"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var main_exports = {};
__export(main_exports, {
  checker: () => checker,
  default: () => main_default
});
module.exports = __toCommonJS(main_exports);
var import_chalk = __toESM(require("chalk"), 1);
var import_child_process = require("child_process");
var import_lodash = __toESM(require("lodash.pick"), 1);
var import_npm_run_path = __toESM(require("npm-run-path"), 1);
var import_path = __toESM(require("path"), 1);
var import_Checker = require("./Checker.js");
var import_client = require("./client/index.js");
var import_types = require("./types.js");
const sharedConfigKeys = ["enableBuild", "overlay"];
const buildInCheckerKeys = [
  "typescript",
  "vueTsc",
  "vls",
  "eslint",
  "stylelint"
];
async function createCheckers(userConfig, env) {
  const serveAndBuildCheckers = [];
  const sharedConfig = (0, import_lodash.default)(userConfig, sharedConfigKeys);
  for (const name of buildInCheckerKeys) {
    if (!userConfig[name])
      continue;
    const { createServeAndBuild } = await import(`./checkers/${name}/main.js`);
    serveAndBuildCheckers.push(
      createServeAndBuild({ [name]: userConfig[name], ...sharedConfig }, env)
    );
  }
  return serveAndBuildCheckers;
}
function checker(userConfig) {
  const enableBuild = (userConfig == null ? void 0 : userConfig.enableBuild) ?? true;
  const enableOverlay = (userConfig == null ? void 0 : userConfig.overlay) !== false;
  const enableTerminal = (userConfig == null ? void 0 : userConfig.terminal) !== false;
  const overlayConfig = typeof (userConfig == null ? void 0 : userConfig.overlay) === "object" ? userConfig == null ? void 0 : userConfig.overlay : {};
  let resolvedRuntimePath = import_client.RUNTIME_PUBLIC_PATH;
  let checkers = [];
  let viteMode;
  let resolvedConfig;
  return {
    name: "vite-plugin-checker",
    __internal__checker: import_Checker.Checker,
    config: async (config, env) => {
      viteMode = env.command;
      checkers = await createCheckers(userConfig || {}, env);
      if (viteMode !== "serve")
        return;
      checkers.forEach((checker2) => {
        const workerConfig = checker2.serve.config;
        workerConfig({
          enableOverlay,
          enableTerminal,
          env
        });
      });
    },
    configResolved(config) {
      resolvedConfig = config;
      resolvedRuntimePath = config.base + import_client.RUNTIME_PUBLIC_PATH.slice(1);
    },
    buildEnd() {
      if (viteMode === "serve") {
        checkers.forEach((checker2) => {
          const { worker } = checker2.serve;
          worker.terminate();
        });
      }
    },
    resolveId(id) {
      if (viteMode === "serve") {
        if (id === import_client.RUNTIME_PUBLIC_PATH) {
          return id;
        }
      }
      return;
    },
    load(id) {
      if (viteMode === "serve") {
        if (id === import_client.RUNTIME_PUBLIC_PATH) {
          return import_client.runtimeCode;
        }
      }
      return;
    },
    transform(code, id, options) {
      if (id === import_client.RUNTIME_PUBLIC_PATH) {
        if (!resolvedConfig)
          return;
        const devBase = resolvedConfig.base;
        const hmrConfig = isObject(resolvedConfig.server.hmr) ? resolvedConfig.server.hmr : {};
        const host = hmrConfig.host || null;
        const protocol = hmrConfig.protocol || null;
        let port = (hmrConfig == null ? void 0 : hmrConfig.clientPort) || (hmrConfig == null ? void 0 : hmrConfig.port) || null;
        if (resolvedConfig.server.middlewareMode) {
          port || (port = 24678);
        }
        let hmrBase = devBase;
        if (hmrConfig == null ? void 0 : hmrConfig.path) {
          hmrBase = import_path.default.posix.join(hmrBase, hmrConfig.path);
        }
        return code.replace(/__HMR_PROTOCOL__/g, JSON.stringify(protocol)).replace(/__HMR_HOSTNAME__/g, JSON.stringify(host)).replace(/__HMR_PORT__/g, JSON.stringify(port)).replace(/__HMR_BASE__/g, JSON.stringify(hmrBase));
      }
      return null;
    },
    transformIndexHtml() {
      if (viteMode === "serve") {
        return [
          {
            tag: "script",
            attrs: { type: "module" },
            children: `import { inject } from "${resolvedRuntimePath}";
inject({
  overlayConfig: ${JSON.stringify(overlayConfig)},
  base: "${resolvedConfig == null ? void 0 : resolvedConfig.base}",
});`
          }
        ];
      }
      return;
    },
    buildStart: () => {
      if (viteMode !== "build" || !enableBuild)
        return;
      const localEnv = import_npm_run_path.default.env({
        env: process.env,
        cwd: process.cwd(),
        execPath: process.execPath
      });
      (async () => {
        const exitCodes = await Promise.all(
          checkers.map((checker2) => spawnChecker(checker2, userConfig, localEnv))
        );
        const exitCode = exitCodes.find((code) => code !== 0) ?? 0;
        if (exitCode !== 0 && !(resolvedConfig == null ? void 0 : resolvedConfig.build.watch)) {
          process.exit(exitCode);
        }
      })();
    },
    configureServer(server) {
      let connectedTimes = 0;
      let latestOverlayErrors = new Array(checkers.length);
      checkers.forEach((checker2, index) => {
        const { worker, configureServer: workerConfigureServer } = checker2.serve;
        workerConfigureServer({ root: server.config.root });
        worker.on("message", (action) => {
          if (action.type === import_types.ACTION_TYPES.overlayError) {
            latestOverlayErrors[index] = action.payload;
            if (action.payload) {
              server.ws.send(action.payload);
            }
          } else if (action.type === import_types.ACTION_TYPES.console) {
            import_Checker.Checker.log(action);
          }
        });
      });
      return () => {
        if (server.ws.on) {
          server.ws.on("connection", () => {
            connectedTimes++;
            if (connectedTimes > 1) {
              server.ws.send({
                type: "custom",
                event: import_client.WS_CHECKER_RECONNECT_EVENT,
                data: latestOverlayErrors.filter(Boolean)
              });
            }
          });
        } else {
          setTimeout(() => {
            console.warn(
              import_chalk.default.yellow(
                "[vite-plugin-checker]: `server.ws.on` is introduced to Vite in 2.6.8, see [PR](https://github.com/vitejs/vite/pull/5273) and [changelog](https://github.com/vitejs/vite/blob/main/packages/vite/CHANGELOG.md#268-2021-10-18). \nvite-plugin-checker relies on `server.ws.on` to bring diagnostics back after a full reload and it' not available for you now due to the old version of Vite. You can upgrade Vite to latest version to eliminate this warning."
              )
            );
          }, 5e3);
        }
        server.middlewares.use((req, res, next) => {
          next();
        });
      };
    }
  };
}
function spawnChecker(checker2, userConfig, localEnv) {
  return new Promise((resolve) => {
    const buildBin = checker2.build.buildBin;
    const finalBin = typeof buildBin === "function" ? buildBin(userConfig) : buildBin;
    const proc = (0, import_child_process.spawn)(...finalBin, {
      cwd: process.cwd(),
      stdio: "inherit",
      env: localEnv,
      shell: true
    });
    proc.on("exit", (code) => {
      if (code !== null && code !== 0) {
        resolve(code);
      } else {
        resolve(0);
      }
    });
  });
}
function isObject(value) {
  return Object.prototype.toString.call(value) === "[object Object]";
}
var main_default = checker;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  checker
});
//# sourceMappingURL=main.js.map