var centrality = require('ngraph.centrality');

module.exports = centralityWrapper;

function centralityWrapper() {
  // TODO: This should not be a function
  return {
    betweennessCentrality: betweennessCentrality,
    degreeCentrality: degreeCentrality
  };
}

function betweennessCentrality(g) {
  var betweenness = centrality.betweenness(g);
  return toVivaGraphCentralityFormat(betweenness);
}

function degreeCentrality(g, kind) {
  var degree = centrality.degree(g, kind);
  return toVivaGraphCentralityFormat(degree);
}

function toVivaGraphCentralityFormat(centrality) {
  return Object.keys(centrality).sort(byValue).map(toKeyValue);

  function byValue(x, y) {
    return centrality[y] - centrality[x];
  }

  function toKeyValue(key) {
    return {
      key: key,
      value: centrality[key]
    };
  }
}
