<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [\_](#_)
-   [objectHighlighted](#objecthighlighted)
-   [viewChanged](#viewchanged)
-   [nodeContextSizeChanged](#nodecontextsizechanged)
-   [matchesFound](#matchesfound)
-   [viewUpdated](#viewupdated)
-   [objectHovered](#objecthovered)
-   [constructor](#constructor)
-   [getStyles](#getstyles)
-   [updateStyles](#updatestyles)
-   [updateDefinitions](#updatedefinitions)
-   [updateData](#updatedata)
-   [setHighlightedNode](#sethighlightednode)
-   [setHighlightedConnection](#sethighlightedconnection)
-   [findNodes](#findnodes)
-   [setView](#setview)
-   [setModes](#setmodes)
-   [zoomOutViewLevel](#zoomoutviewlevel)
-   [getNode](#getnode)
-   [setFilters](#setfilters)

## \_

Copyright 2016 Netflix, Inc.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

## objectHighlighted

The `objectHighlighted` event is fired whenever an object is highlighted.
`object.type` will be either 'node' or 'connection'

**Properties**

-   `object` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The object that has been highlighted, or the highlighted object that has been updated.

## viewChanged

The `viewChanged` event is fired whenever the view changes

**Properties**

-   `view` **[array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)** The currently selected view (e.g. \[] for global, ['us-east-1'] for one node deep, ['us-east-1', 'api'] for two nodes deep)

## nodeContextSizeChanged

The `nodeContextSizeChanged` event is fired whenever the context panel size for node context size changes

**Properties**

-   `dimensions` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The dimensions of the node context panels

## matchesFound

The `matchesFound` event is fired whenever nodes are found via findNodes().

**Properties**

-   `matches` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The matches object { total, visible }

## viewUpdated

The `viewUpdated` event is fired whenever the current displayed graph's view updates.

## objectHovered

The `objectHovered` event is fired whenever on mouseover on a 'node' or 'connection' .
`object.type` will be either 'node' or 'connection'. In case another 'node' or 'connection'
 is already in focus (because of click/highlight event), then this event won't be triggered.

**Properties**

-   `object` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The object that has been hovered,

## constructor

Represents a Vizceral component.

**Parameters**

-   `canvas` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)?** The canvas to render the graph onto; if not provided, will create a canvas accessible by this.renderer.domElement
-   `targetFramerate` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)?** Target frame rate to render at. Will not limit FPS if not provided or set to 0.

## getStyles

Get an array of all possible defined styles

Returns **[array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)** Array of all possible styles

## updateStyles

Update the global styles

**Parameters**

-   `styles`  
-   `An` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** object map of style names to values

## updateDefinitions

Update the global definitions

**Parameters**

-   `definitions`  
-   `An` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** object map of definitions. See the format and defaults in (<https://github.com/Netflix/Vizceral/wiki/Configuration#definitions-for-data-to-display>)

## updateData

Set the new set of traffic data to render. This is expected to be called
with the complete set of traffic data anytime there is an update.

**Parameters**

-   `trafficData`  
-   `data` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The traffic data that matches the format in (<https://github.com/Netflix/Vizceral/wiki/How-to-Use#graph-data-format>)

## setHighlightedNode

Sets the highlighted node.  If the node is undefined, clears any highlighting.

**Parameters**

-   `node` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The node to highlight

## setHighlightedConnection

Sets the highlighted connection.  If the connection is undefined, clears any highlighting.

**Parameters**

-   `connection` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The connection to highlight

## findNodes

Highlight nodes that match searchString.  Searches the node name and the list
of sub nodes, if nodes have one.

**Parameters**

-   `searchString` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The string to match against the nodes.

Returns **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** { total, totalMatches, visible, visibleMatches }

## setView

Set the current view of the component to the passed in array. If the passed
in array does not match an existing node at the passed in depth, the component will try
each level up the array until it finds a match, defaulting to the top level
view.

Ex:
\[] - show the base graph view
['us-east-1'] - show the graph view for 'us-east-1' if it exists
['us-east-1', 'api'] - show the view for the api node in the us-east-1 graph if it exists

**Parameters**

-   `viewArray` **[array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)** the array containing the view to set. (optional, default `[]`)
-   `objectNameToHighlight` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** a node or connection to set as highlighted in the current viewArray

## setModes

Set the current modes of vizceral

**Parameters**

-   `modes`  

## zoomOutViewLevel

If zoomed into a node or a service, zoom out one level up.
If in the global view, this is a noop.

## getNode

Get a specific node object

**Parameters**

-   `viewArray` **[array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)** e.g. [ node1, node2 ]

## setFilters

Set the set of filters to apply along with their current values.

**Parameters**

-   `filters` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** The filters that match the format in (<https://github.com/Netflix/Vizceral/wiki/Configuration#filters>)
