(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("Vizceral", [], factory);
	else if(typeof exports === 'object')
		exports["Vizceral"] = factory();
	else
		root["Vizceral"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	
	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();
	
	var _base = __webpack_require__(1);
	
	Object.keys(_base).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function get() {
	      return _base[key];
	    }
	  });
	});
	
	var _lodash = __webpack_require__(3);
	
	var _lodash2 = _interopRequireDefault(_lodash);
	
	var _events = __webpack_require__(8);
	
	var _events2 = _interopRequireDefault(_events);
	
	var _three = __webpack_require__(5);
	
	var THREE = _interopRequireWildcard(_three);
	
	var _tween = __webpack_require__(22);
	
	var _tween2 = _interopRequireDefault(_tween);
	
	var _hammerjs = __webpack_require__(26);
	
	var _hammerjs2 = _interopRequireDefault(_hammerjs);
	
	var _dnsLayout = __webpack_require__(27);
	
	var _dnsLayout2 = _interopRequireDefault(_dnsLayout);
	
	var _dnsTrafficGraph = __webpack_require__(28);
	
	var _dnsTrafficGraph2 = _interopRequireDefault(_dnsTrafficGraph);
	
	var _focusedChildTrafficGraph = __webpack_require__(33);
	
	var _focusedChildTrafficGraph2 = _interopRequireDefault(_focusedChildTrafficGraph);
	
	var _focusedTrafficGraph = __webpack_require__(34);
	
	var _focusedTrafficGraph2 = _interopRequireDefault(_focusedTrafficGraph);
	
	var _globalDefinitions = __webpack_require__(40);
	
	var _globalDefinitions2 = _interopRequireDefault(_globalDefinitions);
	
	var _globalStyles = __webpack_require__(13);
	
	var _globalStyles2 = _interopRequireDefault(_globalStyles);
	
	var _globalTrafficGraph = __webpack_require__(44);
	
	var _globalTrafficGraph2 = _interopRequireDefault(_globalTrafficGraph);
	
	var _ltrTreeLayout = __webpack_require__(41);
	
	var _ltrTreeLayout2 = _interopRequireDefault(_ltrTreeLayout);
	
	var _regionTrafficGraph = __webpack_require__(49);
	
	var _regionTrafficGraph2 = _interopRequireDefault(_regionTrafficGraph);
	
	var _ringCenterLayout = __webpack_require__(48);
	
	var _ringCenterLayout2 = _interopRequireDefault(_ringCenterLayout);
	
	var _ringLayout = __webpack_require__(51);
	
	var _ringLayout2 = _interopRequireDefault(_ringLayout);
	
	var _rendererUtils = __webpack_require__(10);
	
	var _rendererUtils2 = _interopRequireDefault(_rendererUtils);
	
	var _moveNodeInteraction = __webpack_require__(52);
	
	var _moveNodeInteraction2 = _interopRequireDefault(_moveNodeInteraction);
	
	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *  Copyright 2016 Netflix, Inc.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     Licensed under the Apache License, Version 2.0 (the "License");
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     you may not use this file except in compliance with the License.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     You may obtain a copy of the License at
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         http://www.apache.org/licenses/LICENSE-2.0
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     Unless required by applicable law or agreed to in writing, software
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     distributed under the License is distributed on an "AS IS" BASIS,
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     See the License for the specific language governing permissions and
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *     limitations under the License.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	
	/**
	* The `objectHovered` event is fired whenever on mouseover on a 'node' or 'connection' .
	* `object.type` will be either 'node' or 'connection'. In case another 'node' or 'connection'
	*  is already in focus (because of click/highlight event), then this event won't be triggered.
	*
	* @event objectHovered
	* @property {object} object The object that has been hovered,
	*/
	/**
	* The `objectHighlighted` event is fired whenever an object is highlighted.
	* `object.type` will be either 'node' or 'connection'
	*
	* @event objectHighlighted
	* @property {object} object The object that has been highlighted, or the highlighted object that has been updated.
	*/
	/**
	* The `viewChanged` event is fired whenever the view changes
	*
	* @event viewChanged
	* @property {array} view The currently selected view (e.g. [] for global, ['us-east-1'] for one node deep, ['us-east-1', 'api'] for two nodes deep)
	*/
	/**
	* The `nodeContextSizeChanged` event is fired whenever the context panel size for node context size changes
	*
	* @event nodeContextSizeChanged
	* @property {object} dimensions The dimensions of the node context panels
	*/
	/**
	* The `matchesFound` event is fired whenever nodes are found via findNodes().
	*
	* @event matchesFound
	* @property {object} matches The matches object { total, visible }
	*/
	/**
	* The `viewUpdated` event is fired whenever the current displayed graph's view updates.
	*
	* @event viewUpdated
	*/
	
	// These are a static size and ratio for graph placement.  The element itself can resize.
	var graphWidth = 1800;
	var graphHeight = 1100;
	
	var Console = console;
	
	var Vizceral = function (_EventEmitter) {
	  _inherits(Vizceral, _EventEmitter);
	
	  /**
	   * Represents a Vizceral component.
	   * @constructor
	   * @param {object} [canvas] The canvas to render the graph onto; if not provided, will create a canvas accessible by this.renderer.domElement
	   * @param {Number} [targetFramerate] Target frame rate to render at. Will not limit FPS if not provided or set to 0.
	   */
	  function Vizceral(canvas, targetFramerate) {
	    _classCallCheck(this, Vizceral);
	
	    var _this = _possibleConstructorReturn(this, (Vizceral.__proto__ || Object.getPrototypeOf(Vizceral)).call(this));
	
	    var parameters = { alpha: true, antialias: true };
	    if (canvas) {
	      parameters.canvas = canvas;
	    }
	
	    // Initial three.js setup
	    _this.scene = new THREE.Scene();
	    _this.renderer = new THREE.WebGLRenderer(parameters);
	    _this.renderer.setPixelRatio(window.devicePixelRatio ? window.devicePixelRatio : 1);
	    _this.renderer.autoClear = false;
	    _this.renderer.setClearColor(0x2d2d2d, 1);
	    _this.renderer.domElement.style.width = '100%';
	    _this.renderer.domElement.style.height = '100%';
	    _this.geometry = new THREE.Geometry();
	
	    // Camera
	    _this.camera = new THREE.OrthographicCamera(0, 0, 0, 0, 1, 60000);
	    _this.cameraTarget = new THREE.Vector3(0, 0, 0);
	    _this.camera.position.set(0, 0, 600);
	    _this.camera.lookAt(_this.cameraTarget);
	
	    // Populate renderer utils with the renderer and the camera
	    _rendererUtils2.default.setCamera(_this.camera);
	    _rendererUtils2.default.setRenderer(_this.renderer);
	
	    // Update the size of the renderer and the camera perspective
	    // this.renderer.setSize(width, height);
	    _this.setSize(0, 0);
	
	    // Target FPS
	    _this.targetFrameLength = targetFramerate ? 1000 / targetFramerate : null;
	    _this.lastRenderAt = 0;
	
	    // Setup lighting
	    _this.scene.add(new THREE.AmbientLight(0xffffff));
	
	    // Mouse/Touch interactivity
	    _this.raycaster_mouseLocation_viewportSpace = new THREE.Vector2(-1, -1);
	    _this.raycaster = new THREE.Raycaster();
	    if (window) {
	      window.addEventListener('scroll', function () {
	        return _this.updateBoundingRectCache();
	      });
	    }
	
	    _this.hammertime = new _hammerjs2.default.Manager(_this.renderer.domElement);
	    _this.hammertime.on('press', function (event) {
	      return _this.onDocumentMouseMove(event);
	    }, false);
	    _this.renderer.domElement.addEventListener('mousemove', function (event) {
	      return _this.onDocumentMouseMove(event);
	    }, false);
	    var singleTap = new _hammerjs2.default.Tap({ event: 'singletap' });
	    var doubleTap = new _hammerjs2.default.Tap({ event: 'doubletap', taps: 2 });
	    _this.hammertime.add([doubleTap, singleTap]);
	    doubleTap.recognizeWith(singleTap);
	    singleTap.requireFailure([doubleTap]);
	    _this.hammertime.on('doubletap', function (event) {
	      return _this.onDocumentDoubleClick(event);
	    }, false);
	    _this.hammertime.on('singletap', function (event) {
	      return _this.onDocumentClick(event);
	    }, false);
	
	    _this.graphs = {};
	    _this.options = {
	      showLabels: true,
	      allowDraggingOfNodes: false
	    };
	    _this.filters = {};
	
	    _this.renderers = {
	      global: _globalTrafficGraph2.default,
	      region: _regionTrafficGraph2.default,
	      focused: _focusedTrafficGraph2.default,
	      focusedChild: _focusedChildTrafficGraph2.default,
	      dns: _dnsTrafficGraph2.default
	    };
	    _this.moveNodeInteraction = new _moveNodeInteraction2.default(_this);
	    _this.layouts = {
	      ltrTree: _ltrTreeLayout2.default,
	      dns: _dnsLayout2.default,
	      ringCenter: _ringCenterLayout2.default,
	      ring: _ringLayout2.default
	    };
	    _this.moveNodeInteraction.setEnabled(_this.options.allowDraggingOfNodes);
	    return _this;
	  }
	
	  /**
	   * Get an array of all possible defined styles
	   *
	   * @returns {array}  Array of all possible styles
	   */
	
	
	  _createClass(Vizceral, [{
	    key: 'getStyles',
	    value: function getStyles() {
	      return Object.keys(_globalStyles2.default.styles);
	    }
	
	    /**
	     * Update the global styles
	     *
	     * @param  {Object} An object map of style names to values
	     */
	
	  }, {
	    key: 'updateStyles',
	    value: function updateStyles(styles) {
	      _globalStyles2.default.updateStyles(styles);
	    }
	
	    /**
	     * Update the global definitions
	     *
	     * @param {Object} An object map of definitions. See the format and defaults in (https://github.com/Netflix/Vizceral/wiki/Configuration#definitions-for-data-to-display)
	     */
	
	  }, {
	    key: 'updateDefinitions',
	    value: function updateDefinitions(definitions) {
	      _globalDefinitions2.default.updateDefinitions(definitions);
	    }
	  }, {
	    key: '_attachGraphHandlers',
	    value: function _attachGraphHandlers(graph) {
	      var _this2 = this;
	
	      graph.on('nodeContextSizeChanged', function (dimensions) {
	        return _this2.emit('nodeContextSizeChanged', dimensions);
	      });
	      graph.on('objectHighlighted', function (highlightedObject) {
	        return _this2.emit('objectHighlighted', highlightedObject);
	      });
	      graph.on('setView', function (view) {
	        return _this2.setView(view);
	      });
	      graph.on('viewUpdated', function () {
	        return _this2.emit('viewUpdated');
	      });
	    }
	  }, {
	    key: 'createGraph',
	    value: function createGraph(graphData, mainView, parentGraph, width, height) {
	      var graph = void 0;
	      if (graphData && graphData.renderer) {
	        if (!graphData.name) {
	          Console.log('Attempted to create a new graph that does not have a name');
	        } else if (!this.renderers[graphData.renderer]) {
	          Console.log('Attempted to create a graph type that does not exist: ' + graphData.renderer + ' Presently registered renderers are ' + Object.keys(this.renderers));
	        } else {
	          var parent = parentGraph || this;
	          graph = parent.graphs[graphData.name];
	          if (!graph) {
	            if (graphData.layout && !this.layouts[graphData.layout]) {
	              Console.log('Attempted to create a graph with a layout type that does not exist: ' + graphData.layout + '. Using default layout for graph type.');
	            }
	            graph = new this.renderers[graphData.renderer](graphData.name, mainView, parentGraph, width, height, this.layouts[graphData.layout], graphData.entryNode);
	            this._attachGraphHandlers(graph);
	            graph.setFilters(this.filters);
	            graph.showLabels(this.options.showLabels);
	            parent.graphs[graphData.name] = graph;
	          }
	        }
	      }
	      return graph;
	    }
	  }, {
	    key: 'updateGraph',
	    value: function updateGraph(graph) {
	      if (graph) {
	        var currentGraphData = this.trafficData;
	        var parentGraphData = void 0;
	        graph.graphIndex.every(function (graphLevel) {
	          parentGraphData = currentGraphData;
	          currentGraphData = _lodash2.default.find(currentGraphData.nodes, { name: graphLevel });
	          return currentGraphData;
	        });
	
	        if (currentGraphData) {
	          graph.setState(currentGraphData, false, parentGraphData);
	          graph.validateLayout();
	        }
	      }
	    }
	
	    /**
	     * Set the new set of traffic data to render. This is expected to be called
	     * with the complete set of traffic data anytime there is an update.
	     *
	     * @param {object} data The traffic data that matches the format in (https://github.com/Netflix/Vizceral/wiki/How-to-Use#graph-data-format)
	     */
	
	  }, {
	    key: 'updateData',
	    value: function updateData(trafficData) {
	      if (trafficData && trafficData.nodes) {
	        this.trafficData = trafficData;
	        this.rootGraphName = trafficData.name;
	
	        // Now that the initial data is loaded, check if we can set the initial node
	        if (this.initialView) {
	          this.setView(this.initialView, this.initialObjectToHighlight);
	        }
	
	        this.updateGraph(this.currentGraph);
	      }
	    }
	
	    /**
	     * Sets the highlighted node.  If the node is undefined, clears any highlighting.
	     *
	     * @param {object} node The node to highlight
	     */
	
	  }, {
	    key: 'setHighlightedNode',
	    value: function setHighlightedNode(node) {
	      this.currentGraph.highlightObject(node);
	    }
	
	    /**
	     * Sets the highlighted connection.  If the connection is undefined, clears any highlighting.
	     *
	     * @param {object} connection The connection to highlight
	     */
	
	  }, {
	    key: 'setHighlightedConnection',
	    value: function setHighlightedConnection(connection) {
	      this.currentGraph.highlightObject(connection);
	    }
	
	    /**
	     * Highlight nodes that match searchString.  Searches the node name and the list
	     * of sub nodes, if nodes have one.
	     *
	     * @param {string} searchString The string to match against the nodes.
	     *
	     * @returns {object} { total, totalMatches, visible, visibleMatches }
	     */
	
	  }, {
	    key: 'findNodes',
	    value: function findNodes(searchString) {
	      if (this.currentGraph) {
	        this.disableHoverInteractions = !!searchString;
	        // If !!searchString, clear any highlighted object
	        if (this.disableHoverInteractions && this.currentGraph.highlightedObject) {
	          this.currentGraph.highlightObject();
	        }
	
	        // if !searchString and highlighted object, do nothing
	        if (searchString || !this.currentGraph.highlightedObject) {
	          // Highlight matches
	          var matchesFound = this.currentGraph.highlightMatchedNodes(searchString);
	          matchesFound.total = this.currentGraph.nodeCounts.total;
	          matchesFound.visible = this.currentGraph.nodeCounts.visible;
	
	          this.emit('matchesFound', matchesFound);
	          return matchesFound;
	        }
	      }
	      return undefined;
	    }
	  }, {
	    key: 'calculateIntersectedObject',
	    value: function calculateIntersectedObject(x, y) {
	      this.validateRaycaster(x, y);
	      this.disableHoverInteractions = false;
	      this.calculateMouseOver(true);
	      return this.currentGraph && this.currentGraph.getIntersectedObject();
	    }
	  }, {
	    key: 'onDocumentClick',
	    value: function onDocumentClick(event) {
	      this.calculateIntersectedObject(event.center.x, event.center.y);
	      if (this.currentGraph) {
	        this.currentGraph.handleIntersectedObjectClick();
	      }
	    }
	  }, {
	    key: 'onDocumentDoubleClick',
	    value: function onDocumentDoubleClick(event) {
	      this.calculateIntersectedObject(event.center.x, event.center.y);
	      this.currentGraph.handleIntersectedObjectDoubleClick();
	    }
	  }, {
	    key: 'getNearestValidGraph',
	    value: function getNearestValidGraph(viewArray) {
	      var _this3 = this;
	
	      var newGraph = this.getGraph(this.rootGraphName);
	      if (newGraph) {
	        viewArray.every(function (nodeName) {
	          var nextLevelNode = newGraph.getNode(nodeName);
	          if (nextLevelNode) {
	            var newGraphCandidate = _this3.getGraph(nextLevelNode.name, newGraph);
	            if (newGraphCandidate) {
	              newGraph = newGraphCandidate;
	              return true;
	            }
	            Console.warn('Attempted to select a graph that was not found; ' + viewArray.join());
	          }
	          return false;
	        });
	      }
	      return newGraph;
	    }
	  }, {
	    key: 'checkInitialView',
	    value: function checkInitialView() {
	      var initialView = {
	        view: undefined,
	        highlighted: this.initialObjectToHighlight,
	        redirectedFrom: undefined
	      };
	
	      // If there is an initial node to set and there is not a current selected node
	      if (this.initialView && !this.currentGraph && this.rootGraphName) {
	        // Are there graphs yet?
	        var newGraph = this.getNearestValidGraph(this.initialView);
	        if (newGraph) {
	          initialView.view = newGraph.graphIndex;
	
	          if (initialView.view && this.initialView && !_lodash2.default.isEqual(initialView.view, this.initialView)) {
	            initialView.redirectedFrom = this.initialView;
	          }
	          this.initialView = undefined;
	        }
	      }
	
	      return initialView;
	      // TODO: else, set a timeout for waiting...?
	    }
	  }, {
	    key: 'getGraph',
	    value: function getGraph(graphName, parentGraph) {
	      // If the graph already exists, return it.
	      if (!parentGraph) {
	        if (this.graphs[graphName]) {
	          return this.graphs[graphName];
	        }
	      } else if (parentGraph.graphs[graphName]) {
	        return parentGraph.graphs[graphName];
	      }
	
	      // If parentGraph is root, create a new graph based on this.trafficData
	      var graphData = !parentGraph ? this.trafficData : parentGraph.nodes[graphName];
	      // If the node exists in the graph, create the graph.
	      if (graphData) {
	        // Create the graph and return it
	        var graph = this.createGraph(graphData, this, parentGraph, graphWidth, graphHeight);
	        this.updateGraph(graph);
	        return graph;
	      }
	
	      return undefined;
	    }
	
	    /**
	     * Set the current view of the component to the passed in array. If the passed
	     * in array does not match an existing node at the passed in depth, the component will try
	     * each level up the array until it finds a match, defaulting to the top level
	     * view.
	     *
	     * Ex:
	     * [] - show the base graph view
	     * ['us-east-1'] - show the graph view for 'us-east-1' if it exists
	     * ['us-east-1', 'api'] - show the view for the api node in the us-east-1 graph if it exists
	     *
	     * @param {array} viewArray the array containing the view to set.
	     * @param {string} objectNameToHighlight a node or connection to set as highlighted in the current viewArray
	     */
	
	  }, {
	    key: 'setView',
	    value: function setView() {
	      var viewArray = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
	      var objectNameToHighlight = arguments[1];
	
	      var redirectedFrom = void 0;
	      // If nothing has been selected yet, it's the initial node
	      if (!this.currentGraph) {
	        this.initialView = viewArray;
	        this.initialObjectToHighlight = objectNameToHighlight;
	        var initialView = this.checkInitialView();
	        if (!initialView.view) {
	          return;
	        }
	        viewArray = initialView.view;
	        objectNameToHighlight = initialView.highlighted;
	        redirectedFrom = initialView.redirectedFrom;
	      }
	
	      var newGraph = this.getNearestValidGraph(viewArray);
	
	      // If the view changed, set it.
	      if (!this.currentGraph || !_lodash2.default.isEqual(newGraph.graphIndex, this.currentGraph.graphIndex)) {
	        var difference = this.currentGraph ? newGraph.graphIndex.length - this.currentGraph.graphIndex.length : 0;
	        if (difference === -1) {
	          this.zoomOutOfNode();
	        } else if (difference === 1) {
	          this.zoomIntoNode(newGraph.name);
	        } else {
	          this.selectGraph(newGraph, redirectedFrom);
	        }
	
	        this.calculateMouseOver();
	      }
	
	      // If passed in an object to highlight, try to highlight.
	      if (objectNameToHighlight) {
	        var objectToHighlight = newGraph.getGraphObject(objectNameToHighlight);
	        if (objectToHighlight) {
	          newGraph.highlightObject(objectToHighlight);
	        }
	      } else if (newGraph.highlightedObject) {
	        newGraph.highlightObject();
	      }
	    }
	  }, {
	    key: 'showLabels',
	    value: function showLabels(graph) {
	      var _this4 = this;
	
	      graph.showLabels(this.options.showLabels);
	      _lodash2.default.each(graph.graphs, function (subGraph) {
	        _this4.showLabels(subGraph);
	      });
	    }
	  }, {
	    key: 'updateModes',
	    value: function updateModes(graph) {
	      var _this5 = this;
	
	      graph.setModes(this.modes);
	      _lodash2.default.each(graph.graphs, function (subGraph) {
	        _this5.updateModes(subGraph);
	      });
	    }
	
	    /**
	     * Set the current modes of vizceral
	     */
	
	  }, {
	    key: 'setModes',
	    value: function setModes(modes) {
	      if (!_lodash2.default.isEqual(modes, this.modes)) {
	        this.modes = modes;
	        this.updateModes(this.getGraph(this.rootGraphName));
	      }
	    }
	  }, {
	    key: 'setOptions',
	    value: function setOptions(options) {
	      // Show labels
	      var showLabels = options.showLabels;
	      if (typeof showLabels !== 'boolean') {
	        Console.warn('Vizceral.setOptions: allowDraggingOfNodes must be a boolean but was something else, coercing to boolean. Got the following value: ', allowDraggingOfNodes);
	        showLabels = !!showLabels;
	      }
	      if (showLabels !== this.options.showLabels) {
	        this.options.showLabels = showLabels;
	        this.showLabels(this.getGraph(this.rootGraphName));
	      }
	
	      // Allow repositioning of nodes through dragging
	      var allowDraggingOfNodes = options.allowDraggingOfNodes;
	      if (typeof allowDraggingOfNodes !== 'boolean') {
	        Console.warn('Vizceral.setOptions: allowDraggingOfNodes must be a boolean but was something else, coercing to boolean. Got the following value: ', allowDraggingOfNodes);
	        allowDraggingOfNodes = !!allowDraggingOfNodes;
	      }
	      if (allowDraggingOfNodes !== this.options.allowDraggingOfNodes) {
	        this.options.allowDraggingOfNodes = allowDraggingOfNodes;
	        this.moveNodeInteraction.setEnabled(allowDraggingOfNodes);
	      }
	    }
	
	    /**
	     * If zoomed into a node or a service, zoom out one level up.
	     * If in the global view, this is a noop.
	     */
	
	  }, {
	    key: 'zoomOutViewLevel',
	    value: function zoomOutViewLevel() {
	      if (this.currentGraph) {
	        if (this.currentGraph.highlightedObject) {
	          this.currentGraph.highlightObject(undefined);
	        } else if (this.currentGraph.graphIndex.length > 0) {
	          this.setView(this.currentGraph.graphIndex.slice(0, -1));
	        }
	      }
	    }
	
	    /**
	     * Get a specific node object
	     *
	     * @param {array} viewArray e.g. [ node1, node2 ]
	     */
	
	  }, {
	    key: 'getNode',
	    value: function getNode(viewArray) {
	      var currentGraph = this.getGraph(this.rootGraphName);
	      var node = void 0;
	      _lodash2.default.every(viewArray, function (nodeName, index) {
	        var nextNode = currentGraph.getNode(nodeName);
	        if (nextNode) {
	          if (index === viewArray.length - 1) {
	            node = nextNode;
	            return false;
	          }
	          var nextGraph = currentGraph.graphs[nextNode];
	          if (nextGraph) {
	            currentGraph = nextGraph;
	            return true;
	          }
	        }
	        return false;
	      });
	      return node;
	    }
	
	    /**
	     * Set the set of filters to apply along with their current values.
	     *
	     * @param {object} filters The filters that match the format in (https://github.com/Netflix/Vizceral/wiki/Configuration#filters)
	     */
	
	  }, {
	    key: 'setFilters',
	    value: function setFilters(filters) {
	      this.filters = filters;
	      if (this.currentGraph) {
	        this.currentGraph.setFilters(filters);
	      }
	    }
	  }, {
	    key: 'setRenderers',
	    value: function setRenderers(renderers) {
	      Object.assign(this.renderers, renderers);
	    }
	  }, {
	    key: 'setCurrentGraph',
	    value: function setCurrentGraph(graph, redirectedFrom) {
	      graph.setFilters(this.filters);
	      this.currentGraph = graph;
	      this.updateGraph(this.currentGraph);
	      this.currentGraph.setCurrent(true);
	
	      this.emit('viewChanged', { view: this.currentGraph.graphIndex, graph: this.currentGraph, redirectedFrom: redirectedFrom });
	    }
	
	    // Only necessary when global graph is present
	
	  }, {
	    key: 'zoomBetweenGraphs',
	    value: function zoomBetweenGraphs(fromGraph, toGraph, parametersFrom, parametersTo) {
	      var _this6 = this;
	
	      parametersFrom.fromGraphOpacity = 1;
	      parametersTo.fromGraphOpacity = 0;
	
	      parametersFrom.toGraphOpacity = 0;
	      parametersTo.toGraphOpacity = 1;
	
	      // clear any highlighting on current graph
	      this.setHighlightedNode(undefined);
	
	      // Set the current graph
	      this.setCurrentGraph(toGraph);
	
	      var fromViewObject = fromGraph.view.container;
	      var toViewObject = toGraph.view.container;
	
	      this.scene.add(toViewObject);
	
	      // Pan over and zoom in to the selected node
	      new _tween2.default.Tween(_lodash2.default.clone(parametersFrom)).to(parametersTo, 1000).easing(_tween2.default.Easing.Cubic.Out).onUpdate(function () {
	        // Pan over to the selected node
	        fromViewObject.position.set(this.exitingX, this.exitingY, 0);
	        toViewObject.position.set(this.enteringX, this.enteringY, 0);
	        // Zoom in to the selected entering
	        fromViewObject.scale.set(this.exitingScale, this.exitingScale, 1);
	        toViewObject.scale.set(this.enteringScale, this.enteringScale, 1);
	        // Fade the node node
	        fromGraph.view.setOpacity(this.fromGraphOpacity);
	        if (toGraph.loadedOnce) {
	          toGraph.view.setOpacity(this.toGraphOpacity);
	        }
	      }).onComplete(function () {
	        // Remove the outgoing graph from the scene
	        if (fromViewObject !== undefined) {
	          _this6.scene.remove(fromViewObject);
	        }
	      }).start();
	    }
	  }, {
	    key: 'zoomIntoNode',
	    value: function zoomIntoNode(nodeName) {
	      if (this.currentGraph) {
	        var nodeToZoomInto = this.currentGraph.nodes[nodeName];
	        var toGraph = this.currentGraph.graphs[nodeName];
	        if (nodeToZoomInto && toGraph) {
	          var entryPosition = nodeToZoomInto.position;
	          var parametersFrom = {
	            exitingX: this.currentGraph.view.container.position.x,
	            exitingY: this.currentGraph.view.container.position.y,
	            exitingScale: this.currentGraph.view.container.scale.x,
	            enteringX: entryPosition.x,
	            enteringY: entryPosition.y,
	            enteringScale: 0
	          };
	          var parametersTo = {
	            exitingX: 0 - entryPosition.x * 10,
	            exitingY: 0 - entryPosition.y * 10,
	            enteringX: 0,
	            enteringY: 0,
	            exitingScale: 10,
	            enteringScale: 1
	          };
	          this.zoomBetweenGraphs(this.currentGraph, toGraph, parametersFrom, parametersTo);
	        }
	      }
	    }
	  }, {
	    key: 'zoomOutOfNode',
	    value: function zoomOutOfNode() {
	      if (this.currentGraph && this.currentGraph !== this.getGraph(this.rootGraphName)) {
	        var parentGraph = this.currentGraph.parentGraph;
	        if (parentGraph) {
	          var currentNodeInParent = parentGraph.getNode(this.currentGraph.name);
	
	          var parametersFrom = {
	            enteringX: 0 - currentNodeInParent.position.x * 10,
	            enteringY: 0 - currentNodeInParent.position.y * 10,
	            enteringScale: 10,
	            exitingX: this.currentGraph.view.container.position.x,
	            exitingY: this.currentGraph.view.container.position.y,
	            exitingScale: this.currentGraph.view.container.scale.x
	          };
	          var parametersTo = {
	            enteringX: 0,
	            enteringY: 0,
	            exitingX: currentNodeInParent.position.x,
	            exitingY: currentNodeInParent.position.y,
	            enteringScale: 1,
	            exitingScale: 0
	          };
	          this.zoomBetweenGraphs(this.currentGraph, parentGraph, parametersFrom, parametersTo);
	        }
	      }
	    }
	
	    // Needed for all graphs
	
	  }, {
	    key: 'selectGraph',
	    value: function selectGraph(graph, redirectedFrom) {
	      if (this.currentGraph !== undefined) {
	        this.scene.remove(this.currentGraph.view.container);
	        this.currentGraph.setCurrent(false);
	      }
	      this.scene.add(graph.view.container);
	      this.setCurrentGraph(graph, redirectedFrom);
	    }
	  }, {
	    key: 'validateRaycaster',
	    value: function validateRaycaster(mouseLocVPSpaceX, mouseLocVPSpaceY) {
	      if (this.raycaster_mouseLocation_viewportSpace.x === mouseLocVPSpaceX && this.raycaster_mouseLocation_viewportSpace.y === mouseLocVPSpaceY) {
	        return;
	      }
	      var canvasDomElem = this.renderer.domElement;
	      var canvasBCRect = this.boundingRect;
	      var mouseLocCanvasSpaceX = mouseLocVPSpaceX - canvasBCRect.left;
	      var mouseLocCanvasSpaceY = mouseLocVPSpaceY - canvasBCRect.top;
	      var mouseLocNormScreenSpaceX = mouseLocCanvasSpaceX / canvasDomElem.clientWidth * 2 - 1;
	      var mouseLocNormScreenSpaceY = -(mouseLocCanvasSpaceY / canvasDomElem.clientHeight * 2) + 1;
	      var mouseLocNormScreenSpace = new THREE.Vector2(mouseLocNormScreenSpaceX, mouseLocNormScreenSpaceY);
	      this.raycaster.setFromCamera(mouseLocNormScreenSpace, this.camera);
	      this.raycaster_mouseLocation_viewportSpace.x = mouseLocVPSpaceX;
	      this.raycaster_mouseLocation_viewportSpace.y = mouseLocVPSpaceY;
	    }
	  }, {
	    key: 'calculateMouseOver',
	    value: function calculateMouseOver(immediate) {
	      var _this7 = this;
	
	      if (this.currentGraph) {
	        this.raycaster.linePrecision = this.currentGraph.linePrecision || 1;
	        var intersects = this.raycaster.intersectObjects(this.currentGraph.view.getInteractiveChildren());
	        var userData = {};
	        if (intersects.length > 0) {
	          if (intersects[0].object.userData.object) {
	            userData = intersects[0].object.userData;
	            userData = userData.object && userData.object.loaded && (userData.object.isInteractive() || this.options.allowDraggingOfNodes && userData.object.isDraggable()) ? userData : {};
	          } else {
	            Console.warn('Mouse cursor intersected with a visible object that does not have an associated object model. The object should be set at userData.object');
	          }
	        }
	        if (userData.object && userData.object.isClickable()) {
	          this.renderer.domElement.style.cursor = 'pointer';
	        } else {
	          this.renderer.domElement.style.cursor = 'auto';
	        }
	
	        // Changed hovered object
	        if (this.objectToSwitch !== userData.object) {
	          this.objectToSwitch = userData.object;
	          if (this.currentGraph.intersectedObject) {
	            // If an object was previously moused over, clear the context
	            this.currentGraph.setContext(undefined);
	          }
	
	          // if waiting for a hover effect on something else, clear it before moving on
	          if (this.mouseOverTimer) {
	            clearTimeout(this.mouseOverTimer);
	          }
	
	          if (!immediate && userData.object && !(this.currentGraph && this.currentGraph.highlightedObject)) {
	            // if switching to an object and nothing is highlighted, set a timeout to perform the hover effect
	            this.mouseOverTimer = setTimeout(function () {
	              _this7.currentGraph.setIntersectedObject(_this7.objectToSwitch);
	            }, 100);
	          } else {
	            // if removing a hover effect, or there is a highlighted object, do it immediately
	            this.currentGraph.setIntersectedObject(userData.object);
	          }
	        }
	
	        if (this.currentGraph && this.currentGraph.context !== userData.context) {
	          this.currentGraph.setContext(userData.context);
	        }
	      }
	    }
	  }, {
	    key: 'onDocumentMouseMove',
	    value: function onDocumentMouseMove(event) {
	      event.preventDefault();
	      if (!this.disableHoverInteractions) {
	        this.validateRaycaster(event.clientX, event.clientY);
	        this.calculateMouseOver();
	      }
	    }
	  }, {
	    key: 'requestAnimationFrame',
	    value: function (_requestAnimationFrame) {
	      function requestAnimationFrame() {
	        return _requestAnimationFrame.apply(this, arguments);
	      }
	
	      requestAnimationFrame.toString = function () {
	        return _requestAnimationFrame.toString();
	      };
	
	      return requestAnimationFrame;
	    }(function () {
	      requestAnimationFrame(this.animate.bind(this));
	    })
	  }, {
	    key: 'animate',
	    value: function animate(time) {
	      if (this.targetFrameLength === null) {
	        this.requestAnimationFrame();
	      } else {
	        // Call requestAnimationFrame to be as close to the target frame rate as we can
	        // performance.now allows sub-millisecond timing for maximum smoothness
	        var now = performance.now();
	        var nextRenderAt = Math.max(now, this.lastRenderAt + this.targetFrameLength);
	        var nextRenderIn = nextRenderAt - now;
	        setTimeout(this.requestAnimationFrame.bind(this), nextRenderIn);
	        this.lastRenderAt = nextRenderAt;
	      }
	      this.render(time);
	    }
	  }, {
	    key: 'render',
	    value: function render(time) {
	      _tween2.default.update();
	
	      // Check size
	      if (this.renderer.domElement.offsetWidth !== 0 && this.width !== this.renderer.domElement.offsetWidth || this.renderer.domElement.offsetHeight !== 0 && this.height !== this.renderer.domElement.offsetHeight) {
	        this.setSize(this.renderer.domElement.offsetWidth, this.renderer.domElement.offsetHeight);
	      }
	
	      this.camera.lookAt(this.cameraTarget);
	      if (this.currentGraph) {
	        this.currentGraph.update(time);
	      }
	      this.renderer.render(this.scene, this.camera);
	    }
	  }, {
	    key: 'updateBoundingRectCache',
	    value: function updateBoundingRectCache() {
	      this.boundingRect = this.renderer.domElement.getBoundingClientRect();
	    }
	  }, {
	    key: 'setSize',
	    value: function setSize(w, h) {
	      this.width = w;
	      this.height = h;
	      this.renderer.setSize(w, h, false);
	
	      // Update aspect ratio
	      var viewAspectRatio = w / h;
	      var graphAspectRatio = graphWidth / graphHeight;
	      var scale = void 0;
	      if (viewAspectRatio > graphAspectRatio) {
	        // if the aspect is wider than the graph aspect
	        scale = h / graphHeight;
	        w = graphWidth * (viewAspectRatio / graphAspectRatio);
	        h = graphHeight;
	      } else {
	        // if the aspect is taller than the graph aspect
	        scale = w / graphWidth;
	        h = graphHeight / (viewAspectRatio / graphAspectRatio);
	        w = graphWidth;
	      }
	
	      _rendererUtils2.default.setScale(scale);
	
	      this.camera.left = w / -2;
	      this.camera.right = w / 2;
	      this.camera.top = h / 2;
	      this.camera.bottom = h / -2;
	
	      this.camera.updateProjectionMatrix();
	
	      this.updateBoundingRectCache();
	    }
	  }]);
	
	  return Vizceral;
	}(_events2.default);
	
	exports.default = Vizceral;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	
	var _baseView = __webpack_require__(2);
	
	Object.defineProperty(exports, 'BaseView', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_baseView).default;
	  }
	});
	
	var _connection = __webpack_require__(6);
	
	Object.defineProperty(exports, 'Connection', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_connection).default;
	  }
	});
	
	var _connectionView = __webpack_require__(11);
	
	Object.defineProperty(exports, 'ConnectionView', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_connectionView).default;
	  }
	});
	
	var _connectionNoticeView = __webpack_require__(12);
	
	Object.defineProperty(exports, 'ConnectionNoticeView', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_connectionNoticeView).default;
	  }
	});
	
	var _constants = __webpack_require__(15);
	
	Object.defineProperty(exports, 'Constants', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_constants).default;
	  }
	});
	
	var _graphObject = __webpack_require__(7);
	
	Object.defineProperty(exports, 'GraphObject', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_graphObject).default;
	  }
	});
	
	var _node = __webpack_require__(17);
	
	Object.defineProperty(exports, 'Node', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_node).default;
	  }
	});
	
	var _nodeNameView = __webpack_require__(18);
	
	Object.defineProperty(exports, 'NodeNameView', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_nodeNameView).default;
	  }
	});
	
	var _nodeView = __webpack_require__(19);
	
	Object.defineProperty(exports, 'NodeView', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_nodeView).default;
	  }
	});
	
	var _nodeViewStandard = __webpack_require__(20);
	
	Object.defineProperty(exports, 'NodeViewStandard', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_nodeViewStandard).default;
	  }
	});
	
	var _trafficGraph = __webpack_require__(21);
	
	Object.defineProperty(exports, 'TrafficGraph', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_trafficGraph).default;
	  }
	});
	
	var _trafficGraphView = __webpack_require__(25);
	
	Object.defineProperty(exports, 'TrafficGraphView', {
	  enumerable: true,
	  get: function get() {
	    return _interopRequireDefault(_trafficGraphView).default;
	  }
	});

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	
	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *  Copyright 2016 Netflix, Inc.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     Licensed under the Apache License, Version 2.0 (the "License");
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     you may not use this file except in compliance with the License.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     You may obtain a copy of the License at
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *         http://www.apache.org/licenses/LICENSE-2.0
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     Unless required by applicable law or agreed to in writing, software
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     distributed under the License is distributed on an "AS IS" BASIS,
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     See the License for the specific language governing permissions and
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *     limitations under the License.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
	
	
	var _lodash = __webpack_require__(3);
	
	var _lodash2 = _interopRequireDefault(_lodash);
	
	var _three = __webpack_require__(5);
	
	var THREE = _interopRequireWildcard(_three);
	
	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	var BaseView = function () {
	  function BaseView(object) {
	    _classCallCheck(this, BaseView);
	
	    this.container = new THREE.Object3D();
	    this.container.userData.object = this.object;
	    this.object = object;
	    this.interactiveChildren = [];
	    this.dimmedLevel = 0.2;
	    this.opacity = 1.0;
	    this.dimmed = false;
	
	    this.meshes = {};
	  }
	
	  _createClass(BaseView, [{
	    key: 'addInteractiveChild',
	    value: function addInteractiveChild(child, context) {
	      if (!_lodash2.default.find(this.interactiveChildren, { id: child.id })) {
	        child.userData.object = this.object;
	        child.userData.context = context;
	        this.interactiveChildren.push(child);
	      }
	    }
	  }, {
	    key: 'addInteractiveChildren',
	    value: function addInteractiveChildren(children) {
	      var _this = this;
	
	      _lodash2.default.each(children, function (child) {
	        return _this.addInteractiveChild(child);
	      });
	    }
	  }, {
	    key: 'removeInteractiveChildren',
	    value: function removeInteractiveChildren(children) {
	      var childrenIds = children.map(function (c) {
	        return c.id;
	      });
	      _lodash2.default.remove(this.interactiveChildren, function (c) {
	        return childrenIds.includes(c.id);
	      });
	    }
	  }, {
	    key: 'getInteractiveChildren',
	    value: function getInteractiveChildren() {
	      return this.interactiveChildren;
	    }
	  }, {
	    key: 'invalidateInteractiveChildren',
	    value: function invalidateInteractiveChildren() {
	      this.interactiveChildren = undefined;
	    }
	  }, {
	    key: 'createCanvas',
	    value: function createCanvas(width, height) {
	      var canvas = document.createElement('canvas');
	      var context = canvas.getContext('2d');
	
	      this.resizeCanvas(canvas, width, height);
	      context.textAlign = 'center';
	      context.textBaseline = 'middle';
	
	      return canvas;
	    }
	  }, {
	    key: 'resizeCanvas',
	    value: function resizeCanvas(canvas, width, height) {
	      var context = canvas.getContext('2d');
	
	      // Store the context information we care about
	      var font = context.font;
	      var textAlign = context.textAlign;
	      var textBaseline = context.textBaseline;
	
	      var ratio = 1;
	
	      canvas.width = width * ratio;
	      canvas.height = height * ratio;
	
	      canvas.style.width = width + ' px';
	      canvas.style.height = height + ' px';
	
	      // When a canvas is resized, it loses context, so reset it here
	      context.font = font;
	      context.textAlign = textAlign;
	      context.textBaseline = textBaseline;
	
	      context.scale(ratio, ratio);
	    }
	  }, {
	    key: 'setOpacity',
	    value: function setOpacity(opacity) {
	      this.opacity = opacity;
	    }
	  }, {
	    key: 'setDimPercent',
	    value: function setDimPercent(percent) {
	      this.setOpacity(1 - percent * (1 - this.dimmedLevel));
	    }
	  }, {
	    key: 'refreshFocused',
	    value: function refreshFocused() {}
	  }, {
	    key: 'setDimmed',
	    value: function setDimmed(dimmed, dimmingApplied) {
	      var changed = false;
	      var focused = !dimmed && dimmingApplied;
	      if (focused !== this.focused) {
	        this.focused = focused;
	        this.refreshFocused();
	      }
	
	      changed = dimmed !== this.dimmed;
	      this.dimmed = dimmed;
	      this.updatePosition(true);
	      return changed;
	    }
	  }, {
	    key: 'addChildElement',
	    value: function addChildElement(geometry, material, context) {
	      var mesh = new THREE.Mesh(geometry, material);
	      this.container.add(mesh);
	      this.addInteractiveChild(mesh, context);
	      return mesh;
	    }
	  }]);
	
	  return BaseView;
	}();
	
	exports.default = BaseView;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(global, module) {/**
	 * @license
	 * Lodash <https://lodash.com/>
	 * Copyright JS Foundation and other contributors <https://js.foundation/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */
	;(function() {
	
	  /** Used as a safe reference for `undefined` in pre-ES5 environments. */
	  var undefined;
	
	  /** Used as the semantic version number. */
	  var VERSION = '4.17.4';
	
	  /** Used as the size to enable large array optimizations. */
	  var LARGE_ARRAY_SIZE = 200;
	
	  /** Error message constants. */
	  var CORE_ERROR_TEXT = 'Unsupported core-js use. Try https://npms.io/search?q=ponyfill.',
	      FUNC_ERROR_TEXT = 'Expected a function';
	
	  /** Used to stand-in for `undefined` hash values. */
	  var HASH_UNDEFINED = '__lodash_hash_undefined__';
	
	  /** Used as the maximum memoize cache size. */
	  var MAX_MEMOIZE_SIZE = 500;
	
	  /** Used as the internal argument placeholder. */
	  var PLACEHOLDER = '__lodash_placeholder__';
	
	  /** Used to compose bitmasks for cloning. */
	  var CLONE_DEEP_FLAG = 1,
	      CLONE_FLAT_FLAG = 2,
	      CLONE_SYMBOLS_FLAG = 4;
	
	  /** Used to compose bitmasks for value comparisons. */
	  var COMPARE_PARTIAL_FLAG = 1,
	      COMPARE_UNORDERED_FLAG = 2;
	
	  /** Used to compose bitmasks for function metadata. */
	  var WRAP_BIND_FLAG = 1,
	      WRAP_BIND_KEY_FLAG = 2,
	      WRAP_CURRY_BOUND_FLAG = 4,
	      WRAP_CURRY_FLAG = 8,
	      WRAP_CURRY_RIGHT_FLAG = 16,
	      WRAP_PARTIAL_FLAG = 32,
	      WRAP_PARTIAL_RIGHT_FLAG = 64,
	      WRAP_ARY_FLAG = 128,
	      WRAP_REARG_FLAG = 256,
	      WRAP_FLIP_FLAG = 512;
	
	  /** Used as default options for `_.truncate`. */
	  var DEFAULT_TRUNC_LENGTH = 30,
	      DEFAULT_TRUNC_OMISSION = '...';
	
	  /** Used to detect hot functions by number of calls within a span of milliseconds. */
	  var HOT_COUNT = 800,
	      HOT_SPAN = 16;
	
	  /** Used to indicate the type of lazy iteratees. */
	  var LAZY_FILTER_FLAG = 1,
	      LAZY_MAP_FLAG = 2,
	      LAZY_WHILE_FLAG = 3;
	
	  /** Used as references for various `Number` constants. */
	  var INFINITY = 1 / 0,
	      MAX_SAFE_INTEGER = 9007199254740991,
	      MAX_INTEGER = 1.7976931348623157e+308,
	      NAN = 0 / 0;
	
	  /** Used as references for the maximum length and index of an array. */
	  var MAX_ARRAY_LENGTH = 4294967295,
	      MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1,
	      HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;
	
	  /** Used to associate wrap methods with their bit flags. */
	  var wrapFlags = [
	    ['ary', WRAP_ARY_FLAG],
	    ['bind', WRAP_BIND_FLAG],
	    ['bindKey', WRAP_BIND_KEY_FLAG],
	    ['curry', WRAP_CURRY_FLAG],
	    ['curryRight', WRAP_CURRY_RIGHT_FLAG],
	    ['flip', WRAP_FLIP_FLAG],
	    ['partial', WRAP_PARTIAL_FLAG],
	    ['partialRight', WRAP_PARTIAL_RIGHT_FLAG],
	    ['rearg', WRAP_REARG_FLAG]
	  ];
	
	  /** `Object#toString` result references. */
	  var argsTag = '[object Arguments]',
	      arrayTag = '[object Array]',
	      asyncTag = '[object AsyncFunction]',
	      boolTag = '[object Boolean]',
	      dateTag = '[object Date]',
	      domExcTag = '[object DOMException]',
	      errorTag = '[object Error]',
	      funcTag = '[object Function]',
	      genTag = '[object GeneratorFunction]',
	      mapTag = '[object Map]',
	      numberTag = '[object Number]',
	      nullTag = '[object Null]',
	      objectTag = '[object Object]',
	      promiseTag = '[object Promise]',
	      proxyTag = '[object Proxy]',
	      regexpTag = '[object RegExp]',
	      setTag = '[object Set]',
	      stringTag = '[object String]',
	      symbolTag = '[object Symbol]',
	      undefinedTag = '[object Undefined]',
	      weakMapTag = '[object WeakMap]',
	      weakSetTag = '[object WeakSet]';
	
	  var arrayBufferTag = '[object ArrayBuffer]',
	      dataViewTag = '[object DataView]',
	      float32Tag = '[object Float32Array]',
	      float64Tag = '[object Float64Array]',
	      int8Tag = '[object Int8Array]',
	      int16Tag = '[object Int16Array]',
	      int32Tag = '[object Int32Array]',
	      uint8Tag = '[object Uint8Array]',
	      uint8ClampedTag = '[object Uint8ClampedArray]',
	      uint16Tag = '[object Uint16Array]',
	      uint32Tag = '[object Uint32Array]';
	
	  /** Used to match empty string literals in compiled template source. */
	  var reEmptyStringLeading = /\b__p \+= '';/g,
	      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
	      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
	
	  /** Used to match HTML entities and HTML characters. */
	  var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g,
	      reUnescapedHtml = /[&<>"']/g,
	      reHasEscapedHtml = RegExp(reEscapedHtml.source),
	      reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
	
	  /** Used to match template delimiters. */
	  var reEscape = /<%-([\s\S]+?)%>/g,
	      reEvaluate = /<%([\s\S]+?)%>/g,
	      reInterpolate = /<%=([\s\S]+?)%>/g;
	
	  /** Used to match property names within property paths. */
	  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
	      reIsPlainProp = /^\w*$/,
	      reLeadingDot = /^\./,
	      rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
	
	  /**
	   * Used to match `RegExp`
	   * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
	   */
	  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g,
	      reHasRegExpChar = RegExp(reRegExpChar.source);
	
	  /** Used to match leading and trailing whitespace. */
	  var reTrim = /^\s+|\s+$/g,
	      reTrimStart = /^\s+/,
	      reTrimEnd = /\s+$/;
	
	  /** Used to match wrap detail comments. */
	  var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
	      reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/,
	      reSplitDetails = /,? & /;
	
	  /** Used to match words composed of alphanumeric characters. */
	  var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
	
	  /** Used to match backslashes in property paths. */
	  var reEscapeChar = /\\(\\)?/g;
	
	  /**
	   * Used to match
	   * [ES template delimiters](http://ecma-international.org/ecma-262/7.0/#sec-template-literal-lexical-components).
	   */
	  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
	
	  /** Used to match `RegExp` flags from their coerced string values. */
	  var reFlags = /\w*$/;
	
	  /** Used to detect bad signed hexadecimal string values. */
	  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
	
	  /** Used to detect binary string values. */
	  var reIsBinary = /^0b[01]+$/i;
	
	  /** Used to detect host constructors (Safari). */
	  var reIsHostCtor = /^\[object .+?Constructor\]$/;
	
	  /** Used to detect octal string values. */
	  var reIsOctal = /^0o[0-7]+$/i;
	
	  /** Used to detect unsigned integer values. */
	  var reIsUint = /^(?:0|[1-9]\d*)$/;
	
	  /** Used to match Latin Unicode letters (excluding mathematical operators). */
	  var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
	
	  /** Used to ensure capturing order of template delimiters. */
	  var reNoMatch = /($^)/;
	
	  /** Used to match unescaped characters in compiled string literals. */
	  var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
	
	  /** Used to compose unicode character classes. */
	  var rsAstralRange = '\\ud800-\\udfff',
	      rsComboMarksRange = '\\u0300-\\u036f',
	      reComboHalfMarksRange = '\\ufe20-\\ufe2f',
	      rsComboSymbolsRange = '\\u20d0-\\u20ff',
	      rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
	      rsDingbatRange = '\\u2700-\\u27bf',
	      rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
	      rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
	      rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
	      rsPunctuationRange = '\\u2000-\\u206f',
	      rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
	      rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
	      rsVarRange = '\\ufe0e\\ufe0f',
	      rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
	
	  /** Used to compose unicode capture groups. */
	  var rsApos = "['\u2019]",
	      rsAstral = '[' + rsAstralRange + ']',
	      rsBreak = '[' + rsBreakRange + ']',
	      rsCombo = '[' + rsComboRange + ']',
	      rsDigits = '\\d+',
	      rsDingbat = '[' + rsDingbatRange + ']',
	      rsLower = '[' + rsLowerRange + ']',
	      rsMisc = '[^' + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
	      rsFitz = '\\ud83c[\\udffb-\\udfff]',
	      rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
	      rsNonAstral = '[^' + rsAstralRange + ']',
	      rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
	      rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
	      rsUpper = '[' + rsUpperRange + ']',
	      rsZWJ = '\\u200d';
	
	  /** Used to compose unicode regexes. */
	  var rsMiscLower = '(?:' + rsLower + '|' + rsMisc + ')',
	      rsMiscUpper = '(?:' + rsUpper + '|' + rsMisc + ')',
	      rsOptContrLower = '(?:' + rsApos + '(?:d|ll|m|re|s|t|ve))?',
	      rsOptContrUpper = '(?:' + rsApos + '(?:D|LL|M|RE|S|T|VE))?',
	      reOptMod = rsModifier + '?',
	      rsOptVar = '[' + rsVarRange + ']?',
	      rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
	      rsOrdLower = '\\d*(?:(?:1st|2nd|3rd|(?![123])\\dth)\\b)',
	      rsOrdUpper = '\\d*(?:(?:1ST|2ND|3RD|(?![123])\\dTH)\\b)',
	      rsSeq = rsOptVar + reOptMod + rsOptJoin,
	      rsEmoji = '(?:' + [rsDingbat, rsRegional, rsSurrPair].join('|') + ')' + rsSeq,
	      rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';
	
	  /** Used to match apostrophes. */
	  var reApos = RegExp(rsApos, 'g');
	
	  /**
	   * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
	   * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
	   */
	  var reComboMark = RegExp(rsCombo, 'g');
	
	  /** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
	  var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');
	
	  /** Used to match complex or compound words. */
	  var reUnicodeWord = RegExp([
	    rsUpper + '?' + rsLower + '+' + rsOptContrLower + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
	    rsMiscUpper + '+' + rsOptContrUpper + '(?=' + [rsBreak, rsUpper + rsMiscLower, '$'].join('|') + ')',
	    rsUpper + '?' + rsMiscLower + '+' + rsOptContrLower,
	    rsUpper + '+' + rsOptContrUpper,
	    rsOrdUpper,
	    rsOrdLower,
	    rsDigits,
	    rsEmoji
	  ].join('|'), 'g');
	
	  /** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
	  var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');
	
	  /** Used to detect strings that need a more robust regexp to match words. */
	  var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
	
	  /** Used to assign default `context` object properties. */
	  var contextProps = [
	    'Array', 'Buffer', 'DataView', 'Date', 'Error', 'Float32Array', 'Float64Array',
	    'Function', 'Int8Array', 'Int16Array', 'Int32Array', 'Map', 'Math', 'Object',
	    'Promise', 'RegExp', 'Set', 'String', 'Symbol', 'TypeError', 'Uint8Array',
	    'Uint8ClampedArray', 'Uint16Array', 'Uint32Array', 'WeakMap',
	    '_', 'clearTimeout', 'isFinite', 'parseInt', 'setTimeout'
	  ];
	
	  /** Used to make template sourceURLs easier to identify. */
	  var templateCounter = -1;
	
	  /** Used to identify `toStringTag` values of typed arrays. */
	  var typedArrayTags = {};
	  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
	  typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
	  typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
	  typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
	  typedArrayTags[uint32Tag] = true;
	  typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
	  typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
	  typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
	  typedArrayTags[errorTag] = typedArrayTags[funcTag] =
	  typedArrayTags[mapTag] = typedArrayTags[numberTag] =
	  typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
	  typedArrayTags[setTag] = typedArrayTags[stringTag] =
	  typedArrayTags[weakMapTag] = false;
	
	  /** Used to identify `toStringTag` values supported by `_.clone`. */
	  var cloneableTags = {};
	  cloneableTags[argsTag] = cloneableTags[arrayTag] =
	  cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
	  cloneableTags[boolTag] = cloneableTags[dateTag] =
	  cloneableTags[float32Tag] = cloneableTags[float64Tag] =
	  cloneableTags[int8Tag] = cloneableTags[int16Tag] =
	  cloneableTags[int32Tag] = cloneableTags[mapTag] =
	  cloneableTags[numberTag] = cloneableTags[objectTag] =
	  cloneableTags[regexpTag] = cloneableTags[setTag] =
	  cloneableTags[stringTag] = cloneableTags[symbolTag] =
	  cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
	  cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
	  cloneableTags[errorTag] = cloneableTags[funcTag] =
	  cloneableTags[weakMapTag] = false;
	
	  /** Used to map Latin Unicode letters to basic Latin letters. */
	  var deburredLetters = {
	    // Latin-1 Supplement block.
	    '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
	    '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
	    '\xc7': 'C',  '\xe7': 'c',
	    '\xd0': 'D',  '\xf0': 'd',
	    '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
	    '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
	    '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
	    '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
	    '\xd1': 'N',  '\xf1': 'n',
	    '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
	    '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
	    '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
	    '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
	    '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
	    '\xc6': 'Ae', '\xe6': 'ae',
	    '\xde': 'Th', '\xfe': 'th',
	    '\xdf': 'ss',
	    // Latin Extended-A block.
	    '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
	    '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
	    '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
	    '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
	    '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
	    '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
	    '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
	    '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
	    '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
	    '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
	    '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
	    '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
	    '\u0134': 'J',  '\u0135': 'j',
	    '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
	    '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
	    '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
	    '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
	    '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
	    '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
	    '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
	    '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
	    '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
	    '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
	    '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
	    '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
	    '\u0163': 't',  '\u0165': 't', '\u0167': 't',
	    '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
	    '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
	    '\u0174': 'W',  '\u0175': 'w',
	    '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
	    '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
	    '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
	    '\u0132': 'IJ', '\u0133': 'ij',
	    '\u0152': 'Oe', '\u0153': 'oe',
	    '\u0149': "'n", '\u017f': 's'
	  };
	
	  /** Used to map characters to HTML entities. */
	  var htmlEscapes = {
	    '&': '&amp;',
	    '<': '&lt;',
	    '>': '&gt;',
	    '"': '&quot;',
	    "'": '&#39;'
	  };
	
	  /** Used to map HTML entities to characters. */
	  var htmlUnescapes = {
	    '&amp;': '&',
	    '&lt;': '<',
	    '&gt;': '>',
	    '&quot;': '"',
	    '&#39;': "'"
	  };
	
	  /** Used to escape characters for inclusion in compiled string literals. */
	  var stringEscapes = {
	    '\\': '\\',
	    "'": "'",
	    '\n': 'n',
	    '\r': 'r',
	    '\u2028': 'u2028',
	    '\u2029': 'u2029'
	  };
	
	  /** Built-in method references without a dependency on `root`. */
	  var freeParseFloat = parseFloat,
	      freeParseInt = parseInt;
	
	  /** Detect free variable `global` from Node.js. */
	  var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;
	
	  /** Detect free variable `self`. */
	  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;
	
	  /** Used as a reference to the global object. */
	  var root = freeGlobal || freeSelf || Function('return this')();
	
	  /** Detect free variable `exports`. */
	  var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;
	
	  /** Detect free variable `module`. */
	  var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;
	
	  /** Detect the popular CommonJS extension `module.exports`. */
	  var moduleExports = freeModule && freeModule.exports === freeExports;
	
	  /** Detect free variable `process` from Node.js. */
	  var freeProcess = moduleExports && freeGlobal.process;
	
	  /** Used to access faster Node.js helpers. */
	  var nodeUtil = (function() {
	    try {
	      return freeProcess && freeProcess.binding && freeProcess.binding('util');
	    } catch (e) {}
	  }());
	
	  /* Node.js helper references. */
	  var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer,
	      nodeIsDate = nodeUtil && nodeUtil.isDate,
	      nodeIsMap = nodeUtil && nodeUtil.isMap,
	      nodeIsRegExp = nodeUtil && nodeUtil.isRegExp,
	      nodeIsSet = nodeUtil && nodeUtil.isSet,
	      nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
	
	  /*--------------------------------------------------------------------------*/
	
	  /**
	   * Adds the key-value `pair` to `map`.
	   *
	   * @private
	   * @param {Object} map The map to modify.
	   * @param {Array} pair The key-value pair to add.
	   * @returns {Object} Returns `map`.
	   */
	  function addMapEntry(map, pair) {
	    // Don't return `map.set` because it's not chainable in IE 11.
	    map.set(pair[0], pair[1]);
	    return map;
	  }
	
	  /**
	   * Adds `value` to `set`.
	   *
	   * @private
	   * @param {Object} set The set to modify.
	   * @param {*} value The value to add.
	   * @returns {Object} Returns `set`.
	   */
	  function addSetEntry(set, value) {
	    // Don't return `set.add` because it's not chainable in IE 11.
	    set.add(value);
	    return set;
	  }
	
	  /**
	   * A faster alternative to `Function#apply`, this function invokes `func`
	   * with the `this` binding of `thisArg` and the arguments of `args`.
	   *
	   * @private
	   * @param {Function} func The function to invoke.
	   * @param {*} thisArg The `this` binding of `func`.
	   * @param {Array} args The arguments to invoke `func` with.
	   * @returns {*} Returns the result of `func`.
	   */
	  function apply(func, thisArg, args) {
	    switch (args.length) {
	      case 0: return func.call(thisArg);
	      case 1: return func.call(thisArg, args[0]);
	      case 2: return func.call(thisArg, args[0], args[1]);
	      case 3: return func.call(thisArg, args[0], args[1], args[2]);
	    }
	    return func.apply(thisArg, args);
	  }
	
	  /**
	   * A specialized version of `baseAggregator` for arrays.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} setter The function to set `accumulator` values.
	   * @param {Function} iteratee The iteratee to transform keys.
	   * @param {Object} accumulator The initial aggregated object.
	   * @returns {Function} Returns `accumulator`.
	   */
	  function arrayAggregator(array, setter, iteratee, accumulator) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	
	    while (++index < length) {
	      var value = array[index];
	      setter(accumulator, value, iteratee(value), array);
	    }
	    return accumulator;
	  }
	
	  /**
	   * A specialized version of `_.forEach` for arrays without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @returns {Array} Returns `array`.
	   */
	  function arrayEach(array, iteratee) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	
	    while (++index < length) {
	      if (iteratee(array[index], index, array) === false) {
	        break;
	      }
	    }
	    return array;
	  }
	
	  /**
	   * A specialized version of `_.forEachRight` for arrays without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @returns {Array} Returns `array`.
	   */
	  function arrayEachRight(array, iteratee) {
	    var length = array == null ? 0 : array.length;
	
	    while (length--) {
	      if (iteratee(array[length], length, array) === false) {
	        break;
	      }
	    }
	    return array;
	  }
	
	  /**
	   * A specialized version of `_.every` for arrays without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} predicate The function invoked per iteration.
	   * @returns {boolean} Returns `true` if all elements pass the predicate check,
	   *  else `false`.
	   */
	  function arrayEvery(array, predicate) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	
	    while (++index < length) {
	      if (!predicate(array[index], index, array)) {
	        return false;
	      }
	    }
	    return true;
	  }
	
	  /**
	   * A specialized version of `_.filter` for arrays without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} predicate The function invoked per iteration.
	   * @returns {Array} Returns the new filtered array.
	   */
	  function arrayFilter(array, predicate) {
	    var index = -1,
	        length = array == null ? 0 : array.length,
	        resIndex = 0,
	        result = [];
	
	    while (++index < length) {
	      var value = array[index];
	      if (predicate(value, index, array)) {
	        result[resIndex++] = value;
	      }
	    }
	    return result;
	  }
	
	  /**
	   * A specialized version of `_.includes` for arrays without support for
	   * specifying an index to search from.
	   *
	   * @private
	   * @param {Array} [array] The array to inspect.
	   * @param {*} target The value to search for.
	   * @returns {boolean} Returns `true` if `target` is found, else `false`.
	   */
	  function arrayIncludes(array, value) {
	    var length = array == null ? 0 : array.length;
	    return !!length && baseIndexOf(array, value, 0) > -1;
	  }
	
	  /**
	   * This function is like `arrayIncludes` except that it accepts a comparator.
	   *
	   * @private
	   * @param {Array} [array] The array to inspect.
	   * @param {*} target The value to search for.
	   * @param {Function} comparator The comparator invoked per element.
	   * @returns {boolean} Returns `true` if `target` is found, else `false`.
	   */
	  function arrayIncludesWith(array, value, comparator) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	
	    while (++index < length) {
	      if (comparator(value, array[index])) {
	        return true;
	      }
	    }
	    return false;
	  }
	
	  /**
	   * A specialized version of `_.map` for arrays without support for iteratee
	   * shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @returns {Array} Returns the new mapped array.
	   */
	  function arrayMap(array, iteratee) {
	    var index = -1,
	        length = array == null ? 0 : array.length,
	        result = Array(length);
	
	    while (++index < length) {
	      result[index] = iteratee(array[index], index, array);
	    }
	    return result;
	  }
	
	  /**
	   * Appends the elements of `values` to `array`.
	   *
	   * @private
	   * @param {Array} array The array to modify.
	   * @param {Array} values The values to append.
	   * @returns {Array} Returns `array`.
	   */
	  function arrayPush(array, values) {
	    var index = -1,
	        length = values.length,
	        offset = array.length;
	
	    while (++index < length) {
	      array[offset + index] = values[index];
	    }
	    return array;
	  }
	
	  /**
	   * A specialized version of `_.reduce` for arrays without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @param {*} [accumulator] The initial value.
	   * @param {boolean} [initAccum] Specify using the first element of `array` as
	   *  the initial value.
	   * @returns {*} Returns the accumulated value.
	   */
	  function arrayReduce(array, iteratee, accumulator, initAccum) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	
	    if (initAccum && length) {
	      accumulator = array[++index];
	    }
	    while (++index < length) {
	      accumulator = iteratee(accumulator, array[index], index, array);
	    }
	    return accumulator;
	  }
	
	  /**
	   * A specialized version of `_.reduceRight` for arrays without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @param {*} [accumulator] The initial value.
	   * @param {boolean} [initAccum] Specify using the last element of `array` as
	   *  the initial value.
	   * @returns {*} Returns the accumulated value.
	   */
	  function arrayReduceRight(array, iteratee, accumulator, initAccum) {
	    var length = array == null ? 0 : array.length;
	    if (initAccum && length) {
	      accumulator = array[--length];
	    }
	    while (length--) {
	      accumulator = iteratee(accumulator, array[length], length, array);
	    }
	    return accumulator;
	  }
	
	  /**
	   * A specialized version of `_.some` for arrays without support for iteratee
	   * shorthands.
	   *
	   * @private
	   * @param {Array} [array] The array to iterate over.
	   * @param {Function} predicate The function invoked per iteration.
	   * @returns {boolean} Returns `true` if any element passes the predicate check,
	   *  else `false`.
	   */
	  function arraySome(array, predicate) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	
	    while (++index < length) {
	      if (predicate(array[index], index, array)) {
	        return true;
	      }
	    }
	    return false;
	  }
	
	  /**
	   * Gets the size of an ASCII `string`.
	   *
	   * @private
	   * @param {string} string The string inspect.
	   * @returns {number} Returns the string size.
	   */
	  var asciiSize = baseProperty('length');
	
	  /**
	   * Converts an ASCII `string` to an array.
	   *
	   * @private
	   * @param {string} string The string to convert.
	   * @returns {Array} Returns the converted array.
	   */
	  function asciiToArray(string) {
	    return string.split('');
	  }
	
	  /**
	   * Splits an ASCII `string` into an array of its words.
	   *
	   * @private
	   * @param {string} The string to inspect.
	   * @returns {Array} Returns the words of `string`.
	   */
	  function asciiWords(string) {
	    return string.match(reAsciiWord) || [];
	  }
	
	  /**
	   * The base implementation of methods like `_.findKey` and `_.findLastKey`,
	   * without support for iteratee shorthands, which iterates over `collection`
	   * using `eachFunc`.
	   *
	   * @private
	   * @param {Array|Object} collection The collection to inspect.
	   * @param {Function} predicate The function invoked per iteration.
	   * @param {Function} eachFunc The function to iterate over `collection`.
	   * @returns {*} Returns the found element or its key, else `undefined`.
	   */
	  function baseFindKey(collection, predicate, eachFunc) {
	    var result;
	    eachFunc(collection, function(value, key, collection) {
	      if (predicate(value, key, collection)) {
	        result = key;
	        return false;
	      }
	    });
	    return result;
	  }
	
	  /**
	   * The base implementation of `_.findIndex` and `_.findLastIndex` without
	   * support for iteratee shorthands.
	   *
	   * @private
	   * @param {Array} array The array to inspect.
	   * @param {Function} predicate The function invoked per iteration.
	   * @param {number} fromIndex The index to search from.
	   * @param {boolean} [fromRight] Specify iterating from right to left.
	   * @returns {number} Returns the index of the matched value, else `-1`.
	   */
	  function baseFindIndex(array, predicate, fromIndex, fromRight) {
	    var length = array.length,
	        index = fromIndex + (fromRight ? 1 : -1);
	
	    while ((fromRight ? index-- : ++index < length)) {
	      if (predicate(array[index], index, array)) {
	        return index;
	      }
	    }
	    return -1;
	  }
	
	  /**
	   * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
	   *
	   * @private
	   * @param {Array} array The array to inspect.
	   * @param {*} value The value to search for.
	   * @param {number} fromIndex The index to search from.
	   * @returns {number} Returns the index of the matched value, else `-1`.
	   */
	  function baseIndexOf(array, value, fromIndex) {
	    return value === value
	      ? strictIndexOf(array, value, fromIndex)
	      : baseFindIndex(array, baseIsNaN, fromIndex);
	  }
	
	  /**
	   * This function is like `baseIndexOf` except that it accepts a comparator.
	   *
	   * @private
	   * @param {Array} array The array to inspect.
	   * @param {*} value The value to search for.
	   * @param {number} fromIndex The index to search from.
	   * @param {Function} comparator The comparator invoked per element.
	   * @returns {number} Returns the index of the matched value, else `-1`.
	   */
	  function baseIndexOfWith(array, value, fromIndex, comparator) {
	    var index = fromIndex - 1,
	        length = array.length;
	
	    while (++index < length) {
	      if (comparator(array[index], value)) {
	        return index;
	      }
	    }
	    return -1;
	  }
	
	  /**
	   * The base implementation of `_.isNaN` without support for number objects.
	   *
	   * @private
	   * @param {*} value The value to check.
	   * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
	   */
	  function baseIsNaN(value) {
	    return value !== value;
	  }
	
	  /**
	   * The base implementation of `_.mean` and `_.meanBy` without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} array The array to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @returns {number} Returns the mean.
	   */
	  function baseMean(array, iteratee) {
	    var length = array == null ? 0 : array.length;
	    return length ? (baseSum(array, iteratee) / length) : NAN;
	  }
	
	  /**
	   * The base implementation of `_.property` without support for deep paths.
	   *
	   * @private
	   * @param {string} key The key of the property to get.
	   * @returns {Function} Returns the new accessor function.
	   */
	  function baseProperty(key) {
	    return function(object) {
	      return object == null ? undefined : object[key];
	    };
	  }
	
	  /**
	   * The base implementation of `_.propertyOf` without support for deep paths.
	   *
	   * @private
	   * @param {Object} object The object to query.
	   * @returns {Function} Returns the new accessor function.
	   */
	  function basePropertyOf(object) {
	    return function(key) {
	      return object == null ? undefined : object[key];
	    };
	  }
	
	  /**
	   * The base implementation of `_.reduce` and `_.reduceRight`, without support
	   * for iteratee shorthands, which iterates over `collection` using `eachFunc`.
	   *
	   * @private
	   * @param {Array|Object} collection The collection to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @param {*} accumulator The initial value.
	   * @param {boolean} initAccum Specify using the first or last element of
	   *  `collection` as the initial value.
	   * @param {Function} eachFunc The function to iterate over `collection`.
	   * @returns {*} Returns the accumulated value.
	   */
	  function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
	    eachFunc(collection, function(value, index, collection) {
	      accumulator = initAccum
	        ? (initAccum = false, value)
	        : iteratee(accumulator, value, index, collection);
	    });
	    return accumulator;
	  }
	
	  /**
	   * The base implementation of `_.sortBy` which uses `comparer` to define the
	   * sort order of `array` and replaces criteria objects with their corresponding
	   * values.
	   *
	   * @private
	   * @param {Array} array The array to sort.
	   * @param {Function} comparer The function to define sort order.
	   * @returns {Array} Returns `array`.
	   */
	  function baseSortBy(array, comparer) {
	    var length = array.length;
	
	    array.sort(comparer);
	    while (length--) {
	      array[length] = array[length].value;
	    }
	    return array;
	  }
	
	  /**
	   * The base implementation of `_.sum` and `_.sumBy` without support for
	   * iteratee shorthands.
	   *
	   * @private
	   * @param {Array} array The array to iterate over.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @returns {number} Returns the sum.
	   */
	  function baseSum(array, iteratee) {
	    var result,
	        index = -1,
	        length = array.length;
	
	    while (++index < length) {
	      var current = iteratee(array[index]);
	      if (current !== undefined) {
	        result = result === undefined ? current : (result + current);
	      }
	    }
	    return result;
	  }
	
	  /**
	   * The base implementation of `_.times` without support for iteratee shorthands
	   * or max array length checks.
	   *
	   * @private
	   * @param {number} n The number of times to invoke `iteratee`.
	   * @param {Function} iteratee The function invoked per iteration.
	   * @returns {Array} Returns the array of results.
	   */
	  function baseTimes(n, iteratee) {
	    var index = -1,
	        result = Array(n);
	
	    while (++index < n) {
	      result[index] = iteratee(index);
	    }
	    return result;
	  }
	
	  /**
	   * The base implementation of `_.toPairs` and `_.toPairsIn` which creates an array
	   * of key-value pairs for `object` corresponding to the property names of `props`.
	   *
	   * @private
	   * @param {Object} object The object to query.
	   * @param {Array} props The property names to get values for.
	   * @returns {Object} Returns the key-value pairs.
	   */
	  function baseToPairs(object, props) {
	    return arrayMap(props, function(key) {
	      return [key, object[key]];
	    });
	  }
	
	  /**
	   * The base implementation of `_.unary` without support for storing metadata.
	   *
	   * @private
	   * @param {Function} func The function to cap arguments for.
	   * @returns {Function} Returns the new capped function.
	   */
	  function baseUnary(func) {
	    return function(value) {
	      return func(value);
	    };
	  }
	
	  /**
	   * The base implementation of `_.values` and `_.valuesIn` which creates an
	   * array of `object` property values corresponding to the property names
	   * of `props`.
	   *
	   * @private
	   * @param {Object} object The object to query.
	   * @param {Array} props The property names to get values for.
	   * @returns {Object} Returns the array of property values.
	   */
	  function baseValues(object, props) {
	    return arrayMap(props, function(key) {
	      return object[key];
	    });
	  }
	
	  /**
	   * Checks if a `cache` value for `key` exists.
	   *
	   * @private
	   * @param {Object} cache The cache to query.
	   * @param {string} key The key of the entry to check.
	   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	   */
	  function cacheHas(cache, key) {
	    return cache.has(key);
	  }
	
	  /**
	   * Used by `_.trim` and `_.trimStart` to get the index of the first string symbol
	   * that is not found in the character symbols.
	   *
	   * @private
	   * @param {Array} strSymbols The string symbols to inspect.
	   * @param {Array} chrSymbols The character symbols to find.
	   * @returns {number} Returns the index of the first unmatched string symbol.
	   */
	  function charsStartIndex(strSymbols, chrSymbols) {
	    var index = -1,
	        length = strSymbols.length;
	
	    while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
	    return index;
	  }
	
	  /**
	   * Used by `_.trim` and `_.trimEnd` to get the index of the last string symbol
	   * that is not found in the character symbols.
	   *
	   * @private
	   * @param {Array} strSymbols The string symbols to inspect.
	   * @param {Array} chrSymbols The character symbols to find.
	   * @returns {number} Returns the index of the last unmatched string symbol.
	   */
	  function charsEndIndex(strSymbols, chrSymbols) {
	    var index = strSymbols.length;
	
	    while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
	    return index;
	  }
	
	  /**
	   * Gets the number of `placeholder` occurrences in `array`.
	   *
	   * @private
	   * @param {Array} array The array to inspect.
	   * @param {*} placeholder The placeholder to search for.
	   * @returns {number} Returns the placeholder count.
	   */
	  function countHolders(array, placeholder) {
	    var length = array.length,
	        result = 0;
	
	    while (length--) {
	      if (array[length] === placeholder) {
	        ++result;
	      }
	    }
	    return result;
	  }
	
	  /**
	   * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
	   * letters to basic Latin letters.
	   *
	   * @private
	   * @param {string} letter The matched letter to deburr.
	   * @returns {string} Returns the deburred letter.
	   */
	  var deburrLetter = basePropertyOf(deburredLetters);
	
	  /**
	   * Used by `_.escape` to convert characters to HTML entities.
	   *
	   * @private
	   * @param {string} chr The matched character to escape.
	   * @returns {string} Returns the escaped character.
	   */
	  var escapeHtmlChar = basePropertyOf(htmlEscapes);
	
	  /**
	   * Used by `_.template` to escape characters for inclusion in compiled string literals.
	   *
	   * @private
	   * @param {string} chr The matched character to escape.
	   * @returns {string} Returns the escaped character.
	   */
	  function escapeStringChar(chr) {
	    return '\\' + stringEscapes[chr];
	  }
	
	  /**
	   * Gets the value at `key` of `object`.
	   *
	   * @private
	   * @param {Object} [object] The object to query.
	   * @param {string} key The key of the property to get.
	   * @returns {*} Returns the property value.
	   */
	  function getValue(object, key) {
	    return object == null ? undefined : object[key];
	  }
	
	  /**
	   * Checks if `string` contains Unicode symbols.
	   *
	   * @private
	   * @param {string} string The string to inspect.
	   * @returns {boolean} Returns `true` if a symbol is found, else `false`.
	   */
	  function hasUnicode(string) {
	    return reHasUnicode.test(string);
	  }
	
	  /**
	   * Checks if `string` contains a word composed of Unicode symbols.
	   *
	   * @private
	   * @param {string} string The string to inspect.
	   * @returns {boolean} Returns `true` if a word is found, else `false`.
	   */
	  function hasUnicodeWord(string) {
	    return reHasUnicodeWord.test(string);
	  }
	
	  /**
	   * Converts `iterator` to an array.
	   *
	   * @private
	   * @param {Object} iterator The iterator to convert.
	   * @returns {Array} Returns the converted array.
	   */
	  function iteratorToArray(iterator) {
	    var data,
	        result = [];
	
	    while (!(data = iterator.next()).done) {
	      result.push(data.value);
	    }
	    return result;
	  }
	
	  /**
	   * Converts `map` to its key-value pairs.
	   *
	   * @private
	   * @param {Object} map The map to convert.
	   * @returns {Array} Returns the key-value pairs.
	   */
	  function mapToArray(map) {
	    var index = -1,
	        result = Array(map.size);
	
	    map.forEach(function(value, key) {
	      result[++index] = [key, value];
	    });
	    return result;
	  }
	
	  /**
	   * Creates a unary function that invokes `func` with its argument transformed.
	   *
	   * @private
	   * @param {Function} func The function to wrap.
	   * @param {Function} transform The argument transform.
	   * @returns {Function} Returns the new function.
	   */
	  function overArg(func, transform) {
	    return function(arg) {
	      return func(transform(arg));
	    };
	  }
	
	  /**
	   * Replaces all `placeholder` elements in `array` with an internal placeholder
	   * and returns an array of their indexes.
	   *
	   * @private
	   * @param {Array} array The array to modify.
	   * @param {*} placeholder The placeholder to replace.
	   * @returns {Array} Returns the new array of placeholder indexes.
	   */
	  function replaceHolders(array, placeholder) {
	    var index = -1,
	        length = array.length,
	        resIndex = 0,
	        result = [];
	
	    while (++index < length) {
	      var value = array[index];
	      if (value === placeholder || value === PLACEHOLDER) {
	        array[index] = PLACEHOLDER;
	        result[resIndex++] = index;
	      }
	    }
	    return result;
	  }
	
	  /**
	   * Converts `set` to an array of its values.
	   *
	   * @private
	   * @param {Object} set The set to convert.
	   * @returns {Array} Returns the values.
	   */
	  function setToArray(set) {
	    var index = -1,
	        result = Array(set.size);
	
	    set.forEach(function(value) {
	      result[++index] = value;
	    });
	    return result;
	  }
	
	  /**
	   * Converts `set` to its value-value pairs.
	   *
	   * @private
	   * @param {Object} set The set to convert.
	   * @returns {Array} Returns the value-value pairs.
	   */
	  function setToPairs(set) {
	    var index = -1,
	        result = Array(set.size);
	
	    set.forEach(function(value) {
	      result[++index] = [value, value];
	    });
	    return result;
	  }
	
	  /**
	   * A specialized version of `_.indexOf` which performs strict equality
	   * comparisons of values, i.e. `===`.
	   *
	   * @private
	   * @param {Array} array The array to inspect.
	   * @param {*} value The value to search for.
	   * @param {number} fromIndex The index to search from.
	   * @returns {number} Returns the index of the matched value, else `-1`.
	   */
	  function strictIndexOf(array, value, fromIndex) {
	    var index = fromIndex - 1,
	        length = array.length;
	
	    while (++index < length) {
	      if (array[index] === value) {
	        return index;
	      }
	    }
	    return -1;
	  }
	
	  /**
	   * A specialized version of `_.lastIndexOf` which performs strict equality
	   * comparisons of values, i.e. `===`.
	   *
	   * @private
	   * @param {Array} array The array to inspect.
	   * @param {*} value The value to search for.
	   * @param {number} fromIndex The index to search from.
	   * @returns {number} Returns the index of the matched value, else `-1`.
	   */
	  function strictLastIndexOf(array, value, fromIndex) {
	    var index = fromIndex + 1;
	    while (index--) {
	      if (array[index] === value) {
	        return index;
	      }
	    }
	    return index;
	  }
	
	  /**
	   * Gets the number of symbols in `string`.
	   *
	   * @private
	   * @param {string} string The string to inspect.
	   * @returns {number} Returns the string size.
	   */
	  function stringSize(string) {
	    return hasUnicode(string)
	      ? unicodeSize(string)
	      : asciiSize(string);
	  }
	
	  /**
	   * Converts `string` to an array.
	   *
	   * @private
	   * @param {string} string The string to convert.
	   * @returns {Array} Returns the converted array.
	   */
	  function stringToArray(string) {
	    return hasUnicode(string)
	      ? unicodeToArray(string)
	      : asciiToArray(string);
	  }
	
	  /**
	   * Used by `_.unescape` to convert HTML entities to characters.
	   *
	   * @private
	   * @param {string} chr The matched character to unescape.
	   * @returns {string} Returns the unescaped character.
	   */
	  var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
	
	  /**
	   * Gets the size of a Unicode `string`.
	   *
	   * @private
	   * @param {string} string The string inspect.
	   * @returns {number} Returns the string size.
	   */
	  function unicodeSize(string) {
	    var result = reUnicode.lastIndex = 0;
	    while (reUnicode.test(string)) {
	      ++result;
	    }
	    return result;
	  }
	
	  /**
	   * Converts a Unicode `string` to an array.
	   *
	   * @private
	   * @param {string} string The string to convert.
	   * @returns {Array} Returns the converted array.
	   */
	  function unicodeToArray(string) {
	    return string.match(reUnicode) || [];
	  }
	
	  /**
	   * Splits a Unicode `string` into an array of its words.
	   *
	   * @private
	   * @param {string} The string to inspect.
	   * @returns {Array} Returns the words of `string`.
	   */
	  function unicodeWords(string) {
	    return string.match(reUnicodeWord) || [];
	  }
	
	  /*--------------------------------------------------------------------------*/
	
	  /**
	   * Create a new pristine `lodash` function using the `context` object.
	   *
	   * @static
	   * @memberOf _
	   * @since 1.1.0
	   * @category Util
	   * @param {Object} [context=root] The context object.
	   * @returns {Function} Returns a new `lodash` function.
	   * @example
	   *
	   * _.mixin({ 'foo': _.constant('foo') });
	   *
	   * var lodash = _.runInContext();
	   * lodash.mixin({ 'bar': lodash.constant('bar') });
	   *
	   * _.isFunction(_.foo);
	   * // => true
	   * _.isFunction(_.bar);
	   * // => false
	   *
	   * lodash.isFunction(lodash.foo);
	   * // => false
	   * lodash.isFunction(lodash.bar);
	   * // => true
	   *
	   * // Create a suped-up `defer` in Node.js.
	   * var defer = _.runInContext({ 'setTimeout': setImmediate }).defer;
	   */
	  var runInContext = (function runInContext(context) {
	    context = context == null ? root : _.defaults(root.Object(), context, _.pick(root, contextProps));
	
	    /** Built-in constructor references. */
	    var Array = context.Array,
	        Date = context.Date,
	        Error = context.Error,
	        Function = context.Function,
	        Math = context.Math,
	        Object = context.Object,
	        RegExp = context.RegExp,
	        String = context.String,
	        TypeError = context.TypeError;
	
	    /** Used for built-in method references. */
	    var arrayProto = Array.prototype,
	        funcProto = Function.prototype,
	        objectProto = Object.prototype;
	
	    /** Used to detect overreaching core-js shims. */
	    var coreJsData = context['__core-js_shared__'];
	
	    /** Used to resolve the decompiled source of functions. */
	    var funcToString = funcProto.toString;
	
	    /** Used to check objects for own properties. */
	    var hasOwnProperty = objectProto.hasOwnProperty;
	
	    /** Used to generate unique IDs. */
	    var idCounter = 0;
	
	    /** Used to detect methods masquerading as native. */
	    var maskSrcKey = (function() {
	      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
	      return uid ? ('Symbol(src)_1.' + uid) : '';
	    }());
	
	    /**
	     * Used to resolve the
	     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	     * of values.
	     */
	    var nativeObjectToString = objectProto.toString;
	
	    /** Used to infer the `Object` constructor. */
	    var objectCtorString = funcToString.call(Object);
	
	    /** Used to restore the original `_` reference in `_.noConflict`. */
	    var oldDash = root._;
	
	    /** Used to detect if a method is native. */
	    var reIsNative = RegExp('^' +
	      funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	      .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	    );
	
	    /** Built-in value references. */
	    var Buffer = moduleExports ? context.Buffer : undefined,
	        Symbol = context.Symbol,
	        Uint8Array = context.Uint8Array,
	        allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined,
	        getPrototype = overArg(Object.getPrototypeOf, Object),
	        objectCreate = Object.create,
	        propertyIsEnumerable = objectProto.propertyIsEnumerable,
	        splice = arrayProto.splice,
	        spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined,
	        symIterator = Symbol ? Symbol.iterator : undefined,
	        symToStringTag = Symbol ? Symbol.toStringTag : undefined;
	
	    var defineProperty = (function() {
	      try {
	        var func = getNative(Object, 'defineProperty');
	        func({}, '', {});
	        return func;
	      } catch (e) {}
	    }());
	
	    /** Mocked built-ins. */
	    var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout,
	        ctxNow = Date && Date.now !== root.Date.now && Date.now,
	        ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;
	
	    /* Built-in method references for those with the same name as other `lodash` methods. */
	    var nativeCeil = Math.ceil,
	        nativeFloor = Math.floor,
	        nativeGetSymbols = Object.getOwnPropertySymbols,
	        nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
	        nativeIsFinite = context.isFinite,
	        nativeJoin = arrayProto.join,
	        nativeKeys = overArg(Object.keys, Object),
	        nativeMax = Math.max,
	        nativeMin = Math.min,
	        nativeNow = Date.now,
	        nativeParseInt = context.parseInt,
	        nativeRandom = Math.random,
	        nativeReverse = arrayProto.reverse;
	
	    /* Built-in method references that are verified to be native. */
	    var DataView = getNative(context, 'DataView'),
	        Map = getNative(context, 'Map'),
	        Promise = getNative(context, 'Promise'),
	        Set = getNative(context, 'Set'),
	        WeakMap = getNative(context, 'WeakMap'),
	        nativeCreate = getNative(Object, 'create');
	
	    /** Used to store function metadata. */
	    var metaMap = WeakMap && new WeakMap;
	
	    /** Used to lookup unminified function names. */
	    var realNames = {};
	
	    /** Used to detect maps, sets, and weakmaps. */
	    var dataViewCtorString = toSource(DataView),
	        mapCtorString = toSource(Map),
	        promiseCtorString = toSource(Promise),
	        setCtorString = toSource(Set),
	        weakMapCtorString = toSource(WeakMap);
	
	    /** Used to convert symbols to primitives and strings. */
	    var symbolProto = Symbol ? Symbol.prototype : undefined,
	        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined,
	        symbolToString = symbolProto ? symbolProto.toString : undefined;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates a `lodash` object which wraps `value` to enable implicit method
	     * chain sequences. Methods that operate on and return arrays, collections,
	     * and functions can be chained together. Methods that retrieve a single value
	     * or may return a primitive value will automatically end the chain sequence
	     * and return the unwrapped value. Otherwise, the value must be unwrapped
	     * with `_#value`.
	     *
	     * Explicit chain sequences, which must be unwrapped with `_#value`, may be
	     * enabled using `_.chain`.
	     *
	     * The execution of chained methods is lazy, that is, it's deferred until
	     * `_#value` is implicitly or explicitly called.
	     *
	     * Lazy evaluation allows several methods to support shortcut fusion.
	     * Shortcut fusion is an optimization to merge iteratee calls; this avoids
	     * the creation of intermediate arrays and can greatly reduce the number of
	     * iteratee executions. Sections of a chain sequence qualify for shortcut
	     * fusion if the section is applied to an array and iteratees accept only
	     * one argument. The heuristic for whether a section qualifies for shortcut
	     * fusion is subject to change.
	     *
	     * Chaining is supported in custom builds as long as the `_#value` method is
	     * directly or indirectly included in the build.
	     *
	     * In addition to lodash methods, wrappers have `Array` and `String` methods.
	     *
	     * The wrapper `Array` methods are:
	     * `concat`, `join`, `pop`, `push`, `shift`, `sort`, `splice`, and `unshift`
	     *
	     * The wrapper `String` methods are:
	     * `replace` and `split`
	     *
	     * The wrapper methods that support shortcut fusion are:
	     * `at`, `compact`, `drop`, `dropRight`, `dropWhile`, `filter`, `find`,
	     * `findLast`, `head`, `initial`, `last`, `map`, `reject`, `reverse`, `slice`,
	     * `tail`, `take`, `takeRight`, `takeRightWhile`, `takeWhile`, and `toArray`
	     *
	     * The chainable wrapper methods are:
	     * `after`, `ary`, `assign`, `assignIn`, `assignInWith`, `assignWith`, `at`,
	     * `before`, `bind`, `bindAll`, `bindKey`, `castArray`, `chain`, `chunk`,
	     * `commit`, `compact`, `concat`, `conforms`, `constant`, `countBy`, `create`,
	     * `curry`, `debounce`, `defaults`, `defaultsDeep`, `defer`, `delay`,
	     * `difference`, `differenceBy`, `differenceWith`, `drop`, `dropRight`,
	     * `dropRightWhile`, `dropWhile`, `extend`, `extendWith`, `fill`, `filter`,
	     * `flatMap`, `flatMapDeep`, `flatMapDepth`, `flatten`, `flattenDeep`,
	     * `flattenDepth`, `flip`, `flow`, `flowRight`, `fromPairs`, `functions`,
	     * `functionsIn`, `groupBy`, `initial`, `intersection`, `intersectionBy`,
	     * `intersectionWith`, `invert`, `invertBy`, `invokeMap`, `iteratee`, `keyBy`,
	     * `keys`, `keysIn`, `map`, `mapKeys`, `mapValues`, `matches`, `matchesProperty`,
	     * `memoize`, `merge`, `mergeWith`, `method`, `methodOf`, `mixin`, `negate`,
	     * `nthArg`, `omit`, `omitBy`, `once`, `orderBy`, `over`, `overArgs`,
	     * `overEvery`, `overSome`, `partial`, `partialRight`, `partition`, `pick`,
	     * `pickBy`, `plant`, `property`, `propertyOf`, `pull`, `pullAll`, `pullAllBy`,
	     * `pullAllWith`, `pullAt`, `push`, `range`, `rangeRight`, `rearg`, `reject`,
	     * `remove`, `rest`, `reverse`, `sampleSize`, `set`, `setWith`, `shuffle`,
	     * `slice`, `sort`, `sortBy`, `splice`, `spread`, `tail`, `take`, `takeRight`,
	     * `takeRightWhile`, `takeWhile`, `tap`, `throttle`, `thru`, `toArray`,
	     * `toPairs`, `toPairsIn`, `toPath`, `toPlainObject`, `transform`, `unary`,
	     * `union`, `unionBy`, `unionWith`, `uniq`, `uniqBy`, `uniqWith`, `unset`,
	     * `unshift`, `unzip`, `unzipWith`, `update`, `updateWith`, `values`,
	     * `valuesIn`, `without`, `wrap`, `xor`, `xorBy`, `xorWith`, `zip`,
	     * `zipObject`, `zipObjectDeep`, and `zipWith`
	     *
	     * The wrapper methods that are **not** chainable by default are:
	     * `add`, `attempt`, `camelCase`, `capitalize`, `ceil`, `clamp`, `clone`,
	     * `cloneDeep`, `cloneDeepWith`, `cloneWith`, `conformsTo`, `deburr`,
	     * `defaultTo`, `divide`, `each`, `eachRight`, `endsWith`, `eq`, `escape`,
	     * `escapeRegExp`, `every`, `find`, `findIndex`, `findKey`, `findLast`,
	     * `findLastIndex`, `findLastKey`, `first`, `floor`, `forEach`, `forEachRight`,
	     * `forIn`, `forInRight`, `forOwn`, `forOwnRight`, `get`, `gt`, `gte`, `has`,
	     * `hasIn`, `head`, `identity`, `includes`, `indexOf`, `inRange`, `invoke`,
	     * `isArguments`, `isArray`, `isArrayBuffer`, `isArrayLike`, `isArrayLikeObject`,
	     * `isBoolean`, `isBuffer`, `isDate`, `isElement`, `isEmpty`, `isEqual`,
	     * `isEqualWith`, `isError`, `isFinite`, `isFunction`, `isInteger`, `isLength`,
	     * `isMap`, `isMatch`, `isMatchWith`, `isNaN`, `isNative`, `isNil`, `isNull`,
	     * `isNumber`, `isObject`, `isObjectLike`, `isPlainObject`, `isRegExp`,
	     * `isSafeInteger`, `isSet`, `isString`, `isUndefined`, `isTypedArray`,
	     * `isWeakMap`, `isWeakSet`, `join`, `kebabCase`, `last`, `lastIndexOf`,
	     * `lowerCase`, `lowerFirst`, `lt`, `lte`, `max`, `maxBy`, `mean`, `meanBy`,
	     * `min`, `minBy`, `multiply`, `noConflict`, `noop`, `now`, `nth`, `pad`,
	     * `padEnd`, `padStart`, `parseInt`, `pop`, `random`, `reduce`, `reduceRight`,
	     * `repeat`, `result`, `round`, `runInContext`, `sample`, `shift`, `size`,
	     * `snakeCase`, `some`, `sortedIndex`, `sortedIndexBy`, `sortedLastIndex`,
	     * `sortedLastIndexBy`, `startCase`, `startsWith`, `stubArray`, `stubFalse`,
	     * `stubObject`, `stubString`, `stubTrue`, `subtract`, `sum`, `sumBy`,
	     * `template`, `times`, `toFinite`, `toInteger`, `toJSON`, `toLength`,
	     * `toLower`, `toNumber`, `toSafeInteger`, `toString`, `toUpper`, `trim`,
	     * `trimEnd`, `trimStart`, `truncate`, `unescape`, `uniqueId`, `upperCase`,
	     * `upperFirst`, `value`, and `words`
	     *
	     * @name _
	     * @constructor
	     * @category Seq
	     * @param {*} value The value to wrap in a `lodash` instance.
	     * @returns {Object} Returns the new `lodash` wrapper instance.
	     * @example
	     *
	     * function square(n) {
	     *   return n * n;
	     * }
	     *
	     * var wrapped = _([1, 2, 3]);
	     *
	     * // Returns an unwrapped value.
	     * wrapped.reduce(_.add);
	     * // => 6
	     *
	     * // Returns a wrapped value.
	     * var squares = wrapped.map(square);
	     *
	     * _.isArray(squares);
	     * // => false
	     *
	     * _.isArray(squares.value());
	     * // => true
	     */
	    function lodash(value) {
	      if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
	        if (value instanceof LodashWrapper) {
	          return value;
	        }
	        if (hasOwnProperty.call(value, '__wrapped__')) {
	          return wrapperClone(value);
	        }
	      }
	      return new LodashWrapper(value);
	    }
	
	    /**
	     * The base implementation of `_.create` without support for assigning
	     * properties to the created object.
	     *
	     * @private
	     * @param {Object} proto The object to inherit from.
	     * @returns {Object} Returns the new object.
	     */
	    var baseCreate = (function() {
	      function object() {}
	      return function(proto) {
	        if (!isObject(proto)) {
	          return {};
	        }
	        if (objectCreate) {
	          return objectCreate(proto);
	        }
	        object.prototype = proto;
	        var result = new object;
	        object.prototype = undefined;
	        return result;
	      };
	    }());
	
	    /**
	     * The function whose prototype chain sequence wrappers inherit from.
	     *
	     * @private
	     */
	    function baseLodash() {
	      // No operation performed.
	    }
	
	    /**
	     * The base constructor for creating `lodash` wrapper objects.
	     *
	     * @private
	     * @param {*} value The value to wrap.
	     * @param {boolean} [chainAll] Enable explicit method chain sequences.
	     */
	    function LodashWrapper(value, chainAll) {
	      this.__wrapped__ = value;
	      this.__actions__ = [];
	      this.__chain__ = !!chainAll;
	      this.__index__ = 0;
	      this.__values__ = undefined;
	    }
	
	    /**
	     * By default, the template delimiters used by lodash are like those in
	     * embedded Ruby (ERB) as well as ES2015 template strings. Change the
	     * following template settings to use alternative delimiters.
	     *
	     * @static
	     * @memberOf _
	     * @type {Object}
	     */
	    lodash.templateSettings = {
	
	      /**
	       * Used to detect `data` property values to be HTML-escaped.
	       *
	       * @memberOf _.templateSettings
	       * @type {RegExp}
	       */
	      'escape': reEscape,
	
	      /**
	       * Used to detect code to be evaluated.
	       *
	       * @memberOf _.templateSettings
	       * @type {RegExp}
	       */
	      'evaluate': reEvaluate,
	
	      /**
	       * Used to detect `data` property values to inject.
	       *
	       * @memberOf _.templateSettings
	       * @type {RegExp}
	       */
	      'interpolate': reInterpolate,
	
	      /**
	       * Used to reference the data object in the template text.
	       *
	       * @memberOf _.templateSettings
	       * @type {string}
	       */
	      'variable': '',
	
	      /**
	       * Used to import variables into the compiled template.
	       *
	       * @memberOf _.templateSettings
	       * @type {Object}
	       */
	      'imports': {
	
	        /**
	         * A reference to the `lodash` function.
	         *
	         * @memberOf _.templateSettings.imports
	         * @type {Function}
	         */
	        '_': lodash
	      }
	    };
	
	    // Ensure wrappers are instances of `baseLodash`.
	    lodash.prototype = baseLodash.prototype;
	    lodash.prototype.constructor = lodash;
	
	    LodashWrapper.prototype = baseCreate(baseLodash.prototype);
	    LodashWrapper.prototype.constructor = LodashWrapper;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates a lazy wrapper object which wraps `value` to enable lazy evaluation.
	     *
	     * @private
	     * @constructor
	     * @param {*} value The value to wrap.
	     */
	    function LazyWrapper(value) {
	      this.__wrapped__ = value;
	      this.__actions__ = [];
	      this.__dir__ = 1;
	      this.__filtered__ = false;
	      this.__iteratees__ = [];
	      this.__takeCount__ = MAX_ARRAY_LENGTH;
	      this.__views__ = [];
	    }
	
	    /**
	     * Creates a clone of the lazy wrapper object.
	     *
	     * @private
	     * @name clone
	     * @memberOf LazyWrapper
	     * @returns {Object} Returns the cloned `LazyWrapper` object.
	     */
	    function lazyClone() {
	      var result = new LazyWrapper(this.__wrapped__);
	      result.__actions__ = copyArray(this.__actions__);
	      result.__dir__ = this.__dir__;
	      result.__filtered__ = this.__filtered__;
	      result.__iteratees__ = copyArray(this.__iteratees__);
	      result.__takeCount__ = this.__takeCount__;
	      result.__views__ = copyArray(this.__views__);
	      return result;
	    }
	
	    /**
	     * Reverses the direction of lazy iteration.
	     *
	     * @private
	     * @name reverse
	     * @memberOf LazyWrapper
	     * @returns {Object} Returns the new reversed `LazyWrapper` object.
	     */
	    function lazyReverse() {
	      if (this.__filtered__) {
	        var result = new LazyWrapper(this);
	        result.__dir__ = -1;
	        result.__filtered__ = true;
	      } else {
	        result = this.clone();
	        result.__dir__ *= -1;
	      }
	      return result;
	    }
	
	    /**
	     * Extracts the unwrapped value from its lazy wrapper.
	     *
	     * @private
	     * @name value
	     * @memberOf LazyWrapper
	     * @returns {*} Returns the unwrapped value.
	     */
	    function lazyValue() {
	      var array = this.__wrapped__.value(),
	          dir = this.__dir__,
	          isArr = isArray(array),
	          isRight = dir < 0,
	          arrLength = isArr ? array.length : 0,
	          view = getView(0, arrLength, this.__views__),
	          start = view.start,
	          end = view.end,
	          length = end - start,
	          index = isRight ? end : (start - 1),
	          iteratees = this.__iteratees__,
	          iterLength = iteratees.length,
	          resIndex = 0,
	          takeCount = nativeMin(length, this.__takeCount__);
	
	      if (!isArr || (!isRight && arrLength == length && takeCount == length)) {
	        return baseWrapperValue(array, this.__actions__);
	      }
	      var result = [];
	
	      outer:
	      while (length-- && resIndex < takeCount) {
	        index += dir;
	
	        var iterIndex = -1,
	            value = array[index];
	
	        while (++iterIndex < iterLength) {
	          var data = iteratees[iterIndex],
	              iteratee = data.iteratee,
	              type = data.type,
	              computed = iteratee(value);
	
	          if (type == LAZY_MAP_FLAG) {
	            value = computed;
	          } else if (!computed) {
	            if (type == LAZY_FILTER_FLAG) {
	              continue outer;
	            } else {
	              break outer;
	            }
	          }
	        }
	        result[resIndex++] = value;
	      }
	      return result;
	    }
	
	    // Ensure `LazyWrapper` is an instance of `baseLodash`.
	    LazyWrapper.prototype = baseCreate(baseLodash.prototype);
	    LazyWrapper.prototype.constructor = LazyWrapper;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates a hash object.
	     *
	     * @private
	     * @constructor
	     * @param {Array} [entries] The key-value pairs to cache.
	     */
	    function Hash(entries) {
	      var index = -1,
	          length = entries == null ? 0 : entries.length;
	
	      this.clear();
	      while (++index < length) {
	        var entry = entries[index];
	        this.set(entry[0], entry[1]);
	      }
	    }
	
	    /**
	     * Removes all key-value entries from the hash.
	     *
	     * @private
	     * @name clear
	     * @memberOf Hash
	     */
	    function hashClear() {
	      this.__data__ = nativeCreate ? nativeCreate(null) : {};
	      this.size = 0;
	    }
	
	    /**
	     * Removes `key` and its value from the hash.
	     *
	     * @private
	     * @name delete
	     * @memberOf Hash
	     * @param {Object} hash The hash to modify.
	     * @param {string} key The key of the value to remove.
	     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	     */
	    function hashDelete(key) {
	      var result = this.has(key) && delete this.__data__[key];
	      this.size -= result ? 1 : 0;
	      return result;
	    }
	
	    /**
	     * Gets the hash value for `key`.
	     *
	     * @private
	     * @name get
	     * @memberOf Hash
	     * @param {string} key The key of the value to get.
	     * @returns {*} Returns the entry value.
	     */
	    function hashGet(key) {
	      var data = this.__data__;
	      if (nativeCreate) {
	        var result = data[key];
	        return result === HASH_UNDEFINED ? undefined : result;
	      }
	      return hasOwnProperty.call(data, key) ? data[key] : undefined;
	    }
	
	    /**
	     * Checks if a hash value for `key` exists.
	     *
	     * @private
	     * @name has
	     * @memberOf Hash
	     * @param {string} key The key of the entry to check.
	     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	     */
	    function hashHas(key) {
	      var data = this.__data__;
	      return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
	    }
	
	    /**
	     * Sets the hash `key` to `value`.
	     *
	     * @private
	     * @name set
	     * @memberOf Hash
	     * @param {string} key The key of the value to set.
	     * @param {*} value The value to set.
	     * @returns {Object} Returns the hash instance.
	     */
	    function hashSet(key, value) {
	      var data = this.__data__;
	      this.size += this.has(key) ? 0 : 1;
	      data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
	      return this;
	    }
	
	    // Add methods to `Hash`.
	    Hash.prototype.clear = hashClear;
	    Hash.prototype['delete'] = hashDelete;
	    Hash.prototype.get = hashGet;
	    Hash.prototype.has = hashHas;
	    Hash.prototype.set = hashSet;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates an list cache object.
	     *
	     * @private
	     * @constructor
	     * @param {Array} [entries] The key-value pairs to cache.
	     */
	    function ListCache(entries) {
	      var index = -1,
	          length = entries == null ? 0 : entries.length;
	
	      this.clear();
	      while (++index < length) {
	        var entry = entries[index];
	        this.set(entry[0], entry[1]);
	      }
	    }
	
	    /**
	     * Removes all key-value entries from the list cache.
	     *
	     * @private
	     * @name clear
	     * @memberOf ListCache
	     */
	    function listCacheClear() {
	      this.__data__ = [];
	      this.size = 0;
	    }
	
	    /**
	     * Removes `key` and its value from the list cache.
	     *
	     * @private
	     * @name delete
	     * @memberOf ListCache
	     * @param {string} key The key of the value to remove.
	     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	     */
	    function listCacheDelete(key) {
	      var data = this.__data__,
	          index = assocIndexOf(data, key);
	
	      if (index < 0) {
	        return false;
	      }
	      var lastIndex = data.length - 1;
	      if (index == lastIndex) {
	        data.pop();
	      } else {
	        splice.call(data, index, 1);
	      }
	      --this.size;
	      return true;
	    }
	
	    /**
	     * Gets the list cache value for `key`.
	     *
	     * @private
	     * @name get
	     * @memberOf ListCache
	     * @param {string} key The key of the value to get.
	     * @returns {*} Returns the entry value.
	     */
	    function listCacheGet(key) {
	      var data = this.__data__,
	          index = assocIndexOf(data, key);
	
	      return index < 0 ? undefined : data[index][1];
	    }
	
	    /**
	     * Checks if a list cache value for `key` exists.
	     *
	     * @private
	     * @name has
	     * @memberOf ListCache
	     * @param {string} key The key of the entry to check.
	     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	     */
	    function listCacheHas(key) {
	      return assocIndexOf(this.__data__, key) > -1;
	    }
	
	    /**
	     * Sets the list cache `key` to `value`.
	     *
	     * @private
	     * @name set
	     * @memberOf ListCache
	     * @param {string} key The key of the value to set.
	     * @param {*} value The value to set.
	     * @returns {Object} Returns the list cache instance.
	     */
	    function listCacheSet(key, value) {
	      var data = this.__data__,
	          index = assocIndexOf(data, key);
	
	      if (index < 0) {
	        ++this.size;
	        data.push([key, value]);
	      } else {
	        data[index][1] = value;
	      }
	      return this;
	    }
	
	    // Add methods to `ListCache`.
	    ListCache.prototype.clear = listCacheClear;
	    ListCache.prototype['delete'] = listCacheDelete;
	    ListCache.prototype.get = listCacheGet;
	    ListCache.prototype.has = listCacheHas;
	    ListCache.prototype.set = listCacheSet;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates a map cache object to store key-value pairs.
	     *
	     * @private
	     * @constructor
	     * @param {Array} [entries] The key-value pairs to cache.
	     */
	    function MapCache(entries) {
	      var index = -1,
	          length = entries == null ? 0 : entries.length;
	
	      this.clear();
	      while (++index < length) {
	        var entry = entries[index];
	        this.set(entry[0], entry[1]);
	      }
	    }
	
	    /**
	     * Removes all key-value entries from the map.
	     *
	     * @private
	     * @name clear
	     * @memberOf MapCache
	     */
	    function mapCacheClear() {
	      this.size = 0;
	      this.__data__ = {
	        'hash': new Hash,
	        'map': new (Map || ListCache),
	        'string': new Hash
	      };
	    }
	
	    /**
	     * Removes `key` and its value from the map.
	     *
	     * @private
	     * @name delete
	     * @memberOf MapCache
	     * @param {string} key The key of the value to remove.
	     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	     */
	    function mapCacheDelete(key) {
	      var result = getMapData(this, key)['delete'](key);
	      this.size -= result ? 1 : 0;
	      return result;
	    }
	
	    /**
	     * Gets the map value for `key`.
	     *
	     * @private
	     * @name get
	     * @memberOf MapCache
	     * @param {string} key The key of the value to get.
	     * @returns {*} Returns the entry value.
	     */
	    function mapCacheGet(key) {
	      return getMapData(this, key).get(key);
	    }
	
	    /**
	     * Checks if a map value for `key` exists.
	     *
	     * @private
	     * @name has
	     * @memberOf MapCache
	     * @param {string} key The key of the entry to check.
	     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	     */
	    function mapCacheHas(key) {
	      return getMapData(this, key).has(key);
	    }
	
	    /**
	     * Sets the map `key` to `value`.
	     *
	     * @private
	     * @name set
	     * @memberOf MapCache
	     * @param {string} key The key of the value to set.
	     * @param {*} value The value to set.
	     * @returns {Object} Returns the map cache instance.
	     */
	    function mapCacheSet(key, value) {
	      var data = getMapData(this, key),
	          size = data.size;
	
	      data.set(key, value);
	      this.size += data.size == size ? 0 : 1;
	      return this;
	    }
	
	    // Add methods to `MapCache`.
	    MapCache.prototype.clear = mapCacheClear;
	    MapCache.prototype['delete'] = mapCacheDelete;
	    MapCache.prototype.get = mapCacheGet;
	    MapCache.prototype.has = mapCacheHas;
	    MapCache.prototype.set = mapCacheSet;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     *
	     * Creates an array cache object to store unique values.
	     *
	     * @private
	     * @constructor
	     * @param {Array} [values] The values to cache.
	     */
	    function SetCache(values) {
	      var index = -1,
	          length = values == null ? 0 : values.length;
	
	      this.__data__ = new MapCache;
	      while (++index < length) {
	        this.add(values[index]);
	      }
	    }
	
	    /**
	     * Adds `value` to the array cache.
	     *
	     * @private
	     * @name add
	     * @memberOf SetCache
	     * @alias push
	     * @param {*} value The value to cache.
	     * @returns {Object} Returns the cache instance.
	     */
	    function setCacheAdd(value) {
	      this.__data__.set(value, HASH_UNDEFINED);
	      return this;
	    }
	
	    /**
	     * Checks if `value` is in the array cache.
	     *
	     * @private
	     * @name has
	     * @memberOf SetCache
	     * @param {*} value The value to search for.
	     * @returns {number} Returns `true` if `value` is found, else `false`.
	     */
	    function setCacheHas(value) {
	      return this.__data__.has(value);
	    }
	
	    // Add methods to `SetCache`.
	    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
	    SetCache.prototype.has = setCacheHas;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates a stack cache object to store key-value pairs.
	     *
	     * @private
	     * @constructor
	     * @param {Array} [entries] The key-value pairs to cache.
	     */
	    function Stack(entries) {
	      var data = this.__data__ = new ListCache(entries);
	      this.size = data.size;
	    }
	
	    /**
	     * Removes all key-value entries from the stack.
	     *
	     * @private
	     * @name clear
	     * @memberOf Stack
	     */
	    function stackClear() {
	      this.__data__ = new ListCache;
	      this.size = 0;
	    }
	
	    /**
	     * Removes `key` and its value from the stack.
	     *
	     * @private
	     * @name delete
	     * @memberOf Stack
	     * @param {string} key The key of the value to remove.
	     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	     */
	    function stackDelete(key) {
	      var data = this.__data__,
	          result = data['delete'](key);
	
	      this.size = data.size;
	      return result;
	    }
	
	    /**
	     * Gets the stack value for `key`.
	     *
	     * @private
	     * @name get
	     * @memberOf Stack
	     * @param {string} key The key of the value to get.
	     * @returns {*} Returns the entry value.
	     */
	    function stackGet(key) {
	      return this.__data__.get(key);
	    }
	
	    /**
	     * Checks if a stack value for `key` exists.
	     *
	     * @private
	     * @name has
	     * @memberOf Stack
	     * @param {string} key The key of the entry to check.
	     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	     */
	    function stackHas(key) {
	      return this.__data__.has(key);
	    }
	
	    /**
	     * Sets the stack `key` to `value`.
	     *
	     * @private
	     * @name set
	     * @memberOf Stack
	     * @param {string} key The key of the value to set.
	     * @param {*} value The value to set.
	     * @returns {Object} Returns the stack cache instance.
	     */
	    function stackSet(key, value) {
	      var data = this.__data__;
	      if (data instanceof ListCache) {
	        var pairs = data.__data__;
	        if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
	          pairs.push([key, value]);
	          this.size = ++data.size;
	          return this;
	        }
	        data = this.__data__ = new MapCache(pairs);
	      }
	      data.set(key, value);
	      this.size = data.size;
	      return this;
	    }
	
	    // Add methods to `Stack`.
	    Stack.prototype.clear = stackClear;
	    Stack.prototype['delete'] = stackDelete;
	    Stack.prototype.get = stackGet;
	    Stack.prototype.has = stackHas;
	    Stack.prototype.set = stackSet;
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates an array of the enumerable property names of the array-like `value`.
	     *
	     * @private
	     * @param {*} value The value to query.
	     * @param {boolean} inherited Specify returning inherited property names.
	     * @returns {Array} Returns the array of property names.
	     */
	    function arrayLikeKeys(value, inherited) {
	      var isArr = isArray(value),
	          isArg = !isArr && isArguments(value),
	          isBuff = !isArr && !isArg && isBuffer(value),
	          isType = !isArr && !isArg && !isBuff && isTypedArray(value),
	          skipIndexes = isArr || isArg || isBuff || isType,
	          result = skipIndexes ? baseTimes(value.length, String) : [],
	          length = result.length;
	
	      for (var key in value) {
	        if ((inherited || hasOwnProperty.call(value, key)) &&
	            !(skipIndexes && (
	               // Safari 9 has enumerable `arguments.length` in strict mode.
	               key == 'length' ||
	               // Node.js 0.10 has enumerable non-index properties on buffers.
	               (isBuff && (key == 'offset' || key == 'parent')) ||
	               // PhantomJS 2 has enumerable non-index properties on typed arrays.
	               (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
	               // Skip index properties.
	               isIndex(key, length)
	            ))) {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * A specialized version of `_.sample` for arrays.
	     *
	     * @private
	     * @param {Array} array The array to sample.
	     * @returns {*} Returns the random element.
	     */
	    function arraySample(array) {
	      var length = array.length;
	      return length ? array[baseRandom(0, length - 1)] : undefined;
	    }
	
	    /**
	     * A specialized version of `_.sampleSize` for arrays.
	     *
	     * @private
	     * @param {Array} array The array to sample.
	     * @param {number} n The number of elements to sample.
	     * @returns {Array} Returns the random elements.
	     */
	    function arraySampleSize(array, n) {
	      return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
	    }
	
	    /**
	     * A specialized version of `_.shuffle` for arrays.
	     *
	     * @private
	     * @param {Array} array The array to shuffle.
	     * @returns {Array} Returns the new shuffled array.
	     */
	    function arrayShuffle(array) {
	      return shuffleSelf(copyArray(array));
	    }
	
	    /**
	     * This function is like `assignValue` except that it doesn't assign
	     * `undefined` values.
	     *
	     * @private
	     * @param {Object} object The object to modify.
	     * @param {string} key The key of the property to assign.
	     * @param {*} value The value to assign.
	     */
	    function assignMergeValue(object, key, value) {
	      if ((value !== undefined && !eq(object[key], value)) ||
	          (value === undefined && !(key in object))) {
	        baseAssignValue(object, key, value);
	      }
	    }
	
	    /**
	     * Assigns `value` to `key` of `object` if the existing value is not equivalent
	     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons.
	     *
	     * @private
	     * @param {Object} object The object to modify.
	     * @param {string} key The key of the property to assign.
	     * @param {*} value The value to assign.
	     */
	    function assignValue(object, key, value) {
	      var objValue = object[key];
	      if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
	          (value === undefined && !(key in object))) {
	        baseAssignValue(object, key, value);
	      }
	    }
	
	    /**
	     * Gets the index at which the `key` is found in `array` of key-value pairs.
	     *
	     * @private
	     * @param {Array} array The array to inspect.
	     * @param {*} key The key to search for.
	     * @returns {number} Returns the index of the matched value, else `-1`.
	     */
	    function assocIndexOf(array, key) {
	      var length = array.length;
	      while (length--) {
	        if (eq(array[length][0], key)) {
	          return length;
	        }
	      }
	      return -1;
	    }
	
	    /**
	     * Aggregates elements of `collection` on `accumulator` with keys transformed
	     * by `iteratee` and values set by `setter`.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} setter The function to set `accumulator` values.
	     * @param {Function} iteratee The iteratee to transform keys.
	     * @param {Object} accumulator The initial aggregated object.
	     * @returns {Function} Returns `accumulator`.
	     */
	    function baseAggregator(collection, setter, iteratee, accumulator) {
	      baseEach(collection, function(value, key, collection) {
	        setter(accumulator, value, iteratee(value), collection);
	      });
	      return accumulator;
	    }
	
	    /**
	     * The base implementation of `_.assign` without support for multiple sources
	     * or `customizer` functions.
	     *
	     * @private
	     * @param {Object} object The destination object.
	     * @param {Object} source The source object.
	     * @returns {Object} Returns `object`.
	     */
	    function baseAssign(object, source) {
	      return object && copyObject(source, keys(source), object);
	    }
	
	    /**
	     * The base implementation of `_.assignIn` without support for multiple sources
	     * or `customizer` functions.
	     *
	     * @private
	     * @param {Object} object The destination object.
	     * @param {Object} source The source object.
	     * @returns {Object} Returns `object`.
	     */
	    function baseAssignIn(object, source) {
	      return object && copyObject(source, keysIn(source), object);
	    }
	
	    /**
	     * The base implementation of `assignValue` and `assignMergeValue` without
	     * value checks.
	     *
	     * @private
	     * @param {Object} object The object to modify.
	     * @param {string} key The key of the property to assign.
	     * @param {*} value The value to assign.
	     */
	    function baseAssignValue(object, key, value) {
	      if (key == '__proto__' && defineProperty) {
	        defineProperty(object, key, {
	          'configurable': true,
	          'enumerable': true,
	          'value': value,
	          'writable': true
	        });
	      } else {
	        object[key] = value;
	      }
	    }
	
	    /**
	     * The base implementation of `_.at` without support for individual paths.
	     *
	     * @private
	     * @param {Object} object The object to iterate over.
	     * @param {string[]} paths The property paths to pick.
	     * @returns {Array} Returns the picked elements.
	     */
	    function baseAt(object, paths) {
	      var index = -1,
	          length = paths.length,
	          result = Array(length),
	          skip = object == null;
	
	      while (++index < length) {
	        result[index] = skip ? undefined : get(object, paths[index]);
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.clamp` which doesn't coerce arguments.
	     *
	     * @private
	     * @param {number} number The number to clamp.
	     * @param {number} [lower] The lower bound.
	     * @param {number} upper The upper bound.
	     * @returns {number} Returns the clamped number.
	     */
	    function baseClamp(number, lower, upper) {
	      if (number === number) {
	        if (upper !== undefined) {
	          number = number <= upper ? number : upper;
	        }
	        if (lower !== undefined) {
	          number = number >= lower ? number : lower;
	        }
	      }
	      return number;
	    }
	
	    /**
	     * The base implementation of `_.clone` and `_.cloneDeep` which tracks
	     * traversed objects.
	     *
	     * @private
	     * @param {*} value The value to clone.
	     * @param {boolean} bitmask The bitmask flags.
	     *  1 - Deep clone
	     *  2 - Flatten inherited properties
	     *  4 - Clone symbols
	     * @param {Function} [customizer] The function to customize cloning.
	     * @param {string} [key] The key of `value`.
	     * @param {Object} [object] The parent object of `value`.
	     * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
	     * @returns {*} Returns the cloned value.
	     */
	    function baseClone(value, bitmask, customizer, key, object, stack) {
	      var result,
	          isDeep = bitmask & CLONE_DEEP_FLAG,
	          isFlat = bitmask & CLONE_FLAT_FLAG,
	          isFull = bitmask & CLONE_SYMBOLS_FLAG;
	
	      if (customizer) {
	        result = object ? customizer(value, key, object, stack) : customizer(value);
	      }
	      if (result !== undefined) {
	        return result;
	      }
	      if (!isObject(value)) {
	        return value;
	      }
	      var isArr = isArray(value);
	      if (isArr) {
	        result = initCloneArray(value);
	        if (!isDeep) {
	          return copyArray(value, result);
	        }
	      } else {
	        var tag = getTag(value),
	            isFunc = tag == funcTag || tag == genTag;
	
	        if (isBuffer(value)) {
	          return cloneBuffer(value, isDeep);
	        }
	        if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
	          result = (isFlat || isFunc) ? {} : initCloneObject(value);
	          if (!isDeep) {
	            return isFlat
	              ? copySymbolsIn(value, baseAssignIn(result, value))
	              : copySymbols(value, baseAssign(result, value));
	          }
	        } else {
	          if (!cloneableTags[tag]) {
	            return object ? value : {};
	          }
	          result = initCloneByTag(value, tag, baseClone, isDeep);
	        }
	      }
	      // Check for circular references and return its corresponding clone.
	      stack || (stack = new Stack);
	      var stacked = stack.get(value);
	      if (stacked) {
	        return stacked;
	      }
	      stack.set(value, result);
	
	      var keysFunc = isFull
	        ? (isFlat ? getAllKeysIn : getAllKeys)
	        : (isFlat ? keysIn : keys);
	
	      var props = isArr ? undefined : keysFunc(value);
	      arrayEach(props || value, function(subValue, key) {
	        if (props) {
	          key = subValue;
	          subValue = value[key];
	        }
	        // Recursively populate clone (susceptible to call stack limits).
	        assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
	      });
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.conforms` which doesn't clone `source`.
	     *
	     * @private
	     * @param {Object} source The object of property predicates to conform to.
	     * @returns {Function} Returns the new spec function.
	     */
	    function baseConforms(source) {
	      var props = keys(source);
	      return function(object) {
	        return baseConformsTo(object, source, props);
	      };
	    }
	
	    /**
	     * The base implementation of `_.conformsTo` which accepts `props` to check.
	     *
	     * @private
	     * @param {Object} object The object to inspect.
	     * @param {Object} source The object of property predicates to conform to.
	     * @returns {boolean} Returns `true` if `object` conforms, else `false`.
	     */
	    function baseConformsTo(object, source, props) {
	      var length = props.length;
	      if (object == null) {
	        return !length;
	      }
	      object = Object(object);
	      while (length--) {
	        var key = props[length],
	            predicate = source[key],
	            value = object[key];
	
	        if ((value === undefined && !(key in object)) || !predicate(value)) {
	          return false;
	        }
	      }
	      return true;
	    }
	
	    /**
	     * The base implementation of `_.delay` and `_.defer` which accepts `args`
	     * to provide to `func`.
	     *
	     * @private
	     * @param {Function} func The function to delay.
	     * @param {number} wait The number of milliseconds to delay invocation.
	     * @param {Array} args The arguments to provide to `func`.
	     * @returns {number|Object} Returns the timer id or timeout object.
	     */
	    function baseDelay(func, wait, args) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      return setTimeout(function() { func.apply(undefined, args); }, wait);
	    }
	
	    /**
	     * The base implementation of methods like `_.difference` without support
	     * for excluding multiple arrays or iteratee shorthands.
	     *
	     * @private
	     * @param {Array} array The array to inspect.
	     * @param {Array} values The values to exclude.
	     * @param {Function} [iteratee] The iteratee invoked per element.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new array of filtered values.
	     */
	    function baseDifference(array, values, iteratee, comparator) {
	      var index = -1,
	          includes = arrayIncludes,
	          isCommon = true,
	          length = array.length,
	          result = [],
	          valuesLength = values.length;
	
	      if (!length) {
	        return result;
	      }
	      if (iteratee) {
	        values = arrayMap(values, baseUnary(iteratee));
	      }
	      if (comparator) {
	        includes = arrayIncludesWith;
	        isCommon = false;
	      }
	      else if (values.length >= LARGE_ARRAY_SIZE) {
	        includes = cacheHas;
	        isCommon = false;
	        values = new SetCache(values);
	      }
	      outer:
	      while (++index < length) {
	        var value = array[index],
	            computed = iteratee == null ? value : iteratee(value);
	
	        value = (comparator || value !== 0) ? value : 0;
	        if (isCommon && computed === computed) {
	          var valuesIndex = valuesLength;
	          while (valuesIndex--) {
	            if (values[valuesIndex] === computed) {
	              continue outer;
	            }
	          }
	          result.push(value);
	        }
	        else if (!includes(values, computed, comparator)) {
	          result.push(value);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.forEach` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} iteratee The function invoked per iteration.
	     * @returns {Array|Object} Returns `collection`.
	     */
	    var baseEach = createBaseEach(baseForOwn);
	
	    /**
	     * The base implementation of `_.forEachRight` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} iteratee The function invoked per iteration.
	     * @returns {Array|Object} Returns `collection`.
	     */
	    var baseEachRight = createBaseEach(baseForOwnRight, true);
	
	    /**
	     * The base implementation of `_.every` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} predicate The function invoked per iteration.
	     * @returns {boolean} Returns `true` if all elements pass the predicate check,
	     *  else `false`
	     */
	    function baseEvery(collection, predicate) {
	      var result = true;
	      baseEach(collection, function(value, index, collection) {
	        result = !!predicate(value, index, collection);
	        return result;
	      });
	      return result;
	    }
	
	    /**
	     * The base implementation of methods like `_.max` and `_.min` which accepts a
	     * `comparator` to determine the extremum value.
	     *
	     * @private
	     * @param {Array} array The array to iterate over.
	     * @param {Function} iteratee The iteratee invoked per iteration.
	     * @param {Function} comparator The comparator used to compare values.
	     * @returns {*} Returns the extremum value.
	     */
	    function baseExtremum(array, iteratee, comparator) {
	      var index = -1,
	          length = array.length;
	
	      while (++index < length) {
	        var value = array[index],
	            current = iteratee(value);
	
	        if (current != null && (computed === undefined
	              ? (current === current && !isSymbol(current))
	              : comparator(current, computed)
	            )) {
	          var computed = current,
	              result = value;
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.fill` without an iteratee call guard.
	     *
	     * @private
	     * @param {Array} array The array to fill.
	     * @param {*} value The value to fill `array` with.
	     * @param {number} [start=0] The start position.
	     * @param {number} [end=array.length] The end position.
	     * @returns {Array} Returns `array`.
	     */
	    function baseFill(array, value, start, end) {
	      var length = array.length;
	
	      start = toInteger(start);
	      if (start < 0) {
	        start = -start > length ? 0 : (length + start);
	      }
	      end = (end === undefined || end > length) ? length : toInteger(end);
	      if (end < 0) {
	        end += length;
	      }
	      end = start > end ? 0 : toLength(end);
	      while (start < end) {
	        array[start++] = value;
	      }
	      return array;
	    }
	
	    /**
	     * The base implementation of `_.filter` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} predicate The function invoked per iteration.
	     * @returns {Array} Returns the new filtered array.
	     */
	    function baseFilter(collection, predicate) {
	      var result = [];
	      baseEach(collection, function(value, index, collection) {
	        if (predicate(value, index, collection)) {
	          result.push(value);
	        }
	      });
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.flatten` with support for restricting flattening.
	     *
	     * @private
	     * @param {Array} array The array to flatten.
	     * @param {number} depth The maximum recursion depth.
	     * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
	     * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
	     * @param {Array} [result=[]] The initial result value.
	     * @returns {Array} Returns the new flattened array.
	     */
	    function baseFlatten(array, depth, predicate, isStrict, result) {
	      var index = -1,
	          length = array.length;
	
	      predicate || (predicate = isFlattenable);
	      result || (result = []);
	
	      while (++index < length) {
	        var value = array[index];
	        if (depth > 0 && predicate(value)) {
	          if (depth > 1) {
	            // Recursively flatten arrays (susceptible to call stack limits).
	            baseFlatten(value, depth - 1, predicate, isStrict, result);
	          } else {
	            arrayPush(result, value);
	          }
	        } else if (!isStrict) {
	          result[result.length] = value;
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `baseForOwn` which iterates over `object`
	     * properties returned by `keysFunc` and invokes `iteratee` for each property.
	     * Iteratee functions may exit iteration early by explicitly returning `false`.
	     *
	     * @private
	     * @param {Object} object The object to iterate over.
	     * @param {Function} iteratee The function invoked per iteration.
	     * @param {Function} keysFunc The function to get the keys of `object`.
	     * @returns {Object} Returns `object`.
	     */
	    var baseFor = createBaseFor();
	
	    /**
	     * This function is like `baseFor` except that it iterates over properties
	     * in the opposite order.
	     *
	     * @private
	     * @param {Object} object The object to iterate over.
	     * @param {Function} iteratee The function invoked per iteration.
	     * @param {Function} keysFunc The function to get the keys of `object`.
	     * @returns {Object} Returns `object`.
	     */
	    var baseForRight = createBaseFor(true);
	
	    /**
	     * The base implementation of `_.forOwn` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Object} object The object to iterate over.
	     * @param {Function} iteratee The function invoked per iteration.
	     * @returns {Object} Returns `object`.
	     */
	    function baseForOwn(object, iteratee) {
	      return object && baseFor(object, iteratee, keys);
	    }
	
	    /**
	     * The base implementation of `_.forOwnRight` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Object} object The object to iterate over.
	     * @param {Function} iteratee The function invoked per iteration.
	     * @returns {Object} Returns `object`.
	     */
	    function baseForOwnRight(object, iteratee) {
	      return object && baseForRight(object, iteratee, keys);
	    }
	
	    /**
	     * The base implementation of `_.functions` which creates an array of
	     * `object` function property names filtered from `props`.
	     *
	     * @private
	     * @param {Object} object The object to inspect.
	     * @param {Array} props The property names to filter.
	     * @returns {Array} Returns the function names.
	     */
	    function baseFunctions(object, props) {
	      return arrayFilter(props, function(key) {
	        return isFunction(object[key]);
	      });
	    }
	
	    /**
	     * The base implementation of `_.get` without support for default values.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path of the property to get.
	     * @returns {*} Returns the resolved value.
	     */
	    function baseGet(object, path) {
	      path = castPath(path, object);
	
	      var index = 0,
	          length = path.length;
	
	      while (object != null && index < length) {
	        object = object[toKey(path[index++])];
	      }
	      return (index && index == length) ? object : undefined;
	    }
	
	    /**
	     * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
	     * `keysFunc` and `symbolsFunc` to get the enumerable property names and
	     * symbols of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @param {Function} keysFunc The function to get the keys of `object`.
	     * @param {Function} symbolsFunc The function to get the symbols of `object`.
	     * @returns {Array} Returns the array of property names and symbols.
	     */
	    function baseGetAllKeys(object, keysFunc, symbolsFunc) {
	      var result = keysFunc(object);
	      return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
	    }
	
	    /**
	     * The base implementation of `getTag` without fallbacks for buggy environments.
	     *
	     * @private
	     * @param {*} value The value to query.
	     * @returns {string} Returns the `toStringTag`.
	     */
	    function baseGetTag(value) {
	      if (value == null) {
	        return value === undefined ? undefinedTag : nullTag;
	      }
	      return (symToStringTag && symToStringTag in Object(value))
	        ? getRawTag(value)
	        : objectToString(value);
	    }
	
	    /**
	     * The base implementation of `_.gt` which doesn't coerce arguments.
	     *
	     * @private
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if `value` is greater than `other`,
	     *  else `false`.
	     */
	    function baseGt(value, other) {
	      return value > other;
	    }
	
	    /**
	     * The base implementation of `_.has` without support for deep paths.
	     *
	     * @private
	     * @param {Object} [object] The object to query.
	     * @param {Array|string} key The key to check.
	     * @returns {boolean} Returns `true` if `key` exists, else `false`.
	     */
	    function baseHas(object, key) {
	      return object != null && hasOwnProperty.call(object, key);
	    }
	
	    /**
	     * The base implementation of `_.hasIn` without support for deep paths.
	     *
	     * @private
	     * @param {Object} [object] The object to query.
	     * @param {Array|string} key The key to check.
	     * @returns {boolean} Returns `true` if `key` exists, else `false`.
	     */
	    function baseHasIn(object, key) {
	      return object != null && key in Object(object);
	    }
	
	    /**
	     * The base implementation of `_.inRange` which doesn't coerce arguments.
	     *
	     * @private
	     * @param {number} number The number to check.
	     * @param {number} start The start of the range.
	     * @param {number} end The end of the range.
	     * @returns {boolean} Returns `true` if `number` is in the range, else `false`.
	     */
	    function baseInRange(number, start, end) {
	      return number >= nativeMin(start, end) && number < nativeMax(start, end);
	    }
	
	    /**
	     * The base implementation of methods like `_.intersection`, without support
	     * for iteratee shorthands, that accepts an array of arrays to inspect.
	     *
	     * @private
	     * @param {Array} arrays The arrays to inspect.
	     * @param {Function} [iteratee] The iteratee invoked per element.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new array of shared values.
	     */
	    function baseIntersection(arrays, iteratee, comparator) {
	      var includes = comparator ? arrayIncludesWith : arrayIncludes,
	          length = arrays[0].length,
	          othLength = arrays.length,
	          othIndex = othLength,
	          caches = Array(othLength),
	          maxLength = Infinity,
	          result = [];
	
	      while (othIndex--) {
	        var array = arrays[othIndex];
	        if (othIndex && iteratee) {
	          array = arrayMap(array, baseUnary(iteratee));
	        }
	        maxLength = nativeMin(array.length, maxLength);
	        caches[othIndex] = !comparator && (iteratee || (length >= 120 && array.length >= 120))
	          ? new SetCache(othIndex && array)
	          : undefined;
	      }
	      array = arrays[0];
	
	      var index = -1,
	          seen = caches[0];
	
	      outer:
	      while (++index < length && result.length < maxLength) {
	        var value = array[index],
	            computed = iteratee ? iteratee(value) : value;
	
	        value = (comparator || value !== 0) ? value : 0;
	        if (!(seen
	              ? cacheHas(seen, computed)
	              : includes(result, computed, comparator)
	            )) {
	          othIndex = othLength;
	          while (--othIndex) {
	            var cache = caches[othIndex];
	            if (!(cache
	                  ? cacheHas(cache, computed)
	                  : includes(arrays[othIndex], computed, comparator))
	                ) {
	              continue outer;
	            }
	          }
	          if (seen) {
	            seen.push(computed);
	          }
	          result.push(value);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.invert` and `_.invertBy` which inverts
	     * `object` with values transformed by `iteratee` and set by `setter`.
	     *
	     * @private
	     * @param {Object} object The object to iterate over.
	     * @param {Function} setter The function to set `accumulator` values.
	     * @param {Function} iteratee The iteratee to transform values.
	     * @param {Object} accumulator The initial inverted object.
	     * @returns {Function} Returns `accumulator`.
	     */
	    function baseInverter(object, setter, iteratee, accumulator) {
	      baseForOwn(object, function(value, key, object) {
	        setter(accumulator, iteratee(value), key, object);
	      });
	      return accumulator;
	    }
	
	    /**
	     * The base implementation of `_.invoke` without support for individual
	     * method arguments.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path of the method to invoke.
	     * @param {Array} args The arguments to invoke the method with.
	     * @returns {*} Returns the result of the invoked method.
	     */
	    function baseInvoke(object, path, args) {
	      path = castPath(path, object);
	      object = parent(object, path);
	      var func = object == null ? object : object[toKey(last(path))];
	      return func == null ? undefined : apply(func, object, args);
	    }
	
	    /**
	     * The base implementation of `_.isArguments`.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
	     */
	    function baseIsArguments(value) {
	      return isObjectLike(value) && baseGetTag(value) == argsTag;
	    }
	
	    /**
	     * The base implementation of `_.isArrayBuffer` without Node.js optimizations.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an array buffer, else `false`.
	     */
	    function baseIsArrayBuffer(value) {
	      return isObjectLike(value) && baseGetTag(value) == arrayBufferTag;
	    }
	
	    /**
	     * The base implementation of `_.isDate` without Node.js optimizations.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a date object, else `false`.
	     */
	    function baseIsDate(value) {
	      return isObjectLike(value) && baseGetTag(value) == dateTag;
	    }
	
	    /**
	     * The base implementation of `_.isEqual` which supports partial comparisons
	     * and tracks traversed objects.
	     *
	     * @private
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @param {boolean} bitmask The bitmask flags.
	     *  1 - Unordered comparison
	     *  2 - Partial comparison
	     * @param {Function} [customizer] The function to customize comparisons.
	     * @param {Object} [stack] Tracks traversed `value` and `other` objects.
	     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	     */
	    function baseIsEqual(value, other, bitmask, customizer, stack) {
	      if (value === other) {
	        return true;
	      }
	      if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
	        return value !== value && other !== other;
	      }
	      return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
	    }
	
	    /**
	     * A specialized version of `baseIsEqual` for arrays and objects which performs
	     * deep comparisons and tracks traversed objects enabling objects with circular
	     * references to be compared.
	     *
	     * @private
	     * @param {Object} object The object to compare.
	     * @param {Object} other The other object to compare.
	     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
	     * @param {Function} customizer The function to customize comparisons.
	     * @param {Function} equalFunc The function to determine equivalents of values.
	     * @param {Object} [stack] Tracks traversed `object` and `other` objects.
	     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
	     */
	    function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
	      var objIsArr = isArray(object),
	          othIsArr = isArray(other),
	          objTag = objIsArr ? arrayTag : getTag(object),
	          othTag = othIsArr ? arrayTag : getTag(other);
	
	      objTag = objTag == argsTag ? objectTag : objTag;
	      othTag = othTag == argsTag ? objectTag : othTag;
	
	      var objIsObj = objTag == objectTag,
	          othIsObj = othTag == objectTag,
	          isSameTag = objTag == othTag;
	
	      if (isSameTag && isBuffer(object)) {
	        if (!isBuffer(other)) {
	          return false;
	        }
	        objIsArr = true;
	        objIsObj = false;
	      }
	      if (isSameTag && !objIsObj) {
	        stack || (stack = new Stack);
	        return (objIsArr || isTypedArray(object))
	          ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
	          : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
	      }
	      if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
	        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
	            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');
	
	        if (objIsWrapped || othIsWrapped) {
	          var objUnwrapped = objIsWrapped ? object.value() : object,
	              othUnwrapped = othIsWrapped ? other.value() : other;
	
	          stack || (stack = new Stack);
	          return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
	        }
	      }
	      if (!isSameTag) {
	        return false;
	      }
	      stack || (stack = new Stack);
	      return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
	    }
	
	    /**
	     * The base implementation of `_.isMap` without Node.js optimizations.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a map, else `false`.
	     */
	    function baseIsMap(value) {
	      return isObjectLike(value) && getTag(value) == mapTag;
	    }
	
	    /**
	     * The base implementation of `_.isMatch` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Object} object The object to inspect.
	     * @param {Object} source The object of property values to match.
	     * @param {Array} matchData The property names, values, and compare flags to match.
	     * @param {Function} [customizer] The function to customize comparisons.
	     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
	     */
	    function baseIsMatch(object, source, matchData, customizer) {
	      var index = matchData.length,
	          length = index,
	          noCustomizer = !customizer;
	
	      if (object == null) {
	        return !length;
	      }
	      object = Object(object);
	      while (index--) {
	        var data = matchData[index];
	        if ((noCustomizer && data[2])
	              ? data[1] !== object[data[0]]
	              : !(data[0] in object)
	            ) {
	          return false;
	        }
	      }
	      while (++index < length) {
	        data = matchData[index];
	        var key = data[0],
	            objValue = object[key],
	            srcValue = data[1];
	
	        if (noCustomizer && data[2]) {
	          if (objValue === undefined && !(key in object)) {
	            return false;
	          }
	        } else {
	          var stack = new Stack;
	          if (customizer) {
	            var result = customizer(objValue, srcValue, key, object, source, stack);
	          }
	          if (!(result === undefined
	                ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
	                : result
	              )) {
	            return false;
	          }
	        }
	      }
	      return true;
	    }
	
	    /**
	     * The base implementation of `_.isNative` without bad shim checks.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a native function,
	     *  else `false`.
	     */
	    function baseIsNative(value) {
	      if (!isObject(value) || isMasked(value)) {
	        return false;
	      }
	      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
	      return pattern.test(toSource(value));
	    }
	
	    /**
	     * The base implementation of `_.isRegExp` without Node.js optimizations.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
	     */
	    function baseIsRegExp(value) {
	      return isObjectLike(value) && baseGetTag(value) == regexpTag;
	    }
	
	    /**
	     * The base implementation of `_.isSet` without Node.js optimizations.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a set, else `false`.
	     */
	    function baseIsSet(value) {
	      return isObjectLike(value) && getTag(value) == setTag;
	    }
	
	    /**
	     * The base implementation of `_.isTypedArray` without Node.js optimizations.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
	     */
	    function baseIsTypedArray(value) {
	      return isObjectLike(value) &&
	        isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
	    }
	
	    /**
	     * The base implementation of `_.iteratee`.
	     *
	     * @private
	     * @param {*} [value=_.identity] The value to convert to an iteratee.
	     * @returns {Function} Returns the iteratee.
	     */
	    function baseIteratee(value) {
	      // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
	      // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
	      if (typeof value == 'function') {
	        return value;
	      }
	      if (value == null) {
	        return identity;
	      }
	      if (typeof value == 'object') {
	        return isArray(value)
	          ? baseMatchesProperty(value[0], value[1])
	          : baseMatches(value);
	      }
	      return property(value);
	    }
	
	    /**
	     * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property names.
	     */
	    function baseKeys(object) {
	      if (!isPrototype(object)) {
	        return nativeKeys(object);
	      }
	      var result = [];
	      for (var key in Object(object)) {
	        if (hasOwnProperty.call(object, key) && key != 'constructor') {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property names.
	     */
	    function baseKeysIn(object) {
	      if (!isObject(object)) {
	        return nativeKeysIn(object);
	      }
	      var isProto = isPrototype(object),
	          result = [];
	
	      for (var key in object) {
	        if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.lt` which doesn't coerce arguments.
	     *
	     * @private
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if `value` is less than `other`,
	     *  else `false`.
	     */
	    function baseLt(value, other) {
	      return value < other;
	    }
	
	    /**
	     * The base implementation of `_.map` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} iteratee The function invoked per iteration.
	     * @returns {Array} Returns the new mapped array.
	     */
	    function baseMap(collection, iteratee) {
	      var index = -1,
	          result = isArrayLike(collection) ? Array(collection.length) : [];
	
	      baseEach(collection, function(value, key, collection) {
	        result[++index] = iteratee(value, key, collection);
	      });
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.matches` which doesn't clone `source`.
	     *
	     * @private
	     * @param {Object} source The object of property values to match.
	     * @returns {Function} Returns the new spec function.
	     */
	    function baseMatches(source) {
	      var matchData = getMatchData(source);
	      if (matchData.length == 1 && matchData[0][2]) {
	        return matchesStrictComparable(matchData[0][0], matchData[0][1]);
	      }
	      return function(object) {
	        return object === source || baseIsMatch(object, source, matchData);
	      };
	    }
	
	    /**
	     * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
	     *
	     * @private
	     * @param {string} path The path of the property to get.
	     * @param {*} srcValue The value to match.
	     * @returns {Function} Returns the new spec function.
	     */
	    function baseMatchesProperty(path, srcValue) {
	      if (isKey(path) && isStrictComparable(srcValue)) {
	        return matchesStrictComparable(toKey(path), srcValue);
	      }
	      return function(object) {
	        var objValue = get(object, path);
	        return (objValue === undefined && objValue === srcValue)
	          ? hasIn(object, path)
	          : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
	      };
	    }
	
	    /**
	     * The base implementation of `_.merge` without support for multiple sources.
	     *
	     * @private
	     * @param {Object} object The destination object.
	     * @param {Object} source The source object.
	     * @param {number} srcIndex The index of `source`.
	     * @param {Function} [customizer] The function to customize merged values.
	     * @param {Object} [stack] Tracks traversed source values and their merged
	     *  counterparts.
	     */
	    function baseMerge(object, source, srcIndex, customizer, stack) {
	      if (object === source) {
	        return;
	      }
	      baseFor(source, function(srcValue, key) {
	        if (isObject(srcValue)) {
	          stack || (stack = new Stack);
	          baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
	        }
	        else {
	          var newValue = customizer
	            ? customizer(object[key], srcValue, (key + ''), object, source, stack)
	            : undefined;
	
	          if (newValue === undefined) {
	            newValue = srcValue;
	          }
	          assignMergeValue(object, key, newValue);
	        }
	      }, keysIn);
	    }
	
	    /**
	     * A specialized version of `baseMerge` for arrays and objects which performs
	     * deep merges and tracks traversed objects enabling objects with circular
	     * references to be merged.
	     *
	     * @private
	     * @param {Object} object The destination object.
	     * @param {Object} source The source object.
	     * @param {string} key The key of the value to merge.
	     * @param {number} srcIndex The index of `source`.
	     * @param {Function} mergeFunc The function to merge values.
	     * @param {Function} [customizer] The function to customize assigned values.
	     * @param {Object} [stack] Tracks traversed source values and their merged
	     *  counterparts.
	     */
	    function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
	      var objValue = object[key],
	          srcValue = source[key],
	          stacked = stack.get(srcValue);
	
	      if (stacked) {
	        assignMergeValue(object, key, stacked);
	        return;
	      }
	      var newValue = customizer
	        ? customizer(objValue, srcValue, (key + ''), object, source, stack)
	        : undefined;
	
	      var isCommon = newValue === undefined;
	
	      if (isCommon) {
	        var isArr = isArray(srcValue),
	            isBuff = !isArr && isBuffer(srcValue),
	            isTyped = !isArr && !isBuff && isTypedArray(srcValue);
	
	        newValue = srcValue;
	        if (isArr || isBuff || isTyped) {
	          if (isArray(objValue)) {
	            newValue = objValue;
	          }
	          else if (isArrayLikeObject(objValue)) {
	            newValue = copyArray(objValue);
	          }
	          else if (isBuff) {
	            isCommon = false;
	            newValue = cloneBuffer(srcValue, true);
	          }
	          else if (isTyped) {
	            isCommon = false;
	            newValue = cloneTypedArray(srcValue, true);
	          }
	          else {
	            newValue = [];
	          }
	        }
	        else if (isPlainObject(srcValue) || isArguments(srcValue)) {
	          newValue = objValue;
	          if (isArguments(objValue)) {
	            newValue = toPlainObject(objValue);
	          }
	          else if (!isObject(objValue) || (srcIndex && isFunction(objValue))) {
	            newValue = initCloneObject(srcValue);
	          }
	        }
	        else {
	          isCommon = false;
	        }
	      }
	      if (isCommon) {
	        // Recursively merge objects and arrays (susceptible to call stack limits).
	        stack.set(srcValue, newValue);
	        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
	        stack['delete'](srcValue);
	      }
	      assignMergeValue(object, key, newValue);
	    }
	
	    /**
	     * The base implementation of `_.nth` which doesn't coerce arguments.
	     *
	     * @private
	     * @param {Array} array The array to query.
	     * @param {number} n The index of the element to return.
	     * @returns {*} Returns the nth element of `array`.
	     */
	    function baseNth(array, n) {
	      var length = array.length;
	      if (!length) {
	        return;
	      }
	      n += n < 0 ? length : 0;
	      return isIndex(n, length) ? array[n] : undefined;
	    }
	
	    /**
	     * The base implementation of `_.orderBy` without param guards.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
	     * @param {string[]} orders The sort orders of `iteratees`.
	     * @returns {Array} Returns the new sorted array.
	     */
	    function baseOrderBy(collection, iteratees, orders) {
	      var index = -1;
	      iteratees = arrayMap(iteratees.length ? iteratees : [identity], baseUnary(getIteratee()));
	
	      var result = baseMap(collection, function(value, key, collection) {
	        var criteria = arrayMap(iteratees, function(iteratee) {
	          return iteratee(value);
	        });
	        return { 'criteria': criteria, 'index': ++index, 'value': value };
	      });
	
	      return baseSortBy(result, function(object, other) {
	        return compareMultiple(object, other, orders);
	      });
	    }
	
	    /**
	     * The base implementation of `_.pick` without support for individual
	     * property identifiers.
	     *
	     * @private
	     * @param {Object} object The source object.
	     * @param {string[]} paths The property paths to pick.
	     * @returns {Object} Returns the new object.
	     */
	    function basePick(object, paths) {
	      return basePickBy(object, paths, function(value, path) {
	        return hasIn(object, path);
	      });
	    }
	
	    /**
	     * The base implementation of  `_.pickBy` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Object} object The source object.
	     * @param {string[]} paths The property paths to pick.
	     * @param {Function} predicate The function invoked per property.
	     * @returns {Object} Returns the new object.
	     */
	    function basePickBy(object, paths, predicate) {
	      var index = -1,
	          length = paths.length,
	          result = {};
	
	      while (++index < length) {
	        var path = paths[index],
	            value = baseGet(object, path);
	
	        if (predicate(value, path)) {
	          baseSet(result, castPath(path, object), value);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * A specialized version of `baseProperty` which supports deep paths.
	     *
	     * @private
	     * @param {Array|string} path The path of the property to get.
	     * @returns {Function} Returns the new accessor function.
	     */
	    function basePropertyDeep(path) {
	      return function(object) {
	        return baseGet(object, path);
	      };
	    }
	
	    /**
	     * The base implementation of `_.pullAllBy` without support for iteratee
	     * shorthands.
	     *
	     * @private
	     * @param {Array} array The array to modify.
	     * @param {Array} values The values to remove.
	     * @param {Function} [iteratee] The iteratee invoked per element.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns `array`.
	     */
	    function basePullAll(array, values, iteratee, comparator) {
	      var indexOf = comparator ? baseIndexOfWith : baseIndexOf,
	          index = -1,
	          length = values.length,
	          seen = array;
	
	      if (array === values) {
	        values = copyArray(values);
	      }
	      if (iteratee) {
	        seen = arrayMap(array, baseUnary(iteratee));
	      }
	      while (++index < length) {
	        var fromIndex = 0,
	            value = values[index],
	            computed = iteratee ? iteratee(value) : value;
	
	        while ((fromIndex = indexOf(seen, computed, fromIndex, comparator)) > -1) {
	          if (seen !== array) {
	            splice.call(seen, fromIndex, 1);
	          }
	          splice.call(array, fromIndex, 1);
	        }
	      }
	      return array;
	    }
	
	    /**
	     * The base implementation of `_.pullAt` without support for individual
	     * indexes or capturing the removed elements.
	     *
	     * @private
	     * @param {Array} array The array to modify.
	     * @param {number[]} indexes The indexes of elements to remove.
	     * @returns {Array} Returns `array`.
	     */
	    function basePullAt(array, indexes) {
	      var length = array ? indexes.length : 0,
	          lastIndex = length - 1;
	
	      while (length--) {
	        var index = indexes[length];
	        if (length == lastIndex || index !== previous) {
	          var previous = index;
	          if (isIndex(index)) {
	            splice.call(array, index, 1);
	          } else {
	            baseUnset(array, index);
	          }
	        }
	      }
	      return array;
	    }
	
	    /**
	     * The base implementation of `_.random` without support for returning
	     * floating-point numbers.
	     *
	     * @private
	     * @param {number} lower The lower bound.
	     * @param {number} upper The upper bound.
	     * @returns {number} Returns the random number.
	     */
	    function baseRandom(lower, upper) {
	      return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
	    }
	
	    /**
	     * The base implementation of `_.range` and `_.rangeRight` which doesn't
	     * coerce arguments.
	     *
	     * @private
	     * @param {number} start The start of the range.
	     * @param {number} end The end of the range.
	     * @param {number} step The value to increment or decrement by.
	     * @param {boolean} [fromRight] Specify iterating from right to left.
	     * @returns {Array} Returns the range of numbers.
	     */
	    function baseRange(start, end, step, fromRight) {
	      var index = -1,
	          length = nativeMax(nativeCeil((end - start) / (step || 1)), 0),
	          result = Array(length);
	
	      while (length--) {
	        result[fromRight ? length : ++index] = start;
	        start += step;
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.repeat` which doesn't coerce arguments.
	     *
	     * @private
	     * @param {string} string The string to repeat.
	     * @param {number} n The number of times to repeat the string.
	     * @returns {string} Returns the repeated string.
	     */
	    function baseRepeat(string, n) {
	      var result = '';
	      if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
	        return result;
	      }
	      // Leverage the exponentiation by squaring algorithm for a faster repeat.
	      // See https://en.wikipedia.org/wiki/Exponentiation_by_squaring for more details.
	      do {
	        if (n % 2) {
	          result += string;
	        }
	        n = nativeFloor(n / 2);
	        if (n) {
	          string += string;
	        }
	      } while (n);
	
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.rest` which doesn't validate or coerce arguments.
	     *
	     * @private
	     * @param {Function} func The function to apply a rest parameter to.
	     * @param {number} [start=func.length-1] The start position of the rest parameter.
	     * @returns {Function} Returns the new function.
	     */
	    function baseRest(func, start) {
	      return setToString(overRest(func, start, identity), func + '');
	    }
	
	    /**
	     * The base implementation of `_.sample`.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to sample.
	     * @returns {*} Returns the random element.
	     */
	    function baseSample(collection) {
	      return arraySample(values(collection));
	    }
	
	    /**
	     * The base implementation of `_.sampleSize` without param guards.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to sample.
	     * @param {number} n The number of elements to sample.
	     * @returns {Array} Returns the random elements.
	     */
	    function baseSampleSize(collection, n) {
	      var array = values(collection);
	      return shuffleSelf(array, baseClamp(n, 0, array.length));
	    }
	
	    /**
	     * The base implementation of `_.set`.
	     *
	     * @private
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The path of the property to set.
	     * @param {*} value The value to set.
	     * @param {Function} [customizer] The function to customize path creation.
	     * @returns {Object} Returns `object`.
	     */
	    function baseSet(object, path, value, customizer) {
	      if (!isObject(object)) {
	        return object;
	      }
	      path = castPath(path, object);
	
	      var index = -1,
	          length = path.length,
	          lastIndex = length - 1,
	          nested = object;
	
	      while (nested != null && ++index < length) {
	        var key = toKey(path[index]),
	            newValue = value;
	
	        if (index != lastIndex) {
	          var objValue = nested[key];
	          newValue = customizer ? customizer(objValue, key, nested) : undefined;
	          if (newValue === undefined) {
	            newValue = isObject(objValue)
	              ? objValue
	              : (isIndex(path[index + 1]) ? [] : {});
	          }
	        }
	        assignValue(nested, key, newValue);
	        nested = nested[key];
	      }
	      return object;
	    }
	
	    /**
	     * The base implementation of `setData` without support for hot loop shorting.
	     *
	     * @private
	     * @param {Function} func The function to associate metadata with.
	     * @param {*} data The metadata.
	     * @returns {Function} Returns `func`.
	     */
	    var baseSetData = !metaMap ? identity : function(func, data) {
	      metaMap.set(func, data);
	      return func;
	    };
	
	    /**
	     * The base implementation of `setToString` without support for hot loop shorting.
	     *
	     * @private
	     * @param {Function} func The function to modify.
	     * @param {Function} string The `toString` result.
	     * @returns {Function} Returns `func`.
	     */
	    var baseSetToString = !defineProperty ? identity : function(func, string) {
	      return defineProperty(func, 'toString', {
	        'configurable': true,
	        'enumerable': false,
	        'value': constant(string),
	        'writable': true
	      });
	    };
	
	    /**
	     * The base implementation of `_.shuffle`.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to shuffle.
	     * @returns {Array} Returns the new shuffled array.
	     */
	    function baseShuffle(collection) {
	      return shuffleSelf(values(collection));
	    }
	
	    /**
	     * The base implementation of `_.slice` without an iteratee call guard.
	     *
	     * @private
	     * @param {Array} array The array to slice.
	     * @param {number} [start=0] The start position.
	     * @param {number} [end=array.length] The end position.
	     * @returns {Array} Returns the slice of `array`.
	     */
	    function baseSlice(array, start, end) {
	      var index = -1,
	          length = array.length;
	
	      if (start < 0) {
	        start = -start > length ? 0 : (length + start);
	      }
	      end = end > length ? length : end;
	      if (end < 0) {
	        end += length;
	      }
	      length = start > end ? 0 : ((end - start) >>> 0);
	      start >>>= 0;
	
	      var result = Array(length);
	      while (++index < length) {
	        result[index] = array[index + start];
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.some` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} predicate The function invoked per iteration.
	     * @returns {boolean} Returns `true` if any element passes the predicate check,
	     *  else `false`.
	     */
	    function baseSome(collection, predicate) {
	      var result;
	
	      baseEach(collection, function(value, index, collection) {
	        result = predicate(value, index, collection);
	        return !result;
	      });
	      return !!result;
	    }
	
	    /**
	     * The base implementation of `_.sortedIndex` and `_.sortedLastIndex` which
	     * performs a binary search of `array` to determine the index at which `value`
	     * should be inserted into `array` in order to maintain its sort order.
	     *
	     * @private
	     * @param {Array} array The sorted array to inspect.
	     * @param {*} value The value to evaluate.
	     * @param {boolean} [retHighest] Specify returning the highest qualified index.
	     * @returns {number} Returns the index at which `value` should be inserted
	     *  into `array`.
	     */
	    function baseSortedIndex(array, value, retHighest) {
	      var low = 0,
	          high = array == null ? low : array.length;
	
	      if (typeof value == 'number' && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
	        while (low < high) {
	          var mid = (low + high) >>> 1,
	              computed = array[mid];
	
	          if (computed !== null && !isSymbol(computed) &&
	              (retHighest ? (computed <= value) : (computed < value))) {
	            low = mid + 1;
	          } else {
	            high = mid;
	          }
	        }
	        return high;
	      }
	      return baseSortedIndexBy(array, value, identity, retHighest);
	    }
	
	    /**
	     * The base implementation of `_.sortedIndexBy` and `_.sortedLastIndexBy`
	     * which invokes `iteratee` for `value` and each element of `array` to compute
	     * their sort ranking. The iteratee is invoked with one argument; (value).
	     *
	     * @private
	     * @param {Array} array The sorted array to inspect.
	     * @param {*} value The value to evaluate.
	     * @param {Function} iteratee The iteratee invoked per element.
	     * @param {boolean} [retHighest] Specify returning the highest qualified index.
	     * @returns {number} Returns the index at which `value` should be inserted
	     *  into `array`.
	     */
	    function baseSortedIndexBy(array, value, iteratee, retHighest) {
	      value = iteratee(value);
	
	      var low = 0,
	          high = array == null ? 0 : array.length,
	          valIsNaN = value !== value,
	          valIsNull = value === null,
	          valIsSymbol = isSymbol(value),
	          valIsUndefined = value === undefined;
	
	      while (low < high) {
	        var mid = nativeFloor((low + high) / 2),
	            computed = iteratee(array[mid]),
	            othIsDefined = computed !== undefined,
	            othIsNull = computed === null,
	            othIsReflexive = computed === computed,
	            othIsSymbol = isSymbol(computed);
	
	        if (valIsNaN) {
	          var setLow = retHighest || othIsReflexive;
	        } else if (valIsUndefined) {
	          setLow = othIsReflexive && (retHighest || othIsDefined);
	        } else if (valIsNull) {
	          setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
	        } else if (valIsSymbol) {
	          setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
	        } else if (othIsNull || othIsSymbol) {
	          setLow = false;
	        } else {
	          setLow = retHighest ? (computed <= value) : (computed < value);
	        }
	        if (setLow) {
	          low = mid + 1;
	        } else {
	          high = mid;
	        }
	      }
	      return nativeMin(high, MAX_ARRAY_INDEX);
	    }
	
	    /**
	     * The base implementation of `_.sortedUniq` and `_.sortedUniqBy` without
	     * support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array} array The array to inspect.
	     * @param {Function} [iteratee] The iteratee invoked per element.
	     * @returns {Array} Returns the new duplicate free array.
	     */
	    function baseSortedUniq(array, iteratee) {
	      var index = -1,
	          length = array.length,
	          resIndex = 0,
	          result = [];
	
	      while (++index < length) {
	        var value = array[index],
	            computed = iteratee ? iteratee(value) : value;
	
	        if (!index || !eq(computed, seen)) {
	          var seen = computed;
	          result[resIndex++] = value === 0 ? 0 : value;
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.toNumber` which doesn't ensure correct
	     * conversions of binary, hexadecimal, or octal string values.
	     *
	     * @private
	     * @param {*} value The value to process.
	     * @returns {number} Returns the number.
	     */
	    function baseToNumber(value) {
	      if (typeof value == 'number') {
	        return value;
	      }
	      if (isSymbol(value)) {
	        return NAN;
	      }
	      return +value;
	    }
	
	    /**
	     * The base implementation of `_.toString` which doesn't convert nullish
	     * values to empty strings.
	     *
	     * @private
	     * @param {*} value The value to process.
	     * @returns {string} Returns the string.
	     */
	    function baseToString(value) {
	      // Exit early for strings to avoid a performance hit in some environments.
	      if (typeof value == 'string') {
	        return value;
	      }
	      if (isArray(value)) {
	        // Recursively convert values (susceptible to call stack limits).
	        return arrayMap(value, baseToString) + '';
	      }
	      if (isSymbol(value)) {
	        return symbolToString ? symbolToString.call(value) : '';
	      }
	      var result = (value + '');
	      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	    }
	
	    /**
	     * The base implementation of `_.uniqBy` without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array} array The array to inspect.
	     * @param {Function} [iteratee] The iteratee invoked per element.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new duplicate free array.
	     */
	    function baseUniq(array, iteratee, comparator) {
	      var index = -1,
	          includes = arrayIncludes,
	          length = array.length,
	          isCommon = true,
	          result = [],
	          seen = result;
	
	      if (comparator) {
	        isCommon = false;
	        includes = arrayIncludesWith;
	      }
	      else if (length >= LARGE_ARRAY_SIZE) {
	        var set = iteratee ? null : createSet(array);
	        if (set) {
	          return setToArray(set);
	        }
	        isCommon = false;
	        includes = cacheHas;
	        seen = new SetCache;
	      }
	      else {
	        seen = iteratee ? [] : result;
	      }
	      outer:
	      while (++index < length) {
	        var value = array[index],
	            computed = iteratee ? iteratee(value) : value;
	
	        value = (comparator || value !== 0) ? value : 0;
	        if (isCommon && computed === computed) {
	          var seenIndex = seen.length;
	          while (seenIndex--) {
	            if (seen[seenIndex] === computed) {
	              continue outer;
	            }
	          }
	          if (iteratee) {
	            seen.push(computed);
	          }
	          result.push(value);
	        }
	        else if (!includes(seen, computed, comparator)) {
	          if (seen !== result) {
	            seen.push(computed);
	          }
	          result.push(value);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * The base implementation of `_.unset`.
	     *
	     * @private
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The property path to unset.
	     * @returns {boolean} Returns `true` if the property is deleted, else `false`.
	     */
	    function baseUnset(object, path) {
	      path = castPath(path, object);
	      object = parent(object, path);
	      return object == null || delete object[toKey(last(path))];
	    }
	
	    /**
	     * The base implementation of `_.update`.
	     *
	     * @private
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The path of the property to update.
	     * @param {Function} updater The function to produce the updated value.
	     * @param {Function} [customizer] The function to customize path creation.
	     * @returns {Object} Returns `object`.
	     */
	    function baseUpdate(object, path, updater, customizer) {
	      return baseSet(object, path, updater(baseGet(object, path)), customizer);
	    }
	
	    /**
	     * The base implementation of methods like `_.dropWhile` and `_.takeWhile`
	     * without support for iteratee shorthands.
	     *
	     * @private
	     * @param {Array} array The array to query.
	     * @param {Function} predicate The function invoked per iteration.
	     * @param {boolean} [isDrop] Specify dropping elements instead of taking them.
	     * @param {boolean} [fromRight] Specify iterating from right to left.
	     * @returns {Array} Returns the slice of `array`.
	     */
	    function baseWhile(array, predicate, isDrop, fromRight) {
	      var length = array.length,
	          index = fromRight ? length : -1;
	
	      while ((fromRight ? index-- : ++index < length) &&
	        predicate(array[index], index, array)) {}
	
	      return isDrop
	        ? baseSlice(array, (fromRight ? 0 : index), (fromRight ? index + 1 : length))
	        : baseSlice(array, (fromRight ? index + 1 : 0), (fromRight ? length : index));
	    }
	
	    /**
	     * The base implementation of `wrapperValue` which returns the result of
	     * performing a sequence of actions on the unwrapped `value`, where each
	     * successive action is supplied the return value of the previous.
	     *
	     * @private
	     * @param {*} value The unwrapped value.
	     * @param {Array} actions Actions to perform to resolve the unwrapped value.
	     * @returns {*} Returns the resolved value.
	     */
	    function baseWrapperValue(value, actions) {
	      var result = value;
	      if (result instanceof LazyWrapper) {
	        result = result.value();
	      }
	      return arrayReduce(actions, function(result, action) {
	        return action.func.apply(action.thisArg, arrayPush([result], action.args));
	      }, result);
	    }
	
	    /**
	     * The base implementation of methods like `_.xor`, without support for
	     * iteratee shorthands, that accepts an array of arrays to inspect.
	     *
	     * @private
	     * @param {Array} arrays The arrays to inspect.
	     * @param {Function} [iteratee] The iteratee invoked per element.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new array of values.
	     */
	    function baseXor(arrays, iteratee, comparator) {
	      var length = arrays.length;
	      if (length < 2) {
	        return length ? baseUniq(arrays[0]) : [];
	      }
	      var index = -1,
	          result = Array(length);
	
	      while (++index < length) {
	        var array = arrays[index],
	            othIndex = -1;
	
	        while (++othIndex < length) {
	          if (othIndex != index) {
	            result[index] = baseDifference(result[index] || array, arrays[othIndex], iteratee, comparator);
	          }
	        }
	      }
	      return baseUniq(baseFlatten(result, 1), iteratee, comparator);
	    }
	
	    /**
	     * This base implementation of `_.zipObject` which assigns values using `assignFunc`.
	     *
	     * @private
	     * @param {Array} props The property identifiers.
	     * @param {Array} values The property values.
	     * @param {Function} assignFunc The function to assign values.
	     * @returns {Object} Returns the new object.
	     */
	    function baseZipObject(props, values, assignFunc) {
	      var index = -1,
	          length = props.length,
	          valsLength = values.length,
	          result = {};
	
	      while (++index < length) {
	        var value = index < valsLength ? values[index] : undefined;
	        assignFunc(result, props[index], value);
	      }
	      return result;
	    }
	
	    /**
	     * Casts `value` to an empty array if it's not an array like object.
	     *
	     * @private
	     * @param {*} value The value to inspect.
	     * @returns {Array|Object} Returns the cast array-like object.
	     */
	    function castArrayLikeObject(value) {
	      return isArrayLikeObject(value) ? value : [];
	    }
	
	    /**
	     * Casts `value` to `identity` if it's not a function.
	     *
	     * @private
	     * @param {*} value The value to inspect.
	     * @returns {Function} Returns cast function.
	     */
	    function castFunction(value) {
	      return typeof value == 'function' ? value : identity;
	    }
	
	    /**
	     * Casts `value` to a path array if it's not one.
	     *
	     * @private
	     * @param {*} value The value to inspect.
	     * @param {Object} [object] The object to query keys on.
	     * @returns {Array} Returns the cast property path array.
	     */
	    function castPath(value, object) {
	      if (isArray(value)) {
	        return value;
	      }
	      return isKey(value, object) ? [value] : stringToPath(toString(value));
	    }
	
	    /**
	     * A `baseRest` alias which can be replaced with `identity` by module
	     * replacement plugins.
	     *
	     * @private
	     * @type {Function}
	     * @param {Function} func The function to apply a rest parameter to.
	     * @returns {Function} Returns the new function.
	     */
	    var castRest = baseRest;
	
	    /**
	     * Casts `array` to a slice if it's needed.
	     *
	     * @private
	     * @param {Array} array The array to inspect.
	     * @param {number} start The start position.
	     * @param {number} [end=array.length] The end position.
	     * @returns {Array} Returns the cast slice.
	     */
	    function castSlice(array, start, end) {
	      var length = array.length;
	      end = end === undefined ? length : end;
	      return (!start && end >= length) ? array : baseSlice(array, start, end);
	    }
	
	    /**
	     * A simple wrapper around the global [`clearTimeout`](https://mdn.io/clearTimeout).
	     *
	     * @private
	     * @param {number|Object} id The timer id or timeout object of the timer to clear.
	     */
	    var clearTimeout = ctxClearTimeout || function(id) {
	      return root.clearTimeout(id);
	    };
	
	    /**
	     * Creates a clone of  `buffer`.
	     *
	     * @private
	     * @param {Buffer} buffer The buffer to clone.
	     * @param {boolean} [isDeep] Specify a deep clone.
	     * @returns {Buffer} Returns the cloned buffer.
	     */
	    function cloneBuffer(buffer, isDeep) {
	      if (isDeep) {
	        return buffer.slice();
	      }
	      var length = buffer.length,
	          result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
	
	      buffer.copy(result);
	      return result;
	    }
	
	    /**
	     * Creates a clone of `arrayBuffer`.
	     *
	     * @private
	     * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
	     * @returns {ArrayBuffer} Returns the cloned array buffer.
	     */
	    function cloneArrayBuffer(arrayBuffer) {
	      var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
	      new Uint8Array(result).set(new Uint8Array(arrayBuffer));
	      return result;
	    }
	
	    /**
	     * Creates a clone of `dataView`.
	     *
	     * @private
	     * @param {Object} dataView The data view to clone.
	     * @param {boolean} [isDeep] Specify a deep clone.
	     * @returns {Object} Returns the cloned data view.
	     */
	    function cloneDataView(dataView, isDeep) {
	      var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
	      return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
	    }
	
	    /**
	     * Creates a clone of `map`.
	     *
	     * @private
	     * @param {Object} map The map to clone.
	     * @param {Function} cloneFunc The function to clone values.
	     * @param {boolean} [isDeep] Specify a deep clone.
	     * @returns {Object} Returns the cloned map.
	     */
	    function cloneMap(map, isDeep, cloneFunc) {
	      var array = isDeep ? cloneFunc(mapToArray(map), CLONE_DEEP_FLAG) : mapToArray(map);
	      return arrayReduce(array, addMapEntry, new map.constructor);
	    }
	
	    /**
	     * Creates a clone of `regexp`.
	     *
	     * @private
	     * @param {Object} regexp The regexp to clone.
	     * @returns {Object} Returns the cloned regexp.
	     */
	    function cloneRegExp(regexp) {
	      var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
	      result.lastIndex = regexp.lastIndex;
	      return result;
	    }
	
	    /**
	     * Creates a clone of `set`.
	     *
	     * @private
	     * @param {Object} set The set to clone.
	     * @param {Function} cloneFunc The function to clone values.
	     * @param {boolean} [isDeep] Specify a deep clone.
	     * @returns {Object} Returns the cloned set.
	     */
	    function cloneSet(set, isDeep, cloneFunc) {
	      var array = isDeep ? cloneFunc(setToArray(set), CLONE_DEEP_FLAG) : setToArray(set);
	      return arrayReduce(array, addSetEntry, new set.constructor);
	    }
	
	    /**
	     * Creates a clone of the `symbol` object.
	     *
	     * @private
	     * @param {Object} symbol The symbol object to clone.
	     * @returns {Object} Returns the cloned symbol object.
	     */
	    function cloneSymbol(symbol) {
	      return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
	    }
	
	    /**
	     * Creates a clone of `typedArray`.
	     *
	     * @private
	     * @param {Object} typedArray The typed array to clone.
	     * @param {boolean} [isDeep] Specify a deep clone.
	     * @returns {Object} Returns the cloned typed array.
	     */
	    function cloneTypedArray(typedArray, isDeep) {
	      var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
	      return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
	    }
	
	    /**
	     * Compares values to sort them in ascending order.
	     *
	     * @private
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {number} Returns the sort order indicator for `value`.
	     */
	    function compareAscending(value, other) {
	      if (value !== other) {
	        var valIsDefined = value !== undefined,
	            valIsNull = value === null,
	            valIsReflexive = value === value,
	            valIsSymbol = isSymbol(value);
	
	        var othIsDefined = other !== undefined,
	            othIsNull = other === null,
	            othIsReflexive = other === other,
	            othIsSymbol = isSymbol(other);
	
	        if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
	            (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
	            (valIsNull && othIsDefined && othIsReflexive) ||
	            (!valIsDefined && othIsReflexive) ||
	            !valIsReflexive) {
	          return 1;
	        }
	        if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
	            (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
	            (othIsNull && valIsDefined && valIsReflexive) ||
	            (!othIsDefined && valIsReflexive) ||
	            !othIsReflexive) {
	          return -1;
	        }
	      }
	      return 0;
	    }
	
	    /**
	     * Used by `_.orderBy` to compare multiple properties of a value to another
	     * and stable sort them.
	     *
	     * If `orders` is unspecified, all values are sorted in ascending order. Otherwise,
	     * specify an order of "desc" for descending or "asc" for ascending sort order
	     * of corresponding values.
	     *
	     * @private
	     * @param {Object} object The object to compare.
	     * @param {Object} other The other object to compare.
	     * @param {boolean[]|string[]} orders The order to sort by for each property.
	     * @returns {number} Returns the sort order indicator for `object`.
	     */
	    function compareMultiple(object, other, orders) {
	      var index = -1,
	          objCriteria = object.criteria,
	          othCriteria = other.criteria,
	          length = objCriteria.length,
	          ordersLength = orders.length;
	
	      while (++index < length) {
	        var result = compareAscending(objCriteria[index], othCriteria[index]);
	        if (result) {
	          if (index >= ordersLength) {
	            return result;
	          }
	          var order = orders[index];
	          return result * (order == 'desc' ? -1 : 1);
	        }
	      }
	      // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
	      // that causes it, under certain circumstances, to provide the same value for
	      // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
	      // for more details.
	      //
	      // This also ensures a stable sort in V8 and other engines.
	      // See https://bugs.chromium.org/p/v8/issues/detail?id=90 for more details.
	      return object.index - other.index;
	    }
	
	    /**
	     * Creates an array that is the composition of partially applied arguments,
	     * placeholders, and provided arguments into a single array of arguments.
	     *
	     * @private
	     * @param {Array} args The provided arguments.
	     * @param {Array} partials The arguments to prepend to those provided.
	     * @param {Array} holders The `partials` placeholder indexes.
	     * @params {boolean} [isCurried] Specify composing for a curried function.
	     * @returns {Array} Returns the new array of composed arguments.
	     */
	    function composeArgs(args, partials, holders, isCurried) {
	      var argsIndex = -1,
	          argsLength = args.length,
	          holdersLength = holders.length,
	          leftIndex = -1,
	          leftLength = partials.length,
	          rangeLength = nativeMax(argsLength - holdersLength, 0),
	          result = Array(leftLength + rangeLength),
	          isUncurried = !isCurried;
	
	      while (++leftIndex < leftLength) {
	        result[leftIndex] = partials[leftIndex];
	      }
	      while (++argsIndex < holdersLength) {
	        if (isUncurried || argsIndex < argsLength) {
	          result[holders[argsIndex]] = args[argsIndex];
	        }
	      }
	      while (rangeLength--) {
	        result[leftIndex++] = args[argsIndex++];
	      }
	      return result;
	    }
	
	    /**
	     * This function is like `composeArgs` except that the arguments composition
	     * is tailored for `_.partialRight`.
	     *
	     * @private
	     * @param {Array} args The provided arguments.
	     * @param {Array} partials The arguments to append to those provided.
	     * @param {Array} holders The `partials` placeholder indexes.
	     * @params {boolean} [isCurried] Specify composing for a curried function.
	     * @returns {Array} Returns the new array of composed arguments.
	     */
	    function composeArgsRight(args, partials, holders, isCurried) {
	      var argsIndex = -1,
	          argsLength = args.length,
	          holdersIndex = -1,
	          holdersLength = holders.length,
	          rightIndex = -1,
	          rightLength = partials.length,
	          rangeLength = nativeMax(argsLength - holdersLength, 0),
	          result = Array(rangeLength + rightLength),
	          isUncurried = !isCurried;
	
	      while (++argsIndex < rangeLength) {
	        result[argsIndex] = args[argsIndex];
	      }
	      var offset = argsIndex;
	      while (++rightIndex < rightLength) {
	        result[offset + rightIndex] = partials[rightIndex];
	      }
	      while (++holdersIndex < holdersLength) {
	        if (isUncurried || argsIndex < argsLength) {
	          result[offset + holders[holdersIndex]] = args[argsIndex++];
	        }
	      }
	      return result;
	    }
	
	    /**
	     * Copies the values of `source` to `array`.
	     *
	     * @private
	     * @param {Array} source The array to copy values from.
	     * @param {Array} [array=[]] The array to copy values to.
	     * @returns {Array} Returns `array`.
	     */
	    function copyArray(source, array) {
	      var index = -1,
	          length = source.length;
	
	      array || (array = Array(length));
	      while (++index < length) {
	        array[index] = source[index];
	      }
	      return array;
	    }
	
	    /**
	     * Copies properties of `source` to `object`.
	     *
	     * @private
	     * @param {Object} source The object to copy properties from.
	     * @param {Array} props The property identifiers to copy.
	     * @param {Object} [object={}] The object to copy properties to.
	     * @param {Function} [customizer] The function to customize copied values.
	     * @returns {Object} Returns `object`.
	     */
	    function copyObject(source, props, object, customizer) {
	      var isNew = !object;
	      object || (object = {});
	
	      var index = -1,
	          length = props.length;
	
	      while (++index < length) {
	        var key = props[index];
	
	        var newValue = customizer
	          ? customizer(object[key], source[key], key, object, source)
	          : undefined;
	
	        if (newValue === undefined) {
	          newValue = source[key];
	        }
	        if (isNew) {
	          baseAssignValue(object, key, newValue);
	        } else {
	          assignValue(object, key, newValue);
	        }
	      }
	      return object;
	    }
	
	    /**
	     * Copies own symbols of `source` to `object`.
	     *
	     * @private
	     * @param {Object} source The object to copy symbols from.
	     * @param {Object} [object={}] The object to copy symbols to.
	     * @returns {Object} Returns `object`.
	     */
	    function copySymbols(source, object) {
	      return copyObject(source, getSymbols(source), object);
	    }
	
	    /**
	     * Copies own and inherited symbols of `source` to `object`.
	     *
	     * @private
	     * @param {Object} source The object to copy symbols from.
	     * @param {Object} [object={}] The object to copy symbols to.
	     * @returns {Object} Returns `object`.
	     */
	    function copySymbolsIn(source, object) {
	      return copyObject(source, getSymbolsIn(source), object);
	    }
	
	    /**
	     * Creates a function like `_.groupBy`.
	     *
	     * @private
	     * @param {Function} setter The function to set accumulator values.
	     * @param {Function} [initializer] The accumulator object initializer.
	     * @returns {Function} Returns the new aggregator function.
	     */
	    function createAggregator(setter, initializer) {
	      return function(collection, iteratee) {
	        var func = isArray(collection) ? arrayAggregator : baseAggregator,
	            accumulator = initializer ? initializer() : {};
	
	        return func(collection, setter, getIteratee(iteratee, 2), accumulator);
	      };
	    }
	
	    /**
	     * Creates a function like `_.assign`.
	     *
	     * @private
	     * @param {Function} assigner The function to assign values.
	     * @returns {Function} Returns the new assigner function.
	     */
	    function createAssigner(assigner) {
	      return baseRest(function(object, sources) {
	        var index = -1,
	            length = sources.length,
	            customizer = length > 1 ? sources[length - 1] : undefined,
	            guard = length > 2 ? sources[2] : undefined;
	
	        customizer = (assigner.length > 3 && typeof customizer == 'function')
	          ? (length--, customizer)
	          : undefined;
	
	        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
	          customizer = length < 3 ? undefined : customizer;
	          length = 1;
	        }
	        object = Object(object);
	        while (++index < length) {
	          var source = sources[index];
	          if (source) {
	            assigner(object, source, index, customizer);
	          }
	        }
	        return object;
	      });
	    }
	
	    /**
	     * Creates a `baseEach` or `baseEachRight` function.
	     *
	     * @private
	     * @param {Function} eachFunc The function to iterate over a collection.
	     * @param {boolean} [fromRight] Specify iterating from right to left.
	     * @returns {Function} Returns the new base function.
	     */
	    function createBaseEach(eachFunc, fromRight) {
	      return function(collection, iteratee) {
	        if (collection == null) {
	          return collection;
	        }
	        if (!isArrayLike(collection)) {
	          return eachFunc(collection, iteratee);
	        }
	        var length = collection.length,
	            index = fromRight ? length : -1,
	            iterable = Object(collection);
	
	        while ((fromRight ? index-- : ++index < length)) {
	          if (iteratee(iterable[index], index, iterable) === false) {
	            break;
	          }
	        }
	        return collection;
	      };
	    }
	
	    /**
	     * Creates a base function for methods like `_.forIn` and `_.forOwn`.
	     *
	     * @private
	     * @param {boolean} [fromRight] Specify iterating from right to left.
	     * @returns {Function} Returns the new base function.
	     */
	    function createBaseFor(fromRight) {
	      return function(object, iteratee, keysFunc) {
	        var index = -1,
	            iterable = Object(object),
	            props = keysFunc(object),
	            length = props.length;
	
	        while (length--) {
	          var key = props[fromRight ? length : ++index];
	          if (iteratee(iterable[key], key, iterable) === false) {
	            break;
	          }
	        }
	        return object;
	      };
	    }
	
	    /**
	     * Creates a function that wraps `func` to invoke it with the optional `this`
	     * binding of `thisArg`.
	     *
	     * @private
	     * @param {Function} func The function to wrap.
	     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
	     * @param {*} [thisArg] The `this` binding of `func`.
	     * @returns {Function} Returns the new wrapped function.
	     */
	    function createBind(func, bitmask, thisArg) {
	      var isBind = bitmask & WRAP_BIND_FLAG,
	          Ctor = createCtor(func);
	
	      function wrapper() {
	        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
	        return fn.apply(isBind ? thisArg : this, arguments);
	      }
	      return wrapper;
	    }
	
	    /**
	     * Creates a function like `_.lowerFirst`.
	     *
	     * @private
	     * @param {string} methodName The name of the `String` case method to use.
	     * @returns {Function} Returns the new case function.
	     */
	    function createCaseFirst(methodName) {
	      return function(string) {
	        string = toString(string);
	
	        var strSymbols = hasUnicode(string)
	          ? stringToArray(string)
	          : undefined;
	
	        var chr = strSymbols
	          ? strSymbols[0]
	          : string.charAt(0);
	
	        var trailing = strSymbols
	          ? castSlice(strSymbols, 1).join('')
	          : string.slice(1);
	
	        return chr[methodName]() + trailing;
	      };
	    }
	
	    /**
	     * Creates a function like `_.camelCase`.
	     *
	     * @private
	     * @param {Function} callback The function to combine each word.
	     * @returns {Function} Returns the new compounder function.
	     */
	    function createCompounder(callback) {
	      return function(string) {
	        return arrayReduce(words(deburr(string).replace(reApos, '')), callback, '');
	      };
	    }
	
	    /**
	     * Creates a function that produces an instance of `Ctor` regardless of
	     * whether it was invoked as part of a `new` expression or by `call` or `apply`.
	     *
	     * @private
	     * @param {Function} Ctor The constructor to wrap.
	     * @returns {Function} Returns the new wrapped function.
	     */
	    function createCtor(Ctor) {
	      return function() {
	        // Use a `switch` statement to work with class constructors. See
	        // http://ecma-international.org/ecma-262/7.0/#sec-ecmascript-function-objects-call-thisargument-argumentslist
	        // for more details.
	        var args = arguments;
	        switch (args.length) {
	          case 0: return new Ctor;
	          case 1: return new Ctor(args[0]);
	          case 2: return new Ctor(args[0], args[1]);
	          case 3: return new Ctor(args[0], args[1], args[2]);
	          case 4: return new Ctor(args[0], args[1], args[2], args[3]);
	          case 5: return new Ctor(args[0], args[1], args[2], args[3], args[4]);
	          case 6: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
	          case 7: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
	        }
	        var thisBinding = baseCreate(Ctor.prototype),
	            result = Ctor.apply(thisBinding, args);
	
	        // Mimic the constructor's `return` behavior.
	        // See https://es5.github.io/#x13.2.2 for more details.
	        return isObject(result) ? result : thisBinding;
	      };
	    }
	
	    /**
	     * Creates a function that wraps `func` to enable currying.
	     *
	     * @private
	     * @param {Function} func The function to wrap.
	     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
	     * @param {number} arity The arity of `func`.
	     * @returns {Function} Returns the new wrapped function.
	     */
	    function createCurry(func, bitmask, arity) {
	      var Ctor = createCtor(func);
	
	      function wrapper() {
	        var length = arguments.length,
	            args = Array(length),
	            index = length,
	            placeholder = getHolder(wrapper);
	
	        while (index--) {
	          args[index] = arguments[index];
	        }
	        var holders = (length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder)
	          ? []
	          : replaceHolders(args, placeholder);
	
	        length -= holders.length;
	        if (length < arity) {
	          return createRecurry(
	            func, bitmask, createHybrid, wrapper.placeholder, undefined,
	            args, holders, undefined, undefined, arity - length);
	        }
	        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
	        return apply(fn, this, args);
	      }
	      return wrapper;
	    }
	
	    /**
	     * Creates a `_.find` or `_.findLast` function.
	     *
	     * @private
	     * @param {Function} findIndexFunc The function to find the collection index.
	     * @returns {Function} Returns the new find function.
	     */
	    function createFind(findIndexFunc) {
	      return function(collection, predicate, fromIndex) {
	        var iterable = Object(collection);
	        if (!isArrayLike(collection)) {
	          var iteratee = getIteratee(predicate, 3);
	          collection = keys(collection);
	          predicate = function(key) { return iteratee(iterable[key], key, iterable); };
	        }
	        var index = findIndexFunc(collection, predicate, fromIndex);
	        return index > -1 ? iterable[iteratee ? collection[index] : index] : undefined;
	      };
	    }
	
	    /**
	     * Creates a `_.flow` or `_.flowRight` function.
	     *
	     * @private
	     * @param {boolean} [fromRight] Specify iterating from right to left.
	     * @returns {Function} Returns the new flow function.
	     */
	    function createFlow(fromRight) {
	      return flatRest(function(funcs) {
	        var length = funcs.length,
	            index = length,
	            prereq = LodashWrapper.prototype.thru;
	
	        if (fromRight) {
	          funcs.reverse();
	        }
	        while (index--) {
	          var func = funcs[index];
	          if (typeof func != 'function') {
	            throw new TypeError(FUNC_ERROR_TEXT);
	          }
	          if (prereq && !wrapper && getFuncName(func) == 'wrapper') {
	            var wrapper = new LodashWrapper([], true);
	          }
	        }
	        index = wrapper ? index : length;
	        while (++index < length) {
	          func = funcs[index];
	
	          var funcName = getFuncName(func),
	              data = funcName == 'wrapper' ? getData(func) : undefined;
	
	          if (data && isLaziable(data[0]) &&
	                data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) &&
	                !data[4].length && data[9] == 1
	              ) {
	            wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
	          } else {
	            wrapper = (func.length == 1 && isLaziable(func))
	              ? wrapper[funcName]()
	              : wrapper.thru(func);
	          }
	        }
	        return function() {
	          var args = arguments,
	              value = args[0];
	
	          if (wrapper && args.length == 1 && isArray(value)) {
	            return wrapper.plant(value).value();
	          }
	          var index = 0,
	              result = length ? funcs[index].apply(this, args) : value;
	
	          while (++index < length) {
	            result = funcs[index].call(this, result);
	          }
	          return result;
	        };
	      });
	    }
	
	    /**
	     * Creates a function that wraps `func` to invoke it with optional `this`
	     * binding of `thisArg`, partial application, and currying.
	     *
	     * @private
	     * @param {Function|string} func The function or method name to wrap.
	     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
	     * @param {*} [thisArg] The `this` binding of `func`.
	     * @param {Array} [partials] The arguments to prepend to those provided to
	     *  the new function.
	     * @param {Array} [holders] The `partials` placeholder indexes.
	     * @param {Array} [partialsRight] The arguments to append to those provided
	     *  to the new function.
	     * @param {Array} [holdersRight] The `partialsRight` placeholder indexes.
	     * @param {Array} [argPos] The argument positions of the new function.
	     * @param {number} [ary] The arity cap of `func`.
	     * @param {number} [arity] The arity of `func`.
	     * @returns {Function} Returns the new wrapped function.
	     */
	    function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
	      var isAry = bitmask & WRAP_ARY_FLAG,
	          isBind = bitmask & WRAP_BIND_FLAG,
	          isBindKey = bitmask & WRAP_BIND_KEY_FLAG,
	          isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG),
	          isFlip = bitmask & WRAP_FLIP_FLAG,
	          Ctor = isBindKey ? undefined : createCtor(func);
	
	      function wrapper() {
	        var length = arguments.length,
	            args = Array(length),
	            index = length;
	
	        while (index--) {
	          args[index] = arguments[index];
	        }
	        if (isCurried) {
	          var placeholder = getHolder(wrapper),
	              holdersCount = countHolders(args, placeholder);
	        }
	        if (partials) {
	          args = composeArgs(args, partials, holders, isCurried);
	        }
	        if (partialsRight) {
	          args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
	        }
	        length -= holdersCount;
	        if (isCurried && length < arity) {
	          var newHolders = replaceHolders(args, placeholder);
	          return createRecurry(
	            func, bitmask, createHybrid, wrapper.placeholder, thisArg,
	            args, newHolders, argPos, ary, arity - length
	          );
	        }
	        var thisBinding = isBind ? thisArg : this,
	            fn = isBindKey ? thisBinding[func] : func;
	
	        length = args.length;
	        if (argPos) {
	          args = reorder(args, argPos);
	        } else if (isFlip && length > 1) {
	          args.reverse();
	        }
	        if (isAry && ary < length) {
	          args.length = ary;
	        }
	        if (this && this !== root && this instanceof wrapper) {
	          fn = Ctor || createCtor(fn);
	        }
	        return fn.apply(thisBinding, args);
	      }
	      return wrapper;
	    }
	
	    /**
	     * Creates a function like `_.invertBy`.
	     *
	     * @private
	     * @param {Function} setter The function to set accumulator values.
	     * @param {Function} toIteratee The function to resolve iteratees.
	     * @returns {Function} Returns the new inverter function.
	     */
	    function createInverter(setter, toIteratee) {
	      return function(object, iteratee) {
	        return baseInverter(object, setter, toIteratee(iteratee), {});
	      };
	    }
	
	    /**
	     * Creates a function that performs a mathematical operation on two values.
	     *
	     * @private
	     * @param {Function} operator The function to perform the operation.
	     * @param {number} [defaultValue] The value used for `undefined` arguments.
	     * @returns {Function} Returns the new mathematical operation function.
	     */
	    function createMathOperation(operator, defaultValue) {
	      return function(value, other) {
	        var result;
	        if (value === undefined && other === undefined) {
	          return defaultValue;
	        }
	        if (value !== undefined) {
	          result = value;
	        }
	        if (other !== undefined) {
	          if (result === undefined) {
	            return other;
	          }
	          if (typeof value == 'string' || typeof other == 'string') {
	            value = baseToString(value);
	            other = baseToString(other);
	          } else {
	            value = baseToNumber(value);
	            other = baseToNumber(other);
	          }
	          result = operator(value, other);
	        }
	        return result;
	      };
	    }
	
	    /**
	     * Creates a function like `_.over`.
	     *
	     * @private
	     * @param {Function} arrayFunc The function to iterate over iteratees.
	     * @returns {Function} Returns the new over function.
	     */
	    function createOver(arrayFunc) {
	      return flatRest(function(iteratees) {
	        iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
	        return baseRest(function(args) {
	          var thisArg = this;
	          return arrayFunc(iteratees, function(iteratee) {
	            return apply(iteratee, thisArg, args);
	          });
	        });
	      });
	    }
	
	    /**
	     * Creates the padding for `string` based on `length`. The `chars` string
	     * is truncated if the number of characters exceeds `length`.
	     *
	     * @private
	     * @param {number} length The padding length.
	     * @param {string} [chars=' '] The string used as padding.
	     * @returns {string} Returns the padding for `string`.
	     */
	    function createPadding(length, chars) {
	      chars = chars === undefined ? ' ' : baseToString(chars);
	
	      var charsLength = chars.length;
	      if (charsLength < 2) {
	        return charsLength ? baseRepeat(chars, length) : chars;
	      }
	      var result = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
	      return hasUnicode(chars)
	        ? castSlice(stringToArray(result), 0, length).join('')
	        : result.slice(0, length);
	    }
	
	    /**
	     * Creates a function that wraps `func` to invoke it with the `this` binding
	     * of `thisArg` and `partials` prepended to the arguments it receives.
	     *
	     * @private
	     * @param {Function} func The function to wrap.
	     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
	     * @param {*} thisArg The `this` binding of `func`.
	     * @param {Array} partials The arguments to prepend to those provided to
	     *  the new function.
	     * @returns {Function} Returns the new wrapped function.
	     */
	    function createPartial(func, bitmask, thisArg, partials) {
	      var isBind = bitmask & WRAP_BIND_FLAG,
	          Ctor = createCtor(func);
	
	      function wrapper() {
	        var argsIndex = -1,
	            argsLength = arguments.length,
	            leftIndex = -1,
	            leftLength = partials.length,
	            args = Array(leftLength + argsLength),
	            fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
	
	        while (++leftIndex < leftLength) {
	          args[leftIndex] = partials[leftIndex];
	        }
	        while (argsLength--) {
	          args[leftIndex++] = arguments[++argsIndex];
	        }
	        return apply(fn, isBind ? thisArg : this, args);
	      }
	      return wrapper;
	    }
	
	    /**
	     * Creates a `_.range` or `_.rangeRight` function.
	     *
	     * @private
	     * @param {boolean} [fromRight] Specify iterating from right to left.
	     * @returns {Function} Returns the new range function.
	     */
	    function createRange(fromRight) {
	      return function(start, end, step) {
	        if (step && typeof step != 'number' && isIterateeCall(start, end, step)) {
	          end = step = undefined;
	        }
	        // Ensure the sign of `-0` is preserved.
	        start = toFinite(start);
	        if (end === undefined) {
	          end = start;
	          start = 0;
	        } else {
	          end = toFinite(end);
	        }
	        step = step === undefined ? (start < end ? 1 : -1) : toFinite(step);
	        return baseRange(start, end, step, fromRight);
	      };
	    }
	
	    /**
	     * Creates a function that performs a relational operation on two values.
	     *
	     * @private
	     * @param {Function} operator The function to perform the operation.
	     * @returns {Function} Returns the new relational operation function.
	     */
	    function createRelationalOperation(operator) {
	      return function(value, other) {
	        if (!(typeof value == 'string' && typeof other == 'string')) {
	          value = toNumber(value);
	          other = toNumber(other);
	        }
	        return operator(value, other);
	      };
	    }
	
	    /**
	     * Creates a function that wraps `func` to continue currying.
	     *
	     * @private
	     * @param {Function} func The function to wrap.
	     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
	     * @param {Function} wrapFunc The function to create the `func` wrapper.
	     * @param {*} placeholder The placeholder value.
	     * @param {*} [thisArg] The `this` binding of `func`.
	     * @param {Array} [partials] The arguments to prepend to those provided to
	     *  the new function.
	     * @param {Array} [holders] The `partials` placeholder indexes.
	     * @param {Array} [argPos] The argument positions of the new function.
	     * @param {number} [ary] The arity cap of `func`.
	     * @param {number} [arity] The arity of `func`.
	     * @returns {Function} Returns the new wrapped function.
	     */
	    function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary, arity) {
	      var isCurry = bitmask & WRAP_CURRY_FLAG,
	          newHolders = isCurry ? holders : undefined,
	          newHoldersRight = isCurry ? undefined : holders,
	          newPartials = isCurry ? partials : undefined,
	          newPartialsRight = isCurry ? undefined : partials;
	
	      bitmask |= (isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG);
	      bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
	
	      if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
	        bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
	      }
	      var newData = [
	        func, bitmask, thisArg, newPartials, newHolders, newPartialsRight,
	        newHoldersRight, argPos, ary, arity
	      ];
	
	      var result = wrapFunc.apply(undefined, newData);
	      if (isLaziable(func)) {
	        setData(result, newData);
	      }
	      result.placeholder = placeholder;
	      return setWrapToString(result, func, bitmask);
	    }
	
	    /**
	     * Creates a function like `_.round`.
	     *
	     * @private
	     * @param {string} methodName The name of the `Math` method to use when rounding.
	     * @returns {Function} Returns the new round function.
	     */
	    function createRound(methodName) {
	      var func = Math[methodName];
	      return function(number, precision) {
	        number = toNumber(number);
	        precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
	        if (precision) {
	          // Shift with exponential notation to avoid floating-point issues.
	          // See [MDN](https://mdn.io/round#Examples) for more details.
	          var pair = (toString(number) + 'e').split('e'),
	              value = func(pair[0] + 'e' + (+pair[1] + precision));
	
	          pair = (toString(value) + 'e').split('e');
	          return +(pair[0] + 'e' + (+pair[1] - precision));
	        }
	        return func(number);
	      };
	    }
	
	    /**
	     * Creates a set object of `values`.
	     *
	     * @private
	     * @param {Array} values The values to add to the set.
	     * @returns {Object} Returns the new set.
	     */
	    var createSet = !(Set && (1 / setToArray(new Set([,-0]))[1]) == INFINITY) ? noop : function(values) {
	      return new Set(values);
	    };
	
	    /**
	     * Creates a `_.toPairs` or `_.toPairsIn` function.
	     *
	     * @private
	     * @param {Function} keysFunc The function to get the keys of a given object.
	     * @returns {Function} Returns the new pairs function.
	     */
	    function createToPairs(keysFunc) {
	      return function(object) {
	        var tag = getTag(object);
	        if (tag == mapTag) {
	          return mapToArray(object);
	        }
	        if (tag == setTag) {
	          return setToPairs(object);
	        }
	        return baseToPairs(object, keysFunc(object));
	      };
	    }
	
	    /**
	     * Creates a function that either curries or invokes `func` with optional
	     * `this` binding and partially applied arguments.
	     *
	     * @private
	     * @param {Function|string} func The function or method name to wrap.
	     * @param {number} bitmask The bitmask flags.
	     *    1 - `_.bind`
	     *    2 - `_.bindKey`
	     *    4 - `_.curry` or `_.curryRight` of a bound function
	     *    8 - `_.curry`
	     *   16 - `_.curryRight`
	     *   32 - `_.partial`
	     *   64 - `_.partialRight`
	     *  128 - `_.rearg`
	     *  256 - `_.ary`
	     *  512 - `_.flip`
	     * @param {*} [thisArg] The `this` binding of `func`.
	     * @param {Array} [partials] The arguments to be partially applied.
	     * @param {Array} [holders] The `partials` placeholder indexes.
	     * @param {Array} [argPos] The argument positions of the new function.
	     * @param {number} [ary] The arity cap of `func`.
	     * @param {number} [arity] The arity of `func`.
	     * @returns {Function} Returns the new wrapped function.
	     */
	    function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
	      var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
	      if (!isBindKey && typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      var length = partials ? partials.length : 0;
	      if (!length) {
	        bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
	        partials = holders = undefined;
	      }
	      ary = ary === undefined ? ary : nativeMax(toInteger(ary), 0);
	      arity = arity === undefined ? arity : toInteger(arity);
	      length -= holders ? holders.length : 0;
	
	      if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
	        var partialsRight = partials,
	            holdersRight = holders;
	
	        partials = holders = undefined;
	      }
	      var data = isBindKey ? undefined : getData(func);
	
	      var newData = [
	        func, bitmask, thisArg, partials, holders, partialsRight, holdersRight,
	        argPos, ary, arity
	      ];
	
	      if (data) {
	        mergeData(newData, data);
	      }
	      func = newData[0];
	      bitmask = newData[1];
	      thisArg = newData[2];
	      partials = newData[3];
	      holders = newData[4];
	      arity = newData[9] = newData[9] === undefined
	        ? (isBindKey ? 0 : func.length)
	        : nativeMax(newData[9] - length, 0);
	
	      if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
	        bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
	      }
	      if (!bitmask || bitmask == WRAP_BIND_FLAG) {
	        var result = createBind(func, bitmask, thisArg);
	      } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
	        result = createCurry(func, bitmask, arity);
	      } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
	        result = createPartial(func, bitmask, thisArg, partials);
	      } else {
	        result = createHybrid.apply(undefined, newData);
	      }
	      var setter = data ? baseSetData : setData;
	      return setWrapToString(setter(result, newData), func, bitmask);
	    }
	
	    /**
	     * Used by `_.defaults` to customize its `_.assignIn` use to assign properties
	     * of source objects to the destination object for all destination properties
	     * that resolve to `undefined`.
	     *
	     * @private
	     * @param {*} objValue The destination value.
	     * @param {*} srcValue The source value.
	     * @param {string} key The key of the property to assign.
	     * @param {Object} object The parent object of `objValue`.
	     * @returns {*} Returns the value to assign.
	     */
	    function customDefaultsAssignIn(objValue, srcValue, key, object) {
	      if (objValue === undefined ||
	          (eq(objValue, objectProto[key]) && !hasOwnProperty.call(object, key))) {
	        return srcValue;
	      }
	      return objValue;
	    }
	
	    /**
	     * Used by `_.defaultsDeep` to customize its `_.merge` use to merge source
	     * objects into destination objects that are passed thru.
	     *
	     * @private
	     * @param {*} objValue The destination value.
	     * @param {*} srcValue The source value.
	     * @param {string} key The key of the property to merge.
	     * @param {Object} object The parent object of `objValue`.
	     * @param {Object} source The parent object of `srcValue`.
	     * @param {Object} [stack] Tracks traversed source values and their merged
	     *  counterparts.
	     * @returns {*} Returns the value to assign.
	     */
	    function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
	      if (isObject(objValue) && isObject(srcValue)) {
	        // Recursively merge objects and arrays (susceptible to call stack limits).
	        stack.set(srcValue, objValue);
	        baseMerge(objValue, srcValue, undefined, customDefaultsMerge, stack);
	        stack['delete'](srcValue);
	      }
	      return objValue;
	    }
	
	    /**
	     * Used by `_.omit` to customize its `_.cloneDeep` use to only clone plain
	     * objects.
	     *
	     * @private
	     * @param {*} value The value to inspect.
	     * @param {string} key The key of the property to inspect.
	     * @returns {*} Returns the uncloned value or `undefined` to defer cloning to `_.cloneDeep`.
	     */
	    function customOmitClone(value) {
	      return isPlainObject(value) ? undefined : value;
	    }
	
	    /**
	     * A specialized version of `baseIsEqualDeep` for arrays with support for
	     * partial deep comparisons.
	     *
	     * @private
	     * @param {Array} array The array to compare.
	     * @param {Array} other The other array to compare.
	     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
	     * @param {Function} customizer The function to customize comparisons.
	     * @param {Function} equalFunc The function to determine equivalents of values.
	     * @param {Object} stack Tracks traversed `array` and `other` objects.
	     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
	     */
	    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
	      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
	          arrLength = array.length,
	          othLength = other.length;
	
	      if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
	        return false;
	      }
	      // Assume cyclic values are equal.
	      var stacked = stack.get(array);
	      if (stacked && stack.get(other)) {
	        return stacked == other;
	      }
	      var index = -1,
	          result = true,
	          seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;
	
	      stack.set(array, other);
	      stack.set(other, array);
	
	      // Ignore non-index properties.
	      while (++index < arrLength) {
	        var arrValue = array[index],
	            othValue = other[index];
	
	        if (customizer) {
	          var compared = isPartial
	            ? customizer(othValue, arrValue, index, other, array, stack)
	            : customizer(arrValue, othValue, index, array, other, stack);
	        }
	        if (compared !== undefined) {
	          if (compared) {
	            continue;
	          }
	          result = false;
	          break;
	        }
	        // Recursively compare arrays (susceptible to call stack limits).
	        if (seen) {
	          if (!arraySome(other, function(othValue, othIndex) {
	                if (!cacheHas(seen, othIndex) &&
	                    (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
	                  return seen.push(othIndex);
	                }
	              })) {
	            result = false;
	            break;
	          }
	        } else if (!(
	              arrValue === othValue ||
	                equalFunc(arrValue, othValue, bitmask, customizer, stack)
	            )) {
	          result = false;
	          break;
	        }
	      }
	      stack['delete'](array);
	      stack['delete'](other);
	      return result;
	    }
	
	    /**
	     * A specialized version of `baseIsEqualDeep` for comparing objects of
	     * the same `toStringTag`.
	     *
	     * **Note:** This function only supports comparing values with tags of
	     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
	     *
	     * @private
	     * @param {Object} object The object to compare.
	     * @param {Object} other The other object to compare.
	     * @param {string} tag The `toStringTag` of the objects to compare.
	     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
	     * @param {Function} customizer The function to customize comparisons.
	     * @param {Function} equalFunc The function to determine equivalents of values.
	     * @param {Object} stack Tracks traversed `object` and `other` objects.
	     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
	     */
	    function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
	      switch (tag) {
	        case dataViewTag:
	          if ((object.byteLength != other.byteLength) ||
	              (object.byteOffset != other.byteOffset)) {
	            return false;
	          }
	          object = object.buffer;
	          other = other.buffer;
	
	        case arrayBufferTag:
	          if ((object.byteLength != other.byteLength) ||
	              !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
	            return false;
	          }
	          return true;
	
	        case boolTag:
	        case dateTag:
	        case numberTag:
	          // Coerce booleans to `1` or `0` and dates to milliseconds.
	          // Invalid dates are coerced to `NaN`.
	          return eq(+object, +other);
	
	        case errorTag:
	          return object.name == other.name && object.message == other.message;
	
	        case regexpTag:
	        case stringTag:
	          // Coerce regexes to strings and treat strings, primitives and objects,
	          // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
	          // for more details.
	          return object == (other + '');
	
	        case mapTag:
	          var convert = mapToArray;
	
	        case setTag:
	          var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
	          convert || (convert = setToArray);
	
	          if (object.size != other.size && !isPartial) {
	            return false;
	          }
	          // Assume cyclic values are equal.
	          var stacked = stack.get(object);
	          if (stacked) {
	            return stacked == other;
	          }
	          bitmask |= COMPARE_UNORDERED_FLAG;
	
	          // Recursively compare objects (susceptible to call stack limits).
	          stack.set(object, other);
	          var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
	          stack['delete'](object);
	          return result;
	
	        case symbolTag:
	          if (symbolValueOf) {
	            return symbolValueOf.call(object) == symbolValueOf.call(other);
	          }
	      }
	      return false;
	    }
	
	    /**
	     * A specialized version of `baseIsEqualDeep` for objects with support for
	     * partial deep comparisons.
	     *
	     * @private
	     * @param {Object} object The object to compare.
	     * @param {Object} other The other object to compare.
	     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
	     * @param {Function} customizer The function to customize comparisons.
	     * @param {Function} equalFunc The function to determine equivalents of values.
	     * @param {Object} stack Tracks traversed `object` and `other` objects.
	     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
	     */
	    function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
	      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
	          objProps = getAllKeys(object),
	          objLength = objProps.length,
	          othProps = getAllKeys(other),
	          othLength = othProps.length;
	
	      if (objLength != othLength && !isPartial) {
	        return false;
	      }
	      var index = objLength;
	      while (index--) {
	        var key = objProps[index];
	        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
	          return false;
	        }
	      }
	      // Assume cyclic values are equal.
	      var stacked = stack.get(object);
	      if (stacked && stack.get(other)) {
	        return stacked == other;
	      }
	      var result = true;
	      stack.set(object, other);
	      stack.set(other, object);
	
	      var skipCtor = isPartial;
	      while (++index < objLength) {
	        key = objProps[index];
	        var objValue = object[key],
	            othValue = other[key];
	
	        if (customizer) {
	          var compared = isPartial
	            ? customizer(othValue, objValue, key, other, object, stack)
	            : customizer(objValue, othValue, key, object, other, stack);
	        }
	        // Recursively compare objects (susceptible to call stack limits).
	        if (!(compared === undefined
	              ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
	              : compared
	            )) {
	          result = false;
	          break;
	        }
	        skipCtor || (skipCtor = key == 'constructor');
	      }
	      if (result && !skipCtor) {
	        var objCtor = object.constructor,
	            othCtor = other.constructor;
	
	        // Non `Object` object instances with different constructors are not equal.
	        if (objCtor != othCtor &&
	            ('constructor' in object && 'constructor' in other) &&
	            !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
	              typeof othCtor == 'function' && othCtor instanceof othCtor)) {
	          result = false;
	        }
	      }
	      stack['delete'](object);
	      stack['delete'](other);
	      return result;
	    }
	
	    /**
	     * A specialized version of `baseRest` which flattens the rest array.
	     *
	     * @private
	     * @param {Function} func The function to apply a rest parameter to.
	     * @returns {Function} Returns the new function.
	     */
	    function flatRest(func) {
	      return setToString(overRest(func, undefined, flatten), func + '');
	    }
	
	    /**
	     * Creates an array of own enumerable property names and symbols of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property names and symbols.
	     */
	    function getAllKeys(object) {
	      return baseGetAllKeys(object, keys, getSymbols);
	    }
	
	    /**
	     * Creates an array of own and inherited enumerable property names and
	     * symbols of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property names and symbols.
	     */
	    function getAllKeysIn(object) {
	      return baseGetAllKeys(object, keysIn, getSymbolsIn);
	    }
	
	    /**
	     * Gets metadata for `func`.
	     *
	     * @private
	     * @param {Function} func The function to query.
	     * @returns {*} Returns the metadata for `func`.
	     */
	    var getData = !metaMap ? noop : function(func) {
	      return metaMap.get(func);
	    };
	
	    /**
	     * Gets the name of `func`.
	     *
	     * @private
	     * @param {Function} func The function to query.
	     * @returns {string} Returns the function name.
	     */
	    function getFuncName(func) {
	      var result = (func.name + ''),
	          array = realNames[result],
	          length = hasOwnProperty.call(realNames, result) ? array.length : 0;
	
	      while (length--) {
	        var data = array[length],
	            otherFunc = data.func;
	        if (otherFunc == null || otherFunc == func) {
	          return data.name;
	        }
	      }
	      return result;
	    }
	
	    /**
	     * Gets the argument placeholder value for `func`.
	     *
	     * @private
	     * @param {Function} func The function to inspect.
	     * @returns {*} Returns the placeholder value.
	     */
	    function getHolder(func) {
	      var object = hasOwnProperty.call(lodash, 'placeholder') ? lodash : func;
	      return object.placeholder;
	    }
	
	    /**
	     * Gets the appropriate "iteratee" function. If `_.iteratee` is customized,
	     * this function returns the custom method, otherwise it returns `baseIteratee`.
	     * If arguments are provided, the chosen function is invoked with them and
	     * its result is returned.
	     *
	     * @private
	     * @param {*} [value] The value to convert to an iteratee.
	     * @param {number} [arity] The arity of the created iteratee.
	     * @returns {Function} Returns the chosen function or its result.
	     */
	    function getIteratee() {
	      var result = lodash.iteratee || iteratee;
	      result = result === iteratee ? baseIteratee : result;
	      return arguments.length ? result(arguments[0], arguments[1]) : result;
	    }
	
	    /**
	     * Gets the data for `map`.
	     *
	     * @private
	     * @param {Object} map The map to query.
	     * @param {string} key The reference key.
	     * @returns {*} Returns the map data.
	     */
	    function getMapData(map, key) {
	      var data = map.__data__;
	      return isKeyable(key)
	        ? data[typeof key == 'string' ? 'string' : 'hash']
	        : data.map;
	    }
	
	    /**
	     * Gets the property names, values, and compare flags of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the match data of `object`.
	     */
	    function getMatchData(object) {
	      var result = keys(object),
	          length = result.length;
	
	      while (length--) {
	        var key = result[length],
	            value = object[key];
	
	        result[length] = [key, value, isStrictComparable(value)];
	      }
	      return result;
	    }
	
	    /**
	     * Gets the native function at `key` of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @param {string} key The key of the method to get.
	     * @returns {*} Returns the function if it's native, else `undefined`.
	     */
	    function getNative(object, key) {
	      var value = getValue(object, key);
	      return baseIsNative(value) ? value : undefined;
	    }
	
	    /**
	     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
	     *
	     * @private
	     * @param {*} value The value to query.
	     * @returns {string} Returns the raw `toStringTag`.
	     */
	    function getRawTag(value) {
	      var isOwn = hasOwnProperty.call(value, symToStringTag),
	          tag = value[symToStringTag];
	
	      try {
	        value[symToStringTag] = undefined;
	        var unmasked = true;
	      } catch (e) {}
	
	      var result = nativeObjectToString.call(value);
	      if (unmasked) {
	        if (isOwn) {
	          value[symToStringTag] = tag;
	        } else {
	          delete value[symToStringTag];
	        }
	      }
	      return result;
	    }
	
	    /**
	     * Creates an array of the own enumerable symbols of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of symbols.
	     */
	    var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
	      if (object == null) {
	        return [];
	      }
	      object = Object(object);
	      return arrayFilter(nativeGetSymbols(object), function(symbol) {
	        return propertyIsEnumerable.call(object, symbol);
	      });
	    };
	
	    /**
	     * Creates an array of the own and inherited enumerable symbols of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of symbols.
	     */
	    var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
	      var result = [];
	      while (object) {
	        arrayPush(result, getSymbols(object));
	        object = getPrototype(object);
	      }
	      return result;
	    };
	
	    /**
	     * Gets the `toStringTag` of `value`.
	     *
	     * @private
	     * @param {*} value The value to query.
	     * @returns {string} Returns the `toStringTag`.
	     */
	    var getTag = baseGetTag;
	
	    // Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
	    if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
	        (Map && getTag(new Map) != mapTag) ||
	        (Promise && getTag(Promise.resolve()) != promiseTag) ||
	        (Set && getTag(new Set) != setTag) ||
	        (WeakMap && getTag(new WeakMap) != weakMapTag)) {
	      getTag = function(value) {
	        var result = baseGetTag(value),
	            Ctor = result == objectTag ? value.constructor : undefined,
	            ctorString = Ctor ? toSource(Ctor) : '';
	
	        if (ctorString) {
	          switch (ctorString) {
	            case dataViewCtorString: return dataViewTag;
	            case mapCtorString: return mapTag;
	            case promiseCtorString: return promiseTag;
	            case setCtorString: return setTag;
	            case weakMapCtorString: return weakMapTag;
	          }
	        }
	        return result;
	      };
	    }
	
	    /**
	     * Gets the view, applying any `transforms` to the `start` and `end` positions.
	     *
	     * @private
	     * @param {number} start The start of the view.
	     * @param {number} end The end of the view.
	     * @param {Array} transforms The transformations to apply to the view.
	     * @returns {Object} Returns an object containing the `start` and `end`
	     *  positions of the view.
	     */
	    function getView(start, end, transforms) {
	      var index = -1,
	          length = transforms.length;
	
	      while (++index < length) {
	        var data = transforms[index],
	            size = data.size;
	
	        switch (data.type) {
	          case 'drop':      start += size; break;
	          case 'dropRight': end -= size; break;
	          case 'take':      end = nativeMin(end, start + size); break;
	          case 'takeRight': start = nativeMax(start, end - size); break;
	        }
	      }
	      return { 'start': start, 'end': end };
	    }
	
	    /**
	     * Extracts wrapper details from the `source` body comment.
	     *
	     * @private
	     * @param {string} source The source to inspect.
	     * @returns {Array} Returns the wrapper details.
	     */
	    function getWrapDetails(source) {
	      var match = source.match(reWrapDetails);
	      return match ? match[1].split(reSplitDetails) : [];
	    }
	
	    /**
	     * Checks if `path` exists on `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path to check.
	     * @param {Function} hasFunc The function to check properties.
	     * @returns {boolean} Returns `true` if `path` exists, else `false`.
	     */
	    function hasPath(object, path, hasFunc) {
	      path = castPath(path, object);
	
	      var index = -1,
	          length = path.length,
	          result = false;
	
	      while (++index < length) {
	        var key = toKey(path[index]);
	        if (!(result = object != null && hasFunc(object, key))) {
	          break;
	        }
	        object = object[key];
	      }
	      if (result || ++index != length) {
	        return result;
	      }
	      length = object == null ? 0 : object.length;
	      return !!length && isLength(length) && isIndex(key, length) &&
	        (isArray(object) || isArguments(object));
	    }
	
	    /**
	     * Initializes an array clone.
	     *
	     * @private
	     * @param {Array} array The array to clone.
	     * @returns {Array} Returns the initialized clone.
	     */
	    function initCloneArray(array) {
	      var length = array.length,
	          result = array.constructor(length);
	
	      // Add properties assigned by `RegExp#exec`.
	      if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
	        result.index = array.index;
	        result.input = array.input;
	      }
	      return result;
	    }
	
	    /**
	     * Initializes an object clone.
	     *
	     * @private
	     * @param {Object} object The object to clone.
	     * @returns {Object} Returns the initialized clone.
	     */
	    function initCloneObject(object) {
	      return (typeof object.constructor == 'function' && !isPrototype(object))
	        ? baseCreate(getPrototype(object))
	        : {};
	    }
	
	    /**
	     * Initializes an object clone based on its `toStringTag`.
	     *
	     * **Note:** This function only supports cloning values with tags of
	     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
	     *
	     * @private
	     * @param {Object} object The object to clone.
	     * @param {string} tag The `toStringTag` of the object to clone.
	     * @param {Function} cloneFunc The function to clone values.
	     * @param {boolean} [isDeep] Specify a deep clone.
	     * @returns {Object} Returns the initialized clone.
	     */
	    function initCloneByTag(object, tag, cloneFunc, isDeep) {
	      var Ctor = object.constructor;
	      switch (tag) {
	        case arrayBufferTag:
	          return cloneArrayBuffer(object);
	
	        case boolTag:
	        case dateTag:
	          return new Ctor(+object);
	
	        case dataViewTag:
	          return cloneDataView(object, isDeep);
	
	        case float32Tag: case float64Tag:
	        case int8Tag: case int16Tag: case int32Tag:
	        case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
	          return cloneTypedArray(object, isDeep);
	
	        case mapTag:
	          return cloneMap(object, isDeep, cloneFunc);
	
	        case numberTag:
	        case stringTag:
	          return new Ctor(object);
	
	        case regexpTag:
	          return cloneRegExp(object);
	
	        case setTag:
	          return cloneSet(object, isDeep, cloneFunc);
	
	        case symbolTag:
	          return cloneSymbol(object);
	      }
	    }
	
	    /**
	     * Inserts wrapper `details` in a comment at the top of the `source` body.
	     *
	     * @private
	     * @param {string} source The source to modify.
	     * @returns {Array} details The details to insert.
	     * @returns {string} Returns the modified source.
	     */
	    function insertWrapDetails(source, details) {
	      var length = details.length;
	      if (!length) {
	        return source;
	      }
	      var lastIndex = length - 1;
	      details[lastIndex] = (length > 1 ? '& ' : '') + details[lastIndex];
	      details = details.join(length > 2 ? ', ' : ' ');
	      return source.replace(reWrapComment, '{\n/* [wrapped with ' + details + '] */\n');
	    }
	
	    /**
	     * Checks if `value` is a flattenable `arguments` object or array.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
	     */
	    function isFlattenable(value) {
	      return isArray(value) || isArguments(value) ||
	        !!(spreadableSymbol && value && value[spreadableSymbol]);
	    }
	
	    /**
	     * Checks if `value` is a valid array-like index.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
	     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
	     */
	    function isIndex(value, length) {
	      length = length == null ? MAX_SAFE_INTEGER : length;
	      return !!length &&
	        (typeof value == 'number' || reIsUint.test(value)) &&
	        (value > -1 && value % 1 == 0 && value < length);
	    }
	
	    /**
	     * Checks if the given arguments are from an iteratee call.
	     *
	     * @private
	     * @param {*} value The potential iteratee value argument.
	     * @param {*} index The potential iteratee index or key argument.
	     * @param {*} object The potential iteratee object argument.
	     * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
	     *  else `false`.
	     */
	    function isIterateeCall(value, index, object) {
	      if (!isObject(object)) {
	        return false;
	      }
	      var type = typeof index;
	      if (type == 'number'
	            ? (isArrayLike(object) && isIndex(index, object.length))
	            : (type == 'string' && index in object)
	          ) {
	        return eq(object[index], value);
	      }
	      return false;
	    }
	
	    /**
	     * Checks if `value` is a property name and not a property path.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @param {Object} [object] The object to query keys on.
	     * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
	     */
	    function isKey(value, object) {
	      if (isArray(value)) {
	        return false;
	      }
	      var type = typeof value;
	      if (type == 'number' || type == 'symbol' || type == 'boolean' ||
	          value == null || isSymbol(value)) {
	        return true;
	      }
	      return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
	        (object != null && value in Object(object));
	    }
	
	    /**
	     * Checks if `value` is suitable for use as unique object key.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	     */
	    function isKeyable(value) {
	      var type = typeof value;
	      return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
	        ? (value !== '__proto__')
	        : (value === null);
	    }
	
	    /**
	     * Checks if `func` has a lazy counterpart.
	     *
	     * @private
	     * @param {Function} func The function to check.
	     * @returns {boolean} Returns `true` if `func` has a lazy counterpart,
	     *  else `false`.
	     */
	    function isLaziable(func) {
	      var funcName = getFuncName(func),
	          other = lodash[funcName];
	
	      if (typeof other != 'function' || !(funcName in LazyWrapper.prototype)) {
	        return false;
	      }
	      if (func === other) {
	        return true;
	      }
	      var data = getData(other);
	      return !!data && func === data[0];
	    }
	
	    /**
	     * Checks if `func` has its source masked.
	     *
	     * @private
	     * @param {Function} func The function to check.
	     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
	     */
	    function isMasked(func) {
	      return !!maskSrcKey && (maskSrcKey in func);
	    }
	
	    /**
	     * Checks if `func` is capable of being masked.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `func` is maskable, else `false`.
	     */
	    var isMaskable = coreJsData ? isFunction : stubFalse;
	
	    /**
	     * Checks if `value` is likely a prototype object.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
	     */
	    function isPrototype(value) {
	      var Ctor = value && value.constructor,
	          proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;
	
	      return value === proto;
	    }
	
	    /**
	     * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` if suitable for strict
	     *  equality comparisons, else `false`.
	     */
	    function isStrictComparable(value) {
	      return value === value && !isObject(value);
	    }
	
	    /**
	     * A specialized version of `matchesProperty` for source values suitable
	     * for strict equality comparisons, i.e. `===`.
	     *
	     * @private
	     * @param {string} key The key of the property to get.
	     * @param {*} srcValue The value to match.
	     * @returns {Function} Returns the new spec function.
	     */
	    function matchesStrictComparable(key, srcValue) {
	      return function(object) {
	        if (object == null) {
	          return false;
	        }
	        return object[key] === srcValue &&
	          (srcValue !== undefined || (key in Object(object)));
	      };
	    }
	
	    /**
	     * A specialized version of `_.memoize` which clears the memoized function's
	     * cache when it exceeds `MAX_MEMOIZE_SIZE`.
	     *
	     * @private
	     * @param {Function} func The function to have its output memoized.
	     * @returns {Function} Returns the new memoized function.
	     */
	    function memoizeCapped(func) {
	      var result = memoize(func, function(key) {
	        if (cache.size === MAX_MEMOIZE_SIZE) {
	          cache.clear();
	        }
	        return key;
	      });
	
	      var cache = result.cache;
	      return result;
	    }
	
	    /**
	     * Merges the function metadata of `source` into `data`.
	     *
	     * Merging metadata reduces the number of wrappers used to invoke a function.
	     * This is possible because methods like `_.bind`, `_.curry`, and `_.partial`
	     * may be applied regardless of execution order. Methods like `_.ary` and
	     * `_.rearg` modify function arguments, making the order in which they are
	     * executed important, preventing the merging of metadata. However, we make
	     * an exception for a safe combined case where curried functions have `_.ary`
	     * and or `_.rearg` applied.
	     *
	     * @private
	     * @param {Array} data The destination metadata.
	     * @param {Array} source The source metadata.
	     * @returns {Array} Returns `data`.
	     */
	    function mergeData(data, source) {
	      var bitmask = data[1],
	          srcBitmask = source[1],
	          newBitmask = bitmask | srcBitmask,
	          isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
	
	      var isCombo =
	        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_CURRY_FLAG)) ||
	        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_REARG_FLAG) && (data[7].length <= source[8])) ||
	        ((srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG)) && (source[7].length <= source[8]) && (bitmask == WRAP_CURRY_FLAG));
	
	      // Exit early if metadata can't be merged.
	      if (!(isCommon || isCombo)) {
	        return data;
	      }
	      // Use source `thisArg` if available.
	      if (srcBitmask & WRAP_BIND_FLAG) {
	        data[2] = source[2];
	        // Set when currying a bound function.
	        newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
	      }
	      // Compose partial arguments.
	      var value = source[3];
	      if (value) {
	        var partials = data[3];
	        data[3] = partials ? composeArgs(partials, value, source[4]) : value;
	        data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
	      }
	      // Compose partial right arguments.
	      value = source[5];
	      if (value) {
	        partials = data[5];
	        data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
	        data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
	      }
	      // Use source `argPos` if available.
	      value = source[7];
	      if (value) {
	        data[7] = value;
	      }
	      // Use source `ary` if it's smaller.
	      if (srcBitmask & WRAP_ARY_FLAG) {
	        data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
	      }
	      // Use source `arity` if one is not provided.
	      if (data[9] == null) {
	        data[9] = source[9];
	      }
	      // Use source `func` and merge bitmasks.
	      data[0] = source[0];
	      data[1] = newBitmask;
	
	      return data;
	    }
	
	    /**
	     * This function is like
	     * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
	     * except that it includes inherited enumerable properties.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property names.
	     */
	    function nativeKeysIn(object) {
	      var result = [];
	      if (object != null) {
	        for (var key in Object(object)) {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	
	    /**
	     * Converts `value` to a string using `Object.prototype.toString`.
	     *
	     * @private
	     * @param {*} value The value to convert.
	     * @returns {string} Returns the converted string.
	     */
	    function objectToString(value) {
	      return nativeObjectToString.call(value);
	    }
	
	    /**
	     * A specialized version of `baseRest` which transforms the rest array.
	     *
	     * @private
	     * @param {Function} func The function to apply a rest parameter to.
	     * @param {number} [start=func.length-1] The start position of the rest parameter.
	     * @param {Function} transform The rest array transform.
	     * @returns {Function} Returns the new function.
	     */
	    function overRest(func, start, transform) {
	      start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
	      return function() {
	        var args = arguments,
	            index = -1,
	            length = nativeMax(args.length - start, 0),
	            array = Array(length);
	
	        while (++index < length) {
	          array[index] = args[start + index];
	        }
	        index = -1;
	        var otherArgs = Array(start + 1);
	        while (++index < start) {
	          otherArgs[index] = args[index];
	        }
	        otherArgs[start] = transform(array);
	        return apply(func, this, otherArgs);
	      };
	    }
	
	    /**
	     * Gets the parent value at `path` of `object`.
	     *
	     * @private
	     * @param {Object} object The object to query.
	     * @param {Array} path The path to get the parent value of.
	     * @returns {*} Returns the parent value.
	     */
	    function parent(object, path) {
	      return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
	    }
	
	    /**
	     * Reorder `array` according to the specified indexes where the element at
	     * the first index is assigned as the first element, the element at
	     * the second index is assigned as the second element, and so on.
	     *
	     * @private
	     * @param {Array} array The array to reorder.
	     * @param {Array} indexes The arranged array indexes.
	     * @returns {Array} Returns `array`.
	     */
	    function reorder(array, indexes) {
	      var arrLength = array.length,
	          length = nativeMin(indexes.length, arrLength),
	          oldArray = copyArray(array);
	
	      while (length--) {
	        var index = indexes[length];
	        array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined;
	      }
	      return array;
	    }
	
	    /**
	     * Sets metadata for `func`.
	     *
	     * **Note:** If this function becomes hot, i.e. is invoked a lot in a short
	     * period of time, it will trip its breaker and transition to an identity
	     * function to avoid garbage collection pauses in V8. See
	     * [V8 issue 2070](https://bugs.chromium.org/p/v8/issues/detail?id=2070)
	     * for more details.
	     *
	     * @private
	     * @param {Function} func The function to associate metadata with.
	     * @param {*} data The metadata.
	     * @returns {Function} Returns `func`.
	     */
	    var setData = shortOut(baseSetData);
	
	    /**
	     * A simple wrapper around the global [`setTimeout`](https://mdn.io/setTimeout).
	     *
	     * @private
	     * @param {Function} func The function to delay.
	     * @param {number} wait The number of milliseconds to delay invocation.
	     * @returns {number|Object} Returns the timer id or timeout object.
	     */
	    var setTimeout = ctxSetTimeout || function(func, wait) {
	      return root.setTimeout(func, wait);
	    };
	
	    /**
	     * Sets the `toString` method of `func` to return `string`.
	     *
	     * @private
	     * @param {Function} func The function to modify.
	     * @param {Function} string The `toString` result.
	     * @returns {Function} Returns `func`.
	     */
	    var setToString = shortOut(baseSetToString);
	
	    /**
	     * Sets the `toString` method of `wrapper` to mimic the source of `reference`
	     * with wrapper details in a comment at the top of the source body.
	     *
	     * @private
	     * @param {Function} wrapper The function to modify.
	     * @param {Function} reference The reference function.
	     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
	     * @returns {Function} Returns `wrapper`.
	     */
	    function setWrapToString(wrapper, reference, bitmask) {
	      var source = (reference + '');
	      return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
	    }
	
	    /**
	     * Creates a function that'll short out and invoke `identity` instead
	     * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
	     * milliseconds.
	     *
	     * @private
	     * @param {Function} func The function to restrict.
	     * @returns {Function} Returns the new shortable function.
	     */
	    function shortOut(func) {
	      var count = 0,
	          lastCalled = 0;
	
	      return function() {
	        var stamp = nativeNow(),
	            remaining = HOT_SPAN - (stamp - lastCalled);
	
	        lastCalled = stamp;
	        if (remaining > 0) {
	          if (++count >= HOT_COUNT) {
	            return arguments[0];
	          }
	        } else {
	          count = 0;
	        }
	        return func.apply(undefined, arguments);
	      };
	    }
	
	    /**
	     * A specialized version of `_.shuffle` which mutates and sets the size of `array`.
	     *
	     * @private
	     * @param {Array} array The array to shuffle.
	     * @param {number} [size=array.length] The size of `array`.
	     * @returns {Array} Returns `array`.
	     */
	    function shuffleSelf(array, size) {
	      var index = -1,
	          length = array.length,
	          lastIndex = length - 1;
	
	      size = size === undefined ? length : size;
	      while (++index < size) {
	        var rand = baseRandom(index, lastIndex),
	            value = array[rand];
	
	        array[rand] = array[index];
	        array[index] = value;
	      }
	      array.length = size;
	      return array;
	    }
	
	    /**
	     * Converts `string` to a property path array.
	     *
	     * @private
	     * @param {string} string The string to convert.
	     * @returns {Array} Returns the property path array.
	     */
	    var stringToPath = memoizeCapped(function(string) {
	      var result = [];
	      if (reLeadingDot.test(string)) {
	        result.push('');
	      }
	      string.replace(rePropName, function(match, number, quote, string) {
	        result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
	      });
	      return result;
	    });
	
	    /**
	     * Converts `value` to a string key if it's not a string or symbol.
	     *
	     * @private
	     * @param {*} value The value to inspect.
	     * @returns {string|symbol} Returns the key.
	     */
	    function toKey(value) {
	      if (typeof value == 'string' || isSymbol(value)) {
	        return value;
	      }
	      var result = (value + '');
	      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	    }
	
	    /**
	     * Converts `func` to its source code.
	     *
	     * @private
	     * @param {Function} func The function to convert.
	     * @returns {string} Returns the source code.
	     */
	    function toSource(func) {
	      if (func != null) {
	        try {
	          return funcToString.call(func);
	        } catch (e) {}
	        try {
	          return (func + '');
	        } catch (e) {}
	      }
	      return '';
	    }
	
	    /**
	     * Updates wrapper `details` based on `bitmask` flags.
	     *
	     * @private
	     * @returns {Array} details The details to modify.
	     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
	     * @returns {Array} Returns `details`.
	     */
	    function updateWrapDetails(details, bitmask) {
	      arrayEach(wrapFlags, function(pair) {
	        var value = '_.' + pair[0];
	        if ((bitmask & pair[1]) && !arrayIncludes(details, value)) {
	          details.push(value);
	        }
	      });
	      return details.sort();
	    }
	
	    /**
	     * Creates a clone of `wrapper`.
	     *
	     * @private
	     * @param {Object} wrapper The wrapper to clone.
	     * @returns {Object} Returns the cloned wrapper.
	     */
	    function wrapperClone(wrapper) {
	      if (wrapper instanceof LazyWrapper) {
	        return wrapper.clone();
	      }
	      var result = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
	      result.__actions__ = copyArray(wrapper.__actions__);
	      result.__index__  = wrapper.__index__;
	      result.__values__ = wrapper.__values__;
	      return result;
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates an array of elements split into groups the length of `size`.
	     * If `array` can't be split evenly, the final chunk will be the remaining
	     * elements.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to process.
	     * @param {number} [size=1] The length of each chunk
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Array} Returns the new array of chunks.
	     * @example
	     *
	     * _.chunk(['a', 'b', 'c', 'd'], 2);
	     * // => [['a', 'b'], ['c', 'd']]
	     *
	     * _.chunk(['a', 'b', 'c', 'd'], 3);
	     * // => [['a', 'b', 'c'], ['d']]
	     */
	    function chunk(array, size, guard) {
	      if ((guard ? isIterateeCall(array, size, guard) : size === undefined)) {
	        size = 1;
	      } else {
	        size = nativeMax(toInteger(size), 0);
	      }
	      var length = array == null ? 0 : array.length;
	      if (!length || size < 1) {
	        return [];
	      }
	      var index = 0,
	          resIndex = 0,
	          result = Array(nativeCeil(length / size));
	
	      while (index < length) {
	        result[resIndex++] = baseSlice(array, index, (index += size));
	      }
	      return result;
	    }
	
	    /**
	     * Creates an array with all falsey values removed. The values `false`, `null`,
	     * `0`, `""`, `undefined`, and `NaN` are falsey.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to compact.
	     * @returns {Array} Returns the new array of filtered values.
	     * @example
	     *
	     * _.compact([0, 1, false, 2, '', 3]);
	     * // => [1, 2, 3]
	     */
	    function compact(array) {
	      var index = -1,
	          length = array == null ? 0 : array.length,
	          resIndex = 0,
	          result = [];
	
	      while (++index < length) {
	        var value = array[index];
	        if (value) {
	          result[resIndex++] = value;
	        }
	      }
	      return result;
	    }
	
	    /**
	     * Creates a new array concatenating `array` with any additional arrays
	     * and/or values.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to concatenate.
	     * @param {...*} [values] The values to concatenate.
	     * @returns {Array} Returns the new concatenated array.
	     * @example
	     *
	     * var array = [1];
	     * var other = _.concat(array, 2, [3], [[4]]);
	     *
	     * console.log(other);
	     * // => [1, 2, 3, [4]]
	     *
	     * console.log(array);
	     * // => [1]
	     */
	    function concat() {
	      var length = arguments.length;
	      if (!length) {
	        return [];
	      }
	      var args = Array(length - 1),
	          array = arguments[0],
	          index = length;
	
	      while (index--) {
	        args[index - 1] = arguments[index];
	      }
	      return arrayPush(isArray(array) ? copyArray(array) : [array], baseFlatten(args, 1));
	    }
	
	    /**
	     * Creates an array of `array` values not included in the other given arrays
	     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons. The order and references of result values are
	     * determined by the first array.
	     *
	     * **Note:** Unlike `_.pullAll`, this method returns a new array.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {...Array} [values] The values to exclude.
	     * @returns {Array} Returns the new array of filtered values.
	     * @see _.without, _.xor
	     * @example
	     *
	     * _.difference([2, 1], [2, 3]);
	     * // => [1]
	     */
	    var difference = baseRest(function(array, values) {
	      return isArrayLikeObject(array)
	        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true))
	        : [];
	    });
	
	    /**
	     * This method is like `_.difference` except that it accepts `iteratee` which
	     * is invoked for each element of `array` and `values` to generate the criterion
	     * by which they're compared. The order and references of result values are
	     * determined by the first array. The iteratee is invoked with one argument:
	     * (value).
	     *
	     * **Note:** Unlike `_.pullAllBy`, this method returns a new array.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {...Array} [values] The values to exclude.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {Array} Returns the new array of filtered values.
	     * @example
	     *
	     * _.differenceBy([2.1, 1.2], [2.3, 3.4], Math.floor);
	     * // => [1.2]
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.differenceBy([{ 'x': 2 }, { 'x': 1 }], [{ 'x': 1 }], 'x');
	     * // => [{ 'x': 2 }]
	     */
	    var differenceBy = baseRest(function(array, values) {
	      var iteratee = last(values);
	      if (isArrayLikeObject(iteratee)) {
	        iteratee = undefined;
	      }
	      return isArrayLikeObject(array)
	        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), getIteratee(iteratee, 2))
	        : [];
	    });
	
	    /**
	     * This method is like `_.difference` except that it accepts `comparator`
	     * which is invoked to compare elements of `array` to `values`. The order and
	     * references of result values are determined by the first array. The comparator
	     * is invoked with two arguments: (arrVal, othVal).
	     *
	     * **Note:** Unlike `_.pullAllWith`, this method returns a new array.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {...Array} [values] The values to exclude.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new array of filtered values.
	     * @example
	     *
	     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
	     *
	     * _.differenceWith(objects, [{ 'x': 1, 'y': 2 }], _.isEqual);
	     * // => [{ 'x': 2, 'y': 1 }]
	     */
	    var differenceWith = baseRest(function(array, values) {
	      var comparator = last(values);
	      if (isArrayLikeObject(comparator)) {
	        comparator = undefined;
	      }
	      return isArrayLikeObject(array)
	        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), undefined, comparator)
	        : [];
	    });
	
	    /**
	     * Creates a slice of `array` with `n` elements dropped from the beginning.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.5.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {number} [n=1] The number of elements to drop.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * _.drop([1, 2, 3]);
	     * // => [2, 3]
	     *
	     * _.drop([1, 2, 3], 2);
	     * // => [3]
	     *
	     * _.drop([1, 2, 3], 5);
	     * // => []
	     *
	     * _.drop([1, 2, 3], 0);
	     * // => [1, 2, 3]
	     */
	    function drop(array, n, guard) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      n = (guard || n === undefined) ? 1 : toInteger(n);
	      return baseSlice(array, n < 0 ? 0 : n, length);
	    }
	
	    /**
	     * Creates a slice of `array` with `n` elements dropped from the end.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {number} [n=1] The number of elements to drop.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * _.dropRight([1, 2, 3]);
	     * // => [1, 2]
	     *
	     * _.dropRight([1, 2, 3], 2);
	     * // => [1]
	     *
	     * _.dropRight([1, 2, 3], 5);
	     * // => []
	     *
	     * _.dropRight([1, 2, 3], 0);
	     * // => [1, 2, 3]
	     */
	    function dropRight(array, n, guard) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      n = (guard || n === undefined) ? 1 : toInteger(n);
	      n = length - n;
	      return baseSlice(array, 0, n < 0 ? 0 : n);
	    }
	
	    /**
	     * Creates a slice of `array` excluding elements dropped from the end.
	     * Elements are dropped until `predicate` returns falsey. The predicate is
	     * invoked with three arguments: (value, index, array).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'active': true },
	     *   { 'user': 'fred',    'active': false },
	     *   { 'user': 'pebbles', 'active': false }
	     * ];
	     *
	     * _.dropRightWhile(users, function(o) { return !o.active; });
	     * // => objects for ['barney']
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.dropRightWhile(users, { 'user': 'pebbles', 'active': false });
	     * // => objects for ['barney', 'fred']
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.dropRightWhile(users, ['active', false]);
	     * // => objects for ['barney']
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.dropRightWhile(users, 'active');
	     * // => objects for ['barney', 'fred', 'pebbles']
	     */
	    function dropRightWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3), true, true)
	        : [];
	    }
	
	    /**
	     * Creates a slice of `array` excluding elements dropped from the beginning.
	     * Elements are dropped until `predicate` returns falsey. The predicate is
	     * invoked with three arguments: (value, index, array).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'active': false },
	     *   { 'user': 'fred',    'active': false },
	     *   { 'user': 'pebbles', 'active': true }
	     * ];
	     *
	     * _.dropWhile(users, function(o) { return !o.active; });
	     * // => objects for ['pebbles']
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.dropWhile(users, { 'user': 'barney', 'active': false });
	     * // => objects for ['fred', 'pebbles']
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.dropWhile(users, ['active', false]);
	     * // => objects for ['pebbles']
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.dropWhile(users, 'active');
	     * // => objects for ['barney', 'fred', 'pebbles']
	     */
	    function dropWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3), true)
	        : [];
	    }
	
	    /**
	     * Fills elements of `array` with `value` from `start` up to, but not
	     * including, `end`.
	     *
	     * **Note:** This method mutates `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.2.0
	     * @category Array
	     * @param {Array} array The array to fill.
	     * @param {*} value The value to fill `array` with.
	     * @param {number} [start=0] The start position.
	     * @param {number} [end=array.length] The end position.
	     * @returns {Array} Returns `array`.
	     * @example
	     *
	     * var array = [1, 2, 3];
	     *
	     * _.fill(array, 'a');
	     * console.log(array);
	     * // => ['a', 'a', 'a']
	     *
	     * _.fill(Array(3), 2);
	     * // => [2, 2, 2]
	     *
	     * _.fill([4, 6, 8, 10], '*', 1, 3);
	     * // => [4, '*', '*', 10]
	     */
	    function fill(array, value, start, end) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      if (start && typeof start != 'number' && isIterateeCall(array, value, start)) {
	        start = 0;
	        end = length;
	      }
	      return baseFill(array, value, start, end);
	    }
	
	    /**
	     * This method is like `_.find` except that it returns the index of the first
	     * element `predicate` returns truthy for instead of the element itself.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.1.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @param {number} [fromIndex=0] The index to search from.
	     * @returns {number} Returns the index of the found element, else `-1`.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'active': false },
	     *   { 'user': 'fred',    'active': false },
	     *   { 'user': 'pebbles', 'active': true }
	     * ];
	     *
	     * _.findIndex(users, function(o) { return o.user == 'barney'; });
	     * // => 0
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.findIndex(users, { 'user': 'fred', 'active': false });
	     * // => 1
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.findIndex(users, ['active', false]);
	     * // => 0
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.findIndex(users, 'active');
	     * // => 2
	     */
	    function findIndex(array, predicate, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = fromIndex == null ? 0 : toInteger(fromIndex);
	      if (index < 0) {
	        index = nativeMax(length + index, 0);
	      }
	      return baseFindIndex(array, getIteratee(predicate, 3), index);
	    }
	
	    /**
	     * This method is like `_.findIndex` except that it iterates over elements
	     * of `collection` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @param {number} [fromIndex=array.length-1] The index to search from.
	     * @returns {number} Returns the index of the found element, else `-1`.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'active': true },
	     *   { 'user': 'fred',    'active': false },
	     *   { 'user': 'pebbles', 'active': false }
	     * ];
	     *
	     * _.findLastIndex(users, function(o) { return o.user == 'pebbles'; });
	     * // => 2
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.findLastIndex(users, { 'user': 'barney', 'active': true });
	     * // => 0
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.findLastIndex(users, ['active', false]);
	     * // => 2
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.findLastIndex(users, 'active');
	     * // => 0
	     */
	    function findLastIndex(array, predicate, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = length - 1;
	      if (fromIndex !== undefined) {
	        index = toInteger(fromIndex);
	        index = fromIndex < 0
	          ? nativeMax(length + index, 0)
	          : nativeMin(index, length - 1);
	      }
	      return baseFindIndex(array, getIteratee(predicate, 3), index, true);
	    }
	
	    /**
	     * Flattens `array` a single level deep.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to flatten.
	     * @returns {Array} Returns the new flattened array.
	     * @example
	     *
	     * _.flatten([1, [2, [3, [4]], 5]]);
	     * // => [1, 2, [3, [4]], 5]
	     */
	    function flatten(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseFlatten(array, 1) : [];
	    }
	
	    /**
	     * Recursively flattens `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to flatten.
	     * @returns {Array} Returns the new flattened array.
	     * @example
	     *
	     * _.flattenDeep([1, [2, [3, [4]], 5]]);
	     * // => [1, 2, 3, 4, 5]
	     */
	    function flattenDeep(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseFlatten(array, INFINITY) : [];
	    }
	
	    /**
	     * Recursively flatten `array` up to `depth` times.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.4.0
	     * @category Array
	     * @param {Array} array The array to flatten.
	     * @param {number} [depth=1] The maximum recursion depth.
	     * @returns {Array} Returns the new flattened array.
	     * @example
	     *
	     * var array = [1, [2, [3, [4]], 5]];
	     *
	     * _.flattenDepth(array, 1);
	     * // => [1, 2, [3, [4]], 5]
	     *
	     * _.flattenDepth(array, 2);
	     * // => [1, 2, 3, [4], 5]
	     */
	    function flattenDepth(array, depth) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      depth = depth === undefined ? 1 : toInteger(depth);
	      return baseFlatten(array, depth);
	    }
	
	    /**
	     * The inverse of `_.toPairs`; this method returns an object composed
	     * from key-value `pairs`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} pairs The key-value pairs.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * _.fromPairs([['a', 1], ['b', 2]]);
	     * // => { 'a': 1, 'b': 2 }
	     */
	    function fromPairs(pairs) {
	      var index = -1,
	          length = pairs == null ? 0 : pairs.length,
	          result = {};
	
	      while (++index < length) {
	        var pair = pairs[index];
	        result[pair[0]] = pair[1];
	      }
	      return result;
	    }
	
	    /**
	     * Gets the first element of `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @alias first
	     * @category Array
	     * @param {Array} array The array to query.
	     * @returns {*} Returns the first element of `array`.
	     * @example
	     *
	     * _.head([1, 2, 3]);
	     * // => 1
	     *
	     * _.head([]);
	     * // => undefined
	     */
	    function head(array) {
	      return (array && array.length) ? array[0] : undefined;
	    }
	
	    /**
	     * Gets the index at which the first occurrence of `value` is found in `array`
	     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons. If `fromIndex` is negative, it's used as the
	     * offset from the end of `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {*} value The value to search for.
	     * @param {number} [fromIndex=0] The index to search from.
	     * @returns {number} Returns the index of the matched value, else `-1`.
	     * @example
	     *
	     * _.indexOf([1, 2, 1, 2], 2);
	     * // => 1
	     *
	     * // Search from the `fromIndex`.
	     * _.indexOf([1, 2, 1, 2], 2, 2);
	     * // => 3
	     */
	    function indexOf(array, value, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = fromIndex == null ? 0 : toInteger(fromIndex);
	      if (index < 0) {
	        index = nativeMax(length + index, 0);
	      }
	      return baseIndexOf(array, value, index);
	    }
	
	    /**
	     * Gets all but the last element of `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * _.initial([1, 2, 3]);
	     * // => [1, 2]
	     */
	    function initial(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseSlice(array, 0, -1) : [];
	    }
	
	    /**
	     * Creates an array of unique values that are included in all given arrays
	     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons. The order and references of result values are
	     * determined by the first array.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @returns {Array} Returns the new array of intersecting values.
	     * @example
	     *
	     * _.intersection([2, 1], [2, 3]);
	     * // => [2]
	     */
	    var intersection = baseRest(function(arrays) {
	      var mapped = arrayMap(arrays, castArrayLikeObject);
	      return (mapped.length && mapped[0] === arrays[0])
	        ? baseIntersection(mapped)
	        : [];
	    });
	
	    /**
	     * This method is like `_.intersection` except that it accepts `iteratee`
	     * which is invoked for each element of each `arrays` to generate the criterion
	     * by which they're compared. The order and references of result values are
	     * determined by the first array. The iteratee is invoked with one argument:
	     * (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {Array} Returns the new array of intersecting values.
	     * @example
	     *
	     * _.intersectionBy([2.1, 1.2], [2.3, 3.4], Math.floor);
	     * // => [2.1]
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.intersectionBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
	     * // => [{ 'x': 1 }]
	     */
	    var intersectionBy = baseRest(function(arrays) {
	      var iteratee = last(arrays),
	          mapped = arrayMap(arrays, castArrayLikeObject);
	
	      if (iteratee === last(mapped)) {
	        iteratee = undefined;
	      } else {
	        mapped.pop();
	      }
	      return (mapped.length && mapped[0] === arrays[0])
	        ? baseIntersection(mapped, getIteratee(iteratee, 2))
	        : [];
	    });
	
	    /**
	     * This method is like `_.intersection` except that it accepts `comparator`
	     * which is invoked to compare elements of `arrays`. The order and references
	     * of result values are determined by the first array. The comparator is
	     * invoked with two arguments: (arrVal, othVal).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new array of intersecting values.
	     * @example
	     *
	     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
	     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
	     *
	     * _.intersectionWith(objects, others, _.isEqual);
	     * // => [{ 'x': 1, 'y': 2 }]
	     */
	    var intersectionWith = baseRest(function(arrays) {
	      var comparator = last(arrays),
	          mapped = arrayMap(arrays, castArrayLikeObject);
	
	      comparator = typeof comparator == 'function' ? comparator : undefined;
	      if (comparator) {
	        mapped.pop();
	      }
	      return (mapped.length && mapped[0] === arrays[0])
	        ? baseIntersection(mapped, undefined, comparator)
	        : [];
	    });
	
	    /**
	     * Converts all elements in `array` into a string separated by `separator`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to convert.
	     * @param {string} [separator=','] The element separator.
	     * @returns {string} Returns the joined string.
	     * @example
	     *
	     * _.join(['a', 'b', 'c'], '~');
	     * // => 'a~b~c'
	     */
	    function join(array, separator) {
	      return array == null ? '' : nativeJoin.call(array, separator);
	    }
	
	    /**
	     * Gets the last element of `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @returns {*} Returns the last element of `array`.
	     * @example
	     *
	     * _.last([1, 2, 3]);
	     * // => 3
	     */
	    function last(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? array[length - 1] : undefined;
	    }
	
	    /**
	     * This method is like `_.indexOf` except that it iterates over elements of
	     * `array` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {*} value The value to search for.
	     * @param {number} [fromIndex=array.length-1] The index to search from.
	     * @returns {number} Returns the index of the matched value, else `-1`.
	     * @example
	     *
	     * _.lastIndexOf([1, 2, 1, 2], 2);
	     * // => 3
	     *
	     * // Search from the `fromIndex`.
	     * _.lastIndexOf([1, 2, 1, 2], 2, 2);
	     * // => 1
	     */
	    function lastIndexOf(array, value, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = length;
	      if (fromIndex !== undefined) {
	        index = toInteger(fromIndex);
	        index = index < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
	      }
	      return value === value
	        ? strictLastIndexOf(array, value, index)
	        : baseFindIndex(array, baseIsNaN, index, true);
	    }
	
	    /**
	     * Gets the element at index `n` of `array`. If `n` is negative, the nth
	     * element from the end is returned.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.11.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {number} [n=0] The index of the element to return.
	     * @returns {*} Returns the nth element of `array`.
	     * @example
	     *
	     * var array = ['a', 'b', 'c', 'd'];
	     *
	     * _.nth(array, 1);
	     * // => 'b'
	     *
	     * _.nth(array, -2);
	     * // => 'c';
	     */
	    function nth(array, n) {
	      return (array && array.length) ? baseNth(array, toInteger(n)) : undefined;
	    }
	
	    /**
	     * Removes all given values from `array` using
	     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons.
	     *
	     * **Note:** Unlike `_.without`, this method mutates `array`. Use `_.remove`
	     * to remove elements from an array by predicate.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Array
	     * @param {Array} array The array to modify.
	     * @param {...*} [values] The values to remove.
	     * @returns {Array} Returns `array`.
	     * @example
	     *
	     * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
	     *
	     * _.pull(array, 'a', 'c');
	     * console.log(array);
	     * // => ['b', 'b']
	     */
	    var pull = baseRest(pullAll);
	
	    /**
	     * This method is like `_.pull` except that it accepts an array of values to remove.
	     *
	     * **Note:** Unlike `_.difference`, this method mutates `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to modify.
	     * @param {Array} values The values to remove.
	     * @returns {Array} Returns `array`.
	     * @example
	     *
	     * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
	     *
	     * _.pullAll(array, ['a', 'c']);
	     * console.log(array);
	     * // => ['b', 'b']
	     */
	    function pullAll(array, values) {
	      return (array && array.length && values && values.length)
	        ? basePullAll(array, values)
	        : array;
	    }
	
	    /**
	     * This method is like `_.pullAll` except that it accepts `iteratee` which is
	     * invoked for each element of `array` and `values` to generate the criterion
	     * by which they're compared. The iteratee is invoked with one argument: (value).
	     *
	     * **Note:** Unlike `_.differenceBy`, this method mutates `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to modify.
	     * @param {Array} values The values to remove.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {Array} Returns `array`.
	     * @example
	     *
	     * var array = [{ 'x': 1 }, { 'x': 2 }, { 'x': 3 }, { 'x': 1 }];
	     *
	     * _.pullAllBy(array, [{ 'x': 1 }, { 'x': 3 }], 'x');
	     * console.log(array);
	     * // => [{ 'x': 2 }]
	     */
	    function pullAllBy(array, values, iteratee) {
	      return (array && array.length && values && values.length)
	        ? basePullAll(array, values, getIteratee(iteratee, 2))
	        : array;
	    }
	
	    /**
	     * This method is like `_.pullAll` except that it accepts `comparator` which
	     * is invoked to compare elements of `array` to `values`. The comparator is
	     * invoked with two arguments: (arrVal, othVal).
	     *
	     * **Note:** Unlike `_.differenceWith`, this method mutates `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.6.0
	     * @category Array
	     * @param {Array} array The array to modify.
	     * @param {Array} values The values to remove.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns `array`.
	     * @example
	     *
	     * var array = [{ 'x': 1, 'y': 2 }, { 'x': 3, 'y': 4 }, { 'x': 5, 'y': 6 }];
	     *
	     * _.pullAllWith(array, [{ 'x': 3, 'y': 4 }], _.isEqual);
	     * console.log(array);
	     * // => [{ 'x': 1, 'y': 2 }, { 'x': 5, 'y': 6 }]
	     */
	    function pullAllWith(array, values, comparator) {
	      return (array && array.length && values && values.length)
	        ? basePullAll(array, values, undefined, comparator)
	        : array;
	    }
	
	    /**
	     * Removes elements from `array` corresponding to `indexes` and returns an
	     * array of removed elements.
	     *
	     * **Note:** Unlike `_.at`, this method mutates `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to modify.
	     * @param {...(number|number[])} [indexes] The indexes of elements to remove.
	     * @returns {Array} Returns the new array of removed elements.
	     * @example
	     *
	     * var array = ['a', 'b', 'c', 'd'];
	     * var pulled = _.pullAt(array, [1, 3]);
	     *
	     * console.log(array);
	     * // => ['a', 'c']
	     *
	     * console.log(pulled);
	     * // => ['b', 'd']
	     */
	    var pullAt = flatRest(function(array, indexes) {
	      var length = array == null ? 0 : array.length,
	          result = baseAt(array, indexes);
	
	      basePullAt(array, arrayMap(indexes, function(index) {
	        return isIndex(index, length) ? +index : index;
	      }).sort(compareAscending));
	
	      return result;
	    });
	
	    /**
	     * Removes all elements from `array` that `predicate` returns truthy for
	     * and returns an array of the removed elements. The predicate is invoked
	     * with three arguments: (value, index, array).
	     *
	     * **Note:** Unlike `_.filter`, this method mutates `array`. Use `_.pull`
	     * to pull elements from an array by value.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Array
	     * @param {Array} array The array to modify.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the new array of removed elements.
	     * @example
	     *
	     * var array = [1, 2, 3, 4];
	     * var evens = _.remove(array, function(n) {
	     *   return n % 2 == 0;
	     * });
	     *
	     * console.log(array);
	     * // => [1, 3]
	     *
	     * console.log(evens);
	     * // => [2, 4]
	     */
	    function remove(array, predicate) {
	      var result = [];
	      if (!(array && array.length)) {
	        return result;
	      }
	      var index = -1,
	          indexes = [],
	          length = array.length;
	
	      predicate = getIteratee(predicate, 3);
	      while (++index < length) {
	        var value = array[index];
	        if (predicate(value, index, array)) {
	          result.push(value);
	          indexes.push(index);
	        }
	      }
	      basePullAt(array, indexes);
	      return result;
	    }
	
	    /**
	     * Reverses `array` so that the first element becomes the last, the second
	     * element becomes the second to last, and so on.
	     *
	     * **Note:** This method mutates `array` and is based on
	     * [`Array#reverse`](https://mdn.io/Array/reverse).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to modify.
	     * @returns {Array} Returns `array`.
	     * @example
	     *
	     * var array = [1, 2, 3];
	     *
	     * _.reverse(array);
	     * // => [3, 2, 1]
	     *
	     * console.log(array);
	     * // => [3, 2, 1]
	     */
	    function reverse(array) {
	      return array == null ? array : nativeReverse.call(array);
	    }
	
	    /**
	     * Creates a slice of `array` from `start` up to, but not including, `end`.
	     *
	     * **Note:** This method is used instead of
	     * [`Array#slice`](https://mdn.io/Array/slice) to ensure dense arrays are
	     * returned.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to slice.
	     * @param {number} [start=0] The start position.
	     * @param {number} [end=array.length] The end position.
	     * @returns {Array} Returns the slice of `array`.
	     */
	    function slice(array, start, end) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      if (end && typeof end != 'number' && isIterateeCall(array, start, end)) {
	        start = 0;
	        end = length;
	      }
	      else {
	        start = start == null ? 0 : toInteger(start);
	        end = end === undefined ? length : toInteger(end);
	      }
	      return baseSlice(array, start, end);
	    }
	
	    /**
	     * Uses a binary search to determine the lowest index at which `value`
	     * should be inserted into `array` in order to maintain its sort order.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The sorted array to inspect.
	     * @param {*} value The value to evaluate.
	     * @returns {number} Returns the index at which `value` should be inserted
	     *  into `array`.
	     * @example
	     *
	     * _.sortedIndex([30, 50], 40);
	     * // => 1
	     */
	    function sortedIndex(array, value) {
	      return baseSortedIndex(array, value);
	    }
	
	    /**
	     * This method is like `_.sortedIndex` except that it accepts `iteratee`
	     * which is invoked for `value` and each element of `array` to compute their
	     * sort ranking. The iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The sorted array to inspect.
	     * @param {*} value The value to evaluate.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {number} Returns the index at which `value` should be inserted
	     *  into `array`.
	     * @example
	     *
	     * var objects = [{ 'x': 4 }, { 'x': 5 }];
	     *
	     * _.sortedIndexBy(objects, { 'x': 4 }, function(o) { return o.x; });
	     * // => 0
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.sortedIndexBy(objects, { 'x': 4 }, 'x');
	     * // => 0
	     */
	    function sortedIndexBy(array, value, iteratee) {
	      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2));
	    }
	
	    /**
	     * This method is like `_.indexOf` except that it performs a binary
	     * search on a sorted `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {*} value The value to search for.
	     * @returns {number} Returns the index of the matched value, else `-1`.
	     * @example
	     *
	     * _.sortedIndexOf([4, 5, 5, 5, 6], 5);
	     * // => 1
	     */
	    function sortedIndexOf(array, value) {
	      var length = array == null ? 0 : array.length;
	      if (length) {
	        var index = baseSortedIndex(array, value);
	        if (index < length && eq(array[index], value)) {
	          return index;
	        }
	      }
	      return -1;
	    }
	
	    /**
	     * This method is like `_.sortedIndex` except that it returns the highest
	     * index at which `value` should be inserted into `array` in order to
	     * maintain its sort order.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The sorted array to inspect.
	     * @param {*} value The value to evaluate.
	     * @returns {number} Returns the index at which `value` should be inserted
	     *  into `array`.
	     * @example
	     *
	     * _.sortedLastIndex([4, 5, 5, 5, 6], 5);
	     * // => 4
	     */
	    function sortedLastIndex(array, value) {
	      return baseSortedIndex(array, value, true);
	    }
	
	    /**
	     * This method is like `_.sortedLastIndex` except that it accepts `iteratee`
	     * which is invoked for `value` and each element of `array` to compute their
	     * sort ranking. The iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The sorted array to inspect.
	     * @param {*} value The value to evaluate.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {number} Returns the index at which `value` should be inserted
	     *  into `array`.
	     * @example
	     *
	     * var objects = [{ 'x': 4 }, { 'x': 5 }];
	     *
	     * _.sortedLastIndexBy(objects, { 'x': 4 }, function(o) { return o.x; });
	     * // => 1
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.sortedLastIndexBy(objects, { 'x': 4 }, 'x');
	     * // => 1
	     */
	    function sortedLastIndexBy(array, value, iteratee) {
	      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2), true);
	    }
	
	    /**
	     * This method is like `_.lastIndexOf` except that it performs a binary
	     * search on a sorted `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {*} value The value to search for.
	     * @returns {number} Returns the index of the matched value, else `-1`.
	     * @example
	     *
	     * _.sortedLastIndexOf([4, 5, 5, 5, 6], 5);
	     * // => 3
	     */
	    function sortedLastIndexOf(array, value) {
	      var length = array == null ? 0 : array.length;
	      if (length) {
	        var index = baseSortedIndex(array, value, true) - 1;
	        if (eq(array[index], value)) {
	          return index;
	        }
	      }
	      return -1;
	    }
	
	    /**
	     * This method is like `_.uniq` except that it's designed and optimized
	     * for sorted arrays.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @returns {Array} Returns the new duplicate free array.
	     * @example
	     *
	     * _.sortedUniq([1, 1, 2]);
	     * // => [1, 2]
	     */
	    function sortedUniq(array) {
	      return (array && array.length)
	        ? baseSortedUniq(array)
	        : [];
	    }
	
	    /**
	     * This method is like `_.uniqBy` except that it's designed and optimized
	     * for sorted arrays.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {Function} [iteratee] The iteratee invoked per element.
	     * @returns {Array} Returns the new duplicate free array.
	     * @example
	     *
	     * _.sortedUniqBy([1.1, 1.2, 2.3, 2.4], Math.floor);
	     * // => [1.1, 2.3]
	     */
	    function sortedUniqBy(array, iteratee) {
	      return (array && array.length)
	        ? baseSortedUniq(array, getIteratee(iteratee, 2))
	        : [];
	    }
	
	    /**
	     * Gets all but the first element of `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * _.tail([1, 2, 3]);
	     * // => [2, 3]
	     */
	    function tail(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseSlice(array, 1, length) : [];
	    }
	
	    /**
	     * Creates a slice of `array` with `n` elements taken from the beginning.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {number} [n=1] The number of elements to take.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * _.take([1, 2, 3]);
	     * // => [1]
	     *
	     * _.take([1, 2, 3], 2);
	     * // => [1, 2]
	     *
	     * _.take([1, 2, 3], 5);
	     * // => [1, 2, 3]
	     *
	     * _.take([1, 2, 3], 0);
	     * // => []
	     */
	    function take(array, n, guard) {
	      if (!(array && array.length)) {
	        return [];
	      }
	      n = (guard || n === undefined) ? 1 : toInteger(n);
	      return baseSlice(array, 0, n < 0 ? 0 : n);
	    }
	
	    /**
	     * Creates a slice of `array` with `n` elements taken from the end.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {number} [n=1] The number of elements to take.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * _.takeRight([1, 2, 3]);
	     * // => [3]
	     *
	     * _.takeRight([1, 2, 3], 2);
	     * // => [2, 3]
	     *
	     * _.takeRight([1, 2, 3], 5);
	     * // => [1, 2, 3]
	     *
	     * _.takeRight([1, 2, 3], 0);
	     * // => []
	     */
	    function takeRight(array, n, guard) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      n = (guard || n === undefined) ? 1 : toInteger(n);
	      n = length - n;
	      return baseSlice(array, n < 0 ? 0 : n, length);
	    }
	
	    /**
	     * Creates a slice of `array` with elements taken from the end. Elements are
	     * taken until `predicate` returns falsey. The predicate is invoked with
	     * three arguments: (value, index, array).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'active': true },
	     *   { 'user': 'fred',    'active': false },
	     *   { 'user': 'pebbles', 'active': false }
	     * ];
	     *
	     * _.takeRightWhile(users, function(o) { return !o.active; });
	     * // => objects for ['fred', 'pebbles']
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.takeRightWhile(users, { 'user': 'pebbles', 'active': false });
	     * // => objects for ['pebbles']
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.takeRightWhile(users, ['active', false]);
	     * // => objects for ['fred', 'pebbles']
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.takeRightWhile(users, 'active');
	     * // => []
	     */
	    function takeRightWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3), false, true)
	        : [];
	    }
	
	    /**
	     * Creates a slice of `array` with elements taken from the beginning. Elements
	     * are taken until `predicate` returns falsey. The predicate is invoked with
	     * three arguments: (value, index, array).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Array
	     * @param {Array} array The array to query.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the slice of `array`.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'active': false },
	     *   { 'user': 'fred',    'active': false },
	     *   { 'user': 'pebbles', 'active': true }
	     * ];
	     *
	     * _.takeWhile(users, function(o) { return !o.active; });
	     * // => objects for ['barney', 'fred']
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.takeWhile(users, { 'user': 'barney', 'active': false });
	     * // => objects for ['barney']
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.takeWhile(users, ['active', false]);
	     * // => objects for ['barney', 'fred']
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.takeWhile(users, 'active');
	     * // => []
	     */
	    function takeWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3))
	        : [];
	    }
	
	    /**
	     * Creates an array of unique values, in order, from all given arrays using
	     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @returns {Array} Returns the new array of combined values.
	     * @example
	     *
	     * _.union([2], [1, 2]);
	     * // => [2, 1]
	     */
	    var union = baseRest(function(arrays) {
	      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
	    });
	
	    /**
	     * This method is like `_.union` except that it accepts `iteratee` which is
	     * invoked for each element of each `arrays` to generate the criterion by
	     * which uniqueness is computed. Result values are chosen from the first
	     * array in which the value occurs. The iteratee is invoked with one argument:
	     * (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {Array} Returns the new array of combined values.
	     * @example
	     *
	     * _.unionBy([2.1], [1.2, 2.3], Math.floor);
	     * // => [2.1, 1.2]
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.unionBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
	     * // => [{ 'x': 1 }, { 'x': 2 }]
	     */
	    var unionBy = baseRest(function(arrays) {
	      var iteratee = last(arrays);
	      if (isArrayLikeObject(iteratee)) {
	        iteratee = undefined;
	      }
	      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee, 2));
	    });
	
	    /**
	     * This method is like `_.union` except that it accepts `comparator` which
	     * is invoked to compare elements of `arrays`. Result values are chosen from
	     * the first array in which the value occurs. The comparator is invoked
	     * with two arguments: (arrVal, othVal).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new array of combined values.
	     * @example
	     *
	     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
	     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
	     *
	     * _.unionWith(objects, others, _.isEqual);
	     * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 1 }]
	     */
	    var unionWith = baseRest(function(arrays) {
	      var comparator = last(arrays);
	      comparator = typeof comparator == 'function' ? comparator : undefined;
	      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined, comparator);
	    });
	
	    /**
	     * Creates a duplicate-free version of an array, using
	     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons, in which only the first occurrence of each element
	     * is kept. The order of result values is determined by the order they occur
	     * in the array.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @returns {Array} Returns the new duplicate free array.
	     * @example
	     *
	     * _.uniq([2, 1, 2]);
	     * // => [2, 1]
	     */
	    function uniq(array) {
	      return (array && array.length) ? baseUniq(array) : [];
	    }
	
	    /**
	     * This method is like `_.uniq` except that it accepts `iteratee` which is
	     * invoked for each element in `array` to generate the criterion by which
	     * uniqueness is computed. The order of result values is determined by the
	     * order they occur in the array. The iteratee is invoked with one argument:
	     * (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {Array} Returns the new duplicate free array.
	     * @example
	     *
	     * _.uniqBy([2.1, 1.2, 2.3], Math.floor);
	     * // => [2.1, 1.2]
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.uniqBy([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
	     * // => [{ 'x': 1 }, { 'x': 2 }]
	     */
	    function uniqBy(array, iteratee) {
	      return (array && array.length) ? baseUniq(array, getIteratee(iteratee, 2)) : [];
	    }
	
	    /**
	     * This method is like `_.uniq` except that it accepts `comparator` which
	     * is invoked to compare elements of `array`. The order of result values is
	     * determined by the order they occur in the array.The comparator is invoked
	     * with two arguments: (arrVal, othVal).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new duplicate free array.
	     * @example
	     *
	     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 2 }];
	     *
	     * _.uniqWith(objects, _.isEqual);
	     * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]
	     */
	    function uniqWith(array, comparator) {
	      comparator = typeof comparator == 'function' ? comparator : undefined;
	      return (array && array.length) ? baseUniq(array, undefined, comparator) : [];
	    }
	
	    /**
	     * This method is like `_.zip` except that it accepts an array of grouped
	     * elements and creates an array regrouping the elements to their pre-zip
	     * configuration.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.2.0
	     * @category Array
	     * @param {Array} array The array of grouped elements to process.
	     * @returns {Array} Returns the new array of regrouped elements.
	     * @example
	     *
	     * var zipped = _.zip(['a', 'b'], [1, 2], [true, false]);
	     * // => [['a', 1, true], ['b', 2, false]]
	     *
	     * _.unzip(zipped);
	     * // => [['a', 'b'], [1, 2], [true, false]]
	     */
	    function unzip(array) {
	      if (!(array && array.length)) {
	        return [];
	      }
	      var length = 0;
	      array = arrayFilter(array, function(group) {
	        if (isArrayLikeObject(group)) {
	          length = nativeMax(group.length, length);
	          return true;
	        }
	      });
	      return baseTimes(length, function(index) {
	        return arrayMap(array, baseProperty(index));
	      });
	    }
	
	    /**
	     * This method is like `_.unzip` except that it accepts `iteratee` to specify
	     * how regrouped values should be combined. The iteratee is invoked with the
	     * elements of each group: (...group).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.8.0
	     * @category Array
	     * @param {Array} array The array of grouped elements to process.
	     * @param {Function} [iteratee=_.identity] The function to combine
	     *  regrouped values.
	     * @returns {Array} Returns the new array of regrouped elements.
	     * @example
	     *
	     * var zipped = _.zip([1, 2], [10, 20], [100, 200]);
	     * // => [[1, 10, 100], [2, 20, 200]]
	     *
	     * _.unzipWith(zipped, _.add);
	     * // => [3, 30, 300]
	     */
	    function unzipWith(array, iteratee) {
	      if (!(array && array.length)) {
	        return [];
	      }
	      var result = unzip(array);
	      if (iteratee == null) {
	        return result;
	      }
	      return arrayMap(result, function(group) {
	        return apply(iteratee, undefined, group);
	      });
	    }
	
	    /**
	     * Creates an array excluding all given values using
	     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * for equality comparisons.
	     *
	     * **Note:** Unlike `_.pull`, this method returns a new array.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {Array} array The array to inspect.
	     * @param {...*} [values] The values to exclude.
	     * @returns {Array} Returns the new array of filtered values.
	     * @see _.difference, _.xor
	     * @example
	     *
	     * _.without([2, 1, 2, 3], 1, 2);
	     * // => [3]
	     */
	    var without = baseRest(function(array, values) {
	      return isArrayLikeObject(array)
	        ? baseDifference(array, values)
	        : [];
	    });
	
	    /**
	     * Creates an array of unique values that is the
	     * [symmetric difference](https://en.wikipedia.org/wiki/Symmetric_difference)
	     * of the given arrays. The order of result values is determined by the order
	     * they occur in the arrays.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.4.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @returns {Array} Returns the new array of filtered values.
	     * @see _.difference, _.without
	     * @example
	     *
	     * _.xor([2, 1], [2, 3]);
	     * // => [1, 3]
	     */
	    var xor = baseRest(function(arrays) {
	      return baseXor(arrayFilter(arrays, isArrayLikeObject));
	    });
	
	    /**
	     * This method is like `_.xor` except that it accepts `iteratee` which is
	     * invoked for each element of each `arrays` to generate the criterion by
	     * which by which they're compared. The order of result values is determined
	     * by the order they occur in the arrays. The iteratee is invoked with one
	     * argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {Array} Returns the new array of filtered values.
	     * @example
	     *
	     * _.xorBy([2.1, 1.2], [2.3, 3.4], Math.floor);
	     * // => [1.2, 3.4]
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.xorBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
	     * // => [{ 'x': 2 }]
	     */
	    var xorBy = baseRest(function(arrays) {
	      var iteratee = last(arrays);
	      if (isArrayLikeObject(iteratee)) {
	        iteratee = undefined;
	      }
	      return baseXor(arrayFilter(arrays, isArrayLikeObject), getIteratee(iteratee, 2));
	    });
	
	    /**
	     * This method is like `_.xor` except that it accepts `comparator` which is
	     * invoked to compare elements of `arrays`. The order of result values is
	     * determined by the order they occur in the arrays. The comparator is invoked
	     * with two arguments: (arrVal, othVal).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to inspect.
	     * @param {Function} [comparator] The comparator invoked per element.
	     * @returns {Array} Returns the new array of filtered values.
	     * @example
	     *
	     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
	     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
	     *
	     * _.xorWith(objects, others, _.isEqual);
	     * // => [{ 'x': 2, 'y': 1 }, { 'x': 1, 'y': 1 }]
	     */
	    var xorWith = baseRest(function(arrays) {
	      var comparator = last(arrays);
	      comparator = typeof comparator == 'function' ? comparator : undefined;
	      return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined, comparator);
	    });
	
	    /**
	     * Creates an array of grouped elements, the first of which contains the
	     * first elements of the given arrays, the second of which contains the
	     * second elements of the given arrays, and so on.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to process.
	     * @returns {Array} Returns the new array of grouped elements.
	     * @example
	     *
	     * _.zip(['a', 'b'], [1, 2], [true, false]);
	     * // => [['a', 1, true], ['b', 2, false]]
	     */
	    var zip = baseRest(unzip);
	
	    /**
	     * This method is like `_.fromPairs` except that it accepts two arrays,
	     * one of property identifiers and one of corresponding values.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.4.0
	     * @category Array
	     * @param {Array} [props=[]] The property identifiers.
	     * @param {Array} [values=[]] The property values.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * _.zipObject(['a', 'b'], [1, 2]);
	     * // => { 'a': 1, 'b': 2 }
	     */
	    function zipObject(props, values) {
	      return baseZipObject(props || [], values || [], assignValue);
	    }
	
	    /**
	     * This method is like `_.zipObject` except that it supports property paths.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.1.0
	     * @category Array
	     * @param {Array} [props=[]] The property identifiers.
	     * @param {Array} [values=[]] The property values.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * _.zipObjectDeep(['a.b[0].c', 'a.b[1].d'], [1, 2]);
	     * // => { 'a': { 'b': [{ 'c': 1 }, { 'd': 2 }] } }
	     */
	    function zipObjectDeep(props, values) {
	      return baseZipObject(props || [], values || [], baseSet);
	    }
	
	    /**
	     * This method is like `_.zip` except that it accepts `iteratee` to specify
	     * how grouped values should be combined. The iteratee is invoked with the
	     * elements of each group: (...group).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.8.0
	     * @category Array
	     * @param {...Array} [arrays] The arrays to process.
	     * @param {Function} [iteratee=_.identity] The function to combine
	     *  grouped values.
	     * @returns {Array} Returns the new array of grouped elements.
	     * @example
	     *
	     * _.zipWith([1, 2], [10, 20], [100, 200], function(a, b, c) {
	     *   return a + b + c;
	     * });
	     * // => [111, 222]
	     */
	    var zipWith = baseRest(function(arrays) {
	      var length = arrays.length,
	          iteratee = length > 1 ? arrays[length - 1] : undefined;
	
	      iteratee = typeof iteratee == 'function' ? (arrays.pop(), iteratee) : undefined;
	      return unzipWith(arrays, iteratee);
	    });
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates a `lodash` wrapper instance that wraps `value` with explicit method
	     * chain sequences enabled. The result of such sequences must be unwrapped
	     * with `_#value`.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.3.0
	     * @category Seq
	     * @param {*} value The value to wrap.
	     * @returns {Object} Returns the new `lodash` wrapper instance.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'age': 36 },
	     *   { 'user': 'fred',    'age': 40 },
	     *   { 'user': 'pebbles', 'age': 1 }
	     * ];
	     *
	     * var youngest = _
	     *   .chain(users)
	     *   .sortBy('age')
	     *   .map(function(o) {
	     *     return o.user + ' is ' + o.age;
	     *   })
	     *   .head()
	     *   .value();
	     * // => 'pebbles is 1'
	     */
	    function chain(value) {
	      var result = lodash(value);
	      result.__chain__ = true;
	      return result;
	    }
	
	    /**
	     * This method invokes `interceptor` and returns `value`. The interceptor
	     * is invoked with one argument; (value). The purpose of this method is to
	     * "tap into" a method chain sequence in order to modify intermediate results.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Seq
	     * @param {*} value The value to provide to `interceptor`.
	     * @param {Function} interceptor The function to invoke.
	     * @returns {*} Returns `value`.
	     * @example
	     *
	     * _([1, 2, 3])
	     *  .tap(function(array) {
	     *    // Mutate input array.
	     *    array.pop();
	     *  })
	     *  .reverse()
	     *  .value();
	     * // => [2, 1]
	     */
	    function tap(value, interceptor) {
	      interceptor(value);
	      return value;
	    }
	
	    /**
	     * This method is like `_.tap` except that it returns the result of `interceptor`.
	     * The purpose of this method is to "pass thru" values replacing intermediate
	     * results in a method chain sequence.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Seq
	     * @param {*} value The value to provide to `interceptor`.
	     * @param {Function} interceptor The function to invoke.
	     * @returns {*} Returns the result of `interceptor`.
	     * @example
	     *
	     * _('  abc  ')
	     *  .chain()
	     *  .trim()
	     *  .thru(function(value) {
	     *    return [value];
	     *  })
	     *  .value();
	     * // => ['abc']
	     */
	    function thru(value, interceptor) {
	      return interceptor(value);
	    }
	
	    /**
	     * This method is the wrapper version of `_.at`.
	     *
	     * @name at
	     * @memberOf _
	     * @since 1.0.0
	     * @category Seq
	     * @param {...(string|string[])} [paths] The property paths to pick.
	     * @returns {Object} Returns the new `lodash` wrapper instance.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c': 3 } }, 4] };
	     *
	     * _(object).at(['a[0].b.c', 'a[1]']).value();
	     * // => [3, 4]
	     */
	    var wrapperAt = flatRest(function(paths) {
	      var length = paths.length,
	          start = length ? paths[0] : 0,
	          value = this.__wrapped__,
	          interceptor = function(object) { return baseAt(object, paths); };
	
	      if (length > 1 || this.__actions__.length ||
	          !(value instanceof LazyWrapper) || !isIndex(start)) {
	        return this.thru(interceptor);
	      }
	      value = value.slice(start, +start + (length ? 1 : 0));
	      value.__actions__.push({
	        'func': thru,
	        'args': [interceptor],
	        'thisArg': undefined
	      });
	      return new LodashWrapper(value, this.__chain__).thru(function(array) {
	        if (length && !array.length) {
	          array.push(undefined);
	        }
	        return array;
	      });
	    });
	
	    /**
	     * Creates a `lodash` wrapper instance with explicit method chain sequences enabled.
	     *
	     * @name chain
	     * @memberOf _
	     * @since 0.1.0
	     * @category Seq
	     * @returns {Object} Returns the new `lodash` wrapper instance.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney', 'age': 36 },
	     *   { 'user': 'fred',   'age': 40 }
	     * ];
	     *
	     * // A sequence without explicit chaining.
	     * _(users).head();
	     * // => { 'user': 'barney', 'age': 36 }
	     *
	     * // A sequence with explicit chaining.
	     * _(users)
	     *   .chain()
	     *   .head()
	     *   .pick('user')
	     *   .value();
	     * // => { 'user': 'barney' }
	     */
	    function wrapperChain() {
	      return chain(this);
	    }
	
	    /**
	     * Executes the chain sequence and returns the wrapped result.
	     *
	     * @name commit
	     * @memberOf _
	     * @since 3.2.0
	     * @category Seq
	     * @returns {Object} Returns the new `lodash` wrapper instance.
	     * @example
	     *
	     * var array = [1, 2];
	     * var wrapped = _(array).push(3);
	     *
	     * console.log(array);
	     * // => [1, 2]
	     *
	     * wrapped = wrapped.commit();
	     * console.log(array);
	     * // => [1, 2, 3]
	     *
	     * wrapped.last();
	     * // => 3
	     *
	     * console.log(array);
	     * // => [1, 2, 3]
	     */
	    function wrapperCommit() {
	      return new LodashWrapper(this.value(), this.__chain__);
	    }
	
	    /**
	     * Gets the next value on a wrapped object following the
	     * [iterator protocol](https://mdn.io/iteration_protocols#iterator).
	     *
	     * @name next
	     * @memberOf _
	     * @since 4.0.0
	     * @category Seq
	     * @returns {Object} Returns the next iterator value.
	     * @example
	     *
	     * var wrapped = _([1, 2]);
	     *
	     * wrapped.next();
	     * // => { 'done': false, 'value': 1 }
	     *
	     * wrapped.next();
	     * // => { 'done': false, 'value': 2 }
	     *
	     * wrapped.next();
	     * // => { 'done': true, 'value': undefined }
	     */
	    function wrapperNext() {
	      if (this.__values__ === undefined) {
	        this.__values__ = toArray(this.value());
	      }
	      var done = this.__index__ >= this.__values__.length,
	          value = done ? undefined : this.__values__[this.__index__++];
	
	      return { 'done': done, 'value': value };
	    }
	
	    /**
	     * Enables the wrapper to be iterable.
	     *
	     * @name Symbol.iterator
	     * @memberOf _
	     * @since 4.0.0
	     * @category Seq
	     * @returns {Object} Returns the wrapper object.
	     * @example
	     *
	     * var wrapped = _([1, 2]);
	     *
	     * wrapped[Symbol.iterator]() === wrapped;
	     * // => true
	     *
	     * Array.from(wrapped);
	     * // => [1, 2]
	     */
	    function wrapperToIterator() {
	      return this;
	    }
	
	    /**
	     * Creates a clone of the chain sequence planting `value` as the wrapped value.
	     *
	     * @name plant
	     * @memberOf _
	     * @since 3.2.0
	     * @category Seq
	     * @param {*} value The value to plant.
	     * @returns {Object} Returns the new `lodash` wrapper instance.
	     * @example
	     *
	     * function square(n) {
	     *   return n * n;
	     * }
	     *
	     * var wrapped = _([1, 2]).map(square);
	     * var other = wrapped.plant([3, 4]);
	     *
	     * other.value();
	     * // => [9, 16]
	     *
	     * wrapped.value();
	     * // => [1, 4]
	     */
	    function wrapperPlant(value) {
	      var result,
	          parent = this;
	
	      while (parent instanceof baseLodash) {
	        var clone = wrapperClone(parent);
	        clone.__index__ = 0;
	        clone.__values__ = undefined;
	        if (result) {
	          previous.__wrapped__ = clone;
	        } else {
	          result = clone;
	        }
	        var previous = clone;
	        parent = parent.__wrapped__;
	      }
	      previous.__wrapped__ = value;
	      return result;
	    }
	
	    /**
	     * This method is the wrapper version of `_.reverse`.
	     *
	     * **Note:** This method mutates the wrapped array.
	     *
	     * @name reverse
	     * @memberOf _
	     * @since 0.1.0
	     * @category Seq
	     * @returns {Object} Returns the new `lodash` wrapper instance.
	     * @example
	     *
	     * var array = [1, 2, 3];
	     *
	     * _(array).reverse().value()
	     * // => [3, 2, 1]
	     *
	     * console.log(array);
	     * // => [3, 2, 1]
	     */
	    function wrapperReverse() {
	      var value = this.__wrapped__;
	      if (value instanceof LazyWrapper) {
	        var wrapped = value;
	        if (this.__actions__.length) {
	          wrapped = new LazyWrapper(this);
	        }
	        wrapped = wrapped.reverse();
	        wrapped.__actions__.push({
	          'func': thru,
	          'args': [reverse],
	          'thisArg': undefined
	        });
	        return new LodashWrapper(wrapped, this.__chain__);
	      }
	      return this.thru(reverse);
	    }
	
	    /**
	     * Executes the chain sequence to resolve the unwrapped value.
	     *
	     * @name value
	     * @memberOf _
	     * @since 0.1.0
	     * @alias toJSON, valueOf
	     * @category Seq
	     * @returns {*} Returns the resolved unwrapped value.
	     * @example
	     *
	     * _([1, 2, 3]).value();
	     * // => [1, 2, 3]
	     */
	    function wrapperValue() {
	      return baseWrapperValue(this.__wrapped__, this.__actions__);
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Creates an object composed of keys generated from the results of running
	     * each element of `collection` thru `iteratee`. The corresponding value of
	     * each key is the number of times the key was returned by `iteratee`. The
	     * iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.5.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
	     * @returns {Object} Returns the composed aggregate object.
	     * @example
	     *
	     * _.countBy([6.1, 4.2, 6.3], Math.floor);
	     * // => { '4': 1, '6': 2 }
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.countBy(['one', 'two', 'three'], 'length');
	     * // => { '3': 2, '5': 1 }
	     */
	    var countBy = createAggregator(function(result, value, key) {
	      if (hasOwnProperty.call(result, key)) {
	        ++result[key];
	      } else {
	        baseAssignValue(result, key, 1);
	      }
	    });
	
	    /**
	     * Checks if `predicate` returns truthy for **all** elements of `collection`.
	     * Iteration is stopped once `predicate` returns falsey. The predicate is
	     * invoked with three arguments: (value, index|key, collection).
	     *
	     * **Note:** This method returns `true` for
	     * [empty collections](https://en.wikipedia.org/wiki/Empty_set) because
	     * [everything is true](https://en.wikipedia.org/wiki/Vacuous_truth) of
	     * elements of empty collections.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {boolean} Returns `true` if all elements pass the predicate check,
	     *  else `false`.
	     * @example
	     *
	     * _.every([true, 1, null, 'yes'], Boolean);
	     * // => false
	     *
	     * var users = [
	     *   { 'user': 'barney', 'age': 36, 'active': false },
	     *   { 'user': 'fred',   'age': 40, 'active': false }
	     * ];
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.every(users, { 'user': 'barney', 'active': false });
	     * // => false
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.every(users, ['active', false]);
	     * // => true
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.every(users, 'active');
	     * // => false
	     */
	    function every(collection, predicate, guard) {
	      var func = isArray(collection) ? arrayEvery : baseEvery;
	      if (guard && isIterateeCall(collection, predicate, guard)) {
	        predicate = undefined;
	      }
	      return func(collection, getIteratee(predicate, 3));
	    }
	
	    /**
	     * Iterates over elements of `collection`, returning an array of all elements
	     * `predicate` returns truthy for. The predicate is invoked with three
	     * arguments: (value, index|key, collection).
	     *
	     * **Note:** Unlike `_.remove`, this method returns a new array.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the new filtered array.
	     * @see _.reject
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney', 'age': 36, 'active': true },
	     *   { 'user': 'fred',   'age': 40, 'active': false }
	     * ];
	     *
	     * _.filter(users, function(o) { return !o.active; });
	     * // => objects for ['fred']
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.filter(users, { 'age': 36, 'active': true });
	     * // => objects for ['barney']
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.filter(users, ['active', false]);
	     * // => objects for ['fred']
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.filter(users, 'active');
	     * // => objects for ['barney']
	     */
	    function filter(collection, predicate) {
	      var func = isArray(collection) ? arrayFilter : baseFilter;
	      return func(collection, getIteratee(predicate, 3));
	    }
	
	    /**
	     * Iterates over elements of `collection`, returning the first element
	     * `predicate` returns truthy for. The predicate is invoked with three
	     * arguments: (value, index|key, collection).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to inspect.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @param {number} [fromIndex=0] The index to search from.
	     * @returns {*} Returns the matched element, else `undefined`.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'age': 36, 'active': true },
	     *   { 'user': 'fred',    'age': 40, 'active': false },
	     *   { 'user': 'pebbles', 'age': 1,  'active': true }
	     * ];
	     *
	     * _.find(users, function(o) { return o.age < 40; });
	     * // => object for 'barney'
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.find(users, { 'age': 1, 'active': true });
	     * // => object for 'pebbles'
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.find(users, ['active', false]);
	     * // => object for 'fred'
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.find(users, 'active');
	     * // => object for 'barney'
	     */
	    var find = createFind(findIndex);
	
	    /**
	     * This method is like `_.find` except that it iterates over elements of
	     * `collection` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to inspect.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @param {number} [fromIndex=collection.length-1] The index to search from.
	     * @returns {*} Returns the matched element, else `undefined`.
	     * @example
	     *
	     * _.findLast([1, 2, 3, 4], function(n) {
	     *   return n % 2 == 1;
	     * });
	     * // => 3
	     */
	    var findLast = createFind(findLastIndex);
	
	    /**
	     * Creates a flattened array of values by running each element in `collection`
	     * thru `iteratee` and flattening the mapped results. The iteratee is invoked
	     * with three arguments: (value, index|key, collection).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the new flattened array.
	     * @example
	     *
	     * function duplicate(n) {
	     *   return [n, n];
	     * }
	     *
	     * _.flatMap([1, 2], duplicate);
	     * // => [1, 1, 2, 2]
	     */
	    function flatMap(collection, iteratee) {
	      return baseFlatten(map(collection, iteratee), 1);
	    }
	
	    /**
	     * This method is like `_.flatMap` except that it recursively flattens the
	     * mapped results.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.7.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the new flattened array.
	     * @example
	     *
	     * function duplicate(n) {
	     *   return [[[n, n]]];
	     * }
	     *
	     * _.flatMapDeep([1, 2], duplicate);
	     * // => [1, 1, 2, 2]
	     */
	    function flatMapDeep(collection, iteratee) {
	      return baseFlatten(map(collection, iteratee), INFINITY);
	    }
	
	    /**
	     * This method is like `_.flatMap` except that it recursively flattens the
	     * mapped results up to `depth` times.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.7.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @param {number} [depth=1] The maximum recursion depth.
	     * @returns {Array} Returns the new flattened array.
	     * @example
	     *
	     * function duplicate(n) {
	     *   return [[[n, n]]];
	     * }
	     *
	     * _.flatMapDepth([1, 2], duplicate, 2);
	     * // => [[1, 1], [2, 2]]
	     */
	    function flatMapDepth(collection, iteratee, depth) {
	      depth = depth === undefined ? 1 : toInteger(depth);
	      return baseFlatten(map(collection, iteratee), depth);
	    }
	
	    /**
	     * Iterates over elements of `collection` and invokes `iteratee` for each element.
	     * The iteratee is invoked with three arguments: (value, index|key, collection).
	     * Iteratee functions may exit iteration early by explicitly returning `false`.
	     *
	     * **Note:** As with other "Collections" methods, objects with a "length"
	     * property are iterated like arrays. To avoid this behavior use `_.forIn`
	     * or `_.forOwn` for object iteration.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @alias each
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Array|Object} Returns `collection`.
	     * @see _.forEachRight
	     * @example
	     *
	     * _.forEach([1, 2], function(value) {
	     *   console.log(value);
	     * });
	     * // => Logs `1` then `2`.
	     *
	     * _.forEach({ 'a': 1, 'b': 2 }, function(value, key) {
	     *   console.log(key);
	     * });
	     * // => Logs 'a' then 'b' (iteration order is not guaranteed).
	     */
	    function forEach(collection, iteratee) {
	      var func = isArray(collection) ? arrayEach : baseEach;
	      return func(collection, getIteratee(iteratee, 3));
	    }
	
	    /**
	     * This method is like `_.forEach` except that it iterates over elements of
	     * `collection` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @alias eachRight
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Array|Object} Returns `collection`.
	     * @see _.forEach
	     * @example
	     *
	     * _.forEachRight([1, 2], function(value) {
	     *   console.log(value);
	     * });
	     * // => Logs `2` then `1`.
	     */
	    function forEachRight(collection, iteratee) {
	      var func = isArray(collection) ? arrayEachRight : baseEachRight;
	      return func(collection, getIteratee(iteratee, 3));
	    }
	
	    /**
	     * Creates an object composed of keys generated from the results of running
	     * each element of `collection` thru `iteratee`. The order of grouped values
	     * is determined by the order they occur in `collection`. The corresponding
	     * value of each key is an array of elements responsible for generating the
	     * key. The iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
	     * @returns {Object} Returns the composed aggregate object.
	     * @example
	     *
	     * _.groupBy([6.1, 4.2, 6.3], Math.floor);
	     * // => { '4': [4.2], '6': [6.1, 6.3] }
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.groupBy(['one', 'two', 'three'], 'length');
	     * // => { '3': ['one', 'two'], '5': ['three'] }
	     */
	    var groupBy = createAggregator(function(result, value, key) {
	      if (hasOwnProperty.call(result, key)) {
	        result[key].push(value);
	      } else {
	        baseAssignValue(result, key, [value]);
	      }
	    });
	
	    /**
	     * Checks if `value` is in `collection`. If `collection` is a string, it's
	     * checked for a substring of `value`, otherwise
	     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * is used for equality comparisons. If `fromIndex` is negative, it's used as
	     * the offset from the end of `collection`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object|string} collection The collection to inspect.
	     * @param {*} value The value to search for.
	     * @param {number} [fromIndex=0] The index to search from.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
	     * @returns {boolean} Returns `true` if `value` is found, else `false`.
	     * @example
	     *
	     * _.includes([1, 2, 3], 1);
	     * // => true
	     *
	     * _.includes([1, 2, 3], 1, 2);
	     * // => false
	     *
	     * _.includes({ 'a': 1, 'b': 2 }, 1);
	     * // => true
	     *
	     * _.includes('abcd', 'bc');
	     * // => true
	     */
	    function includes(collection, value, fromIndex, guard) {
	      collection = isArrayLike(collection) ? collection : values(collection);
	      fromIndex = (fromIndex && !guard) ? toInteger(fromIndex) : 0;
	
	      var length = collection.length;
	      if (fromIndex < 0) {
	        fromIndex = nativeMax(length + fromIndex, 0);
	      }
	      return isString(collection)
	        ? (fromIndex <= length && collection.indexOf(value, fromIndex) > -1)
	        : (!!length && baseIndexOf(collection, value, fromIndex) > -1);
	    }
	
	    /**
	     * Invokes the method at `path` of each element in `collection`, returning
	     * an array of the results of each invoked method. Any additional arguments
	     * are provided to each invoked method. If `path` is a function, it's invoked
	     * for, and `this` bound to, each element in `collection`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Array|Function|string} path The path of the method to invoke or
	     *  the function invoked per iteration.
	     * @param {...*} [args] The arguments to invoke each method with.
	     * @returns {Array} Returns the array of results.
	     * @example
	     *
	     * _.invokeMap([[5, 1, 7], [3, 2, 1]], 'sort');
	     * // => [[1, 5, 7], [1, 2, 3]]
	     *
	     * _.invokeMap([123, 456], String.prototype.split, '');
	     * // => [['1', '2', '3'], ['4', '5', '6']]
	     */
	    var invokeMap = baseRest(function(collection, path, args) {
	      var index = -1,
	          isFunc = typeof path == 'function',
	          result = isArrayLike(collection) ? Array(collection.length) : [];
	
	      baseEach(collection, function(value) {
	        result[++index] = isFunc ? apply(path, value, args) : baseInvoke(value, path, args);
	      });
	      return result;
	    });
	
	    /**
	     * Creates an object composed of keys generated from the results of running
	     * each element of `collection` thru `iteratee`. The corresponding value of
	     * each key is the last element responsible for generating the key. The
	     * iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
	     * @returns {Object} Returns the composed aggregate object.
	     * @example
	     *
	     * var array = [
	     *   { 'dir': 'left', 'code': 97 },
	     *   { 'dir': 'right', 'code': 100 }
	     * ];
	     *
	     * _.keyBy(array, function(o) {
	     *   return String.fromCharCode(o.code);
	     * });
	     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
	     *
	     * _.keyBy(array, 'dir');
	     * // => { 'left': { 'dir': 'left', 'code': 97 }, 'right': { 'dir': 'right', 'code': 100 } }
	     */
	    var keyBy = createAggregator(function(result, value, key) {
	      baseAssignValue(result, key, value);
	    });
	
	    /**
	     * Creates an array of values by running each element in `collection` thru
	     * `iteratee`. The iteratee is invoked with three arguments:
	     * (value, index|key, collection).
	     *
	     * Many lodash methods are guarded to work as iteratees for methods like
	     * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
	     *
	     * The guarded methods are:
	     * `ary`, `chunk`, `curry`, `curryRight`, `drop`, `dropRight`, `every`,
	     * `fill`, `invert`, `parseInt`, `random`, `range`, `rangeRight`, `repeat`,
	     * `sampleSize`, `slice`, `some`, `sortBy`, `split`, `take`, `takeRight`,
	     * `template`, `trim`, `trimEnd`, `trimStart`, and `words`
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the new mapped array.
	     * @example
	     *
	     * function square(n) {
	     *   return n * n;
	     * }
	     *
	     * _.map([4, 8], square);
	     * // => [16, 64]
	     *
	     * _.map({ 'a': 4, 'b': 8 }, square);
	     * // => [16, 64] (iteration order is not guaranteed)
	     *
	     * var users = [
	     *   { 'user': 'barney' },
	     *   { 'user': 'fred' }
	     * ];
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.map(users, 'user');
	     * // => ['barney', 'fred']
	     */
	    function map(collection, iteratee) {
	      var func = isArray(collection) ? arrayMap : baseMap;
	      return func(collection, getIteratee(iteratee, 3));
	    }
	
	    /**
	     * This method is like `_.sortBy` except that it allows specifying the sort
	     * orders of the iteratees to sort by. If `orders` is unspecified, all values
	     * are sorted in ascending order. Otherwise, specify an order of "desc" for
	     * descending or "asc" for ascending sort order of corresponding values.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Array[]|Function[]|Object[]|string[]} [iteratees=[_.identity]]
	     *  The iteratees to sort by.
	     * @param {string[]} [orders] The sort orders of `iteratees`.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
	     * @returns {Array} Returns the new sorted array.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'fred',   'age': 48 },
	     *   { 'user': 'barney', 'age': 34 },
	     *   { 'user': 'fred',   'age': 40 },
	     *   { 'user': 'barney', 'age': 36 }
	     * ];
	     *
	     * // Sort by `user` in ascending order and by `age` in descending order.
	     * _.orderBy(users, ['user', 'age'], ['asc', 'desc']);
	     * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
	     */
	    function orderBy(collection, iteratees, orders, guard) {
	      if (collection == null) {
	        return [];
	      }
	      if (!isArray(iteratees)) {
	        iteratees = iteratees == null ? [] : [iteratees];
	      }
	      orders = guard ? undefined : orders;
	      if (!isArray(orders)) {
	        orders = orders == null ? [] : [orders];
	      }
	      return baseOrderBy(collection, iteratees, orders);
	    }
	
	    /**
	     * Creates an array of elements split into two groups, the first of which
	     * contains elements `predicate` returns truthy for, the second of which
	     * contains elements `predicate` returns falsey for. The predicate is
	     * invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the array of grouped elements.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney',  'age': 36, 'active': false },
	     *   { 'user': 'fred',    'age': 40, 'active': true },
	     *   { 'user': 'pebbles', 'age': 1,  'active': false }
	     * ];
	     *
	     * _.partition(users, function(o) { return o.active; });
	     * // => objects for [['fred'], ['barney', 'pebbles']]
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.partition(users, { 'age': 1, 'active': false });
	     * // => objects for [['pebbles'], ['barney', 'fred']]
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.partition(users, ['active', false]);
	     * // => objects for [['barney', 'pebbles'], ['fred']]
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.partition(users, 'active');
	     * // => objects for [['fred'], ['barney', 'pebbles']]
	     */
	    var partition = createAggregator(function(result, value, key) {
	      result[key ? 0 : 1].push(value);
	    }, function() { return [[], []]; });
	
	    /**
	     * Reduces `collection` to a value which is the accumulated result of running
	     * each element in `collection` thru `iteratee`, where each successive
	     * invocation is supplied the return value of the previous. If `accumulator`
	     * is not given, the first element of `collection` is used as the initial
	     * value. The iteratee is invoked with four arguments:
	     * (accumulator, value, index|key, collection).
	     *
	     * Many lodash methods are guarded to work as iteratees for methods like
	     * `_.reduce`, `_.reduceRight`, and `_.transform`.
	     *
	     * The guarded methods are:
	     * `assign`, `defaults`, `defaultsDeep`, `includes`, `merge`, `orderBy`,
	     * and `sortBy`
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @param {*} [accumulator] The initial value.
	     * @returns {*} Returns the accumulated value.
	     * @see _.reduceRight
	     * @example
	     *
	     * _.reduce([1, 2], function(sum, n) {
	     *   return sum + n;
	     * }, 0);
	     * // => 3
	     *
	     * _.reduce({ 'a': 1, 'b': 2, 'c': 1 }, function(result, value, key) {
	     *   (result[value] || (result[value] = [])).push(key);
	     *   return result;
	     * }, {});
	     * // => { '1': ['a', 'c'], '2': ['b'] } (iteration order is not guaranteed)
	     */
	    function reduce(collection, iteratee, accumulator) {
	      var func = isArray(collection) ? arrayReduce : baseReduce,
	          initAccum = arguments.length < 3;
	
	      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEach);
	    }
	
	    /**
	     * This method is like `_.reduce` except that it iterates over elements of
	     * `collection` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @param {*} [accumulator] The initial value.
	     * @returns {*} Returns the accumulated value.
	     * @see _.reduce
	     * @example
	     *
	     * var array = [[0, 1], [2, 3], [4, 5]];
	     *
	     * _.reduceRight(array, function(flattened, other) {
	     *   return flattened.concat(other);
	     * }, []);
	     * // => [4, 5, 2, 3, 0, 1]
	     */
	    function reduceRight(collection, iteratee, accumulator) {
	      var func = isArray(collection) ? arrayReduceRight : baseReduce,
	          initAccum = arguments.length < 3;
	
	      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEachRight);
	    }
	
	    /**
	     * The opposite of `_.filter`; this method returns the elements of `collection`
	     * that `predicate` does **not** return truthy for.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the new filtered array.
	     * @see _.filter
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney', 'age': 36, 'active': false },
	     *   { 'user': 'fred',   'age': 40, 'active': true }
	     * ];
	     *
	     * _.reject(users, function(o) { return !o.active; });
	     * // => objects for ['fred']
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.reject(users, { 'age': 40, 'active': true });
	     * // => objects for ['barney']
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.reject(users, ['active', false]);
	     * // => objects for ['fred']
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.reject(users, 'active');
	     * // => objects for ['barney']
	     */
	    function reject(collection, predicate) {
	      var func = isArray(collection) ? arrayFilter : baseFilter;
	      return func(collection, negate(getIteratee(predicate, 3)));
	    }
	
	    /**
	     * Gets a random element from `collection`.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to sample.
	     * @returns {*} Returns the random element.
	     * @example
	     *
	     * _.sample([1, 2, 3, 4]);
	     * // => 2
	     */
	    function sample(collection) {
	      var func = isArray(collection) ? arraySample : baseSample;
	      return func(collection);
	    }
	
	    /**
	     * Gets `n` random elements at unique keys from `collection` up to the
	     * size of `collection`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to sample.
	     * @param {number} [n=1] The number of elements to sample.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Array} Returns the random elements.
	     * @example
	     *
	     * _.sampleSize([1, 2, 3], 2);
	     * // => [3, 1]
	     *
	     * _.sampleSize([1, 2, 3], 4);
	     * // => [2, 3, 1]
	     */
	    function sampleSize(collection, n, guard) {
	      if ((guard ? isIterateeCall(collection, n, guard) : n === undefined)) {
	        n = 1;
	      } else {
	        n = toInteger(n);
	      }
	      var func = isArray(collection) ? arraySampleSize : baseSampleSize;
	      return func(collection, n);
	    }
	
	    /**
	     * Creates an array of shuffled values, using a version of the
	     * [Fisher-Yates shuffle](https://en.wikipedia.org/wiki/Fisher-Yates_shuffle).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to shuffle.
	     * @returns {Array} Returns the new shuffled array.
	     * @example
	     *
	     * _.shuffle([1, 2, 3, 4]);
	     * // => [4, 1, 3, 2]
	     */
	    function shuffle(collection) {
	      var func = isArray(collection) ? arrayShuffle : baseShuffle;
	      return func(collection);
	    }
	
	    /**
	     * Gets the size of `collection` by returning its length for array-like
	     * values or the number of own enumerable string keyed properties for objects.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object|string} collection The collection to inspect.
	     * @returns {number} Returns the collection size.
	     * @example
	     *
	     * _.size([1, 2, 3]);
	     * // => 3
	     *
	     * _.size({ 'a': 1, 'b': 2 });
	     * // => 2
	     *
	     * _.size('pebbles');
	     * // => 7
	     */
	    function size(collection) {
	      if (collection == null) {
	        return 0;
	      }
	      if (isArrayLike(collection)) {
	        return isString(collection) ? stringSize(collection) : collection.length;
	      }
	      var tag = getTag(collection);
	      if (tag == mapTag || tag == setTag) {
	        return collection.size;
	      }
	      return baseKeys(collection).length;
	    }
	
	    /**
	     * Checks if `predicate` returns truthy for **any** element of `collection`.
	     * Iteration is stopped once `predicate` returns truthy. The predicate is
	     * invoked with three arguments: (value, index|key, collection).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {boolean} Returns `true` if any element passes the predicate check,
	     *  else `false`.
	     * @example
	     *
	     * _.some([null, 0, 'yes', false], Boolean);
	     * // => true
	     *
	     * var users = [
	     *   { 'user': 'barney', 'active': true },
	     *   { 'user': 'fred',   'active': false }
	     * ];
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.some(users, { 'user': 'barney', 'active': false });
	     * // => false
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.some(users, ['active', false]);
	     * // => true
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.some(users, 'active');
	     * // => true
	     */
	    function some(collection, predicate, guard) {
	      var func = isArray(collection) ? arraySome : baseSome;
	      if (guard && isIterateeCall(collection, predicate, guard)) {
	        predicate = undefined;
	      }
	      return func(collection, getIteratee(predicate, 3));
	    }
	
	    /**
	     * Creates an array of elements, sorted in ascending order by the results of
	     * running each element in a collection thru each iteratee. This method
	     * performs a stable sort, that is, it preserves the original sort order of
	     * equal elements. The iteratees are invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Collection
	     * @param {Array|Object} collection The collection to iterate over.
	     * @param {...(Function|Function[])} [iteratees=[_.identity]]
	     *  The iteratees to sort by.
	     * @returns {Array} Returns the new sorted array.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'fred',   'age': 48 },
	     *   { 'user': 'barney', 'age': 36 },
	     *   { 'user': 'fred',   'age': 40 },
	     *   { 'user': 'barney', 'age': 34 }
	     * ];
	     *
	     * _.sortBy(users, [function(o) { return o.user; }]);
	     * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
	     *
	     * _.sortBy(users, ['user', 'age']);
	     * // => objects for [['barney', 34], ['barney', 36], ['fred', 40], ['fred', 48]]
	     */
	    var sortBy = baseRest(function(collection, iteratees) {
	      if (collection == null) {
	        return [];
	      }
	      var length = iteratees.length;
	      if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
	        iteratees = [];
	      } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
	        iteratees = [iteratees[0]];
	      }
	      return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
	    });
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Gets the timestamp of the number of milliseconds that have elapsed since
	     * the Unix epoch (1 January 1970 00:00:00 UTC).
	     *
	     * @static
	     * @memberOf _
	     * @since 2.4.0
	     * @category Date
	     * @returns {number} Returns the timestamp.
	     * @example
	     *
	     * _.defer(function(stamp) {
	     *   console.log(_.now() - stamp);
	     * }, _.now());
	     * // => Logs the number of milliseconds it took for the deferred invocation.
	     */
	    var now = ctxNow || function() {
	      return root.Date.now();
	    };
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * The opposite of `_.before`; this method creates a function that invokes
	     * `func` once it's called `n` or more times.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {number} n The number of calls before `func` is invoked.
	     * @param {Function} func The function to restrict.
	     * @returns {Function} Returns the new restricted function.
	     * @example
	     *
	     * var saves = ['profile', 'settings'];
	     *
	     * var done = _.after(saves.length, function() {
	     *   console.log('done saving!');
	     * });
	     *
	     * _.forEach(saves, function(type) {
	     *   asyncSave({ 'type': type, 'complete': done });
	     * });
	     * // => Logs 'done saving!' after the two async saves have completed.
	     */
	    function after(n, func) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      n = toInteger(n);
	      return function() {
	        if (--n < 1) {
	          return func.apply(this, arguments);
	        }
	      };
	    }
	
	    /**
	     * Creates a function that invokes `func`, with up to `n` arguments,
	     * ignoring any additional arguments.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Function
	     * @param {Function} func The function to cap arguments for.
	     * @param {number} [n=func.length] The arity cap.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Function} Returns the new capped function.
	     * @example
	     *
	     * _.map(['6', '8', '10'], _.ary(parseInt, 1));
	     * // => [6, 8, 10]
	     */
	    function ary(func, n, guard) {
	      n = guard ? undefined : n;
	      n = (func && n == null) ? func.length : n;
	      return createWrap(func, WRAP_ARY_FLAG, undefined, undefined, undefined, undefined, n);
	    }
	
	    /**
	     * Creates a function that invokes `func`, with the `this` binding and arguments
	     * of the created function, while it's called less than `n` times. Subsequent
	     * calls to the created function return the result of the last `func` invocation.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Function
	     * @param {number} n The number of calls at which `func` is no longer invoked.
	     * @param {Function} func The function to restrict.
	     * @returns {Function} Returns the new restricted function.
	     * @example
	     *
	     * jQuery(element).on('click', _.before(5, addContactToList));
	     * // => Allows adding up to 4 contacts to the list.
	     */
	    function before(n, func) {
	      var result;
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      n = toInteger(n);
	      return function() {
	        if (--n > 0) {
	          result = func.apply(this, arguments);
	        }
	        if (n <= 1) {
	          func = undefined;
	        }
	        return result;
	      };
	    }
	
	    /**
	     * Creates a function that invokes `func` with the `this` binding of `thisArg`
	     * and `partials` prepended to the arguments it receives.
	     *
	     * The `_.bind.placeholder` value, which defaults to `_` in monolithic builds,
	     * may be used as a placeholder for partially applied arguments.
	     *
	     * **Note:** Unlike native `Function#bind`, this method doesn't set the "length"
	     * property of bound functions.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {Function} func The function to bind.
	     * @param {*} thisArg The `this` binding of `func`.
	     * @param {...*} [partials] The arguments to be partially applied.
	     * @returns {Function} Returns the new bound function.
	     * @example
	     *
	     * function greet(greeting, punctuation) {
	     *   return greeting + ' ' + this.user + punctuation;
	     * }
	     *
	     * var object = { 'user': 'fred' };
	     *
	     * var bound = _.bind(greet, object, 'hi');
	     * bound('!');
	     * // => 'hi fred!'
	     *
	     * // Bound with placeholders.
	     * var bound = _.bind(greet, object, _, '!');
	     * bound('hi');
	     * // => 'hi fred!'
	     */
	    var bind = baseRest(function(func, thisArg, partials) {
	      var bitmask = WRAP_BIND_FLAG;
	      if (partials.length) {
	        var holders = replaceHolders(partials, getHolder(bind));
	        bitmask |= WRAP_PARTIAL_FLAG;
	      }
	      return createWrap(func, bitmask, thisArg, partials, holders);
	    });
	
	    /**
	     * Creates a function that invokes the method at `object[key]` with `partials`
	     * prepended to the arguments it receives.
	     *
	     * This method differs from `_.bind` by allowing bound functions to reference
	     * methods that may be redefined or don't yet exist. See
	     * [Peter Michaux's article](http://peter.michaux.ca/articles/lazy-function-definition-pattern)
	     * for more details.
	     *
	     * The `_.bindKey.placeholder` value, which defaults to `_` in monolithic
	     * builds, may be used as a placeholder for partially applied arguments.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.10.0
	     * @category Function
	     * @param {Object} object The object to invoke the method on.
	     * @param {string} key The key of the method.
	     * @param {...*} [partials] The arguments to be partially applied.
	     * @returns {Function} Returns the new bound function.
	     * @example
	     *
	     * var object = {
	     *   'user': 'fred',
	     *   'greet': function(greeting, punctuation) {
	     *     return greeting + ' ' + this.user + punctuation;
	     *   }
	     * };
	     *
	     * var bound = _.bindKey(object, 'greet', 'hi');
	     * bound('!');
	     * // => 'hi fred!'
	     *
	     * object.greet = function(greeting, punctuation) {
	     *   return greeting + 'ya ' + this.user + punctuation;
	     * };
	     *
	     * bound('!');
	     * // => 'hiya fred!'
	     *
	     * // Bound with placeholders.
	     * var bound = _.bindKey(object, 'greet', _, '!');
	     * bound('hi');
	     * // => 'hiya fred!'
	     */
	    var bindKey = baseRest(function(object, key, partials) {
	      var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
	      if (partials.length) {
	        var holders = replaceHolders(partials, getHolder(bindKey));
	        bitmask |= WRAP_PARTIAL_FLAG;
	      }
	      return createWrap(key, bitmask, object, partials, holders);
	    });
	
	    /**
	     * Creates a function that accepts arguments of `func` and either invokes
	     * `func` returning its result, if at least `arity` number of arguments have
	     * been provided, or returns a function that accepts the remaining `func`
	     * arguments, and so on. The arity of `func` may be specified if `func.length`
	     * is not sufficient.
	     *
	     * The `_.curry.placeholder` value, which defaults to `_` in monolithic builds,
	     * may be used as a placeholder for provided arguments.
	     *
	     * **Note:** This method doesn't set the "length" property of curried functions.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Function
	     * @param {Function} func The function to curry.
	     * @param {number} [arity=func.length] The arity of `func`.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Function} Returns the new curried function.
	     * @example
	     *
	     * var abc = function(a, b, c) {
	     *   return [a, b, c];
	     * };
	     *
	     * var curried = _.curry(abc);
	     *
	     * curried(1)(2)(3);
	     * // => [1, 2, 3]
	     *
	     * curried(1, 2)(3);
	     * // => [1, 2, 3]
	     *
	     * curried(1, 2, 3);
	     * // => [1, 2, 3]
	     *
	     * // Curried with placeholders.
	     * curried(1)(_, 3)(2);
	     * // => [1, 2, 3]
	     */
	    function curry(func, arity, guard) {
	      arity = guard ? undefined : arity;
	      var result = createWrap(func, WRAP_CURRY_FLAG, undefined, undefined, undefined, undefined, undefined, arity);
	      result.placeholder = curry.placeholder;
	      return result;
	    }
	
	    /**
	     * This method is like `_.curry` except that arguments are applied to `func`
	     * in the manner of `_.partialRight` instead of `_.partial`.
	     *
	     * The `_.curryRight.placeholder` value, which defaults to `_` in monolithic
	     * builds, may be used as a placeholder for provided arguments.
	     *
	     * **Note:** This method doesn't set the "length" property of curried functions.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Function
	     * @param {Function} func The function to curry.
	     * @param {number} [arity=func.length] The arity of `func`.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Function} Returns the new curried function.
	     * @example
	     *
	     * var abc = function(a, b, c) {
	     *   return [a, b, c];
	     * };
	     *
	     * var curried = _.curryRight(abc);
	     *
	     * curried(3)(2)(1);
	     * // => [1, 2, 3]
	     *
	     * curried(2, 3)(1);
	     * // => [1, 2, 3]
	     *
	     * curried(1, 2, 3);
	     * // => [1, 2, 3]
	     *
	     * // Curried with placeholders.
	     * curried(3)(1, _)(2);
	     * // => [1, 2, 3]
	     */
	    function curryRight(func, arity, guard) {
	      arity = guard ? undefined : arity;
	      var result = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined, undefined, undefined, undefined, undefined, arity);
	      result.placeholder = curryRight.placeholder;
	      return result;
	    }
	
	    /**
	     * Creates a debounced function that delays invoking `func` until after `wait`
	     * milliseconds have elapsed since the last time the debounced function was
	     * invoked. The debounced function comes with a `cancel` method to cancel
	     * delayed `func` invocations and a `flush` method to immediately invoke them.
	     * Provide `options` to indicate whether `func` should be invoked on the
	     * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
	     * with the last arguments provided to the debounced function. Subsequent
	     * calls to the debounced function return the result of the last `func`
	     * invocation.
	     *
	     * **Note:** If `leading` and `trailing` options are `true`, `func` is
	     * invoked on the trailing edge of the timeout only if the debounced function
	     * is invoked more than once during the `wait` timeout.
	     *
	     * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
	     * until to the next tick, similar to `setTimeout` with a timeout of `0`.
	     *
	     * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
	     * for details over the differences between `_.debounce` and `_.throttle`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {Function} func The function to debounce.
	     * @param {number} [wait=0] The number of milliseconds to delay.
	     * @param {Object} [options={}] The options object.
	     * @param {boolean} [options.leading=false]
	     *  Specify invoking on the leading edge of the timeout.
	     * @param {number} [options.maxWait]
	     *  The maximum time `func` is allowed to be delayed before it's invoked.
	     * @param {boolean} [options.trailing=true]
	     *  Specify invoking on the trailing edge of the timeout.
	     * @returns {Function} Returns the new debounced function.
	     * @example
	     *
	     * // Avoid costly calculations while the window size is in flux.
	     * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
	     *
	     * // Invoke `sendMail` when clicked, debouncing subsequent calls.
	     * jQuery(element).on('click', _.debounce(sendMail, 300, {
	     *   'leading': true,
	     *   'trailing': false
	     * }));
	     *
	     * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
	     * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
	     * var source = new EventSource('/stream');
	     * jQuery(source).on('message', debounced);
	     *
	     * // Cancel the trailing debounced invocation.
	     * jQuery(window).on('popstate', debounced.cancel);
	     */
	    function debounce(func, wait, options) {
	      var lastArgs,
	          lastThis,
	          maxWait,
	          result,
	          timerId,
	          lastCallTime,
	          lastInvokeTime = 0,
	          leading = false,
	          maxing = false,
	          trailing = true;
	
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      wait = toNumber(wait) || 0;
	      if (isObject(options)) {
	        leading = !!options.leading;
	        maxing = 'maxWait' in options;
	        maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
	        trailing = 'trailing' in options ? !!options.trailing : trailing;
	      }
	
	      function invokeFunc(time) {
	        var args = lastArgs,
	            thisArg = lastThis;
	
	        lastArgs = lastThis = undefined;
	        lastInvokeTime = time;
	        result = func.apply(thisArg, args);
	        return result;
	      }
	
	      function leadingEdge(time) {
	        // Reset any `maxWait` timer.
	        lastInvokeTime = time;
	        // Start the timer for the trailing edge.
	        timerId = setTimeout(timerExpired, wait);
	        // Invoke the leading edge.
	        return leading ? invokeFunc(time) : result;
	      }
	
	      function remainingWait(time) {
	        var timeSinceLastCall = time - lastCallTime,
	            timeSinceLastInvoke = time - lastInvokeTime,
	            result = wait - timeSinceLastCall;
	
	        return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;
	      }
	
	      function shouldInvoke(time) {
	        var timeSinceLastCall = time - lastCallTime,
	            timeSinceLastInvoke = time - lastInvokeTime;
	
	        // Either this is the first call, activity has stopped and we're at the
	        // trailing edge, the system time has gone backwards and we're treating
	        // it as the trailing edge, or we've hit the `maxWait` limit.
	        return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
	          (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
	      }
	
	      function timerExpired() {
	        var time = now();
	        if (shouldInvoke(time)) {
	          return trailingEdge(time);
	        }
	        // Restart the timer.
	        timerId = setTimeout(timerExpired, remainingWait(time));
	      }
	
	      function trailingEdge(time) {
	        timerId = undefined;
	
	        // Only invoke if we have `lastArgs` which means `func` has been
	        // debounced at least once.
	        if (trailing && lastArgs) {
	          return invokeFunc(time);
	        }
	        lastArgs = lastThis = undefined;
	        return result;
	      }
	
	      function cancel() {
	        if (timerId !== undefined) {
	          clearTimeout(timerId);
	        }
	        lastInvokeTime = 0;
	        lastArgs = lastCallTime = lastThis = timerId = undefined;
	      }
	
	      function flush() {
	        return timerId === undefined ? result : trailingEdge(now());
	      }
	
	      function debounced() {
	        var time = now(),
	            isInvoking = shouldInvoke(time);
	
	        lastArgs = arguments;
	        lastThis = this;
	        lastCallTime = time;
	
	        if (isInvoking) {
	          if (timerId === undefined) {
	            return leadingEdge(lastCallTime);
	          }
	          if (maxing) {
	            // Handle invocations in a tight loop.
	            timerId = setTimeout(timerExpired, wait);
	            return invokeFunc(lastCallTime);
	          }
	        }
	        if (timerId === undefined) {
	          timerId = setTimeout(timerExpired, wait);
	        }
	        return result;
	      }
	      debounced.cancel = cancel;
	      debounced.flush = flush;
	      return debounced;
	    }
	
	    /**
	     * Defers invoking the `func` until the current call stack has cleared. Any
	     * additional arguments are provided to `func` when it's invoked.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {Function} func The function to defer.
	     * @param {...*} [args] The arguments to invoke `func` with.
	     * @returns {number} Returns the timer id.
	     * @example
	     *
	     * _.defer(function(text) {
	     *   console.log(text);
	     * }, 'deferred');
	     * // => Logs 'deferred' after one millisecond.
	     */
	    var defer = baseRest(function(func, args) {
	      return baseDelay(func, 1, args);
	    });
	
	    /**
	     * Invokes `func` after `wait` milliseconds. Any additional arguments are
	     * provided to `func` when it's invoked.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {Function} func The function to delay.
	     * @param {number} wait The number of milliseconds to delay invocation.
	     * @param {...*} [args] The arguments to invoke `func` with.
	     * @returns {number} Returns the timer id.
	     * @example
	     *
	     * _.delay(function(text) {
	     *   console.log(text);
	     * }, 1000, 'later');
	     * // => Logs 'later' after one second.
	     */
	    var delay = baseRest(function(func, wait, args) {
	      return baseDelay(func, toNumber(wait) || 0, args);
	    });
	
	    /**
	     * Creates a function that invokes `func` with arguments reversed.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Function
	     * @param {Function} func The function to flip arguments for.
	     * @returns {Function} Returns the new flipped function.
	     * @example
	     *
	     * var flipped = _.flip(function() {
	     *   return _.toArray(arguments);
	     * });
	     *
	     * flipped('a', 'b', 'c', 'd');
	     * // => ['d', 'c', 'b', 'a']
	     */
	    function flip(func) {
	      return createWrap(func, WRAP_FLIP_FLAG);
	    }
	
	    /**
	     * Creates a function that memoizes the result of `func`. If `resolver` is
	     * provided, it determines the cache key for storing the result based on the
	     * arguments provided to the memoized function. By default, the first argument
	     * provided to the memoized function is used as the map cache key. The `func`
	     * is invoked with the `this` binding of the memoized function.
	     *
	     * **Note:** The cache is exposed as the `cache` property on the memoized
	     * function. Its creation may be customized by replacing the `_.memoize.Cache`
	     * constructor with one whose instances implement the
	     * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
	     * method interface of `clear`, `delete`, `get`, `has`, and `set`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {Function} func The function to have its output memoized.
	     * @param {Function} [resolver] The function to resolve the cache key.
	     * @returns {Function} Returns the new memoized function.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': 2 };
	     * var other = { 'c': 3, 'd': 4 };
	     *
	     * var values = _.memoize(_.values);
	     * values(object);
	     * // => [1, 2]
	     *
	     * values(other);
	     * // => [3, 4]
	     *
	     * object.a = 2;
	     * values(object);
	     * // => [1, 2]
	     *
	     * // Modify the result cache.
	     * values.cache.set(object, ['a', 'b']);
	     * values(object);
	     * // => ['a', 'b']
	     *
	     * // Replace `_.memoize.Cache`.
	     * _.memoize.Cache = WeakMap;
	     */
	    function memoize(func, resolver) {
	      if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      var memoized = function() {
	        var args = arguments,
	            key = resolver ? resolver.apply(this, args) : args[0],
	            cache = memoized.cache;
	
	        if (cache.has(key)) {
	          return cache.get(key);
	        }
	        var result = func.apply(this, args);
	        memoized.cache = cache.set(key, result) || cache;
	        return result;
	      };
	      memoized.cache = new (memoize.Cache || MapCache);
	      return memoized;
	    }
	
	    // Expose `MapCache`.
	    memoize.Cache = MapCache;
	
	    /**
	     * Creates a function that negates the result of the predicate `func`. The
	     * `func` predicate is invoked with the `this` binding and arguments of the
	     * created function.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Function
	     * @param {Function} predicate The predicate to negate.
	     * @returns {Function} Returns the new negated function.
	     * @example
	     *
	     * function isEven(n) {
	     *   return n % 2 == 0;
	     * }
	     *
	     * _.filter([1, 2, 3, 4, 5, 6], _.negate(isEven));
	     * // => [1, 3, 5]
	     */
	    function negate(predicate) {
	      if (typeof predicate != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      return function() {
	        var args = arguments;
	        switch (args.length) {
	          case 0: return !predicate.call(this);
	          case 1: return !predicate.call(this, args[0]);
	          case 2: return !predicate.call(this, args[0], args[1]);
	          case 3: return !predicate.call(this, args[0], args[1], args[2]);
	        }
	        return !predicate.apply(this, args);
	      };
	    }
	
	    /**
	     * Creates a function that is restricted to invoking `func` once. Repeat calls
	     * to the function return the value of the first invocation. The `func` is
	     * invoked with the `this` binding and arguments of the created function.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {Function} func The function to restrict.
	     * @returns {Function} Returns the new restricted function.
	     * @example
	     *
	     * var initialize = _.once(createApplication);
	     * initialize();
	     * initialize();
	     * // => `createApplication` is invoked once
	     */
	    function once(func) {
	      return before(2, func);
	    }
	
	    /**
	     * Creates a function that invokes `func` with its arguments transformed.
	     *
	     * @static
	     * @since 4.0.0
	     * @memberOf _
	     * @category Function
	     * @param {Function} func The function to wrap.
	     * @param {...(Function|Function[])} [transforms=[_.identity]]
	     *  The argument transforms.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * function doubled(n) {
	     *   return n * 2;
	     * }
	     *
	     * function square(n) {
	     *   return n * n;
	     * }
	     *
	     * var func = _.overArgs(function(x, y) {
	     *   return [x, y];
	     * }, [square, doubled]);
	     *
	     * func(9, 3);
	     * // => [81, 6]
	     *
	     * func(10, 5);
	     * // => [100, 10]
	     */
	    var overArgs = castRest(function(func, transforms) {
	      transforms = (transforms.length == 1 && isArray(transforms[0]))
	        ? arrayMap(transforms[0], baseUnary(getIteratee()))
	        : arrayMap(baseFlatten(transforms, 1), baseUnary(getIteratee()));
	
	      var funcsLength = transforms.length;
	      return baseRest(function(args) {
	        var index = -1,
	            length = nativeMin(args.length, funcsLength);
	
	        while (++index < length) {
	          args[index] = transforms[index].call(this, args[index]);
	        }
	        return apply(func, this, args);
	      });
	    });
	
	    /**
	     * Creates a function that invokes `func` with `partials` prepended to the
	     * arguments it receives. This method is like `_.bind` except it does **not**
	     * alter the `this` binding.
	     *
	     * The `_.partial.placeholder` value, which defaults to `_` in monolithic
	     * builds, may be used as a placeholder for partially applied arguments.
	     *
	     * **Note:** This method doesn't set the "length" property of partially
	     * applied functions.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.2.0
	     * @category Function
	     * @param {Function} func The function to partially apply arguments to.
	     * @param {...*} [partials] The arguments to be partially applied.
	     * @returns {Function} Returns the new partially applied function.
	     * @example
	     *
	     * function greet(greeting, name) {
	     *   return greeting + ' ' + name;
	     * }
	     *
	     * var sayHelloTo = _.partial(greet, 'hello');
	     * sayHelloTo('fred');
	     * // => 'hello fred'
	     *
	     * // Partially applied with placeholders.
	     * var greetFred = _.partial(greet, _, 'fred');
	     * greetFred('hi');
	     * // => 'hi fred'
	     */
	    var partial = baseRest(function(func, partials) {
	      var holders = replaceHolders(partials, getHolder(partial));
	      return createWrap(func, WRAP_PARTIAL_FLAG, undefined, partials, holders);
	    });
	
	    /**
	     * This method is like `_.partial` except that partially applied arguments
	     * are appended to the arguments it receives.
	     *
	     * The `_.partialRight.placeholder` value, which defaults to `_` in monolithic
	     * builds, may be used as a placeholder for partially applied arguments.
	     *
	     * **Note:** This method doesn't set the "length" property of partially
	     * applied functions.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.0.0
	     * @category Function
	     * @param {Function} func The function to partially apply arguments to.
	     * @param {...*} [partials] The arguments to be partially applied.
	     * @returns {Function} Returns the new partially applied function.
	     * @example
	     *
	     * function greet(greeting, name) {
	     *   return greeting + ' ' + name;
	     * }
	     *
	     * var greetFred = _.partialRight(greet, 'fred');
	     * greetFred('hi');
	     * // => 'hi fred'
	     *
	     * // Partially applied with placeholders.
	     * var sayHelloTo = _.partialRight(greet, 'hello', _);
	     * sayHelloTo('fred');
	     * // => 'hello fred'
	     */
	    var partialRight = baseRest(function(func, partials) {
	      var holders = replaceHolders(partials, getHolder(partialRight));
	      return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined, partials, holders);
	    });
	
	    /**
	     * Creates a function that invokes `func` with arguments arranged according
	     * to the specified `indexes` where the argument value at the first index is
	     * provided as the first argument, the argument value at the second index is
	     * provided as the second argument, and so on.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Function
	     * @param {Function} func The function to rearrange arguments for.
	     * @param {...(number|number[])} indexes The arranged argument indexes.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var rearged = _.rearg(function(a, b, c) {
	     *   return [a, b, c];
	     * }, [2, 0, 1]);
	     *
	     * rearged('b', 'c', 'a')
	     * // => ['a', 'b', 'c']
	     */
	    var rearg = flatRest(function(func, indexes) {
	      return createWrap(func, WRAP_REARG_FLAG, undefined, undefined, undefined, indexes);
	    });
	
	    /**
	     * Creates a function that invokes `func` with the `this` binding of the
	     * created function and arguments from `start` and beyond provided as
	     * an array.
	     *
	     * **Note:** This method is based on the
	     * [rest parameter](https://mdn.io/rest_parameters).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Function
	     * @param {Function} func The function to apply a rest parameter to.
	     * @param {number} [start=func.length-1] The start position of the rest parameter.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var say = _.rest(function(what, names) {
	     *   return what + ' ' + _.initial(names).join(', ') +
	     *     (_.size(names) > 1 ? ', & ' : '') + _.last(names);
	     * });
	     *
	     * say('hello', 'fred', 'barney', 'pebbles');
	     * // => 'hello fred, barney, & pebbles'
	     */
	    function rest(func, start) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      start = start === undefined ? start : toInteger(start);
	      return baseRest(func, start);
	    }
	
	    /**
	     * Creates a function that invokes `func` with the `this` binding of the
	     * create function and an array of arguments much like
	     * [`Function#apply`](http://www.ecma-international.org/ecma-262/7.0/#sec-function.prototype.apply).
	     *
	     * **Note:** This method is based on the
	     * [spread operator](https://mdn.io/spread_operator).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.2.0
	     * @category Function
	     * @param {Function} func The function to spread arguments over.
	     * @param {number} [start=0] The start position of the spread.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var say = _.spread(function(who, what) {
	     *   return who + ' says ' + what;
	     * });
	     *
	     * say(['fred', 'hello']);
	     * // => 'fred says hello'
	     *
	     * var numbers = Promise.all([
	     *   Promise.resolve(40),
	     *   Promise.resolve(36)
	     * ]);
	     *
	     * numbers.then(_.spread(function(x, y) {
	     *   return x + y;
	     * }));
	     * // => a Promise of 76
	     */
	    function spread(func, start) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      start = start == null ? 0 : nativeMax(toInteger(start), 0);
	      return baseRest(function(args) {
	        var array = args[start],
	            otherArgs = castSlice(args, 0, start);
	
	        if (array) {
	          arrayPush(otherArgs, array);
	        }
	        return apply(func, this, otherArgs);
	      });
	    }
	
	    /**
	     * Creates a throttled function that only invokes `func` at most once per
	     * every `wait` milliseconds. The throttled function comes with a `cancel`
	     * method to cancel delayed `func` invocations and a `flush` method to
	     * immediately invoke them. Provide `options` to indicate whether `func`
	     * should be invoked on the leading and/or trailing edge of the `wait`
	     * timeout. The `func` is invoked with the last arguments provided to the
	     * throttled function. Subsequent calls to the throttled function return the
	     * result of the last `func` invocation.
	     *
	     * **Note:** If `leading` and `trailing` options are `true`, `func` is
	     * invoked on the trailing edge of the timeout only if the throttled function
	     * is invoked more than once during the `wait` timeout.
	     *
	     * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
	     * until to the next tick, similar to `setTimeout` with a timeout of `0`.
	     *
	     * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
	     * for details over the differences between `_.throttle` and `_.debounce`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {Function} func The function to throttle.
	     * @param {number} [wait=0] The number of milliseconds to throttle invocations to.
	     * @param {Object} [options={}] The options object.
	     * @param {boolean} [options.leading=true]
	     *  Specify invoking on the leading edge of the timeout.
	     * @param {boolean} [options.trailing=true]
	     *  Specify invoking on the trailing edge of the timeout.
	     * @returns {Function} Returns the new throttled function.
	     * @example
	     *
	     * // Avoid excessively updating the position while scrolling.
	     * jQuery(window).on('scroll', _.throttle(updatePosition, 100));
	     *
	     * // Invoke `renewToken` when the click event is fired, but not more than once every 5 minutes.
	     * var throttled = _.throttle(renewToken, 300000, { 'trailing': false });
	     * jQuery(element).on('click', throttled);
	     *
	     * // Cancel the trailing throttled invocation.
	     * jQuery(window).on('popstate', throttled.cancel);
	     */
	    function throttle(func, wait, options) {
	      var leading = true,
	          trailing = true;
	
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      if (isObject(options)) {
	        leading = 'leading' in options ? !!options.leading : leading;
	        trailing = 'trailing' in options ? !!options.trailing : trailing;
	      }
	      return debounce(func, wait, {
	        'leading': leading,
	        'maxWait': wait,
	        'trailing': trailing
	      });
	    }
	
	    /**
	     * Creates a function that accepts up to one argument, ignoring any
	     * additional arguments.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Function
	     * @param {Function} func The function to cap arguments for.
	     * @returns {Function} Returns the new capped function.
	     * @example
	     *
	     * _.map(['6', '8', '10'], _.unary(parseInt));
	     * // => [6, 8, 10]
	     */
	    function unary(func) {
	      return ary(func, 1);
	    }
	
	    /**
	     * Creates a function that provides `value` to `wrapper` as its first
	     * argument. Any additional arguments provided to the function are appended
	     * to those provided to the `wrapper`. The wrapper is invoked with the `this`
	     * binding of the created function.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Function
	     * @param {*} value The value to wrap.
	     * @param {Function} [wrapper=identity] The wrapper function.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var p = _.wrap(_.escape, function(func, text) {
	     *   return '<p>' + func(text) + '</p>';
	     * });
	     *
	     * p('fred, barney, & pebbles');
	     * // => '<p>fred, barney, &amp; pebbles</p>'
	     */
	    function wrap(value, wrapper) {
	      return partial(castFunction(wrapper), value);
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Casts `value` as an array if it's not one.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.4.0
	     * @category Lang
	     * @param {*} value The value to inspect.
	     * @returns {Array} Returns the cast array.
	     * @example
	     *
	     * _.castArray(1);
	     * // => [1]
	     *
	     * _.castArray({ 'a': 1 });
	     * // => [{ 'a': 1 }]
	     *
	     * _.castArray('abc');
	     * // => ['abc']
	     *
	     * _.castArray(null);
	     * // => [null]
	     *
	     * _.castArray(undefined);
	     * // => [undefined]
	     *
	     * _.castArray();
	     * // => []
	     *
	     * var array = [1, 2, 3];
	     * console.log(_.castArray(array) === array);
	     * // => true
	     */
	    function castArray() {
	      if (!arguments.length) {
	        return [];
	      }
	      var value = arguments[0];
	      return isArray(value) ? value : [value];
	    }
	
	    /**
	     * Creates a shallow clone of `value`.
	     *
	     * **Note:** This method is loosely based on the
	     * [structured clone algorithm](https://mdn.io/Structured_clone_algorithm)
	     * and supports cloning arrays, array buffers, booleans, date objects, maps,
	     * numbers, `Object` objects, regexes, sets, strings, symbols, and typed
	     * arrays. The own enumerable properties of `arguments` objects are cloned
	     * as plain objects. An empty object is returned for uncloneable values such
	     * as error objects, functions, DOM nodes, and WeakMaps.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to clone.
	     * @returns {*} Returns the cloned value.
	     * @see _.cloneDeep
	     * @example
	     *
	     * var objects = [{ 'a': 1 }, { 'b': 2 }];
	     *
	     * var shallow = _.clone(objects);
	     * console.log(shallow[0] === objects[0]);
	     * // => true
	     */
	    function clone(value) {
	      return baseClone(value, CLONE_SYMBOLS_FLAG);
	    }
	
	    /**
	     * This method is like `_.clone` except that it accepts `customizer` which
	     * is invoked to produce the cloned value. If `customizer` returns `undefined`,
	     * cloning is handled by the method instead. The `customizer` is invoked with
	     * up to four arguments; (value [, index|key, object, stack]).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to clone.
	     * @param {Function} [customizer] The function to customize cloning.
	     * @returns {*} Returns the cloned value.
	     * @see _.cloneDeepWith
	     * @example
	     *
	     * function customizer(value) {
	     *   if (_.isElement(value)) {
	     *     return value.cloneNode(false);
	     *   }
	     * }
	     *
	     * var el = _.cloneWith(document.body, customizer);
	     *
	     * console.log(el === document.body);
	     * // => false
	     * console.log(el.nodeName);
	     * // => 'BODY'
	     * console.log(el.childNodes.length);
	     * // => 0
	     */
	    function cloneWith(value, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined;
	      return baseClone(value, CLONE_SYMBOLS_FLAG, customizer);
	    }
	
	    /**
	     * This method is like `_.clone` except that it recursively clones `value`.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.0.0
	     * @category Lang
	     * @param {*} value The value to recursively clone.
	     * @returns {*} Returns the deep cloned value.
	     * @see _.clone
	     * @example
	     *
	     * var objects = [{ 'a': 1 }, { 'b': 2 }];
	     *
	     * var deep = _.cloneDeep(objects);
	     * console.log(deep[0] === objects[0]);
	     * // => false
	     */
	    function cloneDeep(value) {
	      return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
	    }
	
	    /**
	     * This method is like `_.cloneWith` except that it recursively clones `value`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to recursively clone.
	     * @param {Function} [customizer] The function to customize cloning.
	     * @returns {*} Returns the deep cloned value.
	     * @see _.cloneWith
	     * @example
	     *
	     * function customizer(value) {
	     *   if (_.isElement(value)) {
	     *     return value.cloneNode(true);
	     *   }
	     * }
	     *
	     * var el = _.cloneDeepWith(document.body, customizer);
	     *
	     * console.log(el === document.body);
	     * // => false
	     * console.log(el.nodeName);
	     * // => 'BODY'
	     * console.log(el.childNodes.length);
	     * // => 20
	     */
	    function cloneDeepWith(value, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined;
	      return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG, customizer);
	    }
	
	    /**
	     * Checks if `object` conforms to `source` by invoking the predicate
	     * properties of `source` with the corresponding property values of `object`.
	     *
	     * **Note:** This method is equivalent to `_.conforms` when `source` is
	     * partially applied.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.14.0
	     * @category Lang
	     * @param {Object} object The object to inspect.
	     * @param {Object} source The object of property predicates to conform to.
	     * @returns {boolean} Returns `true` if `object` conforms, else `false`.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': 2 };
	     *
	     * _.conformsTo(object, { 'b': function(n) { return n > 1; } });
	     * // => true
	     *
	     * _.conformsTo(object, { 'b': function(n) { return n > 2; } });
	     * // => false
	     */
	    function conformsTo(object, source) {
	      return source == null || baseConformsTo(object, source, keys(source));
	    }
	
	    /**
	     * Performs a
	     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	     * comparison between two values to determine if they are equivalent.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	     * @example
	     *
	     * var object = { 'a': 1 };
	     * var other = { 'a': 1 };
	     *
	     * _.eq(object, object);
	     * // => true
	     *
	     * _.eq(object, other);
	     * // => false
	     *
	     * _.eq('a', 'a');
	     * // => true
	     *
	     * _.eq('a', Object('a'));
	     * // => false
	     *
	     * _.eq(NaN, NaN);
	     * // => true
	     */
	    function eq(value, other) {
	      return value === other || (value !== value && other !== other);
	    }
	
	    /**
	     * Checks if `value` is greater than `other`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.9.0
	     * @category Lang
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if `value` is greater than `other`,
	     *  else `false`.
	     * @see _.lt
	     * @example
	     *
	     * _.gt(3, 1);
	     * // => true
	     *
	     * _.gt(3, 3);
	     * // => false
	     *
	     * _.gt(1, 3);
	     * // => false
	     */
	    var gt = createRelationalOperation(baseGt);
	
	    /**
	     * Checks if `value` is greater than or equal to `other`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.9.0
	     * @category Lang
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if `value` is greater than or equal to
	     *  `other`, else `false`.
	     * @see _.lte
	     * @example
	     *
	     * _.gte(3, 1);
	     * // => true
	     *
	     * _.gte(3, 3);
	     * // => true
	     *
	     * _.gte(1, 3);
	     * // => false
	     */
	    var gte = createRelationalOperation(function(value, other) {
	      return value >= other;
	    });
	
	    /**
	     * Checks if `value` is likely an `arguments` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
	     *  else `false`.
	     * @example
	     *
	     * _.isArguments(function() { return arguments; }());
	     * // => true
	     *
	     * _.isArguments([1, 2, 3]);
	     * // => false
	     */
	    var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
	      return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
	        !propertyIsEnumerable.call(value, 'callee');
	    };
	
	    /**
	     * Checks if `value` is classified as an `Array` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
	     * @example
	     *
	     * _.isArray([1, 2, 3]);
	     * // => true
	     *
	     * _.isArray(document.body.children);
	     * // => false
	     *
	     * _.isArray('abc');
	     * // => false
	     *
	     * _.isArray(_.noop);
	     * // => false
	     */
	    var isArray = Array.isArray;
	
	    /**
	     * Checks if `value` is classified as an `ArrayBuffer` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.3.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an array buffer, else `false`.
	     * @example
	     *
	     * _.isArrayBuffer(new ArrayBuffer(2));
	     * // => true
	     *
	     * _.isArrayBuffer(new Array(2));
	     * // => false
	     */
	    var isArrayBuffer = nodeIsArrayBuffer ? baseUnary(nodeIsArrayBuffer) : baseIsArrayBuffer;
	
	    /**
	     * Checks if `value` is array-like. A value is considered array-like if it's
	     * not a function and has a `value.length` that's an integer greater than or
	     * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
	     * @example
	     *
	     * _.isArrayLike([1, 2, 3]);
	     * // => true
	     *
	     * _.isArrayLike(document.body.children);
	     * // => true
	     *
	     * _.isArrayLike('abc');
	     * // => true
	     *
	     * _.isArrayLike(_.noop);
	     * // => false
	     */
	    function isArrayLike(value) {
	      return value != null && isLength(value.length) && !isFunction(value);
	    }
	
	    /**
	     * This method is like `_.isArrayLike` except that it also checks if `value`
	     * is an object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an array-like object,
	     *  else `false`.
	     * @example
	     *
	     * _.isArrayLikeObject([1, 2, 3]);
	     * // => true
	     *
	     * _.isArrayLikeObject(document.body.children);
	     * // => true
	     *
	     * _.isArrayLikeObject('abc');
	     * // => false
	     *
	     * _.isArrayLikeObject(_.noop);
	     * // => false
	     */
	    function isArrayLikeObject(value) {
	      return isObjectLike(value) && isArrayLike(value);
	    }
	
	    /**
	     * Checks if `value` is classified as a boolean primitive or object.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a boolean, else `false`.
	     * @example
	     *
	     * _.isBoolean(false);
	     * // => true
	     *
	     * _.isBoolean(null);
	     * // => false
	     */
	    function isBoolean(value) {
	      return value === true || value === false ||
	        (isObjectLike(value) && baseGetTag(value) == boolTag);
	    }
	
	    /**
	     * Checks if `value` is a buffer.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.3.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
	     * @example
	     *
	     * _.isBuffer(new Buffer(2));
	     * // => true
	     *
	     * _.isBuffer(new Uint8Array(2));
	     * // => false
	     */
	    var isBuffer = nativeIsBuffer || stubFalse;
	
	    /**
	     * Checks if `value` is classified as a `Date` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a date object, else `false`.
	     * @example
	     *
	     * _.isDate(new Date);
	     * // => true
	     *
	     * _.isDate('Mon April 23 2012');
	     * // => false
	     */
	    var isDate = nodeIsDate ? baseUnary(nodeIsDate) : baseIsDate;
	
	    /**
	     * Checks if `value` is likely a DOM element.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a DOM element, else `false`.
	     * @example
	     *
	     * _.isElement(document.body);
	     * // => true
	     *
	     * _.isElement('<body>');
	     * // => false
	     */
	    function isElement(value) {
	      return isObjectLike(value) && value.nodeType === 1 && !isPlainObject(value);
	    }
	
	    /**
	     * Checks if `value` is an empty object, collection, map, or set.
	     *
	     * Objects are considered empty if they have no own enumerable string keyed
	     * properties.
	     *
	     * Array-like values such as `arguments` objects, arrays, buffers, strings, or
	     * jQuery-like collections are considered empty if they have a `length` of `0`.
	     * Similarly, maps and sets are considered empty if they have a `size` of `0`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is empty, else `false`.
	     * @example
	     *
	     * _.isEmpty(null);
	     * // => true
	     *
	     * _.isEmpty(true);
	     * // => true
	     *
	     * _.isEmpty(1);
	     * // => true
	     *
	     * _.isEmpty([1, 2, 3]);
	     * // => false
	     *
	     * _.isEmpty({ 'a': 1 });
	     * // => false
	     */
	    function isEmpty(value) {
	      if (value == null) {
	        return true;
	      }
	      if (isArrayLike(value) &&
	          (isArray(value) || typeof value == 'string' || typeof value.splice == 'function' ||
	            isBuffer(value) || isTypedArray(value) || isArguments(value))) {
	        return !value.length;
	      }
	      var tag = getTag(value);
	      if (tag == mapTag || tag == setTag) {
	        return !value.size;
	      }
	      if (isPrototype(value)) {
	        return !baseKeys(value).length;
	      }
	      for (var key in value) {
	        if (hasOwnProperty.call(value, key)) {
	          return false;
	        }
	      }
	      return true;
	    }
	
	    /**
	     * Performs a deep comparison between two values to determine if they are
	     * equivalent.
	     *
	     * **Note:** This method supports comparing arrays, array buffers, booleans,
	     * date objects, error objects, maps, numbers, `Object` objects, regexes,
	     * sets, strings, symbols, and typed arrays. `Object` objects are compared
	     * by their own, not inherited, enumerable properties. Functions and DOM
	     * nodes are compared by strict equality, i.e. `===`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	     * @example
	     *
	     * var object = { 'a': 1 };
	     * var other = { 'a': 1 };
	     *
	     * _.isEqual(object, other);
	     * // => true
	     *
	     * object === other;
	     * // => false
	     */
	    function isEqual(value, other) {
	      return baseIsEqual(value, other);
	    }
	
	    /**
	     * This method is like `_.isEqual` except that it accepts `customizer` which
	     * is invoked to compare values. If `customizer` returns `undefined`, comparisons
	     * are handled by the method instead. The `customizer` is invoked with up to
	     * six arguments: (objValue, othValue [, index|key, object, other, stack]).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @param {Function} [customizer] The function to customize comparisons.
	     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	     * @example
	     *
	     * function isGreeting(value) {
	     *   return /^h(?:i|ello)$/.test(value);
	     * }
	     *
	     * function customizer(objValue, othValue) {
	     *   if (isGreeting(objValue) && isGreeting(othValue)) {
	     *     return true;
	     *   }
	     * }
	     *
	     * var array = ['hello', 'goodbye'];
	     * var other = ['hi', 'goodbye'];
	     *
	     * _.isEqualWith(array, other, customizer);
	     * // => true
	     */
	    function isEqualWith(value, other, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined;
	      var result = customizer ? customizer(value, other) : undefined;
	      return result === undefined ? baseIsEqual(value, other, undefined, customizer) : !!result;
	    }
	
	    /**
	     * Checks if `value` is an `Error`, `EvalError`, `RangeError`, `ReferenceError`,
	     * `SyntaxError`, `TypeError`, or `URIError` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an error object, else `false`.
	     * @example
	     *
	     * _.isError(new Error);
	     * // => true
	     *
	     * _.isError(Error);
	     * // => false
	     */
	    function isError(value) {
	      if (!isObjectLike(value)) {
	        return false;
	      }
	      var tag = baseGetTag(value);
	      return tag == errorTag || tag == domExcTag ||
	        (typeof value.message == 'string' && typeof value.name == 'string' && !isPlainObject(value));
	    }
	
	    /**
	     * Checks if `value` is a finite primitive number.
	     *
	     * **Note:** This method is based on
	     * [`Number.isFinite`](https://mdn.io/Number/isFinite).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a finite number, else `false`.
	     * @example
	     *
	     * _.isFinite(3);
	     * // => true
	     *
	     * _.isFinite(Number.MIN_VALUE);
	     * // => true
	     *
	     * _.isFinite(Infinity);
	     * // => false
	     *
	     * _.isFinite('3');
	     * // => false
	     */
	    function isFinite(value) {
	      return typeof value == 'number' && nativeIsFinite(value);
	    }
	
	    /**
	     * Checks if `value` is classified as a `Function` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a function, else `false`.
	     * @example
	     *
	     * _.isFunction(_);
	     * // => true
	     *
	     * _.isFunction(/abc/);
	     * // => false
	     */
	    function isFunction(value) {
	      if (!isObject(value)) {
	        return false;
	      }
	      // The use of `Object#toString` avoids issues with the `typeof` operator
	      // in Safari 9 which returns 'object' for typed arrays and other constructors.
	      var tag = baseGetTag(value);
	      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
	    }
	
	    /**
	     * Checks if `value` is an integer.
	     *
	     * **Note:** This method is based on
	     * [`Number.isInteger`](https://mdn.io/Number/isInteger).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an integer, else `false`.
	     * @example
	     *
	     * _.isInteger(3);
	     * // => true
	     *
	     * _.isInteger(Number.MIN_VALUE);
	     * // => false
	     *
	     * _.isInteger(Infinity);
	     * // => false
	     *
	     * _.isInteger('3');
	     * // => false
	     */
	    function isInteger(value) {
	      return typeof value == 'number' && value == toInteger(value);
	    }
	
	    /**
	     * Checks if `value` is a valid array-like length.
	     *
	     * **Note:** This method is loosely based on
	     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
	     * @example
	     *
	     * _.isLength(3);
	     * // => true
	     *
	     * _.isLength(Number.MIN_VALUE);
	     * // => false
	     *
	     * _.isLength(Infinity);
	     * // => false
	     *
	     * _.isLength('3');
	     * // => false
	     */
	    function isLength(value) {
	      return typeof value == 'number' &&
	        value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
	    }
	
	    /**
	     * Checks if `value` is the
	     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
	     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	     * @example
	     *
	     * _.isObject({});
	     * // => true
	     *
	     * _.isObject([1, 2, 3]);
	     * // => true
	     *
	     * _.isObject(_.noop);
	     * // => true
	     *
	     * _.isObject(null);
	     * // => false
	     */
	    function isObject(value) {
	      var type = typeof value;
	      return value != null && (type == 'object' || type == 'function');
	    }
	
	    /**
	     * Checks if `value` is object-like. A value is object-like if it's not `null`
	     * and has a `typeof` result of "object".
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	     * @example
	     *
	     * _.isObjectLike({});
	     * // => true
	     *
	     * _.isObjectLike([1, 2, 3]);
	     * // => true
	     *
	     * _.isObjectLike(_.noop);
	     * // => false
	     *
	     * _.isObjectLike(null);
	     * // => false
	     */
	    function isObjectLike(value) {
	      return value != null && typeof value == 'object';
	    }
	
	    /**
	     * Checks if `value` is classified as a `Map` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.3.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a map, else `false`.
	     * @example
	     *
	     * _.isMap(new Map);
	     * // => true
	     *
	     * _.isMap(new WeakMap);
	     * // => false
	     */
	    var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
	
	    /**
	     * Performs a partial deep comparison between `object` and `source` to
	     * determine if `object` contains equivalent property values.
	     *
	     * **Note:** This method is equivalent to `_.matches` when `source` is
	     * partially applied.
	     *
	     * Partial comparisons will match empty array and empty object `source`
	     * values against any array or object value, respectively. See `_.isEqual`
	     * for a list of supported value comparisons.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Lang
	     * @param {Object} object The object to inspect.
	     * @param {Object} source The object of property values to match.
	     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': 2 };
	     *
	     * _.isMatch(object, { 'b': 2 });
	     * // => true
	     *
	     * _.isMatch(object, { 'b': 1 });
	     * // => false
	     */
	    function isMatch(object, source) {
	      return object === source || baseIsMatch(object, source, getMatchData(source));
	    }
	
	    /**
	     * This method is like `_.isMatch` except that it accepts `customizer` which
	     * is invoked to compare values. If `customizer` returns `undefined`, comparisons
	     * are handled by the method instead. The `customizer` is invoked with five
	     * arguments: (objValue, srcValue, index|key, object, source).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {Object} object The object to inspect.
	     * @param {Object} source The object of property values to match.
	     * @param {Function} [customizer] The function to customize comparisons.
	     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
	     * @example
	     *
	     * function isGreeting(value) {
	     *   return /^h(?:i|ello)$/.test(value);
	     * }
	     *
	     * function customizer(objValue, srcValue) {
	     *   if (isGreeting(objValue) && isGreeting(srcValue)) {
	     *     return true;
	     *   }
	     * }
	     *
	     * var object = { 'greeting': 'hello' };
	     * var source = { 'greeting': 'hi' };
	     *
	     * _.isMatchWith(object, source, customizer);
	     * // => true
	     */
	    function isMatchWith(object, source, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined;
	      return baseIsMatch(object, source, getMatchData(source), customizer);
	    }
	
	    /**
	     * Checks if `value` is `NaN`.
	     *
	     * **Note:** This method is based on
	     * [`Number.isNaN`](https://mdn.io/Number/isNaN) and is not the same as
	     * global [`isNaN`](https://mdn.io/isNaN) which returns `true` for
	     * `undefined` and other non-number values.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
	     * @example
	     *
	     * _.isNaN(NaN);
	     * // => true
	     *
	     * _.isNaN(new Number(NaN));
	     * // => true
	     *
	     * isNaN(undefined);
	     * // => true
	     *
	     * _.isNaN(undefined);
	     * // => false
	     */
	    function isNaN(value) {
	      // An `NaN` primitive is the only value that is not equal to itself.
	      // Perform the `toStringTag` check first to avoid errors with some
	      // ActiveX objects in IE.
	      return isNumber(value) && value != +value;
	    }
	
	    /**
	     * Checks if `value` is a pristine native function.
	     *
	     * **Note:** This method can't reliably detect native functions in the presence
	     * of the core-js package because core-js circumvents this kind of detection.
	     * Despite multiple requests, the core-js maintainer has made it clear: any
	     * attempt to fix the detection will be obstructed. As a result, we're left
	     * with little choice but to throw an error. Unfortunately, this also affects
	     * packages, like [babel-polyfill](https://www.npmjs.com/package/babel-polyfill),
	     * which rely on core-js.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a native function,
	     *  else `false`.
	     * @example
	     *
	     * _.isNative(Array.prototype.push);
	     * // => true
	     *
	     * _.isNative(_);
	     * // => false
	     */
	    function isNative(value) {
	      if (isMaskable(value)) {
	        throw new Error(CORE_ERROR_TEXT);
	      }
	      return baseIsNative(value);
	    }
	
	    /**
	     * Checks if `value` is `null`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is `null`, else `false`.
	     * @example
	     *
	     * _.isNull(null);
	     * // => true
	     *
	     * _.isNull(void 0);
	     * // => false
	     */
	    function isNull(value) {
	      return value === null;
	    }
	
	    /**
	     * Checks if `value` is `null` or `undefined`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is nullish, else `false`.
	     * @example
	     *
	     * _.isNil(null);
	     * // => true
	     *
	     * _.isNil(void 0);
	     * // => true
	     *
	     * _.isNil(NaN);
	     * // => false
	     */
	    function isNil(value) {
	      return value == null;
	    }
	
	    /**
	     * Checks if `value` is classified as a `Number` primitive or object.
	     *
	     * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are
	     * classified as numbers, use the `_.isFinite` method.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a number, else `false`.
	     * @example
	     *
	     * _.isNumber(3);
	     * // => true
	     *
	     * _.isNumber(Number.MIN_VALUE);
	     * // => true
	     *
	     * _.isNumber(Infinity);
	     * // => true
	     *
	     * _.isNumber('3');
	     * // => false
	     */
	    function isNumber(value) {
	      return typeof value == 'number' ||
	        (isObjectLike(value) && baseGetTag(value) == numberTag);
	    }
	
	    /**
	     * Checks if `value` is a plain object, that is, an object created by the
	     * `Object` constructor or one with a `[[Prototype]]` of `null`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.8.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     * }
	     *
	     * _.isPlainObject(new Foo);
	     * // => false
	     *
	     * _.isPlainObject([1, 2, 3]);
	     * // => false
	     *
	     * _.isPlainObject({ 'x': 0, 'y': 0 });
	     * // => true
	     *
	     * _.isPlainObject(Object.create(null));
	     * // => true
	     */
	    function isPlainObject(value) {
	      if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
	        return false;
	      }
	      var proto = getPrototype(value);
	      if (proto === null) {
	        return true;
	      }
	      var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
	      return typeof Ctor == 'function' && Ctor instanceof Ctor &&
	        funcToString.call(Ctor) == objectCtorString;
	    }
	
	    /**
	     * Checks if `value` is classified as a `RegExp` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.1.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
	     * @example
	     *
	     * _.isRegExp(/abc/);
	     * // => true
	     *
	     * _.isRegExp('/abc/');
	     * // => false
	     */
	    var isRegExp = nodeIsRegExp ? baseUnary(nodeIsRegExp) : baseIsRegExp;
	
	    /**
	     * Checks if `value` is a safe integer. An integer is safe if it's an IEEE-754
	     * double precision number which isn't the result of a rounded unsafe integer.
	     *
	     * **Note:** This method is based on
	     * [`Number.isSafeInteger`](https://mdn.io/Number/isSafeInteger).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a safe integer, else `false`.
	     * @example
	     *
	     * _.isSafeInteger(3);
	     * // => true
	     *
	     * _.isSafeInteger(Number.MIN_VALUE);
	     * // => false
	     *
	     * _.isSafeInteger(Infinity);
	     * // => false
	     *
	     * _.isSafeInteger('3');
	     * // => false
	     */
	    function isSafeInteger(value) {
	      return isInteger(value) && value >= -MAX_SAFE_INTEGER && value <= MAX_SAFE_INTEGER;
	    }
	
	    /**
	     * Checks if `value` is classified as a `Set` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.3.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a set, else `false`.
	     * @example
	     *
	     * _.isSet(new Set);
	     * // => true
	     *
	     * _.isSet(new WeakSet);
	     * // => false
	     */
	    var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
	
	    /**
	     * Checks if `value` is classified as a `String` primitive or object.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a string, else `false`.
	     * @example
	     *
	     * _.isString('abc');
	     * // => true
	     *
	     * _.isString(1);
	     * // => false
	     */
	    function isString(value) {
	      return typeof value == 'string' ||
	        (!isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag);
	    }
	
	    /**
	     * Checks if `value` is classified as a `Symbol` primitive or object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
	     * @example
	     *
	     * _.isSymbol(Symbol.iterator);
	     * // => true
	     *
	     * _.isSymbol('abc');
	     * // => false
	     */
	    function isSymbol(value) {
	      return typeof value == 'symbol' ||
	        (isObjectLike(value) && baseGetTag(value) == symbolTag);
	    }
	
	    /**
	     * Checks if `value` is classified as a typed array.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
	     * @example
	     *
	     * _.isTypedArray(new Uint8Array);
	     * // => true
	     *
	     * _.isTypedArray([]);
	     * // => false
	     */
	    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
	
	    /**
	     * Checks if `value` is `undefined`.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is `undefined`, else `false`.
	     * @example
	     *
	     * _.isUndefined(void 0);
	     * // => true
	     *
	     * _.isUndefined(null);
	     * // => false
	     */
	    function isUndefined(value) {
	      return value === undefined;
	    }
	
	    /**
	     * Checks if `value` is classified as a `WeakMap` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.3.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a weak map, else `false`.
	     * @example
	     *
	     * _.isWeakMap(new WeakMap);
	     * // => true
	     *
	     * _.isWeakMap(new Map);
	     * // => false
	     */
	    function isWeakMap(value) {
	      return isObjectLike(value) && getTag(value) == weakMapTag;
	    }
	
	    /**
	     * Checks if `value` is classified as a `WeakSet` object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.3.0
	     * @category Lang
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a weak set, else `false`.
	     * @example
	     *
	     * _.isWeakSet(new WeakSet);
	     * // => true
	     *
	     * _.isWeakSet(new Set);
	     * // => false
	     */
	    function isWeakSet(value) {
	      return isObjectLike(value) && baseGetTag(value) == weakSetTag;
	    }
	
	    /**
	     * Checks if `value` is less than `other`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.9.0
	     * @category Lang
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if `value` is less than `other`,
	     *  else `false`.
	     * @see _.gt
	     * @example
	     *
	     * _.lt(1, 3);
	     * // => true
	     *
	     * _.lt(3, 3);
	     * // => false
	     *
	     * _.lt(3, 1);
	     * // => false
	     */
	    var lt = createRelationalOperation(baseLt);
	
	    /**
	     * Checks if `value` is less than or equal to `other`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.9.0
	     * @category Lang
	     * @param {*} value The value to compare.
	     * @param {*} other The other value to compare.
	     * @returns {boolean} Returns `true` if `value` is less than or equal to
	     *  `other`, else `false`.
	     * @see _.gte
	     * @example
	     *
	     * _.lte(1, 3);
	     * // => true
	     *
	     * _.lte(3, 3);
	     * // => true
	     *
	     * _.lte(3, 1);
	     * // => false
	     */
	    var lte = createRelationalOperation(function(value, other) {
	      return value <= other;
	    });
	
	    /**
	     * Converts `value` to an array.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Lang
	     * @param {*} value The value to convert.
	     * @returns {Array} Returns the converted array.
	     * @example
	     *
	     * _.toArray({ 'a': 1, 'b': 2 });
	     * // => [1, 2]
	     *
	     * _.toArray('abc');
	     * // => ['a', 'b', 'c']
	     *
	     * _.toArray(1);
	     * // => []
	     *
	     * _.toArray(null);
	     * // => []
	     */
	    function toArray(value) {
	      if (!value) {
	        return [];
	      }
	      if (isArrayLike(value)) {
	        return isString(value) ? stringToArray(value) : copyArray(value);
	      }
	      if (symIterator && value[symIterator]) {
	        return iteratorToArray(value[symIterator]());
	      }
	      var tag = getTag(value),
	          func = tag == mapTag ? mapToArray : (tag == setTag ? setToArray : values);
	
	      return func(value);
	    }
	
	    /**
	     * Converts `value` to a finite number.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.12.0
	     * @category Lang
	     * @param {*} value The value to convert.
	     * @returns {number} Returns the converted number.
	     * @example
	     *
	     * _.toFinite(3.2);
	     * // => 3.2
	     *
	     * _.toFinite(Number.MIN_VALUE);
	     * // => 5e-324
	     *
	     * _.toFinite(Infinity);
	     * // => 1.7976931348623157e+308
	     *
	     * _.toFinite('3.2');
	     * // => 3.2
	     */
	    function toFinite(value) {
	      if (!value) {
	        return value === 0 ? value : 0;
	      }
	      value = toNumber(value);
	      if (value === INFINITY || value === -INFINITY) {
	        var sign = (value < 0 ? -1 : 1);
	        return sign * MAX_INTEGER;
	      }
	      return value === value ? value : 0;
	    }
	
	    /**
	     * Converts `value` to an integer.
	     *
	     * **Note:** This method is loosely based on
	     * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to convert.
	     * @returns {number} Returns the converted integer.
	     * @example
	     *
	     * _.toInteger(3.2);
	     * // => 3
	     *
	     * _.toInteger(Number.MIN_VALUE);
	     * // => 0
	     *
	     * _.toInteger(Infinity);
	     * // => 1.7976931348623157e+308
	     *
	     * _.toInteger('3.2');
	     * // => 3
	     */
	    function toInteger(value) {
	      var result = toFinite(value),
	          remainder = result % 1;
	
	      return result === result ? (remainder ? result - remainder : result) : 0;
	    }
	
	    /**
	     * Converts `value` to an integer suitable for use as the length of an
	     * array-like object.
	     *
	     * **Note:** This method is based on
	     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to convert.
	     * @returns {number} Returns the converted integer.
	     * @example
	     *
	     * _.toLength(3.2);
	     * // => 3
	     *
	     * _.toLength(Number.MIN_VALUE);
	     * // => 0
	     *
	     * _.toLength(Infinity);
	     * // => 4294967295
	     *
	     * _.toLength('3.2');
	     * // => 3
	     */
	    function toLength(value) {
	      return value ? baseClamp(toInteger(value), 0, MAX_ARRAY_LENGTH) : 0;
	    }
	
	    /**
	     * Converts `value` to a number.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to process.
	     * @returns {number} Returns the number.
	     * @example
	     *
	     * _.toNumber(3.2);
	     * // => 3.2
	     *
	     * _.toNumber(Number.MIN_VALUE);
	     * // => 5e-324
	     *
	     * _.toNumber(Infinity);
	     * // => Infinity
	     *
	     * _.toNumber('3.2');
	     * // => 3.2
	     */
	    function toNumber(value) {
	      if (typeof value == 'number') {
	        return value;
	      }
	      if (isSymbol(value)) {
	        return NAN;
	      }
	      if (isObject(value)) {
	        var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
	        value = isObject(other) ? (other + '') : other;
	      }
	      if (typeof value != 'string') {
	        return value === 0 ? value : +value;
	      }
	      value = value.replace(reTrim, '');
	      var isBinary = reIsBinary.test(value);
	      return (isBinary || reIsOctal.test(value))
	        ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
	        : (reIsBadHex.test(value) ? NAN : +value);
	    }
	
	    /**
	     * Converts `value` to a plain object flattening inherited enumerable string
	     * keyed properties of `value` to own properties of the plain object.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Lang
	     * @param {*} value The value to convert.
	     * @returns {Object} Returns the converted plain object.
	     * @example
	     *
	     * function Foo() {
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.assign({ 'a': 1 }, new Foo);
	     * // => { 'a': 1, 'b': 2 }
	     *
	     * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
	     * // => { 'a': 1, 'b': 2, 'c': 3 }
	     */
	    function toPlainObject(value) {
	      return copyObject(value, keysIn(value));
	    }
	
	    /**
	     * Converts `value` to a safe integer. A safe integer can be compared and
	     * represented correctly.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to convert.
	     * @returns {number} Returns the converted integer.
	     * @example
	     *
	     * _.toSafeInteger(3.2);
	     * // => 3
	     *
	     * _.toSafeInteger(Number.MIN_VALUE);
	     * // => 0
	     *
	     * _.toSafeInteger(Infinity);
	     * // => 9007199254740991
	     *
	     * _.toSafeInteger('3.2');
	     * // => 3
	     */
	    function toSafeInteger(value) {
	      return value
	        ? baseClamp(toInteger(value), -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER)
	        : (value === 0 ? value : 0);
	    }
	
	    /**
	     * Converts `value` to a string. An empty string is returned for `null`
	     * and `undefined` values. The sign of `-0` is preserved.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Lang
	     * @param {*} value The value to convert.
	     * @returns {string} Returns the converted string.
	     * @example
	     *
	     * _.toString(null);
	     * // => ''
	     *
	     * _.toString(-0);
	     * // => '-0'
	     *
	     * _.toString([1, 2, 3]);
	     * // => '1,2,3'
	     */
	    function toString(value) {
	      return value == null ? '' : baseToString(value);
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Assigns own enumerable string keyed properties of source objects to the
	     * destination object. Source objects are applied from left to right.
	     * Subsequent sources overwrite property assignments of previous sources.
	     *
	     * **Note:** This method mutates `object` and is loosely based on
	     * [`Object.assign`](https://mdn.io/Object/assign).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.10.0
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} [sources] The source objects.
	     * @returns {Object} Returns `object`.
	     * @see _.assignIn
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     * }
	     *
	     * function Bar() {
	     *   this.c = 3;
	     * }
	     *
	     * Foo.prototype.b = 2;
	     * Bar.prototype.d = 4;
	     *
	     * _.assign({ 'a': 0 }, new Foo, new Bar);
	     * // => { 'a': 1, 'c': 3 }
	     */
	    var assign = createAssigner(function(object, source) {
	      if (isPrototype(source) || isArrayLike(source)) {
	        copyObject(source, keys(source), object);
	        return;
	      }
	      for (var key in source) {
	        if (hasOwnProperty.call(source, key)) {
	          assignValue(object, key, source[key]);
	        }
	      }
	    });
	
	    /**
	     * This method is like `_.assign` except that it iterates over own and
	     * inherited source properties.
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @alias extend
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} [sources] The source objects.
	     * @returns {Object} Returns `object`.
	     * @see _.assign
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     * }
	     *
	     * function Bar() {
	     *   this.c = 3;
	     * }
	     *
	     * Foo.prototype.b = 2;
	     * Bar.prototype.d = 4;
	     *
	     * _.assignIn({ 'a': 0 }, new Foo, new Bar);
	     * // => { 'a': 1, 'b': 2, 'c': 3, 'd': 4 }
	     */
	    var assignIn = createAssigner(function(object, source) {
	      copyObject(source, keysIn(source), object);
	    });
	
	    /**
	     * This method is like `_.assignIn` except that it accepts `customizer`
	     * which is invoked to produce the assigned values. If `customizer` returns
	     * `undefined`, assignment is handled by the method instead. The `customizer`
	     * is invoked with five arguments: (objValue, srcValue, key, object, source).
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @alias extendWith
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} sources The source objects.
	     * @param {Function} [customizer] The function to customize assigned values.
	     * @returns {Object} Returns `object`.
	     * @see _.assignWith
	     * @example
	     *
	     * function customizer(objValue, srcValue) {
	     *   return _.isUndefined(objValue) ? srcValue : objValue;
	     * }
	     *
	     * var defaults = _.partialRight(_.assignInWith, customizer);
	     *
	     * defaults({ 'a': 1 }, { 'b': 2 }, { 'a': 3 });
	     * // => { 'a': 1, 'b': 2 }
	     */
	    var assignInWith = createAssigner(function(object, source, srcIndex, customizer) {
	      copyObject(source, keysIn(source), object, customizer);
	    });
	
	    /**
	     * This method is like `_.assign` except that it accepts `customizer`
	     * which is invoked to produce the assigned values. If `customizer` returns
	     * `undefined`, assignment is handled by the method instead. The `customizer`
	     * is invoked with five arguments: (objValue, srcValue, key, object, source).
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} sources The source objects.
	     * @param {Function} [customizer] The function to customize assigned values.
	     * @returns {Object} Returns `object`.
	     * @see _.assignInWith
	     * @example
	     *
	     * function customizer(objValue, srcValue) {
	     *   return _.isUndefined(objValue) ? srcValue : objValue;
	     * }
	     *
	     * var defaults = _.partialRight(_.assignWith, customizer);
	     *
	     * defaults({ 'a': 1 }, { 'b': 2 }, { 'a': 3 });
	     * // => { 'a': 1, 'b': 2 }
	     */
	    var assignWith = createAssigner(function(object, source, srcIndex, customizer) {
	      copyObject(source, keys(source), object, customizer);
	    });
	
	    /**
	     * Creates an array of values corresponding to `paths` of `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.0.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {...(string|string[])} [paths] The property paths to pick.
	     * @returns {Array} Returns the picked values.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c': 3 } }, 4] };
	     *
	     * _.at(object, ['a[0].b.c', 'a[1]']);
	     * // => [3, 4]
	     */
	    var at = flatRest(baseAt);
	
	    /**
	     * Creates an object that inherits from the `prototype` object. If a
	     * `properties` object is given, its own enumerable string keyed properties
	     * are assigned to the created object.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.3.0
	     * @category Object
	     * @param {Object} prototype The object to inherit from.
	     * @param {Object} [properties] The properties to assign to the object.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * function Shape() {
	     *   this.x = 0;
	     *   this.y = 0;
	     * }
	     *
	     * function Circle() {
	     *   Shape.call(this);
	     * }
	     *
	     * Circle.prototype = _.create(Shape.prototype, {
	     *   'constructor': Circle
	     * });
	     *
	     * var circle = new Circle;
	     * circle instanceof Circle;
	     * // => true
	     *
	     * circle instanceof Shape;
	     * // => true
	     */
	    function create(prototype, properties) {
	      var result = baseCreate(prototype);
	      return properties == null ? result : baseAssign(result, properties);
	    }
	
	    /**
	     * Assigns own and inherited enumerable string keyed properties of source
	     * objects to the destination object for all destination properties that
	     * resolve to `undefined`. Source objects are applied from left to right.
	     * Once a property is set, additional values of the same property are ignored.
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} [sources] The source objects.
	     * @returns {Object} Returns `object`.
	     * @see _.defaultsDeep
	     * @example
	     *
	     * _.defaults({ 'a': 1 }, { 'b': 2 }, { 'a': 3 });
	     * // => { 'a': 1, 'b': 2 }
	     */
	    var defaults = baseRest(function(args) {
	      args.push(undefined, customDefaultsAssignIn);
	      return apply(assignInWith, undefined, args);
	    });
	
	    /**
	     * This method is like `_.defaults` except that it recursively assigns
	     * default properties.
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.10.0
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} [sources] The source objects.
	     * @returns {Object} Returns `object`.
	     * @see _.defaults
	     * @example
	     *
	     * _.defaultsDeep({ 'a': { 'b': 2 } }, { 'a': { 'b': 1, 'c': 3 } });
	     * // => { 'a': { 'b': 2, 'c': 3 } }
	     */
	    var defaultsDeep = baseRest(function(args) {
	      args.push(undefined, customDefaultsMerge);
	      return apply(mergeWith, undefined, args);
	    });
	
	    /**
	     * This method is like `_.find` except that it returns the key of the first
	     * element `predicate` returns truthy for instead of the element itself.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.1.0
	     * @category Object
	     * @param {Object} object The object to inspect.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {string|undefined} Returns the key of the matched element,
	     *  else `undefined`.
	     * @example
	     *
	     * var users = {
	     *   'barney':  { 'age': 36, 'active': true },
	     *   'fred':    { 'age': 40, 'active': false },
	     *   'pebbles': { 'age': 1,  'active': true }
	     * };
	     *
	     * _.findKey(users, function(o) { return o.age < 40; });
	     * // => 'barney' (iteration order is not guaranteed)
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.findKey(users, { 'age': 1, 'active': true });
	     * // => 'pebbles'
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.findKey(users, ['active', false]);
	     * // => 'fred'
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.findKey(users, 'active');
	     * // => 'barney'
	     */
	    function findKey(object, predicate) {
	      return baseFindKey(object, getIteratee(predicate, 3), baseForOwn);
	    }
	
	    /**
	     * This method is like `_.findKey` except that it iterates over elements of
	     * a collection in the opposite order.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Object
	     * @param {Object} object The object to inspect.
	     * @param {Function} [predicate=_.identity] The function invoked per iteration.
	     * @returns {string|undefined} Returns the key of the matched element,
	     *  else `undefined`.
	     * @example
	     *
	     * var users = {
	     *   'barney':  { 'age': 36, 'active': true },
	     *   'fred':    { 'age': 40, 'active': false },
	     *   'pebbles': { 'age': 1,  'active': true }
	     * };
	     *
	     * _.findLastKey(users, function(o) { return o.age < 40; });
	     * // => returns 'pebbles' assuming `_.findKey` returns 'barney'
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.findLastKey(users, { 'age': 36, 'active': true });
	     * // => 'barney'
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.findLastKey(users, ['active', false]);
	     * // => 'fred'
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.findLastKey(users, 'active');
	     * // => 'pebbles'
	     */
	    function findLastKey(object, predicate) {
	      return baseFindKey(object, getIteratee(predicate, 3), baseForOwnRight);
	    }
	
	    /**
	     * Iterates over own and inherited enumerable string keyed properties of an
	     * object and invokes `iteratee` for each property. The iteratee is invoked
	     * with three arguments: (value, key, object). Iteratee functions may exit
	     * iteration early by explicitly returning `false`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.3.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Object} Returns `object`.
	     * @see _.forInRight
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.forIn(new Foo, function(value, key) {
	     *   console.log(key);
	     * });
	     * // => Logs 'a', 'b', then 'c' (iteration order is not guaranteed).
	     */
	    function forIn(object, iteratee) {
	      return object == null
	        ? object
	        : baseFor(object, getIteratee(iteratee, 3), keysIn);
	    }
	
	    /**
	     * This method is like `_.forIn` except that it iterates over properties of
	     * `object` in the opposite order.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Object} Returns `object`.
	     * @see _.forIn
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.forInRight(new Foo, function(value, key) {
	     *   console.log(key);
	     * });
	     * // => Logs 'c', 'b', then 'a' assuming `_.forIn` logs 'a', 'b', then 'c'.
	     */
	    function forInRight(object, iteratee) {
	      return object == null
	        ? object
	        : baseForRight(object, getIteratee(iteratee, 3), keysIn);
	    }
	
	    /**
	     * Iterates over own enumerable string keyed properties of an object and
	     * invokes `iteratee` for each property. The iteratee is invoked with three
	     * arguments: (value, key, object). Iteratee functions may exit iteration
	     * early by explicitly returning `false`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.3.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Object} Returns `object`.
	     * @see _.forOwnRight
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.forOwn(new Foo, function(value, key) {
	     *   console.log(key);
	     * });
	     * // => Logs 'a' then 'b' (iteration order is not guaranteed).
	     */
	    function forOwn(object, iteratee) {
	      return object && baseForOwn(object, getIteratee(iteratee, 3));
	    }
	
	    /**
	     * This method is like `_.forOwn` except that it iterates over properties of
	     * `object` in the opposite order.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.0.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Object} Returns `object`.
	     * @see _.forOwn
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.forOwnRight(new Foo, function(value, key) {
	     *   console.log(key);
	     * });
	     * // => Logs 'b' then 'a' assuming `_.forOwn` logs 'a' then 'b'.
	     */
	    function forOwnRight(object, iteratee) {
	      return object && baseForOwnRight(object, getIteratee(iteratee, 3));
	    }
	
	    /**
	     * Creates an array of function property names from own enumerable properties
	     * of `object`.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The object to inspect.
	     * @returns {Array} Returns the function names.
	     * @see _.functionsIn
	     * @example
	     *
	     * function Foo() {
	     *   this.a = _.constant('a');
	     *   this.b = _.constant('b');
	     * }
	     *
	     * Foo.prototype.c = _.constant('c');
	     *
	     * _.functions(new Foo);
	     * // => ['a', 'b']
	     */
	    function functions(object) {
	      return object == null ? [] : baseFunctions(object, keys(object));
	    }
	
	    /**
	     * Creates an array of function property names from own and inherited
	     * enumerable properties of `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The object to inspect.
	     * @returns {Array} Returns the function names.
	     * @see _.functions
	     * @example
	     *
	     * function Foo() {
	     *   this.a = _.constant('a');
	     *   this.b = _.constant('b');
	     * }
	     *
	     * Foo.prototype.c = _.constant('c');
	     *
	     * _.functionsIn(new Foo);
	     * // => ['a', 'b', 'c']
	     */
	    function functionsIn(object) {
	      return object == null ? [] : baseFunctions(object, keysIn(object));
	    }
	
	    /**
	     * Gets the value at `path` of `object`. If the resolved value is
	     * `undefined`, the `defaultValue` is returned in its place.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.7.0
	     * @category Object
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path of the property to get.
	     * @param {*} [defaultValue] The value returned for `undefined` resolved values.
	     * @returns {*} Returns the resolved value.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
	     *
	     * _.get(object, 'a[0].b.c');
	     * // => 3
	     *
	     * _.get(object, ['a', '0', 'b', 'c']);
	     * // => 3
	     *
	     * _.get(object, 'a.b.c', 'default');
	     * // => 'default'
	     */
	    function get(object, path, defaultValue) {
	      var result = object == null ? undefined : baseGet(object, path);
	      return result === undefined ? defaultValue : result;
	    }
	
	    /**
	     * Checks if `path` is a direct property of `object`.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path to check.
	     * @returns {boolean} Returns `true` if `path` exists, else `false`.
	     * @example
	     *
	     * var object = { 'a': { 'b': 2 } };
	     * var other = _.create({ 'a': _.create({ 'b': 2 }) });
	     *
	     * _.has(object, 'a');
	     * // => true
	     *
	     * _.has(object, 'a.b');
	     * // => true
	     *
	     * _.has(object, ['a', 'b']);
	     * // => true
	     *
	     * _.has(other, 'a');
	     * // => false
	     */
	    function has(object, path) {
	      return object != null && hasPath(object, path, baseHas);
	    }
	
	    /**
	     * Checks if `path` is a direct or inherited property of `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path to check.
	     * @returns {boolean} Returns `true` if `path` exists, else `false`.
	     * @example
	     *
	     * var object = _.create({ 'a': _.create({ 'b': 2 }) });
	     *
	     * _.hasIn(object, 'a');
	     * // => true
	     *
	     * _.hasIn(object, 'a.b');
	     * // => true
	     *
	     * _.hasIn(object, ['a', 'b']);
	     * // => true
	     *
	     * _.hasIn(object, 'b');
	     * // => false
	     */
	    function hasIn(object, path) {
	      return object != null && hasPath(object, path, baseHasIn);
	    }
	
	    /**
	     * Creates an object composed of the inverted keys and values of `object`.
	     * If `object` contains duplicate values, subsequent values overwrite
	     * property assignments of previous values.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.7.0
	     * @category Object
	     * @param {Object} object The object to invert.
	     * @returns {Object} Returns the new inverted object.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': 2, 'c': 1 };
	     *
	     * _.invert(object);
	     * // => { '1': 'c', '2': 'b' }
	     */
	    var invert = createInverter(function(result, value, key) {
	      result[value] = key;
	    }, constant(identity));
	
	    /**
	     * This method is like `_.invert` except that the inverted object is generated
	     * from the results of running each element of `object` thru `iteratee`. The
	     * corresponding inverted value of each inverted key is an array of keys
	     * responsible for generating the inverted value. The iteratee is invoked
	     * with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.1.0
	     * @category Object
	     * @param {Object} object The object to invert.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {Object} Returns the new inverted object.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': 2, 'c': 1 };
	     *
	     * _.invertBy(object);
	     * // => { '1': ['a', 'c'], '2': ['b'] }
	     *
	     * _.invertBy(object, function(value) {
	     *   return 'group' + value;
	     * });
	     * // => { 'group1': ['a', 'c'], 'group2': ['b'] }
	     */
	    var invertBy = createInverter(function(result, value, key) {
	      if (hasOwnProperty.call(result, value)) {
	        result[value].push(key);
	      } else {
	        result[value] = [key];
	      }
	    }, getIteratee);
	
	    /**
	     * Invokes the method at `path` of `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path of the method to invoke.
	     * @param {...*} [args] The arguments to invoke the method with.
	     * @returns {*} Returns the result of the invoked method.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c': [1, 2, 3, 4] } }] };
	     *
	     * _.invoke(object, 'a[0].b.c.slice', 1, 3);
	     * // => [2, 3]
	     */
	    var invoke = baseRest(baseInvoke);
	
	    /**
	     * Creates an array of the own enumerable property names of `object`.
	     *
	     * **Note:** Non-object values are coerced to objects. See the
	     * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
	     * for more details.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property names.
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.keys(new Foo);
	     * // => ['a', 'b'] (iteration order is not guaranteed)
	     *
	     * _.keys('hi');
	     * // => ['0', '1']
	     */
	    function keys(object) {
	      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
	    }
	
	    /**
	     * Creates an array of the own and inherited enumerable property names of `object`.
	     *
	     * **Note:** Non-object values are coerced to objects.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Object
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property names.
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.keysIn(new Foo);
	     * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
	     */
	    function keysIn(object) {
	      return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
	    }
	
	    /**
	     * The opposite of `_.mapValues`; this method creates an object with the
	     * same values as `object` and keys generated by running each own enumerable
	     * string keyed property of `object` thru `iteratee`. The iteratee is invoked
	     * with three arguments: (value, key, object).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.8.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Object} Returns the new mapped object.
	     * @see _.mapValues
	     * @example
	     *
	     * _.mapKeys({ 'a': 1, 'b': 2 }, function(value, key) {
	     *   return key + value;
	     * });
	     * // => { 'a1': 1, 'b2': 2 }
	     */
	    function mapKeys(object, iteratee) {
	      var result = {};
	      iteratee = getIteratee(iteratee, 3);
	
	      baseForOwn(object, function(value, key, object) {
	        baseAssignValue(result, iteratee(value, key, object), value);
	      });
	      return result;
	    }
	
	    /**
	     * Creates an object with the same keys as `object` and values generated
	     * by running each own enumerable string keyed property of `object` thru
	     * `iteratee`. The iteratee is invoked with three arguments:
	     * (value, key, object).
	     *
	     * @static
	     * @memberOf _
	     * @since 2.4.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Object} Returns the new mapped object.
	     * @see _.mapKeys
	     * @example
	     *
	     * var users = {
	     *   'fred':    { 'user': 'fred',    'age': 40 },
	     *   'pebbles': { 'user': 'pebbles', 'age': 1 }
	     * };
	     *
	     * _.mapValues(users, function(o) { return o.age; });
	     * // => { 'fred': 40, 'pebbles': 1 } (iteration order is not guaranteed)
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.mapValues(users, 'age');
	     * // => { 'fred': 40, 'pebbles': 1 } (iteration order is not guaranteed)
	     */
	    function mapValues(object, iteratee) {
	      var result = {};
	      iteratee = getIteratee(iteratee, 3);
	
	      baseForOwn(object, function(value, key, object) {
	        baseAssignValue(result, key, iteratee(value, key, object));
	      });
	      return result;
	    }
	
	    /**
	     * This method is like `_.assign` except that it recursively merges own and
	     * inherited enumerable string keyed properties of source objects into the
	     * destination object. Source properties that resolve to `undefined` are
	     * skipped if a destination value exists. Array and plain object properties
	     * are merged recursively. Other objects and value types are overridden by
	     * assignment. Source objects are applied from left to right. Subsequent
	     * sources overwrite property assignments of previous sources.
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.5.0
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} [sources] The source objects.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * var object = {
	     *   'a': [{ 'b': 2 }, { 'd': 4 }]
	     * };
	     *
	     * var other = {
	     *   'a': [{ 'c': 3 }, { 'e': 5 }]
	     * };
	     *
	     * _.merge(object, other);
	     * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
	     */
	    var merge = createAssigner(function(object, source, srcIndex) {
	      baseMerge(object, source, srcIndex);
	    });
	
	    /**
	     * This method is like `_.merge` except that it accepts `customizer` which
	     * is invoked to produce the merged values of the destination and source
	     * properties. If `customizer` returns `undefined`, merging is handled by the
	     * method instead. The `customizer` is invoked with six arguments:
	     * (objValue, srcValue, key, object, source, stack).
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The destination object.
	     * @param {...Object} sources The source objects.
	     * @param {Function} customizer The function to customize assigned values.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * function customizer(objValue, srcValue) {
	     *   if (_.isArray(objValue)) {
	     *     return objValue.concat(srcValue);
	     *   }
	     * }
	     *
	     * var object = { 'a': [1], 'b': [2] };
	     * var other = { 'a': [3], 'b': [4] };
	     *
	     * _.mergeWith(object, other, customizer);
	     * // => { 'a': [1, 3], 'b': [2, 4] }
	     */
	    var mergeWith = createAssigner(function(object, source, srcIndex, customizer) {
	      baseMerge(object, source, srcIndex, customizer);
	    });
	
	    /**
	     * The opposite of `_.pick`; this method creates an object composed of the
	     * own and inherited enumerable property paths of `object` that are not omitted.
	     *
	     * **Note:** This method is considerably slower than `_.pick`.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The source object.
	     * @param {...(string|string[])} [paths] The property paths to omit.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': '2', 'c': 3 };
	     *
	     * _.omit(object, ['a', 'c']);
	     * // => { 'b': '2' }
	     */
	    var omit = flatRest(function(object, paths) {
	      var result = {};
	      if (object == null) {
	        return result;
	      }
	      var isDeep = false;
	      paths = arrayMap(paths, function(path) {
	        path = castPath(path, object);
	        isDeep || (isDeep = path.length > 1);
	        return path;
	      });
	      copyObject(object, getAllKeysIn(object), result);
	      if (isDeep) {
	        result = baseClone(result, CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG, customOmitClone);
	      }
	      var length = paths.length;
	      while (length--) {
	        baseUnset(result, paths[length]);
	      }
	      return result;
	    });
	
	    /**
	     * The opposite of `_.pickBy`; this method creates an object composed of
	     * the own and inherited enumerable string keyed properties of `object` that
	     * `predicate` doesn't return truthy for. The predicate is invoked with two
	     * arguments: (value, key).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The source object.
	     * @param {Function} [predicate=_.identity] The function invoked per property.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': '2', 'c': 3 };
	     *
	     * _.omitBy(object, _.isNumber);
	     * // => { 'b': '2' }
	     */
	    function omitBy(object, predicate) {
	      return pickBy(object, negate(getIteratee(predicate)));
	    }
	
	    /**
	     * Creates an object composed of the picked `object` properties.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The source object.
	     * @param {...(string|string[])} [paths] The property paths to pick.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': '2', 'c': 3 };
	     *
	     * _.pick(object, ['a', 'c']);
	     * // => { 'a': 1, 'c': 3 }
	     */
	    var pick = flatRest(function(object, paths) {
	      return object == null ? {} : basePick(object, paths);
	    });
	
	    /**
	     * Creates an object composed of the `object` properties `predicate` returns
	     * truthy for. The predicate is invoked with two arguments: (value, key).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The source object.
	     * @param {Function} [predicate=_.identity] The function invoked per property.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * var object = { 'a': 1, 'b': '2', 'c': 3 };
	     *
	     * _.pickBy(object, _.isNumber);
	     * // => { 'a': 1, 'c': 3 }
	     */
	    function pickBy(object, predicate) {
	      if (object == null) {
	        return {};
	      }
	      var props = arrayMap(getAllKeysIn(object), function(prop) {
	        return [prop];
	      });
	      predicate = getIteratee(predicate);
	      return basePickBy(object, props, function(value, path) {
	        return predicate(value, path[0]);
	      });
	    }
	
	    /**
	     * This method is like `_.get` except that if the resolved value is a
	     * function it's invoked with the `this` binding of its parent object and
	     * its result is returned.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The object to query.
	     * @param {Array|string} path The path of the property to resolve.
	     * @param {*} [defaultValue] The value returned for `undefined` resolved values.
	     * @returns {*} Returns the resolved value.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c1': 3, 'c2': _.constant(4) } }] };
	     *
	     * _.result(object, 'a[0].b.c1');
	     * // => 3
	     *
	     * _.result(object, 'a[0].b.c2');
	     * // => 4
	     *
	     * _.result(object, 'a[0].b.c3', 'default');
	     * // => 'default'
	     *
	     * _.result(object, 'a[0].b.c3', _.constant('default'));
	     * // => 'default'
	     */
	    function result(object, path, defaultValue) {
	      path = castPath(path, object);
	
	      var index = -1,
	          length = path.length;
	
	      // Ensure the loop is entered when path is empty.
	      if (!length) {
	        length = 1;
	        object = undefined;
	      }
	      while (++index < length) {
	        var value = object == null ? undefined : object[toKey(path[index])];
	        if (value === undefined) {
	          index = length;
	          value = defaultValue;
	        }
	        object = isFunction(value) ? value.call(object) : value;
	      }
	      return object;
	    }
	
	    /**
	     * Sets the value at `path` of `object`. If a portion of `path` doesn't exist,
	     * it's created. Arrays are created for missing index properties while objects
	     * are created for all other missing properties. Use `_.setWith` to customize
	     * `path` creation.
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.7.0
	     * @category Object
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The path of the property to set.
	     * @param {*} value The value to set.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
	     *
	     * _.set(object, 'a[0].b.c', 4);
	     * console.log(object.a[0].b.c);
	     * // => 4
	     *
	     * _.set(object, ['x', '0', 'y', 'z'], 5);
	     * console.log(object.x[0].y.z);
	     * // => 5
	     */
	    function set(object, path, value) {
	      return object == null ? object : baseSet(object, path, value);
	    }
	
	    /**
	     * This method is like `_.set` except that it accepts `customizer` which is
	     * invoked to produce the objects of `path`.  If `customizer` returns `undefined`
	     * path creation is handled by the method instead. The `customizer` is invoked
	     * with three arguments: (nsValue, key, nsObject).
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The path of the property to set.
	     * @param {*} value The value to set.
	     * @param {Function} [customizer] The function to customize assigned values.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * var object = {};
	     *
	     * _.setWith(object, '[0][1]', 'a', Object);
	     * // => { '0': { '1': 'a' } }
	     */
	    function setWith(object, path, value, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined;
	      return object == null ? object : baseSet(object, path, value, customizer);
	    }
	
	    /**
	     * Creates an array of own enumerable string keyed-value pairs for `object`
	     * which can be consumed by `_.fromPairs`. If `object` is a map or set, its
	     * entries are returned.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @alias entries
	     * @category Object
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the key-value pairs.
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.toPairs(new Foo);
	     * // => [['a', 1], ['b', 2]] (iteration order is not guaranteed)
	     */
	    var toPairs = createToPairs(keys);
	
	    /**
	     * Creates an array of own and inherited enumerable string keyed-value pairs
	     * for `object` which can be consumed by `_.fromPairs`. If `object` is a map
	     * or set, its entries are returned.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @alias entriesIn
	     * @category Object
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the key-value pairs.
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.toPairsIn(new Foo);
	     * // => [['a', 1], ['b', 2], ['c', 3]] (iteration order is not guaranteed)
	     */
	    var toPairsIn = createToPairs(keysIn);
	
	    /**
	     * An alternative to `_.reduce`; this method transforms `object` to a new
	     * `accumulator` object which is the result of running each of its own
	     * enumerable string keyed properties thru `iteratee`, with each invocation
	     * potentially mutating the `accumulator` object. If `accumulator` is not
	     * provided, a new object with the same `[[Prototype]]` will be used. The
	     * iteratee is invoked with four arguments: (accumulator, value, key, object).
	     * Iteratee functions may exit iteration early by explicitly returning `false`.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.3.0
	     * @category Object
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @param {*} [accumulator] The custom accumulator value.
	     * @returns {*} Returns the accumulated value.
	     * @example
	     *
	     * _.transform([2, 3, 4], function(result, n) {
	     *   result.push(n *= n);
	     *   return n % 2 == 0;
	     * }, []);
	     * // => [4, 9]
	     *
	     * _.transform({ 'a': 1, 'b': 2, 'c': 1 }, function(result, value, key) {
	     *   (result[value] || (result[value] = [])).push(key);
	     * }, {});
	     * // => { '1': ['a', 'c'], '2': ['b'] }
	     */
	    function transform(object, iteratee, accumulator) {
	      var isArr = isArray(object),
	          isArrLike = isArr || isBuffer(object) || isTypedArray(object);
	
	      iteratee = getIteratee(iteratee, 4);
	      if (accumulator == null) {
	        var Ctor = object && object.constructor;
	        if (isArrLike) {
	          accumulator = isArr ? new Ctor : [];
	        }
	        else if (isObject(object)) {
	          accumulator = isFunction(Ctor) ? baseCreate(getPrototype(object)) : {};
	        }
	        else {
	          accumulator = {};
	        }
	      }
	      (isArrLike ? arrayEach : baseForOwn)(object, function(value, index, object) {
	        return iteratee(accumulator, value, index, object);
	      });
	      return accumulator;
	    }
	
	    /**
	     * Removes the property at `path` of `object`.
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Object
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The path of the property to unset.
	     * @returns {boolean} Returns `true` if the property is deleted, else `false`.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c': 7 } }] };
	     * _.unset(object, 'a[0].b.c');
	     * // => true
	     *
	     * console.log(object);
	     * // => { 'a': [{ 'b': {} }] };
	     *
	     * _.unset(object, ['a', '0', 'b', 'c']);
	     * // => true
	     *
	     * console.log(object);
	     * // => { 'a': [{ 'b': {} }] };
	     */
	    function unset(object, path) {
	      return object == null ? true : baseUnset(object, path);
	    }
	
	    /**
	     * This method is like `_.set` except that accepts `updater` to produce the
	     * value to set. Use `_.updateWith` to customize `path` creation. The `updater`
	     * is invoked with one argument: (value).
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.6.0
	     * @category Object
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The path of the property to set.
	     * @param {Function} updater The function to produce the updated value.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
	     *
	     * _.update(object, 'a[0].b.c', function(n) { return n * n; });
	     * console.log(object.a[0].b.c);
	     * // => 9
	     *
	     * _.update(object, 'x[0].y.z', function(n) { return n ? n + 1 : 0; });
	     * console.log(object.x[0].y.z);
	     * // => 0
	     */
	    function update(object, path, updater) {
	      return object == null ? object : baseUpdate(object, path, castFunction(updater));
	    }
	
	    /**
	     * This method is like `_.update` except that it accepts `customizer` which is
	     * invoked to produce the objects of `path`.  If `customizer` returns `undefined`
	     * path creation is handled by the method instead. The `customizer` is invoked
	     * with three arguments: (nsValue, key, nsObject).
	     *
	     * **Note:** This method mutates `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.6.0
	     * @category Object
	     * @param {Object} object The object to modify.
	     * @param {Array|string} path The path of the property to set.
	     * @param {Function} updater The function to produce the updated value.
	     * @param {Function} [customizer] The function to customize assigned values.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * var object = {};
	     *
	     * _.updateWith(object, '[0][1]', _.constant('a'), Object);
	     * // => { '0': { '1': 'a' } }
	     */
	    function updateWith(object, path, updater, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined;
	      return object == null ? object : baseUpdate(object, path, castFunction(updater), customizer);
	    }
	
	    /**
	     * Creates an array of the own enumerable string keyed property values of `object`.
	     *
	     * **Note:** Non-object values are coerced to objects.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Object
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property values.
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.values(new Foo);
	     * // => [1, 2] (iteration order is not guaranteed)
	     *
	     * _.values('hi');
	     * // => ['h', 'i']
	     */
	    function values(object) {
	      return object == null ? [] : baseValues(object, keys(object));
	    }
	
	    /**
	     * Creates an array of the own and inherited enumerable string keyed property
	     * values of `object`.
	     *
	     * **Note:** Non-object values are coerced to objects.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Object
	     * @param {Object} object The object to query.
	     * @returns {Array} Returns the array of property values.
	     * @example
	     *
	     * function Foo() {
	     *   this.a = 1;
	     *   this.b = 2;
	     * }
	     *
	     * Foo.prototype.c = 3;
	     *
	     * _.valuesIn(new Foo);
	     * // => [1, 2, 3] (iteration order is not guaranteed)
	     */
	    function valuesIn(object) {
	      return object == null ? [] : baseValues(object, keysIn(object));
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Clamps `number` within the inclusive `lower` and `upper` bounds.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Number
	     * @param {number} number The number to clamp.
	     * @param {number} [lower] The lower bound.
	     * @param {number} upper The upper bound.
	     * @returns {number} Returns the clamped number.
	     * @example
	     *
	     * _.clamp(-10, -5, 5);
	     * // => -5
	     *
	     * _.clamp(10, -5, 5);
	     * // => 5
	     */
	    function clamp(number, lower, upper) {
	      if (upper === undefined) {
	        upper = lower;
	        lower = undefined;
	      }
	      if (upper !== undefined) {
	        upper = toNumber(upper);
	        upper = upper === upper ? upper : 0;
	      }
	      if (lower !== undefined) {
	        lower = toNumber(lower);
	        lower = lower === lower ? lower : 0;
	      }
	      return baseClamp(toNumber(number), lower, upper);
	    }
	
	    /**
	     * Checks if `n` is between `start` and up to, but not including, `end`. If
	     * `end` is not specified, it's set to `start` with `start` then set to `0`.
	     * If `start` is greater than `end` the params are swapped to support
	     * negative ranges.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.3.0
	     * @category Number
	     * @param {number} number The number to check.
	     * @param {number} [start=0] The start of the range.
	     * @param {number} end The end of the range.
	     * @returns {boolean} Returns `true` if `number` is in the range, else `false`.
	     * @see _.range, _.rangeRight
	     * @example
	     *
	     * _.inRange(3, 2, 4);
	     * // => true
	     *
	     * _.inRange(4, 8);
	     * // => true
	     *
	     * _.inRange(4, 2);
	     * // => false
	     *
	     * _.inRange(2, 2);
	     * // => false
	     *
	     * _.inRange(1.2, 2);
	     * // => true
	     *
	     * _.inRange(5.2, 4);
	     * // => false
	     *
	     * _.inRange(-3, -2, -6);
	     * // => true
	     */
	    function inRange(number, start, end) {
	      start = toFinite(start);
	      if (end === undefined) {
	        end = start;
	        start = 0;
	      } else {
	        end = toFinite(end);
	      }
	      number = toNumber(number);
	      return baseInRange(number, start, end);
	    }
	
	    /**
	     * Produces a random number between the inclusive `lower` and `upper` bounds.
	     * If only one argument is provided a number between `0` and the given number
	     * is returned. If `floating` is `true`, or either `lower` or `upper` are
	     * floats, a floating-point number is returned instead of an integer.
	     *
	     * **Note:** JavaScript follows the IEEE-754 standard for resolving
	     * floating-point values which can produce unexpected results.
	     *
	     * @static
	     * @memberOf _
	     * @since 0.7.0
	     * @category Number
	     * @param {number} [lower=0] The lower bound.
	     * @param {number} [upper=1] The upper bound.
	     * @param {boolean} [floating] Specify returning a floating-point number.
	     * @returns {number} Returns the random number.
	     * @example
	     *
	     * _.random(0, 5);
	     * // => an integer between 0 and 5
	     *
	     * _.random(5);
	     * // => also an integer between 0 and 5
	     *
	     * _.random(5, true);
	     * // => a floating-point number between 0 and 5
	     *
	     * _.random(1.2, 5.2);
	     * // => a floating-point number between 1.2 and 5.2
	     */
	    function random(lower, upper, floating) {
	      if (floating && typeof floating != 'boolean' && isIterateeCall(lower, upper, floating)) {
	        upper = floating = undefined;
	      }
	      if (floating === undefined) {
	        if (typeof upper == 'boolean') {
	          floating = upper;
	          upper = undefined;
	        }
	        else if (typeof lower == 'boolean') {
	          floating = lower;
	          lower = undefined;
	        }
	      }
	      if (lower === undefined && upper === undefined) {
	        lower = 0;
	        upper = 1;
	      }
	      else {
	        lower = toFinite(lower);
	        if (upper === undefined) {
	          upper = lower;
	          lower = 0;
	        } else {
	          upper = toFinite(upper);
	        }
	      }
	      if (lower > upper) {
	        var temp = lower;
	        lower = upper;
	        upper = temp;
	      }
	      if (floating || lower % 1 || upper % 1) {
	        var rand = nativeRandom();
	        return nativeMin(lower + (rand * (upper - lower + freeParseFloat('1e-' + ((rand + '').length - 1)))), upper);
	      }
	      return baseRandom(lower, upper);
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the camel cased string.
	     * @example
	     *
	     * _.camelCase('Foo Bar');
	     * // => 'fooBar'
	     *
	     * _.camelCase('--foo-bar--');
	     * // => 'fooBar'
	     *
	     * _.camelCase('__FOO_BAR__');
	     * // => 'fooBar'
	     */
	    var camelCase = createCompounder(function(result, word, index) {
	      word = word.toLowerCase();
	      return result + (index ? capitalize(word) : word);
	    });
	
	    /**
	     * Converts the first character of `string` to upper case and the remaining
	     * to lower case.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to capitalize.
	     * @returns {string} Returns the capitalized string.
	     * @example
	     *
	     * _.capitalize('FRED');
	     * // => 'Fred'
	     */
	    function capitalize(string) {
	      return upperFirst(toString(string).toLowerCase());
	    }
	
	    /**
	     * Deburrs `string` by converting
	     * [Latin-1 Supplement](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
	     * and [Latin Extended-A](https://en.wikipedia.org/wiki/Latin_Extended-A)
	     * letters to basic Latin letters and removing
	     * [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to deburr.
	     * @returns {string} Returns the deburred string.
	     * @example
	     *
	     * _.deburr('déjà vu');
	     * // => 'deja vu'
	     */
	    function deburr(string) {
	      string = toString(string);
	      return string && string.replace(reLatin, deburrLetter).replace(reComboMark, '');
	    }
	
	    /**
	     * Checks if `string` ends with the given target string.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to inspect.
	     * @param {string} [target] The string to search for.
	     * @param {number} [position=string.length] The position to search up to.
	     * @returns {boolean} Returns `true` if `string` ends with `target`,
	     *  else `false`.
	     * @example
	     *
	     * _.endsWith('abc', 'c');
	     * // => true
	     *
	     * _.endsWith('abc', 'b');
	     * // => false
	     *
	     * _.endsWith('abc', 'b', 2);
	     * // => true
	     */
	    function endsWith(string, target, position) {
	      string = toString(string);
	      target = baseToString(target);
	
	      var length = string.length;
	      position = position === undefined
	        ? length
	        : baseClamp(toInteger(position), 0, length);
	
	      var end = position;
	      position -= target.length;
	      return position >= 0 && string.slice(position, end) == target;
	    }
	
	    /**
	     * Converts the characters "&", "<", ">", '"', and "'" in `string` to their
	     * corresponding HTML entities.
	     *
	     * **Note:** No other characters are escaped. To escape additional
	     * characters use a third-party library like [_he_](https://mths.be/he).
	     *
	     * Though the ">" character is escaped for symmetry, characters like
	     * ">" and "/" don't need escaping in HTML and have no special meaning
	     * unless they're part of a tag or unquoted attribute value. See
	     * [Mathias Bynens's article](https://mathiasbynens.be/notes/ambiguous-ampersands)
	     * (under "semi-related fun fact") for more details.
	     *
	     * When working with HTML you should always
	     * [quote attribute values](http://wonko.com/post/html-escaping) to reduce
	     * XSS vectors.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category String
	     * @param {string} [string=''] The string to escape.
	     * @returns {string} Returns the escaped string.
	     * @example
	     *
	     * _.escape('fred, barney, & pebbles');
	     * // => 'fred, barney, &amp; pebbles'
	     */
	    function escape(string) {
	      string = toString(string);
	      return (string && reHasUnescapedHtml.test(string))
	        ? string.replace(reUnescapedHtml, escapeHtmlChar)
	        : string;
	    }
	
	    /**
	     * Escapes the `RegExp` special characters "^", "$", "\", ".", "*", "+",
	     * "?", "(", ")", "[", "]", "{", "}", and "|" in `string`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to escape.
	     * @returns {string} Returns the escaped string.
	     * @example
	     *
	     * _.escapeRegExp('[lodash](https://lodash.com/)');
	     * // => '\[lodash\]\(https://lodash\.com/\)'
	     */
	    function escapeRegExp(string) {
	      string = toString(string);
	      return (string && reHasRegExpChar.test(string))
	        ? string.replace(reRegExpChar, '\\$&')
	        : string;
	    }
	
	    /**
	     * Converts `string` to
	     * [kebab case](https://en.wikipedia.org/wiki/Letter_case#Special_case_styles).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the kebab cased string.
	     * @example
	     *
	     * _.kebabCase('Foo Bar');
	     * // => 'foo-bar'
	     *
	     * _.kebabCase('fooBar');
	     * // => 'foo-bar'
	     *
	     * _.kebabCase('__FOO_BAR__');
	     * // => 'foo-bar'
	     */
	    var kebabCase = createCompounder(function(result, word, index) {
	      return result + (index ? '-' : '') + word.toLowerCase();
	    });
	
	    /**
	     * Converts `string`, as space separated words, to lower case.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the lower cased string.
	     * @example
	     *
	     * _.lowerCase('--Foo-Bar--');
	     * // => 'foo bar'
	     *
	     * _.lowerCase('fooBar');
	     * // => 'foo bar'
	     *
	     * _.lowerCase('__FOO_BAR__');
	     * // => 'foo bar'
	     */
	    var lowerCase = createCompounder(function(result, word, index) {
	      return result + (index ? ' ' : '') + word.toLowerCase();
	    });
	
	    /**
	     * Converts the first character of `string` to lower case.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the converted string.
	     * @example
	     *
	     * _.lowerFirst('Fred');
	     * // => 'fred'
	     *
	     * _.lowerFirst('FRED');
	     * // => 'fRED'
	     */
	    var lowerFirst = createCaseFirst('toLowerCase');
	
	    /**
	     * Pads `string` on the left and right sides if it's shorter than `length`.
	     * Padding characters are truncated if they can't be evenly divided by `length`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to pad.
	     * @param {number} [length=0] The padding length.
	     * @param {string} [chars=' '] The string used as padding.
	     * @returns {string} Returns the padded string.
	     * @example
	     *
	     * _.pad('abc', 8);
	     * // => '  abc   '
	     *
	     * _.pad('abc', 8, '_-');
	     * // => '_-abc_-_'
	     *
	     * _.pad('abc', 3);
	     * // => 'abc'
	     */
	    function pad(string, length, chars) {
	      string = toString(string);
	      length = toInteger(length);
	
	      var strLength = length ? stringSize(string) : 0;
	      if (!length || strLength >= length) {
	        return string;
	      }
	      var mid = (length - strLength) / 2;
	      return (
	        createPadding(nativeFloor(mid), chars) +
	        string +
	        createPadding(nativeCeil(mid), chars)
	      );
	    }
	
	    /**
	     * Pads `string` on the right side if it's shorter than `length`. Padding
	     * characters are truncated if they exceed `length`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to pad.
	     * @param {number} [length=0] The padding length.
	     * @param {string} [chars=' '] The string used as padding.
	     * @returns {string} Returns the padded string.
	     * @example
	     *
	     * _.padEnd('abc', 6);
	     * // => 'abc   '
	     *
	     * _.padEnd('abc', 6, '_-');
	     * // => 'abc_-_'
	     *
	     * _.padEnd('abc', 3);
	     * // => 'abc'
	     */
	    function padEnd(string, length, chars) {
	      string = toString(string);
	      length = toInteger(length);
	
	      var strLength = length ? stringSize(string) : 0;
	      return (length && strLength < length)
	        ? (string + createPadding(length - strLength, chars))
	        : string;
	    }
	
	    /**
	     * Pads `string` on the left side if it's shorter than `length`. Padding
	     * characters are truncated if they exceed `length`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to pad.
	     * @param {number} [length=0] The padding length.
	     * @param {string} [chars=' '] The string used as padding.
	     * @returns {string} Returns the padded string.
	     * @example
	     *
	     * _.padStart('abc', 6);
	     * // => '   abc'
	     *
	     * _.padStart('abc', 6, '_-');
	     * // => '_-_abc'
	     *
	     * _.padStart('abc', 3);
	     * // => 'abc'
	     */
	    function padStart(string, length, chars) {
	      string = toString(string);
	      length = toInteger(length);
	
	      var strLength = length ? stringSize(string) : 0;
	      return (length && strLength < length)
	        ? (createPadding(length - strLength, chars) + string)
	        : string;
	    }
	
	    /**
	     * Converts `string` to an integer of the specified radix. If `radix` is
	     * `undefined` or `0`, a `radix` of `10` is used unless `value` is a
	     * hexadecimal, in which case a `radix` of `16` is used.
	     *
	     * **Note:** This method aligns with the
	     * [ES5 implementation](https://es5.github.io/#x15.1.2.2) of `parseInt`.
	     *
	     * @static
	     * @memberOf _
	     * @since 1.1.0
	     * @category String
	     * @param {string} string The string to convert.
	     * @param {number} [radix=10] The radix to interpret `value` by.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {number} Returns the converted integer.
	     * @example
	     *
	     * _.parseInt('08');
	     * // => 8
	     *
	     * _.map(['6', '08', '10'], _.parseInt);
	     * // => [6, 8, 10]
	     */
	    function parseInt(string, radix, guard) {
	      if (guard || radix == null) {
	        radix = 0;
	      } else if (radix) {
	        radix = +radix;
	      }
	      return nativeParseInt(toString(string).replace(reTrimStart, ''), radix || 0);
	    }
	
	    /**
	     * Repeats the given string `n` times.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to repeat.
	     * @param {number} [n=1] The number of times to repeat the string.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {string} Returns the repeated string.
	     * @example
	     *
	     * _.repeat('*', 3);
	     * // => '***'
	     *
	     * _.repeat('abc', 2);
	     * // => 'abcabc'
	     *
	     * _.repeat('abc', 0);
	     * // => ''
	     */
	    function repeat(string, n, guard) {
	      if ((guard ? isIterateeCall(string, n, guard) : n === undefined)) {
	        n = 1;
	      } else {
	        n = toInteger(n);
	      }
	      return baseRepeat(toString(string), n);
	    }
	
	    /**
	     * Replaces matches for `pattern` in `string` with `replacement`.
	     *
	     * **Note:** This method is based on
	     * [`String#replace`](https://mdn.io/String/replace).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to modify.
	     * @param {RegExp|string} pattern The pattern to replace.
	     * @param {Function|string} replacement The match replacement.
	     * @returns {string} Returns the modified string.
	     * @example
	     *
	     * _.replace('Hi Fred', 'Fred', 'Barney');
	     * // => 'Hi Barney'
	     */
	    function replace() {
	      var args = arguments,
	          string = toString(args[0]);
	
	      return args.length < 3 ? string : string.replace(args[1], args[2]);
	    }
	
	    /**
	     * Converts `string` to
	     * [snake case](https://en.wikipedia.org/wiki/Snake_case).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the snake cased string.
	     * @example
	     *
	     * _.snakeCase('Foo Bar');
	     * // => 'foo_bar'
	     *
	     * _.snakeCase('fooBar');
	     * // => 'foo_bar'
	     *
	     * _.snakeCase('--FOO-BAR--');
	     * // => 'foo_bar'
	     */
	    var snakeCase = createCompounder(function(result, word, index) {
	      return result + (index ? '_' : '') + word.toLowerCase();
	    });
	
	    /**
	     * Splits `string` by `separator`.
	     *
	     * **Note:** This method is based on
	     * [`String#split`](https://mdn.io/String/split).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to split.
	     * @param {RegExp|string} separator The separator pattern to split by.
	     * @param {number} [limit] The length to truncate results to.
	     * @returns {Array} Returns the string segments.
	     * @example
	     *
	     * _.split('a-b-c', '-', 2);
	     * // => ['a', 'b']
	     */
	    function split(string, separator, limit) {
	      if (limit && typeof limit != 'number' && isIterateeCall(string, separator, limit)) {
	        separator = limit = undefined;
	      }
	      limit = limit === undefined ? MAX_ARRAY_LENGTH : limit >>> 0;
	      if (!limit) {
	        return [];
	      }
	      string = toString(string);
	      if (string && (
	            typeof separator == 'string' ||
	            (separator != null && !isRegExp(separator))
	          )) {
	        separator = baseToString(separator);
	        if (!separator && hasUnicode(string)) {
	          return castSlice(stringToArray(string), 0, limit);
	        }
	      }
	      return string.split(separator, limit);
	    }
	
	    /**
	     * Converts `string` to
	     * [start case](https://en.wikipedia.org/wiki/Letter_case#Stylistic_or_specialised_usage).
	     *
	     * @static
	     * @memberOf _
	     * @since 3.1.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the start cased string.
	     * @example
	     *
	     * _.startCase('--foo-bar--');
	     * // => 'Foo Bar'
	     *
	     * _.startCase('fooBar');
	     * // => 'Foo Bar'
	     *
	     * _.startCase('__FOO_BAR__');
	     * // => 'FOO BAR'
	     */
	    var startCase = createCompounder(function(result, word, index) {
	      return result + (index ? ' ' : '') + upperFirst(word);
	    });
	
	    /**
	     * Checks if `string` starts with the given target string.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to inspect.
	     * @param {string} [target] The string to search for.
	     * @param {number} [position=0] The position to search from.
	     * @returns {boolean} Returns `true` if `string` starts with `target`,
	     *  else `false`.
	     * @example
	     *
	     * _.startsWith('abc', 'a');
	     * // => true
	     *
	     * _.startsWith('abc', 'b');
	     * // => false
	     *
	     * _.startsWith('abc', 'b', 1);
	     * // => true
	     */
	    function startsWith(string, target, position) {
	      string = toString(string);
	      position = position == null
	        ? 0
	        : baseClamp(toInteger(position), 0, string.length);
	
	      target = baseToString(target);
	      return string.slice(position, position + target.length) == target;
	    }
	
	    /**
	     * Creates a compiled template function that can interpolate data properties
	     * in "interpolate" delimiters, HTML-escape interpolated data properties in
	     * "escape" delimiters, and execute JavaScript in "evaluate" delimiters. Data
	     * properties may be accessed as free variables in the template. If a setting
	     * object is given, it takes precedence over `_.templateSettings` values.
	     *
	     * **Note:** In the development build `_.template` utilizes
	     * [sourceURLs](http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/#toc-sourceurl)
	     * for easier debugging.
	     *
	     * For more information on precompiling templates see
	     * [lodash's custom builds documentation](https://lodash.com/custom-builds).
	     *
	     * For more information on Chrome extension sandboxes see
	     * [Chrome's extensions documentation](https://developer.chrome.com/extensions/sandboxingEval).
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category String
	     * @param {string} [string=''] The template string.
	     * @param {Object} [options={}] The options object.
	     * @param {RegExp} [options.escape=_.templateSettings.escape]
	     *  The HTML "escape" delimiter.
	     * @param {RegExp} [options.evaluate=_.templateSettings.evaluate]
	     *  The "evaluate" delimiter.
	     * @param {Object} [options.imports=_.templateSettings.imports]
	     *  An object to import into the template as free variables.
	     * @param {RegExp} [options.interpolate=_.templateSettings.interpolate]
	     *  The "interpolate" delimiter.
	     * @param {string} [options.sourceURL='lodash.templateSources[n]']
	     *  The sourceURL of the compiled template.
	     * @param {string} [options.variable='obj']
	     *  The data object variable name.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Function} Returns the compiled template function.
	     * @example
	     *
	     * // Use the "interpolate" delimiter to create a compiled template.
	     * var compiled = _.template('hello <%= user %>!');
	     * compiled({ 'user': 'fred' });
	     * // => 'hello fred!'
	     *
	     * // Use the HTML "escape" delimiter to escape data property values.
	     * var compiled = _.template('<b><%- value %></b>');
	     * compiled({ 'value': '<script>' });
	     * // => '<b>&lt;script&gt;</b>'
	     *
	     * // Use the "evaluate" delimiter to execute JavaScript and generate HTML.
	     * var compiled = _.template('<% _.forEach(users, function(user) { %><li><%- user %></li><% }); %>');
	     * compiled({ 'users': ['fred', 'barney'] });
	     * // => '<li>fred</li><li>barney</li>'
	     *
	     * // Use the internal `print` function in "evaluate" delimiters.
	     * var compiled = _.template('<% print("hello " + user); %>!');
	     * compiled({ 'user': 'barney' });
	     * // => 'hello barney!'
	     *
	     * // Use the ES template literal delimiter as an "interpolate" delimiter.
	     * // Disable support by replacing the "interpolate" delimiter.
	     * var compiled = _.template('hello ${ user }!');
	     * compiled({ 'user': 'pebbles' });
	     * // => 'hello pebbles!'
	     *
	     * // Use backslashes to treat delimiters as plain text.
	     * var compiled = _.template('<%= "\\<%- value %\\>" %>');
	     * compiled({ 'value': 'ignored' });
	     * // => '<%- value %>'
	     *
	     * // Use the `imports` option to import `jQuery` as `jq`.
	     * var text = '<% jq.each(users, function(user) { %><li><%- user %></li><% }); %>';
	     * var compiled = _.template(text, { 'imports': { 'jq': jQuery } });
	     * compiled({ 'users': ['fred', 'barney'] });
	     * // => '<li>fred</li><li>barney</li>'
	     *
	     * // Use the `sourceURL` option to specify a custom sourceURL for the template.
	     * var compiled = _.template('hello <%= user %>!', { 'sourceURL': '/basic/greeting.jst' });
	     * compiled(data);
	     * // => Find the source of "greeting.jst" under the Sources tab or Resources panel of the web inspector.
	     *
	     * // Use the `variable` option to ensure a with-statement isn't used in the compiled template.
	     * var compiled = _.template('hi <%= data.user %>!', { 'variable': 'data' });
	     * compiled.source;
	     * // => function(data) {
	     * //   var __t, __p = '';
	     * //   __p += 'hi ' + ((__t = ( data.user )) == null ? '' : __t) + '!';
	     * //   return __p;
	     * // }
	     *
	     * // Use custom template delimiters.
	     * _.templateSettings.interpolate = /{{([\s\S]+?)}}/g;
	     * var compiled = _.template('hello {{ user }}!');
	     * compiled({ 'user': 'mustache' });
	     * // => 'hello mustache!'
	     *
	     * // Use the `source` property to inline compiled templates for meaningful
	     * // line numbers in error messages and stack traces.
	     * fs.writeFileSync(path.join(process.cwd(), 'jst.js'), '\
	     *   var JST = {\
	     *     "main": ' + _.template(mainText).source + '\
	     *   };\
	     * ');
	     */
	    function template(string, options, guard) {
	      // Based on John Resig's `tmpl` implementation
	      // (http://ejohn.org/blog/javascript-micro-templating/)
	      // and Laura Doktorova's doT.js (https://github.com/olado/doT).
	      var settings = lodash.templateSettings;
	
	      if (guard && isIterateeCall(string, options, guard)) {
	        options = undefined;
	      }
	      string = toString(string);
	      options = assignInWith({}, options, settings, customDefaultsAssignIn);
	
	      var imports = assignInWith({}, options.imports, settings.imports, customDefaultsAssignIn),
	          importsKeys = keys(imports),
	          importsValues = baseValues(imports, importsKeys);
	
	      var isEscaping,
	          isEvaluating,
	          index = 0,
	          interpolate = options.interpolate || reNoMatch,
	          source = "__p += '";
	
	      // Compile the regexp to match each delimiter.
	      var reDelimiters = RegExp(
	        (options.escape || reNoMatch).source + '|' +
	        interpolate.source + '|' +
	        (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + '|' +
	        (options.evaluate || reNoMatch).source + '|$'
	      , 'g');
	
	      // Use a sourceURL for easier debugging.
	      var sourceURL = '//# sourceURL=' +
	        ('sourceURL' in options
	          ? options.sourceURL
	          : ('lodash.templateSources[' + (++templateCounter) + ']')
	        ) + '\n';
	
	      string.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
	        interpolateValue || (interpolateValue = esTemplateValue);
	
	        // Escape characters that can't be included in string literals.
	        source += string.slice(index, offset).replace(reUnescapedString, escapeStringChar);
	
	        // Replace delimiters with snippets.
	        if (escapeValue) {
	          isEscaping = true;
	          source += "' +\n__e(" + escapeValue + ") +\n'";
	        }
	        if (evaluateValue) {
	          isEvaluating = true;
	          source += "';\n" + evaluateValue + ";\n__p += '";
	        }
	        if (interpolateValue) {
	          source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
	        }
	        index = offset + match.length;
	
	        // The JS engine embedded in Adobe products needs `match` returned in
	        // order to produce the correct `offset` value.
	        return match;
	      });
	
	      source += "';\n";
	
	      // If `variable` is not specified wrap a with-statement around the generated
	      // code to add the data object to the top of the scope chain.
	      var variable = options.variable;
	      if (!variable) {
	        source = 'with (obj) {\n' + source + '\n}\n';
	      }
	      // Cleanup code by stripping empty strings.
	      source = (isEvaluating ? source.replace(reEmptyStringLeading, '') : source)
	        .replace(reEmptyStringMiddle, '$1')
	        .replace(reEmptyStringTrailing, '$1;');
	
	      // Frame code as the function body.
	      source = 'function(' + (variable || 'obj') + ') {\n' +
	        (variable
	          ? ''
	          : 'obj || (obj = {});\n'
	        ) +
	        "var __t, __p = ''" +
	        (isEscaping
	           ? ', __e = _.escape'
	           : ''
	        ) +
	        (isEvaluating
	          ? ', __j = Array.prototype.join;\n' +
	            "function print() { __p += __j.call(arguments, '') }\n"
	          : ';\n'
	        ) +
	        source +
	        'return __p\n}';
	
	      var result = attempt(function() {
	        return Function(importsKeys, sourceURL + 'return ' + source)
	          .apply(undefined, importsValues);
	      });
	
	      // Provide the compiled function's source by its `toString` method or
	      // the `source` property as a convenience for inlining compiled templates.
	      result.source = source;
	      if (isError(result)) {
	        throw result;
	      }
	      return result;
	    }
	
	    /**
	     * Converts `string`, as a whole, to lower case just like
	     * [String#toLowerCase](https://mdn.io/toLowerCase).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the lower cased string.
	     * @example
	     *
	     * _.toLower('--Foo-Bar--');
	     * // => '--foo-bar--'
	     *
	     * _.toLower('fooBar');
	     * // => 'foobar'
	     *
	     * _.toLower('__FOO_BAR__');
	     * // => '__foo_bar__'
	     */
	    function toLower(value) {
	      return toString(value).toLowerCase();
	    }
	
	    /**
	     * Converts `string`, as a whole, to upper case just like
	     * [String#toUpperCase](https://mdn.io/toUpperCase).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the upper cased string.
	     * @example
	     *
	     * _.toUpper('--foo-bar--');
	     * // => '--FOO-BAR--'
	     *
	     * _.toUpper('fooBar');
	     * // => 'FOOBAR'
	     *
	     * _.toUpper('__foo_bar__');
	     * // => '__FOO_BAR__'
	     */
	    function toUpper(value) {
	      return toString(value).toUpperCase();
	    }
	
	    /**
	     * Removes leading and trailing whitespace or specified characters from `string`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to trim.
	     * @param {string} [chars=whitespace] The characters to trim.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {string} Returns the trimmed string.
	     * @example
	     *
	     * _.trim('  abc  ');
	     * // => 'abc'
	     *
	     * _.trim('-_-abc-_-', '_-');
	     * // => 'abc'
	     *
	     * _.map(['  foo  ', '  bar  '], _.trim);
	     * // => ['foo', 'bar']
	     */
	    function trim(string, chars, guard) {
	      string = toString(string);
	      if (string && (guard || chars === undefined)) {
	        return string.replace(reTrim, '');
	      }
	      if (!string || !(chars = baseToString(chars))) {
	        return string;
	      }
	      var strSymbols = stringToArray(string),
	          chrSymbols = stringToArray(chars),
	          start = charsStartIndex(strSymbols, chrSymbols),
	          end = charsEndIndex(strSymbols, chrSymbols) + 1;
	
	      return castSlice(strSymbols, start, end).join('');
	    }
	
	    /**
	     * Removes trailing whitespace or specified characters from `string`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to trim.
	     * @param {string} [chars=whitespace] The characters to trim.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {string} Returns the trimmed string.
	     * @example
	     *
	     * _.trimEnd('  abc  ');
	     * // => '  abc'
	     *
	     * _.trimEnd('-_-abc-_-', '_-');
	     * // => '-_-abc'
	     */
	    function trimEnd(string, chars, guard) {
	      string = toString(string);
	      if (string && (guard || chars === undefined)) {
	        return string.replace(reTrimEnd, '');
	      }
	      if (!string || !(chars = baseToString(chars))) {
	        return string;
	      }
	      var strSymbols = stringToArray(string),
	          end = charsEndIndex(strSymbols, stringToArray(chars)) + 1;
	
	      return castSlice(strSymbols, 0, end).join('');
	    }
	
	    /**
	     * Removes leading whitespace or specified characters from `string`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to trim.
	     * @param {string} [chars=whitespace] The characters to trim.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {string} Returns the trimmed string.
	     * @example
	     *
	     * _.trimStart('  abc  ');
	     * // => 'abc  '
	     *
	     * _.trimStart('-_-abc-_-', '_-');
	     * // => 'abc-_-'
	     */
	    function trimStart(string, chars, guard) {
	      string = toString(string);
	      if (string && (guard || chars === undefined)) {
	        return string.replace(reTrimStart, '');
	      }
	      if (!string || !(chars = baseToString(chars))) {
	        return string;
	      }
	      var strSymbols = stringToArray(string),
	          start = charsStartIndex(strSymbols, stringToArray(chars));
	
	      return castSlice(strSymbols, start).join('');
	    }
	
	    /**
	     * Truncates `string` if it's longer than the given maximum string length.
	     * The last characters of the truncated string are replaced with the omission
	     * string which defaults to "...".
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to truncate.
	     * @param {Object} [options={}] The options object.
	     * @param {number} [options.length=30] The maximum string length.
	     * @param {string} [options.omission='...'] The string to indicate text is omitted.
	     * @param {RegExp|string} [options.separator] The separator pattern to truncate to.
	     * @returns {string} Returns the truncated string.
	     * @example
	     *
	     * _.truncate('hi-diddly-ho there, neighborino');
	     * // => 'hi-diddly-ho there, neighbo...'
	     *
	     * _.truncate('hi-diddly-ho there, neighborino', {
	     *   'length': 24,
	     *   'separator': ' '
	     * });
	     * // => 'hi-diddly-ho there,...'
	     *
	     * _.truncate('hi-diddly-ho there, neighborino', {
	     *   'length': 24,
	     *   'separator': /,? +/
	     * });
	     * // => 'hi-diddly-ho there...'
	     *
	     * _.truncate('hi-diddly-ho there, neighborino', {
	     *   'omission': ' [...]'
	     * });
	     * // => 'hi-diddly-ho there, neig [...]'
	     */
	    function truncate(string, options) {
	      var length = DEFAULT_TRUNC_LENGTH,
	          omission = DEFAULT_TRUNC_OMISSION;
	
	      if (isObject(options)) {
	        var separator = 'separator' in options ? options.separator : separator;
	        length = 'length' in options ? toInteger(options.length) : length;
	        omission = 'omission' in options ? baseToString(options.omission) : omission;
	      }
	      string = toString(string);
	
	      var strLength = string.length;
	      if (hasUnicode(string)) {
	        var strSymbols = stringToArray(string);
	        strLength = strSymbols.length;
	      }
	      if (length >= strLength) {
	        return string;
	      }
	      var end = length - stringSize(omission);
	      if (end < 1) {
	        return omission;
	      }
	      var result = strSymbols
	        ? castSlice(strSymbols, 0, end).join('')
	        : string.slice(0, end);
	
	      if (separator === undefined) {
	        return result + omission;
	      }
	      if (strSymbols) {
	        end += (result.length - end);
	      }
	      if (isRegExp(separator)) {
	        if (string.slice(end).search(separator)) {
	          var match,
	              substring = result;
	
	          if (!separator.global) {
	            separator = RegExp(separator.source, toString(reFlags.exec(separator)) + 'g');
	          }
	          separator.lastIndex = 0;
	          while ((match = separator.exec(substring))) {
	            var newEnd = match.index;
	          }
	          result = result.slice(0, newEnd === undefined ? end : newEnd);
	        }
	      } else if (string.indexOf(baseToString(separator), end) != end) {
	        var index = result.lastIndexOf(separator);
	        if (index > -1) {
	          result = result.slice(0, index);
	        }
	      }
	      return result + omission;
	    }
	
	    /**
	     * The inverse of `_.escape`; this method converts the HTML entities
	     * `&amp;`, `&lt;`, `&gt;`, `&quot;`, and `&#39;` in `string` to
	     * their corresponding characters.
	     *
	     * **Note:** No other HTML entities are unescaped. To unescape additional
	     * HTML entities use a third-party library like [_he_](https://mths.be/he).
	     *
	     * @static
	     * @memberOf _
	     * @since 0.6.0
	     * @category String
	     * @param {string} [string=''] The string to unescape.
	     * @returns {string} Returns the unescaped string.
	     * @example
	     *
	     * _.unescape('fred, barney, &amp; pebbles');
	     * // => 'fred, barney, & pebbles'
	     */
	    function unescape(string) {
	      string = toString(string);
	      return (string && reHasEscapedHtml.test(string))
	        ? string.replace(reEscapedHtml, unescapeHtmlChar)
	        : string;
	    }
	
	    /**
	     * Converts `string`, as space separated words, to upper case.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the upper cased string.
	     * @example
	     *
	     * _.upperCase('--foo-bar');
	     * // => 'FOO BAR'
	     *
	     * _.upperCase('fooBar');
	     * // => 'FOO BAR'
	     *
	     * _.upperCase('__foo_bar__');
	     * // => 'FOO BAR'
	     */
	    var upperCase = createCompounder(function(result, word, index) {
	      return result + (index ? ' ' : '') + word.toUpperCase();
	    });
	
	    /**
	     * Converts the first character of `string` to upper case.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category String
	     * @param {string} [string=''] The string to convert.
	     * @returns {string} Returns the converted string.
	     * @example
	     *
	     * _.upperFirst('fred');
	     * // => 'Fred'
	     *
	     * _.upperFirst('FRED');
	     * // => 'FRED'
	     */
	    var upperFirst = createCaseFirst('toUpperCase');
	
	    /**
	     * Splits `string` into an array of its words.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category String
	     * @param {string} [string=''] The string to inspect.
	     * @param {RegExp|string} [pattern] The pattern to match words.
	     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	     * @returns {Array} Returns the words of `string`.
	     * @example
	     *
	     * _.words('fred, barney, & pebbles');
	     * // => ['fred', 'barney', 'pebbles']
	     *
	     * _.words('fred, barney, & pebbles', /[^, ]+/g);
	     * // => ['fred', 'barney', '&', 'pebbles']
	     */
	    function words(string, pattern, guard) {
	      string = toString(string);
	      pattern = guard ? undefined : pattern;
	
	      if (pattern === undefined) {
	        return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
	      }
	      return string.match(pattern) || [];
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Attempts to invoke `func`, returning either the result or the caught error
	     * object. Any additional arguments are provided to `func` when it's invoked.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Util
	     * @param {Function} func The function to attempt.
	     * @param {...*} [args] The arguments to invoke `func` with.
	     * @returns {*} Returns the `func` result or error object.
	     * @example
	     *
	     * // Avoid throwing errors for invalid selectors.
	     * var elements = _.attempt(function(selector) {
	     *   return document.querySelectorAll(selector);
	     * }, '>_>');
	     *
	     * if (_.isError(elements)) {
	     *   elements = [];
	     * }
	     */
	    var attempt = baseRest(function(func, args) {
	      try {
	        return apply(func, undefined, args);
	      } catch (e) {
	        return isError(e) ? e : new Error(e);
	      }
	    });
	
	    /**
	     * Binds methods of an object to the object itself, overwriting the existing
	     * method.
	     *
	     * **Note:** This method doesn't set the "length" property of bound functions.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Util
	     * @param {Object} object The object to bind and assign the bound methods to.
	     * @param {...(string|string[])} methodNames The object method names to bind.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * var view = {
	     *   'label': 'docs',
	     *   'click': function() {
	     *     console.log('clicked ' + this.label);
	     *   }
	     * };
	     *
	     * _.bindAll(view, ['click']);
	     * jQuery(element).on('click', view.click);
	     * // => Logs 'clicked docs' when clicked.
	     */
	    var bindAll = flatRest(function(object, methodNames) {
	      arrayEach(methodNames, function(key) {
	        key = toKey(key);
	        baseAssignValue(object, key, bind(object[key], object));
	      });
	      return object;
	    });
	
	    /**
	     * Creates a function that iterates over `pairs` and invokes the corresponding
	     * function of the first predicate to return truthy. The predicate-function
	     * pairs are invoked with the `this` binding and arguments of the created
	     * function.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {Array} pairs The predicate-function pairs.
	     * @returns {Function} Returns the new composite function.
	     * @example
	     *
	     * var func = _.cond([
	     *   [_.matches({ 'a': 1 }),           _.constant('matches A')],
	     *   [_.conforms({ 'b': _.isNumber }), _.constant('matches B')],
	     *   [_.stubTrue,                      _.constant('no match')]
	     * ]);
	     *
	     * func({ 'a': 1, 'b': 2 });
	     * // => 'matches A'
	     *
	     * func({ 'a': 0, 'b': 1 });
	     * // => 'matches B'
	     *
	     * func({ 'a': '1', 'b': '2' });
	     * // => 'no match'
	     */
	    function cond(pairs) {
	      var length = pairs == null ? 0 : pairs.length,
	          toIteratee = getIteratee();
	
	      pairs = !length ? [] : arrayMap(pairs, function(pair) {
	        if (typeof pair[1] != 'function') {
	          throw new TypeError(FUNC_ERROR_TEXT);
	        }
	        return [toIteratee(pair[0]), pair[1]];
	      });
	
	      return baseRest(function(args) {
	        var index = -1;
	        while (++index < length) {
	          var pair = pairs[index];
	          if (apply(pair[0], this, args)) {
	            return apply(pair[1], this, args);
	          }
	        }
	      });
	    }
	
	    /**
	     * Creates a function that invokes the predicate properties of `source` with
	     * the corresponding property values of a given object, returning `true` if
	     * all predicates return truthy, else `false`.
	     *
	     * **Note:** The created function is equivalent to `_.conformsTo` with
	     * `source` partially applied.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {Object} source The object of property predicates to conform to.
	     * @returns {Function} Returns the new spec function.
	     * @example
	     *
	     * var objects = [
	     *   { 'a': 2, 'b': 1 },
	     *   { 'a': 1, 'b': 2 }
	     * ];
	     *
	     * _.filter(objects, _.conforms({ 'b': function(n) { return n > 1; } }));
	     * // => [{ 'a': 1, 'b': 2 }]
	     */
	    function conforms(source) {
	      return baseConforms(baseClone(source, CLONE_DEEP_FLAG));
	    }
	
	    /**
	     * Creates a function that returns `value`.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.4.0
	     * @category Util
	     * @param {*} value The value to return from the new function.
	     * @returns {Function} Returns the new constant function.
	     * @example
	     *
	     * var objects = _.times(2, _.constant({ 'a': 1 }));
	     *
	     * console.log(objects);
	     * // => [{ 'a': 1 }, { 'a': 1 }]
	     *
	     * console.log(objects[0] === objects[1]);
	     * // => true
	     */
	    function constant(value) {
	      return function() {
	        return value;
	      };
	    }
	
	    /**
	     * Checks `value` to determine whether a default value should be returned in
	     * its place. The `defaultValue` is returned if `value` is `NaN`, `null`,
	     * or `undefined`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.14.0
	     * @category Util
	     * @param {*} value The value to check.
	     * @param {*} defaultValue The default value.
	     * @returns {*} Returns the resolved value.
	     * @example
	     *
	     * _.defaultTo(1, 10);
	     * // => 1
	     *
	     * _.defaultTo(undefined, 10);
	     * // => 10
	     */
	    function defaultTo(value, defaultValue) {
	      return (value == null || value !== value) ? defaultValue : value;
	    }
	
	    /**
	     * Creates a function that returns the result of invoking the given functions
	     * with the `this` binding of the created function, where each successive
	     * invocation is supplied the return value of the previous.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Util
	     * @param {...(Function|Function[])} [funcs] The functions to invoke.
	     * @returns {Function} Returns the new composite function.
	     * @see _.flowRight
	     * @example
	     *
	     * function square(n) {
	     *   return n * n;
	     * }
	     *
	     * var addSquare = _.flow([_.add, square]);
	     * addSquare(1, 2);
	     * // => 9
	     */
	    var flow = createFlow();
	
	    /**
	     * This method is like `_.flow` except that it creates a function that
	     * invokes the given functions from right to left.
	     *
	     * @static
	     * @since 3.0.0
	     * @memberOf _
	     * @category Util
	     * @param {...(Function|Function[])} [funcs] The functions to invoke.
	     * @returns {Function} Returns the new composite function.
	     * @see _.flow
	     * @example
	     *
	     * function square(n) {
	     *   return n * n;
	     * }
	     *
	     * var addSquare = _.flowRight([square, _.add]);
	     * addSquare(1, 2);
	     * // => 9
	     */
	    var flowRight = createFlow(true);
	
	    /**
	     * This method returns the first argument it receives.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Util
	     * @param {*} value Any value.
	     * @returns {*} Returns `value`.
	     * @example
	     *
	     * var object = { 'a': 1 };
	     *
	     * console.log(_.identity(object) === object);
	     * // => true
	     */
	    function identity(value) {
	      return value;
	    }
	
	    /**
	     * Creates a function that invokes `func` with the arguments of the created
	     * function. If `func` is a property name, the created function returns the
	     * property value for a given element. If `func` is an array or object, the
	     * created function returns `true` for elements that contain the equivalent
	     * source properties, otherwise it returns `false`.
	     *
	     * @static
	     * @since 4.0.0
	     * @memberOf _
	     * @category Util
	     * @param {*} [func=_.identity] The value to convert to a callback.
	     * @returns {Function} Returns the callback.
	     * @example
	     *
	     * var users = [
	     *   { 'user': 'barney', 'age': 36, 'active': true },
	     *   { 'user': 'fred',   'age': 40, 'active': false }
	     * ];
	     *
	     * // The `_.matches` iteratee shorthand.
	     * _.filter(users, _.iteratee({ 'user': 'barney', 'active': true }));
	     * // => [{ 'user': 'barney', 'age': 36, 'active': true }]
	     *
	     * // The `_.matchesProperty` iteratee shorthand.
	     * _.filter(users, _.iteratee(['user', 'fred']));
	     * // => [{ 'user': 'fred', 'age': 40 }]
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.map(users, _.iteratee('user'));
	     * // => ['barney', 'fred']
	     *
	     * // Create custom iteratee shorthands.
	     * _.iteratee = _.wrap(_.iteratee, function(iteratee, func) {
	     *   return !_.isRegExp(func) ? iteratee(func) : function(string) {
	     *     return func.test(string);
	     *   };
	     * });
	     *
	     * _.filter(['abc', 'def'], /ef/);
	     * // => ['def']
	     */
	    function iteratee(func) {
	      return baseIteratee(typeof func == 'function' ? func : baseClone(func, CLONE_DEEP_FLAG));
	    }
	
	    /**
	     * Creates a function that performs a partial deep comparison between a given
	     * object and `source`, returning `true` if the given object has equivalent
	     * property values, else `false`.
	     *
	     * **Note:** The created function is equivalent to `_.isMatch` with `source`
	     * partially applied.
	     *
	     * Partial comparisons will match empty array and empty object `source`
	     * values against any array or object value, respectively. See `_.isEqual`
	     * for a list of supported value comparisons.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Util
	     * @param {Object} source The object of property values to match.
	     * @returns {Function} Returns the new spec function.
	     * @example
	     *
	     * var objects = [
	     *   { 'a': 1, 'b': 2, 'c': 3 },
	     *   { 'a': 4, 'b': 5, 'c': 6 }
	     * ];
	     *
	     * _.filter(objects, _.matches({ 'a': 4, 'c': 6 }));
	     * // => [{ 'a': 4, 'b': 5, 'c': 6 }]
	     */
	    function matches(source) {
	      return baseMatches(baseClone(source, CLONE_DEEP_FLAG));
	    }
	
	    /**
	     * Creates a function that performs a partial deep comparison between the
	     * value at `path` of a given object to `srcValue`, returning `true` if the
	     * object value is equivalent, else `false`.
	     *
	     * **Note:** Partial comparisons will match empty array and empty object
	     * `srcValue` values against any array or object value, respectively. See
	     * `_.isEqual` for a list of supported value comparisons.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.2.0
	     * @category Util
	     * @param {Array|string} path The path of the property to get.
	     * @param {*} srcValue The value to match.
	     * @returns {Function} Returns the new spec function.
	     * @example
	     *
	     * var objects = [
	     *   { 'a': 1, 'b': 2, 'c': 3 },
	     *   { 'a': 4, 'b': 5, 'c': 6 }
	     * ];
	     *
	     * _.find(objects, _.matchesProperty('a', 4));
	     * // => { 'a': 4, 'b': 5, 'c': 6 }
	     */
	    function matchesProperty(path, srcValue) {
	      return baseMatchesProperty(path, baseClone(srcValue, CLONE_DEEP_FLAG));
	    }
	
	    /**
	     * Creates a function that invokes the method at `path` of a given object.
	     * Any additional arguments are provided to the invoked method.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.7.0
	     * @category Util
	     * @param {Array|string} path The path of the method to invoke.
	     * @param {...*} [args] The arguments to invoke the method with.
	     * @returns {Function} Returns the new invoker function.
	     * @example
	     *
	     * var objects = [
	     *   { 'a': { 'b': _.constant(2) } },
	     *   { 'a': { 'b': _.constant(1) } }
	     * ];
	     *
	     * _.map(objects, _.method('a.b'));
	     * // => [2, 1]
	     *
	     * _.map(objects, _.method(['a', 'b']));
	     * // => [2, 1]
	     */
	    var method = baseRest(function(path, args) {
	      return function(object) {
	        return baseInvoke(object, path, args);
	      };
	    });
	
	    /**
	     * The opposite of `_.method`; this method creates a function that invokes
	     * the method at a given path of `object`. Any additional arguments are
	     * provided to the invoked method.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.7.0
	     * @category Util
	     * @param {Object} object The object to query.
	     * @param {...*} [args] The arguments to invoke the method with.
	     * @returns {Function} Returns the new invoker function.
	     * @example
	     *
	     * var array = _.times(3, _.constant),
	     *     object = { 'a': array, 'b': array, 'c': array };
	     *
	     * _.map(['a[2]', 'c[0]'], _.methodOf(object));
	     * // => [2, 0]
	     *
	     * _.map([['a', '2'], ['c', '0']], _.methodOf(object));
	     * // => [2, 0]
	     */
	    var methodOf = baseRest(function(object, args) {
	      return function(path) {
	        return baseInvoke(object, path, args);
	      };
	    });
	
	    /**
	     * Adds all own enumerable string keyed function properties of a source
	     * object to the destination object. If `object` is a function, then methods
	     * are added to its prototype as well.
	     *
	     * **Note:** Use `_.runInContext` to create a pristine `lodash` function to
	     * avoid conflicts caused by modifying the original.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Util
	     * @param {Function|Object} [object=lodash] The destination object.
	     * @param {Object} source The object of functions to add.
	     * @param {Object} [options={}] The options object.
	     * @param {boolean} [options.chain=true] Specify whether mixins are chainable.
	     * @returns {Function|Object} Returns `object`.
	     * @example
	     *
	     * function vowels(string) {
	     *   return _.filter(string, function(v) {
	     *     return /[aeiou]/i.test(v);
	     *   });
	     * }
	     *
	     * _.mixin({ 'vowels': vowels });
	     * _.vowels('fred');
	     * // => ['e']
	     *
	     * _('fred').vowels().value();
	     * // => ['e']
	     *
	     * _.mixin({ 'vowels': vowels }, { 'chain': false });
	     * _('fred').vowels();
	     * // => ['e']
	     */
	    function mixin(object, source, options) {
	      var props = keys(source),
	          methodNames = baseFunctions(source, props);
	
	      if (options == null &&
	          !(isObject(source) && (methodNames.length || !props.length))) {
	        options = source;
	        source = object;
	        object = this;
	        methodNames = baseFunctions(source, keys(source));
	      }
	      var chain = !(isObject(options) && 'chain' in options) || !!options.chain,
	          isFunc = isFunction(object);
	
	      arrayEach(methodNames, function(methodName) {
	        var func = source[methodName];
	        object[methodName] = func;
	        if (isFunc) {
	          object.prototype[methodName] = function() {
	            var chainAll = this.__chain__;
	            if (chain || chainAll) {
	              var result = object(this.__wrapped__),
	                  actions = result.__actions__ = copyArray(this.__actions__);
	
	              actions.push({ 'func': func, 'args': arguments, 'thisArg': object });
	              result.__chain__ = chainAll;
	              return result;
	            }
	            return func.apply(object, arrayPush([this.value()], arguments));
	          };
	        }
	      });
	
	      return object;
	    }
	
	    /**
	     * Reverts the `_` variable to its previous value and returns a reference to
	     * the `lodash` function.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Util
	     * @returns {Function} Returns the `lodash` function.
	     * @example
	     *
	     * var lodash = _.noConflict();
	     */
	    function noConflict() {
	      if (root._ === this) {
	        root._ = oldDash;
	      }
	      return this;
	    }
	
	    /**
	     * This method returns `undefined`.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.3.0
	     * @category Util
	     * @example
	     *
	     * _.times(2, _.noop);
	     * // => [undefined, undefined]
	     */
	    function noop() {
	      // No operation performed.
	    }
	
	    /**
	     * Creates a function that gets the argument at index `n`. If `n` is negative,
	     * the nth argument from the end is returned.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {number} [n=0] The index of the argument to return.
	     * @returns {Function} Returns the new pass-thru function.
	     * @example
	     *
	     * var func = _.nthArg(1);
	     * func('a', 'b', 'c', 'd');
	     * // => 'b'
	     *
	     * var func = _.nthArg(-2);
	     * func('a', 'b', 'c', 'd');
	     * // => 'c'
	     */
	    function nthArg(n) {
	      n = toInteger(n);
	      return baseRest(function(args) {
	        return baseNth(args, n);
	      });
	    }
	
	    /**
	     * Creates a function that invokes `iteratees` with the arguments it receives
	     * and returns their results.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {...(Function|Function[])} [iteratees=[_.identity]]
	     *  The iteratees to invoke.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var func = _.over([Math.max, Math.min]);
	     *
	     * func(1, 2, 3, 4);
	     * // => [4, 1]
	     */
	    var over = createOver(arrayMap);
	
	    /**
	     * Creates a function that checks if **all** of the `predicates` return
	     * truthy when invoked with the arguments it receives.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {...(Function|Function[])} [predicates=[_.identity]]
	     *  The predicates to check.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var func = _.overEvery([Boolean, isFinite]);
	     *
	     * func('1');
	     * // => true
	     *
	     * func(null);
	     * // => false
	     *
	     * func(NaN);
	     * // => false
	     */
	    var overEvery = createOver(arrayEvery);
	
	    /**
	     * Creates a function that checks if **any** of the `predicates` return
	     * truthy when invoked with the arguments it receives.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {...(Function|Function[])} [predicates=[_.identity]]
	     *  The predicates to check.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var func = _.overSome([Boolean, isFinite]);
	     *
	     * func('1');
	     * // => true
	     *
	     * func(null);
	     * // => true
	     *
	     * func(NaN);
	     * // => false
	     */
	    var overSome = createOver(arraySome);
	
	    /**
	     * Creates a function that returns the value at `path` of a given object.
	     *
	     * @static
	     * @memberOf _
	     * @since 2.4.0
	     * @category Util
	     * @param {Array|string} path The path of the property to get.
	     * @returns {Function} Returns the new accessor function.
	     * @example
	     *
	     * var objects = [
	     *   { 'a': { 'b': 2 } },
	     *   { 'a': { 'b': 1 } }
	     * ];
	     *
	     * _.map(objects, _.property('a.b'));
	     * // => [2, 1]
	     *
	     * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
	     * // => [1, 2]
	     */
	    function property(path) {
	      return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
	    }
	
	    /**
	     * The opposite of `_.property`; this method creates a function that returns
	     * the value at a given path of `object`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.0.0
	     * @category Util
	     * @param {Object} object The object to query.
	     * @returns {Function} Returns the new accessor function.
	     * @example
	     *
	     * var array = [0, 1, 2],
	     *     object = { 'a': array, 'b': array, 'c': array };
	     *
	     * _.map(['a[2]', 'c[0]'], _.propertyOf(object));
	     * // => [2, 0]
	     *
	     * _.map([['a', '2'], ['c', '0']], _.propertyOf(object));
	     * // => [2, 0]
	     */
	    function propertyOf(object) {
	      return function(path) {
	        return object == null ? undefined : baseGet(object, path);
	      };
	    }
	
	    /**
	     * Creates an array of numbers (positive and/or negative) progressing from
	     * `start` up to, but not including, `end`. A step of `-1` is used if a negative
	     * `start` is specified without an `end` or `step`. If `end` is not specified,
	     * it's set to `start` with `start` then set to `0`.
	     *
	     * **Note:** JavaScript follows the IEEE-754 standard for resolving
	     * floating-point values which can produce unexpected results.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Util
	     * @param {number} [start=0] The start of the range.
	     * @param {number} end The end of the range.
	     * @param {number} [step=1] The value to increment or decrement by.
	     * @returns {Array} Returns the range of numbers.
	     * @see _.inRange, _.rangeRight
	     * @example
	     *
	     * _.range(4);
	     * // => [0, 1, 2, 3]
	     *
	     * _.range(-4);
	     * // => [0, -1, -2, -3]
	     *
	     * _.range(1, 5);
	     * // => [1, 2, 3, 4]
	     *
	     * _.range(0, 20, 5);
	     * // => [0, 5, 10, 15]
	     *
	     * _.range(0, -4, -1);
	     * // => [0, -1, -2, -3]
	     *
	     * _.range(1, 4, 0);
	     * // => [1, 1, 1]
	     *
	     * _.range(0);
	     * // => []
	     */
	    var range = createRange();
	
	    /**
	     * This method is like `_.range` except that it populates values in
	     * descending order.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {number} [start=0] The start of the range.
	     * @param {number} end The end of the range.
	     * @param {number} [step=1] The value to increment or decrement by.
	     * @returns {Array} Returns the range of numbers.
	     * @see _.inRange, _.range
	     * @example
	     *
	     * _.rangeRight(4);
	     * // => [3, 2, 1, 0]
	     *
	     * _.rangeRight(-4);
	     * // => [-3, -2, -1, 0]
	     *
	     * _.rangeRight(1, 5);
	     * // => [4, 3, 2, 1]
	     *
	     * _.rangeRight(0, 20, 5);
	     * // => [15, 10, 5, 0]
	     *
	     * _.rangeRight(0, -4, -1);
	     * // => [-3, -2, -1, 0]
	     *
	     * _.rangeRight(1, 4, 0);
	     * // => [1, 1, 1]
	     *
	     * _.rangeRight(0);
	     * // => []
	     */
	    var rangeRight = createRange(true);
	
	    /**
	     * This method returns a new empty array.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.13.0
	     * @category Util
	     * @returns {Array} Returns the new empty array.
	     * @example
	     *
	     * var arrays = _.times(2, _.stubArray);
	     *
	     * console.log(arrays);
	     * // => [[], []]
	     *
	     * console.log(arrays[0] === arrays[1]);
	     * // => false
	     */
	    function stubArray() {
	      return [];
	    }
	
	    /**
	     * This method returns `false`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.13.0
	     * @category Util
	     * @returns {boolean} Returns `false`.
	     * @example
	     *
	     * _.times(2, _.stubFalse);
	     * // => [false, false]
	     */
	    function stubFalse() {
	      return false;
	    }
	
	    /**
	     * This method returns a new empty object.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.13.0
	     * @category Util
	     * @returns {Object} Returns the new empty object.
	     * @example
	     *
	     * var objects = _.times(2, _.stubObject);
	     *
	     * console.log(objects);
	     * // => [{}, {}]
	     *
	     * console.log(objects[0] === objects[1]);
	     * // => false
	     */
	    function stubObject() {
	      return {};
	    }
	
	    /**
	     * This method returns an empty string.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.13.0
	     * @category Util
	     * @returns {string} Returns the empty string.
	     * @example
	     *
	     * _.times(2, _.stubString);
	     * // => ['', '']
	     */
	    function stubString() {
	      return '';
	    }
	
	    /**
	     * This method returns `true`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.13.0
	     * @category Util
	     * @returns {boolean} Returns `true`.
	     * @example
	     *
	     * _.times(2, _.stubTrue);
	     * // => [true, true]
	     */
	    function stubTrue() {
	      return true;
	    }
	
	    /**
	     * Invokes the iteratee `n` times, returning an array of the results of
	     * each invocation. The iteratee is invoked with one argument; (index).
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Util
	     * @param {number} n The number of times to invoke `iteratee`.
	     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
	     * @returns {Array} Returns the array of results.
	     * @example
	     *
	     * _.times(3, String);
	     * // => ['0', '1', '2']
	     *
	     *  _.times(4, _.constant(0));
	     * // => [0, 0, 0, 0]
	     */
	    function times(n, iteratee) {
	      n = toInteger(n);
	      if (n < 1 || n > MAX_SAFE_INTEGER) {
	        return [];
	      }
	      var index = MAX_ARRAY_LENGTH,
	          length = nativeMin(n, MAX_ARRAY_LENGTH);
	
	      iteratee = getIteratee(iteratee);
	      n -= MAX_ARRAY_LENGTH;
	
	      var result = baseTimes(length, iteratee);
	      while (++index < n) {
	        iteratee(index);
	      }
	      return result;
	    }
	
	    /**
	     * Converts `value` to a property path array.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Util
	     * @param {*} value The value to convert.
	     * @returns {Array} Returns the new property path array.
	     * @example
	     *
	     * _.toPath('a.b.c');
	     * // => ['a', 'b', 'c']
	     *
	     * _.toPath('a[0].b.c');
	     * // => ['a', '0', 'b', 'c']
	     */
	    function toPath(value) {
	      if (isArray(value)) {
	        return arrayMap(value, toKey);
	      }
	      return isSymbol(value) ? [value] : copyArray(stringToPath(toString(value)));
	    }
	
	    /**
	     * Generates a unique ID. If `prefix` is given, the ID is appended to it.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Util
	     * @param {string} [prefix=''] The value to prefix the ID with.
	     * @returns {string} Returns the unique ID.
	     * @example
	     *
	     * _.uniqueId('contact_');
	     * // => 'contact_104'
	     *
	     * _.uniqueId();
	     * // => '105'
	     */
	    function uniqueId(prefix) {
	      var id = ++idCounter;
	      return toString(prefix) + id;
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * Adds two numbers.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.4.0
	     * @category Math
	     * @param {number} augend The first number in an addition.
	     * @param {number} addend The second number in an addition.
	     * @returns {number} Returns the total.
	     * @example
	     *
	     * _.add(6, 4);
	     * // => 10
	     */
	    var add = createMathOperation(function(augend, addend) {
	      return augend + addend;
	    }, 0);
	
	    /**
	     * Computes `number` rounded up to `precision`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.10.0
	     * @category Math
	     * @param {number} number The number to round up.
	     * @param {number} [precision=0] The precision to round up to.
	     * @returns {number} Returns the rounded up number.
	     * @example
	     *
	     * _.ceil(4.006);
	     * // => 5
	     *
	     * _.ceil(6.004, 2);
	     * // => 6.01
	     *
	     * _.ceil(6040, -2);
	     * // => 6100
	     */
	    var ceil = createRound('ceil');
	
	    /**
	     * Divide two numbers.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.7.0
	     * @category Math
	     * @param {number} dividend The first number in a division.
	     * @param {number} divisor The second number in a division.
	     * @returns {number} Returns the quotient.
	     * @example
	     *
	     * _.divide(6, 4);
	     * // => 1.5
	     */
	    var divide = createMathOperation(function(dividend, divisor) {
	      return dividend / divisor;
	    }, 1);
	
	    /**
	     * Computes `number` rounded down to `precision`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.10.0
	     * @category Math
	     * @param {number} number The number to round down.
	     * @param {number} [precision=0] The precision to round down to.
	     * @returns {number} Returns the rounded down number.
	     * @example
	     *
	     * _.floor(4.006);
	     * // => 4
	     *
	     * _.floor(0.046, 2);
	     * // => 0.04
	     *
	     * _.floor(4060, -2);
	     * // => 4000
	     */
	    var floor = createRound('floor');
	
	    /**
	     * Computes the maximum value of `array`. If `array` is empty or falsey,
	     * `undefined` is returned.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @returns {*} Returns the maximum value.
	     * @example
	     *
	     * _.max([4, 2, 8, 6]);
	     * // => 8
	     *
	     * _.max([]);
	     * // => undefined
	     */
	    function max(array) {
	      return (array && array.length)
	        ? baseExtremum(array, identity, baseGt)
	        : undefined;
	    }
	
	    /**
	     * This method is like `_.max` except that it accepts `iteratee` which is
	     * invoked for each element in `array` to generate the criterion by which
	     * the value is ranked. The iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {*} Returns the maximum value.
	     * @example
	     *
	     * var objects = [{ 'n': 1 }, { 'n': 2 }];
	     *
	     * _.maxBy(objects, function(o) { return o.n; });
	     * // => { 'n': 2 }
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.maxBy(objects, 'n');
	     * // => { 'n': 2 }
	     */
	    function maxBy(array, iteratee) {
	      return (array && array.length)
	        ? baseExtremum(array, getIteratee(iteratee, 2), baseGt)
	        : undefined;
	    }
	
	    /**
	     * Computes the mean of the values in `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @returns {number} Returns the mean.
	     * @example
	     *
	     * _.mean([4, 2, 8, 6]);
	     * // => 5
	     */
	    function mean(array) {
	      return baseMean(array, identity);
	    }
	
	    /**
	     * This method is like `_.mean` except that it accepts `iteratee` which is
	     * invoked for each element in `array` to generate the value to be averaged.
	     * The iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.7.0
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {number} Returns the mean.
	     * @example
	     *
	     * var objects = [{ 'n': 4 }, { 'n': 2 }, { 'n': 8 }, { 'n': 6 }];
	     *
	     * _.meanBy(objects, function(o) { return o.n; });
	     * // => 5
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.meanBy(objects, 'n');
	     * // => 5
	     */
	    function meanBy(array, iteratee) {
	      return baseMean(array, getIteratee(iteratee, 2));
	    }
	
	    /**
	     * Computes the minimum value of `array`. If `array` is empty or falsey,
	     * `undefined` is returned.
	     *
	     * @static
	     * @since 0.1.0
	     * @memberOf _
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @returns {*} Returns the minimum value.
	     * @example
	     *
	     * _.min([4, 2, 8, 6]);
	     * // => 2
	     *
	     * _.min([]);
	     * // => undefined
	     */
	    function min(array) {
	      return (array && array.length)
	        ? baseExtremum(array, identity, baseLt)
	        : undefined;
	    }
	
	    /**
	     * This method is like `_.min` except that it accepts `iteratee` which is
	     * invoked for each element in `array` to generate the criterion by which
	     * the value is ranked. The iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {*} Returns the minimum value.
	     * @example
	     *
	     * var objects = [{ 'n': 1 }, { 'n': 2 }];
	     *
	     * _.minBy(objects, function(o) { return o.n; });
	     * // => { 'n': 1 }
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.minBy(objects, 'n');
	     * // => { 'n': 1 }
	     */
	    function minBy(array, iteratee) {
	      return (array && array.length)
	        ? baseExtremum(array, getIteratee(iteratee, 2), baseLt)
	        : undefined;
	    }
	
	    /**
	     * Multiply two numbers.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.7.0
	     * @category Math
	     * @param {number} multiplier The first number in a multiplication.
	     * @param {number} multiplicand The second number in a multiplication.
	     * @returns {number} Returns the product.
	     * @example
	     *
	     * _.multiply(6, 4);
	     * // => 24
	     */
	    var multiply = createMathOperation(function(multiplier, multiplicand) {
	      return multiplier * multiplicand;
	    }, 1);
	
	    /**
	     * Computes `number` rounded to `precision`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.10.0
	     * @category Math
	     * @param {number} number The number to round.
	     * @param {number} [precision=0] The precision to round to.
	     * @returns {number} Returns the rounded number.
	     * @example
	     *
	     * _.round(4.006);
	     * // => 4
	     *
	     * _.round(4.006, 2);
	     * // => 4.01
	     *
	     * _.round(4060, -2);
	     * // => 4100
	     */
	    var round = createRound('round');
	
	    /**
	     * Subtract two numbers.
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Math
	     * @param {number} minuend The first number in a subtraction.
	     * @param {number} subtrahend The second number in a subtraction.
	     * @returns {number} Returns the difference.
	     * @example
	     *
	     * _.subtract(6, 4);
	     * // => 2
	     */
	    var subtract = createMathOperation(function(minuend, subtrahend) {
	      return minuend - subtrahend;
	    }, 0);
	
	    /**
	     * Computes the sum of the values in `array`.
	     *
	     * @static
	     * @memberOf _
	     * @since 3.4.0
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @returns {number} Returns the sum.
	     * @example
	     *
	     * _.sum([4, 2, 8, 6]);
	     * // => 20
	     */
	    function sum(array) {
	      return (array && array.length)
	        ? baseSum(array, identity)
	        : 0;
	    }
	
	    /**
	     * This method is like `_.sum` except that it accepts `iteratee` which is
	     * invoked for each element in `array` to generate the value to be summed.
	     * The iteratee is invoked with one argument: (value).
	     *
	     * @static
	     * @memberOf _
	     * @since 4.0.0
	     * @category Math
	     * @param {Array} array The array to iterate over.
	     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
	     * @returns {number} Returns the sum.
	     * @example
	     *
	     * var objects = [{ 'n': 4 }, { 'n': 2 }, { 'n': 8 }, { 'n': 6 }];
	     *
	     * _.sumBy(objects, function(o) { return o.n; });
	     * // => 20
	     *
	     * // The `_.property` iteratee shorthand.
	     * _.sumBy(objects, 'n');
	     * // => 20
	     */
	    function sumBy(array, iteratee) {
	      return (array && array.length)
	        ? baseSum(array, getIteratee(iteratee, 2))
	        : 0;
	    }
	
	    /*------------------------------------------------------------------------*/
	
	    // Add methods that return wrapped values in chain sequences.
	    lodash.after = after;
	    lodash.ary = ary;
	    lodash.assign = assign;
	    lodash.assignIn = assignIn;
	    lodash.assignInWith = assignInWith;
	    lodash.assignWith = assignWith;
	    lodash.at = at;
	    lodash.before = before;
	    lodash.bind = bind;
	    lodash.bindAll = bindAll;
	    lodash.bindKey = bindKey;
	    lodash.castArray = castArray;
	    lodash.chain = chain;
	    lodash.chunk = chunk;
	    lodash.compact = compact;
	    lodash.concat = concat;
	    lodash.cond = cond;
	    lodash.conforms = conforms;
	    lodash.constant = constant;
	    lodash.countBy = countBy;
	    lodash.create = create;
	    lodash.curry = curry;
	    lodash.curryRight = curryRight;
	    lodash.debounce = debounce;
	    lodash.defaults = defaults;
	    lodash.defaultsDeep = defaultsDeep;
	    lodash.defer = defer;
	    lodash.delay = delay;
	    lodash.difference = difference;
	    lodash.differenceBy = differenceBy;
	    lodash.differenceWith = differenceWith;
	    lodash.drop = drop;
	    lodash.dropRight = dropRight;
	    lodash.dropRightWhile = dropRightWhile;
	    lodash.dropWhile = dropWhile;
	    lodash.fill = fill;
	    lodash.filter = filter;
	    lodash.flatMap = flatMap;
	    lodash.flatMapDeep = flatMapDeep;
	    lodash.flatMapDepth = flatMapDepth;
	    lodash.flatten = flatten;
	    lodash.flattenDeep = flattenDeep;
	    lodash.flattenDepth = flattenDepth;
	    lodash.flip = flip;
	    lodash.flow = flow;
	    lodash.flowRight = flowRight;
	    lodash.fromPairs = fromPairs;
	    lodash.functions = functions;
	    lodash.functionsIn = functionsIn;
	    lodash.groupBy = groupBy;
	    lodash.initial = initial;
	    lodash.intersection = intersection;
	    lodash.intersectionBy = intersectionBy;
	    lodash.intersectionWith = intersectionWith;
	    lodash.invert = invert;
	    lodash.invertBy = invertBy;
	    lodash.invokeMap = invokeMap;
	    lodash.iteratee = iteratee;
	    lodash.keyBy = keyBy;
	    lodash.keys = keys;
	    lodash.keysIn = keysIn;
	    lodash.map = map;
	    lodash.mapKeys = mapKeys;
	    lodash.mapValues = mapValues;
	    lodash.matches = matches;
	    lodash.matchesProperty = matchesProperty;
	    lodash.memoize = memoize;
	    lodash.merge = merge;
	    lodash.mergeWith = mergeWith;
	    lodash.method = method;
	    lodash.methodOf = methodOf;
	    lodash.mixin = mixin;
	    lodash.negate = negate;
	    lodash.nthArg = nthArg;
	    lodash.omit = omit;
	    lodash.omitBy = omitBy;
	    lodash.once = once;
	    lodash.orderBy = orderBy;
	    lodash.over = over;
	    lodash.overArgs = overArgs;
	    lodash.overEvery = overEvery;
	    lodash.overSome = overSome;
	    lodash.partial = partial;
	    lodash.partialRight = partialRight;
	    lodash.partition = partition;
	    lodash.pick = pick;
	    lodash.pickBy = pickBy;
	    lodash.property = property;
	    lodash.propertyOf = propertyOf;
	    lodash.pull = pull;
	    lodash.pullAll = pullAll;
	    lodash.pullAllBy = pullAllBy;
	    lodash.pullAllWith = pullAllWith;
	    lodash.pullAt = pullAt;
	    lodash.range = range;
	    lodash.rangeRight = rangeRight;
	    lodash.rearg = rearg;
	    lodash.reject = reject;
	    lodash.remove = remove;
	    lodash.rest = rest;
	    lodash.reverse = reverse;
	    lodash.sampleSize = sampleSize;
	    lodash.set = set;
	    lodash.setWith = setWith;
	    lodash.shuffle = shuffle;
	    lodash.slice = slice;
	    lodash.sortBy = sortBy;
	    lodash.sortedUniq = sortedUniq;
	    lodash.sortedUniqBy = sortedUniqBy;
	    lodash.split = split;
	    lodash.spread = spread;
	    lodash.tail = tail;
	    lodash.take = take;
	    lodash.takeRight = takeRight;
	    lodash.takeRightWhile = takeRightWhile;
	    lodash.takeWhile = takeWhile;
	    lodash.tap = tap;
	    lodash.throttle = throttle;
	    lodash.thru = thru;
	    lodash.toArray = toArray;
	    lodash.toPairs = toPairs;
	    lodash.toPairsIn = toPairsIn;
	    lodash.toPath = toPath;
	    lodash.toPlainObject = toPlainObject;
	    lodash.transform = transform;
	    lodash.unary = unary;
	    lodash.union = union;
	    lodash.unionBy = unionBy;
	    lodash.unionWith = unionWith;
	    lodash.uniq = uniq;
	    lodash.uniqBy = uniqBy;
	    lodash.uniqWith = uniqWith;
	    lodash.unset = unset;
	    lodash.unzip = unzip;
	    lodash.unzipWith = unzipWith;
	    lodash.update = update;
	    lodash.updateWith = updateWith;
	    lodash.values = values;
	    lodash.valuesIn = valuesIn;
	    lodash.without = without;
	    lodash.words = words;
	    lodash.wrap = wrap;
	    lodash.xor = xor;
	    lodash.xorBy = xorBy;
	    lodash.xorWith = xorWith;
	    lodash.zip = zip;
	    lodash.zipObject = zipObject;
	    lodash.zipObjectDeep = zipObjectDeep;
	    lodash.zipWith = zipWith;
	
	    // Add aliases.
	    lodash.entries = toPairs;
	    lodash.entriesIn = toPairsIn;
	    lodash.extend = assignIn;
	    lodash.extendWith = assignInWith;
	
	    // Add methods to `lodash.prototype`.
	    mixin(lodash, lodash);
	
	    /*------------------------------------------------------------------------*/
	
	    // Add methods that return unwrapped values in chain sequences.
	    lodash.add = add;
	    lodash.attempt = attempt;
	    lodash.camelCase = camelCase;
	    lodash.capitalize = capitalize;
	    lodash.ceil = ceil;
	    lodash.clamp = clamp;
	    lodash.clone = clone;
	    lodash.cloneDeep = cloneDeep;
	    lodash.cloneDeepWith = cloneDeepWith;
	    lodash.cloneWith = cloneWith;
	    lodash.conformsTo = conformsTo;
	    lodash.deburr = deburr;
	    lodash.defaultTo = defaultTo;
	    lodash.divide = divide;
	    lodash.endsWith = endsWith;
	    lodash.eq = eq;
	    lodash.escape = escape;
	    lodash.escapeRegExp = escapeRegExp;
	    lodash.every = every;
	    lodash.find = find;
	    lodash.findIndex = findIndex;
	    lodash.findKey = findKey;
	    lodash.findLast = findLast;
	    lodash.findLastIndex = findLastIndex;
	    lodash.findLastKey = findLastKey;
	    lodash.floor = floor;
	    lodash.forEach = forEach;
	    lodash.forEachRight = forEachRight;
	    lodash.forIn = forIn;
	    lodash.forInRight = forInRight;
	    lodash.forOwn = forOwn;
	    lodash.forOwnRight = forOwnRight;
	    lodash.get = get;
	    lodash.gt = gt;
	    lodash.gte = gte;
	    lodash.has = has;
	    lodash.hasIn = hasIn;
	    lodash.head = head;
	    lodash.identity = identity;
	    lodash.includes = includes;
	    lodash.indexOf = indexOf;
	    lodash.inRange = inRange;
	    lodash.invoke = invoke;
	    lodash.isArguments = isArguments;
	    lodash.isArray = isArray;
	    lodash.isArrayBuffer = isArrayBuffer;
	    lodash.isArrayLike = isArrayLike;
	    lodash.isArrayLikeObject = isArrayLikeObject;
	    lodash.isBoolean = isBoolean;
	    lodash.isBuffer = isBuffer;
	    lodash.isDate = isDate;
	    lodash.isElement = isElement;
	    lodash.isEmpty = isEmpty;
	    lodash.isEqual = isEqual;
	    lodash.isEqualWith = isEqualWith;
	    lodash.isError = isError;
	    lodash.isFinite = isFinite;
	    lodash.isFunction = isFunction;
	    lodash.isInteger = isInteger;
	    lodash.isLength = isLength;
	    lodash.isMap = isMap;
	    lodash.isMatch = isMatch;
	    lodash.isMatchWith = isMatchWith;
	    lodash.isNaN = isNaN;
	    lodash.isNative = isNative;
	    lodash.isNil = isNil;
	    lodash.isNull = isNull;
	    lodash.isNumber = isNumber;
	    lodash.isObject = isObject;
	    lodash.isObjectLike = isObjectLike;
	    lodash.isPlainObject = isPlainObject;
	    lodash.isRegExp = isRegExp;
	    lodash.isSafeInteger = isSafeInteger;
	    lodash.isSet = isSet;
	    lodash.isString = isString;
	    lodash.isSymbol = isSymbol;
	    lodash.isTypedArray = isTypedArray;
	    lodash.isUndefined = isUndefined;
	    lodash.isWeakMap = isWeakMap;
	    lodash.isWeakSet = isWeakSet;
	    lodash.join = join;
	    lodash.kebabCase = kebabCase;
	    lodash.last = last;
	    lodash.lastIndexOf = lastIndexOf;
	    lodash.lowerCase = lowerCase;
	    lodash.lowerFirst = lowerFirst;
	    lodash.lt = lt;
	    lodash.lte = lte;
	    lodash.max = max;
	    lodash.maxBy = maxBy;
	    lodash.mean = mean;
	    lodash.meanBy = meanBy;
	    lodash.min = min;
	    lodash.minBy = minBy;
	    lodash.stubArray = stubArray;
	    lodash.stubFalse = stubFalse;
	    lodash.stubObject = stubObject;
	    lodash.stubString = stubString;
	    lodash.stubTrue = stubTrue;
	    lodash.multiply = multiply;
	    lodash.nth = nth;
	    lodash.noConflict = noConflict;
	    lodash.noop = noop;
	    lodash.now = now;
	    lodash.pad = pad;
	    lodash.padEnd = padEnd;
	    lodash.padStart = padStart;
	    lodash.parseInt = parseInt;
	    lodash.random = random;
	    lodash.reduce = reduce;
	    lodash.reduceRight = reduceRight;
	    lodash.repeat = repeat;
	    lodash.replace = replace;
	    lodash.result = result;
	    lodash.round = round;
	    lodash.runInContext = runInContext;
	    lodash.sample = sample;
	    lodash.size = size;
	    lodash.snakeCase = snakeCase;
	    lodash.some = some;
	    lodash.sortedIndex = sortedIndex;
	    lodash.sortedIndexBy = sortedIndexBy;
	    lodash.sortedIndexOf = sortedIndexOf;
	    lodash.sortedLastIndex = sortedLastIndex;
	    lodash.sortedLastIndexBy = sortedLastIndexBy;
	    lodash.sortedLastIndexOf = sortedLastIndexOf;
	    lodash.startCase = startCase;
	    lodash.startsWith = startsWith;
	    lodash.subtract = subtract;
	    lodash.sum = sum;
	    lodash.sumBy = sumBy;
	    lodash.template = template;
	    lodash.times = times;
	    lodash.toFinite = toFinite;
	    lodash.toInteger = toInteger;
	    lodash.toLength = toLength;
	    lodash.toLower = toLower;
	    lodash.toNumber = toNumber;
	    lodash.toSafeInteger = toSafeInteger;
	    lodash.toString = toString;
	    lodash.toUpper = toUpper;
	    lodash.trim = trim;
	    lodash.trimEnd = trimEnd;
	    lodash.trimStart = trimStart;
	    lodash.truncate = truncate;
	    lodash.unescape = unescape;
	    lodash.uniqueId = uniqueId;
	    lodash.upperCase = upperCase;
	    lodash.upperFirst = upperFirst;
	
	    // Add aliases.
	    lodash.each = forEach;
	    lodash.eachRight = forEachRight;
	    lodash.first = head;
	
	    mixin(lodash, (function() {
	      var source = {};
	      baseForOwn(lodash, function(func, methodName) {
	        if (!hasOwnProperty.call(lodash.prototype, methodName)) {
	          source[methodName] = func;
	        }
	      });
	      return source;
	    }()), { 'chain': false });
	
	    /*------------------------------------------------------------------------*/
	
	    /**
	     * The semantic version number.
	     *
	     * @static
	     * @memberOf _
	     * @type {string}
	     */
	    lodash.VERSION = VERSION;
	
	    // Assign default placeholders.
	    arrayEach(['bind', 'bindKey', 'curry', 'curryRight', 'partial', 'partialRight'], function(methodName) {
	      lodash[methodName].placeholder = lodash;
	    });
	
	    // Add `LazyWrapper` methods for `_.drop` and `_.take` variants.
	    arrayEach(['drop', 'take'], function(methodName, index) {
	      LazyWrapper.prototype[methodName] = function(n) {
	        n = n === undefined ? 1 : nativeMax(toInteger(n), 0);
	
	        var result = (this.__filtered__ && !index)
	          ? new LazyWrapper(this)
	          : this.clone();
	
	        if (result.__filtered__) {
	          result.__takeCount__ = nativeMin(n, result.__takeCount__);
	        } else {
	          result.__views__.push({
	            'size': nativeMin(n, MAX_ARRAY_LENGTH),
	            'type': methodName + (result.__dir__ < 0 ? 'Right' : '')
	          });
	        }
	        return result;
	      };
	
	      LazyWrapper.prototype[methodName + 'Right'] = function(n) {
	        return this.reverse()[methodName](n).reverse();
	      };
	    });
	
	    // Add `LazyWrapper` methods that accept an `iteratee` value.
	    arrayEach(['filter', 'map', 'takeWhile'], function(methodName, index) {
	      var type = index + 1,
	          isFilter = type == LAZY_FILTER_FLAG || type == LAZY_WHILE_FLAG;
	
	      LazyWrapper.prototype[methodName] = function(iteratee) {
	        var result = this.clone();
	        result.__iteratees__.push({
	          'iteratee': getIteratee(iteratee, 3),
	          'type': type
	        });
	        result.__filtered__ = result.__filtered__ || isFilter;
	        return result;
	      };
	    });
	
	    // Add `LazyWrapper` methods for `_.head` and `_.last`.
	    arrayEach(['head', 'last'], function(methodName, index) {
	      var takeName = 'take' + (index ? 'Right' : '');
	
	      LazyWrapper.prototype[methodName] = function() {
	        return this[takeName](1).value()[0];
	      };
	    });
	
	    // Add `LazyWrapper` methods for `_.initial` and `_.tail`.
	    arrayEach(['initial', 'tail'], function(methodName, index) {
	      var dropName = 'drop' + (index ? '' : 'Right');
	
	      LazyWrapper.prototype[methodName] = function() {
	        return this.__filtered__ ? new LazyWrapper(this) : this[dropName](1);
	      };
	    });
	
	    LazyWrapper.prototype.compact = function() {
	      return this.filter(identity);
	    };
	
	    LazyWrapper.prototype.find = function(predicate) {
	      return this.filter(predicate).head();
	    };
	
	    LazyWrapper.prototype.findLast = function(predicate) {
	      return this.reverse().find(predicate);
	    };
	
	    LazyWrapper.prototype.invokeMap = baseRest(function(path, args) {
	      if (typeof path == 'function') {
	        return new LazyWrapper(this);
	      }
	      return this.map(function(value) {
	        return baseInvoke(value, path, args);
	      });
	    });
	
	    LazyWrapper.prototype.reject = function(predicate) {
	      return this.filter(negate(getIteratee(predicate)));
	    };
	
	    LazyWrapper.prototype.slice = function(start, end) {
	      start = toInteger(start);
	
	      var result = this;
	      if (result.__filtered__ && (start > 0 || end < 0)) {
	        return new LazyWrapper(result);
	      }
	      if (start < 0) {
	        result = result.takeRight(-start);
	      } else if (start) {
	        result = result.drop(start);
	      }
	      if (end !== undefined) {
	        end = toInteger(end);
	        result = end < 0 ? result.dropRight(-end) : result.take(end - start);
	      }
	      return result;
	    };
	
	    LazyWrapper.prototype.takeRightWhile = function(predicate) {
	      return this.reverse().takeWhile(predicate).reverse();
	    };
	
	    LazyWrapper.prototype.toArray = function() {
	      return this.take(MAX_ARRAY_LENGTH);
	    };
	
	    // Add `LazyWrapper` methods to `lodash.prototype`.
	    baseForOwn(LazyWrapper.prototype, function(func, methodName) {
	      var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(methodName),
	          isTaker = /^(?:head|last)$/.test(methodName),
	          lodashFunc = lodash[isTaker ? ('take' + (methodName == 'last' ? 'Right' : '')) : methodName],
	          retUnwrapped = isTaker || /^find/.test(methodName);
	
	      if (!lodashFunc) {
	        return;
	      }
	      lodash.prototype[methodName] = function() {
	        var value = this.__wrapped__,
	            args = isTaker ? [1] : arguments,
	            isLazy = value instanceof LazyWrapper,
	            iteratee = args[0],
	            useLazy = isLazy || isArray(value);
	
	        var interceptor = function(value) {
	          var result = lodashFunc.apply(lodash, arrayPush([value], args));
	          return (isTaker && chainAll) ? result[0] : result;
	        };
	
	        if (useLazy && checkIteratee && typeof iteratee == 'function' && iteratee.length != 1) {
	          // Avoid lazy use if the iteratee has a "length" value other than `1`.
	          isLazy = useLazy = false;
	        }
	        var chainAll = this.__chain__,
	            isHybrid = !!this.__actions__.length,
	            isUnwrapped = retUnwrapped && !chainAll,
	            onlyLazy = isLazy && !isHybrid;
	
	        if (!retUnwrapped && useLazy) {
	          value = onlyLazy ? value : new LazyWrapper(this);
	          var result = func.apply(value, args);
	          result.__actions__.push({ 'func': thru, 'args': [interceptor], 'thisArg': undefined });
	          return new LodashWrapper(result, chainAll);
	        }
	        if (isUnwrapped && onlyLazy) {
	          return func.apply(this, args);
	        }
	        result = this.thru(interceptor);
	        return isUnwrapped ? (isTaker ? result.value()[0] : result.value()) : result;
	      };
	    });
	
	    // Add `Array` methods to `lodash.prototype`.
	    arrayEach(['pop', 'push', 'shift', 'sort', 'splice', 'unshift'], function(methodName) {
	      var func = arrayProto[methodName],
	          chainName = /^(?:push|sort|unshift)$/.test(methodName) ? 'tap' : 'thru',
	          retUnwrapped = /^(?:pop|shift)$/.test(methodName);
	
	      lodash.prototype[methodName] = function() {
	        var args = arguments;
	        if (retUnwrapped && !this.__chain__) {
	          var value = this.value();
	          return func.apply(isArray(value) ? value : [], args);
	        }
	        return this[chainName](function(value) {
	          return func.apply(isArray(value) ? value : [], args);
	        });
	      };
	    });
	
	    // Map minified method names to their real names.
	    baseForOwn(LazyWrapper.prototype, function(func, methodName) {
	      var lodashFunc = lodash[methodName];
	      if (lodashFunc) {
	        var key = (lodashFunc.name + ''),
	            names = realNames[key] || (realNames[key] = []);
	
	        names.push({ 'name': methodName, 'func': lodashFunc });
	      }
	    });
	
	    realNames[createHybrid(undefined, WRAP_BIND_KEY_FLAG).name] = [{
	      'name': 'wrapper',
	      'func': undefined
	    }];
	
	    // Add methods to `LazyWrapper`.
	    LazyWrapper.prototype.clone = lazyClone;
	    LazyWrapper.prototype.reverse = lazyReverse;
	    LazyWrapper.prototype.value = lazyValue;
	
	    // Add chain sequence methods to the `lodash` wrapper.
	    lodash.prototype.at = wrapperAt;
	    lodash.prototype.chain = wrapperChain;
	    lodash.prototype.commit = wrapperCommit;
	    lodash.prototype.next = wrapperNext;
	    lodash.prototype.plant = wrapperPlant;
	    lodash.prototype.reverse = wrapperReverse;
	    lodash.prototype.toJSON = lodash.prototype.valueOf = lodash.prototype.value = wrapperValue;
	
	    // Add lazy aliases.
	    lodash.prototype.first = lodash.prototype.head;
	
	    if (symIterator) {
	      lodash.prototype[symIterator] = wrapperToIterator;
	    }
	    return lodash;
	  });
	
	  /*--------------------------------------------------------------------------*/
	
	  // Export lodash.
	  var _ = runInContext();
	
	  // Some AMD build optimizers, like r.js, check for condition patterns like:
	  if (true) {
	    // Expose Lodash on the global object to prevent errors when Lodash is
	    // loaded by a script tag in the presence of an AMD loader.
	    // See http://requirejs.org/docs/errors.html#mismatch for more details.
	    // Use `_.noConflict` to remove Lodash from the global object.
	    root._ = _;
	
	    // Define as an anonymous module so, through path mapping, it can be
	    // referenced as the "underscore" module.
	    !(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
	      return _;
	    }.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  }
	  // Check for `exports` after `define` in case a build optimizer adds it.
	  else if (freeModule) {
	    // Export for Node.js.
	    (freeModule.exports = _)._ = _;
	    // Export for CommonJS support.
	    freeExports._ = _;
	  }
	  else {
	    // Export to the global object.
	    root._ = _;
	  }
	}.call(this));
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(4)(module)))

/***/ }),
/* 4 */
/***/ (function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	(function (global, factory) {
		 true ? factory(exports) :
		typeof define === 'function' && define.amd ? define(['exports'], factory) :
		(factory((global.THREE = global.THREE || {})));
	}(this, (function (exports) { 'use strict';
	
		// Polyfills
	
		if ( Number.EPSILON === undefined ) {
	
			Number.EPSILON = Math.pow( 2, - 52 );
	
		}
	
		if ( Number.isInteger === undefined ) {
	
			// Missing in IE
			// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isInteger
	
			Number.isInteger = function ( value ) {
	
				return typeof value === 'number' && isFinite( value ) && Math.floor( value ) === value;
	
			};
	
		}
	
		//
	
		if ( Math.sign === undefined ) {
	
			// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/sign
	
			Math.sign = function ( x ) {
	
				return ( x < 0 ) ? - 1 : ( x > 0 ) ? 1 : + x;
	
			};
	
		}
	
		if ( Function.prototype.name === undefined ) {
	
			// Missing in IE
			// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/name
	
			Object.defineProperty( Function.prototype, 'name', {
	
				get: function () {
	
					return this.toString().match( /^\s*function\s*([^\(\s]*)/ )[ 1 ];
	
				}
	
			} );
	
		}
	
		if ( Object.assign === undefined ) {
	
			// Missing in IE
			// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign
	
			( function () {
	
				Object.assign = function ( target ) {
	
					'use strict';
	
					if ( target === undefined || target === null ) {
	
						throw new TypeError( 'Cannot convert undefined or null to object' );
	
					}
	
					var output = Object( target );
	
					for ( var index = 1; index < arguments.length; index ++ ) {
	
						var source = arguments[ index ];
	
						if ( source !== undefined && source !== null ) {
	
							for ( var nextKey in source ) {
	
								if ( Object.prototype.hasOwnProperty.call( source, nextKey ) ) {
	
									output[ nextKey ] = source[ nextKey ];
	
								}
	
							}
	
						}
	
					}
	
					return output;
	
				};
	
			} )();
	
		}
	
		/**
		 * https://github.com/mrdoob/eventdispatcher.js/
		 */
	
		function EventDispatcher() {}
	
		Object.assign( EventDispatcher.prototype, {
	
			addEventListener: function ( type, listener ) {
	
				if ( this._listeners === undefined ) this._listeners = {};
	
				var listeners = this._listeners;
	
				if ( listeners[ type ] === undefined ) {
	
					listeners[ type ] = [];
	
				}
	
				if ( listeners[ type ].indexOf( listener ) === - 1 ) {
	
					listeners[ type ].push( listener );
	
				}
	
			},
	
			hasEventListener: function ( type, listener ) {
	
				if ( this._listeners === undefined ) return false;
	
				var listeners = this._listeners;
	
				return listeners[ type ] !== undefined && listeners[ type ].indexOf( listener ) !== - 1;
	
			},
	
			removeEventListener: function ( type, listener ) {
	
				if ( this._listeners === undefined ) return;
	
				var listeners = this._listeners;
				var listenerArray = listeners[ type ];
	
				if ( listenerArray !== undefined ) {
	
					var index = listenerArray.indexOf( listener );
	
					if ( index !== - 1 ) {
	
						listenerArray.splice( index, 1 );
	
					}
	
				}
	
			},
	
			dispatchEvent: function ( event ) {
	
				if ( this._listeners === undefined ) return;
	
				var listeners = this._listeners;
				var listenerArray = listeners[ event.type ];
	
				if ( listenerArray !== undefined ) {
	
					event.target = this;
	
					var array = listenerArray.slice( 0 );
	
					for ( var i = 0, l = array.length; i < l; i ++ ) {
	
						array[ i ].call( this, event );
	
					}
	
				}
	
			}
	
		} );
	
		var REVISION = '86';
		var MOUSE = { LEFT: 0, MIDDLE: 1, RIGHT: 2 };
		var CullFaceNone = 0;
		var CullFaceBack = 1;
		var CullFaceFront = 2;
		var CullFaceFrontBack = 3;
		var FrontFaceDirectionCW = 0;
		var FrontFaceDirectionCCW = 1;
		var BasicShadowMap = 0;
		var PCFShadowMap = 1;
		var PCFSoftShadowMap = 2;
		var FrontSide = 0;
		var BackSide = 1;
		var DoubleSide = 2;
		var FlatShading = 1;
		var SmoothShading = 2;
		var NoColors = 0;
		var FaceColors = 1;
		var VertexColors = 2;
		var NoBlending = 0;
		var NormalBlending = 1;
		var AdditiveBlending = 2;
		var SubtractiveBlending = 3;
		var MultiplyBlending = 4;
		var CustomBlending = 5;
		var AddEquation = 100;
		var SubtractEquation = 101;
		var ReverseSubtractEquation = 102;
		var MinEquation = 103;
		var MaxEquation = 104;
		var ZeroFactor = 200;
		var OneFactor = 201;
		var SrcColorFactor = 202;
		var OneMinusSrcColorFactor = 203;
		var SrcAlphaFactor = 204;
		var OneMinusSrcAlphaFactor = 205;
		var DstAlphaFactor = 206;
		var OneMinusDstAlphaFactor = 207;
		var DstColorFactor = 208;
		var OneMinusDstColorFactor = 209;
		var SrcAlphaSaturateFactor = 210;
		var NeverDepth = 0;
		var AlwaysDepth = 1;
		var LessDepth = 2;
		var LessEqualDepth = 3;
		var EqualDepth = 4;
		var GreaterEqualDepth = 5;
		var GreaterDepth = 6;
		var NotEqualDepth = 7;
		var MultiplyOperation = 0;
		var MixOperation = 1;
		var AddOperation = 2;
		var NoToneMapping = 0;
		var LinearToneMapping = 1;
		var ReinhardToneMapping = 2;
		var Uncharted2ToneMapping = 3;
		var CineonToneMapping = 4;
		var UVMapping = 300;
		var CubeReflectionMapping = 301;
		var CubeRefractionMapping = 302;
		var EquirectangularReflectionMapping = 303;
		var EquirectangularRefractionMapping = 304;
		var SphericalReflectionMapping = 305;
		var CubeUVReflectionMapping = 306;
		var CubeUVRefractionMapping = 307;
		var RepeatWrapping = 1000;
		var ClampToEdgeWrapping = 1001;
		var MirroredRepeatWrapping = 1002;
		var NearestFilter = 1003;
		var NearestMipMapNearestFilter = 1004;
		var NearestMipMapLinearFilter = 1005;
		var LinearFilter = 1006;
		var LinearMipMapNearestFilter = 1007;
		var LinearMipMapLinearFilter = 1008;
		var UnsignedByteType = 1009;
		var ByteType = 1010;
		var ShortType = 1011;
		var UnsignedShortType = 1012;
		var IntType = 1013;
		var UnsignedIntType = 1014;
		var FloatType = 1015;
		var HalfFloatType = 1016;
		var UnsignedShort4444Type = 1017;
		var UnsignedShort5551Type = 1018;
		var UnsignedShort565Type = 1019;
		var UnsignedInt248Type = 1020;
		var AlphaFormat = 1021;
		var RGBFormat = 1022;
		var RGBAFormat = 1023;
		var LuminanceFormat = 1024;
		var LuminanceAlphaFormat = 1025;
		var RGBEFormat = RGBAFormat;
		var DepthFormat = 1026;
		var DepthStencilFormat = 1027;
		var RGB_S3TC_DXT1_Format = 2001;
		var RGBA_S3TC_DXT1_Format = 2002;
		var RGBA_S3TC_DXT3_Format = 2003;
		var RGBA_S3TC_DXT5_Format = 2004;
		var RGB_PVRTC_4BPPV1_Format = 2100;
		var RGB_PVRTC_2BPPV1_Format = 2101;
		var RGBA_PVRTC_4BPPV1_Format = 2102;
		var RGBA_PVRTC_2BPPV1_Format = 2103;
		var RGB_ETC1_Format = 2151;
		var LoopOnce = 2200;
		var LoopRepeat = 2201;
		var LoopPingPong = 2202;
		var InterpolateDiscrete = 2300;
		var InterpolateLinear = 2301;
		var InterpolateSmooth = 2302;
		var ZeroCurvatureEnding = 2400;
		var ZeroSlopeEnding = 2401;
		var WrapAroundEnding = 2402;
		var TrianglesDrawMode = 0;
		var TriangleStripDrawMode = 1;
		var TriangleFanDrawMode = 2;
		var LinearEncoding = 3000;
		var sRGBEncoding = 3001;
		var GammaEncoding = 3007;
		var RGBEEncoding = 3002;
		var LogLuvEncoding = 3003;
		var RGBM7Encoding = 3004;
		var RGBM16Encoding = 3005;
		var RGBDEncoding = 3006;
		var BasicDepthPacking = 3200;
		var RGBADepthPacking = 3201;
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		var _Math = {
	
			DEG2RAD: Math.PI / 180,
			RAD2DEG: 180 / Math.PI,
	
			generateUUID: function () {
	
				// http://www.broofa.com/Tools/Math.uuid.htm
	
				var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.split( '' );
				var uuid = new Array( 36 );
				var rnd = 0, r;
	
				return function generateUUID() {
	
					for ( var i = 0; i < 36; i ++ ) {
	
						if ( i === 8 || i === 13 || i === 18 || i === 23 ) {
	
							uuid[ i ] = '-';
	
						} else if ( i === 14 ) {
	
							uuid[ i ] = '4';
	
						} else {
	
							if ( rnd <= 0x02 ) rnd = 0x2000000 + ( Math.random() * 0x1000000 ) | 0;
							r = rnd & 0xf;
							rnd = rnd >> 4;
							uuid[ i ] = chars[ ( i === 19 ) ? ( r & 0x3 ) | 0x8 : r ];
	
						}
	
					}
	
					return uuid.join( '' );
	
				};
	
			}(),
	
			clamp: function ( value, min, max ) {
	
				return Math.max( min, Math.min( max, value ) );
	
			},
	
			// compute euclidian modulo of m % n
			// https://en.wikipedia.org/wiki/Modulo_operation
	
			euclideanModulo: function ( n, m ) {
	
				return ( ( n % m ) + m ) % m;
	
			},
	
			// Linear mapping from range <a1, a2> to range <b1, b2>
	
			mapLinear: function ( x, a1, a2, b1, b2 ) {
	
				return b1 + ( x - a1 ) * ( b2 - b1 ) / ( a2 - a1 );
	
			},
	
			// https://en.wikipedia.org/wiki/Linear_interpolation
	
			lerp: function ( x, y, t ) {
	
				return ( 1 - t ) * x + t * y;
	
			},
	
			// http://en.wikipedia.org/wiki/Smoothstep
	
			smoothstep: function ( x, min, max ) {
	
				if ( x <= min ) return 0;
				if ( x >= max ) return 1;
	
				x = ( x - min ) / ( max - min );
	
				return x * x * ( 3 - 2 * x );
	
			},
	
			smootherstep: function ( x, min, max ) {
	
				if ( x <= min ) return 0;
				if ( x >= max ) return 1;
	
				x = ( x - min ) / ( max - min );
	
				return x * x * x * ( x * ( x * 6 - 15 ) + 10 );
	
			},
	
			// Random integer from <low, high> interval
	
			randInt: function ( low, high ) {
	
				return low + Math.floor( Math.random() * ( high - low + 1 ) );
	
			},
	
			// Random float from <low, high> interval
	
			randFloat: function ( low, high ) {
	
				return low + Math.random() * ( high - low );
	
			},
	
			// Random float from <-range/2, range/2> interval
	
			randFloatSpread: function ( range ) {
	
				return range * ( 0.5 - Math.random() );
	
			},
	
			degToRad: function ( degrees ) {
	
				return degrees * _Math.DEG2RAD;
	
			},
	
			radToDeg: function ( radians ) {
	
				return radians * _Math.RAD2DEG;
	
			},
	
			isPowerOfTwo: function ( value ) {
	
				return ( value & ( value - 1 ) ) === 0 && value !== 0;
	
			},
	
			nearestPowerOfTwo: function ( value ) {
	
				return Math.pow( 2, Math.round( Math.log( value ) / Math.LN2 ) );
	
			},
	
			nextPowerOfTwo: function ( value ) {
	
				value --;
				value |= value >> 1;
				value |= value >> 2;
				value |= value >> 4;
				value |= value >> 8;
				value |= value >> 16;
				value ++;
	
				return value;
	
			}
	
		};
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author philogb / http://blog.thejit.org/
		 * @author egraether / http://egraether.com/
		 * @author zz85 / http://www.lab4games.net/zz85/blog
		 */
	
		function Vector2( x, y ) {
	
			this.x = x || 0;
			this.y = y || 0;
	
		}
	
		Object.defineProperties( Vector2.prototype, {
	
			"width" : {
	
				get: function () {
	
					return this.x;
	
				},
	
				set: function ( value ) {
	
					this.x = value;
	
				}
	
			},
	
			"height" : {
	
				get: function () {
	
					return this.y;
	
				},
	
				set: function ( value ) {
	
					this.y = value;
	
				}
	
			}
	
		} );
	
		Object.assign( Vector2.prototype, {
	
			isVector2: true,
	
			set: function ( x, y ) {
	
				this.x = x;
				this.y = y;
	
				return this;
	
			},
	
			setScalar: function ( scalar ) {
	
				this.x = scalar;
				this.y = scalar;
	
				return this;
	
			},
	
			setX: function ( x ) {
	
				this.x = x;
	
				return this;
	
			},
	
			setY: function ( y ) {
	
				this.y = y;
	
				return this;
	
			},
	
			setComponent: function ( index, value ) {
	
				switch ( index ) {
	
					case 0: this.x = value; break;
					case 1: this.y = value; break;
					default: throw new Error( 'index is out of range: ' + index );
	
				}
	
				return this;
	
			},
	
			getComponent: function ( index ) {
	
				switch ( index ) {
	
					case 0: return this.x;
					case 1: return this.y;
					default: throw new Error( 'index is out of range: ' + index );
	
				}
	
			},
	
			clone: function () {
	
				return new this.constructor( this.x, this.y );
	
			},
	
			copy: function ( v ) {
	
				this.x = v.x;
				this.y = v.y;
	
				return this;
	
			},
	
			add: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );
					return this.addVectors( v, w );
	
				}
	
				this.x += v.x;
				this.y += v.y;
	
				return this;
	
			},
	
			addScalar: function ( s ) {
	
				this.x += s;
				this.y += s;
	
				return this;
	
			},
	
			addVectors: function ( a, b ) {
	
				this.x = a.x + b.x;
				this.y = a.y + b.y;
	
				return this;
	
			},
	
			addScaledVector: function ( v, s ) {
	
				this.x += v.x * s;
				this.y += v.y * s;
	
				return this;
	
			},
	
			sub: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );
					return this.subVectors( v, w );
	
				}
	
				this.x -= v.x;
				this.y -= v.y;
	
				return this;
	
			},
	
			subScalar: function ( s ) {
	
				this.x -= s;
				this.y -= s;
	
				return this;
	
			},
	
			subVectors: function ( a, b ) {
	
				this.x = a.x - b.x;
				this.y = a.y - b.y;
	
				return this;
	
			},
	
			multiply: function ( v ) {
	
				this.x *= v.x;
				this.y *= v.y;
	
				return this;
	
			},
	
			multiplyScalar: function ( scalar ) {
	
				this.x *= scalar;
				this.y *= scalar;
	
				return this;
	
			},
	
			divide: function ( v ) {
	
				this.x /= v.x;
				this.y /= v.y;
	
				return this;
	
			},
	
			divideScalar: function ( scalar ) {
	
				return this.multiplyScalar( 1 / scalar );
	
			},
	
			min: function ( v ) {
	
				this.x = Math.min( this.x, v.x );
				this.y = Math.min( this.y, v.y );
	
				return this;
	
			},
	
			max: function ( v ) {
	
				this.x = Math.max( this.x, v.x );
				this.y = Math.max( this.y, v.y );
	
				return this;
	
			},
	
			clamp: function ( min, max ) {
	
				// assumes min < max, componentwise
	
				this.x = Math.max( min.x, Math.min( max.x, this.x ) );
				this.y = Math.max( min.y, Math.min( max.y, this.y ) );
	
				return this;
	
			},
	
			clampScalar: function () {
	
				var min = new Vector2();
				var max = new Vector2();
	
				return function clampScalar( minVal, maxVal ) {
	
					min.set( minVal, minVal );
					max.set( maxVal, maxVal );
	
					return this.clamp( min, max );
	
				};
	
			}(),
	
			clampLength: function ( min, max ) {
	
				var length = this.length();
	
				return this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );
	
			},
	
			floor: function () {
	
				this.x = Math.floor( this.x );
				this.y = Math.floor( this.y );
	
				return this;
	
			},
	
			ceil: function () {
	
				this.x = Math.ceil( this.x );
				this.y = Math.ceil( this.y );
	
				return this;
	
			},
	
			round: function () {
	
				this.x = Math.round( this.x );
				this.y = Math.round( this.y );
	
				return this;
	
			},
	
			roundToZero: function () {
	
				this.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );
				this.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );
	
				return this;
	
			},
	
			negate: function () {
	
				this.x = - this.x;
				this.y = - this.y;
	
				return this;
	
			},
	
			dot: function ( v ) {
	
				return this.x * v.x + this.y * v.y;
	
			},
	
			lengthSq: function () {
	
				return this.x * this.x + this.y * this.y;
	
			},
	
			length: function () {
	
				return Math.sqrt( this.x * this.x + this.y * this.y );
	
			},
	
			lengthManhattan: function() {
	
				return Math.abs( this.x ) + Math.abs( this.y );
	
			},
	
			normalize: function () {
	
				return this.divideScalar( this.length() || 1 );
	
			},
	
			angle: function () {
	
				// computes the angle in radians with respect to the positive x-axis
	
				var angle = Math.atan2( this.y, this.x );
	
				if ( angle < 0 ) angle += 2 * Math.PI;
	
				return angle;
	
			},
	
			distanceTo: function ( v ) {
	
				return Math.sqrt( this.distanceToSquared( v ) );
	
			},
	
			distanceToSquared: function ( v ) {
	
				var dx = this.x - v.x, dy = this.y - v.y;
				return dx * dx + dy * dy;
	
			},
	
			distanceToManhattan: function ( v ) {
	
				return Math.abs( this.x - v.x ) + Math.abs( this.y - v.y );
	
			},
	
			setLength: function ( length ) {
	
				return this.normalize().multiplyScalar( length );
	
			},
	
			lerp: function ( v, alpha ) {
	
				this.x += ( v.x - this.x ) * alpha;
				this.y += ( v.y - this.y ) * alpha;
	
				return this;
	
			},
	
			lerpVectors: function ( v1, v2, alpha ) {
	
				return this.subVectors( v2, v1 ).multiplyScalar( alpha ).add( v1 );
	
			},
	
			equals: function ( v ) {
	
				return ( ( v.x === this.x ) && ( v.y === this.y ) );
	
			},
	
			fromArray: function ( array, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				this.x = array[ offset ];
				this.y = array[ offset + 1 ];
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				array[ offset ] = this.x;
				array[ offset + 1 ] = this.y;
	
				return array;
	
			},
	
			fromBufferAttribute: function ( attribute, index, offset ) {
	
				if ( offset !== undefined ) {
	
					console.warn( 'THREE.Vector2: offset has been removed from .fromBufferAttribute().' );
	
				}
	
				this.x = attribute.getX( index );
				this.y = attribute.getY( index );
	
				return this;
	
			},
	
			rotateAround: function ( center, angle ) {
	
				var c = Math.cos( angle ), s = Math.sin( angle );
	
				var x = this.x - center.x;
				var y = this.y - center.y;
	
				this.x = x * c - y * s + center.x;
				this.y = x * s + y * c + center.y;
	
				return this;
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author alteredq / http://alteredqualia.com/
		 * @author szimek / https://github.com/szimek/
		 */
	
		var textureId = 0;
	
		function Texture( image, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding ) {
	
			Object.defineProperty( this, 'id', { value: textureId ++ } );
	
			this.uuid = _Math.generateUUID();
	
			this.name = '';
	
			this.image = image !== undefined ? image : Texture.DEFAULT_IMAGE;
			this.mipmaps = [];
	
			this.mapping = mapping !== undefined ? mapping : Texture.DEFAULT_MAPPING;
	
			this.wrapS = wrapS !== undefined ? wrapS : ClampToEdgeWrapping;
			this.wrapT = wrapT !== undefined ? wrapT : ClampToEdgeWrapping;
	
			this.magFilter = magFilter !== undefined ? magFilter : LinearFilter;
			this.minFilter = minFilter !== undefined ? minFilter : LinearMipMapLinearFilter;
	
			this.anisotropy = anisotropy !== undefined ? anisotropy : 1;
	
			this.format = format !== undefined ? format : RGBAFormat;
			this.type = type !== undefined ? type : UnsignedByteType;
	
			this.offset = new Vector2( 0, 0 );
			this.repeat = new Vector2( 1, 1 );
	
			this.generateMipmaps = true;
			this.premultiplyAlpha = false;
			this.flipY = true;
			this.unpackAlignment = 4;	// valid values: 1, 2, 4, 8 (see http://www.khronos.org/opengles/sdk/docs/man/xhtml/glPixelStorei.xml)
	
			// Values of encoding !== THREE.LinearEncoding only supported on map, envMap and emissiveMap.
			//
			// Also changing the encoding after already used by a Material will not automatically make the Material
			// update.  You need to explicitly call Material.needsUpdate to trigger it to recompile.
			this.encoding = encoding !== undefined ? encoding : LinearEncoding;
	
			this.version = 0;
			this.onUpdate = null;
	
		}
	
		Texture.DEFAULT_IMAGE = undefined;
		Texture.DEFAULT_MAPPING = UVMapping;
	
		Object.defineProperty( Texture.prototype, "needsUpdate", {
	
			set: function ( value ) {
	
				if ( value === true ) this.version ++;
	
			}
	
		} );
	
		Object.assign( Texture.prototype, EventDispatcher.prototype, {
	
			constructor: Texture,
	
			isTexture: true,
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( source ) {
	
				this.name = source.name;
	
				this.image = source.image;
				this.mipmaps = source.mipmaps.slice( 0 );
	
				this.mapping = source.mapping;
	
				this.wrapS = source.wrapS;
				this.wrapT = source.wrapT;
	
				this.magFilter = source.magFilter;
				this.minFilter = source.minFilter;
	
				this.anisotropy = source.anisotropy;
	
				this.format = source.format;
				this.type = source.type;
	
				this.offset.copy( source.offset );
				this.repeat.copy( source.repeat );
	
				this.generateMipmaps = source.generateMipmaps;
				this.premultiplyAlpha = source.premultiplyAlpha;
				this.flipY = source.flipY;
				this.unpackAlignment = source.unpackAlignment;
				this.encoding = source.encoding;
	
				return this;
	
			},
	
			toJSON: function ( meta ) {
	
				if ( meta.textures[ this.uuid ] !== undefined ) {
	
					return meta.textures[ this.uuid ];
	
				}
	
				function getDataURL( image ) {
	
					var canvas;
	
					if ( image.toDataURL !== undefined ) {
	
						canvas = image;
	
					} else {
	
						canvas = document.createElementNS( 'http://www.w3.org/1999/xhtml', 'canvas' );
						canvas.width = image.width;
						canvas.height = image.height;
	
						canvas.getContext( '2d' ).drawImage( image, 0, 0, image.width, image.height );
	
					}
	
					if ( canvas.width > 2048 || canvas.height > 2048 ) {
	
						return canvas.toDataURL( 'image/jpeg', 0.6 );
	
					} else {
	
						return canvas.toDataURL( 'image/png' );
	
					}
	
				}
	
				var output = {
					metadata: {
						version: 4.5,
						type: 'Texture',
						generator: 'Texture.toJSON'
					},
	
					uuid: this.uuid,
					name: this.name,
	
					mapping: this.mapping,
	
					repeat: [ this.repeat.x, this.repeat.y ],
					offset: [ this.offset.x, this.offset.y ],
					wrap: [ this.wrapS, this.wrapT ],
	
					minFilter: this.minFilter,
					magFilter: this.magFilter,
					anisotropy: this.anisotropy,
	
					flipY: this.flipY
				};
	
				if ( this.image !== undefined ) {
	
					// TODO: Move to THREE.Image
	
					var image = this.image;
	
					if ( image.uuid === undefined ) {
	
						image.uuid = _Math.generateUUID(); // UGH
	
					}
	
					if ( meta.images[ image.uuid ] === undefined ) {
	
						meta.images[ image.uuid ] = {
							uuid: image.uuid,
							url: getDataURL( image )
						};
	
					}
	
					output.image = image.uuid;
	
				}
	
				meta.textures[ this.uuid ] = output;
	
				return output;
	
			},
	
			dispose: function () {
	
				this.dispatchEvent( { type: 'dispose' } );
	
			},
	
			transformUv: function ( uv ) {
	
				if ( this.mapping !== UVMapping ) return;
	
				uv.multiply( this.repeat );
				uv.add( this.offset );
	
				if ( uv.x < 0 || uv.x > 1 ) {
	
					switch ( this.wrapS ) {
	
						case RepeatWrapping:
	
							uv.x = uv.x - Math.floor( uv.x );
							break;
	
						case ClampToEdgeWrapping:
	
							uv.x = uv.x < 0 ? 0 : 1;
							break;
	
						case MirroredRepeatWrapping:
	
							if ( Math.abs( Math.floor( uv.x ) % 2 ) === 1 ) {
	
								uv.x = Math.ceil( uv.x ) - uv.x;
	
							} else {
	
								uv.x = uv.x - Math.floor( uv.x );
	
							}
							break;
	
					}
	
				}
	
				if ( uv.y < 0 || uv.y > 1 ) {
	
					switch ( this.wrapT ) {
	
						case RepeatWrapping:
	
							uv.y = uv.y - Math.floor( uv.y );
							break;
	
						case ClampToEdgeWrapping:
	
							uv.y = uv.y < 0 ? 0 : 1;
							break;
	
						case MirroredRepeatWrapping:
	
							if ( Math.abs( Math.floor( uv.y ) % 2 ) === 1 ) {
	
								uv.y = Math.ceil( uv.y ) - uv.y;
	
							} else {
	
								uv.y = uv.y - Math.floor( uv.y );
	
							}
							break;
	
					}
	
				}
	
				if ( this.flipY ) {
	
					uv.y = 1 - uv.y;
	
				}
	
			}
	
		} );
	
		/**
		 * @author supereggbert / http://www.paulbrunt.co.uk/
		 * @author philogb / http://blog.thejit.org/
		 * @author mikael emtinger / http://gomo.se/
		 * @author egraether / http://egraether.com/
		 * @author WestLangley / http://github.com/WestLangley
		 */
	
		function Vector4( x, y, z, w ) {
	
			this.x = x || 0;
			this.y = y || 0;
			this.z = z || 0;
			this.w = ( w !== undefined ) ? w : 1;
	
		}
	
		Object.assign( Vector4.prototype, {
	
			isVector4: true,
	
			set: function ( x, y, z, w ) {
	
				this.x = x;
				this.y = y;
				this.z = z;
				this.w = w;
	
				return this;
	
			},
	
			setScalar: function ( scalar ) {
	
				this.x = scalar;
				this.y = scalar;
				this.z = scalar;
				this.w = scalar;
	
				return this;
	
			},
	
			setX: function ( x ) {
	
				this.x = x;
	
				return this;
	
			},
	
			setY: function ( y ) {
	
				this.y = y;
	
				return this;
	
			},
	
			setZ: function ( z ) {
	
				this.z = z;
	
				return this;
	
			},
	
			setW: function ( w ) {
	
				this.w = w;
	
				return this;
	
			},
	
			setComponent: function ( index, value ) {
	
				switch ( index ) {
	
					case 0: this.x = value; break;
					case 1: this.y = value; break;
					case 2: this.z = value; break;
					case 3: this.w = value; break;
					default: throw new Error( 'index is out of range: ' + index );
	
				}
	
				return this;
	
			},
	
			getComponent: function ( index ) {
	
				switch ( index ) {
	
					case 0: return this.x;
					case 1: return this.y;
					case 2: return this.z;
					case 3: return this.w;
					default: throw new Error( 'index is out of range: ' + index );
	
				}
	
			},
	
			clone: function () {
	
				return new this.constructor( this.x, this.y, this.z, this.w );
	
			},
	
			copy: function ( v ) {
	
				this.x = v.x;
				this.y = v.y;
				this.z = v.z;
				this.w = ( v.w !== undefined ) ? v.w : 1;
	
				return this;
	
			},
	
			add: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );
					return this.addVectors( v, w );
	
				}
	
				this.x += v.x;
				this.y += v.y;
				this.z += v.z;
				this.w += v.w;
	
				return this;
	
			},
	
			addScalar: function ( s ) {
	
				this.x += s;
				this.y += s;
				this.z += s;
				this.w += s;
	
				return this;
	
			},
	
			addVectors: function ( a, b ) {
	
				this.x = a.x + b.x;
				this.y = a.y + b.y;
				this.z = a.z + b.z;
				this.w = a.w + b.w;
	
				return this;
	
			},
	
			addScaledVector: function ( v, s ) {
	
				this.x += v.x * s;
				this.y += v.y * s;
				this.z += v.z * s;
				this.w += v.w * s;
	
				return this;
	
			},
	
			sub: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );
					return this.subVectors( v, w );
	
				}
	
				this.x -= v.x;
				this.y -= v.y;
				this.z -= v.z;
				this.w -= v.w;
	
				return this;
	
			},
	
			subScalar: function ( s ) {
	
				this.x -= s;
				this.y -= s;
				this.z -= s;
				this.w -= s;
	
				return this;
	
			},
	
			subVectors: function ( a, b ) {
	
				this.x = a.x - b.x;
				this.y = a.y - b.y;
				this.z = a.z - b.z;
				this.w = a.w - b.w;
	
				return this;
	
			},
	
			multiplyScalar: function ( scalar ) {
	
				this.x *= scalar;
				this.y *= scalar;
				this.z *= scalar;
				this.w *= scalar;
	
				return this;
	
			},
	
			applyMatrix4: function ( m ) {
	
				var x = this.x, y = this.y, z = this.z, w = this.w;
				var e = m.elements;
	
				this.x = e[ 0 ] * x + e[ 4 ] * y + e[ 8 ] * z + e[ 12 ] * w;
				this.y = e[ 1 ] * x + e[ 5 ] * y + e[ 9 ] * z + e[ 13 ] * w;
				this.z = e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z + e[ 14 ] * w;
				this.w = e[ 3 ] * x + e[ 7 ] * y + e[ 11 ] * z + e[ 15 ] * w;
	
				return this;
	
			},
	
			divideScalar: function ( scalar ) {
	
				return this.multiplyScalar( 1 / scalar );
	
			},
	
			setAxisAngleFromQuaternion: function ( q ) {
	
				// http://www.euclideanspace.com/maths/geometry/rotations/conversions/quaternionToAngle/index.htm
	
				// q is assumed to be normalized
	
				this.w = 2 * Math.acos( q.w );
	
				var s = Math.sqrt( 1 - q.w * q.w );
	
				if ( s < 0.0001 ) {
	
					 this.x = 1;
					 this.y = 0;
					 this.z = 0;
	
				} else {
	
					 this.x = q.x / s;
					 this.y = q.y / s;
					 this.z = q.z / s;
	
				}
	
				return this;
	
			},
	
			setAxisAngleFromRotationMatrix: function ( m ) {
	
				// http://www.euclideanspace.com/maths/geometry/rotations/conversions/matrixToAngle/index.htm
	
				// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)
	
				var angle, x, y, z,		// variables for result
					epsilon = 0.01,		// margin to allow for rounding errors
					epsilon2 = 0.1,		// margin to distinguish between 0 and 180 degrees
	
					te = m.elements,
	
					m11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ],
					m21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ],
					m31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ];
	
				if ( ( Math.abs( m12 - m21 ) < epsilon ) &&
				     ( Math.abs( m13 - m31 ) < epsilon ) &&
				     ( Math.abs( m23 - m32 ) < epsilon ) ) {
	
					// singularity found
					// first check for identity matrix which must have +1 for all terms
					// in leading diagonal and zero in other terms
	
					if ( ( Math.abs( m12 + m21 ) < epsilon2 ) &&
					     ( Math.abs( m13 + m31 ) < epsilon2 ) &&
					     ( Math.abs( m23 + m32 ) < epsilon2 ) &&
					     ( Math.abs( m11 + m22 + m33 - 3 ) < epsilon2 ) ) {
	
						// this singularity is identity matrix so angle = 0
	
						this.set( 1, 0, 0, 0 );
	
						return this; // zero angle, arbitrary axis
	
					}
	
					// otherwise this singularity is angle = 180
	
					angle = Math.PI;
	
					var xx = ( m11 + 1 ) / 2;
					var yy = ( m22 + 1 ) / 2;
					var zz = ( m33 + 1 ) / 2;
					var xy = ( m12 + m21 ) / 4;
					var xz = ( m13 + m31 ) / 4;
					var yz = ( m23 + m32 ) / 4;
	
					if ( ( xx > yy ) && ( xx > zz ) ) {
	
						// m11 is the largest diagonal term
	
						if ( xx < epsilon ) {
	
							x = 0;
							y = 0.707106781;
							z = 0.707106781;
	
						} else {
	
							x = Math.sqrt( xx );
							y = xy / x;
							z = xz / x;
	
						}
	
					} else if ( yy > zz ) {
	
						// m22 is the largest diagonal term
	
						if ( yy < epsilon ) {
	
							x = 0.707106781;
							y = 0;
							z = 0.707106781;
	
						} else {
	
							y = Math.sqrt( yy );
							x = xy / y;
							z = yz / y;
	
						}
	
					} else {
	
						// m33 is the largest diagonal term so base result on this
	
						if ( zz < epsilon ) {
	
							x = 0.707106781;
							y = 0.707106781;
							z = 0;
	
						} else {
	
							z = Math.sqrt( zz );
							x = xz / z;
							y = yz / z;
	
						}
	
					}
	
					this.set( x, y, z, angle );
	
					return this; // return 180 deg rotation
	
				}
	
				// as we have reached here there are no singularities so we can handle normally
	
				var s = Math.sqrt( ( m32 - m23 ) * ( m32 - m23 ) +
				                   ( m13 - m31 ) * ( m13 - m31 ) +
				                   ( m21 - m12 ) * ( m21 - m12 ) ); // used to normalize
	
				if ( Math.abs( s ) < 0.001 ) s = 1;
	
				// prevent divide by zero, should not happen if matrix is orthogonal and should be
				// caught by singularity test above, but I've left it in just in case
	
				this.x = ( m32 - m23 ) / s;
				this.y = ( m13 - m31 ) / s;
				this.z = ( m21 - m12 ) / s;
				this.w = Math.acos( ( m11 + m22 + m33 - 1 ) / 2 );
	
				return this;
	
			},
	
			min: function ( v ) {
	
				this.x = Math.min( this.x, v.x );
				this.y = Math.min( this.y, v.y );
				this.z = Math.min( this.z, v.z );
				this.w = Math.min( this.w, v.w );
	
				return this;
	
			},
	
			max: function ( v ) {
	
				this.x = Math.max( this.x, v.x );
				this.y = Math.max( this.y, v.y );
				this.z = Math.max( this.z, v.z );
				this.w = Math.max( this.w, v.w );
	
				return this;
	
			},
	
			clamp: function ( min, max ) {
	
				// assumes min < max, componentwise
	
				this.x = Math.max( min.x, Math.min( max.x, this.x ) );
				this.y = Math.max( min.y, Math.min( max.y, this.y ) );
				this.z = Math.max( min.z, Math.min( max.z, this.z ) );
				this.w = Math.max( min.w, Math.min( max.w, this.w ) );
	
				return this;
	
			},
	
			clampScalar: function () {
	
				var min, max;
	
				return function clampScalar( minVal, maxVal ) {
	
					if ( min === undefined ) {
	
						min = new Vector4();
						max = new Vector4();
	
					}
	
					min.set( minVal, minVal, minVal, minVal );
					max.set( maxVal, maxVal, maxVal, maxVal );
	
					return this.clamp( min, max );
	
				};
	
			}(),
	
			clampLength: function ( min, max ) {
	
				var length = this.length();
	
				return this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );
	
			},
	
			floor: function () {
	
				this.x = Math.floor( this.x );
				this.y = Math.floor( this.y );
				this.z = Math.floor( this.z );
				this.w = Math.floor( this.w );
	
				return this;
	
			},
	
			ceil: function () {
	
				this.x = Math.ceil( this.x );
				this.y = Math.ceil( this.y );
				this.z = Math.ceil( this.z );
				this.w = Math.ceil( this.w );
	
				return this;
	
			},
	
			round: function () {
	
				this.x = Math.round( this.x );
				this.y = Math.round( this.y );
				this.z = Math.round( this.z );
				this.w = Math.round( this.w );
	
				return this;
	
			},
	
			roundToZero: function () {
	
				this.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );
				this.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );
				this.z = ( this.z < 0 ) ? Math.ceil( this.z ) : Math.floor( this.z );
				this.w = ( this.w < 0 ) ? Math.ceil( this.w ) : Math.floor( this.w );
	
				return this;
	
			},
	
			negate: function () {
	
				this.x = - this.x;
				this.y = - this.y;
				this.z = - this.z;
				this.w = - this.w;
	
				return this;
	
			},
	
			dot: function ( v ) {
	
				return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
	
			},
	
			lengthSq: function () {
	
				return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
	
			},
	
			length: function () {
	
				return Math.sqrt( this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w );
	
			},
	
			lengthManhattan: function () {
	
				return Math.abs( this.x ) + Math.abs( this.y ) + Math.abs( this.z ) + Math.abs( this.w );
	
			},
	
			normalize: function () {
	
				return this.divideScalar( this.length() || 1 );
	
			},
	
			setLength: function ( length ) {
	
				return this.normalize().multiplyScalar( length );
	
			},
	
			lerp: function ( v, alpha ) {
	
				this.x += ( v.x - this.x ) * alpha;
				this.y += ( v.y - this.y ) * alpha;
				this.z += ( v.z - this.z ) * alpha;
				this.w += ( v.w - this.w ) * alpha;
	
				return this;
	
			},
	
			lerpVectors: function ( v1, v2, alpha ) {
	
				return this.subVectors( v2, v1 ).multiplyScalar( alpha ).add( v1 );
	
			},
	
			equals: function ( v ) {
	
				return ( ( v.x === this.x ) && ( v.y === this.y ) && ( v.z === this.z ) && ( v.w === this.w ) );
	
			},
	
			fromArray: function ( array, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				this.x = array[ offset ];
				this.y = array[ offset + 1 ];
				this.z = array[ offset + 2 ];
				this.w = array[ offset + 3 ];
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				array[ offset ] = this.x;
				array[ offset + 1 ] = this.y;
				array[ offset + 2 ] = this.z;
				array[ offset + 3 ] = this.w;
	
				return array;
	
			},
	
			fromBufferAttribute: function ( attribute, index, offset ) {
	
				if ( offset !== undefined ) {
	
					console.warn( 'THREE.Vector4: offset has been removed from .fromBufferAttribute().' );
	
				}
	
				this.x = attribute.getX( index );
				this.y = attribute.getY( index );
				this.z = attribute.getZ( index );
				this.w = attribute.getW( index );
	
				return this;
	
			}
	
		} );
	
		/**
		 * @author szimek / https://github.com/szimek/
		 * @author alteredq / http://alteredqualia.com/
		 * @author Marius Kintel / https://github.com/kintel
		 */
	
		/*
		 In options, we can specify:
		 * Texture parameters for an auto-generated target texture
		 * depthBuffer/stencilBuffer: Booleans to indicate if we should generate these buffers
		*/
		function WebGLRenderTarget( width, height, options ) {
	
			this.uuid = _Math.generateUUID();
	
			this.width = width;
			this.height = height;
	
			this.scissor = new Vector4( 0, 0, width, height );
			this.scissorTest = false;
	
			this.viewport = new Vector4( 0, 0, width, height );
	
			options = options || {};
	
			if ( options.minFilter === undefined ) options.minFilter = LinearFilter;
	
			this.texture = new Texture( undefined, undefined, options.wrapS, options.wrapT, options.magFilter, options.minFilter, options.format, options.type, options.anisotropy, options.encoding );
	
			this.depthBuffer = options.depthBuffer !== undefined ? options.depthBuffer : true;
			this.stencilBuffer = options.stencilBuffer !== undefined ? options.stencilBuffer : true;
			this.depthTexture = options.depthTexture !== undefined ? options.depthTexture : null;
	
		}
	
		Object.assign( WebGLRenderTarget.prototype, EventDispatcher.prototype, {
	
			isWebGLRenderTarget: true,
	
			setSize: function ( width, height ) {
	
				if ( this.width !== width || this.height !== height ) {
	
					this.width = width;
					this.height = height;
	
					this.dispose();
	
				}
	
				this.viewport.set( 0, 0, width, height );
				this.scissor.set( 0, 0, width, height );
	
			},
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( source ) {
	
				this.width = source.width;
				this.height = source.height;
	
				this.viewport.copy( source.viewport );
	
				this.texture = source.texture.clone();
	
				this.depthBuffer = source.depthBuffer;
				this.stencilBuffer = source.stencilBuffer;
				this.depthTexture = source.depthTexture;
	
				return this;
	
			},
	
			dispose: function () {
	
				this.dispatchEvent( { type: 'dispose' } );
	
			}
	
		} );
	
		/**
		 * @author alteredq / http://alteredqualia.com
		 */
	
		function WebGLRenderTargetCube( width, height, options ) {
	
			WebGLRenderTarget.call( this, width, height, options );
	
			this.activeCubeFace = 0; // PX 0, NX 1, PY 2, NY 3, PZ 4, NZ 5
			this.activeMipMapLevel = 0;
	
		}
	
		WebGLRenderTargetCube.prototype = Object.create( WebGLRenderTarget.prototype );
		WebGLRenderTargetCube.prototype.constructor = WebGLRenderTargetCube;
	
		WebGLRenderTargetCube.prototype.isWebGLRenderTargetCube = true;
	
		/**
		 * @author mikael emtinger / http://gomo.se/
		 * @author alteredq / http://alteredqualia.com/
		 * @author WestLangley / http://github.com/WestLangley
		 * @author bhouston / http://clara.io
		 */
	
		function Quaternion( x, y, z, w ) {
	
			this._x = x || 0;
			this._y = y || 0;
			this._z = z || 0;
			this._w = ( w !== undefined ) ? w : 1;
	
		}
	
		Object.assign( Quaternion, {
	
			slerp: function ( qa, qb, qm, t ) {
	
				return qm.copy( qa ).slerp( qb, t );
	
			},
	
			slerpFlat: function ( dst, dstOffset, src0, srcOffset0, src1, srcOffset1, t ) {
	
				// fuzz-free, array-based Quaternion SLERP operation
	
				var x0 = src0[ srcOffset0 + 0 ],
					y0 = src0[ srcOffset0 + 1 ],
					z0 = src0[ srcOffset0 + 2 ],
					w0 = src0[ srcOffset0 + 3 ],
	
					x1 = src1[ srcOffset1 + 0 ],
					y1 = src1[ srcOffset1 + 1 ],
					z1 = src1[ srcOffset1 + 2 ],
					w1 = src1[ srcOffset1 + 3 ];
	
				if ( w0 !== w1 || x0 !== x1 || y0 !== y1 || z0 !== z1 ) {
	
					var s = 1 - t,
	
						cos = x0 * x1 + y0 * y1 + z0 * z1 + w0 * w1,
	
						dir = ( cos >= 0 ? 1 : - 1 ),
						sqrSin = 1 - cos * cos;
	
					// Skip the Slerp for tiny steps to avoid numeric problems:
					if ( sqrSin > Number.EPSILON ) {
	
						var sin = Math.sqrt( sqrSin ),
							len = Math.atan2( sin, cos * dir );
	
						s = Math.sin( s * len ) / sin;
						t = Math.sin( t * len ) / sin;
	
					}
	
					var tDir = t * dir;
	
					x0 = x0 * s + x1 * tDir;
					y0 = y0 * s + y1 * tDir;
					z0 = z0 * s + z1 * tDir;
					w0 = w0 * s + w1 * tDir;
	
					// Normalize in case we just did a lerp:
					if ( s === 1 - t ) {
	
						var f = 1 / Math.sqrt( x0 * x0 + y0 * y0 + z0 * z0 + w0 * w0 );
	
						x0 *= f;
						y0 *= f;
						z0 *= f;
						w0 *= f;
	
					}
	
				}
	
				dst[ dstOffset ] = x0;
				dst[ dstOffset + 1 ] = y0;
				dst[ dstOffset + 2 ] = z0;
				dst[ dstOffset + 3 ] = w0;
	
			}
	
		} );
	
		Object.defineProperties( Quaternion.prototype, {
	
			x: {
	
				get: function () {
	
					return this._x;
	
				},
	
				set: function ( value ) {
	
					this._x = value;
					this.onChangeCallback();
	
				}
	
			},
	
			y: {
	
				get: function () {
	
					return this._y;
	
				},
	
				set: function ( value ) {
	
					this._y = value;
					this.onChangeCallback();
	
				}
	
			},
	
			z: {
	
				get: function () {
	
					return this._z;
	
				},
	
				set: function ( value ) {
	
					this._z = value;
					this.onChangeCallback();
	
				}
	
			},
	
			w: {
	
				get: function () {
	
					return this._w;
	
				},
	
				set: function ( value ) {
	
					this._w = value;
					this.onChangeCallback();
	
				}
	
			}
	
		} );
	
		Object.assign( Quaternion.prototype, {
	
			set: function ( x, y, z, w ) {
	
				this._x = x;
				this._y = y;
				this._z = z;
				this._w = w;
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			clone: function () {
	
				return new this.constructor( this._x, this._y, this._z, this._w );
	
			},
	
			copy: function ( quaternion ) {
	
				this._x = quaternion.x;
				this._y = quaternion.y;
				this._z = quaternion.z;
				this._w = quaternion.w;
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			setFromEuler: function ( euler, update ) {
	
				if ( ! ( euler && euler.isEuler ) ) {
	
					throw new Error( 'THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.' );
	
				}
	
				var x = euler._x, y = euler._y, z = euler._z, order = euler.order;
	
				// http://www.mathworks.com/matlabcentral/fileexchange/
				// 	20696-function-to-convert-between-dcm-euler-angles-quaternions-and-euler-vectors/
				//	content/SpinCalc.m
	
				var cos = Math.cos;
				var sin = Math.sin;
	
				var c1 = cos( x / 2 );
				var c2 = cos( y / 2 );
				var c3 = cos( z / 2 );
	
				var s1 = sin( x / 2 );
				var s2 = sin( y / 2 );
				var s3 = sin( z / 2 );
	
				if ( order === 'XYZ' ) {
	
					this._x = s1 * c2 * c3 + c1 * s2 * s3;
					this._y = c1 * s2 * c3 - s1 * c2 * s3;
					this._z = c1 * c2 * s3 + s1 * s2 * c3;
					this._w = c1 * c2 * c3 - s1 * s2 * s3;
	
				} else if ( order === 'YXZ' ) {
	
					this._x = s1 * c2 * c3 + c1 * s2 * s3;
					this._y = c1 * s2 * c3 - s1 * c2 * s3;
					this._z = c1 * c2 * s3 - s1 * s2 * c3;
					this._w = c1 * c2 * c3 + s1 * s2 * s3;
	
				} else if ( order === 'ZXY' ) {
	
					this._x = s1 * c2 * c3 - c1 * s2 * s3;
					this._y = c1 * s2 * c3 + s1 * c2 * s3;
					this._z = c1 * c2 * s3 + s1 * s2 * c3;
					this._w = c1 * c2 * c3 - s1 * s2 * s3;
	
				} else if ( order === 'ZYX' ) {
	
					this._x = s1 * c2 * c3 - c1 * s2 * s3;
					this._y = c1 * s2 * c3 + s1 * c2 * s3;
					this._z = c1 * c2 * s3 - s1 * s2 * c3;
					this._w = c1 * c2 * c3 + s1 * s2 * s3;
	
				} else if ( order === 'YZX' ) {
	
					this._x = s1 * c2 * c3 + c1 * s2 * s3;
					this._y = c1 * s2 * c3 + s1 * c2 * s3;
					this._z = c1 * c2 * s3 - s1 * s2 * c3;
					this._w = c1 * c2 * c3 - s1 * s2 * s3;
	
				} else if ( order === 'XZY' ) {
	
					this._x = s1 * c2 * c3 - c1 * s2 * s3;
					this._y = c1 * s2 * c3 - s1 * c2 * s3;
					this._z = c1 * c2 * s3 + s1 * s2 * c3;
					this._w = c1 * c2 * c3 + s1 * s2 * s3;
	
				}
	
				if ( update !== false ) this.onChangeCallback();
	
				return this;
	
			},
	
			setFromAxisAngle: function ( axis, angle ) {
	
				// http://www.euclideanspace.com/maths/geometry/rotations/conversions/angleToQuaternion/index.htm
	
				// assumes axis is normalized
	
				var halfAngle = angle / 2, s = Math.sin( halfAngle );
	
				this._x = axis.x * s;
				this._y = axis.y * s;
				this._z = axis.z * s;
				this._w = Math.cos( halfAngle );
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			setFromRotationMatrix: function ( m ) {
	
				// http://www.euclideanspace.com/maths/geometry/rotations/conversions/matrixToQuaternion/index.htm
	
				// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)
	
				var te = m.elements,
	
					m11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ],
					m21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ],
					m31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ],
	
					trace = m11 + m22 + m33,
					s;
	
				if ( trace > 0 ) {
	
					s = 0.5 / Math.sqrt( trace + 1.0 );
	
					this._w = 0.25 / s;
					this._x = ( m32 - m23 ) * s;
					this._y = ( m13 - m31 ) * s;
					this._z = ( m21 - m12 ) * s;
	
				} else if ( m11 > m22 && m11 > m33 ) {
	
					s = 2.0 * Math.sqrt( 1.0 + m11 - m22 - m33 );
	
					this._w = ( m32 - m23 ) / s;
					this._x = 0.25 * s;
					this._y = ( m12 + m21 ) / s;
					this._z = ( m13 + m31 ) / s;
	
				} else if ( m22 > m33 ) {
	
					s = 2.0 * Math.sqrt( 1.0 + m22 - m11 - m33 );
	
					this._w = ( m13 - m31 ) / s;
					this._x = ( m12 + m21 ) / s;
					this._y = 0.25 * s;
					this._z = ( m23 + m32 ) / s;
	
				} else {
	
					s = 2.0 * Math.sqrt( 1.0 + m33 - m11 - m22 );
	
					this._w = ( m21 - m12 ) / s;
					this._x = ( m13 + m31 ) / s;
					this._y = ( m23 + m32 ) / s;
					this._z = 0.25 * s;
	
				}
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			setFromUnitVectors: function () {
	
				// assumes direction vectors vFrom and vTo are normalized
	
				var v1 = new Vector3();
				var r;
	
				var EPS = 0.000001;
	
				return function setFromUnitVectors( vFrom, vTo ) {
	
					if ( v1 === undefined ) v1 = new Vector3();
	
					r = vFrom.dot( vTo ) + 1;
	
					if ( r < EPS ) {
	
						r = 0;
	
						if ( Math.abs( vFrom.x ) > Math.abs( vFrom.z ) ) {
	
							v1.set( - vFrom.y, vFrom.x, 0 );
	
						} else {
	
							v1.set( 0, - vFrom.z, vFrom.y );
	
						}
	
					} else {
	
						v1.crossVectors( vFrom, vTo );
	
					}
	
					this._x = v1.x;
					this._y = v1.y;
					this._z = v1.z;
					this._w = r;
	
					return this.normalize();
	
				};
	
			}(),
	
			inverse: function () {
	
				return this.conjugate().normalize();
	
			},
	
			conjugate: function () {
	
				this._x *= - 1;
				this._y *= - 1;
				this._z *= - 1;
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			dot: function ( v ) {
	
				return this._x * v._x + this._y * v._y + this._z * v._z + this._w * v._w;
	
			},
	
			lengthSq: function () {
	
				return this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w;
	
			},
	
			length: function () {
	
				return Math.sqrt( this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w );
	
			},
	
			normalize: function () {
	
				var l = this.length();
	
				if ( l === 0 ) {
	
					this._x = 0;
					this._y = 0;
					this._z = 0;
					this._w = 1;
	
				} else {
	
					l = 1 / l;
	
					this._x = this._x * l;
					this._y = this._y * l;
					this._z = this._z * l;
					this._w = this._w * l;
	
				}
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			multiply: function ( q, p ) {
	
				if ( p !== undefined ) {
	
					console.warn( 'THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead.' );
					return this.multiplyQuaternions( q, p );
	
				}
	
				return this.multiplyQuaternions( this, q );
	
			},
	
			premultiply: function ( q ) {
	
				return this.multiplyQuaternions( q, this );
	
			},
	
			multiplyQuaternions: function ( a, b ) {
	
				// from http://www.euclideanspace.com/maths/algebra/realNormedAlgebra/quaternions/code/index.htm
	
				var qax = a._x, qay = a._y, qaz = a._z, qaw = a._w;
				var qbx = b._x, qby = b._y, qbz = b._z, qbw = b._w;
	
				this._x = qax * qbw + qaw * qbx + qay * qbz - qaz * qby;
				this._y = qay * qbw + qaw * qby + qaz * qbx - qax * qbz;
				this._z = qaz * qbw + qaw * qbz + qax * qby - qay * qbx;
				this._w = qaw * qbw - qax * qbx - qay * qby - qaz * qbz;
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			slerp: function ( qb, t ) {
	
				if ( t === 0 ) return this;
				if ( t === 1 ) return this.copy( qb );
	
				var x = this._x, y = this._y, z = this._z, w = this._w;
	
				// http://www.euclideanspace.com/maths/algebra/realNormedAlgebra/quaternions/slerp/
	
				var cosHalfTheta = w * qb._w + x * qb._x + y * qb._y + z * qb._z;
	
				if ( cosHalfTheta < 0 ) {
	
					this._w = - qb._w;
					this._x = - qb._x;
					this._y = - qb._y;
					this._z = - qb._z;
	
					cosHalfTheta = - cosHalfTheta;
	
				} else {
	
					this.copy( qb );
	
				}
	
				if ( cosHalfTheta >= 1.0 ) {
	
					this._w = w;
					this._x = x;
					this._y = y;
					this._z = z;
	
					return this;
	
				}
	
				var sinHalfTheta = Math.sqrt( 1.0 - cosHalfTheta * cosHalfTheta );
	
				if ( Math.abs( sinHalfTheta ) < 0.001 ) {
	
					this._w = 0.5 * ( w + this._w );
					this._x = 0.5 * ( x + this._x );
					this._y = 0.5 * ( y + this._y );
					this._z = 0.5 * ( z + this._z );
	
					return this;
	
				}
	
				var halfTheta = Math.atan2( sinHalfTheta, cosHalfTheta );
				var ratioA = Math.sin( ( 1 - t ) * halfTheta ) / sinHalfTheta,
					ratioB = Math.sin( t * halfTheta ) / sinHalfTheta;
	
				this._w = ( w * ratioA + this._w * ratioB );
				this._x = ( x * ratioA + this._x * ratioB );
				this._y = ( y * ratioA + this._y * ratioB );
				this._z = ( z * ratioA + this._z * ratioB );
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			equals: function ( quaternion ) {
	
				return ( quaternion._x === this._x ) && ( quaternion._y === this._y ) && ( quaternion._z === this._z ) && ( quaternion._w === this._w );
	
			},
	
			fromArray: function ( array, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				this._x = array[ offset ];
				this._y = array[ offset + 1 ];
				this._z = array[ offset + 2 ];
				this._w = array[ offset + 3 ];
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				array[ offset ] = this._x;
				array[ offset + 1 ] = this._y;
				array[ offset + 2 ] = this._z;
				array[ offset + 3 ] = this._w;
	
				return array;
	
			},
	
			onChange: function ( callback ) {
	
				this.onChangeCallback = callback;
	
				return this;
	
			},
	
			onChangeCallback: function () {}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author kile / http://kile.stravaganza.org/
		 * @author philogb / http://blog.thejit.org/
		 * @author mikael emtinger / http://gomo.se/
		 * @author egraether / http://egraether.com/
		 * @author WestLangley / http://github.com/WestLangley
		 */
	
		function Vector3( x, y, z ) {
	
			this.x = x || 0;
			this.y = y || 0;
			this.z = z || 0;
	
		}
	
		Object.assign( Vector3.prototype, {
	
			isVector3: true,
	
			set: function ( x, y, z ) {
	
				this.x = x;
				this.y = y;
				this.z = z;
	
				return this;
	
			},
	
			setScalar: function ( scalar ) {
	
				this.x = scalar;
				this.y = scalar;
				this.z = scalar;
	
				return this;
	
			},
	
			setX: function ( x ) {
	
				this.x = x;
	
				return this;
	
			},
	
			setY: function ( y ) {
	
				this.y = y;
	
				return this;
	
			},
	
			setZ: function ( z ) {
	
				this.z = z;
	
				return this;
	
			},
	
			setComponent: function ( index, value ) {
	
				switch ( index ) {
	
					case 0: this.x = value; break;
					case 1: this.y = value; break;
					case 2: this.z = value; break;
					default: throw new Error( 'index is out of range: ' + index );
	
				}
	
				return this;
	
			},
	
			getComponent: function ( index ) {
	
				switch ( index ) {
	
					case 0: return this.x;
					case 1: return this.y;
					case 2: return this.z;
					default: throw new Error( 'index is out of range: ' + index );
	
				}
	
			},
	
			clone: function () {
	
				return new this.constructor( this.x, this.y, this.z );
	
			},
	
			copy: function ( v ) {
	
				this.x = v.x;
				this.y = v.y;
				this.z = v.z;
	
				return this;
	
			},
	
			add: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );
					return this.addVectors( v, w );
	
				}
	
				this.x += v.x;
				this.y += v.y;
				this.z += v.z;
	
				return this;
	
			},
	
			addScalar: function ( s ) {
	
				this.x += s;
				this.y += s;
				this.z += s;
	
				return this;
	
			},
	
			addVectors: function ( a, b ) {
	
				this.x = a.x + b.x;
				this.y = a.y + b.y;
				this.z = a.z + b.z;
	
				return this;
	
			},
	
			addScaledVector: function ( v, s ) {
	
				this.x += v.x * s;
				this.y += v.y * s;
				this.z += v.z * s;
	
				return this;
	
			},
	
			sub: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );
					return this.subVectors( v, w );
	
				}
	
				this.x -= v.x;
				this.y -= v.y;
				this.z -= v.z;
	
				return this;
	
			},
	
			subScalar: function ( s ) {
	
				this.x -= s;
				this.y -= s;
				this.z -= s;
	
				return this;
	
			},
	
			subVectors: function ( a, b ) {
	
				this.x = a.x - b.x;
				this.y = a.y - b.y;
				this.z = a.z - b.z;
	
				return this;
	
			},
	
			multiply: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead.' );
					return this.multiplyVectors( v, w );
	
				}
	
				this.x *= v.x;
				this.y *= v.y;
				this.z *= v.z;
	
				return this;
	
			},
	
			multiplyScalar: function ( scalar ) {
	
				this.x *= scalar;
				this.y *= scalar;
				this.z *= scalar;
	
				return this;
	
			},
	
			multiplyVectors: function ( a, b ) {
	
				this.x = a.x * b.x;
				this.y = a.y * b.y;
				this.z = a.z * b.z;
	
				return this;
	
			},
	
			applyEuler: function () {
	
				var quaternion = new Quaternion();
	
				return function applyEuler( euler ) {
	
					if ( ! ( euler && euler.isEuler ) ) {
	
						console.error( 'THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order.' );
	
					}
	
					return this.applyQuaternion( quaternion.setFromEuler( euler ) );
	
				};
	
			}(),
	
			applyAxisAngle: function () {
	
				var quaternion = new Quaternion();
	
				return function applyAxisAngle( axis, angle ) {
	
					return this.applyQuaternion( quaternion.setFromAxisAngle( axis, angle ) );
	
				};
	
			}(),
	
			applyMatrix3: function ( m ) {
	
				var x = this.x, y = this.y, z = this.z;
				var e = m.elements;
	
				this.x = e[ 0 ] * x + e[ 3 ] * y + e[ 6 ] * z;
				this.y = e[ 1 ] * x + e[ 4 ] * y + e[ 7 ] * z;
				this.z = e[ 2 ] * x + e[ 5 ] * y + e[ 8 ] * z;
	
				return this;
	
			},
	
			applyMatrix4: function ( m ) {
	
				var x = this.x, y = this.y, z = this.z;
				var e = m.elements;
	
				var w = 1 / ( e[ 3 ] * x + e[ 7 ] * y + e[ 11 ] * z + e[ 15 ] );
	
				this.x = ( e[ 0 ] * x + e[ 4 ] * y + e[ 8 ]  * z + e[ 12 ] ) * w;
				this.y = ( e[ 1 ] * x + e[ 5 ] * y + e[ 9 ]  * z + e[ 13 ] ) * w;
				this.z = ( e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z + e[ 14 ] ) * w;
	
				return this;
	
			},
	
			applyQuaternion: function ( q ) {
	
				var x = this.x, y = this.y, z = this.z;
				var qx = q.x, qy = q.y, qz = q.z, qw = q.w;
	
				// calculate quat * vector
	
				var ix =  qw * x + qy * z - qz * y;
				var iy =  qw * y + qz * x - qx * z;
				var iz =  qw * z + qx * y - qy * x;
				var iw = - qx * x - qy * y - qz * z;
	
				// calculate result * inverse quat
	
				this.x = ix * qw + iw * - qx + iy * - qz - iz * - qy;
				this.y = iy * qw + iw * - qy + iz * - qx - ix * - qz;
				this.z = iz * qw + iw * - qz + ix * - qy - iy * - qx;
	
				return this;
	
			},
	
			project: function () {
	
				var matrix = new Matrix4();
	
				return function project( camera ) {
	
					matrix.multiplyMatrices( camera.projectionMatrix, matrix.getInverse( camera.matrixWorld ) );
					return this.applyMatrix4( matrix );
	
				};
	
			}(),
	
			unproject: function () {
	
				var matrix = new Matrix4();
	
				return function unproject( camera ) {
	
					matrix.multiplyMatrices( camera.matrixWorld, matrix.getInverse( camera.projectionMatrix ) );
					return this.applyMatrix4( matrix );
	
				};
	
			}(),
	
			transformDirection: function ( m ) {
	
				// input: THREE.Matrix4 affine matrix
				// vector interpreted as a direction
	
				var x = this.x, y = this.y, z = this.z;
				var e = m.elements;
	
				this.x = e[ 0 ] * x + e[ 4 ] * y + e[ 8 ]  * z;
				this.y = e[ 1 ] * x + e[ 5 ] * y + e[ 9 ]  * z;
				this.z = e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z;
	
				return this.normalize();
	
			},
	
			divide: function ( v ) {
	
				this.x /= v.x;
				this.y /= v.y;
				this.z /= v.z;
	
				return this;
	
			},
	
			divideScalar: function ( scalar ) {
	
				return this.multiplyScalar( 1 / scalar );
	
			},
	
			min: function ( v ) {
	
				this.x = Math.min( this.x, v.x );
				this.y = Math.min( this.y, v.y );
				this.z = Math.min( this.z, v.z );
	
				return this;
	
			},
	
			max: function ( v ) {
	
				this.x = Math.max( this.x, v.x );
				this.y = Math.max( this.y, v.y );
				this.z = Math.max( this.z, v.z );
	
				return this;
	
			},
	
			clamp: function ( min, max ) {
	
				// assumes min < max, componentwise
	
				this.x = Math.max( min.x, Math.min( max.x, this.x ) );
				this.y = Math.max( min.y, Math.min( max.y, this.y ) );
				this.z = Math.max( min.z, Math.min( max.z, this.z ) );
	
				return this;
	
			},
	
			clampScalar: function () {
	
				var min = new Vector3();
				var max = new Vector3();
	
				return function clampScalar( minVal, maxVal ) {
	
					min.set( minVal, minVal, minVal );
					max.set( maxVal, maxVal, maxVal );
	
					return this.clamp( min, max );
	
				};
	
			}(),
	
			clampLength: function ( min, max ) {
	
				var length = this.length();
	
				return this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );
	
			},
	
			floor: function () {
	
				this.x = Math.floor( this.x );
				this.y = Math.floor( this.y );
				this.z = Math.floor( this.z );
	
				return this;
	
			},
	
			ceil: function () {
	
				this.x = Math.ceil( this.x );
				this.y = Math.ceil( this.y );
				this.z = Math.ceil( this.z );
	
				return this;
	
			},
	
			round: function () {
	
				this.x = Math.round( this.x );
				this.y = Math.round( this.y );
				this.z = Math.round( this.z );
	
				return this;
	
			},
	
			roundToZero: function () {
	
				this.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );
				this.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );
				this.z = ( this.z < 0 ) ? Math.ceil( this.z ) : Math.floor( this.z );
	
				return this;
	
			},
	
			negate: function () {
	
				this.x = - this.x;
				this.y = - this.y;
				this.z = - this.z;
	
				return this;
	
			},
	
			dot: function ( v ) {
	
				return this.x * v.x + this.y * v.y + this.z * v.z;
	
			},
	
			// TODO lengthSquared?
	
			lengthSq: function () {
	
				return this.x * this.x + this.y * this.y + this.z * this.z;
	
			},
	
			length: function () {
	
				return Math.sqrt( this.x * this.x + this.y * this.y + this.z * this.z );
	
			},
	
			lengthManhattan: function () {
	
				return Math.abs( this.x ) + Math.abs( this.y ) + Math.abs( this.z );
	
			},
	
			normalize: function () {
	
				return this.divideScalar( this.length() || 1 );
	
			},
	
			setLength: function ( length ) {
	
				return this.normalize().multiplyScalar( length );
	
			},
	
			lerp: function ( v, alpha ) {
	
				this.x += ( v.x - this.x ) * alpha;
				this.y += ( v.y - this.y ) * alpha;
				this.z += ( v.z - this.z ) * alpha;
	
				return this;
	
			},
	
			lerpVectors: function ( v1, v2, alpha ) {
	
				return this.subVectors( v2, v1 ).multiplyScalar( alpha ).add( v1 );
	
			},
	
			cross: function ( v, w ) {
	
				if ( w !== undefined ) {
	
					console.warn( 'THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead.' );
					return this.crossVectors( v, w );
	
				}
	
				var x = this.x, y = this.y, z = this.z;
	
				this.x = y * v.z - z * v.y;
				this.y = z * v.x - x * v.z;
				this.z = x * v.y - y * v.x;
	
				return this;
	
			},
	
			crossVectors: function ( a, b ) {
	
				var ax = a.x, ay = a.y, az = a.z;
				var bx = b.x, by = b.y, bz = b.z;
	
				this.x = ay * bz - az * by;
				this.y = az * bx - ax * bz;
				this.z = ax * by - ay * bx;
	
				return this;
	
			},
	
			projectOnVector: function ( vector ) {
	
				var scalar = vector.dot( this ) / vector.lengthSq();
	
				return this.copy( vector ).multiplyScalar( scalar );
	
			},
	
			projectOnPlane: function () {
	
				var v1 = new Vector3();
	
				return function projectOnPlane( planeNormal ) {
	
					v1.copy( this ).projectOnVector( planeNormal );
	
					return this.sub( v1 );
	
				};
	
			}(),
	
			reflect: function () {
	
				// reflect incident vector off plane orthogonal to normal
				// normal is assumed to have unit length
	
				var v1 = new Vector3();
	
				return function reflect( normal ) {
	
					return this.sub( v1.copy( normal ).multiplyScalar( 2 * this.dot( normal ) ) );
	
				};
	
			}(),
	
			angleTo: function ( v ) {
	
				var theta = this.dot( v ) / ( Math.sqrt( this.lengthSq() * v.lengthSq() ) );
	
				// clamp, to handle numerical problems
	
				return Math.acos( _Math.clamp( theta, - 1, 1 ) );
	
			},
	
			distanceTo: function ( v ) {
	
				return Math.sqrt( this.distanceToSquared( v ) );
	
			},
	
			distanceToSquared: function ( v ) {
	
				var dx = this.x - v.x, dy = this.y - v.y, dz = this.z - v.z;
	
				return dx * dx + dy * dy + dz * dz;
	
			},
	
			distanceToManhattan: function ( v ) {
	
				return Math.abs( this.x - v.x ) + Math.abs( this.y - v.y ) + Math.abs( this.z - v.z );
	
			},
	
			setFromSpherical: function ( s ) {
	
				var sinPhiRadius = Math.sin( s.phi ) * s.radius;
	
				this.x = sinPhiRadius * Math.sin( s.theta );
				this.y = Math.cos( s.phi ) * s.radius;
				this.z = sinPhiRadius * Math.cos( s.theta );
	
				return this;
	
			},
	
			setFromCylindrical: function ( c ) {
	
				this.x = c.radius * Math.sin( c.theta );
				this.y = c.y;
				this.z = c.radius * Math.cos( c.theta );
	
				return this;
	
			},
	
			setFromMatrixPosition: function ( m ) {
	
				var e = m.elements;
	
				this.x = e[ 12 ];
				this.y = e[ 13 ];
				this.z = e[ 14 ];
	
				return this;
	
			},
	
			setFromMatrixScale: function ( m ) {
	
				var sx = this.setFromMatrixColumn( m, 0 ).length();
				var sy = this.setFromMatrixColumn( m, 1 ).length();
				var sz = this.setFromMatrixColumn( m, 2 ).length();
	
				this.x = sx;
				this.y = sy;
				this.z = sz;
	
				return this;
	
			},
	
			setFromMatrixColumn: function ( m, index ) {
	
				return this.fromArray( m.elements, index * 4 );
	
			},
	
			equals: function ( v ) {
	
				return ( ( v.x === this.x ) && ( v.y === this.y ) && ( v.z === this.z ) );
	
			},
	
			fromArray: function ( array, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				this.x = array[ offset ];
				this.y = array[ offset + 1 ];
				this.z = array[ offset + 2 ];
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				array[ offset ] = this.x;
				array[ offset + 1 ] = this.y;
				array[ offset + 2 ] = this.z;
	
				return array;
	
			},
	
			fromBufferAttribute: function ( attribute, index, offset ) {
	
				if ( offset !== undefined ) {
	
					console.warn( 'THREE.Vector3: offset has been removed from .fromBufferAttribute().' );
	
				}
	
				this.x = attribute.getX( index );
				this.y = attribute.getY( index );
				this.z = attribute.getZ( index );
	
				return this;
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author supereggbert / http://www.paulbrunt.co.uk/
		 * @author philogb / http://blog.thejit.org/
		 * @author jordi_ros / http://plattsoft.com
		 * @author D1plo1d / http://github.com/D1plo1d
		 * @author alteredq / http://alteredqualia.com/
		 * @author mikael emtinger / http://gomo.se/
		 * @author timknip / http://www.floorplanner.com/
		 * @author bhouston / http://clara.io
		 * @author WestLangley / http://github.com/WestLangley
		 */
	
		function Matrix4() {
	
			this.elements = [
	
				1, 0, 0, 0,
				0, 1, 0, 0,
				0, 0, 1, 0,
				0, 0, 0, 1
	
			];
	
			if ( arguments.length > 0 ) {
	
				console.error( 'THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.' );
	
			}
	
		}
	
		Object.assign( Matrix4.prototype, {
	
			isMatrix4: true,
	
			set: function ( n11, n12, n13, n14, n21, n22, n23, n24, n31, n32, n33, n34, n41, n42, n43, n44 ) {
	
				var te = this.elements;
	
				te[ 0 ] = n11; te[ 4 ] = n12; te[ 8 ] = n13; te[ 12 ] = n14;
				te[ 1 ] = n21; te[ 5 ] = n22; te[ 9 ] = n23; te[ 13 ] = n24;
				te[ 2 ] = n31; te[ 6 ] = n32; te[ 10 ] = n33; te[ 14 ] = n34;
				te[ 3 ] = n41; te[ 7 ] = n42; te[ 11 ] = n43; te[ 15 ] = n44;
	
				return this;
	
			},
	
			identity: function () {
	
				this.set(
	
					1, 0, 0, 0,
					0, 1, 0, 0,
					0, 0, 1, 0,
					0, 0, 0, 1
	
				);
	
				return this;
	
			},
	
			clone: function () {
	
				return new Matrix4().fromArray( this.elements );
	
			},
	
			copy: function ( m ) {
	
				var te = this.elements;
				var me = m.elements;
	
				te[ 0 ] = me[ 0 ]; te[ 1 ] = me[ 1 ]; te[ 2 ] = me[ 2 ]; te[ 3 ] = me[ 3 ];
				te[ 4 ] = me[ 4 ]; te[ 5 ] = me[ 5 ]; te[ 6 ] = me[ 6 ]; te[ 7 ] = me[ 7 ];
				te[ 8 ] = me[ 8 ]; te[ 9 ] = me[ 9 ]; te[ 10 ] = me[ 10 ]; te[ 11 ] = me[ 11 ];
				te[ 12 ] = me[ 12 ]; te[ 13 ] = me[ 13 ]; te[ 14 ] = me[ 14 ]; te[ 15 ] = me[ 15 ];
	
				return this;
	
			},
	
			copyPosition: function ( m ) {
	
				var te = this.elements, me = m.elements;
	
				te[ 12 ] = me[ 12 ];
				te[ 13 ] = me[ 13 ];
				te[ 14 ] = me[ 14 ];
	
				return this;
	
			},
	
			extractBasis: function ( xAxis, yAxis, zAxis ) {
	
				xAxis.setFromMatrixColumn( this, 0 );
				yAxis.setFromMatrixColumn( this, 1 );
				zAxis.setFromMatrixColumn( this, 2 );
	
				return this;
	
			},
	
			makeBasis: function ( xAxis, yAxis, zAxis ) {
	
				this.set(
					xAxis.x, yAxis.x, zAxis.x, 0,
					xAxis.y, yAxis.y, zAxis.y, 0,
					xAxis.z, yAxis.z, zAxis.z, 0,
					0,       0,       0,       1
				);
	
				return this;
	
			},
	
			extractRotation: function () {
	
				var v1 = new Vector3();
	
				return function extractRotation( m ) {
	
					var te = this.elements;
					var me = m.elements;
	
					var scaleX = 1 / v1.setFromMatrixColumn( m, 0 ).length();
					var scaleY = 1 / v1.setFromMatrixColumn( m, 1 ).length();
					var scaleZ = 1 / v1.setFromMatrixColumn( m, 2 ).length();
	
					te[ 0 ] = me[ 0 ] * scaleX;
					te[ 1 ] = me[ 1 ] * scaleX;
					te[ 2 ] = me[ 2 ] * scaleX;
	
					te[ 4 ] = me[ 4 ] * scaleY;
					te[ 5 ] = me[ 5 ] * scaleY;
					te[ 6 ] = me[ 6 ] * scaleY;
	
					te[ 8 ] = me[ 8 ] * scaleZ;
					te[ 9 ] = me[ 9 ] * scaleZ;
					te[ 10 ] = me[ 10 ] * scaleZ;
	
					return this;
	
				};
	
			}(),
	
			makeRotationFromEuler: function ( euler ) {
	
				if ( ! ( euler && euler.isEuler ) ) {
	
					console.error( 'THREE.Matrix: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.' );
	
				}
	
				var te = this.elements;
	
				var x = euler.x, y = euler.y, z = euler.z;
				var a = Math.cos( x ), b = Math.sin( x );
				var c = Math.cos( y ), d = Math.sin( y );
				var e = Math.cos( z ), f = Math.sin( z );
	
				if ( euler.order === 'XYZ' ) {
	
					var ae = a * e, af = a * f, be = b * e, bf = b * f;
	
					te[ 0 ] = c * e;
					te[ 4 ] = - c * f;
					te[ 8 ] = d;
	
					te[ 1 ] = af + be * d;
					te[ 5 ] = ae - bf * d;
					te[ 9 ] = - b * c;
	
					te[ 2 ] = bf - ae * d;
					te[ 6 ] = be + af * d;
					te[ 10 ] = a * c;
	
				} else if ( euler.order === 'YXZ' ) {
	
					var ce = c * e, cf = c * f, de = d * e, df = d * f;
	
					te[ 0 ] = ce + df * b;
					te[ 4 ] = de * b - cf;
					te[ 8 ] = a * d;
	
					te[ 1 ] = a * f;
					te[ 5 ] = a * e;
					te[ 9 ] = - b;
	
					te[ 2 ] = cf * b - de;
					te[ 6 ] = df + ce * b;
					te[ 10 ] = a * c;
	
				} else if ( euler.order === 'ZXY' ) {
	
					var ce = c * e, cf = c * f, de = d * e, df = d * f;
	
					te[ 0 ] = ce - df * b;
					te[ 4 ] = - a * f;
					te[ 8 ] = de + cf * b;
	
					te[ 1 ] = cf + de * b;
					te[ 5 ] = a * e;
					te[ 9 ] = df - ce * b;
	
					te[ 2 ] = - a * d;
					te[ 6 ] = b;
					te[ 10 ] = a * c;
	
				} else if ( euler.order === 'ZYX' ) {
	
					var ae = a * e, af = a * f, be = b * e, bf = b * f;
	
					te[ 0 ] = c * e;
					te[ 4 ] = be * d - af;
					te[ 8 ] = ae * d + bf;
	
					te[ 1 ] = c * f;
					te[ 5 ] = bf * d + ae;
					te[ 9 ] = af * d - be;
	
					te[ 2 ] = - d;
					te[ 6 ] = b * c;
					te[ 10 ] = a * c;
	
				} else if ( euler.order === 'YZX' ) {
	
					var ac = a * c, ad = a * d, bc = b * c, bd = b * d;
	
					te[ 0 ] = c * e;
					te[ 4 ] = bd - ac * f;
					te[ 8 ] = bc * f + ad;
	
					te[ 1 ] = f;
					te[ 5 ] = a * e;
					te[ 9 ] = - b * e;
	
					te[ 2 ] = - d * e;
					te[ 6 ] = ad * f + bc;
					te[ 10 ] = ac - bd * f;
	
				} else if ( euler.order === 'XZY' ) {
	
					var ac = a * c, ad = a * d, bc = b * c, bd = b * d;
	
					te[ 0 ] = c * e;
					te[ 4 ] = - f;
					te[ 8 ] = d * e;
	
					te[ 1 ] = ac * f + bd;
					te[ 5 ] = a * e;
					te[ 9 ] = ad * f - bc;
	
					te[ 2 ] = bc * f - ad;
					te[ 6 ] = b * e;
					te[ 10 ] = bd * f + ac;
	
				}
	
				// last column
				te[ 3 ] = 0;
				te[ 7 ] = 0;
				te[ 11 ] = 0;
	
				// bottom row
				te[ 12 ] = 0;
				te[ 13 ] = 0;
				te[ 14 ] = 0;
				te[ 15 ] = 1;
	
				return this;
	
			},
	
			makeRotationFromQuaternion: function ( q ) {
	
				var te = this.elements;
	
				var x = q._x, y = q._y, z = q._z, w = q._w;
				var x2 = x + x, y2 = y + y, z2 = z + z;
				var xx = x * x2, xy = x * y2, xz = x * z2;
				var yy = y * y2, yz = y * z2, zz = z * z2;
				var wx = w * x2, wy = w * y2, wz = w * z2;
	
				te[ 0 ] = 1 - ( yy + zz );
				te[ 4 ] = xy - wz;
				te[ 8 ] = xz + wy;
	
				te[ 1 ] = xy + wz;
				te[ 5 ] = 1 - ( xx + zz );
				te[ 9 ] = yz - wx;
	
				te[ 2 ] = xz - wy;
				te[ 6 ] = yz + wx;
				te[ 10 ] = 1 - ( xx + yy );
	
				// last column
				te[ 3 ] = 0;
				te[ 7 ] = 0;
				te[ 11 ] = 0;
	
				// bottom row
				te[ 12 ] = 0;
				te[ 13 ] = 0;
				te[ 14 ] = 0;
				te[ 15 ] = 1;
	
				return this;
	
			},
	
			lookAt: function () {
	
				var x = new Vector3();
				var y = new Vector3();
				var z = new Vector3();
	
				return function lookAt( eye, target, up ) {
	
					var te = this.elements;
	
					z.subVectors( eye, target );
	
					if ( z.lengthSq() === 0 ) {
	
						// eye and target are in the same position
	
						z.z = 1;
	
					}
	
					z.normalize();
					x.crossVectors( up, z );
	
					if ( x.lengthSq() === 0 ) {
	
						// up and z are parallel
	
						if ( Math.abs( up.z ) === 1 ) {
	
							z.x += 0.0001;
	
						} else {
	
							z.z += 0.0001;
	
						}
	
						z.normalize();
						x.crossVectors( up, z );
	
					}
	
					x.normalize();
					y.crossVectors( z, x );
	
					te[ 0 ] = x.x; te[ 4 ] = y.x; te[ 8 ] = z.x;
					te[ 1 ] = x.y; te[ 5 ] = y.y; te[ 9 ] = z.y;
					te[ 2 ] = x.z; te[ 6 ] = y.z; te[ 10 ] = z.z;
	
					return this;
	
				};
	
			}(),
	
			multiply: function ( m, n ) {
	
				if ( n !== undefined ) {
	
					console.warn( 'THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead.' );
					return this.multiplyMatrices( m, n );
	
				}
	
				return this.multiplyMatrices( this, m );
	
			},
	
			premultiply: function ( m ) {
	
				return this.multiplyMatrices( m, this );
	
			},
	
			multiplyMatrices: function ( a, b ) {
	
				var ae = a.elements;
				var be = b.elements;
				var te = this.elements;
	
				var a11 = ae[ 0 ], a12 = ae[ 4 ], a13 = ae[ 8 ], a14 = ae[ 12 ];
				var a21 = ae[ 1 ], a22 = ae[ 5 ], a23 = ae[ 9 ], a24 = ae[ 13 ];
				var a31 = ae[ 2 ], a32 = ae[ 6 ], a33 = ae[ 10 ], a34 = ae[ 14 ];
				var a41 = ae[ 3 ], a42 = ae[ 7 ], a43 = ae[ 11 ], a44 = ae[ 15 ];
	
				var b11 = be[ 0 ], b12 = be[ 4 ], b13 = be[ 8 ], b14 = be[ 12 ];
				var b21 = be[ 1 ], b22 = be[ 5 ], b23 = be[ 9 ], b24 = be[ 13 ];
				var b31 = be[ 2 ], b32 = be[ 6 ], b33 = be[ 10 ], b34 = be[ 14 ];
				var b41 = be[ 3 ], b42 = be[ 7 ], b43 = be[ 11 ], b44 = be[ 15 ];
	
				te[ 0 ] = a11 * b11 + a12 * b21 + a13 * b31 + a14 * b41;
				te[ 4 ] = a11 * b12 + a12 * b22 + a13 * b32 + a14 * b42;
				te[ 8 ] = a11 * b13 + a12 * b23 + a13 * b33 + a14 * b43;
				te[ 12 ] = a11 * b14 + a12 * b24 + a13 * b34 + a14 * b44;
	
				te[ 1 ] = a21 * b11 + a22 * b21 + a23 * b31 + a24 * b41;
				te[ 5 ] = a21 * b12 + a22 * b22 + a23 * b32 + a24 * b42;
				te[ 9 ] = a21 * b13 + a22 * b23 + a23 * b33 + a24 * b43;
				te[ 13 ] = a21 * b14 + a22 * b24 + a23 * b34 + a24 * b44;
	
				te[ 2 ] = a31 * b11 + a32 * b21 + a33 * b31 + a34 * b41;
				te[ 6 ] = a31 * b12 + a32 * b22 + a33 * b32 + a34 * b42;
				te[ 10 ] = a31 * b13 + a32 * b23 + a33 * b33 + a34 * b43;
				te[ 14 ] = a31 * b14 + a32 * b24 + a33 * b34 + a34 * b44;
	
				te[ 3 ] = a41 * b11 + a42 * b21 + a43 * b31 + a44 * b41;
				te[ 7 ] = a41 * b12 + a42 * b22 + a43 * b32 + a44 * b42;
				te[ 11 ] = a41 * b13 + a42 * b23 + a43 * b33 + a44 * b43;
				te[ 15 ] = a41 * b14 + a42 * b24 + a43 * b34 + a44 * b44;
	
				return this;
	
			},
	
			multiplyScalar: function ( s ) {
	
				var te = this.elements;
	
				te[ 0 ] *= s; te[ 4 ] *= s; te[ 8 ] *= s; te[ 12 ] *= s;
				te[ 1 ] *= s; te[ 5 ] *= s; te[ 9 ] *= s; te[ 13 ] *= s;
				te[ 2 ] *= s; te[ 6 ] *= s; te[ 10 ] *= s; te[ 14 ] *= s;
				te[ 3 ] *= s; te[ 7 ] *= s; te[ 11 ] *= s; te[ 15 ] *= s;
	
				return this;
	
			},
	
			applyToBufferAttribute: function () {
	
				var v1 = new Vector3();
	
				return function applyToBufferAttribute( attribute ) {
	
					for ( var i = 0, l = attribute.count; i < l; i ++ ) {
	
						v1.x = attribute.getX( i );
						v1.y = attribute.getY( i );
						v1.z = attribute.getZ( i );
	
						v1.applyMatrix4( this );
	
						attribute.setXYZ( i, v1.x, v1.y, v1.z );
	
					}
	
					return attribute;
	
				};
	
			}(),
	
			determinant: function () {
	
				var te = this.elements;
	
				var n11 = te[ 0 ], n12 = te[ 4 ], n13 = te[ 8 ], n14 = te[ 12 ];
				var n21 = te[ 1 ], n22 = te[ 5 ], n23 = te[ 9 ], n24 = te[ 13 ];
				var n31 = te[ 2 ], n32 = te[ 6 ], n33 = te[ 10 ], n34 = te[ 14 ];
				var n41 = te[ 3 ], n42 = te[ 7 ], n43 = te[ 11 ], n44 = te[ 15 ];
	
				//TODO: make this more efficient
				//( based on http://www.euclideanspace.com/maths/algebra/matrix/functions/inverse/fourD/index.htm )
	
				return (
					n41 * (
						+ n14 * n23 * n32
						 - n13 * n24 * n32
						 - n14 * n22 * n33
						 + n12 * n24 * n33
						 + n13 * n22 * n34
						 - n12 * n23 * n34
					) +
					n42 * (
						+ n11 * n23 * n34
						 - n11 * n24 * n33
						 + n14 * n21 * n33
						 - n13 * n21 * n34
						 + n13 * n24 * n31
						 - n14 * n23 * n31
					) +
					n43 * (
						+ n11 * n24 * n32
						 - n11 * n22 * n34
						 - n14 * n21 * n32
						 + n12 * n21 * n34
						 + n14 * n22 * n31
						 - n12 * n24 * n31
					) +
					n44 * (
						- n13 * n22 * n31
						 - n11 * n23 * n32
						 + n11 * n22 * n33
						 + n13 * n21 * n32
						 - n12 * n21 * n33
						 + n12 * n23 * n31
					)
	
				);
	
			},
	
			transpose: function () {
	
				var te = this.elements;
				var tmp;
	
				tmp = te[ 1 ]; te[ 1 ] = te[ 4 ]; te[ 4 ] = tmp;
				tmp = te[ 2 ]; te[ 2 ] = te[ 8 ]; te[ 8 ] = tmp;
				tmp = te[ 6 ]; te[ 6 ] = te[ 9 ]; te[ 9 ] = tmp;
	
				tmp = te[ 3 ]; te[ 3 ] = te[ 12 ]; te[ 12 ] = tmp;
				tmp = te[ 7 ]; te[ 7 ] = te[ 13 ]; te[ 13 ] = tmp;
				tmp = te[ 11 ]; te[ 11 ] = te[ 14 ]; te[ 14 ] = tmp;
	
				return this;
	
			},
	
			setPosition: function ( v ) {
	
				var te = this.elements;
	
				te[ 12 ] = v.x;
				te[ 13 ] = v.y;
				te[ 14 ] = v.z;
	
				return this;
	
			},
	
			getInverse: function ( m, throwOnDegenerate ) {
	
				// based on http://www.euclideanspace.com/maths/algebra/matrix/functions/inverse/fourD/index.htm
				var te = this.elements,
					me = m.elements,
	
					n11 = me[ 0 ], n21 = me[ 1 ], n31 = me[ 2 ], n41 = me[ 3 ],
					n12 = me[ 4 ], n22 = me[ 5 ], n32 = me[ 6 ], n42 = me[ 7 ],
					n13 = me[ 8 ], n23 = me[ 9 ], n33 = me[ 10 ], n43 = me[ 11 ],
					n14 = me[ 12 ], n24 = me[ 13 ], n34 = me[ 14 ], n44 = me[ 15 ],
	
					t11 = n23 * n34 * n42 - n24 * n33 * n42 + n24 * n32 * n43 - n22 * n34 * n43 - n23 * n32 * n44 + n22 * n33 * n44,
					t12 = n14 * n33 * n42 - n13 * n34 * n42 - n14 * n32 * n43 + n12 * n34 * n43 + n13 * n32 * n44 - n12 * n33 * n44,
					t13 = n13 * n24 * n42 - n14 * n23 * n42 + n14 * n22 * n43 - n12 * n24 * n43 - n13 * n22 * n44 + n12 * n23 * n44,
					t14 = n14 * n23 * n32 - n13 * n24 * n32 - n14 * n22 * n33 + n12 * n24 * n33 + n13 * n22 * n34 - n12 * n23 * n34;
	
				var det = n11 * t11 + n21 * t12 + n31 * t13 + n41 * t14;
	
				if ( det === 0 ) {
	
					var msg = "THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0";
	
					if ( throwOnDegenerate === true ) {
	
						throw new Error( msg );
	
					} else {
	
						console.warn( msg );
	
					}
	
					return this.identity();
	
				}
	
				var detInv = 1 / det;
	
				te[ 0 ] = t11 * detInv;
				te[ 1 ] = ( n24 * n33 * n41 - n23 * n34 * n41 - n24 * n31 * n43 + n21 * n34 * n43 + n23 * n31 * n44 - n21 * n33 * n44 ) * detInv;
				te[ 2 ] = ( n22 * n34 * n41 - n24 * n32 * n41 + n24 * n31 * n42 - n21 * n34 * n42 - n22 * n31 * n44 + n21 * n32 * n44 ) * detInv;
				te[ 3 ] = ( n23 * n32 * n41 - n22 * n33 * n41 - n23 * n31 * n42 + n21 * n33 * n42 + n22 * n31 * n43 - n21 * n32 * n43 ) * detInv;
	
				te[ 4 ] = t12 * detInv;
				te[ 5 ] = ( n13 * n34 * n41 - n14 * n33 * n41 + n14 * n31 * n43 - n11 * n34 * n43 - n13 * n31 * n44 + n11 * n33 * n44 ) * detInv;
				te[ 6 ] = ( n14 * n32 * n41 - n12 * n34 * n41 - n14 * n31 * n42 + n11 * n34 * n42 + n12 * n31 * n44 - n11 * n32 * n44 ) * detInv;
				te[ 7 ] = ( n12 * n33 * n41 - n13 * n32 * n41 + n13 * n31 * n42 - n11 * n33 * n42 - n12 * n31 * n43 + n11 * n32 * n43 ) * detInv;
	
				te[ 8 ] = t13 * detInv;
				te[ 9 ] = ( n14 * n23 * n41 - n13 * n24 * n41 - n14 * n21 * n43 + n11 * n24 * n43 + n13 * n21 * n44 - n11 * n23 * n44 ) * detInv;
				te[ 10 ] = ( n12 * n24 * n41 - n14 * n22 * n41 + n14 * n21 * n42 - n11 * n24 * n42 - n12 * n21 * n44 + n11 * n22 * n44 ) * detInv;
				te[ 11 ] = ( n13 * n22 * n41 - n12 * n23 * n41 - n13 * n21 * n42 + n11 * n23 * n42 + n12 * n21 * n43 - n11 * n22 * n43 ) * detInv;
	
				te[ 12 ] = t14 * detInv;
				te[ 13 ] = ( n13 * n24 * n31 - n14 * n23 * n31 + n14 * n21 * n33 - n11 * n24 * n33 - n13 * n21 * n34 + n11 * n23 * n34 ) * detInv;
				te[ 14 ] = ( n14 * n22 * n31 - n12 * n24 * n31 - n14 * n21 * n32 + n11 * n24 * n32 + n12 * n21 * n34 - n11 * n22 * n34 ) * detInv;
				te[ 15 ] = ( n12 * n23 * n31 - n13 * n22 * n31 + n13 * n21 * n32 - n11 * n23 * n32 - n12 * n21 * n33 + n11 * n22 * n33 ) * detInv;
	
				return this;
	
			},
	
			scale: function ( v ) {
	
				var te = this.elements;
				var x = v.x, y = v.y, z = v.z;
	
				te[ 0 ] *= x; te[ 4 ] *= y; te[ 8 ] *= z;
				te[ 1 ] *= x; te[ 5 ] *= y; te[ 9 ] *= z;
				te[ 2 ] *= x; te[ 6 ] *= y; te[ 10 ] *= z;
				te[ 3 ] *= x; te[ 7 ] *= y; te[ 11 ] *= z;
	
				return this;
	
			},
	
			getMaxScaleOnAxis: function () {
	
				var te = this.elements;
	
				var scaleXSq = te[ 0 ] * te[ 0 ] + te[ 1 ] * te[ 1 ] + te[ 2 ] * te[ 2 ];
				var scaleYSq = te[ 4 ] * te[ 4 ] + te[ 5 ] * te[ 5 ] + te[ 6 ] * te[ 6 ];
				var scaleZSq = te[ 8 ] * te[ 8 ] + te[ 9 ] * te[ 9 ] + te[ 10 ] * te[ 10 ];
	
				return Math.sqrt( Math.max( scaleXSq, scaleYSq, scaleZSq ) );
	
			},
	
			makeTranslation: function ( x, y, z ) {
	
				this.set(
	
					1, 0, 0, x,
					0, 1, 0, y,
					0, 0, 1, z,
					0, 0, 0, 1
	
				);
	
				return this;
	
			},
	
			makeRotationX: function ( theta ) {
	
				var c = Math.cos( theta ), s = Math.sin( theta );
	
				this.set(
	
					1, 0,  0, 0,
					0, c, - s, 0,
					0, s,  c, 0,
					0, 0,  0, 1
	
				);
	
				return this;
	
			},
	
			makeRotationY: function ( theta ) {
	
				var c = Math.cos( theta ), s = Math.sin( theta );
	
				this.set(
	
					 c, 0, s, 0,
					 0, 1, 0, 0,
					- s, 0, c, 0,
					 0, 0, 0, 1
	
				);
	
				return this;
	
			},
	
			makeRotationZ: function ( theta ) {
	
				var c = Math.cos( theta ), s = Math.sin( theta );
	
				this.set(
	
					c, - s, 0, 0,
					s,  c, 0, 0,
					0,  0, 1, 0,
					0,  0, 0, 1
	
				);
	
				return this;
	
			},
	
			makeRotationAxis: function ( axis, angle ) {
	
				// Based on http://www.gamedev.net/reference/articles/article1199.asp
	
				var c = Math.cos( angle );
				var s = Math.sin( angle );
				var t = 1 - c;
				var x = axis.x, y = axis.y, z = axis.z;
				var tx = t * x, ty = t * y;
	
				this.set(
	
					tx * x + c, tx * y - s * z, tx * z + s * y, 0,
					tx * y + s * z, ty * y + c, ty * z - s * x, 0,
					tx * z - s * y, ty * z + s * x, t * z * z + c, 0,
					0, 0, 0, 1
	
				);
	
				 return this;
	
			},
	
			makeScale: function ( x, y, z ) {
	
				this.set(
	
					x, 0, 0, 0,
					0, y, 0, 0,
					0, 0, z, 0,
					0, 0, 0, 1
	
				);
	
				return this;
	
			},
	
			makeShear: function ( x, y, z ) {
	
				this.set(
	
					1, y, z, 0,
					x, 1, z, 0,
					x, y, 1, 0,
					0, 0, 0, 1
	
				);
	
				return this;
	
			},
	
			compose: function ( position, quaternion, scale ) {
	
				this.makeRotationFromQuaternion( quaternion );
				this.scale( scale );
				this.setPosition( position );
	
				return this;
	
			},
	
			decompose: function () {
	
				var vector = new Vector3();
				var matrix = new Matrix4();
	
				return function decompose( position, quaternion, scale ) {
	
					var te = this.elements;
	
					var sx = vector.set( te[ 0 ], te[ 1 ], te[ 2 ] ).length();
					var sy = vector.set( te[ 4 ], te[ 5 ], te[ 6 ] ).length();
					var sz = vector.set( te[ 8 ], te[ 9 ], te[ 10 ] ).length();
	
					// if determine is negative, we need to invert one scale
					var det = this.determinant();
					if ( det < 0 ) sx = - sx;
	
					position.x = te[ 12 ];
					position.y = te[ 13 ];
					position.z = te[ 14 ];
	
					// scale the rotation part
					matrix.copy( this );
	
					var invSX = 1 / sx;
					var invSY = 1 / sy;
					var invSZ = 1 / sz;
	
					matrix.elements[ 0 ] *= invSX;
					matrix.elements[ 1 ] *= invSX;
					matrix.elements[ 2 ] *= invSX;
	
					matrix.elements[ 4 ] *= invSY;
					matrix.elements[ 5 ] *= invSY;
					matrix.elements[ 6 ] *= invSY;
	
					matrix.elements[ 8 ] *= invSZ;
					matrix.elements[ 9 ] *= invSZ;
					matrix.elements[ 10 ] *= invSZ;
	
					quaternion.setFromRotationMatrix( matrix );
	
					scale.x = sx;
					scale.y = sy;
					scale.z = sz;
	
					return this;
	
				};
	
			}(),
	
			makePerspective: function ( left, right, top, bottom, near, far ) {
	
				if ( far === undefined ) {
	
					console.warn( 'THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.' );
	
				}
	
				var te = this.elements;
				var x = 2 * near / ( right - left );
				var y = 2 * near / ( top - bottom );
	
				var a = ( right + left ) / ( right - left );
				var b = ( top + bottom ) / ( top - bottom );
				var c = - ( far + near ) / ( far - near );
				var d = - 2 * far * near / ( far - near );
	
				te[ 0 ] = x;	te[ 4 ] = 0;	te[ 8 ] = a;	te[ 12 ] = 0;
				te[ 1 ] = 0;	te[ 5 ] = y;	te[ 9 ] = b;	te[ 13 ] = 0;
				te[ 2 ] = 0;	te[ 6 ] = 0;	te[ 10 ] = c;	te[ 14 ] = d;
				te[ 3 ] = 0;	te[ 7 ] = 0;	te[ 11 ] = - 1;	te[ 15 ] = 0;
	
				return this;
	
			},
	
			makeOrthographic: function ( left, right, top, bottom, near, far ) {
	
				var te = this.elements;
				var w = 1.0 / ( right - left );
				var h = 1.0 / ( top - bottom );
				var p = 1.0 / ( far - near );
	
				var x = ( right + left ) * w;
				var y = ( top + bottom ) * h;
				var z = ( far + near ) * p;
	
				te[ 0 ] = 2 * w;	te[ 4 ] = 0;	te[ 8 ] = 0;	te[ 12 ] = - x;
				te[ 1 ] = 0;	te[ 5 ] = 2 * h;	te[ 9 ] = 0;	te[ 13 ] = - y;
				te[ 2 ] = 0;	te[ 6 ] = 0;	te[ 10 ] = - 2 * p;	te[ 14 ] = - z;
				te[ 3 ] = 0;	te[ 7 ] = 0;	te[ 11 ] = 0;	te[ 15 ] = 1;
	
				return this;
	
			},
	
			equals: function ( matrix ) {
	
				var te = this.elements;
				var me = matrix.elements;
	
				for ( var i = 0; i < 16; i ++ ) {
	
					if ( te[ i ] !== me[ i ] ) return false;
	
				}
	
				return true;
	
			},
	
			fromArray: function ( array, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				for ( var i = 0; i < 16; i ++ ) {
	
					this.elements[ i ] = array[ i + offset ];
	
				}
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				var te = this.elements;
	
				array[ offset ] = te[ 0 ];
				array[ offset + 1 ] = te[ 1 ];
				array[ offset + 2 ] = te[ 2 ];
				array[ offset + 3 ] = te[ 3 ];
	
				array[ offset + 4 ] = te[ 4 ];
				array[ offset + 5 ] = te[ 5 ];
				array[ offset + 6 ] = te[ 6 ];
				array[ offset + 7 ] = te[ 7 ];
	
				array[ offset + 8 ] = te[ 8 ];
				array[ offset + 9 ] = te[ 9 ];
				array[ offset + 10 ] = te[ 10 ];
				array[ offset + 11 ] = te[ 11 ];
	
				array[ offset + 12 ] = te[ 12 ];
				array[ offset + 13 ] = te[ 13 ];
				array[ offset + 14 ] = te[ 14 ];
				array[ offset + 15 ] = te[ 15 ];
	
				return array;
	
			}
	
		} );
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 */
	
		function DataTexture( data, width, height, format, type, mapping, wrapS, wrapT, magFilter, minFilter, anisotropy, encoding ) {
	
			Texture.call( this, null, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding );
	
			this.image = { data: data, width: width, height: height };
	
			this.magFilter = magFilter !== undefined ? magFilter : NearestFilter;
			this.minFilter = minFilter !== undefined ? minFilter : NearestFilter;
	
			this.generateMipmaps = false;
			this.flipY = false;
			this.unpackAlignment = 1;
	
		}
	
		DataTexture.prototype = Object.create( Texture.prototype );
		DataTexture.prototype.constructor = DataTexture;
	
		DataTexture.prototype.isDataTexture = true;
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function CubeTexture( images, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding ) {
	
			images = images !== undefined ? images : [];
			mapping = mapping !== undefined ? mapping : CubeReflectionMapping;
	
			Texture.call( this, images, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding );
	
			this.flipY = false;
	
		}
	
		CubeTexture.prototype = Object.create( Texture.prototype );
		CubeTexture.prototype.constructor = CubeTexture;
	
		CubeTexture.prototype.isCubeTexture = true;
	
		Object.defineProperty( CubeTexture.prototype, 'images', {
	
			get: function () {
	
				return this.image;
	
			},
	
			set: function ( value ) {
	
				this.image = value;
	
			}
	
		} );
	
		/**
		 * @author tschw
		 *
		 * Uniforms of a program.
		 * Those form a tree structure with a special top-level container for the root,
		 * which you get by calling 'new WebGLUniforms( gl, program, renderer )'.
		 *
		 *
		 * Properties of inner nodes including the top-level container:
		 *
		 * .seq - array of nested uniforms
		 * .map - nested uniforms by name
		 *
		 *
		 * Methods of all nodes except the top-level container:
		 *
		 * .setValue( gl, value, [renderer] )
		 *
		 * 		uploads a uniform value(s)
		 *  	the 'renderer' parameter is needed for sampler uniforms
		 *
		 *
		 * Static methods of the top-level container (renderer factorizations):
		 *
		 * .upload( gl, seq, values, renderer )
		 *
		 * 		sets uniforms in 'seq' to 'values[id].value'
		 *
		 * .seqWithValue( seq, values ) : filteredSeq
		 *
		 * 		filters 'seq' entries with corresponding entry in values
		 *
		 *
		 * Methods of the top-level container (renderer factorizations):
		 *
		 * .setValue( gl, name, value )
		 *
		 * 		sets uniform with  name 'name' to 'value'
		 *
		 * .set( gl, obj, prop )
		 *
		 * 		sets uniform from object and property with same name than uniform
		 *
		 * .setOptional( gl, obj, prop )
		 *
		 * 		like .set for an optional property of the object
		 *
		 */
	
		var emptyTexture = new Texture();
		var emptyCubeTexture = new CubeTexture();
	
		// --- Base for inner nodes (including the root) ---
	
		function UniformContainer() {
	
			this.seq = [];
			this.map = {};
	
		}
	
		// --- Utilities ---
	
		// Array Caches (provide typed arrays for temporary by size)
	
		var arrayCacheF32 = [];
		var arrayCacheI32 = [];
	
		// Float32Array caches used for uploading Matrix uniforms
	
		var mat4array = new Float32Array( 16 );
		var mat3array = new Float32Array( 9 );
	
		// Flattening for arrays of vectors and matrices
	
		function flatten( array, nBlocks, blockSize ) {
	
			var firstElem = array[ 0 ];
	
			if ( firstElem <= 0 || firstElem > 0 ) return array;
			// unoptimized: ! isNaN( firstElem )
			// see http://jacksondunstan.com/articles/983
	
			var n = nBlocks * blockSize,
				r = arrayCacheF32[ n ];
	
			if ( r === undefined ) {
	
				r = new Float32Array( n );
				arrayCacheF32[ n ] = r;
	
			}
	
			if ( nBlocks !== 0 ) {
	
				firstElem.toArray( r, 0 );
	
				for ( var i = 1, offset = 0; i !== nBlocks; ++ i ) {
	
					offset += blockSize;
					array[ i ].toArray( r, offset );
	
				}
	
			}
	
			return r;
	
		}
	
		// Texture unit allocation
	
		function allocTexUnits( renderer, n ) {
	
			var r = arrayCacheI32[ n ];
	
			if ( r === undefined ) {
	
				r = new Int32Array( n );
				arrayCacheI32[ n ] = r;
	
			}
	
			for ( var i = 0; i !== n; ++ i )
				r[ i ] = renderer.allocTextureUnit();
	
			return r;
	
		}
	
		// --- Setters ---
	
		// Note: Defining these methods externally, because they come in a bunch
		// and this way their names minify.
	
		// Single scalar
	
		function setValue1f( gl, v ) { gl.uniform1f( this.addr, v ); }
		function setValue1i( gl, v ) { gl.uniform1i( this.addr, v ); }
	
		// Single float vector (from flat array or THREE.VectorN)
	
		function setValue2fv( gl, v ) {
	
			if ( v.x === undefined ) gl.uniform2fv( this.addr, v );
			else gl.uniform2f( this.addr, v.x, v.y );
	
		}
	
		function setValue3fv( gl, v ) {
	
			if ( v.x !== undefined )
				gl.uniform3f( this.addr, v.x, v.y, v.z );
			else if ( v.r !== undefined )
				gl.uniform3f( this.addr, v.r, v.g, v.b );
			else
				gl.uniform3fv( this.addr, v );
	
		}
	
		function setValue4fv( gl, v ) {
	
			if ( v.x === undefined ) gl.uniform4fv( this.addr, v );
			else gl.uniform4f( this.addr, v.x, v.y, v.z, v.w );
	
		}
	
		// Single matrix (from flat array or MatrixN)
	
		function setValue2fm( gl, v ) {
	
			gl.uniformMatrix2fv( this.addr, false, v.elements || v );
	
		}
	
		function setValue3fm( gl, v ) {
	
			if ( v.elements === undefined ) {
	
				gl.uniformMatrix3fv( this.addr, false, v );
	
			} else {
	
				mat3array.set( v.elements );
				gl.uniformMatrix3fv( this.addr, false, mat3array );
	
			}
	
		}
	
		function setValue4fm( gl, v ) {
	
			if ( v.elements === undefined ) {
	
				gl.uniformMatrix4fv( this.addr, false, v );
	
			} else {
	
				mat4array.set( v.elements );
				gl.uniformMatrix4fv( this.addr, false, mat4array );
	
			}
	
		}
	
		// Single texture (2D / Cube)
	
		function setValueT1( gl, v, renderer ) {
	
			var unit = renderer.allocTextureUnit();
			gl.uniform1i( this.addr, unit );
			renderer.setTexture2D( v || emptyTexture, unit );
	
		}
	
		function setValueT6( gl, v, renderer ) {
	
			var unit = renderer.allocTextureUnit();
			gl.uniform1i( this.addr, unit );
			renderer.setTextureCube( v || emptyCubeTexture, unit );
	
		}
	
		// Integer / Boolean vectors or arrays thereof (always flat arrays)
	
		function setValue2iv( gl, v ) { gl.uniform2iv( this.addr, v ); }
		function setValue3iv( gl, v ) { gl.uniform3iv( this.addr, v ); }
		function setValue4iv( gl, v ) { gl.uniform4iv( this.addr, v ); }
	
		// Helper to pick the right setter for the singular case
	
		function getSingularSetter( type ) {
	
			switch ( type ) {
	
				case 0x1406: return setValue1f; // FLOAT
				case 0x8b50: return setValue2fv; // _VEC2
				case 0x8b51: return setValue3fv; // _VEC3
				case 0x8b52: return setValue4fv; // _VEC4
	
				case 0x8b5a: return setValue2fm; // _MAT2
				case 0x8b5b: return setValue3fm; // _MAT3
				case 0x8b5c: return setValue4fm; // _MAT4
	
				case 0x8b5e: case 0x8d66: return setValueT1; // SAMPLER_2D, SAMPLER_EXTERNAL_OES
				case 0x8b60: return setValueT6; // SAMPLER_CUBE
	
				case 0x1404: case 0x8b56: return setValue1i; // INT, BOOL
				case 0x8b53: case 0x8b57: return setValue2iv; // _VEC2
				case 0x8b54: case 0x8b58: return setValue3iv; // _VEC3
				case 0x8b55: case 0x8b59: return setValue4iv; // _VEC4
	
			}
	
		}
	
		// Array of scalars
	
		function setValue1fv( gl, v ) { gl.uniform1fv( this.addr, v ); }
		function setValue1iv( gl, v ) { gl.uniform1iv( this.addr, v ); }
	
		// Array of vectors (flat or from THREE classes)
	
		function setValueV2a( gl, v ) {
	
			gl.uniform2fv( this.addr, flatten( v, this.size, 2 ) );
	
		}
	
		function setValueV3a( gl, v ) {
	
			gl.uniform3fv( this.addr, flatten( v, this.size, 3 ) );
	
		}
	
		function setValueV4a( gl, v ) {
	
			gl.uniform4fv( this.addr, flatten( v, this.size, 4 ) );
	
		}
	
		// Array of matrices (flat or from THREE clases)
	
		function setValueM2a( gl, v ) {
	
			gl.uniformMatrix2fv( this.addr, false, flatten( v, this.size, 4 ) );
	
		}
	
		function setValueM3a( gl, v ) {
	
			gl.uniformMatrix3fv( this.addr, false, flatten( v, this.size, 9 ) );
	
		}
	
		function setValueM4a( gl, v ) {
	
			gl.uniformMatrix4fv( this.addr, false, flatten( v, this.size, 16 ) );
	
		}
	
		// Array of textures (2D / Cube)
	
		function setValueT1a( gl, v, renderer ) {
	
			var n = v.length,
				units = allocTexUnits( renderer, n );
	
			gl.uniform1iv( this.addr, units );
	
			for ( var i = 0; i !== n; ++ i ) {
	
				renderer.setTexture2D( v[ i ] || emptyTexture, units[ i ] );
	
			}
	
		}
	
		function setValueT6a( gl, v, renderer ) {
	
			var n = v.length,
				units = allocTexUnits( renderer, n );
	
			gl.uniform1iv( this.addr, units );
	
			for ( var i = 0; i !== n; ++ i ) {
	
				renderer.setTextureCube( v[ i ] || emptyCubeTexture, units[ i ] );
	
			}
	
		}
	
		// Helper to pick the right setter for a pure (bottom-level) array
	
		function getPureArraySetter( type ) {
	
			switch ( type ) {
	
				case 0x1406: return setValue1fv; // FLOAT
				case 0x8b50: return setValueV2a; // _VEC2
				case 0x8b51: return setValueV3a; // _VEC3
				case 0x8b52: return setValueV4a; // _VEC4
	
				case 0x8b5a: return setValueM2a; // _MAT2
				case 0x8b5b: return setValueM3a; // _MAT3
				case 0x8b5c: return setValueM4a; // _MAT4
	
				case 0x8b5e: return setValueT1a; // SAMPLER_2D
				case 0x8b60: return setValueT6a; // SAMPLER_CUBE
	
				case 0x1404: case 0x8b56: return setValue1iv; // INT, BOOL
				case 0x8b53: case 0x8b57: return setValue2iv; // _VEC2
				case 0x8b54: case 0x8b58: return setValue3iv; // _VEC3
				case 0x8b55: case 0x8b59: return setValue4iv; // _VEC4
	
			}
	
		}
	
		// --- Uniform Classes ---
	
		function SingleUniform( id, activeInfo, addr ) {
	
			this.id = id;
			this.addr = addr;
			this.setValue = getSingularSetter( activeInfo.type );
	
			// this.path = activeInfo.name; // DEBUG
	
		}
	
		function PureArrayUniform( id, activeInfo, addr ) {
	
			this.id = id;
			this.addr = addr;
			this.size = activeInfo.size;
			this.setValue = getPureArraySetter( activeInfo.type );
	
			// this.path = activeInfo.name; // DEBUG
	
		}
	
		function StructuredUniform( id ) {
	
			this.id = id;
	
			UniformContainer.call( this ); // mix-in
	
		}
	
		StructuredUniform.prototype.setValue = function ( gl, value ) {
	
			// Note: Don't need an extra 'renderer' parameter, since samplers
			// are not allowed in structured uniforms.
	
			var seq = this.seq;
	
			for ( var i = 0, n = seq.length; i !== n; ++ i ) {
	
				var u = seq[ i ];
				u.setValue( gl, value[ u.id ] );
	
			}
	
		};
	
		// --- Top-level ---
	
		// Parser - builds up the property tree from the path strings
	
		var RePathPart = /([\w\d_]+)(\])?(\[|\.)?/g;
	
		// extracts
		// 	- the identifier (member name or array index)
		//  - followed by an optional right bracket (found when array index)
		//  - followed by an optional left bracket or dot (type of subscript)
		//
		// Note: These portions can be read in a non-overlapping fashion and
		// allow straightforward parsing of the hierarchy that WebGL encodes
		// in the uniform names.
	
		function addUniform( container, uniformObject ) {
	
			container.seq.push( uniformObject );
			container.map[ uniformObject.id ] = uniformObject;
	
		}
	
		function parseUniform( activeInfo, addr, container ) {
	
			var path = activeInfo.name,
				pathLength = path.length;
	
			// reset RegExp object, because of the early exit of a previous run
			RePathPart.lastIndex = 0;
	
			for ( ; ; ) {
	
				var match = RePathPart.exec( path ),
					matchEnd = RePathPart.lastIndex,
	
					id = match[ 1 ],
					idIsIndex = match[ 2 ] === ']',
					subscript = match[ 3 ];
	
				if ( idIsIndex ) id = id | 0; // convert to integer
	
				if ( subscript === undefined || subscript === '[' && matchEnd + 2 === pathLength ) {
	
					// bare name or "pure" bottom-level array "[0]" suffix
	
					addUniform( container, subscript === undefined ?
							new SingleUniform( id, activeInfo, addr ) :
							new PureArrayUniform( id, activeInfo, addr ) );
	
					break;
	
				} else {
	
					// step into inner node / create it in case it doesn't exist
	
					var map = container.map, next = map[ id ];
	
					if ( next === undefined ) {
	
						next = new StructuredUniform( id );
						addUniform( container, next );
	
					}
	
					container = next;
	
				}
	
			}
	
		}
	
		// Root Container
	
		function WebGLUniforms( gl, program, renderer ) {
	
			UniformContainer.call( this );
	
			this.renderer = renderer;
	
			var n = gl.getProgramParameter( program, gl.ACTIVE_UNIFORMS );
	
			for ( var i = 0; i < n; ++ i ) {
	
				var info = gl.getActiveUniform( program, i ),
					path = info.name,
					addr = gl.getUniformLocation( program, path );
	
				parseUniform( info, addr, this );
	
			}
	
		}
	
		WebGLUniforms.prototype.setValue = function ( gl, name, value ) {
	
			var u = this.map[ name ];
	
			if ( u !== undefined ) u.setValue( gl, value, this.renderer );
	
		};
	
		WebGLUniforms.prototype.setOptional = function ( gl, object, name ) {
	
			var v = object[ name ];
	
			if ( v !== undefined ) this.setValue( gl, name, v );
	
		};
	
	
		// Static interface
	
		WebGLUniforms.upload = function ( gl, seq, values, renderer ) {
	
			for ( var i = 0, n = seq.length; i !== n; ++ i ) {
	
				var u = seq[ i ],
					v = values[ u.id ];
	
				if ( v.needsUpdate !== false ) {
	
					// note: always updating when .needsUpdate is undefined
					u.setValue( gl, v.value, renderer );
	
				}
	
			}
	
		};
	
		WebGLUniforms.seqWithValue = function ( seq, values ) {
	
			var r = [];
	
			for ( var i = 0, n = seq.length; i !== n; ++ i ) {
	
				var u = seq[ i ];
				if ( u.id in values ) r.push( u );
	
			}
	
			return r;
	
		};
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		var ColorKeywords = { 'aliceblue': 0xF0F8FF, 'antiquewhite': 0xFAEBD7, 'aqua': 0x00FFFF, 'aquamarine': 0x7FFFD4, 'azure': 0xF0FFFF,
			'beige': 0xF5F5DC, 'bisque': 0xFFE4C4, 'black': 0x000000, 'blanchedalmond': 0xFFEBCD, 'blue': 0x0000FF, 'blueviolet': 0x8A2BE2,
			'brown': 0xA52A2A, 'burlywood': 0xDEB887, 'cadetblue': 0x5F9EA0, 'chartreuse': 0x7FFF00, 'chocolate': 0xD2691E, 'coral': 0xFF7F50,
			'cornflowerblue': 0x6495ED, 'cornsilk': 0xFFF8DC, 'crimson': 0xDC143C, 'cyan': 0x00FFFF, 'darkblue': 0x00008B, 'darkcyan': 0x008B8B,
			'darkgoldenrod': 0xB8860B, 'darkgray': 0xA9A9A9, 'darkgreen': 0x006400, 'darkgrey': 0xA9A9A9, 'darkkhaki': 0xBDB76B, 'darkmagenta': 0x8B008B,
			'darkolivegreen': 0x556B2F, 'darkorange': 0xFF8C00, 'darkorchid': 0x9932CC, 'darkred': 0x8B0000, 'darksalmon': 0xE9967A, 'darkseagreen': 0x8FBC8F,
			'darkslateblue': 0x483D8B, 'darkslategray': 0x2F4F4F, 'darkslategrey': 0x2F4F4F, 'darkturquoise': 0x00CED1, 'darkviolet': 0x9400D3,
			'deeppink': 0xFF1493, 'deepskyblue': 0x00BFFF, 'dimgray': 0x696969, 'dimgrey': 0x696969, 'dodgerblue': 0x1E90FF, 'firebrick': 0xB22222,
			'floralwhite': 0xFFFAF0, 'forestgreen': 0x228B22, 'fuchsia': 0xFF00FF, 'gainsboro': 0xDCDCDC, 'ghostwhite': 0xF8F8FF, 'gold': 0xFFD700,
			'goldenrod': 0xDAA520, 'gray': 0x808080, 'green': 0x008000, 'greenyellow': 0xADFF2F, 'grey': 0x808080, 'honeydew': 0xF0FFF0, 'hotpink': 0xFF69B4,
			'indianred': 0xCD5C5C, 'indigo': 0x4B0082, 'ivory': 0xFFFFF0, 'khaki': 0xF0E68C, 'lavender': 0xE6E6FA, 'lavenderblush': 0xFFF0F5, 'lawngreen': 0x7CFC00,
			'lemonchiffon': 0xFFFACD, 'lightblue': 0xADD8E6, 'lightcoral': 0xF08080, 'lightcyan': 0xE0FFFF, 'lightgoldenrodyellow': 0xFAFAD2, 'lightgray': 0xD3D3D3,
			'lightgreen': 0x90EE90, 'lightgrey': 0xD3D3D3, 'lightpink': 0xFFB6C1, 'lightsalmon': 0xFFA07A, 'lightseagreen': 0x20B2AA, 'lightskyblue': 0x87CEFA,
			'lightslategray': 0x778899, 'lightslategrey': 0x778899, 'lightsteelblue': 0xB0C4DE, 'lightyellow': 0xFFFFE0, 'lime': 0x00FF00, 'limegreen': 0x32CD32,
			'linen': 0xFAF0E6, 'magenta': 0xFF00FF, 'maroon': 0x800000, 'mediumaquamarine': 0x66CDAA, 'mediumblue': 0x0000CD, 'mediumorchid': 0xBA55D3,
			'mediumpurple': 0x9370DB, 'mediumseagreen': 0x3CB371, 'mediumslateblue': 0x7B68EE, 'mediumspringgreen': 0x00FA9A, 'mediumturquoise': 0x48D1CC,
			'mediumvioletred': 0xC71585, 'midnightblue': 0x191970, 'mintcream': 0xF5FFFA, 'mistyrose': 0xFFE4E1, 'moccasin': 0xFFE4B5, 'navajowhite': 0xFFDEAD,
			'navy': 0x000080, 'oldlace': 0xFDF5E6, 'olive': 0x808000, 'olivedrab': 0x6B8E23, 'orange': 0xFFA500, 'orangered': 0xFF4500, 'orchid': 0xDA70D6,
			'palegoldenrod': 0xEEE8AA, 'palegreen': 0x98FB98, 'paleturquoise': 0xAFEEEE, 'palevioletred': 0xDB7093, 'papayawhip': 0xFFEFD5, 'peachpuff': 0xFFDAB9,
			'peru': 0xCD853F, 'pink': 0xFFC0CB, 'plum': 0xDDA0DD, 'powderblue': 0xB0E0E6, 'purple': 0x800080, 'red': 0xFF0000, 'rosybrown': 0xBC8F8F,
			'royalblue': 0x4169E1, 'saddlebrown': 0x8B4513, 'salmon': 0xFA8072, 'sandybrown': 0xF4A460, 'seagreen': 0x2E8B57, 'seashell': 0xFFF5EE,
			'sienna': 0xA0522D, 'silver': 0xC0C0C0, 'skyblue': 0x87CEEB, 'slateblue': 0x6A5ACD, 'slategray': 0x708090, 'slategrey': 0x708090, 'snow': 0xFFFAFA,
			'springgreen': 0x00FF7F, 'steelblue': 0x4682B4, 'tan': 0xD2B48C, 'teal': 0x008080, 'thistle': 0xD8BFD8, 'tomato': 0xFF6347, 'turquoise': 0x40E0D0,
			'violet': 0xEE82EE, 'wheat': 0xF5DEB3, 'white': 0xFFFFFF, 'whitesmoke': 0xF5F5F5, 'yellow': 0xFFFF00, 'yellowgreen': 0x9ACD32 };
	
		function Color( r, g, b ) {
	
			if ( g === undefined && b === undefined ) {
	
				// r is THREE.Color, hex or string
				return this.set( r );
	
			}
	
			return this.setRGB( r, g, b );
	
		}
	
		Object.assign( Color.prototype, {
	
			isColor: true,
	
			r: 1, g: 1, b: 1,
	
			set: function ( value ) {
	
				if ( value && value.isColor ) {
	
					this.copy( value );
	
				} else if ( typeof value === 'number' ) {
	
					this.setHex( value );
	
				} else if ( typeof value === 'string' ) {
	
					this.setStyle( value );
	
				}
	
				return this;
	
			},
	
			setScalar: function ( scalar ) {
	
				this.r = scalar;
				this.g = scalar;
				this.b = scalar;
	
				return this;
	
			},
	
			setHex: function ( hex ) {
	
				hex = Math.floor( hex );
	
				this.r = ( hex >> 16 & 255 ) / 255;
				this.g = ( hex >> 8 & 255 ) / 255;
				this.b = ( hex & 255 ) / 255;
	
				return this;
	
			},
	
			setRGB: function ( r, g, b ) {
	
				this.r = r;
				this.g = g;
				this.b = b;
	
				return this;
	
			},
	
			setHSL: function () {
	
				function hue2rgb( p, q, t ) {
	
					if ( t < 0 ) t += 1;
					if ( t > 1 ) t -= 1;
					if ( t < 1 / 6 ) return p + ( q - p ) * 6 * t;
					if ( t < 1 / 2 ) return q;
					if ( t < 2 / 3 ) return p + ( q - p ) * 6 * ( 2 / 3 - t );
					return p;
	
				}
	
				return function setHSL( h, s, l ) {
	
					// h,s,l ranges are in 0.0 - 1.0
					h = _Math.euclideanModulo( h, 1 );
					s = _Math.clamp( s, 0, 1 );
					l = _Math.clamp( l, 0, 1 );
	
					if ( s === 0 ) {
	
						this.r = this.g = this.b = l;
	
					} else {
	
						var p = l <= 0.5 ? l * ( 1 + s ) : l + s - ( l * s );
						var q = ( 2 * l ) - p;
	
						this.r = hue2rgb( q, p, h + 1 / 3 );
						this.g = hue2rgb( q, p, h );
						this.b = hue2rgb( q, p, h - 1 / 3 );
	
					}
	
					return this;
	
				};
	
			}(),
	
			setStyle: function ( style ) {
	
				function handleAlpha( string ) {
	
					if ( string === undefined ) return;
	
					if ( parseFloat( string ) < 1 ) {
	
						console.warn( 'THREE.Color: Alpha component of ' + style + ' will be ignored.' );
	
					}
	
				}
	
	
				var m;
	
				if ( m = /^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec( style ) ) {
	
					// rgb / hsl
	
					var color;
					var name = m[ 1 ];
					var components = m[ 2 ];
	
					switch ( name ) {
	
						case 'rgb':
						case 'rgba':
	
							if ( color = /^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec( components ) ) {
	
								// rgb(255,0,0) rgba(255,0,0,0.5)
								this.r = Math.min( 255, parseInt( color[ 1 ], 10 ) ) / 255;
								this.g = Math.min( 255, parseInt( color[ 2 ], 10 ) ) / 255;
								this.b = Math.min( 255, parseInt( color[ 3 ], 10 ) ) / 255;
	
								handleAlpha( color[ 5 ] );
	
								return this;
	
							}
	
							if ( color = /^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec( components ) ) {
	
								// rgb(100%,0%,0%) rgba(100%,0%,0%,0.5)
								this.r = Math.min( 100, parseInt( color[ 1 ], 10 ) ) / 100;
								this.g = Math.min( 100, parseInt( color[ 2 ], 10 ) ) / 100;
								this.b = Math.min( 100, parseInt( color[ 3 ], 10 ) ) / 100;
	
								handleAlpha( color[ 5 ] );
	
								return this;
	
							}
	
							break;
	
						case 'hsl':
						case 'hsla':
	
							if ( color = /^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec( components ) ) {
	
								// hsl(120,50%,50%) hsla(120,50%,50%,0.5)
								var h = parseFloat( color[ 1 ] ) / 360;
								var s = parseInt( color[ 2 ], 10 ) / 100;
								var l = parseInt( color[ 3 ], 10 ) / 100;
	
								handleAlpha( color[ 5 ] );
	
								return this.setHSL( h, s, l );
	
							}
	
							break;
	
					}
	
				} else if ( m = /^\#([A-Fa-f0-9]+)$/.exec( style ) ) {
	
					// hex color
	
					var hex = m[ 1 ];
					var size = hex.length;
	
					if ( size === 3 ) {
	
						// #ff0
						this.r = parseInt( hex.charAt( 0 ) + hex.charAt( 0 ), 16 ) / 255;
						this.g = parseInt( hex.charAt( 1 ) + hex.charAt( 1 ), 16 ) / 255;
						this.b = parseInt( hex.charAt( 2 ) + hex.charAt( 2 ), 16 ) / 255;
	
						return this;
	
					} else if ( size === 6 ) {
	
						// #ff0000
						this.r = parseInt( hex.charAt( 0 ) + hex.charAt( 1 ), 16 ) / 255;
						this.g = parseInt( hex.charAt( 2 ) + hex.charAt( 3 ), 16 ) / 255;
						this.b = parseInt( hex.charAt( 4 ) + hex.charAt( 5 ), 16 ) / 255;
	
						return this;
	
					}
	
				}
	
				if ( style && style.length > 0 ) {
	
					// color keywords
					var hex = ColorKeywords[ style ];
	
					if ( hex !== undefined ) {
	
						// red
						this.setHex( hex );
	
					} else {
	
						// unknown color
						console.warn( 'THREE.Color: Unknown color ' + style );
	
					}
	
				}
	
				return this;
	
			},
	
			clone: function () {
	
				return new this.constructor( this.r, this.g, this.b );
	
			},
	
			copy: function ( color ) {
	
				this.r = color.r;
				this.g = color.g;
				this.b = color.b;
	
				return this;
	
			},
	
			copyGammaToLinear: function ( color, gammaFactor ) {
	
				if ( gammaFactor === undefined ) gammaFactor = 2.0;
	
				this.r = Math.pow( color.r, gammaFactor );
				this.g = Math.pow( color.g, gammaFactor );
				this.b = Math.pow( color.b, gammaFactor );
	
				return this;
	
			},
	
			copyLinearToGamma: function ( color, gammaFactor ) {
	
				if ( gammaFactor === undefined ) gammaFactor = 2.0;
	
				var safeInverse = ( gammaFactor > 0 ) ? ( 1.0 / gammaFactor ) : 1.0;
	
				this.r = Math.pow( color.r, safeInverse );
				this.g = Math.pow( color.g, safeInverse );
				this.b = Math.pow( color.b, safeInverse );
	
				return this;
	
			},
	
			convertGammaToLinear: function () {
	
				var r = this.r, g = this.g, b = this.b;
	
				this.r = r * r;
				this.g = g * g;
				this.b = b * b;
	
				return this;
	
			},
	
			convertLinearToGamma: function () {
	
				this.r = Math.sqrt( this.r );
				this.g = Math.sqrt( this.g );
				this.b = Math.sqrt( this.b );
	
				return this;
	
			},
	
			getHex: function () {
	
				return ( this.r * 255 ) << 16 ^ ( this.g * 255 ) << 8 ^ ( this.b * 255 ) << 0;
	
			},
	
			getHexString: function () {
	
				return ( '000000' + this.getHex().toString( 16 ) ).slice( - 6 );
	
			},
	
			getHSL: function ( optionalTarget ) {
	
				// h,s,l ranges are in 0.0 - 1.0
	
				var hsl = optionalTarget || { h: 0, s: 0, l: 0 };
	
				var r = this.r, g = this.g, b = this.b;
	
				var max = Math.max( r, g, b );
				var min = Math.min( r, g, b );
	
				var hue, saturation;
				var lightness = ( min + max ) / 2.0;
	
				if ( min === max ) {
	
					hue = 0;
					saturation = 0;
	
				} else {
	
					var delta = max - min;
	
					saturation = lightness <= 0.5 ? delta / ( max + min ) : delta / ( 2 - max - min );
	
					switch ( max ) {
	
						case r: hue = ( g - b ) / delta + ( g < b ? 6 : 0 ); break;
						case g: hue = ( b - r ) / delta + 2; break;
						case b: hue = ( r - g ) / delta + 4; break;
	
					}
	
					hue /= 6;
	
				}
	
				hsl.h = hue;
				hsl.s = saturation;
				hsl.l = lightness;
	
				return hsl;
	
			},
	
			getStyle: function () {
	
				return 'rgb(' + ( ( this.r * 255 ) | 0 ) + ',' + ( ( this.g * 255 ) | 0 ) + ',' + ( ( this.b * 255 ) | 0 ) + ')';
	
			},
	
			offsetHSL: function ( h, s, l ) {
	
				var hsl = this.getHSL();
	
				hsl.h += h; hsl.s += s; hsl.l += l;
	
				this.setHSL( hsl.h, hsl.s, hsl.l );
	
				return this;
	
			},
	
			add: function ( color ) {
	
				this.r += color.r;
				this.g += color.g;
				this.b += color.b;
	
				return this;
	
			},
	
			addColors: function ( color1, color2 ) {
	
				this.r = color1.r + color2.r;
				this.g = color1.g + color2.g;
				this.b = color1.b + color2.b;
	
				return this;
	
			},
	
			addScalar: function ( s ) {
	
				this.r += s;
				this.g += s;
				this.b += s;
	
				return this;
	
			},
	
			sub: function( color ) {
	
				this.r = Math.max( 0, this.r - color.r );
				this.g = Math.max( 0, this.g - color.g );
				this.b = Math.max( 0, this.b - color.b );
	
				return this;
	
			},
	
			multiply: function ( color ) {
	
				this.r *= color.r;
				this.g *= color.g;
				this.b *= color.b;
	
				return this;
	
			},
	
			multiplyScalar: function ( s ) {
	
				this.r *= s;
				this.g *= s;
				this.b *= s;
	
				return this;
	
			},
	
			lerp: function ( color, alpha ) {
	
				this.r += ( color.r - this.r ) * alpha;
				this.g += ( color.g - this.g ) * alpha;
				this.b += ( color.b - this.b ) * alpha;
	
				return this;
	
			},
	
			equals: function ( c ) {
	
				return ( c.r === this.r ) && ( c.g === this.g ) && ( c.b === this.b );
	
			},
	
			fromArray: function ( array, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				this.r = array[ offset ];
				this.g = array[ offset + 1 ];
				this.b = array[ offset + 2 ];
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				array[ offset ] = this.r;
				array[ offset + 1 ] = this.g;
				array[ offset + 2 ] = this.b;
	
				return array;
	
			},
	
			toJSON: function () {
	
				return this.getHex();
	
			}
	
		} );
	
		/**
		 * Uniforms library for shared webgl shaders
		 */
	
		var UniformsLib = {
	
			common: {
	
				diffuse: { value: new Color( 0xeeeeee ) },
				opacity: { value: 1.0 },
	
				map: { value: null },
				offsetRepeat: { value: new Vector4( 0, 0, 1, 1 ) },
	
				specularMap: { value: null },
				alphaMap: { value: null },
	
				envMap: { value: null },
				flipEnvMap: { value: - 1 },
				reflectivity: { value: 1.0 },
				refractionRatio: { value: 0.98 }
	
			},
	
			aomap: {
	
				aoMap: { value: null },
				aoMapIntensity: { value: 1 }
	
			},
	
			lightmap: {
	
				lightMap: { value: null },
				lightMapIntensity: { value: 1 }
	
			},
	
			emissivemap: {
	
				emissiveMap: { value: null }
	
			},
	
			bumpmap: {
	
				bumpMap: { value: null },
				bumpScale: { value: 1 }
	
			},
	
			normalmap: {
	
				normalMap: { value: null },
				normalScale: { value: new Vector2( 1, 1 ) }
	
			},
	
			displacementmap: {
	
				displacementMap: { value: null },
				displacementScale: { value: 1 },
				displacementBias: { value: 0 }
	
			},
	
			roughnessmap: {
	
				roughnessMap: { value: null }
	
			},
	
			metalnessmap: {
	
				metalnessMap: { value: null }
	
			},
	
			gradientmap: {
	
				gradientMap: { value: null }
	
			},
	
			fog: {
	
				fogDensity: { value: 0.00025 },
				fogNear: { value: 1 },
				fogFar: { value: 2000 },
				fogColor: { value: new Color( 0xffffff ) }
	
			},
	
			lights: {
	
				ambientLightColor: { value: [] },
	
				directionalLights: { value: [], properties: {
					direction: {},
					color: {},
	
					shadow: {},
					shadowBias: {},
					shadowRadius: {},
					shadowMapSize: {}
				} },
	
				directionalShadowMap: { value: [] },
				directionalShadowMatrix: { value: [] },
	
				spotLights: { value: [], properties: {
					color: {},
					position: {},
					direction: {},
					distance: {},
					coneCos: {},
					penumbraCos: {},
					decay: {},
	
					shadow: {},
					shadowBias: {},
					shadowRadius: {},
					shadowMapSize: {}
				} },
	
				spotShadowMap: { value: [] },
				spotShadowMatrix: { value: [] },
	
				pointLights: { value: [], properties: {
					color: {},
					position: {},
					decay: {},
					distance: {},
	
					shadow: {},
					shadowBias: {},
					shadowRadius: {},
					shadowMapSize: {}
				} },
	
				pointShadowMap: { value: [] },
				pointShadowMatrix: { value: [] },
	
				hemisphereLights: { value: [], properties: {
					direction: {},
					skyColor: {},
					groundColor: {}
				} },
	
				// TODO (abelnation): RectAreaLight BRDF data needs to be moved from example to main src
				rectAreaLights: { value: [], properties: {
					color: {},
					position: {},
					width: {},
					height: {}
				} }
	
			},
	
			points: {
	
				diffuse: { value: new Color( 0xeeeeee ) },
				opacity: { value: 1.0 },
				size: { value: 1.0 },
				scale: { value: 1.0 },
				map: { value: null },
				offsetRepeat: { value: new Vector4( 0, 0, 1, 1 ) }
	
			}
	
		};
	
		/**
		 * Uniform Utilities
		 */
	
		var UniformsUtils = {
	
			merge: function ( uniforms ) {
	
				var merged = {};
	
				for ( var u = 0; u < uniforms.length; u ++ ) {
	
					var tmp = this.clone( uniforms[ u ] );
	
					for ( var p in tmp ) {
	
						merged[ p ] = tmp[ p ];
	
					}
	
				}
	
				return merged;
	
			},
	
			clone: function ( uniforms_src ) {
	
				var uniforms_dst = {};
	
				for ( var u in uniforms_src ) {
	
					uniforms_dst[ u ] = {};
	
					for ( var p in uniforms_src[ u ] ) {
	
						var parameter_src = uniforms_src[ u ][ p ];
	
						if ( parameter_src && ( parameter_src.isColor ||
							parameter_src.isMatrix3 || parameter_src.isMatrix4 ||
							parameter_src.isVector2 || parameter_src.isVector3 || parameter_src.isVector4 ||
							parameter_src.isTexture ) ) {
	
							uniforms_dst[ u ][ p ] = parameter_src.clone();
	
						} else if ( Array.isArray( parameter_src ) ) {
	
							uniforms_dst[ u ][ p ] = parameter_src.slice();
	
						} else {
	
							uniforms_dst[ u ][ p ] = parameter_src;
	
						}
	
					}
	
				}
	
				return uniforms_dst;
	
			}
	
		};
	
		var alphamap_fragment = "#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif\n";
	
		var alphamap_pars_fragment = "#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif\n";
	
		var alphatest_fragment = "#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif\n";
	
		var aomap_fragment = "#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif\n";
	
		var aomap_pars_fragment = "#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif";
	
		var begin_vertex = "\nvec3 transformed = vec3( position );\n";
	
		var beginnormal_vertex = "\nvec3 objectNormal = vec3( normal );\n";
	
		var bsdfs = "float punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\tif( decayExponent > 0.0 ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\t\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\t\tfloat maxDistanceCutoffFactor = pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t\treturn distanceFalloff * maxDistanceCutoffFactor;\n#else\n\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n#endif\n\t}\n\treturn 1.0;\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNL = saturate( dot( geometry.normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE  = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS  = 0.5 / LUT_SIZE;\n\tfloat theta = acos( dot( N, V ) );\n\tvec2 uv = vec2(\n\t\tsqrt( saturate( roughness ) ),\n\t\tsaturate( theta / ( 0.5 * PI ) ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.86267 + (0.49788 + 0.01436 * y ) * y;\n\tfloat b = 3.45068 + (4.18814 + y) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = (x > 0.0) ? v : 0.5 * inversesqrt( 1.0 - x * x ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transpose( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tvec3 result = vec3( LTC_ClippedSphereFormFactor( vectorFormFactor ) );\n\treturn result;\n}\nvec3 BRDF_Specular_GGX_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 AB = vec2( -1.04, 1.04 ) * a004 + r.zw;\n\treturn specularColor * AB.x + AB.y;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n";
	
		var bumpmap_pars_fragment = "#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\n\t\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif\n";
	
		var clipping_planes_fragment = "#if NUM_CLIPPING_PLANES > 0\n\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; ++ i ) {\n\t\tvec4 plane = clippingPlanes[ i ];\n\t\tif ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n\t}\n\t\t\n\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\tbool clipped = true;\n\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; ++ i ) {\n\t\t\tvec4 plane = clippingPlanes[ i ];\n\t\t\tclipped = ( dot( vViewPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t}\n\t\tif ( clipped ) discard;\n\t\n\t#endif\n#endif\n";
	
		var clipping_planes_pars_fragment = "#if NUM_CLIPPING_PLANES > 0\n\t#if ! defined( PHYSICAL ) && ! defined( PHONG )\n\t\tvarying vec3 vViewPosition;\n\t#endif\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif\n";
	
		var clipping_planes_pars_vertex = "#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvarying vec3 vViewPosition;\n#endif\n";
	
		var clipping_planes_vertex = "#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n";
	
		var color_fragment = "#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif";
	
		var color_pars_fragment = "#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif\n";
	
		var color_pars_vertex = "#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif";
	
		var color_vertex = "#ifdef USE_COLOR\n\tvColor.xyz = color.xyz;\n#endif";
	
		var common = "#define PI 3.14159265359\n#define PI2 6.28318530718\n#define PI_HALF 1.5707963267949\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#define whiteCompliment(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\nmat3 transpose( const in mat3 v ) {\n\tmat3 tmp;\n\ttmp[0] = vec3(v[0].x, v[1].x, v[2].x);\n\ttmp[1] = vec3(v[0].y, v[1].y, v[2].y);\n\ttmp[2] = vec3(v[0].z, v[1].z, v[2].z);\n\treturn tmp;\n}\n";
	
		var cube_uv_reflection_fragment = "#ifdef ENVMAP_TYPE_CUBE_UV\n#define cubeUV_textureSize (1024.0)\nint getFaceFromDirection(vec3 direction) {\n\tvec3 absDirection = abs(direction);\n\tint face = -1;\n\tif( absDirection.x > absDirection.z ) {\n\t\tif(absDirection.x > absDirection.y )\n\t\t\tface = direction.x > 0.0 ? 0 : 3;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\telse {\n\t\tif(absDirection.z > absDirection.y )\n\t\t\tface = direction.z > 0.0 ? 2 : 5;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\treturn face;\n}\n#define cubeUV_maxLods1  (log2(cubeUV_textureSize*0.25) - 1.0)\n#define cubeUV_rangeClamp (exp2((6.0 - 1.0) * 2.0))\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n\tfloat scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n\tfloat dxRoughness = dFdx(roughness);\n\tfloat dyRoughness = dFdy(roughness);\n\tvec3 dx = dFdx( vec * scale * dxRoughness );\n\tvec3 dy = dFdy( vec * scale * dyRoughness );\n\tfloat d = max( dot( dx, dx ), dot( dy, dy ) );\n\td = clamp(d, 1.0, cubeUV_rangeClamp);\n\tfloat mipLevel = 0.5 * log2(d);\n\treturn vec2(floor(mipLevel), fract(mipLevel));\n}\n#define cubeUV_maxLods2 (log2(cubeUV_textureSize*0.25) - 2.0)\n#define cubeUV_rcpTextureSize (1.0 / cubeUV_textureSize)\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n\tmipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n\tfloat a = 16.0 * cubeUV_rcpTextureSize;\n\tvec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n\tvec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n\tfloat powScale = exp2_packed.x * exp2_packed.y;\n\tfloat scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n\tfloat mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n\tbool bRes = mipLevel == 0.0;\n\tscale =  bRes && (scale < a) ? a : scale;\n\tvec3 r;\n\tvec2 offset;\n\tint face = getFaceFromDirection(direction);\n\tfloat rcpPowScale = 1.0 / powScale;\n\tif( face == 0) {\n\t\tr = vec3(direction.x, -direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 1) {\n\t\tr = vec3(direction.y, direction.x, direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 2) {\n\t\tr = vec3(direction.z, direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 3) {\n\t\tr = vec3(direction.x, direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse if( face == 4) {\n\t\tr = vec3(direction.y, direction.x, -direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse {\n\t\tr = vec3(direction.z, -direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\tr = normalize(r);\n\tfloat texelOffset = 0.5 * cubeUV_rcpTextureSize;\n\tvec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n\tvec2 base = offset + vec2( texelOffset );\n\treturn base + s * ( scale - 2.0 * texelOffset );\n}\n#define cubeUV_maxLods3 (log2(cubeUV_textureSize*0.25) - 3.0)\nvec4 textureCubeUV(vec3 reflectedDirection, float roughness ) {\n\tfloat roughnessVal = roughness* cubeUV_maxLods3;\n\tfloat r1 = floor(roughnessVal);\n\tfloat r2 = r1 + 1.0;\n\tfloat t = fract(roughnessVal);\n\tvec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n\tfloat s = mipInfo.y;\n\tfloat level0 = mipInfo.x;\n\tfloat level1 = level0 + 1.0;\n\tlevel1 = level1 > 5.0 ? 5.0 : level1;\n\tlevel0 += min( floor( s + 0.5 ), 5.0 );\n\tvec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n\tvec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n\tvec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n\tvec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n\tvec4 result = mix(color10, color20, t);\n\treturn vec4(result.rgb, 1.0);\n}\n#endif\n";
	
		var defaultnormal_vertex = "vec3 transformedNormal = normalMatrix * objectNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n";
	
		var displacementmap_pars_vertex = "#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif\n";
	
		var displacementmap_vertex = "#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, uv ).x * displacementScale + displacementBias );\n#endif\n";
	
		var emissivemap_fragment = "#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif\n";
	
		var emissivemap_pars_fragment = "#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif\n";
	
		var encodings_fragment = "  gl_FragColor = linearToOutputTexel( gl_FragColor );\n";
	
		var encodings_pars_fragment = "\nvec4 LinearToLinear( in vec4 value ) {\n\treturn value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.xyz, vec3( gammaFactor ) ), value.w );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.xyz, vec3( 1.0 / gammaFactor ) ), value.w );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.w );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.w );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n\treturn vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n\tfloat maxComponent = max( max( value.r, value.g ), value.b );\n\tfloat fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n\treturn vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.xyz * value.w * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.x, max( value.g, value.b ) );\n\tfloat M      = clamp( maxRGB / maxRange, 0.0, 1.0 );\n\tM            = ceil( M * 255.0 ) / 255.0;\n\treturn vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.x, max( value.g, value.b ) );\n\tfloat D      = max( maxRange / maxRGB, 1.0 );\n\tD            = min( floor( D ) / 255.0, 1.0 );\n\treturn vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n\tvec3 Xp_Y_XYZp = value.rgb * cLogLuvM;\n\tXp_Y_XYZp = max(Xp_Y_XYZp, vec3(1e-6, 1e-6, 1e-6));\n\tvec4 vResult;\n\tvResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n\tfloat Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n\tvResult.w = fract(Le);\n\tvResult.z = (Le - (floor(vResult.w*255.0))/255.0)/255.0;\n\treturn vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n\tfloat Le = value.z * 255.0 + value.w;\n\tvec3 Xp_Y_XYZp;\n\tXp_Y_XYZp.y = exp2((Le - 127.0) / 2.0);\n\tXp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n\tXp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n\tvec3 vRGB = Xp_Y_XYZp.rgb * cLogLuvInverseM;\n\treturn vec4( max(vRGB, 0.0), 1.0 );\n}\n";
	
		var envmap_fragment = "#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\tvec2 sampleUV;\n\t\tsampleUV.y = asin( flipNormal * reflectVec.y ) * RECIPROCAL_PI + 0.5;\n\t\tsampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\tvec3 reflectView = flipNormal * normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0, 0.0, 1.0 ) );\n\t\tvec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\tenvColor = envMapTexelToLinear( envColor );\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif\n";
	
		var envmap_pars_fragment = "#if defined( USE_ENVMAP ) || defined( PHYSICAL )\n\tuniform float reflectivity;\n\tuniform float envMapIntensity;\n#endif\n#ifdef USE_ENVMAP\n\t#if ! defined( PHYSICAL ) && ( defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) )\n\t\tvarying vec3 vWorldPosition;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\tuniform float flipEnvMap;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( PHYSICAL )\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif\n";
	
		var envmap_pars_vertex = "#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif\n";
	
		var envmap_vertex = "#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif\n";
	
		var fog_vertex = "\n#ifdef USE_FOG\nfogDepth = -mvPosition.z;\n#endif";
	
		var fog_pars_vertex = "#ifdef USE_FOG\n  varying float fogDepth;\n#endif\n";
	
		var fog_fragment = "#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * fogDepth * fogDepth * LOG2 ) );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, fogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif\n";
	
		var fog_pars_fragment = "#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float fogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif\n";
	
		var gradientmap_pars_fragment = "#ifdef TOON\n\tuniform sampler2D gradientMap;\n\tvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\t\tfloat dotNL = dot( normal, lightDirection );\n\t\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t\t#ifdef USE_GRADIENTMAP\n\t\t\treturn texture2D( gradientMap, coord ).rgb;\n\t\t#else\n\t\t\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\n\t\t#endif\n\t}\n#endif\n";
	
		var lightmap_fragment = "#ifdef USE_LIGHTMAP\n\treflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif\n";
	
		var lightmap_pars_fragment = "#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif";
	
		var lights_lambert_vertex = "vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvLightFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n#endif\n";
	
		var lights_pars = "uniform vec3 ambientLightColor;\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tdirectLight.color = pointLight.color;\n\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\tdirectLight.visible = ( directLight.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( angleCos > spotLight.coneCos ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltcMat;\tuniform sampler2D ltcMag;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif\n#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\tvec4 envMapColor = textureCubeUV( queryVec, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar - 0.79248 - 0.5 * log2( pow2( blinnShininessExponent ) + 1.0 );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in GeometricContext geometry, const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( -geometry.viewDir, geometry.normal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( -geometry.viewDir, geometry.normal, refractionRatio );\n\t\t#endif\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( blinnShininessExponent, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\tvec4 envMapColor = textureCubeUV(queryReflectVec, BlinnExponentToGGXRoughness(blinnShininessExponent));\n\t\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\t\tvec2 sampleUV;\n\t\t\tsampleUV.y = saturate( reflectVec.y * 0.5 + 0.5 );\n\t\t\tsampleUV.x = atan( reflectVec.z, reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\t\tvec3 reflectView = normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0,0.0,1.0 ) );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif\n";
	
		var lights_phong_fragment = "BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;\n";
	
		var lights_phong_pars_fragment = "varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3\tdiffuseColor;\n\tvec3\tspecularColor;\n\tfloat\tspecularShininess;\n\tfloat\tspecularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifdef TOON\n\t\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\n\t#else\n\t\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\t\tvec3 irradiance = dotNL * directLight.color;\n\t#endif\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)\n";
	
		var lights_physical_fragment = "PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef STANDARD\n\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.clearCoat = saturate( clearCoat );\tmaterial.clearCoatRoughness = clamp( clearCoatRoughness, 0.04, 1.0 );\n#endif\n";
	
		var lights_physical_pars_fragment = "struct PhysicalMaterial {\n\tvec3\tdiffuseColor;\n\tfloat\tspecularRoughness;\n\tvec3\tspecularColor;\n\t#ifndef STANDARD\n\t\tfloat clearCoat;\n\t\tfloat clearCoatRoughness;\n\t#endif\n};\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\nfloat clearCoatDHRApprox( const in float roughness, const in float dotNL ) {\n\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometry.normal;\n\t\tvec3 viewDir = geometry.viewDir;\n\t\tvec3 position = geometry.position;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.specularRoughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos - halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos + halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos + halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos - halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tfloat norm = texture2D( ltcMag, uv ).a;\n\t\tvec4 t = texture2D( ltcMat, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3(   1,   0, t.y ),\n\t\t\tvec3(   0, t.z,   0 ),\n\t\t\tvec3( t.w,   0, t.x )\n\t\t);\n\t\treflectedLight.directSpecular += lightColor * material.specularColor * norm * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\t#ifndef STANDARD\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.directSpecular += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry, material.specularColor, material.specularRoughness );\n\treflectedLight.directDiffuse += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\t#ifndef STANDARD\n\t\treflectedLight.directSpecular += irradiance * material.clearCoat * BRDF_Specular_GGX( directLight, geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 clearCoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifndef STANDARD\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\tfloat dotNL = dotNV;\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.indirectSpecular += ( 1.0 - clearCoatDHR ) * radiance * BRDF_Specular_GGX_Environment( geometry, material.specularColor, material.specularRoughness );\n\t#ifndef STANDARD\n\t\treflectedLight.indirectSpecular += clearCoatRadiance * material.clearCoat * BRDF_Specular_GGX_Environment( geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\n#define Material_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.specularRoughness )\n#define Material_ClearCoat_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.clearCoatRoughness )\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}\n";
	
		var lights_template = "\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = normalize( vViewPosition );\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( pointLight.shadow, directLight.visible ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( spotLight.shadow, directLight.visible ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( directionalLight.shadow, directLight.visible ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#ifdef USE_LIGHTMAP\n\t\tvec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tirradiance += getLightProbeIndirectIrradiance( geometry, 8 );\n\t#endif\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tvec3 radiance = getLightProbeIndirectRadiance( geometry, Material_BlinnShininessExponent( material ), 8 );\n\t#ifndef STANDARD\n\t\tvec3 clearCoatRadiance = getLightProbeIndirectRadiance( geometry, Material_ClearCoat_BlinnShininessExponent( material ), 8 );\n\t#else\n\t\tvec3 clearCoatRadiance = vec3( 0.0 );\n\t#endif\n\tRE_IndirectSpecular( radiance, clearCoatRadiance, geometry, material, reflectedLight );\n#endif\n";
	
		var logdepthbuf_fragment = "#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n\tgl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n#endif";
	
		var logdepthbuf_pars_fragment = "#ifdef USE_LOGDEPTHBUF\n\tuniform float logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n#endif\n";
	
		var logdepthbuf_pars_vertex = "#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n\tuniform float logDepthBufFC;\n#endif";
	
		var logdepthbuf_vertex = "#ifdef USE_LOGDEPTHBUF\n\tgl_Position.z = log2(max( EPSILON, gl_Position.w + 1.0 )) * logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t#else\n\t\tgl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n\t#endif\n#endif\n";
	
		var map_fragment = "#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif\n";
	
		var map_pars_fragment = "#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n";
	
		var map_particle_fragment = "#ifdef USE_MAP\n\tvec4 mapTexel = texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) * offsetRepeat.zw + offsetRepeat.xy );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n";
	
		var map_particle_pars_fragment = "#ifdef USE_MAP\n\tuniform vec4 offsetRepeat;\n\tuniform sampler2D map;\n#endif\n";
	
		var metalnessmap_fragment = "float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif\n";
	
		var metalnessmap_pars_fragment = "#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif";
	
		var morphnormal_vertex = "#ifdef USE_MORPHNORMALS\n\tobjectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n\tobjectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n\tobjectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n\tobjectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif\n";
	
		var morphtarget_pars_vertex = "#ifdef USE_MORPHTARGETS\n\t#ifndef USE_MORPHNORMALS\n\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif";
	
		var morphtarget_vertex = "#ifdef USE_MORPHTARGETS\n\ttransformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n\ttransformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n\ttransformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n\ttransformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\ttransformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n\ttransformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n\ttransformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n\ttransformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\t#endif\n#endif\n";
	
		var normal_flip = "#ifdef DOUBLE_SIDED\n\tfloat flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n#else\n\tfloat flipNormal = 1.0;\n#endif\n";
	
		var normal_fragment = "#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal ) * flipNormal;\n#endif\n#ifdef USE_NORMALMAP\n\tnormal = perturbNormal2Arb( -vViewPosition, normal );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\n";
	
		var normalmap_pars_fragment = "#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n\t\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\n\t\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tvec3 S = normalize( q0 * st1.t - q1 * st0.t );\n\t\tvec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n\t\tvec3 N = normalize( surf_norm );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = normalScale * mapN.xy;\n\t\tmat3 tsn = mat3( S, T, N );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif\n";
	
		var packing = "vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 1.0 - 2.0 * rgb.xyz;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n\treturn linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\n}\n";
	
		var premultiplied_alpha_fragment = "#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif\n";
	
		var project_vertex = "vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );\ngl_Position = projectionMatrix * mvPosition;\n";
	
		var dithering_fragment = "#if defined( DITHERING )\n  gl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif\n";
	
		var dithering_pars_fragment = "#if defined( DITHERING )\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif\n";
	
		var roughnessmap_fragment = "float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.g;\n#endif\n";
	
		var roughnessmap_pars_fragment = "#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif";
	
		var shadowmap_pars_fragment = "#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tfloat texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n\t\tconst vec2 offset = vec2( 0.0, 1.0 );\n\t\tvec2 texelSize = vec2( 1.0 ) / size;\n\t\tvec2 centroidUV = floor( uv * size + 0.5 ) / size;\n\t\tfloat lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n\t\tfloat lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n\t\tfloat rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n\t\tfloat rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n\t\tvec2 f = fract( uv * size + 0.5 );\n\t\tfloat a = mix( lb, lt, f.y );\n\t\tfloat b = mix( rb, rt, f.y );\n\t\tfloat c = mix( a, b, f.x );\n\t\treturn c;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tshadow = (\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn shadow;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\tfloat dp = ( length( lightToPosition ) - shadowBias ) / 1000.0;\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif\n";
	
		var shadowmap_pars_vertex = "#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n#endif\n";
	
		var shadowmap_vertex = "#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n#endif\n";
	
		var shadowmask_pars_fragment = "float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tshadow *= bool( directionalLight.shadow ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tshadow *= bool( spotLight.shadow ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tshadow *= bool( pointLight.shadow ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#endif\n\treturn shadow;\n}\n";
	
		var skinbase_vertex = "#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif";
	
		var skinning_pars_vertex = "#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform sampler2D boneTexture;\n\t\tuniform int boneTextureSize;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureSize ) );\n\t\t\tfloat y = floor( j / float( boneTextureSize ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureSize );\n\t\t\tfloat dy = 1.0 / float( boneTextureSize );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif\n";
	
		var skinning_vertex = "#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif\n";
	
		var skinnormal_vertex = "#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n#endif\n";
	
		var specularmap_fragment = "float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif";
	
		var specularmap_pars_fragment = "#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif";
	
		var tonemapping_fragment = "#if defined( TONE_MAPPING )\n  gl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif\n";
	
		var tonemapping_pars_fragment = "#define saturate(a) clamp( a, 0.0, 1.0 )\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\n";
	
		var uv_pars_fragment = "#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n#endif";
	
		var uv_pars_vertex = "#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n\tuniform vec4 offsetRepeat;\n#endif\n";
	
		var uv_vertex = "#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif";
	
		var uv2_pars_fragment = "#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif";
	
		var uv2_pars_vertex = "#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n#endif";
	
		var uv2_vertex = "#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = uv2;\n#endif";
	
		var worldpos_vertex = "#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( PHYSICAL ) || defined( LAMBERT ) || defined ( USE_SHADOWMAP )\n\tvec4 worldPosition = modelMatrix * vec4( transformed, 1.0 );\n#endif\n";
	
		var cube_frag = "uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tgl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );\n\tgl_FragColor.a *= opacity;\n}\n";
	
		var cube_vert = "varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}\n";
	
		var depth_frag = "#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( gl_FragCoord.z ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n\t#endif\n}\n";
	
		var depth_vert = "#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n";
	
		var distanceRGBA_frag = "uniform vec3 lightPos;\nvarying vec4 vWorldPosition;\n#include <common>\n#include <packing>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tgl_FragColor = packDepthToRGBA( length( vWorldPosition.xyz - lightPos.xyz ) / 1000.0 );\n}\n";
	
		var distanceRGBA_vert = "varying vec4 vWorldPosition;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <skinbase_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition;\n}\n";
	
		var equirect_frag = "uniform sampler2D tEquirect;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldPosition );\n\tvec2 sampleUV;\n\tsampleUV.y = saturate( tFlip * direction.y * -0.5 + 0.5 );\n\tsampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n}\n";
	
		var equirect_vert = "varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}\n";
	
		var linedashed_frag = "uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
	
		var linedashed_vert = "uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\tvLineDistance = scale * lineDistance;\n\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}\n";
	
		var meshbasic_frag = "uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\treflectedLight.indirectDiffuse += texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <normal_flip>\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
	
		var meshbasic_vert = "#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}\n";
	
		var meshlambert_frag = "uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\treflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <normal_flip>\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n";
	
		var meshlambert_vert = "#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n";
	
		var meshphong_frag = "#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_flip>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n";
	
		var meshphong_vert = "#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n";
	
		var meshphysical_frag = "#define PHYSICAL\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifndef STANDARD\n\tuniform float clearCoat;\n\tuniform float clearCoatRoughness;\n#endif\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <lights_pars>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_flip>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n";
	
		var meshphysical_vert = "#define PHYSICAL\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n";
	
		var normal_frag = "#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\nvoid main() {\n\t#include <logdepthbuf_fragment>\n\t#include <normal_flip>\n\t#include <normal_fragment>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\n}\n";
	
		var normal_vert = "#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}\n";
	
		var points_frag = "uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
	
		var points_vert = "uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#ifdef USE_SIZEATTENUATION\n\t\tgl_PointSize = size * ( scale / - mvPosition.z );\n\t#else\n\t\tgl_PointSize = size;\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n";
	
		var shadow_frag = "uniform float opacity;\n#include <common>\n#include <packing>\n#include <bsdfs>\n#include <lights_pars>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( 0.0, 0.0, 0.0, opacity * ( 1.0 - getShadowMask() ) );\n}\n";
	
		var shadow_vert = "#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n}\n";
	
		var ShaderChunk = {
			alphamap_fragment: alphamap_fragment,
			alphamap_pars_fragment: alphamap_pars_fragment,
			alphatest_fragment: alphatest_fragment,
			aomap_fragment: aomap_fragment,
			aomap_pars_fragment: aomap_pars_fragment,
			begin_vertex: begin_vertex,
			beginnormal_vertex: beginnormal_vertex,
			bsdfs: bsdfs,
			bumpmap_pars_fragment: bumpmap_pars_fragment,
			clipping_planes_fragment: clipping_planes_fragment,
			clipping_planes_pars_fragment: clipping_planes_pars_fragment,
			clipping_planes_pars_vertex: clipping_planes_pars_vertex,
			clipping_planes_vertex: clipping_planes_vertex,
			color_fragment: color_fragment,
			color_pars_fragment: color_pars_fragment,
			color_pars_vertex: color_pars_vertex,
			color_vertex: color_vertex,
			common: common,
			cube_uv_reflection_fragment: cube_uv_reflection_fragment,
			defaultnormal_vertex: defaultnormal_vertex,
			displacementmap_pars_vertex: displacementmap_pars_vertex,
			displacementmap_vertex: displacementmap_vertex,
			emissivemap_fragment: emissivemap_fragment,
			emissivemap_pars_fragment: emissivemap_pars_fragment,
			encodings_fragment: encodings_fragment,
			encodings_pars_fragment: encodings_pars_fragment,
			envmap_fragment: envmap_fragment,
			envmap_pars_fragment: envmap_pars_fragment,
			envmap_pars_vertex: envmap_pars_vertex,
			envmap_vertex: envmap_vertex,
			fog_vertex: fog_vertex,
			fog_pars_vertex: fog_pars_vertex,
			fog_fragment: fog_fragment,
			fog_pars_fragment: fog_pars_fragment,
			gradientmap_pars_fragment: gradientmap_pars_fragment,
			lightmap_fragment: lightmap_fragment,
			lightmap_pars_fragment: lightmap_pars_fragment,
			lights_lambert_vertex: lights_lambert_vertex,
			lights_pars: lights_pars,
			lights_phong_fragment: lights_phong_fragment,
			lights_phong_pars_fragment: lights_phong_pars_fragment,
			lights_physical_fragment: lights_physical_fragment,
			lights_physical_pars_fragment: lights_physical_pars_fragment,
			lights_template: lights_template,
			logdepthbuf_fragment: logdepthbuf_fragment,
			logdepthbuf_pars_fragment: logdepthbuf_pars_fragment,
			logdepthbuf_pars_vertex: logdepthbuf_pars_vertex,
			logdepthbuf_vertex: logdepthbuf_vertex,
			map_fragment: map_fragment,
			map_pars_fragment: map_pars_fragment,
			map_particle_fragment: map_particle_fragment,
			map_particle_pars_fragment: map_particle_pars_fragment,
			metalnessmap_fragment: metalnessmap_fragment,
			metalnessmap_pars_fragment: metalnessmap_pars_fragment,
			morphnormal_vertex: morphnormal_vertex,
			morphtarget_pars_vertex: morphtarget_pars_vertex,
			morphtarget_vertex: morphtarget_vertex,
			normal_flip: normal_flip,
			normal_fragment: normal_fragment,
			normalmap_pars_fragment: normalmap_pars_fragment,
			packing: packing,
			premultiplied_alpha_fragment: premultiplied_alpha_fragment,
			project_vertex: project_vertex,
			dithering_fragment: dithering_fragment,
			dithering_pars_fragment: dithering_pars_fragment,
			roughnessmap_fragment: roughnessmap_fragment,
			roughnessmap_pars_fragment: roughnessmap_pars_fragment,
			shadowmap_pars_fragment: shadowmap_pars_fragment,
			shadowmap_pars_vertex: shadowmap_pars_vertex,
			shadowmap_vertex: shadowmap_vertex,
			shadowmask_pars_fragment: shadowmask_pars_fragment,
			skinbase_vertex: skinbase_vertex,
			skinning_pars_vertex: skinning_pars_vertex,
			skinning_vertex: skinning_vertex,
			skinnormal_vertex: skinnormal_vertex,
			specularmap_fragment: specularmap_fragment,
			specularmap_pars_fragment: specularmap_pars_fragment,
			tonemapping_fragment: tonemapping_fragment,
			tonemapping_pars_fragment: tonemapping_pars_fragment,
			uv_pars_fragment: uv_pars_fragment,
			uv_pars_vertex: uv_pars_vertex,
			uv_vertex: uv_vertex,
			uv2_pars_fragment: uv2_pars_fragment,
			uv2_pars_vertex: uv2_pars_vertex,
			uv2_vertex: uv2_vertex,
			worldpos_vertex: worldpos_vertex,
	
			cube_frag: cube_frag,
			cube_vert: cube_vert,
			depth_frag: depth_frag,
			depth_vert: depth_vert,
			distanceRGBA_frag: distanceRGBA_frag,
			distanceRGBA_vert: distanceRGBA_vert,
			equirect_frag: equirect_frag,
			equirect_vert: equirect_vert,
			linedashed_frag: linedashed_frag,
			linedashed_vert: linedashed_vert,
			meshbasic_frag: meshbasic_frag,
			meshbasic_vert: meshbasic_vert,
			meshlambert_frag: meshlambert_frag,
			meshlambert_vert: meshlambert_vert,
			meshphong_frag: meshphong_frag,
			meshphong_vert: meshphong_vert,
			meshphysical_frag: meshphysical_frag,
			meshphysical_vert: meshphysical_vert,
			normal_frag: normal_frag,
			normal_vert: normal_vert,
			points_frag: points_frag,
			points_vert: points_vert,
			shadow_frag: shadow_frag,
			shadow_vert: shadow_vert
		};
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 * @author mrdoob / http://mrdoob.com/
		 * @author mikael emtinger / http://gomo.se/
		 */
	
		var ShaderLib = {
	
			basic: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.common,
					UniformsLib.aomap,
					UniformsLib.lightmap,
					UniformsLib.fog
				] ),
	
				vertexShader: ShaderChunk.meshbasic_vert,
				fragmentShader: ShaderChunk.meshbasic_frag
	
			},
	
			lambert: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.common,
					UniformsLib.aomap,
					UniformsLib.lightmap,
					UniformsLib.emissivemap,
					UniformsLib.fog,
					UniformsLib.lights,
					{
						emissive: { value: new Color( 0x000000 ) }
					}
				] ),
	
				vertexShader: ShaderChunk.meshlambert_vert,
				fragmentShader: ShaderChunk.meshlambert_frag
	
			},
	
			phong: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.common,
					UniformsLib.aomap,
					UniformsLib.lightmap,
					UniformsLib.emissivemap,
					UniformsLib.bumpmap,
					UniformsLib.normalmap,
					UniformsLib.displacementmap,
					UniformsLib.gradientmap,
					UniformsLib.fog,
					UniformsLib.lights,
					{
						emissive: { value: new Color( 0x000000 ) },
						specular: { value: new Color( 0x111111 ) },
						shininess: { value: 30 }
					}
				] ),
	
				vertexShader: ShaderChunk.meshphong_vert,
				fragmentShader: ShaderChunk.meshphong_frag
	
			},
	
			standard: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.common,
					UniformsLib.aomap,
					UniformsLib.lightmap,
					UniformsLib.emissivemap,
					UniformsLib.bumpmap,
					UniformsLib.normalmap,
					UniformsLib.displacementmap,
					UniformsLib.roughnessmap,
					UniformsLib.metalnessmap,
					UniformsLib.fog,
					UniformsLib.lights,
					{
						emissive: { value: new Color( 0x000000 ) },
						roughness: { value: 0.5 },
						metalness: { value: 0.5 },
						envMapIntensity: { value: 1 } // temporary
					}
				] ),
	
				vertexShader: ShaderChunk.meshphysical_vert,
				fragmentShader: ShaderChunk.meshphysical_frag
	
			},
	
			points: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.points,
					UniformsLib.fog
				] ),
	
				vertexShader: ShaderChunk.points_vert,
				fragmentShader: ShaderChunk.points_frag
	
			},
	
			dashed: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.common,
					UniformsLib.fog,
					{
						scale: { value: 1 },
						dashSize: { value: 1 },
						totalSize: { value: 2 }
					}
				] ),
	
				vertexShader: ShaderChunk.linedashed_vert,
				fragmentShader: ShaderChunk.linedashed_frag
	
			},
	
			depth: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.common,
					UniformsLib.displacementmap
				] ),
	
				vertexShader: ShaderChunk.depth_vert,
				fragmentShader: ShaderChunk.depth_frag
	
			},
	
			normal: {
	
				uniforms: UniformsUtils.merge( [
					UniformsLib.common,
					UniformsLib.bumpmap,
					UniformsLib.normalmap,
					UniformsLib.displacementmap,
					{
						opacity: { value: 1.0 }
					}
				] ),
	
				vertexShader: ShaderChunk.normal_vert,
				fragmentShader: ShaderChunk.normal_frag
	
			},
	
			/* -------------------------------------------------------------------------
			//	Cube map shader
			 ------------------------------------------------------------------------- */
	
			cube: {
	
				uniforms: {
					tCube: { value: null },
					tFlip: { value: - 1 },
					opacity: { value: 1.0 }
				},
	
				vertexShader: ShaderChunk.cube_vert,
				fragmentShader: ShaderChunk.cube_frag
	
			},
	
			/* -------------------------------------------------------------------------
			//	Cube map shader
			 ------------------------------------------------------------------------- */
	
			equirect: {
	
				uniforms: {
					tEquirect: { value: null },
					tFlip: { value: - 1 }
				},
	
				vertexShader: ShaderChunk.equirect_vert,
				fragmentShader: ShaderChunk.equirect_frag
	
			},
	
			distanceRGBA: {
	
				uniforms: {
					lightPos: { value: new Vector3() }
				},
	
				vertexShader: ShaderChunk.distanceRGBA_vert,
				fragmentShader: ShaderChunk.distanceRGBA_frag
	
			}
	
		};
	
		ShaderLib.physical = {
	
			uniforms: UniformsUtils.merge( [
				ShaderLib.standard.uniforms,
				{
					clearCoat: { value: 0 },
					clearCoatRoughness: { value: 0 }
				}
			] ),
	
			vertexShader: ShaderChunk.meshphysical_vert,
			fragmentShader: ShaderChunk.meshphysical_frag
	
		};
	
		/**
		 * @author bhouston / http://clara.io
		 */
	
		function Box2( min, max ) {
	
			this.min = ( min !== undefined ) ? min : new Vector2( + Infinity, + Infinity );
			this.max = ( max !== undefined ) ? max : new Vector2( - Infinity, - Infinity );
	
		}
	
		Object.assign( Box2.prototype, {
	
			set: function ( min, max ) {
	
				this.min.copy( min );
				this.max.copy( max );
	
				return this;
	
			},
	
			setFromPoints: function ( points ) {
	
				this.makeEmpty();
	
				for ( var i = 0, il = points.length; i < il; i ++ ) {
	
					this.expandByPoint( points[ i ] );
	
				}
	
				return this;
	
			},
	
			setFromCenterAndSize: function () {
	
				var v1 = new Vector2();
	
				return function setFromCenterAndSize( center, size ) {
	
					var halfSize = v1.copy( size ).multiplyScalar( 0.5 );
					this.min.copy( center ).sub( halfSize );
					this.max.copy( center ).add( halfSize );
	
					return this;
	
				};
	
			}(),
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( box ) {
	
				this.min.copy( box.min );
				this.max.copy( box.max );
	
				return this;
	
			},
	
			makeEmpty: function () {
	
				this.min.x = this.min.y = + Infinity;
				this.max.x = this.max.y = - Infinity;
	
				return this;
	
			},
	
			isEmpty: function () {
	
				// this is a more robust check for empty than ( volume <= 0 ) because volume can get positive with two negative axes
	
				return ( this.max.x < this.min.x ) || ( this.max.y < this.min.y );
	
			},
	
			getCenter: function ( optionalTarget ) {
	
				var result = optionalTarget || new Vector2();
				return this.isEmpty() ? result.set( 0, 0 ) : result.addVectors( this.min, this.max ).multiplyScalar( 0.5 );
	
			},
	
			getSize: function ( optionalTarget ) {
	
				var result = optionalTarget || new Vector2();
				return this.isEmpty() ? result.set( 0, 0 ) : result.subVectors( this.max, this.min );
	
			},
	
			expandByPoint: function ( point ) {
	
				this.min.min( point );
				this.max.max( point );
	
				return this;
	
			},
	
			expandByVector: function ( vector ) {
	
				this.min.sub( vector );
				this.max.add( vector );
	
				return this;
	
			},
	
			expandByScalar: function ( scalar ) {
	
				this.min.addScalar( - scalar );
				this.max.addScalar( scalar );
	
				return this;
	
			},
	
			containsPoint: function ( point ) {
	
				return point.x < this.min.x || point.x > this.max.x ||
					point.y < this.min.y || point.y > this.max.y ? false : true;
	
			},
	
			containsBox: function ( box ) {
	
				return this.min.x <= box.min.x && box.max.x <= this.max.x &&
					this.min.y <= box.min.y && box.max.y <= this.max.y;
	
			},
	
			getParameter: function ( point, optionalTarget ) {
	
				// This can potentially have a divide by zero if the box
				// has a size dimension of 0.
	
				var result = optionalTarget || new Vector2();
	
				return result.set(
					( point.x - this.min.x ) / ( this.max.x - this.min.x ),
					( point.y - this.min.y ) / ( this.max.y - this.min.y )
				);
	
			},
	
			intersectsBox: function ( box ) {
	
				// using 4 splitting planes to rule out intersections
	
				return box.max.x < this.min.x || box.min.x > this.max.x ||
					box.max.y < this.min.y || box.min.y > this.max.y ? false : true;
	
			},
	
			clampPoint: function ( point, optionalTarget ) {
	
				var result = optionalTarget || new Vector2();
				return result.copy( point ).clamp( this.min, this.max );
	
			},
	
			distanceToPoint: function () {
	
				var v1 = new Vector2();
	
				return function distanceToPoint( point ) {
	
					var clampedPoint = v1.copy( point ).clamp( this.min, this.max );
					return clampedPoint.sub( point ).length();
	
				};
	
			}(),
	
			intersect: function ( box ) {
	
				this.min.max( box.min );
				this.max.min( box.max );
	
				return this;
	
			},
	
			union: function ( box ) {
	
				this.min.min( box.min );
				this.max.max( box.max );
	
				return this;
	
			},
	
			translate: function ( offset ) {
	
				this.min.add( offset );
				this.max.add( offset );
	
				return this;
	
			},
	
			equals: function ( box ) {
	
				return box.min.equals( this.min ) && box.max.equals( this.max );
	
			}
	
		} );
	
		/**
		 * @author mikael emtinger / http://gomo.se/
		 * @author alteredq / http://alteredqualia.com/
		 */
	
		function LensFlarePlugin( renderer, flares ) {
	
			var gl = renderer.context;
			var state = renderer.state;
	
			var vertexBuffer, elementBuffer;
			var shader, program, attributes, uniforms;
	
			var tempTexture, occlusionTexture;
	
			function init() {
	
				var vertices = new Float32Array( [
					- 1, - 1,  0, 0,
					 1, - 1,  1, 0,
					 1,  1,  1, 1,
					- 1,  1,  0, 1
				] );
	
				var faces = new Uint16Array( [
					0, 1, 2,
					0, 2, 3
				] );
	
				// buffers
	
				vertexBuffer     = gl.createBuffer();
				elementBuffer    = gl.createBuffer();
	
				gl.bindBuffer( gl.ARRAY_BUFFER, vertexBuffer );
				gl.bufferData( gl.ARRAY_BUFFER, vertices, gl.STATIC_DRAW );
	
				gl.bindBuffer( gl.ELEMENT_ARRAY_BUFFER, elementBuffer );
				gl.bufferData( gl.ELEMENT_ARRAY_BUFFER, faces, gl.STATIC_DRAW );
	
				// textures
	
				tempTexture      = gl.createTexture();
				occlusionTexture = gl.createTexture();
	
				state.bindTexture( gl.TEXTURE_2D, tempTexture );
				gl.texImage2D( gl.TEXTURE_2D, 0, gl.RGB, 16, 16, 0, gl.RGB, gl.UNSIGNED_BYTE, null );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST );
	
				state.bindTexture( gl.TEXTURE_2D, occlusionTexture );
				gl.texImage2D( gl.TEXTURE_2D, 0, gl.RGBA, 16, 16, 0, gl.RGBA, gl.UNSIGNED_BYTE, null );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST );
				gl.texParameteri( gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST );
	
				shader = {
	
					vertexShader: [
	
						"uniform lowp int renderType;",
	
						"uniform vec3 screenPosition;",
						"uniform vec2 scale;",
						"uniform float rotation;",
	
						"uniform sampler2D occlusionMap;",
	
						"attribute vec2 position;",
						"attribute vec2 uv;",
	
						"varying vec2 vUV;",
						"varying float vVisibility;",
	
						"void main() {",
	
							"vUV = uv;",
	
							"vec2 pos = position;",
	
							"if ( renderType == 2 ) {",
	
								"vec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );",
								"visibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );",
	
								"vVisibility =        visibility.r / 9.0;",
								"vVisibility *= 1.0 - visibility.g / 9.0;",
								"vVisibility *=       visibility.b / 9.0;",
								"vVisibility *= 1.0 - visibility.a / 9.0;",
	
								"pos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;",
								"pos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;",
	
							"}",
	
							"gl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );",
	
						"}"
	
					].join( "\n" ),
	
					fragmentShader: [
	
						"uniform lowp int renderType;",
	
						"uniform sampler2D map;",
						"uniform float opacity;",
						"uniform vec3 color;",
	
						"varying vec2 vUV;",
						"varying float vVisibility;",
	
						"void main() {",
	
							// pink square
	
							"if ( renderType == 0 ) {",
	
								"gl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );",
	
							// restore
	
							"} else if ( renderType == 1 ) {",
	
								"gl_FragColor = texture2D( map, vUV );",
	
							// flare
	
							"} else {",
	
								"vec4 texture = texture2D( map, vUV );",
								"texture.a *= opacity * vVisibility;",
								"gl_FragColor = texture;",
								"gl_FragColor.rgb *= color;",
	
							"}",
	
						"}"
	
					].join( "\n" )
	
				};
	
				program = createProgram( shader );
	
				attributes = {
					vertex: gl.getAttribLocation ( program, "position" ),
					uv:     gl.getAttribLocation ( program, "uv" )
				};
	
				uniforms = {
					renderType:     gl.getUniformLocation( program, "renderType" ),
					map:            gl.getUniformLocation( program, "map" ),
					occlusionMap:   gl.getUniformLocation( program, "occlusionMap" ),
					opacity:        gl.getUniformLocation( program, "opacity" ),
					color:          gl.getUniformLocation( program, "color" ),
					scale:          gl.getUniformLocation( program, "scale" ),
					rotation:       gl.getUniformLocation( program, "rotation" ),
					screenPosition: gl.getUniformLocation( program, "screenPosition" )
				};
	
			}
	
			/*
			 * Render lens flares
			 * Method: renders 16x16 0xff00ff-colored points scattered over the light source area,
			 *         reads these back and calculates occlusion.
			 */
	
			this.render = function ( scene, camera, viewport ) {
	
				if ( flares.length === 0 ) return;
	
				var tempPosition = new Vector3();
	
				var invAspect = viewport.w / viewport.z,
					halfViewportWidth = viewport.z * 0.5,
					halfViewportHeight = viewport.w * 0.5;
	
				var size = 16 / viewport.w,
					scale = new Vector2( size * invAspect, size );
	
				var screenPosition = new Vector3( 1, 1, 0 ),
					screenPositionPixels = new Vector2( 1, 1 );
	
				var validArea = new Box2();
	
				validArea.min.set( viewport.x, viewport.y );
				validArea.max.set( viewport.x + ( viewport.z - 16 ), viewport.y + ( viewport.w - 16 ) );
	
				if ( program === undefined ) {
	
					init();
	
				}
	
				gl.useProgram( program );
	
				state.initAttributes();
				state.enableAttribute( attributes.vertex );
				state.enableAttribute( attributes.uv );
				state.disableUnusedAttributes();
	
				// loop through all lens flares to update their occlusion and positions
				// setup gl and common used attribs/uniforms
	
				gl.uniform1i( uniforms.occlusionMap, 0 );
				gl.uniform1i( uniforms.map, 1 );
	
				gl.bindBuffer( gl.ARRAY_BUFFER, vertexBuffer );
				gl.vertexAttribPointer( attributes.vertex, 2, gl.FLOAT, false, 2 * 8, 0 );
				gl.vertexAttribPointer( attributes.uv, 2, gl.FLOAT, false, 2 * 8, 8 );
	
				gl.bindBuffer( gl.ELEMENT_ARRAY_BUFFER, elementBuffer );
	
				state.disable( gl.CULL_FACE );
				state.buffers.depth.setMask( false );
	
				for ( var i = 0, l = flares.length; i < l; i ++ ) {
	
					size = 16 / viewport.w;
					scale.set( size * invAspect, size );
	
					// calc object screen position
	
					var flare = flares[ i ];
	
					tempPosition.set( flare.matrixWorld.elements[ 12 ], flare.matrixWorld.elements[ 13 ], flare.matrixWorld.elements[ 14 ] );
	
					tempPosition.applyMatrix4( camera.matrixWorldInverse );
					tempPosition.applyMatrix4( camera.projectionMatrix );
	
					// setup arrays for gl programs
	
					screenPosition.copy( tempPosition );
	
					// horizontal and vertical coordinate of the lower left corner of the pixels to copy
	
					screenPositionPixels.x = viewport.x + ( screenPosition.x * halfViewportWidth ) + halfViewportWidth - 8;
					screenPositionPixels.y = viewport.y + ( screenPosition.y * halfViewportHeight ) + halfViewportHeight - 8;
	
					// screen cull
	
					if ( validArea.containsPoint( screenPositionPixels ) === true ) {
	
						// save current RGB to temp texture
	
						state.activeTexture( gl.TEXTURE0 );
						state.bindTexture( gl.TEXTURE_2D, null );
						state.activeTexture( gl.TEXTURE1 );
						state.bindTexture( gl.TEXTURE_2D, tempTexture );
						gl.copyTexImage2D( gl.TEXTURE_2D, 0, gl.RGB, screenPositionPixels.x, screenPositionPixels.y, 16, 16, 0 );
	
	
						// render pink quad
	
						gl.uniform1i( uniforms.renderType, 0 );
						gl.uniform2f( uniforms.scale, scale.x, scale.y );
						gl.uniform3f( uniforms.screenPosition, screenPosition.x, screenPosition.y, screenPosition.z );
	
						state.disable( gl.BLEND );
						state.enable( gl.DEPTH_TEST );
	
						gl.drawElements( gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0 );
	
	
						// copy result to occlusionMap
	
						state.activeTexture( gl.TEXTURE0 );
						state.bindTexture( gl.TEXTURE_2D, occlusionTexture );
						gl.copyTexImage2D( gl.TEXTURE_2D, 0, gl.RGBA, screenPositionPixels.x, screenPositionPixels.y, 16, 16, 0 );
	
	
						// restore graphics
	
						gl.uniform1i( uniforms.renderType, 1 );
						state.disable( gl.DEPTH_TEST );
	
						state.activeTexture( gl.TEXTURE1 );
						state.bindTexture( gl.TEXTURE_2D, tempTexture );
						gl.drawElements( gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0 );
	
	
						// update object positions
	
						flare.positionScreen.copy( screenPosition );
	
						if ( flare.customUpdateCallback ) {
	
							flare.customUpdateCallback( flare );
	
						} else {
	
							flare.updateLensFlares();
	
						}
	
						// render flares
	
						gl.uniform1i( uniforms.renderType, 2 );
						state.enable( gl.BLEND );
	
						for ( var j = 0, jl = flare.lensFlares.length; j < jl; j ++ ) {
	
							var sprite = flare.lensFlares[ j ];
	
							if ( sprite.opacity > 0.001 && sprite.scale > 0.001 ) {
	
								screenPosition.x = sprite.x;
								screenPosition.y = sprite.y;
								screenPosition.z = sprite.z;
	
								size = sprite.size * sprite.scale / viewport.w;
	
								scale.x = size * invAspect;
								scale.y = size;
	
								gl.uniform3f( uniforms.screenPosition, screenPosition.x, screenPosition.y, screenPosition.z );
								gl.uniform2f( uniforms.scale, scale.x, scale.y );
								gl.uniform1f( uniforms.rotation, sprite.rotation );
	
								gl.uniform1f( uniforms.opacity, sprite.opacity );
								gl.uniform3f( uniforms.color, sprite.color.r, sprite.color.g, sprite.color.b );
	
								state.setBlending( sprite.blending, sprite.blendEquation, sprite.blendSrc, sprite.blendDst );
								renderer.setTexture2D( sprite.texture, 1 );
	
								gl.drawElements( gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0 );
	
							}
	
						}
	
					}
	
				}
	
				// restore gl
	
				state.enable( gl.CULL_FACE );
				state.enable( gl.DEPTH_TEST );
				state.buffers.depth.setMask( true );
	
				renderer.resetGLState();
	
			};
	
			function createProgram( shader ) {
	
				var program = gl.createProgram();
	
				var fragmentShader = gl.createShader( gl.FRAGMENT_SHADER );
				var vertexShader = gl.createShader( gl.VERTEX_SHADER );
	
				var prefix = "precision " + renderer.getPrecision() + " float;\n";
	
				gl.shaderSource( fragmentShader, prefix + shader.fragmentShader );
				gl.shaderSource( vertexShader, prefix + shader.vertexShader );
	
				gl.compileShader( fragmentShader );
				gl.compileShader( vertexShader );
	
				gl.attachShader( program, fragmentShader );
				gl.attachShader( program, vertexShader );
	
				gl.linkProgram( program );
	
				return program;
	
			}
	
		}
	
		/**
		 * @author mikael emtinger / http://gomo.se/
		 * @author alteredq / http://alteredqualia.com/
		 */
	
		function SpritePlugin( renderer, sprites ) {
	
			var gl = renderer.context;
			var state = renderer.state;
	
			var vertexBuffer, elementBuffer;
			var program, attributes, uniforms;
	
			var texture;
	
			// decompose matrixWorld
	
			var spritePosition = new Vector3();
			var spriteRotation = new Quaternion();
			var spriteScale = new Vector3();
	
			function init() {
	
				var vertices = new Float32Array( [
					- 0.5, - 0.5,  0, 0,
					  0.5, - 0.5,  1, 0,
					  0.5,   0.5,  1, 1,
					- 0.5,   0.5,  0, 1
				] );
	
				var faces = new Uint16Array( [
					0, 1, 2,
					0, 2, 3
				] );
	
				vertexBuffer  = gl.createBuffer();
				elementBuffer = gl.createBuffer();
	
				gl.bindBuffer( gl.ARRAY_BUFFER, vertexBuffer );
				gl.bufferData( gl.ARRAY_BUFFER, vertices, gl.STATIC_DRAW );
	
				gl.bindBuffer( gl.ELEMENT_ARRAY_BUFFER, elementBuffer );
				gl.bufferData( gl.ELEMENT_ARRAY_BUFFER, faces, gl.STATIC_DRAW );
	
				program = createProgram();
	
				attributes = {
					position:			gl.getAttribLocation ( program, 'position' ),
					uv:					gl.getAttribLocation ( program, 'uv' )
				};
	
				uniforms = {
					uvOffset:			gl.getUniformLocation( program, 'uvOffset' ),
					uvScale:			gl.getUniformLocation( program, 'uvScale' ),
	
					rotation:			gl.getUniformLocation( program, 'rotation' ),
					scale:				gl.getUniformLocation( program, 'scale' ),
	
					color:				gl.getUniformLocation( program, 'color' ),
					map:				gl.getUniformLocation( program, 'map' ),
					opacity:			gl.getUniformLocation( program, 'opacity' ),
	
					modelViewMatrix: 	gl.getUniformLocation( program, 'modelViewMatrix' ),
					projectionMatrix:	gl.getUniformLocation( program, 'projectionMatrix' ),
	
					fogType:			gl.getUniformLocation( program, 'fogType' ),
					fogDensity:			gl.getUniformLocation( program, 'fogDensity' ),
					fogNear:			gl.getUniformLocation( program, 'fogNear' ),
					fogFar:				gl.getUniformLocation( program, 'fogFar' ),
					fogColor:			gl.getUniformLocation( program, 'fogColor' ),
	
					alphaTest:			gl.getUniformLocation( program, 'alphaTest' )
				};
	
				var canvas = document.createElementNS( 'http://www.w3.org/1999/xhtml', 'canvas' );
				canvas.width = 8;
				canvas.height = 8;
	
				var context = canvas.getContext( '2d' );
				context.fillStyle = 'white';
				context.fillRect( 0, 0, 8, 8 );
	
				texture = new Texture( canvas );
				texture.needsUpdate = true;
	
			}
	
			this.render = function ( scene, camera ) {
	
				if ( sprites.length === 0 ) return;
	
				// setup gl
	
				if ( program === undefined ) {
	
					init();
	
				}
	
				gl.useProgram( program );
	
				state.initAttributes();
				state.enableAttribute( attributes.position );
				state.enableAttribute( attributes.uv );
				state.disableUnusedAttributes();
	
				state.disable( gl.CULL_FACE );
				state.enable( gl.BLEND );
	
				gl.bindBuffer( gl.ARRAY_BUFFER, vertexBuffer );
				gl.vertexAttribPointer( attributes.position, 2, gl.FLOAT, false, 2 * 8, 0 );
				gl.vertexAttribPointer( attributes.uv, 2, gl.FLOAT, false, 2 * 8, 8 );
	
				gl.bindBuffer( gl.ELEMENT_ARRAY_BUFFER, elementBuffer );
	
				gl.uniformMatrix4fv( uniforms.projectionMatrix, false, camera.projectionMatrix.elements );
	
				state.activeTexture( gl.TEXTURE0 );
				gl.uniform1i( uniforms.map, 0 );
	
				var oldFogType = 0;
				var sceneFogType = 0;
				var fog = scene.fog;
	
				if ( fog ) {
	
					gl.uniform3f( uniforms.fogColor, fog.color.r, fog.color.g, fog.color.b );
	
					if ( fog.isFog ) {
	
						gl.uniform1f( uniforms.fogNear, fog.near );
						gl.uniform1f( uniforms.fogFar, fog.far );
	
						gl.uniform1i( uniforms.fogType, 1 );
						oldFogType = 1;
						sceneFogType = 1;
	
					} else if ( fog.isFogExp2 ) {
	
						gl.uniform1f( uniforms.fogDensity, fog.density );
	
						gl.uniform1i( uniforms.fogType, 2 );
						oldFogType = 2;
						sceneFogType = 2;
	
					}
	
				} else {
	
					gl.uniform1i( uniforms.fogType, 0 );
					oldFogType = 0;
					sceneFogType = 0;
	
				}
	
	
				// update positions and sort
	
				for ( var i = 0, l = sprites.length; i < l; i ++ ) {
	
					var sprite = sprites[ i ];
	
					sprite.modelViewMatrix.multiplyMatrices( camera.matrixWorldInverse, sprite.matrixWorld );
					sprite.z = - sprite.modelViewMatrix.elements[ 14 ];
	
				}
	
				sprites.sort( painterSortStable );
	
				// render all sprites
	
				var scale = [];
	
				for ( var i = 0, l = sprites.length; i < l; i ++ ) {
	
					var sprite = sprites[ i ];
					var material = sprite.material;
	
					if ( material.visible === false ) continue;
	
					sprite.onBeforeRender( renderer, scene, camera, undefined, material, undefined );
	
					gl.uniform1f( uniforms.alphaTest, material.alphaTest );
					gl.uniformMatrix4fv( uniforms.modelViewMatrix, false, sprite.modelViewMatrix.elements );
	
					sprite.matrixWorld.decompose( spritePosition, spriteRotation, spriteScale );
	
					scale[ 0 ] = spriteScale.x;
					scale[ 1 ] = spriteScale.y;
	
					var fogType = 0;
	
					if ( scene.fog && material.fog ) {
	
						fogType = sceneFogType;
	
					}
	
					if ( oldFogType !== fogType ) {
	
						gl.uniform1i( uniforms.fogType, fogType );
						oldFogType = fogType;
	
					}
	
					if ( material.map !== null ) {
	
						gl.uniform2f( uniforms.uvOffset, material.map.offset.x, material.map.offset.y );
						gl.uniform2f( uniforms.uvScale, material.map.repeat.x, material.map.repeat.y );
	
					} else {
	
						gl.uniform2f( uniforms.uvOffset, 0, 0 );
						gl.uniform2f( uniforms.uvScale, 1, 1 );
	
					}
	
					gl.uniform1f( uniforms.opacity, material.opacity );
					gl.uniform3f( uniforms.color, material.color.r, material.color.g, material.color.b );
	
					gl.uniform1f( uniforms.rotation, material.rotation );
					gl.uniform2fv( uniforms.scale, scale );
	
					state.setBlending( material.blending, material.blendEquation, material.blendSrc, material.blendDst, material.blendEquationAlpha, material.blendSrcAlpha, material.blendDstAlpha, material.premultipliedAlpha );
					state.buffers.depth.setTest( material.depthTest );
					state.buffers.depth.setMask( material.depthWrite );
	
					if ( material.map ) {
	
						renderer.setTexture2D( material.map, 0 );
	
					} else {
	
						renderer.setTexture2D( texture, 0 );
	
					}
	
					gl.drawElements( gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0 );
	
					sprite.onAfterRender( renderer, scene, camera, undefined, material, undefined );
	
				}
	
				// restore gl
	
				state.enable( gl.CULL_FACE );
	
				renderer.resetGLState();
	
			};
	
			function createProgram() {
	
				var program = gl.createProgram();
	
				var vertexShader = gl.createShader( gl.VERTEX_SHADER );
				var fragmentShader = gl.createShader( gl.FRAGMENT_SHADER );
	
				gl.shaderSource( vertexShader, [
	
					'precision ' + renderer.getPrecision() + ' float;',
	
					'#define SHADER_NAME ' + 'SpriteMaterial',
	
					'uniform mat4 modelViewMatrix;',
					'uniform mat4 projectionMatrix;',
					'uniform float rotation;',
					'uniform vec2 scale;',
					'uniform vec2 uvOffset;',
					'uniform vec2 uvScale;',
	
					'attribute vec2 position;',
					'attribute vec2 uv;',
	
					'varying vec2 vUV;',
	
					'void main() {',
	
						'vUV = uvOffset + uv * uvScale;',
	
						'vec2 alignedPosition = position * scale;',
	
						'vec2 rotatedPosition;',
						'rotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;',
						'rotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;',
	
						'vec4 finalPosition;',
	
						'finalPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );',
						'finalPosition.xy += rotatedPosition;',
						'finalPosition = projectionMatrix * finalPosition;',
	
						'gl_Position = finalPosition;',
	
					'}'
	
				].join( '\n' ) );
	
				gl.shaderSource( fragmentShader, [
	
					'precision ' + renderer.getPrecision() + ' float;',
	
					'#define SHADER_NAME ' + 'SpriteMaterial',
	
					'uniform vec3 color;',
					'uniform sampler2D map;',
					'uniform float opacity;',
	
					'uniform int fogType;',
					'uniform vec3 fogColor;',
					'uniform float fogDensity;',
					'uniform float fogNear;',
					'uniform float fogFar;',
					'uniform float alphaTest;',
	
					'varying vec2 vUV;',
	
					'void main() {',
	
						'vec4 texture = texture2D( map, vUV );',
	
						'if ( texture.a < alphaTest ) discard;',
	
						'gl_FragColor = vec4( color * texture.xyz, texture.a * opacity );',
	
						'if ( fogType > 0 ) {',
	
							'float depth = gl_FragCoord.z / gl_FragCoord.w;',
							'float fogFactor = 0.0;',
	
							'if ( fogType == 1 ) {',
	
								'fogFactor = smoothstep( fogNear, fogFar, depth );',
	
							'} else {',
	
								'const float LOG2 = 1.442695;',
								'fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );',
								'fogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );',
	
							'}',
	
							'gl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );',
	
						'}',
	
					'}'
	
				].join( '\n' ) );
	
				gl.compileShader( vertexShader );
				gl.compileShader( fragmentShader );
	
				gl.attachShader( program, vertexShader );
				gl.attachShader( program, fragmentShader );
	
				gl.linkProgram( program );
	
				return program;
	
			}
	
			function painterSortStable( a, b ) {
	
				if ( a.renderOrder !== b.renderOrder ) {
	
					return a.renderOrder - b.renderOrder;
	
				} else if ( a.z !== b.z ) {
	
					return b.z - a.z;
	
				} else {
	
					return b.id - a.id;
	
				}
	
			}
	
		}
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author alteredq / http://alteredqualia.com/
		 */
	
		var materialId = 0;
	
		function Material() {
	
			Object.defineProperty( this, 'id', { value: materialId ++ } );
	
			this.uuid = _Math.generateUUID();
	
			this.name = '';
			this.type = 'Material';
	
			this.fog = true;
			this.lights = true;
	
			this.blending = NormalBlending;
			this.side = FrontSide;
			this.shading = SmoothShading; // THREE.FlatShading, THREE.SmoothShading
			this.vertexColors = NoColors; // THREE.NoColors, THREE.VertexColors, THREE.FaceColors
	
			this.opacity = 1;
			this.transparent = false;
	
			this.blendSrc = SrcAlphaFactor;
			this.blendDst = OneMinusSrcAlphaFactor;
			this.blendEquation = AddEquation;
			this.blendSrcAlpha = null;
			this.blendDstAlpha = null;
			this.blendEquationAlpha = null;
	
			this.depthFunc = LessEqualDepth;
			this.depthTest = true;
			this.depthWrite = true;
	
			this.clippingPlanes = null;
			this.clipIntersection = false;
			this.clipShadows = false;
	
			this.colorWrite = true;
	
			this.precision = null; // override the renderer's default precision for this material
	
			this.polygonOffset = false;
			this.polygonOffsetFactor = 0;
			this.polygonOffsetUnits = 0;
	
			this.dithering = false;
	
			this.alphaTest = 0;
			this.premultipliedAlpha = false;
	
			this.overdraw = 0; // Overdrawn pixels (typically between 0 and 1) for fixing antialiasing gaps in CanvasRenderer
	
			this.visible = true;
	
			this.needsUpdate = true;
	
		}
	
		Object.assign( Material.prototype, EventDispatcher.prototype, {
	
			isMaterial: true,
	
			onBeforeCompile: function () {},
	
			setValues: function ( values ) {
	
				if ( values === undefined ) return;
	
				for ( var key in values ) {
	
					var newValue = values[ key ];
	
					if ( newValue === undefined ) {
	
						console.warn( "THREE.Material: '" + key + "' parameter is undefined." );
						continue;
	
					}
	
					var currentValue = this[ key ];
	
					if ( currentValue === undefined ) {
	
						console.warn( "THREE." + this.type + ": '" + key + "' is not a property of this material." );
						continue;
	
					}
	
					if ( currentValue && currentValue.isColor ) {
	
						currentValue.set( newValue );
	
					} else if ( ( currentValue && currentValue.isVector3 ) && ( newValue && newValue.isVector3 ) ) {
	
						currentValue.copy( newValue );
	
					} else if ( key === 'overdraw' ) {
	
						// ensure overdraw is backwards-compatible with legacy boolean type
						this[ key ] = Number( newValue );
	
					} else {
	
						this[ key ] = newValue;
	
					}
	
				}
	
			},
	
			toJSON: function ( meta ) {
	
				var isRoot = meta === undefined;
	
				if ( isRoot ) {
	
					meta = {
						textures: {},
						images: {}
					};
	
				}
	
				var data = {
					metadata: {
						version: 4.5,
						type: 'Material',
						generator: 'Material.toJSON'
					}
				};
	
				// standard Material serialization
				data.uuid = this.uuid;
				data.type = this.type;
	
				if ( this.name !== '' ) data.name = this.name;
	
				if ( this.color && this.color.isColor ) data.color = this.color.getHex();
	
				if ( this.roughness !== undefined ) data.roughness = this.roughness;
				if ( this.metalness !== undefined ) data.metalness = this.metalness;
	
				if ( this.emissive && this.emissive.isColor ) data.emissive = this.emissive.getHex();
				if ( this.specular && this.specular.isColor ) data.specular = this.specular.getHex();
				if ( this.shininess !== undefined ) data.shininess = this.shininess;
				if ( this.clearCoat !== undefined ) data.clearCoat = this.clearCoat;
				if ( this.clearCoatRoughness !== undefined ) data.clearCoatRoughness = this.clearCoatRoughness;
	
				if ( this.map && this.map.isTexture ) data.map = this.map.toJSON( meta ).uuid;
				if ( this.alphaMap && this.alphaMap.isTexture ) data.alphaMap = this.alphaMap.toJSON( meta ).uuid;
				if ( this.lightMap && this.lightMap.isTexture ) data.lightMap = this.lightMap.toJSON( meta ).uuid;
				if ( this.bumpMap && this.bumpMap.isTexture ) {
	
					data.bumpMap = this.bumpMap.toJSON( meta ).uuid;
					data.bumpScale = this.bumpScale;
	
				}
				if ( this.normalMap && this.normalMap.isTexture ) {
	
					data.normalMap = this.normalMap.toJSON( meta ).uuid;
					data.normalScale = this.normalScale.toArray();
	
				}
				if ( this.displacementMap && this.displacementMap.isTexture ) {
	
					data.displacementMap = this.displacementMap.toJSON( meta ).uuid;
					data.displacementScale = this.displacementScale;
					data.displacementBias = this.displacementBias;
	
				}
				if ( this.roughnessMap && this.roughnessMap.isTexture ) data.roughnessMap = this.roughnessMap.toJSON( meta ).uuid;
				if ( this.metalnessMap && this.metalnessMap.isTexture ) data.metalnessMap = this.metalnessMap.toJSON( meta ).uuid;
	
				if ( this.emissiveMap && this.emissiveMap.isTexture ) data.emissiveMap = this.emissiveMap.toJSON( meta ).uuid;
				if ( this.specularMap && this.specularMap.isTexture ) data.specularMap = this.specularMap.toJSON( meta ).uuid;
	
				if ( this.envMap && this.envMap.isTexture ) {
	
					data.envMap = this.envMap.toJSON( meta ).uuid;
					data.reflectivity = this.reflectivity; // Scale behind envMap
	
				}
	
				if ( this.gradientMap && this.gradientMap.isTexture ) {
	
					data.gradientMap = this.gradientMap.toJSON( meta ).uuid;
	
				}
	
				if ( this.size !== undefined ) data.size = this.size;
				if ( this.sizeAttenuation !== undefined ) data.sizeAttenuation = this.sizeAttenuation;
	
				if ( this.blending !== NormalBlending ) data.blending = this.blending;
				if ( this.shading !== SmoothShading ) data.shading = this.shading;
				if ( this.side !== FrontSide ) data.side = this.side;
				if ( this.vertexColors !== NoColors ) data.vertexColors = this.vertexColors;
	
				if ( this.opacity < 1 ) data.opacity = this.opacity;
				if ( this.transparent === true ) data.transparent = this.transparent;
	
				data.depthFunc = this.depthFunc;
				data.depthTest = this.depthTest;
				data.depthWrite = this.depthWrite;
	
				if ( this.alphaTest > 0 ) data.alphaTest = this.alphaTest;
				if ( this.premultipliedAlpha === true ) data.premultipliedAlpha = this.premultipliedAlpha;
				if ( this.wireframe === true ) data.wireframe = this.wireframe;
				if ( this.wireframeLinewidth > 1 ) data.wireframeLinewidth = this.wireframeLinewidth;
				if ( this.wireframeLinecap !== 'round' ) data.wireframeLinecap = this.wireframeLinecap;
				if ( this.wireframeLinejoin !== 'round' ) data.wireframeLinejoin = this.wireframeLinejoin;
	
				data.skinning = this.skinning;
				data.morphTargets = this.morphTargets;
	
				data.dithering = this.dithering;
	
				// TODO: Copied from Object3D.toJSON
	
				function extractFromCache( cache ) {
	
					var values = [];
	
					for ( var key in cache ) {
	
						var data = cache[ key ];
						delete data.metadata;
						values.push( data );
	
					}
	
					return values;
	
				}
	
				if ( isRoot ) {
	
					var textures = extractFromCache( meta.textures );
					var images = extractFromCache( meta.images );
	
					if ( textures.length > 0 ) data.textures = textures;
					if ( images.length > 0 ) data.images = images;
	
				}
	
				return data;
	
			},
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( source ) {
	
				this.name = source.name;
	
				this.fog = source.fog;
				this.lights = source.lights;
	
				this.blending = source.blending;
				this.side = source.side;
				this.shading = source.shading;
				this.vertexColors = source.vertexColors;
	
				this.opacity = source.opacity;
				this.transparent = source.transparent;
	
				this.blendSrc = source.blendSrc;
				this.blendDst = source.blendDst;
				this.blendEquation = source.blendEquation;
				this.blendSrcAlpha = source.blendSrcAlpha;
				this.blendDstAlpha = source.blendDstAlpha;
				this.blendEquationAlpha = source.blendEquationAlpha;
	
				this.depthFunc = source.depthFunc;
				this.depthTest = source.depthTest;
				this.depthWrite = source.depthWrite;
	
				this.colorWrite = source.colorWrite;
	
				this.precision = source.precision;
	
				this.polygonOffset = source.polygonOffset;
				this.polygonOffsetFactor = source.polygonOffsetFactor;
				this.polygonOffsetUnits = source.polygonOffsetUnits;
	
				this.dithering = source.dithering;
	
				this.alphaTest = source.alphaTest;
	
				this.premultipliedAlpha = source.premultipliedAlpha;
	
				this.overdraw = source.overdraw;
	
				this.visible = source.visible;
				this.clipShadows = source.clipShadows;
				this.clipIntersection = source.clipIntersection;
	
				var srcPlanes = source.clippingPlanes,
					dstPlanes = null;
	
				if ( srcPlanes !== null ) {
	
					var n = srcPlanes.length;
					dstPlanes = new Array( n );
	
					for ( var i = 0; i !== n; ++ i )
						dstPlanes[ i ] = srcPlanes[ i ].clone();
	
				}
	
				this.clippingPlanes = dstPlanes;
	
				return this;
	
			},
	
			dispose: function () {
	
				this.dispatchEvent( { type: 'dispose' } );
	
			}
	
		} );
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 *
		 * parameters = {
		 *  defines: { "label" : "value" },
		 *  uniforms: { "parameter1": { value: 1.0 }, "parameter2": { value2: 2 } },
		 *
		 *  fragmentShader: <string>,
		 *  vertexShader: <string>,
		 *
		 *  wireframe: <boolean>,
		 *  wireframeLinewidth: <float>,
		 *
		 *  lights: <bool>,
		 *
		 *  skinning: <bool>,
		 *  morphTargets: <bool>,
		 *  morphNormals: <bool>
		 * }
		 */
	
		function ShaderMaterial( parameters ) {
	
			Material.call( this );
	
			this.type = 'ShaderMaterial';
	
			this.defines = {};
			this.uniforms = {};
	
			this.vertexShader = 'void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}';
			this.fragmentShader = 'void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}';
	
			this.linewidth = 1;
	
			this.wireframe = false;
			this.wireframeLinewidth = 1;
	
			this.fog = false; // set to use scene fog
			this.lights = false; // set to use scene lights
			this.clipping = false; // set to use user-defined clipping planes
	
			this.skinning = false; // set to use skinning attribute streams
			this.morphTargets = false; // set to use morph targets
			this.morphNormals = false; // set to use morph normals
	
			this.extensions = {
				derivatives: false, // set to use derivatives
				fragDepth: false, // set to use fragment depth values
				drawBuffers: false, // set to use draw buffers
				shaderTextureLOD: false // set to use shader texture LOD
			};
	
			// When rendered geometry doesn't include these attributes but the material does,
			// use these default values in WebGL. This avoids errors when buffer data is missing.
			this.defaultAttributeValues = {
				'color': [ 1, 1, 1 ],
				'uv': [ 0, 0 ],
				'uv2': [ 0, 0 ]
			};
	
			this.index0AttributeName = undefined;
	
			if ( parameters !== undefined ) {
	
				if ( parameters.attributes !== undefined ) {
	
					console.error( 'THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead.' );
	
				}
	
				this.setValues( parameters );
	
			}
	
		}
	
		ShaderMaterial.prototype = Object.create( Material.prototype );
		ShaderMaterial.prototype.constructor = ShaderMaterial;
	
		ShaderMaterial.prototype.isShaderMaterial = true;
	
		ShaderMaterial.prototype.copy = function ( source ) {
	
			Material.prototype.copy.call( this, source );
	
			this.fragmentShader = source.fragmentShader;
			this.vertexShader = source.vertexShader;
	
			this.uniforms = UniformsUtils.clone( source.uniforms );
	
			this.defines = source.defines;
	
			this.wireframe = source.wireframe;
			this.wireframeLinewidth = source.wireframeLinewidth;
	
			this.lights = source.lights;
			this.clipping = source.clipping;
	
			this.skinning = source.skinning;
	
			this.morphTargets = source.morphTargets;
			this.morphNormals = source.morphNormals;
	
			this.extensions = source.extensions;
	
			return this;
	
		};
	
		ShaderMaterial.prototype.toJSON = function ( meta ) {
	
			var data = Material.prototype.toJSON.call( this, meta );
	
			data.uniforms = this.uniforms;
			data.vertexShader = this.vertexShader;
			data.fragmentShader = this.fragmentShader;
	
			return data;
	
		};
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author alteredq / http://alteredqualia.com/
		 * @author bhouston / https://clara.io
		 * @author WestLangley / http://github.com/WestLangley
		 *
		 * parameters = {
		 *
		 *  opacity: <float>,
		 *
		 *  map: new THREE.Texture( <Image> ),
		 *
		 *  alphaMap: new THREE.Texture( <Image> ),
		 *
		 *  displacementMap: new THREE.Texture( <Image> ),
		 *  displacementScale: <float>,
		 *  displacementBias: <float>,
		 *
		 *  wireframe: <boolean>,
		 *  wireframeLinewidth: <float>
		 * }
		 */
	
		function MeshDepthMaterial( parameters ) {
	
			Material.call( this );
	
			this.type = 'MeshDepthMaterial';
	
			this.depthPacking = BasicDepthPacking;
	
			this.skinning = false;
			this.morphTargets = false;
	
			this.map = null;
	
			this.alphaMap = null;
	
			this.displacementMap = null;
			this.displacementScale = 1;
			this.displacementBias = 0;
	
			this.wireframe = false;
			this.wireframeLinewidth = 1;
	
			this.fog = false;
			this.lights = false;
	
			this.setValues( parameters );
	
		}
	
		MeshDepthMaterial.prototype = Object.create( Material.prototype );
		MeshDepthMaterial.prototype.constructor = MeshDepthMaterial;
	
		MeshDepthMaterial.prototype.isMeshDepthMaterial = true;
	
		MeshDepthMaterial.prototype.copy = function ( source ) {
	
			Material.prototype.copy.call( this, source );
	
			this.depthPacking = source.depthPacking;
	
			this.skinning = source.skinning;
			this.morphTargets = source.morphTargets;
	
			this.map = source.map;
	
			this.alphaMap = source.alphaMap;
	
			this.displacementMap = source.displacementMap;
			this.displacementScale = source.displacementScale;
			this.displacementBias = source.displacementBias;
	
			this.wireframe = source.wireframe;
			this.wireframeLinewidth = source.wireframeLinewidth;
	
			return this;
	
		};
	
		/**
		 * @author bhouston / http://clara.io
		 * @author WestLangley / http://github.com/WestLangley
		 */
	
		function Box3( min, max ) {
	
			this.min = ( min !== undefined ) ? min : new Vector3( + Infinity, + Infinity, + Infinity );
			this.max = ( max !== undefined ) ? max : new Vector3( - Infinity, - Infinity, - Infinity );
	
		}
	
		Object.assign( Box3.prototype, {
	
			isBox3: true,
	
			set: function ( min, max ) {
	
				this.min.copy( min );
				this.max.copy( max );
	
				return this;
	
			},
	
			setFromArray: function ( array ) {
	
				var minX = + Infinity;
				var minY = + Infinity;
				var minZ = + Infinity;
	
				var maxX = - Infinity;
				var maxY = - Infinity;
				var maxZ = - Infinity;
	
				for ( var i = 0, l = array.length; i < l; i += 3 ) {
	
					var x = array[ i ];
					var y = array[ i + 1 ];
					var z = array[ i + 2 ];
	
					if ( x < minX ) minX = x;
					if ( y < minY ) minY = y;
					if ( z < minZ ) minZ = z;
	
					if ( x > maxX ) maxX = x;
					if ( y > maxY ) maxY = y;
					if ( z > maxZ ) maxZ = z;
	
				}
	
				this.min.set( minX, minY, minZ );
				this.max.set( maxX, maxY, maxZ );
	
				return this;
	
			},
	
			setFromBufferAttribute: function ( attribute ) {
	
				var minX = + Infinity;
				var minY = + Infinity;
				var minZ = + Infinity;
	
				var maxX = - Infinity;
				var maxY = - Infinity;
				var maxZ = - Infinity;
	
				for ( var i = 0, l = attribute.count; i < l; i ++ ) {
	
					var x = attribute.getX( i );
					var y = attribute.getY( i );
					var z = attribute.getZ( i );
	
					if ( x < minX ) minX = x;
					if ( y < minY ) minY = y;
					if ( z < minZ ) minZ = z;
	
					if ( x > maxX ) maxX = x;
					if ( y > maxY ) maxY = y;
					if ( z > maxZ ) maxZ = z;
	
				}
	
				this.min.set( minX, minY, minZ );
				this.max.set( maxX, maxY, maxZ );
	
				return this;
	
			},
	
			setFromPoints: function ( points ) {
	
				this.makeEmpty();
	
				for ( var i = 0, il = points.length; i < il; i ++ ) {
	
					this.expandByPoint( points[ i ] );
	
				}
	
				return this;
	
			},
	
			setFromCenterAndSize: function () {
	
				var v1 = new Vector3();
	
				return function setFromCenterAndSize( center, size ) {
	
					var halfSize = v1.copy( size ).multiplyScalar( 0.5 );
	
					this.min.copy( center ).sub( halfSize );
					this.max.copy( center ).add( halfSize );
	
					return this;
	
				};
	
			}(),
	
			setFromObject: function ( object ) {
	
				this.makeEmpty();
	
				return this.expandByObject( object );
	
			},
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( box ) {
	
				this.min.copy( box.min );
				this.max.copy( box.max );
	
				return this;
	
			},
	
			makeEmpty: function () {
	
				this.min.x = this.min.y = this.min.z = + Infinity;
				this.max.x = this.max.y = this.max.z = - Infinity;
	
				return this;
	
			},
	
			isEmpty: function () {
	
				// this is a more robust check for empty than ( volume <= 0 ) because volume can get positive with two negative axes
	
				return ( this.max.x < this.min.x ) || ( this.max.y < this.min.y ) || ( this.max.z < this.min.z );
	
			},
	
			getCenter: function ( optionalTarget ) {
	
				var result = optionalTarget || new Vector3();
				return this.isEmpty() ? result.set( 0, 0, 0 ) : result.addVectors( this.min, this.max ).multiplyScalar( 0.5 );
	
			},
	
			getSize: function ( optionalTarget ) {
	
				var result = optionalTarget || new Vector3();
				return this.isEmpty() ? result.set( 0, 0, 0 ) : result.subVectors( this.max, this.min );
	
			},
	
			expandByPoint: function ( point ) {
	
				this.min.min( point );
				this.max.max( point );
	
				return this;
	
			},
	
			expandByVector: function ( vector ) {
	
				this.min.sub( vector );
				this.max.add( vector );
	
				return this;
	
			},
	
			expandByScalar: function ( scalar ) {
	
				this.min.addScalar( - scalar );
				this.max.addScalar( scalar );
	
				return this;
	
			},
	
			expandByObject: function () {
	
				// Computes the world-axis-aligned bounding box of an object (including its children),
				// accounting for both the object's, and children's, world transforms
	
				var v1 = new Vector3();
	
				return function expandByObject( object ) {
	
					var scope = this;
	
					object.updateMatrixWorld( true );
	
					object.traverse( function ( node ) {
	
						var i, l;
	
						var geometry = node.geometry;
	
						if ( geometry !== undefined ) {
	
							if ( geometry.isGeometry ) {
	
								var vertices = geometry.vertices;
	
								for ( i = 0, l = vertices.length; i < l; i ++ ) {
	
									v1.copy( vertices[ i ] );
									v1.applyMatrix4( node.matrixWorld );
	
									scope.expandByPoint( v1 );
	
								}
	
							} else if ( geometry.isBufferGeometry ) {
	
								var attribute = geometry.attributes.position;
	
								if ( attribute !== undefined ) {
	
									for ( i = 0, l = attribute.count; i < l; i ++ ) {
	
										v1.fromBufferAttribute( attribute, i ).applyMatrix4( node.matrixWorld );
	
										scope.expandByPoint( v1 );
	
									}
	
								}
	
							}
	
						}
	
					} );
	
					return this;
	
				};
	
			}(),
	
			containsPoint: function ( point ) {
	
				return point.x < this.min.x || point.x > this.max.x ||
					point.y < this.min.y || point.y > this.max.y ||
					point.z < this.min.z || point.z > this.max.z ? false : true;
	
			},
	
			containsBox: function ( box ) {
	
				return this.min.x <= box.min.x && box.max.x <= this.max.x &&
					this.min.y <= box.min.y && box.max.y <= this.max.y &&
					this.min.z <= box.min.z && box.max.z <= this.max.z;
	
			},
	
			getParameter: function ( point, optionalTarget ) {
	
				// This can potentially have a divide by zero if the box
				// has a size dimension of 0.
	
				var result = optionalTarget || new Vector3();
	
				return result.set(
					( point.x - this.min.x ) / ( this.max.x - this.min.x ),
					( point.y - this.min.y ) / ( this.max.y - this.min.y ),
					( point.z - this.min.z ) / ( this.max.z - this.min.z )
				);
	
			},
	
			intersectsBox: function ( box ) {
	
				// using 6 splitting planes to rule out intersections.
				return box.max.x < this.min.x || box.min.x > this.max.x ||
					box.max.y < this.min.y || box.min.y > this.max.y ||
					box.max.z < this.min.z || box.min.z > this.max.z ? false : true;
	
			},
	
			intersectsSphere: ( function () {
	
				var closestPoint = new Vector3();
	
				return function intersectsSphere( sphere ) {
	
					// Find the point on the AABB closest to the sphere center.
					this.clampPoint( sphere.center, closestPoint );
	
					// If that point is inside the sphere, the AABB and sphere intersect.
					return closestPoint.distanceToSquared( sphere.center ) <= ( sphere.radius * sphere.radius );
	
				};
	
			} )(),
	
			intersectsPlane: function ( plane ) {
	
				// We compute the minimum and maximum dot product values. If those values
				// are on the same side (back or front) of the plane, then there is no intersection.
	
				var min, max;
	
				if ( plane.normal.x > 0 ) {
	
					min = plane.normal.x * this.min.x;
					max = plane.normal.x * this.max.x;
	
				} else {
	
					min = plane.normal.x * this.max.x;
					max = plane.normal.x * this.min.x;
	
				}
	
				if ( plane.normal.y > 0 ) {
	
					min += plane.normal.y * this.min.y;
					max += plane.normal.y * this.max.y;
	
				} else {
	
					min += plane.normal.y * this.max.y;
					max += plane.normal.y * this.min.y;
	
				}
	
				if ( plane.normal.z > 0 ) {
	
					min += plane.normal.z * this.min.z;
					max += plane.normal.z * this.max.z;
	
				} else {
	
					min += plane.normal.z * this.max.z;
					max += plane.normal.z * this.min.z;
	
				}
	
				return ( min <= plane.constant && max >= plane.constant );
	
			},
	
			clampPoint: function ( point, optionalTarget ) {
	
				var result = optionalTarget || new Vector3();
				return result.copy( point ).clamp( this.min, this.max );
	
			},
	
			distanceToPoint: function () {
	
				var v1 = new Vector3();
	
				return function distanceToPoint( point ) {
	
					var clampedPoint = v1.copy( point ).clamp( this.min, this.max );
					return clampedPoint.sub( point ).length();
	
				};
	
			}(),
	
			getBoundingSphere: function () {
	
				var v1 = new Vector3();
	
				return function getBoundingSphere( optionalTarget ) {
	
					var result = optionalTarget || new Sphere();
	
					this.getCenter( result.center );
	
					result.radius = this.getSize( v1 ).length() * 0.5;
	
					return result;
	
				};
	
			}(),
	
			intersect: function ( box ) {
	
				this.min.max( box.min );
				this.max.min( box.max );
	
				// ensure that if there is no overlap, the result is fully empty, not slightly empty with non-inf/+inf values that will cause subsequence intersects to erroneously return valid values.
				if( this.isEmpty() ) this.makeEmpty();
	
				return this;
	
			},
	
			union: function ( box ) {
	
				this.min.min( box.min );
				this.max.max( box.max );
	
				return this;
	
			},
	
			applyMatrix4: function () {
	
				var points = [
					new Vector3(),
					new Vector3(),
					new Vector3(),
					new Vector3(),
					new Vector3(),
					new Vector3(),
					new Vector3(),
					new Vector3()
				];
	
				return function applyMatrix4( matrix ) {
	
					// transform of empty box is an empty box.
					if( this.isEmpty() ) return this;
	
					// NOTE: I am using a binary pattern to specify all 2^3 combinations below
					points[ 0 ].set( this.min.x, this.min.y, this.min.z ).applyMatrix4( matrix ); // 000
					points[ 1 ].set( this.min.x, this.min.y, this.max.z ).applyMatrix4( matrix ); // 001
					points[ 2 ].set( this.min.x, this.max.y, this.min.z ).applyMatrix4( matrix ); // 010
					points[ 3 ].set( this.min.x, this.max.y, this.max.z ).applyMatrix4( matrix ); // 011
					points[ 4 ].set( this.max.x, this.min.y, this.min.z ).applyMatrix4( matrix ); // 100
					points[ 5 ].set( this.max.x, this.min.y, this.max.z ).applyMatrix4( matrix ); // 101
					points[ 6 ].set( this.max.x, this.max.y, this.min.z ).applyMatrix4( matrix ); // 110
					points[ 7 ].set( this.max.x, this.max.y, this.max.z ).applyMatrix4( matrix );	// 111
	
					this.setFromPoints( points );
	
					return this;
	
				};
	
			}(),
	
			translate: function ( offset ) {
	
				this.min.add( offset );
				this.max.add( offset );
	
				return this;
	
			},
	
			equals: function ( box ) {
	
				return box.min.equals( this.min ) && box.max.equals( this.max );
	
			}
	
		} );
	
		/**
		 * @author bhouston / http://clara.io
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function Sphere( center, radius ) {
	
			this.center = ( center !== undefined ) ? center : new Vector3();
			this.radius = ( radius !== undefined ) ? radius : 0;
	
		}
	
		Object.assign( Sphere.prototype, {
	
			set: function ( center, radius ) {
	
				this.center.copy( center );
				this.radius = radius;
	
				return this;
	
			},
	
			setFromPoints: function () {
	
				var box = new Box3();
	
				return function setFromPoints( points, optionalCenter ) {
	
					var center = this.center;
	
					if ( optionalCenter !== undefined ) {
	
						center.copy( optionalCenter );
	
					} else {
	
						box.setFromPoints( points ).getCenter( center );
	
					}
	
					var maxRadiusSq = 0;
	
					for ( var i = 0, il = points.length; i < il; i ++ ) {
	
						maxRadiusSq = Math.max( maxRadiusSq, center.distanceToSquared( points[ i ] ) );
	
					}
	
					this.radius = Math.sqrt( maxRadiusSq );
	
					return this;
	
				};
	
			}(),
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( sphere ) {
	
				this.center.copy( sphere.center );
				this.radius = sphere.radius;
	
				return this;
	
			},
	
			empty: function () {
	
				return ( this.radius <= 0 );
	
			},
	
			containsPoint: function ( point ) {
	
				return ( point.distanceToSquared( this.center ) <= ( this.radius * this.radius ) );
	
			},
	
			distanceToPoint: function ( point ) {
	
				return ( point.distanceTo( this.center ) - this.radius );
	
			},
	
			intersectsSphere: function ( sphere ) {
	
				var radiusSum = this.radius + sphere.radius;
	
				return sphere.center.distanceToSquared( this.center ) <= ( radiusSum * radiusSum );
	
			},
	
			intersectsBox: function ( box ) {
	
				return box.intersectsSphere( this );
	
			},
	
			intersectsPlane: function ( plane ) {
	
				// We use the following equation to compute the signed distance from
				// the center of the sphere to the plane.
				//
				// distance = q * n - d
				//
				// If this distance is greater than the radius of the sphere,
				// then there is no intersection.
	
				return Math.abs( this.center.dot( plane.normal ) - plane.constant ) <= this.radius;
	
			},
	
			clampPoint: function ( point, optionalTarget ) {
	
				var deltaLengthSq = this.center.distanceToSquared( point );
	
				var result = optionalTarget || new Vector3();
	
				result.copy( point );
	
				if ( deltaLengthSq > ( this.radius * this.radius ) ) {
	
					result.sub( this.center ).normalize();
					result.multiplyScalar( this.radius ).add( this.center );
	
				}
	
				return result;
	
			},
	
			getBoundingBox: function ( optionalTarget ) {
	
				var box = optionalTarget || new Box3();
	
				box.set( this.center, this.center );
				box.expandByScalar( this.radius );
	
				return box;
	
			},
	
			applyMatrix4: function ( matrix ) {
	
				this.center.applyMatrix4( matrix );
				this.radius = this.radius * matrix.getMaxScaleOnAxis();
	
				return this;
	
			},
	
			translate: function ( offset ) {
	
				this.center.add( offset );
	
				return this;
	
			},
	
			equals: function ( sphere ) {
	
				return sphere.center.equals( this.center ) && ( sphere.radius === this.radius );
	
			}
	
		} );
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 * @author WestLangley / http://github.com/WestLangley
		 * @author bhouston / http://clara.io
		 * @author tschw
		 */
	
		function Matrix3() {
	
			this.elements = [
	
				1, 0, 0,
				0, 1, 0,
				0, 0, 1
	
			];
	
			if ( arguments.length > 0 ) {
	
				console.error( 'THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.' );
	
			}
	
		}
	
		Object.assign( Matrix3.prototype, {
	
			isMatrix3: true,
	
			set: function ( n11, n12, n13, n21, n22, n23, n31, n32, n33 ) {
	
				var te = this.elements;
	
				te[ 0 ] = n11; te[ 1 ] = n21; te[ 2 ] = n31;
				te[ 3 ] = n12; te[ 4 ] = n22; te[ 5 ] = n32;
				te[ 6 ] = n13; te[ 7 ] = n23; te[ 8 ] = n33;
	
				return this;
	
			},
	
			identity: function () {
	
				this.set(
	
					1, 0, 0,
					0, 1, 0,
					0, 0, 1
	
				);
	
				return this;
	
			},
	
			clone: function () {
	
				return new this.constructor().fromArray( this.elements );
	
			},
	
			copy: function ( m ) {
	
				var te = this.elements;
				var me = m.elements;
	
				te[ 0 ] = me[ 0 ]; te[ 1 ] = me[ 1 ]; te[ 2 ] = me[ 2 ];
				te[ 3 ] = me[ 3 ]; te[ 4 ] = me[ 4 ]; te[ 5 ] = me[ 5 ];
				te[ 6 ] = me[ 6 ]; te[ 7 ] = me[ 7 ]; te[ 8 ] = me[ 8 ];
	
				return this;
	
			},
	
			setFromMatrix4: function ( m ) {
	
				var me = m.elements;
	
				this.set(
	
					me[ 0 ], me[ 4 ], me[  8 ],
					me[ 1 ], me[ 5 ], me[  9 ],
					me[ 2 ], me[ 6 ], me[ 10 ]
	
				);
	
				return this;
	
			},
	
			applyToBufferAttribute: function () {
	
				var v1 = new Vector3();
	
				return function applyToBufferAttribute( attribute ) {
	
					for ( var i = 0, l = attribute.count; i < l; i ++ ) {
	
						v1.x = attribute.getX( i );
						v1.y = attribute.getY( i );
						v1.z = attribute.getZ( i );
	
						v1.applyMatrix3( this );
	
						attribute.setXYZ( i, v1.x, v1.y, v1.z );
	
					}
	
					return attribute;
	
				};
	
			}(),
	
			multiply: function ( m ) {
	
				return this.multiplyMatrices( this, m );
	
			},
	
			premultiply: function ( m ) {
	
				return this.multiplyMatrices( m, this );
	
			},
	
			multiplyMatrices: function ( a, b ) {
	
				var ae = a.elements;
				var be = b.elements;
				var te = this.elements;
	
				var a11 = ae[ 0 ], a12 = ae[ 3 ], a13 = ae[ 6 ];
				var a21 = ae[ 1 ], a22 = ae[ 4 ], a23 = ae[ 7 ];
				var a31 = ae[ 2 ], a32 = ae[ 5 ], a33 = ae[ 8 ];
	
				var b11 = be[ 0 ], b12 = be[ 3 ], b13 = be[ 6 ];
				var b21 = be[ 1 ], b22 = be[ 4 ], b23 = be[ 7 ];
				var b31 = be[ 2 ], b32 = be[ 5 ], b33 = be[ 8 ];
	
				te[ 0 ] = a11 * b11 + a12 * b21 + a13 * b31;
				te[ 3 ] = a11 * b12 + a12 * b22 + a13 * b32;
				te[ 6 ] = a11 * b13 + a12 * b23 + a13 * b33;
	
				te[ 1 ] = a21 * b11 + a22 * b21 + a23 * b31;
				te[ 4 ] = a21 * b12 + a22 * b22 + a23 * b32;
				te[ 7 ] = a21 * b13 + a22 * b23 + a23 * b33;
	
				te[ 2 ] = a31 * b11 + a32 * b21 + a33 * b31;
				te[ 5 ] = a31 * b12 + a32 * b22 + a33 * b32;
				te[ 8 ] = a31 * b13 + a32 * b23 + a33 * b33;
	
				return this;
	
			},
	
			multiplyScalar: function ( s ) {
	
				var te = this.elements;
	
				te[ 0 ] *= s; te[ 3 ] *= s; te[ 6 ] *= s;
				te[ 1 ] *= s; te[ 4 ] *= s; te[ 7 ] *= s;
				te[ 2 ] *= s; te[ 5 ] *= s; te[ 8 ] *= s;
	
				return this;
	
			},
	
			determinant: function () {
	
				var te = this.elements;
	
				var a = te[ 0 ], b = te[ 1 ], c = te[ 2 ],
					d = te[ 3 ], e = te[ 4 ], f = te[ 5 ],
					g = te[ 6 ], h = te[ 7 ], i = te[ 8 ];
	
				return a * e * i - a * f * h - b * d * i + b * f * g + c * d * h - c * e * g;
	
			},
	
			getInverse: function ( matrix, throwOnDegenerate ) {
	
				if ( matrix && matrix.isMatrix4 ) {
	
					console.error( "THREE.Matrix3.getInverse no longer takes a Matrix4 argument." );
	
				}
	
				var me = matrix.elements,
					te = this.elements,
	
					n11 = me[ 0 ], n21 = me[ 1 ], n31 = me[ 2 ],
					n12 = me[ 3 ], n22 = me[ 4 ], n32 = me[ 5 ],
					n13 = me[ 6 ], n23 = me[ 7 ], n33 = me[ 8 ],
	
					t11 = n33 * n22 - n32 * n23,
					t12 = n32 * n13 - n33 * n12,
					t13 = n23 * n12 - n22 * n13,
	
					det = n11 * t11 + n21 * t12 + n31 * t13;
	
				if ( det === 0 ) {
	
					var msg = "THREE.Matrix3.getInverse(): can't invert matrix, determinant is 0";
	
					if ( throwOnDegenerate === true ) {
	
						throw new Error( msg );
	
					} else {
	
						console.warn( msg );
	
					}
	
					return this.identity();
	
				}
	
				var detInv = 1 / det;
	
				te[ 0 ] = t11 * detInv;
				te[ 1 ] = ( n31 * n23 - n33 * n21 ) * detInv;
				te[ 2 ] = ( n32 * n21 - n31 * n22 ) * detInv;
	
				te[ 3 ] = t12 * detInv;
				te[ 4 ] = ( n33 * n11 - n31 * n13 ) * detInv;
				te[ 5 ] = ( n31 * n12 - n32 * n11 ) * detInv;
	
				te[ 6 ] = t13 * detInv;
				te[ 7 ] = ( n21 * n13 - n23 * n11 ) * detInv;
				te[ 8 ] = ( n22 * n11 - n21 * n12 ) * detInv;
	
				return this;
	
			},
	
			transpose: function () {
	
				var tmp, m = this.elements;
	
				tmp = m[ 1 ]; m[ 1 ] = m[ 3 ]; m[ 3 ] = tmp;
				tmp = m[ 2 ]; m[ 2 ] = m[ 6 ]; m[ 6 ] = tmp;
				tmp = m[ 5 ]; m[ 5 ] = m[ 7 ]; m[ 7 ] = tmp;
	
				return this;
	
			},
	
			getNormalMatrix: function ( matrix4 ) {
	
				return this.setFromMatrix4( matrix4 ).getInverse( this ).transpose();
	
			},
	
			transposeIntoArray: function ( r ) {
	
				var m = this.elements;
	
				r[ 0 ] = m[ 0 ];
				r[ 1 ] = m[ 3 ];
				r[ 2 ] = m[ 6 ];
				r[ 3 ] = m[ 1 ];
				r[ 4 ] = m[ 4 ];
				r[ 5 ] = m[ 7 ];
				r[ 6 ] = m[ 2 ];
				r[ 7 ] = m[ 5 ];
				r[ 8 ] = m[ 8 ];
	
				return this;
	
			},
	
			equals: function ( matrix ) {
	
				var te = this.elements;
				var me = matrix.elements;
	
				for ( var i = 0; i < 9; i ++ ) {
	
					if ( te[ i ] !== me[ i ] ) return false;
	
				}
	
				return true;
	
			},
	
			fromArray: function ( array, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				for ( var i = 0; i < 9; i ++ ) {
	
					this.elements[ i ] = array[ i + offset ];
	
				}
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				var te = this.elements;
	
				array[ offset ] = te[ 0 ];
				array[ offset + 1 ] = te[ 1 ];
				array[ offset + 2 ] = te[ 2 ];
	
				array[ offset + 3 ] = te[ 3 ];
				array[ offset + 4 ] = te[ 4 ];
				array[ offset + 5 ] = te[ 5 ];
	
				array[ offset + 6 ] = te[ 6 ];
				array[ offset + 7 ] = te[ 7 ];
				array[ offset + 8 ] = te[ 8 ];
	
				return array;
	
			}
	
		} );
	
		/**
		 * @author bhouston / http://clara.io
		 */
	
		function Plane( normal, constant ) {
	
			this.normal = ( normal !== undefined ) ? normal : new Vector3( 1, 0, 0 );
			this.constant = ( constant !== undefined ) ? constant : 0;
	
		}
	
		Object.assign( Plane.prototype, {
	
			set: function ( normal, constant ) {
	
				this.normal.copy( normal );
				this.constant = constant;
	
				return this;
	
			},
	
			setComponents: function ( x, y, z, w ) {
	
				this.normal.set( x, y, z );
				this.constant = w;
	
				return this;
	
			},
	
			setFromNormalAndCoplanarPoint: function ( normal, point ) {
	
				this.normal.copy( normal );
				this.constant = - point.dot( this.normal );	// must be this.normal, not normal, as this.normal is normalized
	
				return this;
	
			},
	
			setFromCoplanarPoints: function () {
	
				var v1 = new Vector3();
				var v2 = new Vector3();
	
				return function setFromCoplanarPoints( a, b, c ) {
	
					var normal = v1.subVectors( c, b ).cross( v2.subVectors( a, b ) ).normalize();
	
					// Q: should an error be thrown if normal is zero (e.g. degenerate plane)?
	
					this.setFromNormalAndCoplanarPoint( normal, a );
	
					return this;
	
				};
	
			}(),
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( plane ) {
	
				this.normal.copy( plane.normal );
				this.constant = plane.constant;
	
				return this;
	
			},
	
			normalize: function () {
	
				// Note: will lead to a divide by zero if the plane is invalid.
	
				var inverseNormalLength = 1.0 / this.normal.length();
				this.normal.multiplyScalar( inverseNormalLength );
				this.constant *= inverseNormalLength;
	
				return this;
	
			},
	
			negate: function () {
	
				this.constant *= - 1;
				this.normal.negate();
	
				return this;
	
			},
	
			distanceToPoint: function ( point ) {
	
				return this.normal.dot( point ) + this.constant;
	
			},
	
			distanceToSphere: function ( sphere ) {
	
				return this.distanceToPoint( sphere.center ) - sphere.radius;
	
			},
	
			projectPoint: function ( point, optionalTarget ) {
	
				return this.orthoPoint( point, optionalTarget ).sub( point ).negate();
	
			},
	
			orthoPoint: function ( point, optionalTarget ) {
	
				var perpendicularMagnitude = this.distanceToPoint( point );
	
				var result = optionalTarget || new Vector3();
				return result.copy( this.normal ).multiplyScalar( perpendicularMagnitude );
	
			},
	
			intersectLine: function () {
	
				var v1 = new Vector3();
	
				return function intersectLine( line, optionalTarget ) {
	
					var result = optionalTarget || new Vector3();
	
					var direction = line.delta( v1 );
	
					var denominator = this.normal.dot( direction );
	
					if ( denominator === 0 ) {
	
						// line is coplanar, return origin
						if ( this.distanceToPoint( line.start ) === 0 ) {
	
							return result.copy( line.start );
	
						}
	
						// Unsure if this is the correct method to handle this case.
						return undefined;
	
					}
	
					var t = - ( line.start.dot( this.normal ) + this.constant ) / denominator;
	
					if ( t < 0 || t > 1 ) {
	
						return undefined;
	
					}
	
					return result.copy( direction ).multiplyScalar( t ).add( line.start );
	
				};
	
			}(),
	
			intersectsLine: function ( line ) {
	
				// Note: this tests if a line intersects the plane, not whether it (or its end-points) are coplanar with it.
	
				var startSign = this.distanceToPoint( line.start );
				var endSign = this.distanceToPoint( line.end );
	
				return ( startSign < 0 && endSign > 0 ) || ( endSign < 0 && startSign > 0 );
	
			},
	
			intersectsBox: function ( box ) {
	
				return box.intersectsPlane( this );
	
			},
	
			intersectsSphere: function ( sphere ) {
	
				return sphere.intersectsPlane( this );
	
			},
	
			coplanarPoint: function ( optionalTarget ) {
	
				var result = optionalTarget || new Vector3();
				return result.copy( this.normal ).multiplyScalar( - this.constant );
	
			},
	
			applyMatrix4: function () {
	
				var v1 = new Vector3();
				var m1 = new Matrix3();
	
				return function applyMatrix4( matrix, optionalNormalMatrix ) {
	
					var referencePoint = this.coplanarPoint( v1 ).applyMatrix4( matrix );
	
					// transform normal based on theory here:
					// http://www.songho.ca/opengl/gl_normaltransform.html
					var normalMatrix = optionalNormalMatrix || m1.getNormalMatrix( matrix );
					var normal = this.normal.applyMatrix3( normalMatrix ).normalize();
	
					// recalculate constant (like in setFromNormalAndCoplanarPoint)
					this.constant = - referencePoint.dot( normal );
	
					return this;
	
				};
	
			}(),
	
			translate: function ( offset ) {
	
				this.constant = this.constant - offset.dot( this.normal );
	
				return this;
	
			},
	
			equals: function ( plane ) {
	
				return plane.normal.equals( this.normal ) && ( plane.constant === this.constant );
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author alteredq / http://alteredqualia.com/
		 * @author bhouston / http://clara.io
		 */
	
		function Frustum( p0, p1, p2, p3, p4, p5 ) {
	
			this.planes = [
	
				( p0 !== undefined ) ? p0 : new Plane(),
				( p1 !== undefined ) ? p1 : new Plane(),
				( p2 !== undefined ) ? p2 : new Plane(),
				( p3 !== undefined ) ? p3 : new Plane(),
				( p4 !== undefined ) ? p4 : new Plane(),
				( p5 !== undefined ) ? p5 : new Plane()
	
			];
	
		}
	
		Object.assign( Frustum.prototype, {
	
			set: function ( p0, p1, p2, p3, p4, p5 ) {
	
				var planes = this.planes;
	
				planes[ 0 ].copy( p0 );
				planes[ 1 ].copy( p1 );
				planes[ 2 ].copy( p2 );
				planes[ 3 ].copy( p3 );
				planes[ 4 ].copy( p4 );
				planes[ 5 ].copy( p5 );
	
				return this;
	
			},
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( frustum ) {
	
				var planes = this.planes;
	
				for ( var i = 0; i < 6; i ++ ) {
	
					planes[ i ].copy( frustum.planes[ i ] );
	
				}
	
				return this;
	
			},
	
			setFromMatrix: function ( m ) {
	
				var planes = this.planes;
				var me = m.elements;
				var me0 = me[ 0 ], me1 = me[ 1 ], me2 = me[ 2 ], me3 = me[ 3 ];
				var me4 = me[ 4 ], me5 = me[ 5 ], me6 = me[ 6 ], me7 = me[ 7 ];
				var me8 = me[ 8 ], me9 = me[ 9 ], me10 = me[ 10 ], me11 = me[ 11 ];
				var me12 = me[ 12 ], me13 = me[ 13 ], me14 = me[ 14 ], me15 = me[ 15 ];
	
				planes[ 0 ].setComponents( me3 - me0, me7 - me4, me11 - me8, me15 - me12 ).normalize();
				planes[ 1 ].setComponents( me3 + me0, me7 + me4, me11 + me8, me15 + me12 ).normalize();
				planes[ 2 ].setComponents( me3 + me1, me7 + me5, me11 + me9, me15 + me13 ).normalize();
				planes[ 3 ].setComponents( me3 - me1, me7 - me5, me11 - me9, me15 - me13 ).normalize();
				planes[ 4 ].setComponents( me3 - me2, me7 - me6, me11 - me10, me15 - me14 ).normalize();
				planes[ 5 ].setComponents( me3 + me2, me7 + me6, me11 + me10, me15 + me14 ).normalize();
	
				return this;
	
			},
	
			intersectsObject: function () {
	
				var sphere = new Sphere();
	
				return function intersectsObject( object ) {
	
					var geometry = object.geometry;
	
					if ( geometry.boundingSphere === null )
						geometry.computeBoundingSphere();
	
					sphere.copy( geometry.boundingSphere )
						.applyMatrix4( object.matrixWorld );
	
					return this.intersectsSphere( sphere );
	
				};
	
			}(),
	
			intersectsSprite: function () {
	
				var sphere = new Sphere();
	
				return function intersectsSprite( sprite ) {
	
					sphere.center.set( 0, 0, 0 );
					sphere.radius = 0.7071067811865476;
					sphere.applyMatrix4( sprite.matrixWorld );
	
					return this.intersectsSphere( sphere );
	
				};
	
			}(),
	
			intersectsSphere: function ( sphere ) {
	
				var planes = this.planes;
				var center = sphere.center;
				var negRadius = - sphere.radius;
	
				for ( var i = 0; i < 6; i ++ ) {
	
					var distance = planes[ i ].distanceToPoint( center );
	
					if ( distance < negRadius ) {
	
						return false;
	
					}
	
				}
	
				return true;
	
			},
	
			intersectsBox: function () {
	
				var p1 = new Vector3(),
					p2 = new Vector3();
	
				return function intersectsBox( box ) {
	
					var planes = this.planes;
	
					for ( var i = 0; i < 6; i ++ ) {
	
						var plane = planes[ i ];
	
						p1.x = plane.normal.x > 0 ? box.min.x : box.max.x;
						p2.x = plane.normal.x > 0 ? box.max.x : box.min.x;
						p1.y = plane.normal.y > 0 ? box.min.y : box.max.y;
						p2.y = plane.normal.y > 0 ? box.max.y : box.min.y;
						p1.z = plane.normal.z > 0 ? box.min.z : box.max.z;
						p2.z = plane.normal.z > 0 ? box.max.z : box.min.z;
	
						var d1 = plane.distanceToPoint( p1 );
						var d2 = plane.distanceToPoint( p2 );
	
						// if both outside plane, no intersection
	
						if ( d1 < 0 && d2 < 0 ) {
	
							return false;
	
						}
	
					}
	
					return true;
	
				};
	
			}(),
	
			containsPoint: function ( point ) {
	
				var planes = this.planes;
	
				for ( var i = 0; i < 6; i ++ ) {
	
					if ( planes[ i ].distanceToPoint( point ) < 0 ) {
	
						return false;
	
					}
	
				}
	
				return true;
	
			}
	
		} );
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function WebGLShadowMap( _renderer, _lights, _objects, capabilities ) {
	
			var _gl = _renderer.context,
				_state = _renderer.state,
				_frustum = new Frustum(),
				_projScreenMatrix = new Matrix4(),
	
				_lightShadows = _lights.shadows,
	
				_shadowMapSize = new Vector2(),
				_maxShadowMapSize = new Vector2( capabilities.maxTextureSize, capabilities.maxTextureSize ),
	
				_lookTarget = new Vector3(),
				_lightPositionWorld = new Vector3(),
	
				_MorphingFlag = 1,
				_SkinningFlag = 2,
	
				_NumberOfMaterialVariants = ( _MorphingFlag | _SkinningFlag ) + 1,
	
				_depthMaterials = new Array( _NumberOfMaterialVariants ),
				_distanceMaterials = new Array( _NumberOfMaterialVariants ),
	
				_materialCache = {};
	
			var cubeDirections = [
				new Vector3( 1, 0, 0 ), new Vector3( - 1, 0, 0 ), new Vector3( 0, 0, 1 ),
				new Vector3( 0, 0, - 1 ), new Vector3( 0, 1, 0 ), new Vector3( 0, - 1, 0 )
			];
	
			var cubeUps = [
				new Vector3( 0, 1, 0 ), new Vector3( 0, 1, 0 ), new Vector3( 0, 1, 0 ),
				new Vector3( 0, 1, 0 ), new Vector3( 0, 0, 1 ),	new Vector3( 0, 0, - 1 )
			];
	
			var cube2DViewPorts = [
				new Vector4(), new Vector4(), new Vector4(),
				new Vector4(), new Vector4(), new Vector4()
			];
	
			// init
	
			var depthMaterialTemplate = new MeshDepthMaterial();
			depthMaterialTemplate.depthPacking = RGBADepthPacking;
			depthMaterialTemplate.clipping = true;
	
			var distanceShader = ShaderLib[ "distanceRGBA" ];
			var distanceUniforms = UniformsUtils.clone( distanceShader.uniforms );
	
			for ( var i = 0; i !== _NumberOfMaterialVariants; ++ i ) {
	
				var useMorphing = ( i & _MorphingFlag ) !== 0;
				var useSkinning = ( i & _SkinningFlag ) !== 0;
	
				var depthMaterial = depthMaterialTemplate.clone();
				depthMaterial.morphTargets = useMorphing;
				depthMaterial.skinning = useSkinning;
	
				_depthMaterials[ i ] = depthMaterial;
	
				var distanceMaterial = new ShaderMaterial( {
					defines: {
						'USE_SHADOWMAP': ''
					},
					uniforms: distanceUniforms,
					vertexShader: distanceShader.vertexShader,
					fragmentShader: distanceShader.fragmentShader,
					morphTargets: useMorphing,
					skinning: useSkinning,
					clipping: true
				} );
	
				_distanceMaterials[ i ] = distanceMaterial;
	
			}
	
			//
	
			var scope = this;
	
			this.enabled = false;
	
			this.autoUpdate = true;
			this.needsUpdate = false;
	
			this.type = PCFShadowMap;
	
			this.renderReverseSided = true;
			this.renderSingleSided = true;
	
			this.render = function ( scene, camera ) {
	
				if ( scope.enabled === false ) return;
				if ( scope.autoUpdate === false && scope.needsUpdate === false ) return;
	
				if ( _lightShadows.length === 0 ) return;
	
				// Set GL state for depth map.
				_state.disable( _gl.BLEND );
				_state.buffers.color.setClear( 1, 1, 1, 1 );
				_state.buffers.depth.setTest( true );
				_state.setScissorTest( false );
	
				// render depth map
	
				var faceCount;
	
				for ( var i = 0, il = _lightShadows.length; i < il; i ++ ) {
	
					var light = _lightShadows[ i ];
					var shadow = light.shadow;
					var isPointLight = light && light.isPointLight;
	
					if ( shadow === undefined ) {
	
						console.warn( 'THREE.WebGLShadowMap:', light, 'has no shadow.' );
						continue;
	
					}
	
					var shadowCamera = shadow.camera;
	
					_shadowMapSize.copy( shadow.mapSize );
					_shadowMapSize.min( _maxShadowMapSize );
	
					if ( isPointLight ) {
	
						var vpWidth = _shadowMapSize.x;
						var vpHeight = _shadowMapSize.y;
	
						// These viewports map a cube-map onto a 2D texture with the
						// following orientation:
						//
						//  xzXZ
						//   y Y
						//
						// X - Positive x direction
						// x - Negative x direction
						// Y - Positive y direction
						// y - Negative y direction
						// Z - Positive z direction
						// z - Negative z direction
	
						// positive X
						cube2DViewPorts[ 0 ].set( vpWidth * 2, vpHeight, vpWidth, vpHeight );
						// negative X
						cube2DViewPorts[ 1 ].set( 0, vpHeight, vpWidth, vpHeight );
						// positive Z
						cube2DViewPorts[ 2 ].set( vpWidth * 3, vpHeight, vpWidth, vpHeight );
						// negative Z
						cube2DViewPorts[ 3 ].set( vpWidth, vpHeight, vpWidth, vpHeight );
						// positive Y
						cube2DViewPorts[ 4 ].set( vpWidth * 3, 0, vpWidth, vpHeight );
						// negative Y
						cube2DViewPorts[ 5 ].set( vpWidth, 0, vpWidth, vpHeight );
	
						_shadowMapSize.x *= 4.0;
						_shadowMapSize.y *= 2.0;
	
					}
	
					if ( shadow.map === null ) {
	
						var pars = { minFilter: NearestFilter, magFilter: NearestFilter, format: RGBAFormat };
	
						shadow.map = new WebGLRenderTarget( _shadowMapSize.x, _shadowMapSize.y, pars );
						shadow.map.texture.name = light.name + ".shadowMap";
	
						shadowCamera.updateProjectionMatrix();
	
					}
	
					if ( shadow.isSpotLightShadow ) {
	
						shadow.update( light );
	
					}
	
					var shadowMap = shadow.map;
					var shadowMatrix = shadow.matrix;
	
					_lightPositionWorld.setFromMatrixPosition( light.matrixWorld );
					shadowCamera.position.copy( _lightPositionWorld );
	
					if ( isPointLight ) {
	
						faceCount = 6;
	
						// for point lights we set the shadow matrix to be a translation-only matrix
						// equal to inverse of the light's position
	
						shadowMatrix.makeTranslation( - _lightPositionWorld.x, - _lightPositionWorld.y, - _lightPositionWorld.z );
	
					} else {
	
						faceCount = 1;
	
						_lookTarget.setFromMatrixPosition( light.target.matrixWorld );
						shadowCamera.lookAt( _lookTarget );
						shadowCamera.updateMatrixWorld();
	
						// compute shadow matrix
	
						shadowMatrix.set(
							0.5, 0.0, 0.0, 0.5,
							0.0, 0.5, 0.0, 0.5,
							0.0, 0.0, 0.5, 0.5,
							0.0, 0.0, 0.0, 1.0
						);
	
						shadowMatrix.multiply( shadowCamera.projectionMatrix );
						shadowMatrix.multiply( shadowCamera.matrixWorldInverse );
	
					}
	
					_renderer.setRenderTarget( shadowMap );
					_renderer.clear();
	
					// render shadow map for each cube face (if omni-directional) or
					// run a single pass if not
	
					for ( var face = 0; face < faceCount; face ++ ) {
	
						if ( isPointLight ) {
	
							_lookTarget.copy( shadowCamera.position );
							_lookTarget.add( cubeDirections[ face ] );
							shadowCamera.up.copy( cubeUps[ face ] );
							shadowCamera.lookAt( _lookTarget );
							shadowCamera.updateMatrixWorld();
	
							var vpDimensions = cube2DViewPorts[ face ];
							_state.viewport( vpDimensions );
	
						}
	
						// update camera matrices and frustum
	
						_projScreenMatrix.multiplyMatrices( shadowCamera.projectionMatrix, shadowCamera.matrixWorldInverse );
						_frustum.setFromMatrix( _projScreenMatrix );
	
						// set object matrices & frustum culling
	
						renderObject( scene, camera, shadowCamera, isPointLight );
	
					}
	
				}
	
				// Restore GL state.
				var clearColor = _renderer.getClearColor();
				var clearAlpha = _renderer.getClearAlpha();
				_renderer.setClearColor( clearColor, clearAlpha );
	
				scope.needsUpdate = false;
	
			};
	
			function getDepthMaterial( object, material, isPointLight, lightPositionWorld ) {
	
				var geometry = object.geometry;
	
				var result = null;
	
				var materialVariants = _depthMaterials;
				var customMaterial = object.customDepthMaterial;
	
				if ( isPointLight ) {
	
					materialVariants = _distanceMaterials;
					customMaterial = object.customDistanceMaterial;
	
				}
	
				if ( ! customMaterial ) {
	
					var useMorphing = false;
	
					if ( material.morphTargets ) {
	
						if ( geometry && geometry.isBufferGeometry ) {
	
							useMorphing = geometry.morphAttributes && geometry.morphAttributes.position && geometry.morphAttributes.position.length > 0;
	
						} else if ( geometry && geometry.isGeometry ) {
	
							useMorphing = geometry.morphTargets && geometry.morphTargets.length > 0;
	
						}
	
					}
	
					if ( object.isSkinnedMesh && material.skinning === false ) {
	
						console.warn( 'THREE.WebGLShadowMap: THREE.SkinnedMesh with material.skinning set to false:', object );
	
					}
	
					var useSkinning = object.isSkinnedMesh && material.skinning;
	
					var variantIndex = 0;
	
					if ( useMorphing ) variantIndex |= _MorphingFlag;
					if ( useSkinning ) variantIndex |= _SkinningFlag;
	
					result = materialVariants[ variantIndex ];
	
				} else {
	
					result = customMaterial;
	
				}
	
				if ( _renderer.localClippingEnabled &&
						material.clipShadows === true &&
						material.clippingPlanes.length !== 0 ) {
	
					// in this case we need a unique material instance reflecting the
					// appropriate state
	
					var keyA = result.uuid, keyB = material.uuid;
	
					var materialsForVariant = _materialCache[ keyA ];
	
					if ( materialsForVariant === undefined ) {
	
						materialsForVariant = {};
						_materialCache[ keyA ] = materialsForVariant;
	
					}
	
					var cachedMaterial = materialsForVariant[ keyB ];
	
					if ( cachedMaterial === undefined ) {
	
						cachedMaterial = result.clone();
						materialsForVariant[ keyB ] = cachedMaterial;
	
					}
	
					result = cachedMaterial;
	
				}
	
				result.visible = material.visible;
				result.wireframe = material.wireframe;
	
				var side = material.side;
	
				if ( scope.renderSingleSided && side == DoubleSide ) {
	
					side = FrontSide;
	
				}
	
				if ( scope.renderReverseSided ) {
	
					if ( side === FrontSide ) side = BackSide;
					else if ( side === BackSide ) side = FrontSide;
	
				}
	
				result.side = side;
	
				result.clipShadows = material.clipShadows;
				result.clippingPlanes = material.clippingPlanes;
	
				result.wireframeLinewidth = material.wireframeLinewidth;
				result.linewidth = material.linewidth;
	
				if ( isPointLight && result.uniforms.lightPos !== undefined ) {
	
					result.uniforms.lightPos.value.copy( lightPositionWorld );
	
				}
	
				return result;
	
			}
	
			function renderObject( object, camera, shadowCamera, isPointLight ) {
	
				if ( object.visible === false ) return;
	
				var visible = object.layers.test( camera.layers );
	
				if ( visible && ( object.isMesh || object.isLine || object.isPoints ) ) {
	
					if ( object.castShadow && ( ! object.frustumCulled || _frustum.intersectsObject( object ) ) ) {
	
						object.modelViewMatrix.multiplyMatrices( shadowCamera.matrixWorldInverse, object.matrixWorld );
	
						var geometry = _objects.update( object );
						var material = object.material;
	
						if ( Array.isArray( material ) ) {
	
							var groups = geometry.groups;
	
							for ( var k = 0, kl = groups.length; k < kl; k ++ ) {
	
								var group = groups[ k ];
								var groupMaterial = material[ group.materialIndex ];
	
								if ( groupMaterial && groupMaterial.visible ) {
	
									var depthMaterial = getDepthMaterial( object, groupMaterial, isPointLight, _lightPositionWorld );
									_renderer.renderBufferDirect( shadowCamera, null, geometry, depthMaterial, object, group );
	
								}
	
							}
	
						} else if ( material.visible ) {
	
							var depthMaterial = getDepthMaterial( object, material, isPointLight, _lightPositionWorld );
							_renderer.renderBufferDirect( shadowCamera, null, geometry, depthMaterial, object, null );
	
						}
	
					}
	
				}
	
				var children = object.children;
	
				for ( var i = 0, l = children.length; i < l; i ++ ) {
	
					renderObject( children[ i ], camera, shadowCamera, isPointLight );
	
				}
	
			}
	
		}
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function WebGLAttributes( gl ) {
	
			var buffers = {};
	
			function createBuffer( attribute, bufferType ) {
	
				var array = attribute.array;
				var usage = attribute.dynamic ? gl.DYNAMIC_DRAW : gl.STATIC_DRAW;
	
				var buffer = gl.createBuffer();
	
				gl.bindBuffer( bufferType, buffer );
				gl.bufferData( bufferType, array, usage );
	
				attribute.onUploadCallback();
	
				var type = gl.FLOAT;
	
				if ( array instanceof Float32Array ) {
	
					type = gl.FLOAT;
	
				} else if ( array instanceof Float64Array ) {
	
					console.warn( 'THREE.WebGLAttributes: Unsupported data buffer format: Float64Array.' );
	
				} else if ( array instanceof Uint16Array ) {
	
					type = gl.UNSIGNED_SHORT;
	
				} else if ( array instanceof Int16Array ) {
	
					type = gl.SHORT;
	
				} else if ( array instanceof Uint32Array ) {
	
					type = gl.UNSIGNED_INT;
	
				} else if ( array instanceof Int32Array ) {
	
					type = gl.INT;
	
				} else if ( array instanceof Int8Array ) {
	
					type = gl.BYTE;
	
				} else if ( array instanceof Uint8Array ) {
	
					type = gl.UNSIGNED_BYTE;
	
				}
	
				return {
					buffer: buffer,
					type: type,
					bytesPerElement: array.BYTES_PER_ELEMENT,
					version: attribute.version
				};
	
			}
	
			function updateBuffer( buffer, attribute, bufferType ) {
	
				var array = attribute.array;
				var updateRange = attribute.updateRange;
	
				gl.bindBuffer( bufferType, buffer );
	
				if ( attribute.dynamic === false ) {
	
					gl.bufferData( bufferType, array, gl.STATIC_DRAW );
	
				} else if ( updateRange.count === - 1 ) {
	
					// Not using update ranges
	
					gl.bufferSubData( bufferType, 0, array );
	
				} else if ( updateRange.count === 0 ) {
	
					console.error( 'THREE.WebGLObjects.updateBuffer: dynamic THREE.BufferAttribute marked as needsUpdate but updateRange.count is 0, ensure you are using set methods or updating manually.' );
	
				} else {
	
					gl.bufferSubData( bufferType, updateRange.offset * array.BYTES_PER_ELEMENT,
						array.subarray( updateRange.offset, updateRange.offset + updateRange.count ) );
	
					updateRange.count = -1; // reset range
	
				}
	
			}
	
			//
	
			function get( attribute ) {
	
				if ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;
	
				return buffers[ attribute.uuid ];
	
			}
	
			function remove( attribute ) {
	
				if ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;
				
				var data = buffers[ attribute.uuid ];
	
				if ( data ) {
	
					gl.deleteBuffer( data.buffer );
	
					delete buffers[ attribute.uuid ];
	
				}
	
			}
	
			function update( attribute, bufferType ) {
	
				if ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;
	
				var data = buffers[ attribute.uuid ];
	
				if ( data === undefined ) {
	
					buffers[ attribute.uuid ] = createBuffer( attribute, bufferType );
	
				} else if ( data.version < attribute.version ) {
	
					updateBuffer( data.buffer, attribute, bufferType );
	
					data.version = attribute.version;
	
				}
	
			}
	
			return {
	
				get: get,
				remove: remove,
				update: update
	
			};
	
		}
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author WestLangley / http://github.com/WestLangley
		 * @author bhouston / http://clara.io
		 */
	
		function Euler( x, y, z, order ) {
	
			this._x = x || 0;
			this._y = y || 0;
			this._z = z || 0;
			this._order = order || Euler.DefaultOrder;
	
		}
	
		Euler.RotationOrders = [ 'XYZ', 'YZX', 'ZXY', 'XZY', 'YXZ', 'ZYX' ];
	
		Euler.DefaultOrder = 'XYZ';
	
		Object.defineProperties( Euler.prototype, {
	
			x: {
	
				get: function () {
	
					return this._x;
	
				},
	
				set: function ( value ) {
	
					this._x = value;
					this.onChangeCallback();
	
				}
	
			},
	
			y: {
	
				get: function () {
	
					return this._y;
	
				},
	
				set: function ( value ) {
	
					this._y = value;
					this.onChangeCallback();
	
				}
	
			},
	
			z: {
	
				get: function () {
	
					return this._z;
	
				},
	
				set: function ( value ) {
	
					this._z = value;
					this.onChangeCallback();
	
				}
	
			},
	
			order: {
	
				get: function () {
	
					return this._order;
	
				},
	
				set: function ( value ) {
	
					this._order = value;
					this.onChangeCallback();
	
				}
	
			}
	
		} );
	
		Object.assign( Euler.prototype, {
	
			isEuler: true,
	
			set: function ( x, y, z, order ) {
	
				this._x = x;
				this._y = y;
				this._z = z;
				this._order = order || this._order;
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			clone: function () {
	
				return new this.constructor( this._x, this._y, this._z, this._order );
	
			},
	
			copy: function ( euler ) {
	
				this._x = euler._x;
				this._y = euler._y;
				this._z = euler._z;
				this._order = euler._order;
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			setFromRotationMatrix: function ( m, order, update ) {
	
				var clamp = _Math.clamp;
	
				// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)
	
				var te = m.elements;
				var m11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ];
				var m21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ];
				var m31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ];
	
				order = order || this._order;
	
				if ( order === 'XYZ' ) {
	
					this._y = Math.asin( clamp( m13, - 1, 1 ) );
	
					if ( Math.abs( m13 ) < 0.99999 ) {
	
						this._x = Math.atan2( - m23, m33 );
						this._z = Math.atan2( - m12, m11 );
	
					} else {
	
						this._x = Math.atan2( m32, m22 );
						this._z = 0;
	
					}
	
				} else if ( order === 'YXZ' ) {
	
					this._x = Math.asin( - clamp( m23, - 1, 1 ) );
	
					if ( Math.abs( m23 ) < 0.99999 ) {
	
						this._y = Math.atan2( m13, m33 );
						this._z = Math.atan2( m21, m22 );
	
					} else {
	
						this._y = Math.atan2( - m31, m11 );
						this._z = 0;
	
					}
	
				} else if ( order === 'ZXY' ) {
	
					this._x = Math.asin( clamp( m32, - 1, 1 ) );
	
					if ( Math.abs( m32 ) < 0.99999 ) {
	
						this._y = Math.atan2( - m31, m33 );
						this._z = Math.atan2( - m12, m22 );
	
					} else {
	
						this._y = 0;
						this._z = Math.atan2( m21, m11 );
	
					}
	
				} else if ( order === 'ZYX' ) {
	
					this._y = Math.asin( - clamp( m31, - 1, 1 ) );
	
					if ( Math.abs( m31 ) < 0.99999 ) {
	
						this._x = Math.atan2( m32, m33 );
						this._z = Math.atan2( m21, m11 );
	
					} else {
	
						this._x = 0;
						this._z = Math.atan2( - m12, m22 );
	
					}
	
				} else if ( order === 'YZX' ) {
	
					this._z = Math.asin( clamp( m21, - 1, 1 ) );
	
					if ( Math.abs( m21 ) < 0.99999 ) {
	
						this._x = Math.atan2( - m23, m22 );
						this._y = Math.atan2( - m31, m11 );
	
					} else {
	
						this._x = 0;
						this._y = Math.atan2( m13, m33 );
	
					}
	
				} else if ( order === 'XZY' ) {
	
					this._z = Math.asin( - clamp( m12, - 1, 1 ) );
	
					if ( Math.abs( m12 ) < 0.99999 ) {
	
						this._x = Math.atan2( m32, m22 );
						this._y = Math.atan2( m13, m11 );
	
					} else {
	
						this._x = Math.atan2( - m23, m33 );
						this._y = 0;
	
					}
	
				} else {
	
					console.warn( 'THREE.Euler: .setFromRotationMatrix() given unsupported order: ' + order );
	
				}
	
				this._order = order;
	
				if ( update !== false ) this.onChangeCallback();
	
				return this;
	
			},
	
			setFromQuaternion: function () {
	
				var matrix = new Matrix4();
	
				return function setFromQuaternion( q, order, update ) {
	
					matrix.makeRotationFromQuaternion( q );
	
					return this.setFromRotationMatrix( matrix, order, update );
	
				};
	
			}(),
	
			setFromVector3: function ( v, order ) {
	
				return this.set( v.x, v.y, v.z, order || this._order );
	
			},
	
			reorder: function () {
	
				// WARNING: this discards revolution information -bhouston
	
				var q = new Quaternion();
	
				return function reorder( newOrder ) {
	
					q.setFromEuler( this );
	
					return this.setFromQuaternion( q, newOrder );
	
				};
	
			}(),
	
			equals: function ( euler ) {
	
				return ( euler._x === this._x ) && ( euler._y === this._y ) && ( euler._z === this._z ) && ( euler._order === this._order );
	
			},
	
			fromArray: function ( array ) {
	
				this._x = array[ 0 ];
				this._y = array[ 1 ];
				this._z = array[ 2 ];
				if ( array[ 3 ] !== undefined ) this._order = array[ 3 ];
	
				this.onChangeCallback();
	
				return this;
	
			},
	
			toArray: function ( array, offset ) {
	
				if ( array === undefined ) array = [];
				if ( offset === undefined ) offset = 0;
	
				array[ offset ] = this._x;
				array[ offset + 1 ] = this._y;
				array[ offset + 2 ] = this._z;
				array[ offset + 3 ] = this._order;
	
				return array;
	
			},
	
			toVector3: function ( optionalResult ) {
	
				if ( optionalResult ) {
	
					return optionalResult.set( this._x, this._y, this._z );
	
				} else {
	
					return new Vector3( this._x, this._y, this._z );
	
				}
	
			},
	
			onChange: function ( callback ) {
	
				this.onChangeCallback = callback;
	
				return this;
	
			},
	
			onChangeCallback: function () {}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function Layers() {
	
			this.mask = 1 | 0;
	
		}
	
		Object.assign( Layers.prototype, {
	
			set: function ( channel ) {
	
				this.mask = 1 << channel | 0;
	
			},
	
			enable: function ( channel ) {
	
				this.mask |= 1 << channel | 0;
	
			},
	
			toggle: function ( channel ) {
	
				this.mask ^= 1 << channel | 0;
	
			},
	
			disable: function ( channel ) {
	
				this.mask &= ~ ( 1 << channel | 0 );
	
			},
	
			test: function ( layers ) {
	
				return ( this.mask & layers.mask ) !== 0;
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author mikael emtinger / http://gomo.se/
		 * @author alteredq / http://alteredqualia.com/
		 * @author WestLangley / http://github.com/WestLangley
		 * @author elephantatwork / www.elephantatwork.ch
		 */
	
		var object3DId = 0;
	
		function Object3D() {
	
			Object.defineProperty( this, 'id', { value: object3DId ++ } );
	
			this.uuid = _Math.generateUUID();
	
			this.name = '';
			this.type = 'Object3D';
	
			this.parent = null;
			this.children = [];
	
			this.up = Object3D.DefaultUp.clone();
	
			var position = new Vector3();
			var rotation = new Euler();
			var quaternion = new Quaternion();
			var scale = new Vector3( 1, 1, 1 );
	
			function onRotationChange() {
	
				quaternion.setFromEuler( rotation, false );
	
			}
	
			function onQuaternionChange() {
	
				rotation.setFromQuaternion( quaternion, undefined, false );
	
			}
	
			rotation.onChange( onRotationChange );
			quaternion.onChange( onQuaternionChange );
	
			Object.defineProperties( this, {
				position: {
					enumerable: true,
					value: position
				},
				rotation: {
					enumerable: true,
					value: rotation
				},
				quaternion: {
					enumerable: true,
					value: quaternion
				},
				scale: {
					enumerable: true,
					value: scale
				},
				modelViewMatrix: {
					value: new Matrix4()
				},
				normalMatrix: {
					value: new Matrix3()
				}
			} );
	
			this.matrix = new Matrix4();
			this.matrixWorld = new Matrix4();
	
			this.matrixAutoUpdate = Object3D.DefaultMatrixAutoUpdate;
			this.matrixWorldNeedsUpdate = false;
	
			this.layers = new Layers();
			this.visible = true;
	
			this.castShadow = false;
			this.receiveShadow = false;
	
			this.frustumCulled = true;
			this.renderOrder = 0;
	
			this.userData = {};
		}
	
		Object3D.DefaultUp = new Vector3( 0, 1, 0 );
		Object3D.DefaultMatrixAutoUpdate = true;
	
		Object.assign( Object3D.prototype, EventDispatcher.prototype, {
	
			isObject3D: true,
	
			onBeforeRender: function () {},
			onAfterRender: function () {},
	
			applyMatrix: function ( matrix ) {
	
				this.matrix.multiplyMatrices( matrix, this.matrix );
	
				this.matrix.decompose( this.position, this.quaternion, this.scale );
	
			},
	
			applyQuaternion: function ( q ) {
	
				this.quaternion.premultiply( q );
	
				return this;
	
			},
	
			setRotationFromAxisAngle: function ( axis, angle ) {
	
				// assumes axis is normalized
	
				this.quaternion.setFromAxisAngle( axis, angle );
	
			},
	
			setRotationFromEuler: function ( euler ) {
	
				this.quaternion.setFromEuler( euler, true );
	
			},
	
			setRotationFromMatrix: function ( m ) {
	
				// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)
	
				this.quaternion.setFromRotationMatrix( m );
	
			},
	
			setRotationFromQuaternion: function ( q ) {
	
				// assumes q is normalized
	
				this.quaternion.copy( q );
	
			},
	
			rotateOnAxis: function () {
	
				// rotate object on axis in object space
				// axis is assumed to be normalized
	
				var q1 = new Quaternion();
	
				return function rotateOnAxis( axis, angle ) {
	
					q1.setFromAxisAngle( axis, angle );
	
					this.quaternion.multiply( q1 );
	
					return this;
	
				};
	
			}(),
	
			rotateX: function () {
	
				var v1 = new Vector3( 1, 0, 0 );
	
				return function rotateX( angle ) {
	
					return this.rotateOnAxis( v1, angle );
	
				};
	
			}(),
	
			rotateY: function () {
	
				var v1 = new Vector3( 0, 1, 0 );
	
				return function rotateY( angle ) {
	
					return this.rotateOnAxis( v1, angle );
	
				};
	
			}(),
	
			rotateZ: function () {
	
				var v1 = new Vector3( 0, 0, 1 );
	
				return function rotateZ( angle ) {
	
					return this.rotateOnAxis( v1, angle );
	
				};
	
			}(),
	
			translateOnAxis: function () {
	
				// translate object by distance along axis in object space
				// axis is assumed to be normalized
	
				var v1 = new Vector3();
	
				return function translateOnAxis( axis, distance ) {
	
					v1.copy( axis ).applyQuaternion( this.quaternion );
	
					this.position.add( v1.multiplyScalar( distance ) );
	
					return this;
	
				};
	
			}(),
	
			translateX: function () {
	
				var v1 = new Vector3( 1, 0, 0 );
	
				return function translateX( distance ) {
	
					return this.translateOnAxis( v1, distance );
	
				};
	
			}(),
	
			translateY: function () {
	
				var v1 = new Vector3( 0, 1, 0 );
	
				return function translateY( distance ) {
	
					return this.translateOnAxis( v1, distance );
	
				};
	
			}(),
	
			translateZ: function () {
	
				var v1 = new Vector3( 0, 0, 1 );
	
				return function translateZ( distance ) {
	
					return this.translateOnAxis( v1, distance );
	
				};
	
			}(),
	
			localToWorld: function ( vector ) {
	
				return vector.applyMatrix4( this.matrixWorld );
	
			},
	
			worldToLocal: function () {
	
				var m1 = new Matrix4();
	
				return function worldToLocal( vector ) {
	
					return vector.applyMatrix4( m1.getInverse( this.matrixWorld ) );
	
				};
	
			}(),
	
			lookAt: function () {
	
				// This method does not support objects with rotated and/or translated parent(s)
	
				var m1 = new Matrix4();
	
				return function lookAt( vector ) {
	
					if ( this.isCamera ) {
	
						m1.lookAt( this.position, vector, this.up );
	
					} else {
	
						m1.lookAt( vector, this.position, this.up );
	
					}
	
					this.quaternion.setFromRotationMatrix( m1 );
	
				};
	
			}(),
	
			add: function ( object ) {
	
				if ( arguments.length > 1 ) {
	
					for ( var i = 0; i < arguments.length; i ++ ) {
	
						this.add( arguments[ i ] );
	
					}
	
					return this;
	
				}
	
				if ( object === this ) {
	
					console.error( "THREE.Object3D.add: object can't be added as a child of itself.", object );
					return this;
	
				}
	
				if ( ( object && object.isObject3D ) ) {
	
					if ( object.parent !== null ) {
	
						object.parent.remove( object );
	
					}
	
					object.parent = this;
					object.dispatchEvent( { type: 'added' } );
	
					this.children.push( object );
	
				} else {
	
					console.error( "THREE.Object3D.add: object not an instance of THREE.Object3D.", object );
	
				}
	
				return this;
	
			},
	
			remove: function ( object ) {
	
				if ( arguments.length > 1 ) {
	
					for ( var i = 0; i < arguments.length; i ++ ) {
	
						this.remove( arguments[ i ] );
	
					}
	
					return this;
	
				}
	
				var index = this.children.indexOf( object );
	
				if ( index !== - 1 ) {
	
					object.parent = null;
	
					object.dispatchEvent( { type: 'removed' } );
	
					this.children.splice( index, 1 );
	
				}
	
				return this;
				
			},
	
			getObjectById: function ( id ) {
	
				return this.getObjectByProperty( 'id', id );
	
			},
	
			getObjectByName: function ( name ) {
	
				return this.getObjectByProperty( 'name', name );
	
			},
	
			getObjectByProperty: function ( name, value ) {
	
				if ( this[ name ] === value ) return this;
	
				for ( var i = 0, l = this.children.length; i < l; i ++ ) {
	
					var child = this.children[ i ];
					var object = child.getObjectByProperty( name, value );
	
					if ( object !== undefined ) {
	
						return object;
	
					}
	
				}
	
				return undefined;
	
			},
	
			getWorldPosition: function ( optionalTarget ) {
	
				var result = optionalTarget || new Vector3();
	
				this.updateMatrixWorld( true );
	
				return result.setFromMatrixPosition( this.matrixWorld );
	
			},
	
			getWorldQuaternion: function () {
	
				var position = new Vector3();
				var scale = new Vector3();
	
				return function getWorldQuaternion( optionalTarget ) {
	
					var result = optionalTarget || new Quaternion();
	
					this.updateMatrixWorld( true );
	
					this.matrixWorld.decompose( position, result, scale );
	
					return result;
	
				};
	
			}(),
	
			getWorldRotation: function () {
	
				var quaternion = new Quaternion();
	
				return function getWorldRotation( optionalTarget ) {
	
					var result = optionalTarget || new Euler();
	
					this.getWorldQuaternion( quaternion );
	
					return result.setFromQuaternion( quaternion, this.rotation.order, false );
	
				};
	
			}(),
	
			getWorldScale: function () {
	
				var position = new Vector3();
				var quaternion = new Quaternion();
	
				return function getWorldScale( optionalTarget ) {
	
					var result = optionalTarget || new Vector3();
	
					this.updateMatrixWorld( true );
	
					this.matrixWorld.decompose( position, quaternion, result );
	
					return result;
	
				};
	
			}(),
	
			getWorldDirection: function () {
	
				var quaternion = new Quaternion();
	
				return function getWorldDirection( optionalTarget ) {
	
					var result = optionalTarget || new Vector3();
	
					this.getWorldQuaternion( quaternion );
	
					return result.set( 0, 0, 1 ).applyQuaternion( quaternion );
	
				};
	
			}(),
	
			raycast: function () {},
	
			traverse: function ( callback ) {
	
				callback( this );
	
				var children = this.children;
	
				for ( var i = 0, l = children.length; i < l; i ++ ) {
	
					children[ i ].traverse( callback );
	
				}
	
			},
	
			traverseVisible: function ( callback ) {
	
				if ( this.visible === false ) return;
	
				callback( this );
	
				var children = this.children;
	
				for ( var i = 0, l = children.length; i < l; i ++ ) {
	
					children[ i ].traverseVisible( callback );
	
				}
	
			},
	
			traverseAncestors: function ( callback ) {
	
				var parent = this.parent;
	
				if ( parent !== null ) {
	
					callback( parent );
	
					parent.traverseAncestors( callback );
	
				}
	
			},
	
			updateMatrix: function () {
	
				this.matrix.compose( this.position, this.quaternion, this.scale );
	
				this.matrixWorldNeedsUpdate = true;
	
			},
	
			updateMatrixWorld: function ( force ) {
	
				if ( this.matrixAutoUpdate ) this.updateMatrix();
	
				if ( this.matrixWorldNeedsUpdate || force ) {
	
					if ( this.parent === null ) {
	
						this.matrixWorld.copy( this.matrix );
	
					} else {
	
						this.matrixWorld.multiplyMatrices( this.parent.matrixWorld, this.matrix );
	
					}
	
					this.matrixWorldNeedsUpdate = false;
	
					force = true;
	
				}
	
				// update children
	
				var children = this.children;
	
				for ( var i = 0, l = children.length; i < l; i ++ ) {
	
					children[ i ].updateMatrixWorld( force );
	
				}
	
			},
	
			toJSON: function ( meta ) {
	
				// meta is '' when called from JSON.stringify
				var isRootObject = ( meta === undefined || meta === '' );
	
				var output = {};
	
				// meta is a hash used to collect geometries, materials.
				// not providing it implies that this is the root object
				// being serialized.
				if ( isRootObject ) {
	
					// initialize meta obj
					meta = {
						geometries: {},
						materials: {},
						textures: {},
						images: {}
					};
	
					output.metadata = {
						version: 4.5,
						type: 'Object',
						generator: 'Object3D.toJSON'
					};
	
				}
	
				// standard Object3D serialization
	
				var object = {};
	
				object.uuid = this.uuid;
				object.type = this.type;
	
				if ( this.name !== '' ) object.name = this.name;
				if ( JSON.stringify( this.userData ) !== '{}' ) object.userData = this.userData;
				if ( this.castShadow === true ) object.castShadow = true;
				if ( this.receiveShadow === true ) object.receiveShadow = true;
				if ( this.visible === false ) object.visible = false;
	
				object.matrix = this.matrix.toArray();
	
				//
	
				function serialize( library, element ) {
	
					if ( library[ element.uuid ] === undefined ) {
	
						library[ element.uuid ] = element.toJSON( meta );
	
					}
	
					return element.uuid;
	
				}
	
				if ( this.geometry !== undefined ) {
	
					object.geometry = serialize( meta.geometries, this.geometry );
	
				}
	
				if ( this.material !== undefined ) {
	
					if ( Array.isArray( this.material ) ) {
	
						var uuids = [];
	
						for ( var i = 0, l = this.material.length; i < l; i ++ ) {
	
							uuids.push( serialize( meta.materials, this.material[ i ] ) );
	
						}
	
						object.material = uuids;
	
					} else {
	
						object.material = serialize( meta.materials, this.material );
	
					}
	
				}
	
				//
	
				if ( this.children.length > 0 ) {
	
					object.children = [];
	
					for ( var i = 0; i < this.children.length; i ++ ) {
	
						object.children.push( this.children[ i ].toJSON( meta ).object );
	
					}
	
				}
	
				if ( isRootObject ) {
	
					var geometries = extractFromCache( meta.geometries );
					var materials = extractFromCache( meta.materials );
					var textures = extractFromCache( meta.textures );
					var images = extractFromCache( meta.images );
	
					if ( geometries.length > 0 ) output.geometries = geometries;
					if ( materials.length > 0 ) output.materials = materials;
					if ( textures.length > 0 ) output.textures = textures;
					if ( images.length > 0 ) output.images = images;
	
				}
	
				output.object = object;
	
				return output;
	
				// extract data from the cache hash
				// remove metadata on each item
				// and return as array
				function extractFromCache( cache ) {
	
					var values = [];
					for ( var key in cache ) {
	
						var data = cache[ key ];
						delete data.metadata;
						values.push( data );
	
					}
					return values;
	
				}
	
			},
	
			clone: function ( recursive ) {
	
				return new this.constructor().copy( this, recursive );
	
			},
	
			copy: function ( source, recursive ) {
	
				if ( recursive === undefined ) recursive = true;
	
				this.name = source.name;
	
				this.up.copy( source.up );
	
				this.position.copy( source.position );
				this.quaternion.copy( source.quaternion );
				this.scale.copy( source.scale );
	
				this.matrix.copy( source.matrix );
				this.matrixWorld.copy( source.matrixWorld );
	
				this.matrixAutoUpdate = source.matrixAutoUpdate;
				this.matrixWorldNeedsUpdate = source.matrixWorldNeedsUpdate;
	
				this.layers.mask = source.layers.mask;
				this.visible = source.visible;
	
				this.castShadow = source.castShadow;
				this.receiveShadow = source.receiveShadow;
	
				this.frustumCulled = source.frustumCulled;
				this.renderOrder = source.renderOrder;
	
				this.userData = JSON.parse( JSON.stringify( source.userData ) );
	
				if ( recursive === true ) {
	
					for ( var i = 0; i < source.children.length; i ++ ) {
	
						var child = source.children[ i ];
						this.add( child.clone() );
	
					}
	
				}
	
				return this;
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author mikael emtinger / http://gomo.se/
		 * @author WestLangley / http://github.com/WestLangley
		*/
	
		function Camera() {
	
			Object3D.call( this );
	
			this.type = 'Camera';
	
			this.matrixWorldInverse = new Matrix4();
			this.projectionMatrix = new Matrix4();
	
		}
	
		Camera.prototype = Object.assign( Object.create( Object3D.prototype ), {
	
			constructor: Camera,
	
			isCamera: true,
	
			copy: function ( source, recursive ) {
	
				Object3D.prototype.copy.call( this, source, recursive );
	
				this.matrixWorldInverse.copy( source.matrixWorldInverse );
				this.projectionMatrix.copy( source.projectionMatrix );
	
				return this;
	
			},
	
			getWorldDirection: function () {
	
				var quaternion = new Quaternion();
	
				return function getWorldDirection( optionalTarget ) {
	
					var result = optionalTarget || new Vector3();
	
					this.getWorldQuaternion( quaternion );
	
					return result.set( 0, 0, - 1 ).applyQuaternion( quaternion );
	
				};
	
			}(),
	
			updateMatrixWorld: function ( force ) {
	
				Object3D.prototype.updateMatrixWorld.call( this, force );
	
				this.matrixWorldInverse.getInverse( this.matrixWorld );
	
			},
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			}
	
		} );
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 * @author arose / http://github.com/arose
		 */
	
		function OrthographicCamera( left, right, top, bottom, near, far ) {
	
			Camera.call( this );
	
			this.type = 'OrthographicCamera';
	
			this.zoom = 1;
			this.view = null;
	
			this.left = left;
			this.right = right;
			this.top = top;
			this.bottom = bottom;
	
			this.near = ( near !== undefined ) ? near : 0.1;
			this.far = ( far !== undefined ) ? far : 2000;
	
			this.updateProjectionMatrix();
	
		}
	
		OrthographicCamera.prototype = Object.assign( Object.create( Camera.prototype ), {
	
			constructor: OrthographicCamera,
	
			isOrthographicCamera: true,
	
			copy: function ( source, recursive ) {
	
				Camera.prototype.copy.call( this, source, recursive );
	
				this.left = source.left;
				this.right = source.right;
				this.top = source.top;
				this.bottom = source.bottom;
				this.near = source.near;
				this.far = source.far;
	
				this.zoom = source.zoom;
				this.view = source.view === null ? null : Object.assign( {}, source.view );
	
				return this;
	
			},
	
			setViewOffset: function( fullWidth, fullHeight, x, y, width, height ) {
	
				this.view = {
					fullWidth: fullWidth,
					fullHeight: fullHeight,
					offsetX: x,
					offsetY: y,
					width: width,
					height: height
				};
	
				this.updateProjectionMatrix();
	
			},
	
			clearViewOffset: function() {
	
				this.view = null;
				this.updateProjectionMatrix();
	
			},
	
			updateProjectionMatrix: function () {
	
				var dx = ( this.right - this.left ) / ( 2 * this.zoom );
				var dy = ( this.top - this.bottom ) / ( 2 * this.zoom );
				var cx = ( this.right + this.left ) / 2;
				var cy = ( this.top + this.bottom ) / 2;
	
				var left = cx - dx;
				var right = cx + dx;
				var top = cy + dy;
				var bottom = cy - dy;
	
				if ( this.view !== null ) {
	
					var zoomW = this.zoom / ( this.view.width / this.view.fullWidth );
					var zoomH = this.zoom / ( this.view.height / this.view.fullHeight );
					var scaleW = ( this.right - this.left ) / this.view.width;
					var scaleH = ( this.top - this.bottom ) / this.view.height;
	
					left += scaleW * ( this.view.offsetX / zoomW );
					right = left + scaleW * ( this.view.width / zoomW );
					top -= scaleH * ( this.view.offsetY / zoomH );
					bottom = top - scaleH * ( this.view.height / zoomH );
	
				}
	
				this.projectionMatrix.makeOrthographic( left, right, top, bottom, this.near, this.far );
	
			},
	
			toJSON: function ( meta ) {
	
				var data = Object3D.prototype.toJSON.call( this, meta );
	
				data.object.zoom = this.zoom;
				data.object.left = this.left;
				data.object.right = this.right;
				data.object.top = this.top;
				data.object.bottom = this.bottom;
				data.object.near = this.near;
				data.object.far = this.far;
	
				if ( this.view !== null ) data.object.view = Object.assign( {}, this.view );
	
				return data;
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author greggman / http://games.greggman.com/
		 * @author zz85 / http://www.lab4games.net/zz85/blog
		 * @author tschw
		 */
	
		function PerspectiveCamera( fov, aspect, near, far ) {
	
			Camera.call( this );
	
			this.type = 'PerspectiveCamera';
	
			this.fov = fov !== undefined ? fov : 50;
			this.zoom = 1;
	
			this.near = near !== undefined ? near : 0.1;
			this.far = far !== undefined ? far : 2000;
			this.focus = 10;
	
			this.aspect = aspect !== undefined ? aspect : 1;
			this.view = null;
	
			this.filmGauge = 35;	// width of the film (default in millimeters)
			this.filmOffset = 0;	// horizontal film offset (same unit as gauge)
	
			this.updateProjectionMatrix();
	
		}
	
		PerspectiveCamera.prototype = Object.assign( Object.create( Camera.prototype ), {
	
			constructor: PerspectiveCamera,
	
			isPerspectiveCamera: true,
	
			copy: function ( source, recursive ) {
	
				Camera.prototype.copy.call( this, source, recursive );
	
				this.fov = source.fov;
				this.zoom = source.zoom;
	
				this.near = source.near;
				this.far = source.far;
				this.focus = source.focus;
	
				this.aspect = source.aspect;
				this.view = source.view === null ? null : Object.assign( {}, source.view );
	
				this.filmGauge = source.filmGauge;
				this.filmOffset = source.filmOffset;
	
				return this;
	
			},
	
			/**
			 * Sets the FOV by focal length in respect to the current .filmGauge.
			 *
			 * The default film gauge is 35, so that the focal length can be specified for
			 * a 35mm (full frame) camera.
			 *
			 * Values for focal length and film gauge must have the same unit.
			 */
			setFocalLength: function ( focalLength ) {
	
				// see http://www.bobatkins.com/photography/technical/field_of_view.html
				var vExtentSlope = 0.5 * this.getFilmHeight() / focalLength;
	
				this.fov = _Math.RAD2DEG * 2 * Math.atan( vExtentSlope );
				this.updateProjectionMatrix();
	
			},
	
			/**
			 * Calculates the focal length from the current .fov and .filmGauge.
			 */
			getFocalLength: function () {
	
				var vExtentSlope = Math.tan( _Math.DEG2RAD * 0.5 * this.fov );
	
				return 0.5 * this.getFilmHeight() / vExtentSlope;
	
			},
	
			getEffectiveFOV: function () {
	
				return _Math.RAD2DEG * 2 * Math.atan(
						Math.tan( _Math.DEG2RAD * 0.5 * this.fov ) / this.zoom );
	
			},
	
			getFilmWidth: function () {
	
				// film not completely covered in portrait format (aspect < 1)
				return this.filmGauge * Math.min( this.aspect, 1 );
	
			},
	
			getFilmHeight: function () {
	
				// film not completely covered in landscape format (aspect > 1)
				return this.filmGauge / Math.max( this.aspect, 1 );
	
			},
	
			/**
			 * Sets an offset in a larger frustum. This is useful for multi-window or
			 * multi-monitor/multi-machine setups.
			 *
			 * For example, if you have 3x2 monitors and each monitor is 1920x1080 and
			 * the monitors are in grid like this
			 *
			 *   +---+---+---+
			 *   | A | B | C |
			 *   +---+---+---+
			 *   | D | E | F |
			 *   +---+---+---+
			 *
			 * then for each monitor you would call it like this
			 *
			 *   var w = 1920;
			 *   var h = 1080;
			 *   var fullWidth = w * 3;
			 *   var fullHeight = h * 2;
			 *
			 *   --A--
			 *   camera.setOffset( fullWidth, fullHeight, w * 0, h * 0, w, h );
			 *   --B--
			 *   camera.setOffset( fullWidth, fullHeight, w * 1, h * 0, w, h );
			 *   --C--
			 *   camera.setOffset( fullWidth, fullHeight, w * 2, h * 0, w, h );
			 *   --D--
			 *   camera.setOffset( fullWidth, fullHeight, w * 0, h * 1, w, h );
			 *   --E--
			 *   camera.setOffset( fullWidth, fullHeight, w * 1, h * 1, w, h );
			 *   --F--
			 *   camera.setOffset( fullWidth, fullHeight, w * 2, h * 1, w, h );
			 *
			 *   Note there is no reason monitors have to be the same size or in a grid.
			 */
			setViewOffset: function ( fullWidth, fullHeight, x, y, width, height ) {
	
				this.aspect = fullWidth / fullHeight;
	
				this.view = {
					fullWidth: fullWidth,
					fullHeight: fullHeight,
					offsetX: x,
					offsetY: y,
					width: width,
					height: height
				};
	
				this.updateProjectionMatrix();
	
			},
	
			clearViewOffset: function () {
	
				this.view = null;
				this.updateProjectionMatrix();
	
			},
	
			updateProjectionMatrix: function () {
	
				var near = this.near,
					top = near * Math.tan(
							_Math.DEG2RAD * 0.5 * this.fov ) / this.zoom,
					height = 2 * top,
					width = this.aspect * height,
					left = - 0.5 * width,
					view = this.view;
	
				if ( view !== null ) {
	
					var fullWidth = view.fullWidth,
						fullHeight = view.fullHeight;
	
					left += view.offsetX * width / fullWidth;
					top -= view.offsetY * height / fullHeight;
					width *= view.width / fullWidth;
					height *= view.height / fullHeight;
	
				}
	
				var skew = this.filmOffset;
				if ( skew !== 0 ) left += near * skew / this.getFilmWidth();
	
				this.projectionMatrix.makePerspective( left, left + width, top, top - height, near, this.far );
	
			},
	
			toJSON: function ( meta ) {
	
				var data = Object3D.prototype.toJSON.call( this, meta );
	
				data.object.fov = this.fov;
				data.object.zoom = this.zoom;
	
				data.object.near = this.near;
				data.object.far = this.far;
				data.object.focus = this.focus;
	
				data.object.aspect = this.aspect;
	
				if ( this.view !== null ) data.object.view = Object.assign( {}, this.view );
	
				data.object.filmGauge = this.filmGauge;
				data.object.filmOffset = this.filmOffset;
	
				return data;
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author alteredq / http://alteredqualia.com/
		 */
	
		function Face3( a, b, c, normal, color, materialIndex ) {
	
			this.a = a;
			this.b = b;
			this.c = c;
	
			this.normal = ( normal && normal.isVector3 ) ? normal : new Vector3();
			this.vertexNormals = Array.isArray( normal ) ? normal : [];
	
			this.color = ( color && color.isColor ) ? color : new Color();
			this.vertexColors = Array.isArray( color ) ? color : [];
	
			this.materialIndex = materialIndex !== undefined ? materialIndex : 0;
	
		}
	
		Object.assign( Face3.prototype, {
	
			clone: function () {
	
				return new this.constructor().copy( this );
	
			},
	
			copy: function ( source ) {
	
				this.a = source.a;
				this.b = source.b;
				this.c = source.c;
	
				this.normal.copy( source.normal );
				this.color.copy( source.color );
	
				this.materialIndex = source.materialIndex;
	
				for ( var i = 0, il = source.vertexNormals.length; i < il; i ++ ) {
	
					this.vertexNormals[ i ] = source.vertexNormals[ i ].clone();
	
				}
	
				for ( var i = 0, il = source.vertexColors.length; i < il; i ++ ) {
	
					this.vertexColors[ i ] = source.vertexColors[ i ].clone();
	
				}
	
				return this;
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 * @author kile / http://kile.stravaganza.org/
		 * @author alteredq / http://alteredqualia.com/
		 * @author mikael emtinger / http://gomo.se/
		 * @author zz85 / http://www.lab4games.net/zz85/blog
		 * @author bhouston / http://clara.io
		 */
	
		var count = 0;
		function GeometryIdCount() { return count++; }
	
		function Geometry() {
	
			Object.defineProperty( this, 'id', { value: GeometryIdCount() } );
	
			this.uuid = _Math.generateUUID();
	
			this.name = '';
			this.type = 'Geometry';
	
			this.vertices = [];
			this.colors = [];
			this.faces = [];
			this.faceVertexUvs = [[]];
	
			this.morphTargets = [];
			this.morphNormals = [];
	
			this.skinWeights = [];
			this.skinIndices = [];
	
			this.lineDistances = [];
	
			this.boundingBox = null;
			this.boundingSphere = null;
	
			// update flags
	
			this.elementsNeedUpdate = false;
			this.verticesNeedUpdate = false;
			this.uvsNeedUpdate = false;
			this.normalsNeedUpdate = false;
			this.colorsNeedUpdate = false;
			this.lineDistancesNeedUpdate = false;
			this.groupsNeedUpdate = false;
	
		}
	
		Object.assign( Geometry.prototype, EventDispatcher.prototype, {
	
			isGeometry: true,
	
			applyMatrix: function ( matrix ) {
	
				var normalMatrix = new Matrix3().getNormalMatrix( matrix );
	
				for ( var i = 0, il = this.vertices.length; i < il; i ++ ) {
	
					var vertex = this.vertices[ i ];
					vertex.applyMatrix4( matrix );
	
				}
	
				for ( var i = 0, il = this.faces.length; i < il; i ++ ) {
	
					var face = this.faces[ i ];
					face.normal.applyMatrix3( normalMatrix ).normalize();
	
					for ( var j = 0, jl = face.vertexNormals.length; j < jl; j ++ ) {
	
						face.vertexNormals[ j ].applyMatrix3( normalMatrix ).normalize();
	
					}
	
				}
	
				if ( this.boundingBox !== null ) {
	
					this.computeBoundingBox();
	
				}
	
				if ( this.boundingSphere !== null ) {
	
					this.computeBoundingSphere();
	
				}
	
				this.verticesNeedUpdate = true;
				this.normalsNeedUpdate = true;
	
				return this;
	
			},
	
			rotateX: function () {
	
				// rotate geometry around world x-axis
	
				var m1 = new Matrix4();
	
				return function rotateX( angle ) {
	
					m1.makeRotationX( angle );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			rotateY: function () {
	
				// rotate geometry around world y-axis
	
				var m1 = new Matrix4();
	
				return function rotateY( angle ) {
	
					m1.makeRotationY( angle );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			rotateZ: function () {
	
				// rotate geometry around world z-axis
	
				var m1 = new Matrix4();
	
				return function rotateZ( angle ) {
	
					m1.makeRotationZ( angle );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			translate: function () {
	
				// translate geometry
	
				var m1 = new Matrix4();
	
				return function translate( x, y, z ) {
	
					m1.makeTranslation( x, y, z );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			scale: function () {
	
				// scale geometry
	
				var m1 = new Matrix4();
	
				return function scale( x, y, z ) {
	
					m1.makeScale( x, y, z );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			lookAt: function () {
	
				var obj = new Object3D();
	
				return function lookAt( vector ) {
	
					obj.lookAt( vector );
	
					obj.updateMatrix();
	
					this.applyMatrix( obj.matrix );
	
				};
	
			}(),
	
			fromBufferGeometry: function ( geometry ) {
	
				var scope = this;
	
				var indices = geometry.index !== null ? geometry.index.array : undefined;
				var attributes = geometry.attributes;
	
				var positions = attributes.position.array;
				var normals = attributes.normal !== undefined ? attributes.normal.array : undefined;
				var colors = attributes.color !== undefined ? attributes.color.array : undefined;
				var uvs = attributes.uv !== undefined ? attributes.uv.array : undefined;
				var uvs2 = attributes.uv2 !== undefined ? attributes.uv2.array : undefined;
	
				if ( uvs2 !== undefined ) this.faceVertexUvs[ 1 ] = [];
	
				var tempNormals = [];
				var tempUVs = [];
				var tempUVs2 = [];
	
				for ( var i = 0, j = 0; i < positions.length; i += 3, j += 2 ) {
	
					scope.vertices.push( new Vector3( positions[ i ], positions[ i + 1 ], positions[ i + 2 ] ) );
	
					if ( normals !== undefined ) {
	
						tempNormals.push( new Vector3( normals[ i ], normals[ i + 1 ], normals[ i + 2 ] ) );
	
					}
	
					if ( colors !== undefined ) {
	
						scope.colors.push( new Color( colors[ i ], colors[ i + 1 ], colors[ i + 2 ] ) );
	
					}
	
					if ( uvs !== undefined ) {
	
						tempUVs.push( new Vector2( uvs[ j ], uvs[ j + 1 ] ) );
	
					}
	
					if ( uvs2 !== undefined ) {
	
						tempUVs2.push( new Vector2( uvs2[ j ], uvs2[ j + 1 ] ) );
	
					}
	
				}
	
				function addFace( a, b, c, materialIndex ) {
	
					var vertexNormals = normals !== undefined ? [ tempNormals[ a ].clone(), tempNormals[ b ].clone(), tempNormals[ c ].clone() ] : [];
					var vertexColors = colors !== undefined ? [ scope.colors[ a ].clone(), scope.colors[ b ].clone(), scope.colors[ c ].clone() ] : [];
	
					var face = new Face3( a, b, c, vertexNormals, vertexColors, materialIndex );
	
					scope.faces.push( face );
	
					if ( uvs !== undefined ) {
	
						scope.faceVertexUvs[ 0 ].push( [ tempUVs[ a ].clone(), tempUVs[ b ].clone(), tempUVs[ c ].clone() ] );
	
					}
	
					if ( uvs2 !== undefined ) {
	
						scope.faceVertexUvs[ 1 ].push( [ tempUVs2[ a ].clone(), tempUVs2[ b ].clone(), tempUVs2[ c ].clone() ] );
	
					}
	
				}
	
				var groups = geometry.groups;
	
				if ( groups.length > 0 ) {
	
					for ( var i = 0; i < groups.length; i ++ ) {
	
						var group = groups[ i ];
	
						var start = group.start;
						var count = group.count;
	
						for ( var j = start, jl = start + count; j < jl; j += 3 ) {
	
							if ( indices !== undefined ) {
	
								addFace( indices[ j ], indices[ j + 1 ], indices[ j + 2 ], group.materialIndex );
	
							} else {
	
								addFace( j, j + 1, j + 2, group.materialIndex );
	
							}
	
						}
	
					}
	
				} else {
	
					if ( indices !== undefined ) {
	
						for ( var i = 0; i < indices.length; i += 3 ) {
	
							addFace( indices[ i ], indices[ i + 1 ], indices[ i + 2 ] );
	
						}
	
					} else {
	
						for ( var i = 0; i < positions.length / 3; i += 3 ) {
	
							addFace( i, i + 1, i + 2 );
	
						}
	
					}
	
				}
	
				this.computeFaceNormals();
	
				if ( geometry.boundingBox !== null ) {
	
					this.boundingBox = geometry.boundingBox.clone();
	
				}
	
				if ( geometry.boundingSphere !== null ) {
	
					this.boundingSphere = geometry.boundingSphere.clone();
	
				}
	
				return this;
	
			},
	
			center: function () {
	
				this.computeBoundingBox();
	
				var offset = this.boundingBox.getCenter().negate();
	
				this.translate( offset.x, offset.y, offset.z );
	
				return offset;
	
			},
	
			normalize: function () {
	
				this.computeBoundingSphere();
	
				var center = this.boundingSphere.center;
				var radius = this.boundingSphere.radius;
	
				var s = radius === 0 ? 1 : 1.0 / radius;
	
				var matrix = new Matrix4();
				matrix.set(
					s, 0, 0, - s * center.x,
					0, s, 0, - s * center.y,
					0, 0, s, - s * center.z,
					0, 0, 0, 1
				);
	
				this.applyMatrix( matrix );
	
				return this;
	
			},
	
			computeFaceNormals: function () {
	
				var cb = new Vector3(), ab = new Vector3();
	
				for ( var f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
					var face = this.faces[ f ];
	
					var vA = this.vertices[ face.a ];
					var vB = this.vertices[ face.b ];
					var vC = this.vertices[ face.c ];
	
					cb.subVectors( vC, vB );
					ab.subVectors( vA, vB );
					cb.cross( ab );
	
					cb.normalize();
	
					face.normal.copy( cb );
	
				}
	
			},
	
			computeVertexNormals: function ( areaWeighted ) {
	
				if ( areaWeighted === undefined ) areaWeighted = true;
	
				var v, vl, f, fl, face, vertices;
	
				vertices = new Array( this.vertices.length );
	
				for ( v = 0, vl = this.vertices.length; v < vl; v ++ ) {
	
					vertices[ v ] = new Vector3();
	
				}
	
				if ( areaWeighted ) {
	
					// vertex normals weighted by triangle areas
					// http://www.iquilezles.org/www/articles/normals/normals.htm
	
					var vA, vB, vC;
					var cb = new Vector3(), ab = new Vector3();
	
					for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
						face = this.faces[ f ];
	
						vA = this.vertices[ face.a ];
						vB = this.vertices[ face.b ];
						vC = this.vertices[ face.c ];
	
						cb.subVectors( vC, vB );
						ab.subVectors( vA, vB );
						cb.cross( ab );
	
						vertices[ face.a ].add( cb );
						vertices[ face.b ].add( cb );
						vertices[ face.c ].add( cb );
	
					}
	
				} else {
	
					this.computeFaceNormals();
	
					for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
						face = this.faces[ f ];
	
						vertices[ face.a ].add( face.normal );
						vertices[ face.b ].add( face.normal );
						vertices[ face.c ].add( face.normal );
	
					}
	
				}
	
				for ( v = 0, vl = this.vertices.length; v < vl; v ++ ) {
	
					vertices[ v ].normalize();
	
				}
	
				for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
					face = this.faces[ f ];
	
					var vertexNormals = face.vertexNormals;
	
					if ( vertexNormals.length === 3 ) {
	
						vertexNormals[ 0 ].copy( vertices[ face.a ] );
						vertexNormals[ 1 ].copy( vertices[ face.b ] );
						vertexNormals[ 2 ].copy( vertices[ face.c ] );
	
					} else {
	
						vertexNormals[ 0 ] = vertices[ face.a ].clone();
						vertexNormals[ 1 ] = vertices[ face.b ].clone();
						vertexNormals[ 2 ] = vertices[ face.c ].clone();
	
					}
	
				}
	
				if ( this.faces.length > 0 ) {
	
					this.normalsNeedUpdate = true;
	
				}
	
			},
	
			computeFlatVertexNormals: function () {
	
				var f, fl, face;
	
				this.computeFaceNormals();
	
				for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
					face = this.faces[ f ];
	
					var vertexNormals = face.vertexNormals;
	
					if ( vertexNormals.length === 3 ) {
	
						vertexNormals[ 0 ].copy( face.normal );
						vertexNormals[ 1 ].copy( face.normal );
						vertexNormals[ 2 ].copy( face.normal );
	
					} else {
	
						vertexNormals[ 0 ] = face.normal.clone();
						vertexNormals[ 1 ] = face.normal.clone();
						vertexNormals[ 2 ] = face.normal.clone();
	
					}
	
				}
	
				if ( this.faces.length > 0 ) {
	
					this.normalsNeedUpdate = true;
	
				}
	
			},
	
			computeMorphNormals: function () {
	
				var i, il, f, fl, face;
	
				// save original normals
				// - create temp variables on first access
				//   otherwise just copy (for faster repeated calls)
	
				for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
					face = this.faces[ f ];
	
					if ( ! face.__originalFaceNormal ) {
	
						face.__originalFaceNormal = face.normal.clone();
	
					} else {
	
						face.__originalFaceNormal.copy( face.normal );
	
					}
	
					if ( ! face.__originalVertexNormals ) face.__originalVertexNormals = [];
	
					for ( i = 0, il = face.vertexNormals.length; i < il; i ++ ) {
	
						if ( ! face.__originalVertexNormals[ i ] ) {
	
							face.__originalVertexNormals[ i ] = face.vertexNormals[ i ].clone();
	
						} else {
	
							face.__originalVertexNormals[ i ].copy( face.vertexNormals[ i ] );
	
						}
	
					}
	
				}
	
				// use temp geometry to compute face and vertex normals for each morph
	
				var tmpGeo = new Geometry();
				tmpGeo.faces = this.faces;
	
				for ( i = 0, il = this.morphTargets.length; i < il; i ++ ) {
	
					// create on first access
	
					if ( ! this.morphNormals[ i ] ) {
	
						this.morphNormals[ i ] = {};
						this.morphNormals[ i ].faceNormals = [];
						this.morphNormals[ i ].vertexNormals = [];
	
						var dstNormalsFace = this.morphNormals[ i ].faceNormals;
						var dstNormalsVertex = this.morphNormals[ i ].vertexNormals;
	
						var faceNormal, vertexNormals;
	
						for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
							faceNormal = new Vector3();
							vertexNormals = { a: new Vector3(), b: new Vector3(), c: new Vector3() };
	
							dstNormalsFace.push( faceNormal );
							dstNormalsVertex.push( vertexNormals );
	
						}
	
					}
	
					var morphNormals = this.morphNormals[ i ];
	
					// set vertices to morph target
	
					tmpGeo.vertices = this.morphTargets[ i ].vertices;
	
					// compute morph normals
	
					tmpGeo.computeFaceNormals();
					tmpGeo.computeVertexNormals();
	
					// store morph normals
	
					var faceNormal, vertexNormals;
	
					for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
						face = this.faces[ f ];
	
						faceNormal = morphNormals.faceNormals[ f ];
						vertexNormals = morphNormals.vertexNormals[ f ];
	
						faceNormal.copy( face.normal );
	
						vertexNormals.a.copy( face.vertexNormals[ 0 ] );
						vertexNormals.b.copy( face.vertexNormals[ 1 ] );
						vertexNormals.c.copy( face.vertexNormals[ 2 ] );
	
					}
	
				}
	
				// restore original normals
	
				for ( f = 0, fl = this.faces.length; f < fl; f ++ ) {
	
					face = this.faces[ f ];
	
					face.normal = face.__originalFaceNormal;
					face.vertexNormals = face.__originalVertexNormals;
	
				}
	
			},
	
			computeLineDistances: function () {
	
				var d = 0;
				var vertices = this.vertices;
	
				for ( var i = 0, il = vertices.length; i < il; i ++ ) {
	
					if ( i > 0 ) {
	
						d += vertices[ i ].distanceTo( vertices[ i - 1 ] );
	
					}
	
					this.lineDistances[ i ] = d;
	
				}
	
			},
	
			computeBoundingBox: function () {
	
				if ( this.boundingBox === null ) {
	
					this.boundingBox = new Box3();
	
				}
	
				this.boundingBox.setFromPoints( this.vertices );
	
			},
	
			computeBoundingSphere: function () {
	
				if ( this.boundingSphere === null ) {
	
					this.boundingSphere = new Sphere();
	
				}
	
				this.boundingSphere.setFromPoints( this.vertices );
	
			},
	
			merge: function ( geometry, matrix, materialIndexOffset ) {
	
				if ( ! ( geometry && geometry.isGeometry ) ) {
	
					console.error( 'THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.', geometry );
					return;
	
				}
	
				var normalMatrix,
					vertexOffset = this.vertices.length,
					vertices1 = this.vertices,
					vertices2 = geometry.vertices,
					faces1 = this.faces,
					faces2 = geometry.faces,
					uvs1 = this.faceVertexUvs[ 0 ],
					uvs2 = geometry.faceVertexUvs[ 0 ],
					colors1 = this.colors,
					colors2 = geometry.colors;
	
				if ( materialIndexOffset === undefined ) materialIndexOffset = 0;
	
				if ( matrix !== undefined ) {
	
					normalMatrix = new Matrix3().getNormalMatrix( matrix );
	
				}
	
				// vertices
	
				for ( var i = 0, il = vertices2.length; i < il; i ++ ) {
	
					var vertex = vertices2[ i ];
	
					var vertexCopy = vertex.clone();
	
					if ( matrix !== undefined ) vertexCopy.applyMatrix4( matrix );
	
					vertices1.push( vertexCopy );
	
				}
	
				// colors
	
				for ( var i = 0, il = colors2.length; i < il; i ++ ) {
	
					colors1.push( colors2[ i ].clone() );
	
				}
	
				// faces
	
				for ( i = 0, il = faces2.length; i < il; i ++ ) {
	
					var face = faces2[ i ], faceCopy, normal, color,
						faceVertexNormals = face.vertexNormals,
						faceVertexColors = face.vertexColors;
	
					faceCopy = new Face3( face.a + vertexOffset, face.b + vertexOffset, face.c + vertexOffset );
					faceCopy.normal.copy( face.normal );
	
					if ( normalMatrix !== undefined ) {
	
						faceCopy.normal.applyMatrix3( normalMatrix ).normalize();
	
					}
	
					for ( var j = 0, jl = faceVertexNormals.length; j < jl; j ++ ) {
	
						normal = faceVertexNormals[ j ].clone();
	
						if ( normalMatrix !== undefined ) {
	
							normal.applyMatrix3( normalMatrix ).normalize();
	
						}
	
						faceCopy.vertexNormals.push( normal );
	
					}
	
					faceCopy.color.copy( face.color );
	
					for ( var j = 0, jl = faceVertexColors.length; j < jl; j ++ ) {
	
						color = faceVertexColors[ j ];
						faceCopy.vertexColors.push( color.clone() );
	
					}
	
					faceCopy.materialIndex = face.materialIndex + materialIndexOffset;
	
					faces1.push( faceCopy );
	
				}
	
				// uvs
	
				for ( i = 0, il = uvs2.length; i < il; i ++ ) {
	
					var uv = uvs2[ i ], uvCopy = [];
	
					if ( uv === undefined ) {
	
						continue;
	
					}
	
					for ( var j = 0, jl = uv.length; j < jl; j ++ ) {
	
						uvCopy.push( uv[ j ].clone() );
	
					}
	
					uvs1.push( uvCopy );
	
				}
	
			},
	
			mergeMesh: function ( mesh ) {
	
				if ( ! ( mesh && mesh.isMesh ) ) {
	
					console.error( 'THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.', mesh );
					return;
	
				}
	
				mesh.matrixAutoUpdate && mesh.updateMatrix();
	
				this.merge( mesh.geometry, mesh.matrix );
	
			},
	
			/*
			 * Checks for duplicate vertices with hashmap.
			 * Duplicated vertices are removed
			 * and faces' vertices are updated.
			 */
	
			mergeVertices: function () {
	
				var verticesMap = {}; // Hashmap for looking up vertices by position coordinates (and making sure they are unique)
				var unique = [], changes = [];
	
				var v, key;
				var precisionPoints = 4; // number of decimal points, e.g. 4 for epsilon of 0.0001
				var precision = Math.pow( 10, precisionPoints );
				var i, il, face;
				var indices, j, jl;
	
				for ( i = 0, il = this.vertices.length; i < il; i ++ ) {
	
					v = this.vertices[ i ];
					key = Math.round( v.x * precision ) + '_' + Math.round( v.y * precision ) + '_' + Math.round( v.z * precision );
	
					if ( verticesMap[ key ] === undefined ) {
	
						verticesMap[ key ] = i;
						unique.push( this.vertices[ i ] );
						changes[ i ] = unique.length - 1;
	
					} else {
	
						//console.log('Duplicate vertex found. ', i, ' could be using ', verticesMap[key]);
						changes[ i ] = changes[ verticesMap[ key ] ];
	
					}
	
				}
	
	
				// if faces are completely degenerate after merging vertices, we
				// have to remove them from the geometry.
				var faceIndicesToRemove = [];
	
				for ( i = 0, il = this.faces.length; i < il; i ++ ) {
	
					face = this.faces[ i ];
	
					face.a = changes[ face.a ];
					face.b = changes[ face.b ];
					face.c = changes[ face.c ];
	
					indices = [ face.a, face.b, face.c ];
	
					// if any duplicate vertices are found in a Face3
					// we have to remove the face as nothing can be saved
					for ( var n = 0; n < 3; n ++ ) {
	
						if ( indices[ n ] === indices[ ( n + 1 ) % 3 ] ) {
	
							faceIndicesToRemove.push( i );
							break;
	
						}
	
					}
	
				}
	
				for ( i = faceIndicesToRemove.length - 1; i >= 0; i -- ) {
	
					var idx = faceIndicesToRemove[ i ];
	
					this.faces.splice( idx, 1 );
	
					for ( j = 0, jl = this.faceVertexUvs.length; j < jl; j ++ ) {
	
						this.faceVertexUvs[ j ].splice( idx, 1 );
	
					}
	
				}
	
				// Use unique set of vertices
	
				var diff = this.vertices.length - unique.length;
				this.vertices = unique;
				return diff;
	
			},
	
			sortFacesByMaterialIndex: function () {
	
				var faces = this.faces;
				var length = faces.length;
	
				// tag faces
	
				for ( var i = 0; i < length; i ++ ) {
	
					faces[ i ]._id = i;
	
				}
	
				// sort faces
	
				function materialIndexSort( a, b ) {
	
					return a.materialIndex - b.materialIndex;
	
				}
	
				faces.sort( materialIndexSort );
	
				// sort uvs
	
				var uvs1 = this.faceVertexUvs[ 0 ];
				var uvs2 = this.faceVertexUvs[ 1 ];
	
				var newUvs1, newUvs2;
	
				if ( uvs1 && uvs1.length === length ) newUvs1 = [];
				if ( uvs2 && uvs2.length === length ) newUvs2 = [];
	
				for ( var i = 0; i < length; i ++ ) {
	
					var id = faces[ i ]._id;
	
					if ( newUvs1 ) newUvs1.push( uvs1[ id ] );
					if ( newUvs2 ) newUvs2.push( uvs2[ id ] );
	
				}
	
				if ( newUvs1 ) this.faceVertexUvs[ 0 ] = newUvs1;
				if ( newUvs2 ) this.faceVertexUvs[ 1 ] = newUvs2;
	
			},
	
			toJSON: function () {
	
				var data = {
					metadata: {
						version: 4.5,
						type: 'Geometry',
						generator: 'Geometry.toJSON'
					}
				};
	
				// standard Geometry serialization
	
				data.uuid = this.uuid;
				data.type = this.type;
				if ( this.name !== '' ) data.name = this.name;
	
				if ( this.parameters !== undefined ) {
	
					var parameters = this.parameters;
	
					for ( var key in parameters ) {
	
						if ( parameters[ key ] !== undefined ) data[ key ] = parameters[ key ];
	
					}
	
					return data;
	
				}
	
				var vertices = [];
	
				for ( var i = 0; i < this.vertices.length; i ++ ) {
	
					var vertex = this.vertices[ i ];
					vertices.push( vertex.x, vertex.y, vertex.z );
	
				}
	
				var faces = [];
				var normals = [];
				var normalsHash = {};
				var colors = [];
				var colorsHash = {};
				var uvs = [];
				var uvsHash = {};
	
				for ( var i = 0; i < this.faces.length; i ++ ) {
	
					var face = this.faces[ i ];
	
					var hasMaterial = true;
					var hasFaceUv = false; // deprecated
					var hasFaceVertexUv = this.faceVertexUvs[ 0 ][ i ] !== undefined;
					var hasFaceNormal = face.normal.length() > 0;
					var hasFaceVertexNormal = face.vertexNormals.length > 0;
					var hasFaceColor = face.color.r !== 1 || face.color.g !== 1 || face.color.b !== 1;
					var hasFaceVertexColor = face.vertexColors.length > 0;
	
					var faceType = 0;
	
					faceType = setBit( faceType, 0, 0 ); // isQuad
					faceType = setBit( faceType, 1, hasMaterial );
					faceType = setBit( faceType, 2, hasFaceUv );
					faceType = setBit( faceType, 3, hasFaceVertexUv );
					faceType = setBit( faceType, 4, hasFaceNormal );
					faceType = setBit( faceType, 5, hasFaceVertexNormal );
					faceType = setBit( faceType, 6, hasFaceColor );
					faceType = setBit( faceType, 7, hasFaceVertexColor );
	
					faces.push( faceType );
					faces.push( face.a, face.b, face.c );
					faces.push( face.materialIndex );
	
					if ( hasFaceVertexUv ) {
	
						var faceVertexUvs = this.faceVertexUvs[ 0 ][ i ];
	
						faces.push(
							getUvIndex( faceVertexUvs[ 0 ] ),
							getUvIndex( faceVertexUvs[ 1 ] ),
							getUvIndex( faceVertexUvs[ 2 ] )
						);
	
					}
	
					if ( hasFaceNormal ) {
	
						faces.push( getNormalIndex( face.normal ) );
	
					}
	
					if ( hasFaceVertexNormal ) {
	
						var vertexNormals = face.vertexNormals;
	
						faces.push(
							getNormalIndex( vertexNormals[ 0 ] ),
							getNormalIndex( vertexNormals[ 1 ] ),
							getNormalIndex( vertexNormals[ 2 ] )
						);
	
					}
	
					if ( hasFaceColor ) {
	
						faces.push( getColorIndex( face.color ) );
	
					}
	
					if ( hasFaceVertexColor ) {
	
						var vertexColors = face.vertexColors;
	
						faces.push(
							getColorIndex( vertexColors[ 0 ] ),
							getColorIndex( vertexColors[ 1 ] ),
							getColorIndex( vertexColors[ 2 ] )
						);
	
					}
	
				}
	
				function setBit( value, position, enabled ) {
	
					return enabled ? value | ( 1 << position ) : value & ( ~ ( 1 << position ) );
	
				}
	
				function getNormalIndex( normal ) {
	
					var hash = normal.x.toString() + normal.y.toString() + normal.z.toString();
	
					if ( normalsHash[ hash ] !== undefined ) {
	
						return normalsHash[ hash ];
	
					}
	
					normalsHash[ hash ] = normals.length / 3;
					normals.push( normal.x, normal.y, normal.z );
	
					return normalsHash[ hash ];
	
				}
	
				function getColorIndex( color ) {
	
					var hash = color.r.toString() + color.g.toString() + color.b.toString();
	
					if ( colorsHash[ hash ] !== undefined ) {
	
						return colorsHash[ hash ];
	
					}
	
					colorsHash[ hash ] = colors.length;
					colors.push( color.getHex() );
	
					return colorsHash[ hash ];
	
				}
	
				function getUvIndex( uv ) {
	
					var hash = uv.x.toString() + uv.y.toString();
	
					if ( uvsHash[ hash ] !== undefined ) {
	
						return uvsHash[ hash ];
	
					}
	
					uvsHash[ hash ] = uvs.length / 2;
					uvs.push( uv.x, uv.y );
	
					return uvsHash[ hash ];
	
				}
	
				data.data = {};
	
				data.data.vertices = vertices;
				data.data.normals = normals;
				if ( colors.length > 0 ) data.data.colors = colors;
				if ( uvs.length > 0 ) data.data.uvs = [ uvs ]; // temporal backward compatibility
				data.data.faces = faces;
	
				return data;
	
			},
	
			clone: function () {
	
				/*
				 // Handle primitives
	
				 var parameters = this.parameters;
	
				 if ( parameters !== undefined ) {
	
				 var values = [];
	
				 for ( var key in parameters ) {
	
				 values.push( parameters[ key ] );
	
				 }
	
				 var geometry = Object.create( this.constructor.prototype );
				 this.constructor.apply( geometry, values );
				 return geometry;
	
				 }
	
				 return new this.constructor().copy( this );
				 */
	
				return new Geometry().copy( this );
	
			},
	
			copy: function ( source ) {
	
				var i, il, j, jl, k, kl;
	
				// reset
	
				this.vertices = [];
				this.colors = [];
				this.faces = [];
				this.faceVertexUvs = [[]];
				this.morphTargets = [];
				this.morphNormals = [];
				this.skinWeights = [];
				this.skinIndices = [];
				this.lineDistances = [];
				this.boundingBox = null;
				this.boundingSphere = null;
	
				// name
	
				this.name = source.name;
	
				// vertices
	
				var vertices = source.vertices;
	
				for ( i = 0, il = vertices.length; i < il; i ++ ) {
	
					this.vertices.push( vertices[ i ].clone() );
	
				}
	
				// colors
	
				var colors = source.colors;
	
				for ( i = 0, il = colors.length; i < il; i ++ ) {
	
					this.colors.push( colors[ i ].clone() );
	
				}
	
				// faces
	
				var faces = source.faces;
	
				for ( i = 0, il = faces.length; i < il; i ++ ) {
	
					this.faces.push( faces[ i ].clone() );
	
				}
	
				// face vertex uvs
	
				for ( i = 0, il = source.faceVertexUvs.length; i < il; i ++ ) {
	
					var faceVertexUvs = source.faceVertexUvs[ i ];
	
					if ( this.faceVertexUvs[ i ] === undefined ) {
	
						this.faceVertexUvs[ i ] = [];
	
					}
	
					for ( j = 0, jl = faceVertexUvs.length; j < jl; j ++ ) {
	
						var uvs = faceVertexUvs[ j ], uvsCopy = [];
	
						for ( k = 0, kl = uvs.length; k < kl; k ++ ) {
	
							var uv = uvs[ k ];
	
							uvsCopy.push( uv.clone() );
	
						}
	
						this.faceVertexUvs[ i ].push( uvsCopy );
	
					}
	
				}
	
				// morph targets
	
				var morphTargets = source.morphTargets;
	
				for ( i = 0, il = morphTargets.length; i < il; i ++ ) {
	
					var morphTarget = {};
					morphTarget.name = morphTargets[ i ].name;
	
					// vertices
	
					if ( morphTargets[ i ].vertices !== undefined ) {
	
						morphTarget.vertices = [];
	
						for ( j = 0, jl = morphTargets[ i ].vertices.length; j < jl; j ++ ) {
	
							morphTarget.vertices.push( morphTargets[ i ].vertices[ j ].clone() );
	
						}
	
					}
	
					// normals
	
					if ( morphTargets[ i ].normals !== undefined ) {
	
						morphTarget.normals = [];
	
						for ( j = 0, jl = morphTargets[ i ].normals.length; j < jl; j ++ ) {
	
							morphTarget.normals.push( morphTargets[ i ].normals[ j ].clone() );
	
						}
	
					}
	
					this.morphTargets.push( morphTarget );
	
				}
	
				// morph normals
	
				var morphNormals = source.morphNormals;
	
				for ( i = 0, il = morphNormals.length; i < il; i ++ ) {
	
					var morphNormal = {};
	
					// vertex normals
	
					if ( morphNormals[ i ].vertexNormals !== undefined ) {
	
						morphNormal.vertexNormals = [];
	
						for ( j = 0, jl = morphNormals[ i ].vertexNormals.length; j < jl; j ++ ) {
	
							var srcVertexNormal = morphNormals[ i ].vertexNormals[ j ];
							var destVertexNormal = {};
	
							destVertexNormal.a = srcVertexNormal.a.clone();
							destVertexNormal.b = srcVertexNormal.b.clone();
							destVertexNormal.c = srcVertexNormal.c.clone();
	
							morphNormal.vertexNormals.push( destVertexNormal );
	
						}
	
					}
	
					// face normals
	
					if ( morphNormals[ i ].faceNormals !== undefined ) {
	
						morphNormal.faceNormals = [];
	
						for ( j = 0, jl = morphNormals[ i ].faceNormals.length; j < jl; j ++ ) {
	
							morphNormal.faceNormals.push( morphNormals[ i ].faceNormals[ j ].clone() );
	
						}
	
					}
	
					this.morphNormals.push( morphNormal );
	
				}
	
				// skin weights
	
				var skinWeights = source.skinWeights;
	
				for ( i = 0, il = skinWeights.length; i < il; i ++ ) {
	
					this.skinWeights.push( skinWeights[ i ].clone() );
	
				}
	
				// skin indices
	
				var skinIndices = source.skinIndices;
	
				for ( i = 0, il = skinIndices.length; i < il; i ++ ) {
	
					this.skinIndices.push( skinIndices[ i ].clone() );
	
				}
	
				// line distances
	
				var lineDistances = source.lineDistances;
	
				for ( i = 0, il = lineDistances.length; i < il; i ++ ) {
	
					this.lineDistances.push( lineDistances[ i ] );
	
				}
	
				// bounding box
	
				var boundingBox = source.boundingBox;
	
				if ( boundingBox !== null ) {
	
					this.boundingBox = boundingBox.clone();
	
				}
	
				// bounding sphere
	
				var boundingSphere = source.boundingSphere;
	
				if ( boundingSphere !== null ) {
	
					this.boundingSphere = boundingSphere.clone();
	
				}
	
				// update flags
	
				this.elementsNeedUpdate = source.elementsNeedUpdate;
				this.verticesNeedUpdate = source.verticesNeedUpdate;
				this.uvsNeedUpdate = source.uvsNeedUpdate;
				this.normalsNeedUpdate = source.normalsNeedUpdate;
				this.colorsNeedUpdate = source.colorsNeedUpdate;
				this.lineDistancesNeedUpdate = source.lineDistancesNeedUpdate;
				this.groupsNeedUpdate = source.groupsNeedUpdate;
	
				return this;
	
			},
	
			dispose: function () {
	
				this.dispatchEvent( { type: 'dispose' } );
	
			}
	
		} );
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function BufferAttribute( array, itemSize, normalized ) {
	
			if ( Array.isArray( array ) ) {
	
				throw new TypeError( 'THREE.BufferAttribute: array should be a Typed Array.' );
	
			}
	
			this.uuid = _Math.generateUUID();
			this.name = '';
	
			this.array = array;
			this.itemSize = itemSize;
			this.count = array !== undefined ? array.length / itemSize : 0;
			this.normalized = normalized === true;
	
			this.dynamic = false;
			this.updateRange = { offset: 0, count: - 1 };
	
			this.onUploadCallback = function () {};
	
			this.version = 0;
	
		}
	
		Object.defineProperty( BufferAttribute.prototype, 'needsUpdate', {
	
			set: function ( value ) {
	
				if ( value === true ) this.version ++;
	
			}
	
		} );
	
		Object.assign( BufferAttribute.prototype, {
	
			isBufferAttribute: true,
	
			setArray: function ( array ) {
	
				if ( Array.isArray( array ) ) {
	
					throw new TypeError( 'THREE.BufferAttribute: array should be a Typed Array.' );
	
				}
	
				this.count = array !== undefined ? array.length / this.itemSize : 0;
				this.array = array;
	
			},
	
			setDynamic: function ( value ) {
	
				this.dynamic = value;
	
				return this;
	
			},
	
			copy: function ( source ) {
	
				this.array = new source.array.constructor( source.array );
				this.itemSize = source.itemSize;
				this.count = source.count;
				this.normalized = source.normalized;
	
				this.dynamic = source.dynamic;
	
				return this;
	
			},
	
			copyAt: function ( index1, attribute, index2 ) {
	
				index1 *= this.itemSize;
				index2 *= attribute.itemSize;
	
				for ( var i = 0, l = this.itemSize; i < l; i ++ ) {
	
					this.array[ index1 + i ] = attribute.array[ index2 + i ];
	
				}
	
				return this;
	
			},
	
			copyArray: function ( array ) {
	
				this.array.set( array );
	
				return this;
	
			},
	
			copyColorsArray: function ( colors ) {
	
				var array = this.array, offset = 0;
	
				for ( var i = 0, l = colors.length; i < l; i ++ ) {
	
					var color = colors[ i ];
	
					if ( color === undefined ) {
	
						console.warn( 'THREE.BufferAttribute.copyColorsArray(): color is undefined', i );
						color = new Color();
	
					}
	
					array[ offset ++ ] = color.r;
					array[ offset ++ ] = color.g;
					array[ offset ++ ] = color.b;
	
				}
	
				return this;
	
			},
	
			copyIndicesArray: function ( indices ) {
	
				var array = this.array, offset = 0;
	
				for ( var i = 0, l = indices.length; i < l; i ++ ) {
	
					var index = indices[ i ];
	
					array[ offset ++ ] = index.a;
					array[ offset ++ ] = index.b;
					array[ offset ++ ] = index.c;
	
				}
	
				return this;
	
			},
	
			copyVector2sArray: function ( vectors ) {
	
				var array = this.array, offset = 0;
	
				for ( var i = 0, l = vectors.length; i < l; i ++ ) {
	
					var vector = vectors[ i ];
	
					if ( vector === undefined ) {
	
						console.warn( 'THREE.BufferAttribute.copyVector2sArray(): vector is undefined', i );
						vector = new Vector2();
	
					}
	
					array[ offset ++ ] = vector.x;
					array[ offset ++ ] = vector.y;
	
				}
	
				return this;
	
			},
	
			copyVector3sArray: function ( vectors ) {
	
				var array = this.array, offset = 0;
	
				for ( var i = 0, l = vectors.length; i < l; i ++ ) {
	
					var vector = vectors[ i ];
	
					if ( vector === undefined ) {
	
						console.warn( 'THREE.BufferAttribute.copyVector3sArray(): vector is undefined', i );
						vector = new Vector3();
	
					}
	
					array[ offset ++ ] = vector.x;
					array[ offset ++ ] = vector.y;
					array[ offset ++ ] = vector.z;
	
				}
	
				return this;
	
			},
	
			copyVector4sArray: function ( vectors ) {
	
				var array = this.array, offset = 0;
	
				for ( var i = 0, l = vectors.length; i < l; i ++ ) {
	
					var vector = vectors[ i ];
	
					if ( vector === undefined ) {
	
						console.warn( 'THREE.BufferAttribute.copyVector4sArray(): vector is undefined', i );
						vector = new Vector4();
	
					}
	
					array[ offset ++ ] = vector.x;
					array[ offset ++ ] = vector.y;
					array[ offset ++ ] = vector.z;
					array[ offset ++ ] = vector.w;
	
				}
	
				return this;
	
			},
	
			set: function ( value, offset ) {
	
				if ( offset === undefined ) offset = 0;
	
				this.array.set( value, offset );
	
				return this;
	
			},
	
			getX: function ( index ) {
	
				return this.array[ index * this.itemSize ];
	
			},
	
			setX: function ( index, x ) {
	
				this.array[ index * this.itemSize ] = x;
	
				return this;
	
			},
	
			getY: function ( index ) {
	
				return this.array[ index * this.itemSize + 1 ];
	
			},
	
			setY: function ( index, y ) {
	
				this.array[ index * this.itemSize + 1 ] = y;
	
				return this;
	
			},
	
			getZ: function ( index ) {
	
				return this.array[ index * this.itemSize + 2 ];
	
			},
	
			setZ: function ( index, z ) {
	
				this.array[ index * this.itemSize + 2 ] = z;
	
				return this;
	
			},
	
			getW: function ( index ) {
	
				return this.array[ index * this.itemSize + 3 ];
	
			},
	
			setW: function ( index, w ) {
	
				this.array[ index * this.itemSize + 3 ] = w;
	
				return this;
	
			},
	
			setXY: function ( index, x, y ) {
	
				index *= this.itemSize;
	
				this.array[ index + 0 ] = x;
				this.array[ index + 1 ] = y;
	
				return this;
	
			},
	
			setXYZ: function ( index, x, y, z ) {
	
				index *= this.itemSize;
	
				this.array[ index + 0 ] = x;
				this.array[ index + 1 ] = y;
				this.array[ index + 2 ] = z;
	
				return this;
	
			},
	
			setXYZW: function ( index, x, y, z, w ) {
	
				index *= this.itemSize;
	
				this.array[ index + 0 ] = x;
				this.array[ index + 1 ] = y;
				this.array[ index + 2 ] = z;
				this.array[ index + 3 ] = w;
	
				return this;
	
			},
	
			onUpload: function ( callback ) {
	
				this.onUploadCallback = callback;
	
				return this;
	
			},
	
			clone: function () {
	
				return new this.constructor( this.array, this.itemSize ).copy( this );
	
			}
	
		} );
	
		//
	
		function Int8BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Int8Array( array ), itemSize );
	
		}
	
		Int8BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Int8BufferAttribute.prototype.constructor = Int8BufferAttribute;
	
	
		function Uint8BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Uint8Array( array ), itemSize );
	
		}
	
		Uint8BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Uint8BufferAttribute.prototype.constructor = Uint8BufferAttribute;
	
	
		function Uint8ClampedBufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Uint8ClampedArray( array ), itemSize );
	
		}
	
		Uint8ClampedBufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Uint8ClampedBufferAttribute.prototype.constructor = Uint8ClampedBufferAttribute;
	
	
		function Int16BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Int16Array( array ), itemSize );
	
		}
	
		Int16BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Int16BufferAttribute.prototype.constructor = Int16BufferAttribute;
	
	
		function Uint16BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Uint16Array( array ), itemSize );
	
		}
	
		Uint16BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Uint16BufferAttribute.prototype.constructor = Uint16BufferAttribute;
	
	
		function Int32BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Int32Array( array ), itemSize );
	
		}
	
		Int32BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Int32BufferAttribute.prototype.constructor = Int32BufferAttribute;
	
	
		function Uint32BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Uint32Array( array ), itemSize );
	
		}
	
		Uint32BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Uint32BufferAttribute.prototype.constructor = Uint32BufferAttribute;
	
	
		function Float32BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Float32Array( array ), itemSize );
	
		}
	
		Float32BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Float32BufferAttribute.prototype.constructor = Float32BufferAttribute;
	
	
		function Float64BufferAttribute( array, itemSize ) {
	
			BufferAttribute.call( this, new Float64Array( array ), itemSize );
	
		}
	
		Float64BufferAttribute.prototype = Object.create( BufferAttribute.prototype );
		Float64BufferAttribute.prototype.constructor = Float64BufferAttribute;
	
		/**
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function DirectGeometry() {
	
			this.indices = [];
			this.vertices = [];
			this.normals = [];
			this.colors = [];
			this.uvs = [];
			this.uvs2 = [];
	
			this.groups = [];
	
			this.morphTargets = {};
	
			this.skinWeights = [];
			this.skinIndices = [];
	
			// this.lineDistances = [];
	
			this.boundingBox = null;
			this.boundingSphere = null;
	
			// update flags
	
			this.verticesNeedUpdate = false;
			this.normalsNeedUpdate = false;
			this.colorsNeedUpdate = false;
			this.uvsNeedUpdate = false;
			this.groupsNeedUpdate = false;
	
		}
	
		Object.assign( DirectGeometry.prototype, {
	
			computeGroups: function ( geometry ) {
	
				var group;
				var groups = [];
				var materialIndex = undefined;
	
				var faces = geometry.faces;
	
				for ( var i = 0; i < faces.length; i ++ ) {
	
					var face = faces[ i ];
	
					// materials
	
					if ( face.materialIndex !== materialIndex ) {
	
						materialIndex = face.materialIndex;
	
						if ( group !== undefined ) {
	
							group.count = ( i * 3 ) - group.start;
							groups.push( group );
	
						}
	
						group = {
							start: i * 3,
							materialIndex: materialIndex
						};
	
					}
	
				}
	
				if ( group !== undefined ) {
	
					group.count = ( i * 3 ) - group.start;
					groups.push( group );
	
				}
	
				this.groups = groups;
	
			},
	
			fromGeometry: function ( geometry ) {
	
				var faces = geometry.faces;
				var vertices = geometry.vertices;
				var faceVertexUvs = geometry.faceVertexUvs;
	
				var hasFaceVertexUv = faceVertexUvs[ 0 ] && faceVertexUvs[ 0 ].length > 0;
				var hasFaceVertexUv2 = faceVertexUvs[ 1 ] && faceVertexUvs[ 1 ].length > 0;
	
				// morphs
	
				var morphTargets = geometry.morphTargets;
				var morphTargetsLength = morphTargets.length;
	
				var morphTargetsPosition;
	
				if ( morphTargetsLength > 0 ) {
	
					morphTargetsPosition = [];
	
					for ( var i = 0; i < morphTargetsLength; i ++ ) {
	
						morphTargetsPosition[ i ] = [];
	
					}
	
					this.morphTargets.position = morphTargetsPosition;
	
				}
	
				var morphNormals = geometry.morphNormals;
				var morphNormalsLength = morphNormals.length;
	
				var morphTargetsNormal;
	
				if ( morphNormalsLength > 0 ) {
	
					morphTargetsNormal = [];
	
					for ( var i = 0; i < morphNormalsLength; i ++ ) {
	
						morphTargetsNormal[ i ] = [];
	
					}
	
					this.morphTargets.normal = morphTargetsNormal;
	
				}
	
				// skins
	
				var skinIndices = geometry.skinIndices;
				var skinWeights = geometry.skinWeights;
	
				var hasSkinIndices = skinIndices.length === vertices.length;
				var hasSkinWeights = skinWeights.length === vertices.length;
	
				//
	
				for ( var i = 0; i < faces.length; i ++ ) {
	
					var face = faces[ i ];
	
					this.vertices.push( vertices[ face.a ], vertices[ face.b ], vertices[ face.c ] );
	
					var vertexNormals = face.vertexNormals;
	
					if ( vertexNormals.length === 3 ) {
	
						this.normals.push( vertexNormals[ 0 ], vertexNormals[ 1 ], vertexNormals[ 2 ] );
	
					} else {
	
						var normal = face.normal;
	
						this.normals.push( normal, normal, normal );
	
					}
	
					var vertexColors = face.vertexColors;
	
					if ( vertexColors.length === 3 ) {
	
						this.colors.push( vertexColors[ 0 ], vertexColors[ 1 ], vertexColors[ 2 ] );
	
					} else {
	
						var color = face.color;
	
						this.colors.push( color, color, color );
	
					}
	
					if ( hasFaceVertexUv === true ) {
	
						var vertexUvs = faceVertexUvs[ 0 ][ i ];
	
						if ( vertexUvs !== undefined ) {
	
							this.uvs.push( vertexUvs[ 0 ], vertexUvs[ 1 ], vertexUvs[ 2 ] );
	
						} else {
	
							console.warn( 'THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ', i );
	
							this.uvs.push( new Vector2(), new Vector2(), new Vector2() );
	
						}
	
					}
	
					if ( hasFaceVertexUv2 === true ) {
	
						var vertexUvs = faceVertexUvs[ 1 ][ i ];
	
						if ( vertexUvs !== undefined ) {
	
							this.uvs2.push( vertexUvs[ 0 ], vertexUvs[ 1 ], vertexUvs[ 2 ] );
	
						} else {
	
							console.warn( 'THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ', i );
	
							this.uvs2.push( new Vector2(), new Vector2(), new Vector2() );
	
						}
	
					}
	
					// morphs
	
					for ( var j = 0; j < morphTargetsLength; j ++ ) {
	
						var morphTarget = morphTargets[ j ].vertices;
	
						morphTargetsPosition[ j ].push( morphTarget[ face.a ], morphTarget[ face.b ], morphTarget[ face.c ] );
	
					}
	
					for ( var j = 0; j < morphNormalsLength; j ++ ) {
	
						var morphNormal = morphNormals[ j ].vertexNormals[ i ];
	
						morphTargetsNormal[ j ].push( morphNormal.a, morphNormal.b, morphNormal.c );
	
					}
	
					// skins
	
					if ( hasSkinIndices ) {
	
						this.skinIndices.push( skinIndices[ face.a ], skinIndices[ face.b ], skinIndices[ face.c ] );
	
					}
	
					if ( hasSkinWeights ) {
	
						this.skinWeights.push( skinWeights[ face.a ], skinWeights[ face.b ], skinWeights[ face.c ] );
	
					}
	
				}
	
				this.computeGroups( geometry );
	
				this.verticesNeedUpdate = geometry.verticesNeedUpdate;
				this.normalsNeedUpdate = geometry.normalsNeedUpdate;
				this.colorsNeedUpdate = geometry.colorsNeedUpdate;
				this.uvsNeedUpdate = geometry.uvsNeedUpdate;
				this.groupsNeedUpdate = geometry.groupsNeedUpdate;
	
				return this;
	
			}
	
		} );
	
		function arrayMax( array ) {
	
			if ( array.length === 0 ) return - Infinity;
	
			var max = array[ 0 ];
	
			for ( var i = 1, l = array.length; i < l; ++ i ) {
	
				if ( array[ i ] > max ) max = array[ i ];
	
			}
	
			return max;
	
		}
	
		/**
		 * @author alteredq / http://alteredqualia.com/
		 * @author mrdoob / http://mrdoob.com/
		 */
	
		function BufferGeometry() {
	
			Object.defineProperty( this, 'id', { value: GeometryIdCount() } );
	
			this.uuid = _Math.generateUUID();
	
			this.name = '';
			this.type = 'BufferGeometry';
	
			this.index = null;
			this.attributes = {};
	
			this.morphAttributes = {};
	
			this.groups = [];
	
			this.boundingBox = null;
			this.boundingSphere = null;
	
			this.drawRange = { start: 0, count: Infinity };
	
		}
	
		BufferGeometry.MaxIndex = 65535;
	
		Object.assign( BufferGeometry.prototype, EventDispatcher.prototype, {
	
			isBufferGeometry: true,
	
			getIndex: function () {
	
				return this.index;
	
			},
	
			setIndex: function ( index ) {
	
				if ( Array.isArray( index ) ) {
	
					this.index = new ( arrayMax( index ) > 65535 ? Uint32BufferAttribute : Uint16BufferAttribute )( index, 1 );
	
				} else {
	
					this.index = index;
	
				}
	
			},
	
			addAttribute: function ( name, attribute ) {
	
				if ( ! ( attribute && attribute.isBufferAttribute ) && ! ( attribute && attribute.isInterleavedBufferAttribute ) ) {
	
					console.warn( 'THREE.BufferGeometry: .addAttribute() now expects ( name, attribute ).' );
	
					this.addAttribute( name, new BufferAttribute( arguments[ 1 ], arguments[ 2 ] ) );
	
					return;
	
				}
	
				if ( name === 'index' ) {
	
					console.warn( 'THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute.' );
					this.setIndex( attribute );
	
					return;
	
				}
	
				this.attributes[ name ] = attribute;
	
				return this;
	
			},
	
			getAttribute: function ( name ) {
	
				return this.attributes[ name ];
	
			},
	
			removeAttribute: function ( name ) {
	
				delete this.attributes[ name ];
	
				return this;
	
			},
	
			addGroup: function ( start, count, materialIndex ) {
	
				this.groups.push( {
	
					start: start,
					count: count,
					materialIndex: materialIndex !== undefined ? materialIndex : 0
	
				} );
	
			},
	
			clearGroups: function () {
	
				this.groups = [];
	
			},
	
			setDrawRange: function ( start, count ) {
	
				this.drawRange.start = start;
				this.drawRange.count = count;
	
			},
	
			applyMatrix: function ( matrix ) {
	
				var position = this.attributes.position;
	
				if ( position !== undefined ) {
	
					matrix.applyToBufferAttribute( position );
					position.needsUpdate = true;
	
				}
	
				var normal = this.attributes.normal;
	
				if ( normal !== undefined ) {
	
					var normalMatrix = new Matrix3().getNormalMatrix( matrix );
	
					normalMatrix.applyToBufferAttribute( normal );
					normal.needsUpdate = true;
	
				}
	
				if ( this.boundingBox !== null ) {
	
					this.computeBoundingBox();
	
				}
	
				if ( this.boundingSphere !== null ) {
	
					this.computeBoundingSphere();
	
				}
	
				return this;
	
			},
	
			rotateX: function () {
	
				// rotate geometry around world x-axis
	
				var m1 = new Matrix4();
	
				return function rotateX( angle ) {
	
					m1.makeRotationX( angle );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			rotateY: function () {
	
				// rotate geometry around world y-axis
	
				var m1 = new Matrix4();
	
				return function rotateY( angle ) {
	
					m1.makeRotationY( angle );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			rotateZ: function () {
	
				// rotate geometry around world z-axis
	
				var m1 = new Matrix4();
	
				return function rotateZ( angle ) {
	
					m1.makeRotationZ( angle );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			translate: function () {
	
				// translate geometry
	
				var m1 = new Matrix4();
	
				return function translate( x, y, z ) {
	
					m1.makeTranslation( x, y, z );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			scale: function () {
	
				// scale geometry
	
				var m1 = new Matrix4();
	
				return function scale( x, y, z ) {
	
					m1.makeScale( x, y, z );
	
					this.applyMatrix( m1 );
	
					return this;
	
				};
	
			}(),
	
			lookAt: function () {
	
				var obj = new Object3D();
	
				return function lookAt( vector ) {
	
					obj.lookAt( vector );
	
					obj.updateMatrix();
	
					this.applyMatrix( obj.matrix );
	
				};
	
			}(),
	
			center: function () {
	
				this.computeBoundingBox();
	
				var offset = this.boundingBox.getCenter().negate();
	
				this.translate( offset.x, offset.y, offset.z );
	
				return offset;
	
			},
	
			setFromObject: function ( object ) {
	
				// console.log( 'THREE.BufferGeometry.setFromObject(). Converting', object, this );
	
				var geometry = object.geometry;
	
				if ( object.isPoints || object.isLine ) {
	
					var positions = new Float32BufferAttribute( geometry.vertices.length * 3, 3 );
					var colors = new Float32BufferAttribute( geometry.colors.length * 3, 3 );
	
					this.addAttribute( 'position', positions.copyVector3sArray( geometry.vertices ) );
					this.addAttribute( 'color', colors.copyColorsArray( geometry.colors ) );
	
					if ( geometry.lineDistances && geometry.lineDistances.length === geometry.vertices.length ) {
	
						var lineDistances = new Float32BufferAttribute( geometry.lineDistances.length, 1 );
	
						this.addAttribute( 'lineDistance', lineDistances.copyArray( geometry.lineDistances ) );
	
					}
	
					if ( geometry.boundingSphere !== null ) {
	
						this.boundingSphere = geometry.boundingSphere.clone();
	
					}
	
					if ( geometry.boundingBox !== null ) {
	
						this.boundingBox = geometry.boundingBox.clone();
	
					}
	
				} else if ( object.isMesh ) {
	
					if ( geometry && geometry.isGeometry ) {
	
						this.fromGeometry( geometry );
	
					}
	
				}
	
				return this;
	
			},
	
			updateFromObject: function ( object ) {
	
				var geometry = object.geometry;
	
				if ( object.isMesh ) {
	
					var direct = geometry.__directGeometry;
	
					if ( geometry.elementsNeedUpdate === true ) {
	
						direct = undefined;
						geometry.elementsNeedUpdate = false;
	
					}
	
					if ( direct === undefined ) {
	
						return this.fromGeometry( geometry );
	
					}
	
					direct.verticesNeedUpdate = geometry.verticesNeedUpdate;
					direct.normalsNeedUpdate = geometry.normalsNeedUpdate;
					direct.colorsNeedUpdate = geometry.colorsNeedUpdate;
					direct.uvsNeedUpdate = geometry.uvsNeedUpdate;
					direct.groupsNeedUpdate = geometry.groupsNeedUpdate;
	
					geometry.verticesNeedUpdate = false;
					geometry.normalsNeedUpdate = false;
					geometry.colorsNeedUpdate = false;
					geometry.uvsNeedUpdate = false;
					geometry.groupsNeedUpdate = false;
	
					geometry = direct;
	
				}
	
				var attribute;
	
				if ( geometry.verticesNeedUpdate === true ) {
	
					attribute = this.attributes.position;
	
					if ( attribute !== undefined ) {
	
						attribute.copyVector3sArray( geometry.vertices );
						attribute.needsUpdate = true;
	
					}
	
					geometry.verticesNeedUpdate = false;
	
				}
	
				if ( geometry.normalsNeedUpdate === true ) {
	
					attribute = this.attributes.normal;
	
					if ( attribute !== undefined ) {
	
						attribute.copyVector3sArray( geometry.normals );
						attribute.needsUpdate = true;
	
					}
	
					geometry.normalsNeedUpdate = false;
	
				}
	
				if ( geometry.colorsNeedUpdate === true ) {
	
					attribute = this.attributes.color;
	
					if ( attribute !== undefined ) {
	
						attribute.copyColorsArray( geometry.colors );
						attribute.needsUpdate = true;
	
					}
	
					geometry.colorsNeedUpdate = false;
	
				}
	
				if ( geometry.uvsNeedUpdate ) {
	
					attribute = this.attributes.uv;
	
					if ( attribute !== undefined ) {
	
						attribute.copyVector2sArray( geometry.uvs );
						attribute.