'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = first;

var _clip_number = require('./helper/number/clip_number');

var _clip_number2 = _interopRequireDefault(_clip_number);

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _is_nil = require('./helper/object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _const = require('./helper/number/const');

var _to_integer = require('./helper/number/to_integer');

var _to_integer2 = _interopRequireDefault(_to_integer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Extracts the first `length` characters from `subject`.
 *
 * @function first
 * @static
 * @since 1.0.0
 * @memberOf Chop
 * @param  {string} [subject=''] The string to extract from.
 * @param  {int}    [length=1]   The number of characters to extract.
 * @return {string}              Returns the first characters string.
 * @example
 * v.first('helicopter');
 * // => 'h'
 *
 * v.first('vehicle', 2);
 * // => 've'
 *
 * v.first('car', 5);
 * // => 'car'
 */
function first(subject, length) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  var lengthInt = (0, _is_nil2.default)(length) ? 1 : (0, _clip_number2.default)((0, _to_integer2.default)(length), 0, _const.MAX_SAFE_INTEGER);
  if (subjectString.length <= lengthInt) {
    return subjectString;
  }
  return subjectString.substr(0, lengthInt);
}
module.exports = exports['default'];