'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = graphemeAt;

var _coerce_to_number = require('./helper/number/coerce_to_number');

var _coerce_to_number2 = _interopRequireDefault(_coerce_to_number);

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _nan_default = require('./helper/number/nan_default');

var _nan_default2 = _interopRequireDefault(_nan_default);

var _const = require('./helper/reg_exp/const');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Get a grapheme from `subject` at specified `position` taking care of
 * <a href="https://rainsoft.io/what-every-javascript-developer-should-know-about-unicode/#24surrogatepairs">surrogate pairs</a> and
 * <a href="https://rainsoft.io/what-every-javascript-developer-should-know-about-unicode/#25combiningmarks">combining marks</a>.
 *
 * @function graphemeAt
 * @static
 * @since 1.0.0
 * @memberOf Chop
 * @param  {string} [subject=''] The string to extract from.
 * @param  {number} position The position to get the grapheme.
 * @return {string} Returns the grapheme at specified position.
 * @example
 * v.graphemeAt('\uD835\uDC00\uD835\uDC01', 0); // or '𝐀𝐁'
 * // => 'A'
 *
 * v.graphemeAt('cafe\u0301', 3); // or 'café'
 * // => 'é'
 */
function graphemeAt(subject, position) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  var positionNumber = (0, _coerce_to_number2.default)(position);
  var graphemeMatch = void 0;
  var graphemeMatchIndex = 0;
  positionNumber = (0, _nan_default2.default)(positionNumber, 0);
  while ((graphemeMatch = _const.REGEXP_UNICODE_CHARACTER.exec(subjectString)) !== null) {
    if (graphemeMatchIndex === positionNumber) {
      _const.REGEXP_UNICODE_CHARACTER.lastIndex = 0;
      return graphemeMatch[0];
    }
    graphemeMatchIndex++;
  }
  return '';
}
module.exports = exports['default'];