'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alignAndPad;

var _is_nil = require('../object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _const = require('./const');

var _pad_left = require('../../pad_left');

var _pad_left2 = _interopRequireDefault(_pad_left);

var _pad_right = require('../../pad_right');

var _pad_right2 = _interopRequireDefault(_pad_right);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Aligns and pads `subject` string.
 *
 * @ignore
 * @param {string} subject The subject string.
 * @param {ConversionSpecification} conversion The conversion specification object.
 * @return {string} Returns the aligned and padded string.
 */
function alignAndPad(subject, conversion) {
  var width = conversion.width;
  if ((0, _is_nil2.default)(width) || subject.length >= width) {
    return subject;
  }
  var padType = conversion.alignmentSpecifier === _const.LITERAL_MINUS ? _pad_right2.default : _pad_left2.default;
  return padType(subject, width, conversion.getPaddingCharacter());
}
module.exports = exports['default'];