'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = compute;

var _const = require('../const');

var _align_and_pad = require('../align_and_pad');

var _align_and_pad2 = _interopRequireDefault(_align_and_pad);

var _float = require('../type_format/float');

var _float2 = _interopRequireDefault(_float);

var _integer_base = require('../type_format/integer_base');

var _integer_base2 = _interopRequireDefault(_integer_base);

var _integer_decimal = require('../type_format/integer_decimal');

var _integer_decimal2 = _interopRequireDefault(_integer_decimal);

var _string = require('../type_format/string');

var _string2 = _interopRequireDefault(_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Returns the computed string based on format specifiers.
 *
 * @ignore
 * @name computeReplacement
 * @param {string} replacement The replacement value.
 * @param {ConversionSpecification} conversion The conversion specification object.
 * @return {string} Returns the computed string.
 */
function compute(replacement, conversion) {
  var formatFunction = void 0;
  switch (conversion.typeSpecifier) {
    case _const.TYPE_STRING:
      formatFunction = _string2.default;
      break;
    case _const.TYPE_INTEGER_DECIMAL:
    case _const.TYPE_INTEGER:
      formatFunction = _integer_decimal2.default;
      break;
    case _const.TYPE_INTEGER_ASCII_CHARACTER:
    case _const.TYPE_INTEGER_BINARY:
    case _const.TYPE_INTEGER_OCTAL:
    case _const.TYPE_INTEGER_HEXADECIMAL:
    case _const.TYPE_INTEGER_HEXADECIMAL_UPPERCASE:
    case _const.TYPE_INTEGER_UNSIGNED_DECIMAL:
      formatFunction = _integer_base2.default;
      break;
    case _const.TYPE_FLOAT:
    case _const.TYPE_FLOAT_SCIENTIFIC:
    case _const.TYPE_FLOAT_SCIENTIFIC_UPPERCASE:
    case _const.TYPE_FLOAT_SHORT:
    case _const.TYPE_FLOAT_SHORT_UPPERCASE:
      formatFunction = _float2.default;
      break;
  }
  var formattedString = formatFunction(replacement, conversion);
  return (0, _align_and_pad2.default)(formattedString, conversion);
}
module.exports = exports['default'];