'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = addSignToFormattedNumber;

var _const = require('../const');

/**
 * Add sign to the formatted number.
 *
 * @ignore
 * @name addSignToFormattedNumber
 * @param  {number} replacementNumber The number to be replaced.
 * @param  {string} formattedReplacement The formatted version of number.
 * @param  {ConversionSpecification} conversion The conversion specification object.
 * @return {string} Returns the formatted number string with a sign.
 */
function addSignToFormattedNumber(replacementNumber, formattedReplacement, conversion) {
  if (conversion.signSpecifier === _const.LITERAL_PLUS && replacementNumber >= 0) {
    formattedReplacement = _const.LITERAL_PLUS + formattedReplacement;
  }
  return formattedReplacement;
}
module.exports = exports['default'];