'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = integerBase;

var _const = require('../const');

var _coerce_to_string = require('../../string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Formats an integer type according to specifiers.
 *
 * @ignore
 * @param  {string} replacement The string to be formatted.
 * @param  {ConversionSpecification} conversion The conversion specification object.
 * @return {string} Returns the formatted string.
 */

function integerBase(replacement, conversion) {
  var integer = parseInt(replacement);
  if (isNaN(integer)) {
    integer = 0;
  }
  integer = integer >>> 0;
  switch (conversion.typeSpecifier) {
    case _const.TYPE_INTEGER_ASCII_CHARACTER:
      integer = String.fromCharCode(integer);
      break;
    case _const.TYPE_INTEGER_BINARY:
      integer = integer.toString(_const.RADIX_BINARY);
      break;
    case _const.TYPE_INTEGER_OCTAL:
      integer = integer.toString(_const.RADIX_OCTAL);
      break;
    case _const.TYPE_INTEGER_HEXADECIMAL:
      integer = integer.toString(_const.RADIX_HEXADECIMAL);
      break;
    case _const.TYPE_INTEGER_HEXADECIMAL_UPPERCASE:
      integer = integer.toString(_const.RADIX_HEXADECIMAL).toUpperCase();
      break;
  }
  return (0, _coerce_to_string2.default)(integer);
}
module.exports = exports['default'];