'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = integerDecimal;

var _add_sign_to_formatted_number = require('./add_sign_to_formatted_number');

var _add_sign_to_formatted_number2 = _interopRequireDefault(_add_sign_to_formatted_number);

var _to_string = require('../../string/to_string');

var _to_string2 = _interopRequireDefault(_to_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Formats a decimal integer type according to specifiers.
 *
 * @ignore
 * @param  {string} replacement The string to be formatted.
 * @param  {ConversionSpecification} conversion The conversion specification object.
 * @return {string} Returns the formatted string.
 */

function integerDecimal(replacement, conversion) {
  var integer = parseInt(replacement);
  if (isNaN(integer)) {
    integer = 0;
  }
  return (0, _add_sign_to_formatted_number2.default)(integer, (0, _to_string2.default)(integer), conversion);
}
module.exports = exports['default'];