'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = stringFormat;

var _is_nil = require('../../object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _truncate = require('../../../truncate');

var _truncate2 = _interopRequireDefault(_truncate);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Formats a string type according to specifiers.
 *
 * @ignore
 * @param {string} replacement The string to be formatted.
 * @param {ConversionSpecification} conversion The conversion specification object.
 * @return {string} Returns the formatted string.
 */
function stringFormat(replacement, conversion) {
  var formattedReplacement = replacement;
  var precision = conversion.precision;
  if (!(0, _is_nil2.default)(precision) && formattedReplacement.length > precision) {
    formattedReplacement = (0, _truncate2.default)(formattedReplacement, precision, '');
  }
  return formattedReplacement;
}
module.exports = exports['default'];