'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toInteger;

var _const = require('./const');

/**
 * Transforms `value` to an integer.
 *
 * @ignore
 * @function toInteger
 * @param {number} value The number to transform.
 * @returns {number} Returns the transformed integer.
 */
function toInteger(value) {
  if (value === Infinity) {
    return _const.MAX_SAFE_INTEGER;
  }
  if (value === -Infinity) {
    return -_const.MAX_SAFE_INTEGER;
  }
  return ~~value;
}
module.exports = exports['default'];