'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toNumber;

var _is_nil = require('../object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Get the number representation of the `value`.
 * Converts the `value` to a number.
 * If `value` is `null` or `undefined`, return `null`.
 *
 * @ignore
 * @function toNumber
 * @param  {*} value            The value to convert.
 * @return {number|null}        Returns the number representation of `value` or `null` if `value` is `null` or `undefined`.
 */
function toNumber(value) {
  if ((0, _is_nil2.default)(value)) {
    return null;
  }
  return Number(value);
}
module.exports = exports['default'];