'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = appendFlagToRegExp;

var _get_reg_exp_flags = require('./get_reg_exp_flags');

var _get_reg_exp_flags2 = _interopRequireDefault(_get_reg_exp_flags);

var _includes = require('../../includes');

var _includes2 = _interopRequireDefault(_includes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Append flag to a regular expression.
 *
 * @ignore
 * @param {RegExp} pattern The pattern to coerce.
 * @param {string} appendFlag The flag to append to regular expression.
 * @return {RegExp} The regular expression with added flag.
 */
function appendFlagToRegExp(pattern, appendFlag) {
  var regularExpressionFlags = (0, _get_reg_exp_flags2.default)(pattern);
  if (!(0, _includes2.default)(regularExpressionFlags, appendFlag)) {
    return new RegExp(pattern.source, regularExpressionFlags + appendFlag);
  }
  return pattern;
}
module.exports = exports['default'];