'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getRegExpFlags;

var _const = require('./const');

/**
 * Get the flags string from a regular expression object.
 *
 * @ignore
 * @param {RegExp} regExp The regular expression object.
 * @return {string} Returns the string with flags chars.
 */
function getRegExpFlags(regExp) {
  return regExp.toString().match(_const.REGEXP_FLAGS)[0];
}
module.exports = exports['default'];