'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = buildPadding;

var _repeat = require('../../repeat');

var _repeat2 = _interopRequireDefault(_repeat);

var _to_integer = require('../number/to_integer');

var _to_integer2 = _interopRequireDefault(_to_integer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Creates the padding string.
 *
 * @ignore
 * @param {string} padCharacters The characters to create padding string.
 * @param {number} length The padding string length.
 * @return {string} The padding string.
 */
function buildPadding(padCharacters, length) {
  var padStringRepeat = (0, _to_integer2.default)(length / padCharacters.length);
  var padStringRest = length % padCharacters.length;
  return (0, _repeat2.default)(padCharacters, padStringRepeat + padStringRest).substr(0, length);
}
module.exports = exports['default'];