'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toString;

var _is_nil = require('../object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _is_string = require('../../is_string');

var _is_string2 = _interopRequireDefault(_is_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Get the string representation of the `value`.
 * Converts the `value` to string.
 *
 * @ignore
 * @function toString
 * @param {*} value             The value to convert.
 * @return {string|null}        Returns the string representation of `value`.
 */
function toString(value) {
  if ((0, _is_nil2.default)(value)) {
    return null;
  }
  if ((0, _is_string2.default)(value)) {
    return value;
  }
  return String(value);
}
module.exports = exports['default'];