'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parseTagList;

var _const = require('../reg_exp/const');

/**
 * Parses the tags from the string '<tag1><tag2>...<tagN>'.
 *
 * @ignore
 * @param {string} tags The string that contains the tags.
 * @return {string[]} Returns the array of tag names.
 */
function parseTagList(tags) {
  var tagsList = [];
  var match = void 0;
  while ((match = _const.REGEXP_TAG_LIST.exec(tags)) !== null) {
    tagsList.push(match[1]);
  }
  return tagsList;
}
module.exports = exports['default'];