'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isLowerCase;

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _is_alpha = require('./is_alpha');

var _is_alpha2 = _interopRequireDefault(_is_alpha);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Checks whether `subject` has only lower case characters.
 *
 * @function isLowerCase
 * @static
 * @since 1.0.0
 * @memberOf Query
 * @param {string} [subject=''] The string to verify.
 * @return {boolean} Returns `true` if `subject` is lower case or `false` otherwise.
 * @example
 * v.isLowerCase('motorcycle');
 * // => true
 *
 * v.isLowerCase('John');
 * // => false
 *
 * v.isLowerCase('T1000');
 * // => false
 */
function isLowerCase(subject) {
  var valueString = (0, _coerce_to_string2.default)(subject);
  return (0, _is_alpha2.default)(valueString) && valueString.toLowerCase() === valueString;
}
module.exports = exports['default'];