'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isUpperCase;

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _is_alpha = require('./is_alpha');

var _is_alpha2 = _interopRequireDefault(_is_alpha);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Checks whether `subject` contains only upper case characters.
 *
 * @function isUpperCase
 * @static
 * @since 1.0.0
 * @memberOf Query
 * @param {string} [subject=''] The string to verify.
 * @return {boolean} Returns `true` if `subject` is upper case or `false` otherwise.
 * @example
 * v.isUpperCase('ACDC');
 * // => true
 *
 * v.isUpperCase('Morning');
 * // => false
 */
function isUpperCase(subject) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  return (0, _is_alpha2.default)(subjectString) && subjectString.toUpperCase() === subjectString;
}
module.exports = exports['default'];