'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = latinise;

var _const = require('./helper/reg_exp/const');

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _diacritics_map = require('./helper/string/diacritics_map');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Returns the `cleanCharacter` from combining marks regular expression match.
 *
 * @ignore
 * @param {string} character The character with combining marks
 * @param {string} cleanCharacter The character without combining marks.
 * @return {string} The character without combining marks.
 */
function removeCombiningMarks(character, cleanCharacter) {
  return cleanCharacter;
}

/**
 * Latinises the `subject` by removing diacritic characters.
 *
 * @function latinise
 * @static
 * @since 1.0.0
 * @memberOf Manipulate
 * @param {string} [subject=''] The string to latinise.
 * @return {string} Returns the latinised string.
 * @example
 * v.latinise('cafe\u0301'); // or 'café'
 * // => 'cafe'
 *
 * v.latinise('août décembre');
 * // => 'aout decembre'
 *
 * v.latinise('как прекрасен этот мир');
 * // => 'kak prekrasen etot mir'
 */
function latinise(subject) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  if (subjectString === '') {
    return '';
  }
  return subjectString.replace(_const.REGEXP_NON_LATIN, _diacritics_map.getLatinCharacter).replace(_const.REGEXP_COMBINING_MARKS, removeCombiningMarks);
}
module.exports = exports['default'];