'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = pad;

var _build_padding = require('./helper/string/build_padding');

var _build_padding2 = _interopRequireDefault(_build_padding);

var _clip_number = require('./helper/number/clip_number');

var _clip_number2 = _interopRequireDefault(_clip_number);

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _is_nil = require('./helper/object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _const = require('./helper/number/const');

var _to_integer = require('./helper/number/to_integer');

var _to_integer2 = _interopRequireDefault(_to_integer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Pads `subject` to a new `length`.
 *
 * @function pad
 * @static
 * @since 1.0.0
 * @memberOf Manipulate
 * @param {string} [subject=''] The string to pad.
 * @param {int} [length=0] The length to pad the string. No changes are made if `length` is less than `subject.length`.
 * @param {string} [pad=' '] The string to be used for padding.
 * @return {string} Returns the padded string.
 * @example
 * v.pad('dog', 5);
 * // => ' dog '
 *
 * v.pad('bird', 6, '-');
 * // => '-bird-'
 *
 * v.pad('cat', 6, '-=');
 * // => '-cat-='
 */
function pad(subject, length, pad) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  var lengthInt = (0, _is_nil2.default)(length) ? 0 : (0, _clip_number2.default)((0, _to_integer2.default)(length), 0, _const.MAX_SAFE_INTEGER);
  var padString = (0, _coerce_to_string2.default)(pad, ' ');
  if (lengthInt <= subjectString.length) {
    return subjectString;
  }
  var paddingLength = lengthInt - subjectString.length;
  var paddingSideLength = (0, _to_integer2.default)(paddingLength / 2);
  var paddingSideRemainingLength = paddingLength % 2;
  return (0, _build_padding2.default)(padString, paddingSideLength) + subjectString + (0, _build_padding2.default)(padString, paddingSideLength + paddingSideRemainingLength);
}
module.exports = exports['default'];