'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = prune;

var _const_extended = require('./helper/reg_exp/const_extended');

var _clip_number = require('./helper/number/clip_number');

var _clip_number2 = _interopRequireDefault(_clip_number);

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _is_nil = require('./helper/object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _const = require('./helper/number/const');

var _to_integer = require('./helper/number/to_integer');

var _to_integer2 = _interopRequireDefault(_to_integer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Truncates `subject` to a new `length` and does not break the words. Guarantees that the truncated string is no longer
 * than `length`.
 *
 * @static
 * @function prune
 * @since 1.0.0
 * @memberOf Chop
 * @param  {string} [subject=''] The string to prune.
 * @param  {int}    length       The length to prune the string.
 * @param  {string} [end='...']  The string to be added at the end.
 * @return {string}              Returns the pruned string.
 * @example
 * v.prune('Once upon a time', 7);
 * // => 'Once...'
 *
 * v.prune('Good day, Little Red Riding Hood', 16, ' (more)');
 * // => 'Good day (more)'
 *
 * v.prune('Once upon', 10);
 * // => 'Once upon'
 */
function prune(subject, length, end) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  var lengthInt = (0, _is_nil2.default)(length) ? subjectString.length : (0, _clip_number2.default)((0, _to_integer2.default)(length), 0, _const.MAX_SAFE_INTEGER);
  var endString = (0, _coerce_to_string2.default)(end, '...');
  if (lengthInt >= subjectString.length) {
    return subjectString;
  }
  var pattern = _const_extended.REGEXP_EXTENDED_ASCII.test(subjectString) ? _const_extended.REGEXP_LATIN_WORD : _const_extended.REGEXP_WORD;
  var truncatedLength = 0;
  subjectString.replace(pattern, function (word, offset) {
    var wordInsertLength = offset + word.length;
    if (wordInsertLength <= lengthInt - endString.length) {
      truncatedLength = wordInsertLength;
    }
  });
  return subjectString.substr(0, truncatedLength) + endString;
}
module.exports = exports['default'];