'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = replaceAll;

var _append_flag_to_reg_exp = require('./helper/reg_exp/append_flag_to_reg_exp');

var _append_flag_to_reg_exp2 = _interopRequireDefault(_append_flag_to_reg_exp);

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _escape_reg_exp = require('./escape_reg_exp');

var _escape_reg_exp2 = _interopRequireDefault(_escape_reg_exp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Replaces all matches of `pattern` with `replacement`. <br/>
 *
 * @function replaceAll
 * @static
 * @since 1.0.0
 * @memberOf Manipulate
 * @param {string} [subject=''] The string to verify.
 * @param {string|RegExp} pattern The pattern which match is replaced. If `pattern` is a string, a simple string match is evaluated.
 * All matches are replaced.
 * @param {string|Function} replacement The string or function which invocation result replaces `pattern` match.
 * @return {string} Returns the replacement result.
 * @example
 * v.replaceAll('good morning', 'o', '*');
 * // => 'g**d m*rning'
 * v.replaceAll('evening', /n/, 's');
 * // => 'evesisg'
 *
 */
function replaceAll(subject, pattern, replacement) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  var regExp = pattern;
  if (!(pattern instanceof RegExp)) {
    regExp = new RegExp((0, _escape_reg_exp2.default)(pattern), 'g');
  } else if (!pattern.global) {
    regExp = (0, _append_flag_to_reg_exp2.default)(pattern, 'g');
  }
  return subjectString.replace(regExp, replacement);
}
module.exports = exports['default'];