'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = slugify;

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _kebab_case = require('./kebab_case');

var _kebab_case2 = _interopRequireDefault(_kebab_case);

var _latinise = require('./latinise');

var _latinise2 = _interopRequireDefault(_latinise);

var _const = require('./helper/reg_exp/const');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Slugifies the `subject`. Cleans the `subject` by replacing diacritics with corresponding latin characters.
 *
 * @function slugify
 * @static
 * @since 1.0.0
 * @memberOf Manipulate
 * @param {string} [subject=''] The string to slugify.
 * @return {string} Returns the slugified string.
 * @example
 * v.slugify('Italian cappuccino drink');
 * // => 'italian-cappuccino-drink'
 *
 * v.slugify('caffé latté');
 * // => 'caffe-latte'
 *
 * v.slugify('хорошая погода');
 * // => 'horoshaya-pogoda'
 */
function slugify(subject) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  if (subjectString === '') {
    return '';
  }
  var cleanSubjectString = (0, _latinise2.default)(subjectString).replace(_const.REGEXP_NON_LATIN, '-');
  return (0, _kebab_case2.default)(cleanSubjectString);
}
module.exports = exports['default'];