'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = swapCase;

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Converts the uppercase alpha caracters of `subject` to lowercase and lowercase 
 * characters to uppercase.
 *
 * @function swapCase
 * @static
 * @since 1.3.0
 * @memberOf Case
 * @param  {string} [subject=''] The string to swap the case.
 * @return {string}              Returns the converted string.
 * @example
 * v.swapCase('League of Shadows');
 * // => 'lEAGUE OF sHADOWS'
 *
 * v.swapCase('2 Bees');
 * // => '2 bEES'
 */
function swapCase(subject) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  return subjectString.split('').reduce(swapAndConcat, '');
}

function swapAndConcat(swapped, character) {
  var lowerCase = character.toLowerCase();
  var upperCase = character.toUpperCase();
  return swapped + (character === lowerCase ? upperCase : lowerCase);
}
module.exports = exports['default'];