'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = trim;

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _is_nil = require('./helper/object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _to_string = require('./helper/string/to_string');

var _to_string2 = _interopRequireDefault(_to_string);

var _trim_left = require('./trim_left');

var _trim_left2 = _interopRequireDefault(_trim_left);

var _trim_right = require('./trim_right');

var _trim_right2 = _interopRequireDefault(_trim_right);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Removes whitespaces from left and right sides of the `subject`.
 *
 * @function trim
 * @static
 * @since 1.0.0
 * @memberOf Manipulate
 * @param {string} [subject=''] The string to trim.
 * @param {string} [whitespace=whitespace] The whitespace characters to trim. List all characters that you want to be stripped.
 * @return {string} Returns the trimmed string.
 * @example
 * v.trim(' Mother nature ');
 * // => 'Mother nature'
 *
 * v.trim('--Earth--', '-');
 * // => 'Earth'
 */
function trim(subject, whitespace) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  if (whitespace === '' || subjectString === '') {
    return subjectString;
  }
  var whitespaceString = (0, _to_string2.default)(whitespace);
  if ((0, _is_nil2.default)(whitespaceString)) {
    return subjectString.trim();
  }
  return (0, _trim_right2.default)((0, _trim_left2.default)(subjectString, whitespaceString), whitespaceString);
}
module.exports = exports['default'];