'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = trimRight;

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _includes = require('./includes');

var _includes2 = _interopRequireDefault(_includes);

var _is_nil = require('./helper/object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _const = require('./helper/reg_exp/const');

var _to_string = require('./helper/string/to_string');

var _to_string2 = _interopRequireDefault(_to_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var reduceRight = Array.prototype.reduceRight;

/**
 * Removes whitespaces from the right side of the `subject`.
 *
 * @function trimRight
 * @static
 * @since 1.0.0
 * @memberOf Manipulate
 * @param {string} [subject=''] The string to trim.
 * @param {string} [whitespace=whitespace] The whitespace characters to trim. List all characters that you want to be stripped.
 * @return {string} Returns the trimmed string.
 * @example
 * v.trimRight('the fire rises   ');
 * // => 'the fire rises'
 *
 * v.trimRight('do you feel in charge?!!!', '!');
 * // => 'do you feel in charge?'
 */
function trimRight(subject, whitespace) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  if (whitespace === '' || subjectString === '') {
    return subjectString;
  }
  var whitespaceString = (0, _to_string2.default)(whitespace);
  if ((0, _is_nil2.default)(whitespaceString)) {
    return subjectString.replace(_const.REGEXP_TRIM_RIGHT, '');
  }
  var matchWhitespace = true;
  return reduceRight.call(subjectString, function (trimmed, character) {
    if (matchWhitespace && (0, _includes2.default)(whitespaceString, character)) {
      return trimmed;
    }
    matchWhitespace = false;
    return character + trimmed;
  }, '');
}
module.exports = exports['default'];