'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = words;

var _const_extended = require('./helper/reg_exp/const_extended');

var _coerce_to_string = require('./helper/string/coerce_to_string');

var _coerce_to_string2 = _interopRequireDefault(_coerce_to_string);

var _is_nil = require('./helper/object/is_nil');

var _is_nil2 = _interopRequireDefault(_is_nil);

var _nil_default = require('./helper/undefined/nil_default');

var _nil_default2 = _interopRequireDefault(_nil_default);

var _to_string = require('./helper/string/to_string');

var _to_string2 = _interopRequireDefault(_to_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Splits `subject` into an array of words.
 *
 * @function words
 * @static
 * @since 1.0.0
 * @memberOf Split
 * @param {string} [subject=''] The string to split into words.
 * @param {string|RegExp} [pattern] The pattern to watch words. If `pattern` is not RegExp, it is transformed to `new RegExp(pattern, flags)`.
 * @param {string} [flags=''] The regular expression flags. Applies when `pattern` is string type.
 * @return {Array} Returns the array of words.
 * @example
 * v.words('gravity can cross dimensions');
 * // => ['gravity', 'can', 'cross', 'dimensions']
 *
 * v.words('GravityCanCrossDimensions');
 * // => ['Gravity', 'Can', 'Cross', 'Dimensions']
 *
 * v.words('Gravity - can cross dimensions!');
 * // => ['Gravity', 'can', 'cross', 'dimensions']
 *
 * v.words('Earth gravity', /[^\s]+/g);
 * // => ['Earth', 'gravity']
 */
function words(subject, pattern, flags) {
  var subjectString = (0, _coerce_to_string2.default)(subject);
  var patternRegExp = void 0;
  if ((0, _is_nil2.default)(pattern)) {
    patternRegExp = _const_extended.REGEXP_EXTENDED_ASCII.test(subjectString) ? _const_extended.REGEXP_LATIN_WORD : _const_extended.REGEXP_WORD;
  } else if (pattern instanceof RegExp) {
    patternRegExp = pattern;
  } else {
    var flagsString = (0, _to_string2.default)((0, _nil_default2.default)(flags, ''));
    patternRegExp = new RegExp((0, _to_string2.default)(pattern), flagsString);
  }
  return (0, _nil_default2.default)(subjectString.match(patternRegExp), []);
}
module.exports = exports['default'];