import { Proposed } from 'vscode-languageserver-protocol';
import { BaseLanguageClient, LanguageClientOptions, StaticFeature, DynamicFeature } from './client';
export declare abstract class CommonLanguageClient extends BaseLanguageClient {
    constructor(id: string, name: string, clientOptions: LanguageClientOptions);
    registerProposedFeatures(): void;
    protected registerBuiltinFeatures(): void;
}
export declare namespace ProposedFeatures {
    function createAll(client: BaseLanguageClient): (StaticFeature | DynamicFeature<any>)[];
    function createDiagnosticFeature(client: BaseLanguageClient): DynamicFeature<Proposed.DiagnosticOptions>;
    function createTypeHierarchyFeature(client: BaseLanguageClient): DynamicFeature<boolean | Proposed.TypeHierarchyOptions>;
    function createInlineValueFeature(client: BaseLanguageClient): DynamicFeature<boolean | Proposed.InlineValuesOptions>;
    function createNotebookDocumentSyncFeature(client: BaseLanguageClient): DynamicFeature<Proposed.NotebookDocumentSyncRegistrationOptions>;
}
