/// <reference path="../../typings/vscode.proposed.tabs.d.ts" />
/// <reference path="../../typings/vscode.proposed.openEditors.d.ts" />
import { Disposable, CancellationToken, ProviderResult, Diagnostic as VDiagnostic, TextDocument, Event as VEvent, EventEmitter, Uri } from 'vscode';
import { Proposed, ClientCapabilities, ServerCapabilities, DocumentSelector } from 'vscode-languageserver-protocol';
import { TextDocumentFeature, BaseLanguageClient } from './client';
export declare namespace vsdiag {
    enum DocumentDiagnosticReportKind {
        full = "full",
        unChanged = "unChanged"
    }
    interface FullDocumentDiagnosticReport {
        kind: DocumentDiagnosticReportKind.full;
        resultId?: string;
        items: VDiagnostic[];
    }
    interface RelatedFullDocumentDiagnosticReport extends FullDocumentDiagnosticReport {
        relatedDocuments?: {
            [uri: string /** DocumentUri */]: FullDocumentDiagnosticReport | UnchangedDocumentDiagnosticReport;
        };
    }
    interface UnchangedDocumentDiagnosticReport {
        kind: DocumentDiagnosticReportKind.unChanged;
        resultId: string;
    }
    interface RelatedUnchangedDocumentDiagnosticReport extends UnchangedDocumentDiagnosticReport {
        relatedDocuments?: {
            [uri: string /** DocumentUri */]: FullDocumentDiagnosticReport | UnchangedDocumentDiagnosticReport;
        };
    }
    type DocumentDiagnosticReport = RelatedFullDocumentDiagnosticReport | RelatedUnchangedDocumentDiagnosticReport;
    type PreviousResultId = {
        uri: Uri;
        value: string;
    };
    interface WorkspaceFullDocumentDiagnosticReport extends FullDocumentDiagnosticReport {
        uri: Uri;
        version: number | null;
    }
    interface WorkspaceUnchangedDocumentDiagnosticReport extends UnchangedDocumentDiagnosticReport {
        uri: Uri;
        version: number | null;
    }
    type WorkspaceDocumentDiagnosticReport = WorkspaceFullDocumentDiagnosticReport | WorkspaceUnchangedDocumentDiagnosticReport;
    interface WorkspaceDiagnosticReport {
        items: WorkspaceDocumentDiagnosticReport[];
    }
    interface WorkspaceDiagnosticReportPartialResult {
        items: WorkspaceDocumentDiagnosticReport[];
    }
    interface ResultReporter {
        (chunk: WorkspaceDiagnosticReportPartialResult | null): void;
    }
    interface DiagnosticProvider {
        onDidChangeDiagnostics: VEvent<void>;
        provideDiagnostics(textDocument: TextDocument, previousResultId: string | undefined, token: CancellationToken): ProviderResult<DocumentDiagnosticReport>;
        provideWorkspaceDiagnostics?(resultIds: PreviousResultId[], token: CancellationToken, resultReporter: ResultReporter): ProviderResult<WorkspaceDiagnosticReport>;
    }
}
export interface ProvideDiagnosticSignature {
    (this: void, textDocument: TextDocument, previousResultId: string | undefined, token: CancellationToken): ProviderResult<vsdiag.DocumentDiagnosticReport>;
}
export interface ProvideWorkspaceDiagnosticSignature {
    (this: void, resultIds: vsdiag.PreviousResultId[], token: CancellationToken, resultReporter: vsdiag.ResultReporter): ProviderResult<vsdiag.WorkspaceDiagnosticReport>;
}
export interface DiagnosticProviderMiddleware {
    provideDiagnostics?: (this: void, document: TextDocument, previousResultId: string | undefined, token: CancellationToken, next: ProvideDiagnosticSignature) => ProviderResult<vsdiag.DocumentDiagnosticReport>;
    provideWorkspaceDiagnostics?: (this: void, resultIds: vsdiag.PreviousResultId[], token: CancellationToken, resultReporter: vsdiag.ResultReporter, next: ProvideWorkspaceDiagnosticSignature) => ProviderResult<vsdiag.WorkspaceDiagnosticReport>;
}
export interface DiagnosticFeatureProvider {
    onDidChangeDiagnosticsEmitter: EventEmitter<void>;
    diagnostics: vsdiag.DiagnosticProvider;
}
export declare class DiagnosticFeature extends TextDocumentFeature<Proposed.DiagnosticOptions, Proposed.DiagnosticRegistrationOptions, DiagnosticFeatureProvider> {
    private readonly editorTracker;
    constructor(client: BaseLanguageClient);
    fillClientCapabilities(capabilities: ClientCapabilities & Proposed.$DiagnosticClientCapabilities): void;
    initialize(capabilities: ServerCapabilities & Proposed.$DiagnosticServerCapabilities, documentSelector: DocumentSelector): void;
    dispose(): void;
    protected registerLanguageProvider(options: Proposed.DiagnosticRegistrationOptions): [Disposable, DiagnosticFeatureProvider];
}
