/// <reference path="../../typings/vscode.proposed.notebookEditor.d.ts" />
import * as vscode from 'vscode';
import * as proto from 'vscode-languageserver-protocol';
import { NotebookCellTextDocumentFilter } from 'vscode-languageserver-protocol';
import { DynamicFeature, BaseLanguageClient, RegistrationData } from './client';
export interface NotebookDocumentChangeData {
    /**
     * The changed meta data if any.
     */
    metadata?: {
        [key: string]: any;
    };
    /**
     * Changes to the cell structure to add or
     * remove cells.
     */
    cellStructure?: {
        /**
         * The change to the cell array.
         */
        array: {
            start: number;
            deleteCount: number;
            cells?: vscode.NotebookCell[];
        };
        /**
         * Additional opened cell text documents.
         */
        didOpen?: vscode.NotebookCell[];
        /**
         * Additional closed cell text documents.
         */
        didClose?: vscode.NotebookCell[];
    };
    /**
     * Changes to notebook cells properties like its
     * kind or metadata.
     */
    cellData?: vscode.NotebookCell[];
    /**
     * Changes to the text content of notebook cells.
     */
    cellTextContent?: vscode.TextDocumentChangeEvent[];
}
export interface NotebookDocumentMiddleware {
    notebooks?: {
        didOpen?: (this: void, notebookDocument: vscode.NotebookDocument, cells: vscode.NotebookCell[], next: (this: void, notebookDocument: vscode.NotebookDocument, cells: vscode.NotebookCell[]) => Promise<void>) => Promise<void>;
        didSave?: (this: void, notebookDocument: vscode.NotebookDocument, next: (this: void, notebookDocument: vscode.NotebookDocument) => Promise<void>) => Promise<void>;
        didChange?: (this: void, notebookDocument: vscode.NotebookDocument, event: proto.Proposed.NotebookDocumentChangeEvent, next: (this: void, notebookDocument: vscode.NotebookDocument, event: proto.Proposed.NotebookDocumentChangeEvent) => Promise<void>) => Promise<void>;
        didClose?: (this: void, notebookDocument: vscode.NotebookDocument, cells: vscode.NotebookCell[], next: (this: void, notebookDocument: vscode.NotebookDocument, cells: vscode.NotebookCell[]) => Promise<void>) => Promise<void>;
    };
}
export interface NotebookDocumentSyncFeatureShape {
    mode: 'notebook';
    sendOpen(notebookDocument: vscode.NotebookDocument): Promise<void>;
    sendSave(notebookDocument: vscode.NotebookDocument): Promise<void>;
    sendChange(notebookDocument: vscode.NotebookDocument, changeData: NotebookDocumentChangeData): Promise<void>;
    sendClose(notebookDocument: vscode.NotebookDocument): Promise<void>;
}
export declare type $NotebookCellTextDocumentFilter = NotebookCellTextDocumentFilter & {
    sync: true;
};
export interface NotebookCellTextDocumentSyncFeatureShape {
    mode: 'cellContent';
    sendOpen(textDocument: vscode.TextDocument): Promise<void>;
    sendChange(event: vscode.TextDocumentChangeEvent): Promise<void>;
    sendClose(textDocument: vscode.TextDocument): Promise<void>;
}
export interface NotebookDocumentProviderFeature {
    getProvider(notebookCell: vscode.NotebookCell): NotebookCellTextDocumentSyncFeatureShape | NotebookDocumentSyncFeatureShape | undefined;
}
export declare class NotebookDocumentSyncFeature implements DynamicFeature<proto.Proposed.NotebookDocumentSyncRegistrationOptions>, NotebookDocumentProviderFeature {
    static readonly CellScheme: string;
    private readonly client;
    private readonly registrations;
    constructor(client: BaseLanguageClient);
    readonly registrationType: proto.RegistrationType<proto.Proposed.NotebookDocumentSyncRegistrationOptions>;
    fillClientCapabilities(capabilities: proto.ClientCapabilities & proto.Proposed.$NotebookDocumentClientCapabilities): void;
    initialize(capabilities: proto.ServerCapabilities<any> & proto.Proposed.$NotebookDocumentSyncServerCapabilities): void;
    register(data: RegistrationData<proto.Proposed.NotebookDocumentSyncRegistrationOptions>): void;
    unregister(id: string): void;
    dispose(): void;
    getProvider(notebookCell: vscode.NotebookCell): NotebookCellTextDocumentSyncFeatureShape | NotebookDocumentSyncFeatureShape | undefined;
    private getNotebookDocument;
    private getNotebookCellTextDocumentFilter;
}
