import { Disposable, TextDocument, ProviderResult, Position as VPosition, CancellationToken, TypeHierarchyProvider as VTypeHierarchyProvider, TypeHierarchyItem as VTypeHierarchyItem } from 'vscode';
import { ClientCapabilities, DocumentSelector, ServerCapabilities, Proposed } from 'vscode-languageserver-protocol';
import { TextDocumentFeature, BaseLanguageClient } from './client';
export interface PrepareTypeHierarchySignature {
    (this: void, document: TextDocument, position: VPosition, token: CancellationToken): ProviderResult<VTypeHierarchyItem[]>;
}
export interface TypeHierarchySupertypesSignature {
    (this: void, item: VTypeHierarchyItem, token: CancellationToken): ProviderResult<VTypeHierarchyItem[]>;
}
export interface TypeHierarchySubtypesSignature {
    (this: void, item: VTypeHierarchyItem, token: CancellationToken): ProviderResult<VTypeHierarchyItem[]>;
}
/**
 * Type hierarchy middleware
 *
 * @since 3.17.0 - proposed state
 */
export interface TypeHierarchyMiddleware {
    prepareTypeHierarchy?: (this: void, document: TextDocument, positions: VPosition, token: CancellationToken, next: PrepareTypeHierarchySignature) => ProviderResult<VTypeHierarchyItem[]>;
    provideTypeHierarchySupertypes?: (this: void, item: VTypeHierarchyItem, token: CancellationToken, next: TypeHierarchySupertypesSignature) => ProviderResult<VTypeHierarchyItem[]>;
    provideTypeHierarchySubtypes?: (this: void, item: VTypeHierarchyItem, token: CancellationToken, next: TypeHierarchySubtypesSignature) => ProviderResult<VTypeHierarchyItem[]>;
}
declare class TypeHierarchyProvider implements VTypeHierarchyProvider {
    private client;
    private options;
    private middleware;
    constructor(client: BaseLanguageClient, options: Proposed.TypeHierarchyRegistrationOptions);
    prepareTypeHierarchy(document: TextDocument, position: VPosition, token: CancellationToken): ProviderResult<VTypeHierarchyItem[]>;
    provideTypeHierarchySupertypes(item: VTypeHierarchyItem, token: CancellationToken): ProviderResult<VTypeHierarchyItem[]>;
    provideTypeHierarchySubtypes(item: VTypeHierarchyItem, token: CancellationToken): ProviderResult<VTypeHierarchyItem[]>;
}
export declare class TypeHierarchyFeature extends TextDocumentFeature<boolean | Proposed.TypeHierarchyOptions, Proposed.TypeHierarchyRegistrationOptions, TypeHierarchyProvider> {
    constructor(client: BaseLanguageClient);
    fillClientCapabilities(cap: ClientCapabilities): void;
    initialize(capabilities: ServerCapabilities, documentSelector: DocumentSelector): void;
    protected registerLanguageProvider(options: Proposed.TypeHierarchyRegistrationOptions): [Disposable, TypeHierarchyProvider];
}
export {};
