"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
var path = require("path");
var url_1 = require("url");
var downloadPlatform;
switch (process.platform) {
    case 'darwin':
        downloadPlatform = 'darwin';
        break;
    case 'win32':
        downloadPlatform = 'win32-archive';
        break;
    default:
        downloadPlatform = 'linux-x64';
}
function getVSCodeDownloadUrl(version) {
    if (version === 'insiders') {
        return "https://update.code.visualstudio.com/latest/" + downloadPlatform + "/insider";
    }
    return "https://update.code.visualstudio.com/" + version + "/" + downloadPlatform + "/stable";
}
exports.getVSCodeDownloadUrl = getVSCodeDownloadUrl;
var HttpsProxyAgent = require('https-proxy-agent');
var HttpProxyAgent = require('http-proxy-agent');
var PROXY_AGENT = undefined;
var HTTPS_PROXY_AGENT = undefined;
if (process.env.npm_config_proxy) {
    PROXY_AGENT = new HttpProxyAgent(process.env.npm_config_proxy);
    HTTPS_PROXY_AGENT = new HttpsProxyAgent(process.env.npm_config_proxy);
}
if (process.env.npm_config_https_proxy) {
    HTTPS_PROXY_AGENT = new HttpsProxyAgent(process.env.npm_config_https_proxy);
}
function urlToOptions(url) {
    var options = url_1.parse(url);
    if (PROXY_AGENT && options.protocol.startsWith('http:')) {
        options.agent = PROXY_AGENT;
    }
    if (HTTPS_PROXY_AGENT && options.protocol.startsWith('https:')) {
        options.agent = HTTPS_PROXY_AGENT;
    }
    return options;
}
exports.urlToOptions = urlToOptions;
function downloadDirToExecutablePath(dir) {
    if (process.platform === 'win32') {
        return path.resolve(dir, 'Code.exe');
    }
    else if (process.platform === 'darwin') {
        return path.resolve(dir, 'Visual Studio Code.app/Contents/MacOS/Electron');
    }
    else {
        return path.resolve(dir, 'VSCode-linux-x64/code');
    }
}
exports.downloadDirToExecutablePath = downloadDirToExecutablePath;
function insidersDownloadDirToExecutablePath(dir) {
    if (process.platform === 'win32') {
        return path.resolve(dir, 'Code - Insiders.exe');
    }
    else if (process.platform === 'darwin') {
        return path.resolve(dir, 'Visual Studio Code - Insiders.app/Contents/MacOS/Electron');
    }
    else {
        return path.resolve(dir, 'VSCode-linux-x64/code-insiders');
    }
}
exports.insidersDownloadDirToExecutablePath = insidersDownloadDirToExecutablePath;
