(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['module', 'exports'], factory);
  } else if (typeof exports !== "undefined") {
    factory(module, exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod, mod.exports);
    global.AsyncComputed = mod.exports;
  }
})(this, function (module, exports) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  var prefix = '_async_computed$';

  var AsyncComputed = {
    install: function install(Vue, options) {
      options = options || {};

      Vue.config.optionMergeStrategies.asyncComputed = Vue.config.optionMergeStrategies.computed;

      Vue.mixin({
        beforeCreate: function beforeCreate() {
          var _this = this;

          var optionData = this.$options.data;

          if (!this.$options.computed) this.$options.computed = {};

          Object.keys(this.$options.asyncComputed || {}).forEach(function (key) {
            var fn = _this.$options.asyncComputed[key],
                get = typeof fn === 'function' ? fn : fn.get;

            _this.$options.computed[prefix + key] = get;
          });

          this.$options.data = function vueAsyncComputedInjectedDataFn() {
            var data = (typeof optionData === 'function' ? optionData.call(this) : optionData) || {};
            Object.keys(this.$options.asyncComputed || {}).forEach(function (key) {
              data[key] = null;
            });
            return data;
          };
        },
        created: function created() {
          var _this2 = this;

          Object.keys(this.$options.asyncComputed || {}).forEach(function (key) {
            var fn = _this2.$options.asyncComputed[key],
                def = typeof fn.default === 'undefined' ? null : fn.default;

            if (typeof def === 'function') {
              _this2[key] = def.call(_this2);
            } else {
              _this2[key] = def;
            }
          });

          Object.keys(this.$options.asyncComputed || {}).forEach(function (key) {
            var promiseId = 0;
            _this2.$watch(prefix + key, function (newPromise) {
              var thisPromise = ++promiseId;
              newPromise.then(function (value) {
                if (thisPromise !== promiseId) return;
                _this2[key] = value;
              }).catch(function (err) {
                if (thisPromise !== promiseId) return;

                if (options.errorHandler === false) return;

                var handler = options.errorHandler === undefined ? console.error.bind(console, 'Error evaluating async computed property:') : options.errorHandler;

                if (options.useRawError) {
                  handler(err);
                } else {
                  handler(err.stack);
                }
              });
            }, { immediate: true });
          });
        }
      });
    }
  };

  exports.default = AsyncComputed;


  // Auto install in dist mode
  if (typeof window !== 'undefined' && window.Vue) {
    window.Vue.use(AsyncComputed);
  }
  module.exports = exports['default'];
});