# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## [3.5.0](https://github.com/apertureless/vue-chartjs/compare/v3.4.2...v3.5.0) (2019-11-01)


### Bug Fixes

* Fix type script definition for `addPlugin` method ([#564](https://github.com/apertureless/vue-chartjs/issues/564)) ([3065d70](https://github.com/apertureless/vue-chartjs/commit/3065d70))
* Update chart.js peerDependency ([a140f5a](https://github.com/apertureless/vue-chartjs/commit/a140f5a))


### Features

* **typescript:** Improve mixins type definitions ([2a6eb7b](https://github.com/apertureless/vue-chartjs/commit/2a6eb7b))
* **typescript:** Improve mixins type definitions ([#514](https://github.com/apertureless/vue-chartjs/issues/514)) ([520faca](https://github.com/apertureless/vue-chartjs/commit/520faca))
* Add @types/chart.js types in typescript definitions ([#536](https://github.com/apertureless/vue-chartjs/issues/536)) ([22fb8d1](https://github.com/apertureless/vue-chartjs/commit/22fb8d1))
* enhance search on the documentation ([3542b34](https://github.com/apertureless/vue-chartjs/commit/3542b34))

## [3.4.2](https://github.com/apertureless/vue-chartjs/compare/v3.4.1...v3.4.2) (2019-03-18)


### Bug Fixes

* Change peerDependency version of chart.js to include older versions ([8c780d3](https://github.com/apertureless/vue-chartjs/commit/8c780d3))



## [3.4.1](https://github.com/apertureless/vue-chartjs/compare/v3.4.0...v3.4.1) (2019-03-18)


### Bug Fixes

* **reactive-mixins:** Add prop type and default value ([8762521](https://github.com/apertureless/vue-chartjs/commit/8762521))
* Update peerDependencies ([5b19efc](https://github.com/apertureless/vue-chartjs/commit/5b19efc)), closes [#489](https://github.com/apertureless/vue-chartjs/issues/489)



<a name="3.4.0"></a>
# [3.4.0](https://github.com/apertureless/vue-chartjs/compare/v3.3.2...v3.4.0) (2018-08-04)


### Features

* **events:** Add events to reactiveMixins ([#389](https://github.com/apertureless/vue-chartjs/issues/389)) ([67e8e4d](https://github.com/apertureless/vue-chartjs/commit/67e8e4d)), closes [#382](https://github.com/apertureless/vue-chartjs/issues/382)
* **typescript:** Add basic typescript definitions ([184be5c](https://github.com/apertureless/vue-chartjs/commit/184be5c)), closes [#376](https://github.com/apertureless/vue-chartjs/issues/376)
* **ux:** Add a wrapper around generateLegend ([#390](https://github.com/apertureless/vue-chartjs/issues/390)) ([fc646d8](https://github.com/apertureless/vue-chartjs/commit/fc646d8))
* **ux:** Add fake render method with error message ([23ff90d](https://github.com/apertureless/vue-chartjs/commit/23ff90d)), closes [#380](https://github.com/apertureless/vue-chartjs/issues/380)



<a name="3.3.2"></a>
## [3.3.2](https://github.com/apertureless/vue-chartjs/compare/v3.3.1...v3.3.2) (2018-06-18)


### Bug Fixes

* **babel:** fix decorator error with new version of babel ([2fe804b](https://github.com/apertureless/vue-chartjs/commit/2fe804b))
* **core:** Delete old chart.js instance first ([#375](https://github.com/apertureless/vue-chartjs/issues/375)) ([89a7cac](https://github.com/apertureless/vue-chartjs/commit/89a7cac))
* **mixins:** Add condition to check if chart instance is present. ([1fed8e7](https://github.com/apertureless/vue-chartjs/commit/1fed8e7))


### Features

* **privacy:** Remove GA from docs page ([d2d944f](https://github.com/apertureless/vue-chartjs/commit/d2d944f))



<a name="3.3.1"></a>
## [3.3.1](https://github.com/apertureless/vue-chartjs/compare/v3.3.0...v3.3.1) (2018-03-26)


### Bug Fixes

* **release:** Add exports to index ([8341f94](https://github.com/apertureless/vue-chartjs/commit/8341f94))



<a name="3.3.0"></a>
# [3.3.0](https://github.com/apertureless/vue-chartjs/compare/v3.2.1...v3.3.0) (2018-03-23)


### Bug Fixes

* **readme:** Update paypal donate button ([bfda218](https://github.com/apertureless/vue-chartjs/commit/bfda218))


### Features

* **charts:** Export generateChart to create custom charts ([50e5644](https://github.com/apertureless/vue-chartjs/commit/50e5644))
* **docs:** Update docs with custom chart example ([3247a61](https://github.com/apertureless/vue-chartjs/commit/3247a61))



<a name="3.1.0"></a>
# [3.1.0](https://github.com/apertureless/vue-chartjs/compare/v3.0.2...v3.1.0) (2018-01-12)


### Bug Fixes

* **mixins:** Check for chartjs instance before rendering chart ([39ff839](https://github.com/apertureless/vue-chartjs/commit/39ff839)), closes [#288](https://github.com/apertureless/vue-chartjs/issues/288)


### Features

* **charts:** Remove default styling ([ac5d4d8](https://github.com/apertureless/vue-chartjs/commit/ac5d4d8))



# Change Log

## [v3.0.1](https://github.com/apertureless/vue-chartjs/tree/v3.0.1) (2017-11-06)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v3.0.0...v3.0.1)

**Closed issues:**

- \[Suggestion\]Loose package dependencies [\#245](https://github.com/apertureless/vue-chartjs/issues/245)
- reactiveData mixin [\#244](https://github.com/apertureless/vue-chartjs/issues/244)
- Customise individual Axis Labels [\#243](https://github.com/apertureless/vue-chartjs/issues/243)
- presets es2015  [\#242](https://github.com/apertureless/vue-chartjs/issues/242)
- Uncaught TypeError: Cannot read property 'transition' of null [\#241](https://github.com/apertureless/vue-chartjs/issues/241)
- Is it possible to create an callback on the onAnimationComplete option [\#240](https://github.com/apertureless/vue-chartjs/issues/240)
- When resizing window, chart returns to first loaded state [\#239](https://github.com/apertureless/vue-chartjs/issues/239)
- Reactively change chart properties [\#237](https://github.com/apertureless/vue-chartjs/issues/237)
- how to enforce the max value on y axis [\#236](https://github.com/apertureless/vue-chartjs/issues/236)
- Chart is not rendered when maintainAspectRatio is set to false and chart container is hidden [\#235](https://github.com/apertureless/vue-chartjs/issues/235)
- How to access Chart.defaults.global [\#234](https://github.com/apertureless/vue-chartjs/issues/234)
- Blank Chart - no data [\#233](https://github.com/apertureless/vue-chartjs/issues/233)
- Maxin with multiple chartData [\#231](https://github.com/apertureless/vue-chartjs/issues/231)
- How to destroy chart before re-rendering? [\#230](https://github.com/apertureless/vue-chartjs/issues/230)
- chnage gridlines color [\#228](https://github.com/apertureless/vue-chartjs/issues/228)
- Stacked bar chart? [\#226](https://github.com/apertureless/vue-chartjs/issues/226)
- Chart crashes when reentering page [\#223](https://github.com/apertureless/vue-chartjs/issues/223)
- 在图表上左右滑动会出现数据错乱的问题 [\#222](https://github.com/apertureless/vue-chartjs/issues/222)
- How do I set the scale of the Y axis? [\#220](https://github.com/apertureless/vue-chartjs/issues/220)
- Upgrading from 2.8.2 to 2.8.3 breaks charts [\#209](https://github.com/apertureless/vue-chartjs/issues/209)
- How to scale the radius property of each bubble in a vue-chartjs bubble chart [\#205](https://github.com/apertureless/vue-chartjs/issues/205)
- Last release is causing problems with Firefox [\#203](https://github.com/apertureless/vue-chartjs/issues/203)
- 🔥 Remove Vue.extend\(\) [\#201](https://github.com/apertureless/vue-chartjs/issues/201)
- Update to webpack@3 [\#134](https://github.com/apertureless/vue-chartjs/issues/134)

**Merged pull requests:**

- Feature/dependency and build fix [\#246](https://github.com/apertureless/vue-chartjs/pull/246) ([apertureless](https://github.com/apertureless))
- Typo fix in EN docs [\#238](https://github.com/apertureless/vue-chartjs/pull/238) ([chakan](https://github.com/chakan))
- Made some small edits to French README.MD [\#232](https://github.com/apertureless/vue-chartjs/pull/232) ([music-mind](https://github.com/music-mind))
- update webpack to version 3 [\#227](https://github.com/apertureless/vue-chartjs/pull/227) ([kingkong64](https://github.com/kingkong64))

## [v3.0.0](https://github.com/apertureless/vue-chartjs/tree/v3.0.0) (2017-10-14)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.7...v3.0.0)

**Closed issues:**

- Create an image of the chart to download [\#219](https://github.com/apertureless/vue-chartjs/issues/219)
- How to achieve this effect? [\#218](https://github.com/apertureless/vue-chartjs/issues/218)
- Some Error [\#217](https://github.com/apertureless/vue-chartjs/issues/217)
- Avoid mutating a prop directly since the value will be overwritten whenever the parent component re-renders. Instead, use a data or computed property based on the prop's value. Prop being mutated: "chartData" [\#216](https://github.com/apertureless/vue-chartjs/issues/216)
- can't get legendCallback to fire at all [\#212](https://github.com/apertureless/vue-chartjs/issues/212)
- this demo is not support, is it because version older? [\#210](https://github.com/apertureless/vue-chartjs/issues/210)
- how to change value without reload?? [\#208](https://github.com/apertureless/vue-chartjs/issues/208)
- typescript definition? [\#207](https://github.com/apertureless/vue-chartjs/issues/207)
- 使用动态数据时报错 [\#204](https://github.com/apertureless/vue-chartjs/issues/204)
- Commit the final dist js files to github [\#202](https://github.com/apertureless/vue-chartjs/issues/202)
- \[Best Practices❓\] Usage of Private Data [\#182](https://github.com/apertureless/vue-chartjs/issues/182)
- 📝 Update docs & examples - SSR with nuxt [\#172](https://github.com/apertureless/vue-chartjs/issues/172)
- 📝 Update Docs - Section about extending [\#171](https://github.com/apertureless/vue-chartjs/issues/171)
- Register vue-chartjs as vue-plugin? [\#168](https://github.com/apertureless/vue-chartjs/issues/168)
- Avoid mutating a prop directly since the value will be overwritten whenever the parent component re-renders [\#151](https://github.com/apertureless/vue-chartjs/issues/151)

**Merged pull requests:**

- Feature/v3 [\#225](https://github.com/apertureless/vue-chartjs/pull/225) ([apertureless](https://github.com/apertureless))
- ✏️ Spelling in docs [\#215](https://github.com/apertureless/vue-chartjs/pull/215) ([cugu](https://github.com/cugu))
- Fix inaccuracies in Russian translation [\#214](https://github.com/apertureless/vue-chartjs/pull/214) ([pushkyn](https://github.com/pushkyn))
- Add id docs readme support [\#213](https://github.com/apertureless/vue-chartjs/pull/213) ([tesarwijaya](https://github.com/tesarwijaya))
- French translation for README.md [\#211](https://github.com/apertureless/vue-chartjs/pull/211) ([julienc91](https://github.com/julienc91))

## [v2.8.7](https://github.com/apertureless/vue-chartjs/tree/v2.8.7) (2017-09-16)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.6...v2.8.7)

**Closed issues:**

- 真机和浏览器呈现的效果不一样的问题 [\#199](https://github.com/apertureless/vue-chartjs/issues/199)
- can not use npm install? [\#198](https://github.com/apertureless/vue-chartjs/issues/198)
- Reactive Props - Max Call Stack Exceeded Error [\#197](https://github.com/apertureless/vue-chartjs/issues/197)
- Unmet Peer Dependency [\#196](https://github.com/apertureless/vue-chartjs/issues/196)
- Is there a way to update options? [\#195](https://github.com/apertureless/vue-chartjs/issues/195)
- deepmerge [\#194](https://github.com/apertureless/vue-chartjs/issues/194)
- TypeError: Cannot convert undefined or null to object [\#193](https://github.com/apertureless/vue-chartjs/issues/193)

## [v2.8.6](https://github.com/apertureless/vue-chartjs/tree/v2.8.6) (2017-09-12)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.5...v2.8.6)

## [v2.8.5](https://github.com/apertureless/vue-chartjs/tree/v2.8.5) (2017-09-12)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.4...v2.8.5)

**Closed issues:**

- Chart error since the addition of deepmerge in build 2.8.4 [\#192](https://github.com/apertureless/vue-chartjs/issues/192)

## [v2.8.4](https://github.com/apertureless/vue-chartjs/tree/v2.8.4) (2017-09-08)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.3...v2.8.4)

**Closed issues:**

- Regression in 2.8.3 [\#190](https://github.com/apertureless/vue-chartjs/issues/190)
- Why default Chart.js styles are overridden? [\#189](https://github.com/apertureless/vue-chartjs/issues/189)
- Legend or other options not working in reactiveProps [\#188](https://github.com/apertureless/vue-chartjs/issues/188)
- Changes to yAxisID property does not re-render chart [\#177](https://github.com/apertureless/vue-chartjs/issues/177)

**Merged pull requests:**

- Replace Object.assign with deepmerge [\#191](https://github.com/apertureless/vue-chartjs/pull/191) ([apertureless](https://github.com/apertureless))

## [v2.8.3](https://github.com/apertureless/vue-chartjs/tree/v2.8.3) (2017-09-06)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.2...v2.8.3)

**Closed issues:**

- Rounded corner for Bar chart [\#185](https://github.com/apertureless/vue-chartjs/issues/185)
- Access canvas object from parents [\#184](https://github.com/apertureless/vue-chartjs/issues/184)
- Issue with DonutChart in Safari [\#183](https://github.com/apertureless/vue-chartjs/issues/183)
- Responsive Width, Fixed Height [\#180](https://github.com/apertureless/vue-chartjs/issues/180)
- Entire Lodash Library Is Loaded!! 200kb chunk!  [\#179](https://github.com/apertureless/vue-chartjs/issues/179)
- height changed unexpectedly after re-rendering [\#178](https://github.com/apertureless/vue-chartjs/issues/178)
- Default height no longer working in 2.8 [\#176](https://github.com/apertureless/vue-chartjs/issues/176)
- how to get click on point in bar chart? [\#175](https://github.com/apertureless/vue-chartjs/issues/175)
- clean install of from npm cannot be used in gulp / browserify [\#174](https://github.com/apertureless/vue-chartjs/issues/174)
- tooltip callbacks possible? [\#173](https://github.com/apertureless/vue-chartjs/issues/173)
- Computed object won't populate chart [\#170](https://github.com/apertureless/vue-chartjs/issues/170)
- Error in nextTick: "RangeError: Maximum call stack size exceeded" [\#169](https://github.com/apertureless/vue-chartjs/issues/169)
- Standalone chartjs build \(don't include moment.js\) [\#124](https://github.com/apertureless/vue-chartjs/issues/124)

**Merged pull requests:**

- 🔥 Remove default styles object as it causes problems [\#187](https://github.com/apertureless/vue-chartjs/pull/187) ([apertureless](https://github.com/apertureless))
- remvove lodash merge [\#186](https://github.com/apertureless/vue-chartjs/pull/186) ([apertureless](https://github.com/apertureless))

## [v2.8.2](https://github.com/apertureless/vue-chartjs/tree/v2.8.2) (2017-08-12)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.1...v2.8.2)

**Closed issues:**

- UNMET PEER DEPENDENCY [\#167](https://github.com/apertureless/vue-chartjs/issues/167)
- Base Charts' height: 200% [\#164](https://github.com/apertureless/vue-chartjs/issues/164)

**Merged pull requests:**

- Add support for xLabels and yLabels [\#166](https://github.com/apertureless/vue-chartjs/pull/166) ([dsbert](https://github.com/dsbert))
- Update README.md [\#165](https://github.com/apertureless/vue-chartjs/pull/165) ([mikeybeck](https://github.com/mikeybeck))

## [v2.8.1](https://github.com/apertureless/vue-chartjs/tree/v2.8.1) (2017-08-05)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.8.0...v2.8.1)

**Merged pull requests:**

- Add Russian documentation [\#163](https://github.com/apertureless/vue-chartjs/pull/163) ([dood-](https://github.com/dood-))

## [v2.8.0](https://github.com/apertureless/vue-chartjs/tree/v2.8.0) (2017-08-04)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v1.2.0...v2.8.0)

**Closed issues:**

- Update README CDN link [\#161](https://github.com/apertureless/vue-chartjs/issues/161)
- Options being ignored [\#160](https://github.com/apertureless/vue-chartjs/issues/160)
- Fails to dynamically change height. [\#158](https://github.com/apertureless/vue-chartjs/issues/158)
- Chart doesn't load in bootstrap tab [\#157](https://github.com/apertureless/vue-chartjs/issues/157)
- Add scatter chart to vue-chatjs@legacy [\#155](https://github.com/apertureless/vue-chartjs/issues/155)
- \[Error\] Get error when $destroy is started. [\#149](https://github.com/apertureless/vue-chartjs/issues/149)

**Merged pull requests:**

- Feature/dynamic styles [\#162](https://github.com/apertureless/vue-chartjs/pull/162) ([apertureless](https://github.com/apertureless))
- Add Chinese simplified docs support. [\#159](https://github.com/apertureless/vue-chartjs/pull/159) ([Mooooooon](https://github.com/Mooooooon))

## [v1.2.0](https://github.com/apertureless/vue-chartjs/tree/v1.2.0) (2017-07-25)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.7.2...v1.2.0)

**Closed issues:**

- this.$refs doesn't seem to have expected canvas property [\#156](https://github.com/apertureless/vue-chartjs/issues/156)

**Merged pull requests:**

- Before destroy fix [\#152](https://github.com/apertureless/vue-chartjs/pull/152) ([DenisLapi](https://github.com/DenisLapi))

## [v2.7.2](https://github.com/apertureless/vue-chartjs/tree/v2.7.2) (2017-07-22)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.7.1...v2.7.2)

**Closed issues:**

- Accessibility - Add unique titles to frames [\#150](https://github.com/apertureless/vue-chartjs/issues/150)
- update\(\) not refreshing chart [\#148](https://github.com/apertureless/vue-chartjs/issues/148)
- Custome label y axis [\#147](https://github.com/apertureless/vue-chartjs/issues/147)
- Access specific points on the canvas and labels for styling [\#146](https://github.com/apertureless/vue-chartjs/issues/146)
- legendCallback\(\) doesn't render a custom legend [\#144](https://github.com/apertureless/vue-chartjs/issues/144)
- where can i get the demo sources code? thanks [\#143](https://github.com/apertureless/vue-chartjs/issues/143)
- Props not works as expected, updating of value doesn't work [\#138](https://github.com/apertureless/vue-chartjs/issues/138)

**Merged pull requests:**

- ⬆️ Update dependency vue to 2.4.2 [\#154](https://github.com/apertureless/vue-chartjs/pull/154) ([apertureless](https://github.com/apertureless))
- Remove useless labels [\#153](https://github.com/apertureless/vue-chartjs/pull/153) ([clarkdo](https://github.com/clarkdo))
- :pencil2: Remove generateLegend\(\)  from initialization codes [\#145](https://github.com/apertureless/vue-chartjs/pull/145) ([k-rumi](https://github.com/k-rumi))

## [v2.7.1](https://github.com/apertureless/vue-chartjs/tree/v2.7.1) (2017-07-05)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.7.0...v2.7.1)

**Closed issues:**

- Default backgroundColor needed [\#142](https://github.com/apertureless/vue-chartjs/issues/142)

**Merged pull requests:**

- Fix links to images in translated documents [\#141](https://github.com/apertureless/vue-chartjs/pull/141) ([k-rumi](https://github.com/k-rumi))

## [v2.7.0](https://github.com/apertureless/vue-chartjs/tree/v2.7.0) (2017-07-04)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.6.5...v2.7.0)

**Closed issues:**

- Reactive Data Tutorial [\#132](https://github.com/apertureless/vue-chartjs/issues/132)
- Using inline plugins [\#130](https://github.com/apertureless/vue-chartjs/issues/130)
- Scatter Chart [\#129](https://github.com/apertureless/vue-chartjs/issues/129)
- Generating Chart after clicking submit button [\#128](https://github.com/apertureless/vue-chartjs/issues/128)
- Ticks not working with reactive props [\#127](https://github.com/apertureless/vue-chartjs/issues/127)
- Error in callback for watcher "chartData": "TypeError: Cannot read property 'data' of undefined" [\#126](https://github.com/apertureless/vue-chartjs/issues/126)
- Passing the data from vue to chartjs [\#125](https://github.com/apertureless/vue-chartjs/issues/125)
- Combination of Bar and Line Chart  [\#123](https://github.com/apertureless/vue-chartjs/issues/123)
- Reactive data example not working [\#122](https://github.com/apertureless/vue-chartjs/issues/122)
- vue-chartjs height was 0 when i set v-show [\#120](https://github.com/apertureless/vue-chartjs/issues/120)
- Bar chart, barPercentage in X axis [\#119](https://github.com/apertureless/vue-chartjs/issues/119)
- update event not firing on data change [\#118](https://github.com/apertureless/vue-chartjs/issues/118)

**Merged pull requests:**

- ✅ Update tests for addPlugin method [\#140](https://github.com/apertureless/vue-chartjs/pull/140) ([apertureless](https://github.com/apertureless))
- Fix beforeDestory when renderChart was not called [\#139](https://github.com/apertureless/vue-chartjs/pull/139) ([ZhangYiJiang](https://github.com/ZhangYiJiang))
- Add support for inline plugins [\#137](https://github.com/apertureless/vue-chartjs/pull/137) ([kurbar](https://github.com/kurbar))
- Feature/scatter chart [\#136](https://github.com/apertureless/vue-chartjs/pull/136) ([apertureless](https://github.com/apertureless))
- 🐛 Fix \#122 reactive mixin [\#135](https://github.com/apertureless/vue-chartjs/pull/135) ([apertureless](https://github.com/apertureless))
- 📝 Add resources & tutorials to docs [\#133](https://github.com/apertureless/vue-chartjs/pull/133) ([apertureless](https://github.com/apertureless))
- fix a typo in an example [\#131](https://github.com/apertureless/vue-chartjs/pull/131) ([JobV](https://github.com/JobV))
- Update README [\#121](https://github.com/apertureless/vue-chartjs/pull/121) ([stoykostanchev](https://github.com/stoykostanchev))

## [v2.6.5](https://github.com/apertureless/vue-chartjs/tree/v2.6.5) (2017-06-10)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.6.4...v2.6.5)

## [v2.6.4](https://github.com/apertureless/vue-chartjs/tree/v2.6.4) (2017-06-04)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.6.3...v2.6.4)

**Closed issues:**

- Transition leave-active-class not working [\#117](https://github.com/apertureless/vue-chartjs/issues/117)
- chartOptions reactivity [\#116](https://github.com/apertureless/vue-chartjs/issues/116)
- Cannot switch off legend [\#114](https://github.com/apertureless/vue-chartjs/issues/114)
- run error on my mac pro [\#113](https://github.com/apertureless/vue-chartjs/issues/113)
- Update install instructions in docs [\#112](https://github.com/apertureless/vue-chartjs/issues/112)
- Typo in docs [\#111](https://github.com/apertureless/vue-chartjs/issues/111)
- Charts are given a fixed width, even when they are set to be responsive [\#108](https://github.com/apertureless/vue-chartjs/issues/108)
- Use Reactive Data with \<script\> version of vue-chartjs [\#107](https://github.com/apertureless/vue-chartjs/issues/107)

**Merged pull requests:**

- Fix typo in docs [\#115](https://github.com/apertureless/vue-chartjs/pull/115) ([euledge](https://github.com/euledge))
- :memo: Add pt-br readme support [\#110](https://github.com/apertureless/vue-chartjs/pull/110) ([kimuraz](https://github.com/kimuraz))
- Fix reactive mixins animation re-rendering issue. [\#109](https://github.com/apertureless/vue-chartjs/pull/109) ([MuseofMoose](https://github.com/MuseofMoose))

## [v2.6.3](https://github.com/apertureless/vue-chartjs/tree/v2.6.3) (2017-05-14)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.6.2...v2.6.3)

**Closed issues:**

- Reactivity of Options [\#106](https://github.com/apertureless/vue-chartjs/issues/106)
- Do not use built-in or reserved HTML elements as component id: MenuItem [\#104](https://github.com/apertureless/vue-chartjs/issues/104)
- Is it possible to use with axios? [\#103](https://github.com/apertureless/vue-chartjs/issues/103)
- How to change momentjs locale for time scale? [\#101](https://github.com/apertureless/vue-chartjs/issues/101)
- It seems that the reactiveProp couldn't let the chart update itself [\#99](https://github.com/apertureless/vue-chartjs/issues/99)
- vue-chartjs not working with lodash-webpack-plugin installed [\#97](https://github.com/apertureless/vue-chartjs/issues/97)
- multi lines with same options [\#95](https://github.com/apertureless/vue-chartjs/issues/95)
- Zoom And Pan Options in Vue Charts [\#94](https://github.com/apertureless/vue-chartjs/issues/94)

**Merged pull requests:**

- Update README.md [\#105](https://github.com/apertureless/vue-chartjs/pull/105) ([guilherfp](https://github.com/guilherfp))
- translated README.md into Japanese [\#102](https://github.com/apertureless/vue-chartjs/pull/102) ([euledge](https://github.com/euledge))
- add CDNJS version badge in README.md [\#100](https://github.com/apertureless/vue-chartjs/pull/100) ([extend1994](https://github.com/extend1994))

## [v2.6.2](https://github.com/apertureless/vue-chartjs/tree/v2.6.2) (2017-04-29)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.6.1...v2.6.2)

**Merged pull requests:**

- ⬆️ Update dev dependencies [\#96](https://github.com/apertureless/vue-chartjs/pull/96) ([apertureless](https://github.com/apertureless))

## [v2.6.1](https://github.com/apertureless/vue-chartjs/tree/v2.6.1) (2017-04-21)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.6.0...v2.6.1)

**Closed issues:**

- Not understanding options [\#93](https://github.com/apertureless/vue-chartjs/issues/93)
- A Gotcha on component creation. [\#92](https://github.com/apertureless/vue-chartjs/issues/92)
- Error when building: 'This dependency was not found: chartjs' [\#91](https://github.com/apertureless/vue-chartjs/issues/91)
- Chart does not render inside conditional [\#90](https://github.com/apertureless/vue-chartjs/issues/90)
- Unable to add to material-vue layout [\#87](https://github.com/apertureless/vue-chartjs/issues/87)

## [v2.6.0](https://github.com/apertureless/vue-chartjs/tree/v2.6.0) (2017-04-09)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.6.0-rc1...v2.6.0)

**Closed issues:**

- how to export to image or pdf [\#89](https://github.com/apertureless/vue-chartjs/issues/89)
- 🙏🏻 Testing 2.6.0-rc1 [\#88](https://github.com/apertureless/vue-chartjs/issues/88)
- Adding annotation plugin functionality [\#86](https://github.com/apertureless/vue-chartjs/issues/86)

## [v2.6.0-rc1](https://github.com/apertureless/vue-chartjs/tree/v2.6.0-rc1) (2017-04-05)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.5.6...v2.6.0-rc1)

**Closed issues:**

- Overwrite prop [\#85](https://github.com/apertureless/vue-chartjs/issues/85)

**Merged pull requests:**

- Update release build to not include externals. [\#84](https://github.com/apertureless/vue-chartjs/pull/84) ([gcoguiec](https://github.com/gcoguiec))

## [v2.5.6](https://github.com/apertureless/vue-chartjs/tree/v2.5.6) (2017-03-29)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.5.5...v2.5.6)

**Closed issues:**

- Can not render two lines at the same time [\#83](https://github.com/apertureless/vue-chartjs/issues/83)
- Suggestion: Chart not re-rendering on window resize [\#82](https://github.com/apertureless/vue-chartjs/issues/82)
- How can you change legend label colour? [\#81](https://github.com/apertureless/vue-chartjs/issues/81)
- Doughnut with text in the middle [\#80](https://github.com/apertureless/vue-chartjs/issues/80)
- Set chart width without affecting labels [\#79](https://github.com/apertureless/vue-chartjs/issues/79)
- Loading data from server and displaying [\#78](https://github.com/apertureless/vue-chartjs/issues/78)
- Why separate .js files in the examples? [\#77](https://github.com/apertureless/vue-chartjs/issues/77)
- An in-range update of vue is breaking the build 🚨 [\#76](https://github.com/apertureless/vue-chartjs/issues/76)
- An in-range update of vue-template-compiler is breaking the build 🚨 [\#75](https://github.com/apertureless/vue-chartjs/issues/75)
- Uncaught TypeError: Cannot read property 'chartId' of undefined [\#74](https://github.com/apertureless/vue-chartjs/issues/74)
- TypeError: child.\_updateFromParent is not a function [\#72](https://github.com/apertureless/vue-chartjs/issues/72)
- Styling componement's surrounding \<div\> [\#70](https://github.com/apertureless/vue-chartjs/issues/70)

## [v2.5.5](https://github.com/apertureless/vue-chartjs/tree/v2.5.5) (2017-03-24)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.5.4...v2.5.5)

**Closed issues:**

- Access chartjs methods [\#71](https://github.com/apertureless/vue-chartjs/issues/71)
- Pass Reactive data into Scatterplot  [\#69](https://github.com/apertureless/vue-chartjs/issues/69)

**Merged pull requests:**

- Removed -s flag from yarn command in docs [\#73](https://github.com/apertureless/vue-chartjs/pull/73) ([mika76](https://github.com/mika76))

## [v2.5.4](https://github.com/apertureless/vue-chartjs/tree/v2.5.4) (2017-03-19)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.5.3...v2.5.4)

**Closed issues:**

- An in-range update of eslint-config-standard is breaking the build 🚨 [\#68](https://github.com/apertureless/vue-chartjs/issues/68)
- Using data from vuex to populate a line graph [\#67](https://github.com/apertureless/vue-chartjs/issues/67)
- How to use without babel/webpack? [\#66](https://github.com/apertureless/vue-chartjs/issues/66)
- The vue-chartjs/src entry point is still creating a new vue instance. [\#55](https://github.com/apertureless/vue-chartjs/issues/55)

**Merged pull requests:**

- Update dependencies to enable Greenkeeper 🌴 [\#65](https://github.com/apertureless/vue-chartjs/pull/65) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v2.5.3](https://github.com/apertureless/vue-chartjs/tree/v2.5.3) (2017-03-17)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.5.2...v2.5.3)

**Closed issues:**

- Cannot modify styling using options [\#60](https://github.com/apertureless/vue-chartjs/issues/60)

## [v2.5.2](https://github.com/apertureless/vue-chartjs/tree/v2.5.2) (2017-03-14)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.5.1...v2.5.2)

**Closed issues:**

- TypeError: child.\_updateFromParent is not a function [\#62](https://github.com/apertureless/vue-chartjs/issues/62)
- child.\_updateFromParent is not a function [\#59](https://github.com/apertureless/vue-chartjs/issues/59)
- dependency was not found [\#58](https://github.com/apertureless/vue-chartjs/issues/58)

**Merged pull requests:**

- Develop [\#63](https://github.com/apertureless/vue-chartjs/pull/63) ([apertureless](https://github.com/apertureless))
- Fix typo for legacy tag [\#61](https://github.com/apertureless/vue-chartjs/pull/61) ([kylestev](https://github.com/kylestev))

## [v2.5.1](https://github.com/apertureless/vue-chartjs/tree/v2.5.1) (2017-03-11)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.5.0...v2.5.1)

**Closed issues:**

- Lines are looking weird. [\#57](https://github.com/apertureless/vue-chartjs/issues/57)
- Working with objects [\#48](https://github.com/apertureless/vue-chartjs/issues/48)
- Mixins don't seem to trigger a refresh of the chart [\#44](https://github.com/apertureless/vue-chartjs/issues/44)

## [v2.5.0](https://github.com/apertureless/vue-chartjs/tree/v2.5.0) (2017-03-08)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.4.1...v2.5.0)

**Closed issues:**

- UglifyJs is not happy with versions after 2.3.8 [\#54](https://github.com/apertureless/vue-chartjs/issues/54)
- Why "main"  in Package.json is "src/index.js" and not "dist/vue-chartjs.js" [\#53](https://github.com/apertureless/vue-chartjs/issues/53)
- Adding static data and dynamic data at the same time.  [\#52](https://github.com/apertureless/vue-chartjs/issues/52)

**Merged pull requests:**

- separate HorizontalBar component added [\#56](https://github.com/apertureless/vue-chartjs/pull/56) ([imbashamba](https://github.com/imbashamba))

## [v2.4.1](https://github.com/apertureless/vue-chartjs/tree/v2.4.1) (2017-03-04)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.4.0...v2.4.1)

## [v2.4.0](https://github.com/apertureless/vue-chartjs/tree/v2.4.0) (2017-03-03)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.9...v2.4.0)

**Merged pull requests:**

- Added browserify support [\#51](https://github.com/apertureless/vue-chartjs/pull/51) ([craigh411](https://github.com/craigh411))

## [v2.3.9](https://github.com/apertureless/vue-chartjs/tree/v2.3.9) (2017-03-01)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.8...v2.3.9)

**Closed issues:**

- Add src folder to package.json "files" and make main "src/index.js" [\#49](https://github.com/apertureless/vue-chartjs/issues/49)
- Unable to refresh [\#41](https://github.com/apertureless/vue-chartjs/issues/41)

**Merged pull requests:**

- 🐛 Fix \#49 [\#50](https://github.com/apertureless/vue-chartjs/pull/50) ([apertureless](https://github.com/apertureless))

## [v2.3.8](https://github.com/apertureless/vue-chartjs/tree/v2.3.8) (2017-03-01)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.6...v2.3.8)

**Closed issues:**

- Colors of dynamically added bars in bar graph are the default color instead of specified color [\#42](https://github.com/apertureless/vue-chartjs/issues/42)

**Merged pull requests:**

- Feature/documentation [\#47](https://github.com/apertureless/vue-chartjs/pull/47) ([apertureless](https://github.com/apertureless))
- ⬆️ Update dependencies [\#46](https://github.com/apertureless/vue-chartjs/pull/46) ([apertureless](https://github.com/apertureless))
- 📝 Update github issue template [\#45](https://github.com/apertureless/vue-chartjs/pull/45) ([apertureless](https://github.com/apertureless))

## [v2.3.6](https://github.com/apertureless/vue-chartjs/tree/v2.3.6) (2017-02-22)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.5...v2.3.6)

**Closed issues:**

- Please update1.1.3 chartjs to 2.5.0 [\#40](https://github.com/apertureless/vue-chartjs/issues/40)
- Vue-chartjs components creating a second Vue runtime [\#39](https://github.com/apertureless/vue-chartjs/issues/39)
- Since last update bar chart will no longer stack [\#38](https://github.com/apertureless/vue-chartjs/issues/38)
- barchart 如何横向显示条形图 [\#37](https://github.com/apertureless/vue-chartjs/issues/37)
- Animation with reactivity [\#34](https://github.com/apertureless/vue-chartjs/issues/34)

**Merged pull requests:**

- 🐛 Fix reactiveMixins issue \#42 [\#43](https://github.com/apertureless/vue-chartjs/pull/43) ([apertureless](https://github.com/apertureless))

## [v2.3.5](https://github.com/apertureless/vue-chartjs/tree/v2.3.5) (2017-02-14)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.4...v2.3.5)

**Closed issues:**

- Destory chart instance in reactiveMixins on render [\#35](https://github.com/apertureless/vue-chartjs/issues/35)
- Rerendering doughtnut chart not working [\#33](https://github.com/apertureless/vue-chartjs/issues/33)

**Merged pull requests:**

- 🔨 Change reactiveMixins to fix \#35 [\#36](https://github.com/apertureless/vue-chartjs/pull/36) ([apertureless](https://github.com/apertureless))

## [v2.3.4](https://github.com/apertureless/vue-chartjs/tree/v2.3.4) (2017-02-11)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.3...v2.3.4)

**Closed issues:**

- Update Chart.js docs to include link to vue-chartjs [\#32](https://github.com/apertureless/vue-chartjs/issues/32)
- Compatibility with Vue 2.1.10 [\#30](https://github.com/apertureless/vue-chartjs/issues/30)

## [v2.3.3](https://github.com/apertureless/vue-chartjs/tree/v2.3.3) (2017-01-19)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.2...v2.3.3)

**Closed issues:**

- How to create mixed chart types [\#29](https://github.com/apertureless/vue-chartjs/issues/29)
- hello a q about reactivity [\#28](https://github.com/apertureless/vue-chartjs/issues/28)
- chart do not render after build  [\#26](https://github.com/apertureless/vue-chartjs/issues/26)

**Merged pull requests:**

- 🐛 Fix \#30 type error [\#31](https://github.com/apertureless/vue-chartjs/pull/31) ([apertureless](https://github.com/apertureless))

## [v2.3.2](https://github.com/apertureless/vue-chartjs/tree/v2.3.2) (2016-12-23)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.1...v2.3.2)

**Closed issues:**

- Content Security Policy [\#22](https://github.com/apertureless/vue-chartjs/issues/22)

**Merged pull requests:**

- ✨ Add minimal release webpack config [\#27](https://github.com/apertureless/vue-chartjs/pull/27) ([apertureless](https://github.com/apertureless))
- 📝 Update README [\#25](https://github.com/apertureless/vue-chartjs/pull/25) ([apertureless](https://github.com/apertureless))

## [v2.3.1](https://github.com/apertureless/vue-chartjs/tree/v2.3.1) (2016-12-20)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.3.0...v2.3.1)

**Closed issues:**

- Error in rendering [\#21](https://github.com/apertureless/vue-chartjs/issues/21)
- Issues after using gulp-- production [\#19](https://github.com/apertureless/vue-chartjs/issues/19)

**Merged pull requests:**

- ✅ Add tests for chart instance destroying [\#24](https://github.com/apertureless/vue-chartjs/pull/24) ([apertureless](https://github.com/apertureless))
- Feature/runtimebuild \#22 [\#23](https://github.com/apertureless/vue-chartjs/pull/23) ([apertureless](https://github.com/apertureless))

## [v2.3.0](https://github.com/apertureless/vue-chartjs/tree/v2.3.0) (2016-12-17)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.2.1...v2.3.0)

**Closed issues:**

- Uncaught TypeError: \_c is not a function  [\#20](https://github.com/apertureless/vue-chartjs/issues/20)

## [v2.2.1](https://github.com/apertureless/vue-chartjs/tree/v2.2.1) (2016-12-07)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.2.0...v2.2.1)

**Closed issues:**

- Chart height definition inside the component [\#18](https://github.com/apertureless/vue-chartjs/issues/18)
- Uncaught TypeError: Cannot read property 'draw' of null [\#15](https://github.com/apertureless/vue-chartjs/issues/15)

**Merged pull requests:**

- Update README.md [\#16](https://github.com/apertureless/vue-chartjs/pull/16) ([Ag47](https://github.com/Ag47))

## [v2.2.0](https://github.com/apertureless/vue-chartjs/tree/v2.2.0) (2016-10-24)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v2.1.1...v2.2.0)

**Closed issues:**

- The page is blank？ [\#13](https://github.com/apertureless/vue-chartjs/issues/13)
- question:syntax with vue-loader [\#12](https://github.com/apertureless/vue-chartjs/issues/12)
- Rerender when data has changed [\#10](https://github.com/apertureless/vue-chartjs/issues/10)

**Merged pull requests:**

- add horizontal bar parameter [\#14](https://github.com/apertureless/vue-chartjs/pull/14) ([wahaha2012](https://github.com/wahaha2012))
- WIP Feature/reactive chart data \#11 [\#11](https://github.com/apertureless/vue-chartjs/pull/11) ([apertureless](https://github.com/apertureless))

## [v2.1.1](https://github.com/apertureless/vue-chartjs/tree/v2.1.1) (2016-10-02)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v.2.1.0...v2.1.1)

## [v.2.1.0](https://github.com/apertureless/vue-chartjs/tree/v.2.1.0) (2016-09-23)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/v1.1.3...v.2.1.0)

## [v1.1.3](https://github.com/apertureless/vue-chartjs/tree/v1.1.3) (2016-09-08)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/1.1.2...v1.1.3)

**Closed issues:**

- Passing chart size \(width / height\) as prop doesnt resize the chart [\#8](https://github.com/apertureless/vue-chartjs/issues/8)
- Add test [\#1](https://github.com/apertureless/vue-chartjs/issues/1)

**Merged pull requests:**

- Added bubble chart type [\#9](https://github.com/apertureless/vue-chartjs/pull/9) ([jcalonso](https://github.com/jcalonso))

## [1.1.2](https://github.com/apertureless/vue-chartjs/tree/1.1.2) (2016-09-07)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/1.1.1...1.1.2)

**Closed issues:**

- Change name of the render method to ensure compatiblity with Vue 2.0 [\#4](https://github.com/apertureless/vue-chartjs/issues/4)

## [1.1.1](https://github.com/apertureless/vue-chartjs/tree/1.1.1) (2016-08-23)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/1.1.0...1.1.1)

## [1.1.0](https://github.com/apertureless/vue-chartjs/tree/1.1.0) (2016-08-21)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/1.0.3...1.1.0)

**Closed issues:**

- Use Vue.util.mergeOptions to merge default options with user's options [\#5](https://github.com/apertureless/vue-chartjs/issues/5)

**Merged pull requests:**

- Feature/merge options \#5 [\#6](https://github.com/apertureless/vue-chartjs/pull/6) ([apertureless](https://github.com/apertureless))

## [1.0.3](https://github.com/apertureless/vue-chartjs/tree/1.0.3) (2016-08-20)
[Full Changelog](https://github.com/apertureless/vue-chartjs/compare/1.0.2...1.0.3)

**Closed issues:**

- Publish on NPM [\#2](https://github.com/apertureless/vue-chartjs/issues/2)

**Merged pull requests:**

- Properly destroy chartjs objects [\#3](https://github.com/apertureless/vue-chartjs/pull/3) ([LinusBorg](https://github.com/LinusBorg))

## [1.0.2](https://github.com/apertureless/vue-chartjs/tree/1.0.2) (2016-07-27)


\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*