# vue-ckeditor

> Ckeditor using for Vue.js 2

![](https://raw.githubusercontent.com/dangvanthanh/vue-ckeditor2/master/screenshot.png)

## Requirements

- [Ckeditor](http://ckeditor.com/) >= 4
- [Vue.js](http://vuejs.org/) >= 2

## Install

### CDN

```html
<script src="https://unpkg.com/vue-ckeditor2"></script>
```
### NPM
```
$ npm install vue-ckeditor2 --save
```

## Usage

> This document applies to v2.0+. If you are looking for older versions, docs are [here](https://github.com/dangvanthanh/vue-ckeditor2/wiki/Getting-Started)

```javascript
import Vue from 'vue';
import VueCkeditor from 'vue-ckeditor2';

Vue.use(VueCkeditor);
```

Then in your component: 

```vue
<template>
  <div>
    <vue-ckeditor v-model="content" :config="config" @blur="onBlur($event)" @focus="onFocus($event)" />
  </div>
</template>

<script>
export default {
  data () {
    return {
      content: '',
      config: {
        toolbar: [
          [ 'Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript' ]
        ],
        height: 300
      }
    }
  },
  methods: {
    onBlur (editor) {
      console.log(editor)
    },
    onFocus (editor) {
      console.log(editor)
    }
  }
}
</script>
```

### Props

| Name           | Type     | Description                              |
| -------------- | -------- | ---------------------------------------- |
| `name`         | `String` | Name of instance ckedior. **Default: editor-1** |
| `id`           | `String` | Id of instance ckedior. **Default: editor-1** |
| `types`        | `String` | Types of ckedior. **Default: classic** |
| `config`       | `Object` | All configuration of ckeditor. **Default: {}** |

## Build Setup

You can use [vue-cli](https://github.com/vuejs/vue-cli) with [vue-rollup-boilerplate templates](https://github.com/dangvanthanh/vue-rollup-boilerplate) or [other vue templates](https://github.com/vuejs-templates)

## Created By

- [Dang Van Thanh](https://github.com/dangvanthanh)

Thanks to:

- [Eduárd Moldován](https://github.com/edimoldovan)
- [Dominique FERET](https://github.com/DominiqueFERET)
- [comfuture](https://github.com/comfuture)
- [旺旺](https://github.com/chengpan168)
- [Tony Yip](https://github.com/tonyhhyip)
- [Nedyalko Dyakov](https://github.com/ndyakov)
- [Bryan Miller](https://github.com/bryanjamesmiller)
- [Jeff Omiecinski](https://github.com/omiecinski)
- [rlfscin](https://github.com/rlfscin)
- [Renato Souza](https://github.com/renatosistemasvc)

## License

MIT © [Dang Van Thanh](http://dangthanh.org)
