import { defineComponent, useSlots, ref, onMounted, watchEffect, openBlock, createBlock, h } from "vue";
var vueClientRecaptcha_vue_vue_type_style_index_0_lang = "";
const _sfc_main = /* @__PURE__ */ defineComponent({
  props: {
    value: { default: "" },
    numbers: { default: () => ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"] },
    capitalCaseLetters: { default: () => [
      "A",
      "B",
      "C",
      "D",
      "E",
      "F",
      "G",
      "H",
      "I",
      "J",
      "K",
      "L",
      "M",
      "N",
      "O",
      "P",
      "Q",
      "R",
      "S",
      "T",
      "U",
      "V",
      "W",
      "X",
      "Y",
      "Z"
    ] },
    lowerCaseLetters: { default: () => [
      "a",
      "b",
      "c",
      "d",
      "e",
      "f",
      "g",
      "h",
      "i",
      "j",
      "k",
      "l",
      "m",
      "n",
      "o",
      "p",
      "q",
      "r",
      "s",
      "t",
      "u",
      "v",
      "w",
      "x",
      "y",
      "z"
    ] },
    showNumbers: { type: Boolean, default: true },
    showCapitalCaseLetters: { type: Boolean, default: true },
    showLowerCaseLetters: { type: Boolean, default: true },
    count: { default: 5 },
    hideLines: { type: Boolean, default: false },
    customTextColor: { default: "" },
    isDirty: { type: Boolean, default: true },
    width: { default: function(props) {
      return props.count * 30;
    } },
    height: { default: 50 },
    canvasClass: { default: "" },
    icon: { default: "refresh" }
  },
  emits: ["isValid", "getCode"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    console.log(slots.header);
    const captcha_canvas = ref();
    let code = ref("");
    let canvasWidth = props.width;
    let canvasHeight = props.height;
    const letters = ref([
      ...props.showNumbers ? props.numbers : [],
      ...props.showCapitalCaseLetters ? props.capitalCaseLetters : [],
      ...props.showLowerCaseLetters ? props.lowerCaseLetters : []
    ]);
    onMounted(() => {
      captcha();
    });
    const captcha = () => {
      captcha_canvas.value.width = canvasWidth;
      captcha_canvas.value.height = canvasHeight;
      let ctx = captcha_canvas.value.getContext("2d");
      for (let i = 0; i < props.count; i++) {
        let sIndex = Math.floor(Math.random() * letters.value.length);
        let sDeg = Math.random() * 30 * Math.PI / 180;
        let cTxt = letters.value[sIndex];
        code.value += cTxt;
        letters[i] = cTxt.toLowerCase();
        let x = 10 + i * 25;
        let y = 30 + Math.random() * 8;
        ctx.font = "bold 28px \u5FAE\u8F6F\u96C5\u9ED1";
        ctx.translate(x, y);
        if (props.customTextColor) {
          ctx.fillStyle = props.customTextColor;
        } else {
          ctx.fillStyle = randomColor();
        }
        ctx.rotate(sDeg);
        ctx.fillText(cTxt, 0, 0);
        ctx.rotate(-sDeg);
        ctx.translate(-x, -y);
      }
      if (!props.hideLines) {
        createLines();
      }
      sendValueToParent();
    };
    const createLines = () => {
      let ctx = captcha_canvas.value.getContext("2d");
      for (let i = 0; i < props.count; i++) {
        ctx.strokeStyle = randomColor();
        ctx.beginPath();
        ctx.moveTo(Math.random() * canvasWidth, Math.random() * canvasHeight);
        ctx.lineTo(Math.random() * canvasWidth, Math.random() * canvasHeight);
        ctx.stroke();
      }
    };
    const sendValueToParent = () => {
      emit("getCode", code.value);
    };
    watchEffect(() => {
      if (code.value && code.value === props.value) {
        emit("isValid", true);
      } else {
        emit("isValid", false);
      }
    });
    const randomColor = () => {
      let r = Math.floor(Math.random() * 256);
      let g = Math.floor(Math.random() * 256);
      let b = Math.floor(Math.random() * 256);
      return "rgb(" + r + "," + g + "," + b + ")";
    };
    const resetCaptcha = () => {
      let ctx = captcha_canvas.value.getContext("2d");
      ctx.clearRect(0, 0, canvasWidth, canvasHeight);
      code.value = "";
      captcha();
    };
    const render = () => {
      return h("div", { class: "vue_client_recaptcha" }, [
        h("div", { class: "vue_client_recaptcha_icon", onClick: () => resetCaptcha() }, [
          h(slots.icon ? slots.icon : "img", {
            src: "https://www.freeiconspng.com/uploads/black-refresh-icon-png-9.png",
            style: "width:60px"
          })
        ]),
        h("canvas", {
          id: "captcha_canvas",
          class: `captcha_canvas ${props.canvasClass}`,
          ref: captcha_canvas
        }, code.value)
      ]);
    };
    return (_ctx, _cache) => {
      return openBlock(), createBlock(render);
    };
  }
});
export { _sfc_main as default };
