<p align="center">
    <a href="https://vue-data-ui.graphieros.com/"><img src="https://vue-data-ui.graphieros.com/vue-data-ui2.png"></a>
    <br>
    <br>
    <br>
    <a href="https://vue-data-ui.graphieros.com/"><img src="https://vue-data-ui.graphieros.com/vue-data-ui-showcase.png"></a>
</p>

# vue-data-ui

[![npm](https://img.shields.io/npm/v/vue-data-ui)](https://github.com/graphieros/vue-data-ui)
[![Static Badge](https://img.shields.io/badge/components-58-blue)](https://github.com/graphieros/vue-data-ui)
[![GitHub issues](https://img.shields.io/github/issues/graphieros/vue-data-ui)](https://github.com/graphieros/vue-data-ui/issues)
[![License](https://img.shields.io/badge/license-MIT-green)](https://github.com/graphieros/vue-data-ui?tab=MIT-1-ov-file#readme)
[![MadeWithVueJs.com shield](https://madewithvuejs.com/storage/repo-shields/4526-shield.svg)](https://madewithvuejs.com/p/vue-data-ui/shield-link)
[![npm](https://img.shields.io/npm/dt/vue-data-ui)](https://github.com/graphieros/vue-data-ui)

[Interactive documentation](https://vue-data-ui.graphieros.com/)

A user-empowering data visualization Vue components library for eloquent data storytelling.

Available components

## Charts

- [VueUiAgePyramid](https://vue-data-ui.graphieros.com/docs#vue-ui-age-pyramid)
- [VueUiCandlestick](https://vue-data-ui.graphieros.com/docs#vue-ui-candlestick)
- [VueUiChestnut](https://vue-data-ui.graphieros.com/docs#vue-ui-chestnut)
- [VueUiDonutEvolution](https://vue-data-ui.graphieros.com/docs#vue-ui-donut-evolution)
- [VueUiDonut](https://vue-data-ui.graphieros.com/docs#vue-ui-donut)
- [VueUiDumbbell](https://vue-data-ui.graphieros.com/docs#vue-ui-dumbbell)
- [VueUiFlow](https://vue-data-ui.graphieros.com/docs#vue-ui-flow)
- [VueUiGalaxy](https://vue-data-ui.graphieros.com/docs#vue-ui-galaxy)
- [VueUiGauge](https://vue-data-ui.graphieros.com/docs#vue-ui-gauge)
- [VueUiHeatmap](https://vue-data-ui.graphieros.com/docs#vue-ui-heatmap)
- [VueUiMolecule](https://vue-data-ui.graphieros.com/docs#vue-ui-molecule)
- [VueUiMoodRadar](https://vue-data-ui.graphieros.com/docs#vue-ui-mood-radar)
- [VueUiNestedDonuts](https://vue-data-ui.graphieros.com/docs#vue-ui-nested-donuts)
- [VueUiOnion](https://vue-data-ui.graphieros.com/docs#vue-ui-onion)
- [VueUiParallelCoordinatePlot](https://vue-data-ui.graphieros.com/docs#vue-ui-parallel-coordinate-plot)
- [VueUiQuadrant](https://vue-data-ui.graphieros.com/docs#vue-ui-quadrant)
- [VueUiQuickChart](https://vue-data-ui.graphieros.com/docs#vue-ui-quick-chart)
- [VueUiRadar](https://vue-data-ui.graphieros.com/docs#vue-ui-radar)
- [VueUiRelationCircle](https://vue-data-ui.graphieros.com/docs#vue-ui-relation-circle)
- [VueUiRings](https://vue-data-ui.graphieros.com/docs#vue-ui-rings)
- [VueUiScatter](https://vue-data-ui.graphieros.com/docs#vue-ui-scatter)
- [VueUiStackbar](https://vue-data-ui.graphieros.com/docs#vue-ui-stackbar)
- [VueUiStripPlot](https://vue-data-ui.graphieros.com/docs#vue-ui-strip-plot)
- [VueUiThermometer](https://vue-data-ui.graphieros.com/docs#vue-ui-thermometer)
- [VueUiTiremarks](https://vue-data-ui.graphieros.com/docs#vue-ui-tiremarks)
- [VueUiTreemap](https://vue-data-ui.graphieros.com/docs#vue-ui-treemap)
- [VueUiVerticalBar](https://vue-data-ui.graphieros.com/docs#vue-ui-vertical-bar)
- [VueUiWaffle](https://vue-data-ui.graphieros.com/docs#vue-ui-waffle)
- [VueUiWheel](https://vue-data-ui.graphieros.com/docs#vue-ui-wheel)
- [VueUiWordCloud](https://vue-data-ui.graphieros.com/docs#vue-ui-word-cloud)
- [VueUiXyCanvas](https://vue-data-ui.graphieros.com/docs#vue-ui-xy-canvas)
- [VueUiXy](https://vue-data-ui.graphieros.com/docs#vue-ui-xy)

## Mini charts

- [VueUiSparkHistogram](https://vue-data-ui.graphieros.com/docs#vue-ui-sparkhistogram)
- [VueUiSparkbar](https://vue-data-ui.graphieros.com/docs#vue-ui-sparkbar)
- [VueUiSparkgauge](https://vue-data-ui.graphieros.com/docs#vue-ui-sparkgauge)
- [VueUiSparkline](https://vue-data-ui.graphieros.com/docs#vue-ui-sparkline)
- [VueUiSparkStackbar](https://vue-data-ui.graphieros.com/docs#vue-ui-sparkstackbar)
- [VueUiSparkTrend](https://vue-data-ui.graphieros.com/docs#vue-ui-spark-trend)
- [VueUiGizmo](https://vue-data-ui.graphieros.com/docs#vue-ui-gizmo)
- [VueUiBullet](https://vue-data-ui.graphieros.com/docs#vue-ui-bullet)

## 3d

- [VueUi3dBar](https://vue-data-ui.graphieros.com/docs#vue-ui-3d-bar)

## Tables

- [VueUiTableHeatmap](https://vue-data-ui.graphieros.com/docs#vue-ui-table-heatmap)
- [VueUiTableSparkline](https://vue-data-ui.graphieros.com/docs#vue-ui-table-sparkline)
- [VueUiTable](https://vue-data-ui.graphieros.com/docs#vue-ui-table)
- [VueUiCarouselTable](https://vue-data-ui.graphieros.com/docs#vue-ui-carousel-table)

## Rating

- [VueUiRating](https://vue-data-ui.graphieros.com/docs#vue-ui-rating)
- [VueUiSmiley](https://vue-data-ui.graphieros.com/docs#vue-ui-smiley)

## Utilities

- [VueUiAccordion](https://vue-data-ui.graphieros.com/docs#vue-ui-accordion)
- [VueUiAnnotator](https://vue-data-ui.graphieros.com/docs#vue-ui-annotator)
- [VueUiCursor](https://vue-data-ui.graphieros.com/docs#vue-ui-cursor)
- [VueUiDashboard](https://vue-data-ui.graphieros.com/docs#vue-ui-dashboard)
- [VueUiDigits](https://vue-data-ui.graphieros.com/docs#vue-ui-digits)
- [VueUiIcon](https://vue-data-ui.graphieros.com/docs#vue-ui-icon)
- [VueUiKpi](https://vue-data-ui.graphieros.com/docs#vue-ui-kpi)
- [VueUiMiniLoader](https://vue-data-ui.graphieros.com/docs#vue-ui-mini-loader)
- [VueUiScreenshot](https://vue-data-ui.graphieros.com/docs#vue-ui-screenshot)
- [VueUiSkeleton](https://vue-data-ui.graphieros.com/docs#vue-ui-skeleton)
- [VueUiTimer](https://vue-data-ui.graphieros.com/docs#vue-ui-timer)

# Installation

```
npm i vue-data-ui
```

You can declare components globally in your main.js:

```js
import { createApp } from "vue";
import App from "./App.vue";
// Include the css;
import "vue-data-ui/style.css";

// You can declare Vue Data UI components globally
import { VueUiRadar } from "vue-data-ui";

const app = createApp(App);

app.component("VueUiRadar", VueUiRadar);
app.mount("#app");
```

Or you can import just what you need in your files:

```js
<script setup>import {(VueUiRadar, VueUiXy)} from "vue-data-ui";</script>
```

Since v.2.0.38, you can also use the "VueDataUi" universal component, just specifying which component you are using. You can of course use the slots provided, if the target component has them.

```js
<script setup>
import { ref } from "vue";
import { VueDataUi } from "vue-data-ui";
// Include the css;
import "vue-data-ui/style.css";

const config = ref({...});
const dataset = ref([...]);

</script>

<template>

  <VueDataUi
    component="VueUiXy"
    :config="config"
    :dataset="dataset"
  />

</template>

```

## Typescript

Types are available in the 'vue-data-ui.d.ts' file under the types directory of the package.

## Nuxt

[This repo contains a boilerplate implementation of the vue-data-ui package in Nuxt](https://github.com/graphieros/vue-data-ui-nuxt)

# Customizable tooltips

Charts with tooltips have a config option to customize tooltip contents:

```js

customFormat: ({ seriesIndex, datapoint, series, config }) => {
  return `<div>${ ... }</div>`;
}

```

# Data formatting

Data labels can be customized using the `formatter` config attribute (since v2.3.29 on all chart components):

```
// the formatter attribute is generally placed under label or dataLabel config attribute objects

const config = ref({
  formatter: ({ value, config }) => {
    return `formatted ${value}`;
  }
})

```

# Slots

## #svg slot

Most Vue Data UI chart components include a #svg slot you can use to introduce customized svg elements (shapes, text, etc).

```html
<VueUiXy :dataset="dataset" :config="config">
  <template #svg="{ svg }">
    <foreignObject x="100" y="0" height="100" width="150">
      <div>This is a custom caption</div>
    </foreignObject>
  </template>
</VueUiXy>
```

The svg slot also works when using the VueDataUi universal component, if the component it wraps supports it.

## #legend slot (since v.2.0.41)

All charts expose a #legend slot except for:

- VueUiFlow
- VueUiHeatmap
- VueUiRelationCircle
- VueUiSparkHistogram
- VueUiSparkStackbar
- VueUiSparkbar
- VueUiSparkgauge
- VueUiSparkline
- VueUiThermometer
- VueUiTiremarks
- VueUiWheel
- VueUiDumbbell
- VueUiTimer

The legend slot also works when using the VueDataUi universal component, if the component it wraps supports it.
It is recommended to set the show legend config attribute to false, to hide the default legend.

```html
<VueUiDonut :config="config" :dataset="dataset">
  <template #legend="{ legend }">
    <div v-for="item in legend">{{ legend.name }}</div>
  </template>
</VueUiDonut>
```

## Tooltip #tooltip-before & #tooltip-after slots

Customize tooltip contents with #tooltip-before and #tooltip-after slots.
It is that easy to include an image, another chart or any other content into your tooltips. It's an alternative to the config option tooltip.customFormat, in case richer tooltip content is needed.

Both slots expose the following object:

```
{
  datapoint,
  seriesIndex,
  series,
  config,
}
```

The following charts bear these slots:

- VueUiAgePyramid
- VueUiCandlestick
- VueUiDonut
- VueUiGalaxy
- VueUiHeatmap
- VueUiMolecule
- VueUiNestedDonuts
- VueUiOnion
- VueUiQuadrant
- VueUiQuickChart
- VueUiParallelCoordinatePlot
- VueUiRadar
- VueUiRings
- VueUiScatter
- VueUiSparkStackbar
- VueUiStackbar
- VueUiTreemap
- VueUiVerticalBar
- VueUiXy \*
- VueUiwaffle
- VueUiWordCloud
- VueUiXyCanvas

\* VueUiXy slots specifically expose the following additional attributes:

```

{
  ...,
  bars,
  lines,
  plots
}

```

```html
<VueUiDonut :config="config" :dataset="dataset">
  <template #tooltip-before={ datapoint, seriesIndex, dataset, config }">
    <div>
      This content shows first
    </div>
  </template>
  <template #tooltip-after={ datapoint, seriesIndex, dataset, config }">
    <div>
      This content shows last
    </div>
  </template>
</VueUiDonut>
```

The #tooltip-before & #tooltip-after slots also works when using the VueDataUi universal component, if the component it wraps supports them.

## Add a watermark using the #watermark slot

You can use the #watermark slot to include any watermark content with your own styling.
This slot exposes the isPrinting boolean you can use to display the watermark only when producing a pdf or an image.

```html
<VueUiDonut :config="config" :dataset="dataset">
  <template #watermark="{ isPrinting }">
    <div
      v-if="isPrinting"
      style="font-size: 100px; opacity: 0.1; transform: rotate(-10deg)"
    >
      WATERMARK
    </div>
  </template>
</VueUiDonut>
```

## Customization of the zoom reset button with the #reset-action slot

Available for the following components:

- VueUiQuickChart (for line & bar types only)
- VueUiXy
- VueUiDonutEvolution
- VueUiCandlestick
- VueUiWordCloud

The config option zoom.useResetSlot must be set to true to use the slot.

```html
<VueUiXy :config="config" :dataset="dataset">
  <template #reset-action="{ reset }">
    <button @click="reset()">RESET ZOOM</button>
  </template>
</VueUiXy>
```

# Config

If for some reason you can't access the documentation website and need to get the default config object for a component:

```js
import { getVueDataUiConfig } from "vue-data-ui";

const defaultConfigXy = getVueDataUiConfig("vue_ui_xy");
```

# Themes (since v2.2.9)

All charts are set by default without a theme, and use the default color palette.

3 themes are available for all charts:

- zen
- hack
- concrete

Any color provided in dataset props will override the colors used by the theme for datapoints.

To use a theme, set the theme attribute of the config prop, for example:

```js
const donutConfig = ref({
  theme: 'zen',
  ...
})
```

# Available components : details

Type definitions are available in the `vue-data-ui.d.ts` file in the `dist/types` directory.

### Universal component

| Name        | dataset type           | config type            | emits / exposed methods | slots                  | custom tooltip         | themes                 |
| ----------- | ---------------------- | ---------------------- | ----------------------- | ---------------------- | ---------------------- | ---------------------- |
| `VueDataUi` | (depends on component) | (depends on component) | (depends on component)  | (depends on component) | (depends on component) | (depends on component) |

### Quick chart

From the dataset you pass into the props, this component will produce the most adapted chart (either a line, bar or donut chart)

| Name              | dataset type             | config type             | emits / exposed methods                                                              | slots                                                                         | custom tooltip | themes |
| ----------------- | ------------------------ | ----------------------- | ------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------- | -------------- | ------ |
| `VueUiQuickChart` | `VueUiQuickChartDataset` | `VueUiQuickChartConfig` | `@selectDatapoint`, `@selectLegend`, `generatePdf`, `generateImage`, `toggleTooltip` | `#legend`, `#tooltip-before`, `#tooltip-after`, `#reset-action`, `#watermark` | ✅             | ✅     |

### Mini charts

| Name                  | dataset type                       | config type                 | emits / exposed methods                 | slots                               | custom tooltip | themes |
| --------------------- | ---------------------------------- | --------------------------- | --------------------------------------- | ----------------------------------- | -------------- | ------ |
| `VueUiSparkline`      | `VueUiSparklineDatasetItem[]`      | `VueUiSparklineConfig`      | `@selectDatapoint`                      | `#svg`, `#before`                   | ❌             | ✅     |
| `VueUiSparkbar`       | `VueUiSparkbarDatasetItem[]`       | `VueUiSparkbarConfig`       | `@selectDatapoint`                      | `#data-label`, `#title`             | ❌             | ✅     |
| `VueUiSparkStackbar`  | `VueUiSparkStackbarDatasetItem[]`  | `VueUiSparkStackbarConfig`  | `@selectDatapoint`                      | `#tooltip-before`, `#tooltip-after` | ✅             | ✅     |
| `VueUiSparkHistogram` | `VueUiSparkHistogramDatasetItem[]` | `VueUiSparkHistogramConfig` | `@selectDatapoint`                      | ❌                                  | ❌             | ✅     |
| `VueUiSparkGauge`     | `VueUiSparkGaugeDataset`           | `VueUiSparkGaugeConfig`     | ❌                                      | ❌                                  | ❌             | ✅     |
| `VueUiSparkTrend`     | `number[]`                         | `VueUiSparkTrendConfig`     | ❌                                      | ❌                                  | ❌             | ✅     |
| `VueUiGizmo`          | `VueUiGizmoDataset`                | `VueUiGizmoConfig`          | ❌                                      | ❌                                  | ❌             | ❌     |
| `VueUiBullet`         | `VueUiBulletDataset`               | `VueUiBulletConfig`         | `generatePdf`, `generateImg`, `getData` | `#svg`, `#legend`, `#watermark`     | ❌             | ✅     |

### Charts

| Name                          | dataset type                               | config type                         | emits / exposed methods                                                                                                                                 | slots                                                                                                 | custom tooltip | themes |
| ----------------------------- | ------------------------------------------ | ----------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------- | -------------- | ------ |
| `VueUiAgePyramid`             | `Array<Array<string / number>>`            | `VueUiSparklineConfig`              | `generatePdf`, `generateImage`, `generateCsv`, `toggleTable`, `toggleTooltip`                                                                           | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiCandlestick`            | `Array<Array<string / number>>`            | `VueUiCandlestickConfig`            | `generatePdf`, `generateImage`, `generateCsv`, `toggleTable`, `toggleTooltip`                                                                           | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#reset-action`, `#watermark`                 | ✅             | ✅     |
| `VueUiChestnut`               | `VueUiChestnutDatasetRoot[]`               | `VueUiChestnutConfig`               | `@selectRoot`, `@selectBranch`, `@selectNut`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`                                   | `#svg`, `#legend`, `#watermark`                                                                       | ❌             | ✅     |
| `VueUiDonutEvolution`         | `VueUiDonutEvolutionDatasetItem[]`         | `VueUiDonutEvolutionConfig`         | `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`                                                                | `#svg`, `#legend`, `#reset-action`, `#watermark`                                                      | ❌             | ✅     |
| `VueUiDonut`                  | `VueUiDonutDatasetItem[]`                  | `VueUiDonutConfig`                  | `@selectDatapoint`, `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleTooltip`           | `#svg`, `#legend`, `#dataLabel`, `#tooltip-before`, `#tooltip-after`, `#plot-comment`, `#watermark`   | ✅             | ✅     |
| `VueUiDumbbell`               | `VueUiDumbbellDataset[]`                   | `VueUiDumbbellConfig`               | `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`                                                                                 | `#svg`, `#legend`, `#watermark`                                                                       | ❌             | ✅     |
| `VueUiFlow`                   | `VueUiFlowDatasetItem[]`                   | `VueUiFlowConfig`                   | `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`                                                                                 | `#svg`,, `#watermark`                                                                                 | ❌             | ✅     |
| `VueUiGalaxy`                 | `VueUiGalaxyDatasetItem[]`                 | `VueUiGalaxyConfig`                 | `@selectDatapoint`, `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                           | `#svg`, `#legend`,`#tooltip-before`, `#tooltip-after`                                                 | ✅             | ✅     |
| `VueUiGauge`                  | `VueUiGaugeDataset`                        | `VueUiGaugeConfig`                  | `generatePdf`, `generateImage`                                                                                                                          | `#svg`, `#legend`, `#watermark`                                                                       | ❌             | ✅     |
| `VueUiHeatmap`                | `VueUiHeatmapDatasetItem[]`                | `VueUiHeatmapConfig`                | `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                                                                           | `#svg`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                             | ✅             | ✅     |
| `VueUiMolecule`               | `VueUiMoleculeDatasetNode[]`               | `VueUiMoleculeConfig`               | `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleTooltip`                                                | `#svg`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                             | ✅             | ✅     |
| `VueUiMoodRadar`              | `VueUiMoodRadarDataset`                    | `VueUiMoodRadarConfig`              | `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`                                                                                 | `#svg`, `#legend`, `#watermark`                                                                       | ❌             | ✅     |
| `VueUiNestedDonuts`           | `VueUiNestedDonutsDatasetItem[]`           | `VueUiNestedDonutsConfig`           | `@selectDatapoint`, `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleTooltip`           | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiOnion`                  | `VueUiOnionDatasetItem[]`                  | `VueUiOnionConfig`                  | `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                                               | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiParallelCoordinatePlot` | `VueUiParallelCoordinatePlotDatasetItem[]` | `VueUiParallelCoordinatePlotConfig` | `@selectLegend`, `@selectDatapoint`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleTooltip`           | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#plot-comment`, `#watermark`                 | ✅             | ✅     |
| `VueUiQuadrant`               | `VueUiQuadrantDatasetItem[]`               | `VueUiQuadrantConfig`               | `@selectLegend`, `@selectPlot`, `@selectSide`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleTooltip` | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiRadar`                  | `VueUiRadarDataset`                        | `VueUiRadarConfig`                  | `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                                               | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiRings`                  | `VueUiRingsDatasetItem[]`                  | `VueUiRingsConfig`                  | `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                                               | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiScatter`                | `VueUiScatterDatasetItem[]`                | `VueUiScatterConfig`                | `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                                                                | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiStackbar`               | `VueUiStackbarDatasetItem[]`               | `VueUiStackbarConfig`               | `@selectLegend`, `@selectDatapoint`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleTooltip`           | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#reset-action`, `#watermark`                 | ✅             | ✅     |
| `VueUiStripPlot`              | `VueUiStripPlotDataset[]`                  | `VueUiStripPlotConfig`              | `@selectDatapoint`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleTooltip`                            | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiThermometer`            | `VueUiThermometerDataset`                  | `VueUiThermometerConfig`            | `generatePdf`, `generateImage`                                                                                                                          | `#svg`, `#watermark`                                                                                  | ❌             | ✅     |
| `VueUiTiremarks`              | `VueUiTiremarksDataset`                    | `VueUiTiremarksConfig`              | `generatePdf`, `generateImage`                                                                                                                          | `#svg`, `#legend`, `#watermark`                                                                       | ❌             | ✅     |
| `VueUiTreemap`                | `VueUiTreemapDatasetItem[]`                | `VueUiTreemapConfig`                | `@selectLegend`, `@selectDatapoint`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                           | `#svg`, `#rect`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                         | ✅             | ✅     |
| `VueUiVerticalBar`            | `VueUiVerticalBarDatasetItem[]`            | `VueUiWheelConfig`                  | `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleSort`, `toggleTooltip`                                 | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiWaffle`                 | `VueUiWaffleDatasetItem[]`                 | `VueUiWaffleConfig`                 | `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleTooltip`                                               | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#watermark`                                  | ✅             | ✅     |
| `VueUiWheel`                  | `VueUiWheelDataset`                        | `VueUiWheelConfig`                  | `generatePdf`, `generateImage`                                                                                                                          | `#svg`, `#watermark`                                                                                  | ❌             | ✅     |
| `VueUiWordCloud`              | `VueUiWordCloudDatasetItem[] / string`     | `VueUiWordCloudConfig`              | `getData`, `generatePdf`, `generateImage`, `generateCsv`, `toggleTooltip`                                                                               | `#svg`, `#reset-action`, `#watermark`, `#tooltip-before`, `#tooltip-after`                            | ✅             | ✅     |
| `VueUiXyCanvas`               | `VueUiXyCanvasDatasetItem[]`               | `VueUiXyCanvasConfig`               | `@selectLegend`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleStack`, `toggleTooltip`                | `#legend`, `#tooltip-before`, `#tooltip-after`, `#reset-action`, `#watermark`                         | ✅             | ✅     |
| `VueUiXy`                     | `VueUiXyDatasetItem[]`                     | `VueUiXyConfig`                     | `@selectLegend`, `@selectX`, `getData`, `generatePdf`, `generateCsv`, `generateImage`, `toggleTable`, `toggleLabels`, `toggleStack`, `toggleTooltip`    | `#svg`, `#legend`, `#tooltip-before`, `#tooltip-after`, `#reset-action`, `#plot-comment`,`#watermark` | ✅             | ✅     |

### 3D charts

| Name         | dataset type        | config type        | emits / exposed methods                       | slots                | custom tooltip | themes |
| ------------ | ------------------- | ------------------ | --------------------------------------------- | -------------------- | -------------- | ------ |
| `VueUi3dBar` | `VueUi3dBarDataset` | `VueUi3dBarConfig` | `generatePdf`, `generateImage`, `toggleTable` | `#svg`, `#watermark` | ❌             | ✅     |

### Data tables

| Name                  | dataset type                       | config type                 | emits / exposed methods                                                                               | slots                                                           | themes |
| --------------------- | ---------------------------------- | --------------------------- | ----------------------------------------------------------------------------------------------------- | --------------------------------------------------------------- | ------ |
| `VueUiTable`          | `VueUiTableDataset`                | `VueUiTableConfig`          | ❌                                                                                                    | ❌                                                              | ❌     |
| `VueUiTableHeatmap`   | `VueUiTableHeatmapDatasetItem[]`   | `VueUiTableHeatmapConfig`   | `generatePdf`, `generateCsv`, `generateImage`                                                         | `#caption`, `#rowTitle`, `#cell`, `#sum`, `#average`, `#median` | ✅     |
| `VueUiTableSparkline` | `VueUiTableSparklineDatasetItem[]` | `VueUiTableSparklineConfig` | `generatePdf`, `generateCsv`, `generateImage`                                                         | ❌                                                              | ✅     |
| `VueUiCarouselTable`  | `VueUiCarouselTableDataset`        | `VueUiCarouselTableConfig`  | `generatePdf`, `generateImage`, `generateCsv`, `toggleAnimation`, `pauseAnimation`, `resumeAnimation` | `#caption`, `#th`, `#td`                                        | ❌     |

### Rating

| Name          | dataset type         | config type         | emits / exposed methods             |
| ------------- | -------------------- | ------------------- | ----------------------------------- |
| `VueUiRating` | `VueUiRatingDataset` | `VueUiRatingConfig` | `@rate`, `getData`,`toggleReadonly` |
| `VueUiSmiley` | `VueUiRatingDataset` | `VueUiSmileyConfig` | `@rate`, `getData`,`toggleReadonly` |

### Utilities

| Name              | dataset type              | config type             | emits / exposed methods                          | slots                                                   |
| ----------------- | ------------------------- | ----------------------- | ------------------------------------------------ | ------------------------------------------------------- |
| `VueUiAccordion`  | ❌                        | `VueUiAccordionConfig`  | ❌                                               | `#arrow`, `#title`, `#content`                          |
| `VueUiAnnotator`  | `VueUiAnnotatorDataset`   | `VueUiAnnotatorConfig`  | `@toggleOpenState`, `@saveAnnotations`           | ❌                                                      |
| `VueUiCursor`     | ❌                        | `VueUiCursorConfig`     | ❌                                               | ❌                                                      |
| `VueUiDashboard`  | `VueUiDashboardElement[]` | `VueUiDashboardConfig`  | `@change`                                        | `#content`                                              |
| `VueUiDigits`     | `number`                  | `VueUiDigitsConfig`     | ❌                                               | ❌                                                      |
| `VueUiKpi`        | `number`                  | `VueUiKpiConfig`        | ❌                                               | `#title`, `#value`, `#comment-before`, `#comment-after` |
| `VueUiMiniLoader` | ❌                        | `VueUiMiniLoaderConfig` | ❌                                               | ❌                                                      |
| `VueUiScreenshot` | ❌                        | `VueUiScreenshotConfig` | `@postImage`, `shoot`, `close`                   | ❌                                                      |
| `VueUiSkeleton`   | ❌                        | `VueUiSkeletonConfig`   | ❌                                               | ❌                                                      |
| `VueUiTimer`      | ❌                        | `VueUiTimerConfig`      | `@start`, `@pause`, `@reset`, `@restart`, `@lap` | `#time`, `#controls`, `#laps`                           |
| `VueUiIcon`       | see below                 |

### Icons

Tailor made icons are available through the VueUiIcon component:

```html
<VueUiIcon name="arrowRight" :size="24" stroke="#6376DD" />
```

All names of available icons are available in the vue-data-ui.d.ts file under the `VueUiIconName` type.

# User options

User options menu is accessible in the burger menu located on the top right of charts, and visible by default.
To hide user options menu, set config.userOptions.show to false:

```js
const config = ref({
  userOptions: {
    show: false
  },
  ...
})
```

Predefined actions in user options menu depend on the type of chart. Some charts have more or less actions available. Action buttons contain an predefined icons by default.

To hide a given action, set the userOption.buttons, for example:

```js
const config = ref({
  userOptions: {
    show: true,
    buttons: {
      pdf: false,
      fullscreen: false,
      // all other actions will be visible by default (list of all actions below)
    },
  },
});
```

You can use slots to override the content of action buttons.
What happens when the button is clicked is taken care of by the component, except for the optionFullscreen slot.

```html
<VueUiDonut :config="config" :dataset="dataset">
  <template #optionPdf> GENERATE PDF </template>

  <!-- This is the only action where scoped content is provided -->
  <template template #optionFullscreen="{ isFullscreen, toggleFullscreen }">
    <div @click="toggleFullscreen(isFullscreen ? 'out' : 'in')">
      TOGGLE FULLSCREEN
    </div>
  </template>
</VueUiDonut>
```

User options actions available per chart:

| Chart name                  | User options actions slot names                                                                                           |
| --------------------------- | ------------------------------------------------------------------------------------------------------------------------- |
| VueUi3dBar                  | optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                                           |
| VueUiAgePyramid             | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiBullet                 | optionPdf, optionImg, optionFullscreen, optionAnnotator                                                                   |
| VueUiCandlestick            | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiCarouselTable          | optionPdf, optionImg, optionCsv, optionAnimation, optionFullscreen                                                        |
| VueUiChestnut               | optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                                           |
| VueUiDonut                  | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionAnnotator              |
| VueUiDonutEvolution         | optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                                           |
| VueUiDumbbell               | optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                                           |
| VueUiFlow                   | optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                                           |
| VueUiGalaxy                 | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiGauge                  | optionPdf, optionImg, optionFullscreen, optionAnnotator                                                                   |
| VueUiHeatmap                | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiMolecule               | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionAnnotator              |
| VueUiMoodRadar              | optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                                           |
| VueUiNestedDonuts           | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionAnnotator              |
| VueUiOnion                  | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiParallelCoordinatePlot | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionAnnotator              |
| VueUiQuadrant               | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionAnnotator              |
| VueUiQuickChart             | optionTooltip, optionPdf, optionImg, optionFullscreen, optionAnnotator                                                    |
| VueUiRadar                  | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiRelationCircle         | optionPdf, optionImg, optionFullscreen, optionAnnotator                                                                   |
| VueUiRings                  | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiScatter                | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiSparkHistogram         | (no user options menu)                                                                                                    |
| VueUiSparkStackbar          | (no user options menu)                                                                                                    |
| VueUiSparkTrend             | (no user options menu)                                                                                                    |
| VueUiSparkbar               | (no user options menu)                                                                                                    |
| VueUiSparkgauge             | (no user options menu)                                                                                                    |
| VueUiSparkline              | (no user options menu)                                                                                                    |
| VueUiStackbar               | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionAnnotator              |
| VueUiStripPlot              | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionAnnotator              |
| VueUiTableHeatmap           | optionPdf, optionImg, optionCsv, optionFullscreen                                                                         |
| VueUiTableSparkline         | optionPdf, optionImg, optionCsv, optionFullscreen                                                                         |
| VueUiThermometer            | optionPdf, optionImg, optionFullscreen, optionAnnotator                                                                   |
| VueUiTiremarks              | optionPdf, optionImg, optionFullscreen, optionAnnotator                                                                   |
| VueUiTreemap                | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiVerticalBar            | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionSort, optionFullscreen, optionAnnotator                |
| VueUiWaffle                 | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                            |
| VueUiWheel                  | optionPdf, optionImg, optionFullscreen, optionAnnotator                                                                   |
| VueUiWordCloud              | optionPdf, optionImg, optionCsv, optionTable, optionFullscreen, optionAnnotator                                           |
| VueUiXy                     | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionStack, optionAnnotator |
| VueUiXyCanvas               | optionTooltip, optionPdf, optionImg, optionCsv, optionTable, optionLabels, optionFullscreen, optionStack, optionAnnotator |

# Custom palette

It is possible to provide a custom palette in the config prop through config.customPalette (string[]) for the following components:

- VueUi3dBar
- VueUiChestnut
- VueUiDonut
- VueUiDonutEvolution
- VueUiFlow
- VueUiGalaxy
- VueUiGauge
- VueUiMolecule
- VueUiNestedDonuts
- VueUiOnion
- VueUiParallelCoordinatePlot
- VueUiQuadrant
- VueUiQuickChart
- VueUiRadar
- VueUiRelationCircle
- VueUiRings
- VueUiScatter
- VueUiSparkStackbar
- VueUiSparkbar
- VueUiStackbar
- VueUiStripPlot
- VueUiTableSparkline
- VueUiThermometer
- VueUiTreemap
- VueUiVerticalBar
- VueUiWaffle
- VueUiWordCloud
- VueUiXy
- VueUiXyCanvas

If the array of colors provided in customPalette is too small for the dataset, remaining colors will be computed from the default internal palette.
Accepted color formats: HEX, RGB, HSL, named colors.

# Responsive charts

By default, all charts will scale to the width of their container.
However the folowing charts can be made fully responsive, making them better to use in resizable containers:

| Component                   | Responsive feature implemented |
| --------------------------- | ------------------------------ |
| VueUi3dBar                  | -                              |
| VueUiAgePyramid             | ✅                             |
| VueUiAgePyramid             | ✅                             |
| VueUiBullet                 | -                              |
| VueUiCarouselTable          | -                              |
| VueUiChestnut               | -                              |
| VueUiDonut                  | ✅                             |
| VueUiDonutEvolution         | -                              |
| VueUiDumbbell               | ✅                             |
| VueUiFlow                   | -                              |
| VueUiGalaxy                 | -                              |
| VueUiGauge                  | ✅                             |
| VueUiHeatmap                | -                              |
| VueUiMolecule               | -                              |
| VueUiMoodRadar              | -                              |
| VueUiNestedDonuts           | ✅                             |
| VueUiOnion                  | ✅                             |
| VueUiParallelCoordinatePlot | ✅                             |
| VueUiQuadrant               | ✅                             |
| VueUiQuickChart             | ✅                             |
| VueUiRadar                  | ✅                             |
| VueUiRelationCircle         | ✅                             |
| VueUiRings                  | ✅                             |
| VueUiScatter                | ✅                             |
| VueUiSparkHistogram         | -                              |
| VueUiSparkStackbar          | -                              |
| VueUiSparkTrend             | -                              |
| VueUiSparkbar               | -                              |
| VueUiSparkgauge             | -                              |
| VueUiSparkline              | ✅                             |
| VueUiStackbar               | ✅                             |
| VueUiStripPlot              | ✅                             |
| VueUiTableHeatmap           | -                              |
| VueUiTableSparkline         | -                              |
| VueUiThermometer            | -                              |
| VueUiTimer                  | ✅                             |
| VueUiTiremarks              | -                              |
| VueUiTreemap                | ✅                             |
| VueUiVerticalBar            | ✅                             |
| VueUiWaffle                 | ✅                             |
| VueUiWheel                  | ✅                             |
| VueUiWordCloud              | ✅                             |
| VueUiXy                     | ✅                             |
| VueUiXyCanvas               | ✅                             |

To activate responsiveness, set the config.responsive attribute to true:

```js
const config = ref({
  responsive: true,
  // rest of your config
});
```

**Important:** when using the responsive feature, charts must be placed inside a container with fixed dimensions. Avoid setting a 100% height to this container, as it will result in the chart growing infinitely.

# Big data optimization (since v2.4.11)

Very large datasets (> 5k or > 10k datapoints) will cause the browsers rendering engines to slow down, caused by too many SVG DOM elements to render.
The following charts use the LTTB algorithm (Largest-Triangle-Three-Bucket) beyond a certain threshold to downsample the rendered dataset while preserving its shape. These components are the most susceptible to be used with very large datasets:

| Component       | Default Threshold | Remark                                                    |
| --------------- | ----------------- | --------------------------------------------------------- |
| VueUiXy         | 500               |                                                           |
| VueUiXyCanvas   | 10000             | Since this chart uses canvas, threhsold can be set higher |
| VueUiQuadrant   | 500               |                                                           |
| VueUiScatter    | 500               |                                                           |
| VueUiSparkline  | 500               |                                                           |
| VueUiSparkTrend | 500               |                                                           |

The downsample threshold for each component can be set in the config prop passed to components:

```js
const config = ref({
  downsample: {
    threshold: 500,
  },
  ...// rest of your config
})
```
