import { p as D, u as x, A as G, m as M, d as T, B as E, q as z, r as B, a0 as H } from "./index-hV0hU1iE.js";
import { openBlock as i, createElementBlock as c, normalizeStyle as g, createElementVNode as a, toDisplayString as u, Fragment as b, renderList as _, normalizeClass as f, createTextVNode as I, createCommentVNode as N, withDirectives as k, vModelText as w, withKeys as S, withModifiers as O, vModelSelect as P, createStaticVNode as R, pushScopeId as U, popScopeId as V } from "vue";
import { _ as j } from "./_plugin-vue_export-helper-CHgC5LLL.js";
const X = {
  name: "vue-ui-table",
  props: {
    config: {
      type: Object,
      default() {
        return {};
      }
    },
    dataset: {
      type: Object,
      default() {
        return {};
      }
    }
  },
  data() {
    return {
      uid: `vue-ui-table-${Math.random()}`,
      bodyCopy: JSON.parse(JSON.stringify(this.dataset.body)).map((r, l) => ({
        ...r,
        absoluteIndex: l
      })),
      buttonTimeout: null,
      canMoveChart: !1,
      chart: {
        height: 316,
        type: "bar",
        width: 512
      },
      constants: {
        ASC: 1,
        BAR: "bar",
        DATE: "date",
        DESC: -1,
        DONUT: "donut",
        LINE: "line",
        NUMERIC: "numeric",
        PERCENTAGE: "percentage",
        TEXT: "text"
      },
      clientX: 100,
      clientY: 100,
      cssClass: {
        CELL: "smart-td-selected",
        FIRST_TD: "smart-td-selected-first",
        LAST_TD: "smart-td-selected-last",
        ROW: "smart-td-selected-neighbor"
      },
      currentDonut: void 0,
      currentFilter: void 0,
      currentSearch: void 0,
      currentSelectionSpan: {
        col: void 0,
        rows: []
      },
      currentPage: 0,
      dates: {},
      filteredDatesIndexes: {},
      hasNaN: {},
      iconColor: "#2D353C",
      iconSize: 20,
      immutableRangeFilters: {},
      isExportRequest: !1,
      isLoading: !1,
      itemsPerPage: this.config.rowsPerPage ? this.config.rowsPerPage : 25,
      multiselects: {},
      paginatorOptions: [.../* @__PURE__ */ new Set([10, 25, 50, 100, 250, 500, this.config.rowsPerPage ? this.config.rowsPerPage : 25, this.dataset.body.length])].sort((r, l) => r - l),
      palette: D,
      percentages: {},
      rafId: null,
      rangeFilters: {},
      searches: {},
      selectedColumn: void 0,
      selectedDonutCategory: void 0,
      selectedPlot: void 0,
      showChart: !1,
      showDonutOptions: !1,
      sorts: {},
      tableBody: JSON.parse(JSON.stringify(this.dataset.body)).map((r, l) => ({
        ...r,
        absoluteIndex: l
      })),
      tableHead: JSON.parse(JSON.stringify(this.dataset.header)).map((r) => ({
        average: Object.hasOwn(r, "average") ? r.average : !1,
        decimals: Object.hasOwn(r, "decimals") ? r.decimals : 0,
        isMultiselect: Object.hasOwn(r, "isMultiselect") ? r.isMultiselect : !1,
        isPercentage: Object.hasOwn(r, "isPercentage") ? r.isPercentage : !1,
        isSearch: Object.hasOwn(r, "isSearch") ? r.isSearch : !1,
        isSort: Object.hasOwn(r, "isSort") ? r.isSort : !1,
        name: r.name,
        // this attribute is mandatory
        percentageTo: Object.hasOwn(r, "percentageTo") ? r.percentageTo : void 0,
        prefix: Object.hasOwn(r, "prefix") ? r.prefix : "",
        rangeFilter: Object.hasOwn(r, "rangeFilter") ? r.rangeFilter : !1,
        suffix: Object.hasOwn(r, "suffix") ? r.suffix : "",
        sum: Object.hasOwn(r, "sum") ? r.sum : !1,
        type: r.type
        // this attribute is mandatory
      }))
    };
  },
  mounted() {
    if (this.dataset.header.length === 0)
      throw new Error(`vue-ui-table error: missing header data.
Provide an array of objects of type:
{
 name: string;
 type: string; ('text' | 'numeric' | 'date')
 average: boolean;
 decimals: number | undefined;
 sum: boolean;
 isSort:boolean;
 isSearch: boolean;
 isMultiselect: boolean;
 isPercentage: boolean;
 percentageTo: string; (or '')
}`);
    if (this.dataset.body.length === 0)
      throw new Error("vue-ui-table error: missing body data");
    this.isLoading = !0, this.promiseWithAsyncFunction(this.prepareBodyCopy, () => {
      this.$forceUpdate(), this.isLoading = !1;
    }), document.addEventListener("keydown", (s) => {
      const r = document.activeElement;
      (r && Array.from(r.classList).includes("td-focusable") && s.key.includes("Arrow") || s.code === "Space") && s.preventDefault();
    });
  },
  watch: {
    showChart: function(s) {
      s && this.$nextTick(() => {
        this.closeDragElement();
        const r = this.$refs.chartModal;
        r.onmousedown = this.dragMouseDown;
      });
    }
  },
  computed: {
    availableDonutCategories() {
      return Object.keys(this.multiselects).map((s) => ({
        index: s,
        name: this.dataset.header[s].name,
        options: this.multiselects[s]
      }));
    },
    canChart() {
      return this.FINAL_CONFIG.useChart && this.currentSelectionSpan.rows.length > 1;
    },
    chartData() {
      if (!this.canChart) return [];
      const s = 316, r = 512, l = this.currentSelectionSpan.rows.length, h = r / l, t = Math.max(...this.currentSelectionSpan.rows.map((C) => C.value)), e = Math.min(...this.currentSelectionSpan.rows.map((C) => C.value)), n = e >= 0 ? 0 : Math.abs(e), o = t + n, d = t < 0 && e < 0, y = this.dataset.header[this.currentSelectionSpan.col].isPercentage, m = this.currentSelectionSpan.rows.map((C, L) => ({
        x: h * L + h / 2,
        y: (1 - (C.value + n) / o) * s,
        value: y ? C.value * 100 : C.value,
        suffix: y ? "%" : this.dataset.header[this.currentSelectionSpan.col].suffix ? this.dataset.header[this.currentSelectionSpan.col].suffix : "",
        prefix: this.dataset.header[this.currentSelectionSpan.col].prefix ? this.dataset.header[this.currentSelectionSpan.col].prefix : "",
        index: C.index,
        absoluteValue: y ? Math.abs(C.value) * 100 : Math.abs(C.value)
      })), p = s - s * (n / o);
      return { isAllNegative: d, zero: p, plots: m, slot: h, progression: m.length >= 2 ? this.calcLinearProgression(m) : !1 };
    },
    donutHollowLabels() {
      return {
        total: Number((this.currentDonut.map((s) => s.absoluteValue).reduce((s, r) => s + r, 0) * (this.dataset.header[this.currentSelectionSpan.col].isPercentage ? 100 : 1)).toFixed(this.dataset.header[this.currentSelectionSpan.col].decimals)).toLocaleString(),
        average: Number((this.currentDonut.map((s) => s.absoluteValue).reduce((s, r) => s + r, 0) / this.currentSelectionSpan.rows.length * (this.dataset.header[this.currentSelectionSpan.col].isPercentage ? 100 : 1)).toFixed(this.dataset.header[this.currentSelectionSpan.col].decimals)).toLocaleString()
      };
    },
    hasNumericTypes() {
      return this.dataset.header.map((s) => s.type).includes(this.constants.NUMERIC);
    },
    icons() {
      return {
        arrowSort: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 9l4 -4l4 4m-4 -4v14" /><path d="M21 15l-4 4l-4 -4m4 4v-14" /></svg>`,
        bar: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M9 8m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M15 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M4 20l14 0" /></svg>`,
        chart: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 19l16 0" /><path d="M4 15l4 -6l4 2l4 -5l4 4" /></svg>`,
        chevronDown: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 9l6 6l6 -6" /></svg>`,
        chevronLeft: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize * 1.6}" height="${this.iconSize * 1.6}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 6l-6 6l6 6" /></svg>`,
        chevronRight: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize * 1.6}" height="${this.iconSize * 1.6}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>`,
        donut: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize * 0.8}" height="${this.iconSize * 0.8}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 3v5m4 4h5" /><path d="M8.929 14.582l-3.429 2.918" /><path d="M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0" /><path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" /></svg>`,
        export: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12.5 21h-7.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7.5" /><path d="M3 10h18" /><path d="M10 3v18" /><path d="M16 19h6" /><path d="M19 16l3 3l-3 3" /></svg>`,
        fileDownload: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M14 3v4a1 1 0 0 0 1 1h4" /><path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" /><path d="M12 17v-6" /><path d="M9.5 14.5l2.5 2.5l2.5 -2.5" /></svg>`,
        filter: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 4h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v7l-6 2v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227z" /></svg>`,
        move: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 9l3 3l-3 3" /><path d="M15 12h6" /><path d="M6 9l-3 3l3 3" /><path d="M3 12h6" /><path d="M9 18l3 3l3 -3" /><path d="M12 15v6" /><path d="M15 6l-3 -3l-3 3" /><path d="M12 3v6" /></svg>`,
        sort09: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 15l3 3l3 -3" /><path d="M7 6v12" /><path d="M17 3a2 2 0 0 1 2 2v3a2 2 0 1 1 -4 0v-3a2 2 0 0 1 2 -2z" /><path d="M17 16m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M19 16v3a2 2 0 0 1 -2 2h-1.5" /></svg>`,
        sort90: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 15l3 3l3 -3" /><path d="M7 6v12" /><path d="M17 14a2 2 0 0 1 2 2v3a2 2 0 1 1 -4 0v-3a2 2 0 0 1 2 -2z" /><path d="M17 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M19 5v3a2 2 0 0 1 -2 2h-1.5" /></svg>`,
        sortAZ: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 10v-5c0 -1.38 .62 -2 2 -2s2 .62 2 2v5m0 -3h-4" /><path d="M19 21h-4l4 -7h-4" /><path d="M4 15l3 3l3 -3" /><path d="M7 6v12" /></svg>`,
        sortZA: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 21v-5c0 -1.38 .62 -2 2 -2s2 .62 2 2v5m0 -3h-4" /><path d="M19 10h-4l4 -7h-4" /><path d="M4 15l3 3l3 -3" /><path d="M7 6v12" /></svg>`,
        sum: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 16v2a1 1 0 0 1 -1 1h-11l6 -7l-6 -7h11a1 1 0 0 1 1 1v2" /></svg>`,
        table: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize}" height="${this.iconSize}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" fill="white" d="M 10 2, 21 2, 21 21, 10 21Z"/><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z" /><path d="M3 10h18" /><path d="M10 3v18" /></svg>`,
        warning: `<svg xmlns="http://www.w3.org/2000/svg" width="${this.iconSize * 0.8}" height="${this.iconSize * 0.8}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.24 3.957l-8.422 14.06a1.989 1.989 0 0 0 1.7 2.983h16.845a1.989 1.989 0 0 0 1.7 -2.983l-8.423 -14.06a1.989 1.989 0 0 0 -3.4 0z" /><path d="M12 9v4" /><path d="M12 17h.01" /></svg>`
      };
    },
    pages() {
      const s = [];
      if (this.bodyCopy.length)
        for (let r = 0; r < this.bodyCopy.length; r += this.itemsPerPage)
          s.push(this.bodyCopy.slice(r, r + this.itemsPerPage));
      return s;
    },
    rows() {
      return this.bodyCopy.map((s) => s.td);
    },
    selectedCellsCalculations() {
      return {
        sumPercentage: Number((this.currentSelectionSpan.rows.map((s) => s.value).reduce((s, r) => s + r, 0) * 100).toFixed(this.dataset.header[this.currentSelectionSpan.col].decimals)).toLocaleString(),
        sumRegular: Number(this.currentSelectionSpan.rows.map((s) => s.value).reduce((s, r) => s + r, 0).toFixed(this.dataset.header[this.currentSelectionSpan.col].decimals)).toLocaleString(),
        averagePercentage: Number((this.currentSelectionSpan.rows.map((s) => s.value).reduce((s, r) => s + r, 0) / this.currentSelectionSpan.rows.length * 100).toFixed(this.dataset.header[this.currentSelectionSpan.col].decimals)).toLocaleString(),
        averageRegular: Number((this.currentSelectionSpan.rows.map((s) => s.value).reduce((s, r) => s + r, 0) / this.currentSelectionSpan.rows.length).toFixed(this.dataset.header[this.currentSelectionSpan.col].decimals)).toLocaleString()
      };
    },
    FINAL_CONFIG() {
      const { vue_ui_table: s } = x();
      if (!Object.keys(this.config || {}).length)
        return s;
      const r = this.treeShake({
        defaultConfig: s,
        userConfig: this.config
      });
      return this.convertConfigColors(r);
    },
    visibleRows() {
      return this.pages[this.currentPage];
    }
  },
  methods: {
    // lib
    treeShake: G,
    makeDonut: M,
    convertColorToHex: T,
    convertConfigColors: E,
    createCsvContent: z,
    downloadCsv: B,
    // specific
    applyDonutOption() {
      const s = this.selectedDonutCategory.options.map((r, l) => ({
        name: r,
        color: this.palette[l] || this.palette[l % this.palette.length],
        value: this.visibleRows.filter((h, t) => h.td[this.selectedDonutCategory.index] === r && this.currentSelectionSpan.rows.map((e) => e.index).includes(t)).map((h) => h.td[this.currentSelectionSpan.col]).reduce((h, t) => Math.abs(h) + Math.abs(t), 0),
        absoluteValue: this.visibleRows.filter((h, t) => h.td[this.selectedDonutCategory.index] === r && this.currentSelectionSpan.rows.map((e) => e.index).includes(t)).map((h) => h.td[this.currentSelectionSpan.col]).reduce((h, t) => h + t, 0)
      })).sort((r, l) => l.value - r.value);
      this.currentDonut = this.makeDonut({ series: s }, 50, 50, 30, 30), this.$nextTick(() => {
        this.chart.type = this.constants.DONUT, this.showDonutOptions = !1;
      });
    },
    calcRectY(s, r) {
      return s >= 0 ? r : this.chartData.zero;
    },
    canResetColumn(s, r) {
      return !this.hasNaN[s] && (r.isSort || r.isSearch || r.isMultiselect || r.rangeFilter) && ![this.constants.DATE].includes(r.type);
    },
    createXls(s = "all") {
      const r = this.dataset.header.map((e) => e.name), l = s === "all" ? this.bodyCopy.map((e) => e.td) : this.visibleRows.map((e) => e.td), h = [r].concat(l), t = this.createCsvContent(h);
      this.downloadCsv({ csvContent: t, title: "vue-ui-table" });
    },
    calcLinearProgression: H,
    closeAllDropdowns() {
      const s = document.getElementsByClassName("th-dropdown");
      s.length && Array.from(s).forEach((r) => {
        r.dataset.isOpen = !1;
      });
    },
    debounce(s, r) {
      let l;
      clearTimeout(l), l = setTimeout(s, r);
    },
    filterBody() {
      this.bodyCopy = this.tableBody.filter((s) => {
        for (const r in this.searches)
          if (!s.td[r].toUpperCase().includes(this.searches[r].toUpperCase()))
            return !1;
        for (const r in this.multiselects)
          if (!this.multiselects[r].some((h) => h === s.td[r]))
            return !1;
        for (const r in this.dates) {
          const l = new Date(s.td[r]), h = new Date(this.dates[r].from), t = new Date(this.dates[r].to);
          if (l < h || l > t)
            return !1;
        }
        return !0;
      }), this.sortBody();
    },
    getAverage(s) {
      return this.rows.map((r) => r[s]).map((r) => isNaN(Number(r)) ? 0 : r).reduce((r, l) => r + l, 0) / this.bodyCopy.length;
    },
    getDatesRange(s) {
      const r = this.dataset.body.map((C) => new Date(C.td[s])), l = new Date(Math.min(...r)), h = new Date(Math.max(...r)), t = l.getFullYear(), e = h.getFullYear(), n = String(l.getMonth() + 1).padStart(2, "0"), o = String(h.getMonth() + 1).padStart(2, "0"), d = String(l.getDate()).padStart(2, "0"), y = String(h.getDate()).padStart(2, "0"), m = `${t}-${n}-${d}`, p = `${e}-${o}-${y}`;
      return {
        from: m,
        to: p
      };
    },
    getDonutLegendValue(s) {
      return Number((s * (this.dataset.header[this.currentSelectionSpan.col].isPercentage ? 100 : 1)).toFixed(this.dataset.header[this.currentSelectionSpan.col].decimals)).toLocaleString();
    },
    getDropdownOptions(s) {
      return [...new Set(this.dataset.body.map((r) => r.td[s]))];
    },
    getSum(s) {
      return this.rows.map((r) => r[s]).map((r) => isNaN(Number(r)) ? 0 : r).reduce((r, l) => r + l, 0);
    },
    includesNaN(s) {
      return s.includes(NaN);
    },
    isDropdownOptionSelected(s, r) {
      return this.multiselects[r] ? this.multiselects[r].includes(s) : !0;
    },
    isNumeric(s) {
      return !isNaN(Number(String(s).replaceAll("%", "")));
    },
    isResetDisabled(s, r) {
      const l = r.isSort, h = r.isSearch, t = r.isMultiselect && this.multiselects[s], e = r.rangeFilter, n = (o) => {
        if (e && this.rangeFilters[o])
          return Math.round(this.rangeFilters[o].min) === this.immutableRangeFilters[o].min && Math.round(this.rangeFilters[o].max) === this.immutableRangeFilters[o].max;
      };
      if (l && h && t && e)
        return ["", void 0].includes(this.searches[s]) && [void 0].includes(this.sorts[s]) && this.multiselects[s].length === this.getDropdownOptions(s).length && n(s);
      if (l && h && t)
        return ["", void 0].includes(this.searches[s]) && [void 0].includes(this.sorts[s]) && this.multiselects[s].length === this.getDropdownOptions(s).length;
      if (l && h && e)
        return ["", void 0].includes(this.searches[s]) && [void 0].includes(this.sorts[s]) && n(s);
      if (l && h)
        return ["", void 0].includes(this.searches[s]) && [void 0].includes(this.sorts[s]);
      if (l && t && e)
        return [void 0].includes(this.sorts[s]) && this.multiselects[s].length === this.getDropdownOptions(s).length && n(s);
      if (l && t)
        return [void 0].includes(this.sorts[s]) && this.multiselects[s].length === this.getDropdownOptions(s).length;
      if (h && t && e)
        return ["", void 0].includes(this.searches[s]) && this.multiselects[s].length === this.getDropdownOptions(s).length && n(s);
      if (h && t)
        return ["", void 0].includes(this.searches[s]) && this.multiselects[s].length === this.getDropdownOptions(s).length;
      if (h && e)
        return ["", void 0].includes(this.searches[s]) && n(s);
      if (h)
        return ["", void 0].includes(this.searches[s]);
      if (l && e)
        return [void 0].includes(this.sorts[s]) && n(s);
      if (l)
        return [void 0].includes(this.sorts[s]);
      if (t && e)
        return this.multiselects[s].length === this.getDropdownOptions(s).length && n(s);
      if (t)
        return this.multiselects[s].length === this.getDropdownOptions(s).length;
    },
    navigate(s) {
      this.resetSelection(), s === "next" && this.currentPage < this.pages.length ? this.currentPage += 1 : s === "previous" && this.currentPage >= 1 ? this.currentPage -= 1 : this.currentPage = s - 1, this.$refs.tableWrapper.scrollTo({
        top: 0,
        left: 0,
        behavior: "smooth"
      });
    },
    navigateCell(s) {
      s.preventDefault();
      const r = s.keyCode, l = 38, h = 40, t = 37, e = 39;
      if (![l, h, t, e].includes(r)) return;
      const n = s.target.id, o = /cell_(\d+)_(\d+)_vue-ui-table-(\d+)/, d = n.match(o), y = parseInt(d[1]), m = parseInt(d[2]), p = document.getElementById(`cell_${y}_${m + 1}_${this.uid}`), C = document.getElementById(`cell_${y}_${m - 1}_${this.uid}`), L = document.getElementById(`cell_${y + 1}_${m}_${this.uid}`), A = document.getElementById(`cell_${y - 1}_${m}_${this.uid}`);
      let v;
      switch (!0) {
        case r === e:
          v = p;
          break;
        case r === t:
          v = C;
          break;
        case r === l:
          v = A;
          break;
        case r === h:
          v = L;
          break;
        default:
          return;
      }
      v && (v.focus(), v.scrollIntoView({ behavior: "smooth", block: "center" }));
    },
    openDonutOptions() {
      this.selectedDonutCategory = this.availableDonutCategories[0], this.showDonutOptions = !0;
    },
    placeLabelOnTopOrBottom({ previousPlot: s, currentPlot: r, nextPlot: l }) {
      const h = r.y - 38, t = r.y + 16;
      return s && l ? s.value < r.value && l.value < r.value ? h : s.value > r.value && l.value > r.value ? t : (s.value > r.value && l.value < r.value || s.value < r.value && l.value > r.value, h) : s && !l ? s.value > r.value ? t : h : !s && l && l.value > r.value ? t : h;
    },
    async prepareBodyCopy() {
      return new Promise((s) => {
        const r = [];
        this.tableHead.forEach((l, h) => {
          if (l.isSearch && Object.assign(this.searches, { [h]: "" }), l.isMultiselect && Object.assign(this.multiselects, { [h]: this.getDropdownOptions(h) }), l.type === this.constants.DATE && (Object.assign(this.dates, { [h]: this.getDatesRange(h) }), Object.assign(this.filteredDatesIndexes, { [h]: !1 })), (l.isPercentage || l.percentageTo) && Object.assign(this.percentages, { [h]: {
            reference: l.percentageTo,
            referenceIndex: this.dataset.header.map((t) => t.name).indexOf(l.percentageTo)
          } }), l.rangeFilter && (Object.assign(this.rangeFilters, { [h]: {
            min: Math.round(Math.min(...this.dataset.body.map((t) => t.td).map((t) => t[h]))),
            max: Math.round(Math.max(...this.dataset.body.map((t) => t.td).map((t) => t[h])))
          } }), Object.assign(this.immutableRangeFilters, { [h]: {
            min: Math.round(Math.min(...this.dataset.body.map((t) => t.td).map((t) => t[h]))),
            max: Math.round(Math.max(...this.dataset.body.map((t) => t.td).map((t) => t[h])))
          } })), l.isPercentage) {
            const t = this.dataset.header.map((n) => n.name).indexOf(l.percentageTo), e = this.dataset.body.map((n) => n.td[t]).reduce((n, o) => n + o, 0);
            r.push([h, t, e]);
          }
          l.type === this.constants.NUMERIC && !l.isPercentage && Object.assign(this.hasNaN, { [h]: this.includesNaN(this.dataset.body.map((t) => Number(t.td[h]))) });
        }), this.bodyCopy.forEach((l, h) => {
          r.map((t) => {
            const [e, n, o] = t;
            l.td[e] = l.td[n] / o;
          }), l.td.forEach((t, e) => {
            this.dataset.header[e].type === this.constants.TEXT && this.dataset.header[e].isSearch && (l[e] = this.stringToNumber(t)), this.dataset.header[e].type === this.constants.DATE && (l[e] = new Date(t).getTime()), this.dataset.header[e].type === this.constants.NUMERIC && (l[e] = isNaN(Number(t)) ? e : t), this.tableBody[h][e] = l[e];
          });
        }), s(!0);
      });
    },
    promiseWithAsyncFunction(s, r) {
      return new Promise((l, h) => {
        s().then((t) => {
          try {
            const e = r(t);
            l(e);
          } catch (e) {
            h(e);
          }
        }).catch((t) => {
          h(t);
        });
      });
    },
    resetDates(s) {
      this.dates[s] = {
        from: this.getDatesRange(s).from,
        to: this.getDatesRange(s).to
      }, this.filteredDatesIndexes[s] = !1, this.$forceUpdate(), this.filterBody();
    },
    resetFilter(s, r, l) {
      const h = l.currentTarget;
      clearTimeout(this.buttonTimeout), h.classList.add("clicked"), this.buttonTimeout = setTimeout(() => {
        h.classList.remove("clicked");
      }, 200), this.currentFilter = void 0, r.rangeFilter && (this.rangeFilters[s].min = this.immutableRangeFilters[s].min, this.rangeFilters[s].max = this.immutableRangeFilters[s].max), r.isMultiselect ? (this.multiselects[s] = this.getDropdownOptions(s), r.type === this.constants.TEXT && (this.sorts[s] = void 0), r.isSearch && (this.searches[s] = "")) : r.type === this.constants.NUMERIC ? this.sorts[s] = void 0 : r.type === this.constants.TEXT ? (this.sorts[s] = void 0, this.searches[s] = "") : r.type === this.constants.DATE && (this.sorts[s] = void 0), this.filterBody();
    },
    resetSelection() {
      const s = document.getElementsByClassName(`tr_${this.uid}`);
      Array.from(s).forEach((r) => {
        Array.from(r.getElementsByTagName("td")).forEach((l) => {
          l.dataset.row === "even" ? (l.style.background = this.FINAL_CONFIG.style.rows.even.backgroundColor, l.style.color = this.FINAL_CONFIG.style.rows.even.color) : (l.style.background = this.FINAL_CONFIG.style.rows.odd.backgroundColor, l.style.color = this.FINAL_CONFIG.style.rows.odd.color);
        });
      }), Array.from(s).forEach((r) => r.dataset.selected = "false"), this.currentPage > this.pages.length - 1 && (this.currentPage = this.pages.length - 1), this.showChart = !1, this.currentDonut = void 0, this.selectedColumn = void 0, this.chart.type = this.constants.BAR, this.currentSelectionSpan = {
        col: void 0,
        rows: []
      }, this.clientX = 100, this.clientY = 100;
    },
    selectColumn(s) {
      this.currentSelectionSpan.col !== s ? (this.visibleRows.forEach((r, l) => {
        this.selectTd({
          td: r.td[s],
          rowIndex: l,
          colIndex: s,
          headerType: this.constants.NUMERIC,
          event: {
            currentTarget: document.getElementById(`cell_${l}_${s}_${this.uid}`)
          }
        });
      }), this.selectedColumn = s) : (this.selectedColumn = void 0, this.resetSelection());
    },
    selectDropdownOption(s, r) {
      this.multiselects[r].includes(s) ? this.multiselects[r] = this.multiselects[r].filter((l) => l !== s) : this.multiselects[r].push(s), this.$forceUpdate(), this.filterBody();
    },
    selectTd({ td: s, rowIndex: r, colIndex: l, headerType: h, event: t }) {
      if (h !== this.constants.NUMERIC || isNaN(Number(s))) {
        this.resetSelection();
        return;
      }
      this.currentSelectionSpan.col !== l && this.resetSelection();
      const e = t.currentTarget.parentNode;
      this.currentSelectionSpan.col = l, this.currentSelectionSpan.rows.map((n) => n.index).includes(r) ? (e.dataset.selected = "false", this.currentSelectionSpan.rows = this.currentSelectionSpan.rows.filter((n) => n.index !== r), t.currentTarget.classList.remove(this.cssClass.CELL), Array.from(e.children).forEach((n, o) => {
        n.dataset.row === "even" ? (n.style.background = this.FINAL_CONFIG.style.rows.even.backgroundColor, n.style.color = this.FINAL_CONFIG.style.rows.even.olor) : (n.style.background = this.FINAL_CONFIG.style.rows.odd.backgroundColor, n.style.color = this.FINAL_CONFIG.style.rows.odd.color);
      }), t.currentTarget.dataset.row === "even" ? (t.currentTarget.style.background = this.FINAL_CONFIG.style.rows.even.backgroundColor, t.currentTarget.style.color = this.FINAL_CONFIG.style.rows.even.color) : (t.currentTarget.style.background = this.FINAL_CONFIG.style.rows.odd.backgroundColor, t.currentTarget.style.color = this.FINAL_CONFIG.style.rows.odd.color)) : (e.dataset.selected = "true", this.currentSelectionSpan.rows.push({
        index: r,
        value: s
      }), Array.from(e.children).forEach((n, o) => {
        n.dataset.row === "even" ? (n.style.background = this.FINAL_CONFIG.style.rows.even.selectedNeighbors.backgroundColor, n.style.color = this.FINAL_CONFIG.style.rows.even.selectedNeighbors.color) : (n.style.background = this.FINAL_CONFIG.style.rows.odd.selectedNeighbors.backgroundColor, n.style.color = this.FINAL_CONFIG.style.rows.odd.selectedNeighbors.color);
      }), t.currentTarget.dataset.row === "odd" ? (t.currentTarget.style.background = this.FINAL_CONFIG.style.rows.odd.selectedCell.backgroundColor, t.currentTarget.style.color = this.FINAL_CONFIG.style.rows.odd.selectedCell.color) : (t.currentTarget.style.background = this.FINAL_CONFIG.style.rows.even.selectedCell.backgroundColor, t.currentTarget.style.color = this.FINAL_CONFIG.style.rows.even.selectedCell.color)), this.currentSelectionSpan.rows = this.currentSelectionSpan.rows.sort((n, o) => n.index - o.index), this.chart.type === this.constants.DONUT && this.currentSelectionSpan.rows.length > 0 && this.applyDonutOption();
    },
    setFilterDatesIndexes(s) {
      this.filteredDatesIndexes[s] = !(this.getDatesRange(s).from === this.dates[s].from && this.getDatesRange(s).to === this.dates[s].to);
    },
    sortBody() {
      this.resetSelection(), Object.keys(this.rangeFilters).forEach((s) => {
        this.filterByRange(this.bodyCopy, s);
      }), Object.keys(this.sorts).forEach((s) => {
        this.sortByNumber(this.bodyCopy, s);
      }), this.currentFilter !== void 0 && this.sortByNumber(this.bodyCopy, this.currentFilter), this.dataset.header.forEach((s, r) => {
        if (s.isPercentage) {
          const l = this.percentages[r].referenceIndex, h = this.bodyCopy.map((t) => t.td[l]).reduce((t, e) => t + e, 0);
          this.bodyCopy.forEach((t) => {
            t.td[r] = t.td[l] / h;
          });
        }
      }), this.currentPage > this.pages.length - 1 && (this.currentPage = this.pages.length - 1), [-1].includes(this.currentPage) && (this.currentPage = 0), this.$forceUpdate();
    },
    filterByRange(s, r) {
      this.bodyCopy = s.filter((l) => l.td[r] >= this.rangeFilters[r].min && l[r] <= this.rangeFilters[r].max);
    },
    sortByNumber(s, r) {
      if (this.sorts[r] === this.constants.ASC && (s = s.sort((l, h) => l[r] - h[r])), this.sorts[r] === this.constants.DESC)
        s = s.sort((l, h) => h[r] - l[r]);
      else
        return 0;
    },
    sortTh(s, r) {
      this.currentFilter = s;
      const l = r.currentTarget;
      clearTimeout(this.buttonTimeout), l.classList.add("clicked"), this.buttonTimeout = setTimeout(() => {
        l.classList.remove("clicked");
      }, 200), this.sorts[s] === 1 ? this.sorts[s] = this.constants.DESC : this.sorts[s] = this.constants.ASC, this.sortBody();
    },
    stringToNumber(s) {
      let r = 0;
      for (let l = 0; l < s.length; l += 1)
        r += s.charCodeAt(l);
      return r;
    },
    toggleMultiselect(s, r, l) {
      const h = l.currentTarget;
      clearTimeout(this.buttonTimeout), h.classList.add("clicked"), this.buttonTimeout = setTimeout(() => {
        h.classList.remove("clicked");
      }, 200);
      const t = document.getElementById(`th_dropdown_${s}`);
      t.dataset.isOpen === "false" ? t.dataset.isOpen = "true" : t.dataset.isOpen = "false";
    },
    updateCurrentPage(s) {
      this.resetSelection(), this.currentPage = Number(s.target.value);
    },
    // DONUTS
    calcDonutMarkerConnectorColor(s) {
      return s.proportion * 100 > 3 ? s.color : "transparent";
    },
    calcDonutMarkerLabelPositionX(s) {
      return s.center.endX + this.calcMarkerOffset(s, 50);
    },
    calcMarkerOffset(s, r) {
      return s.center.endX - r >= 0 ? 3 : -2;
    },
    displayArcPercentage(s, r) {
      return isNaN(s.value / this.sumValues(r)) ? 0 : (s.value / this.sumValues(r) * 100).toFixed(0) + "%";
    },
    isArcBigEnough(s) {
      return s.proportion * 100 > 3;
    },
    sumValues(s) {
      return [...s].map((r) => r.value).reduce((r, l) => r + l, 0);
    },
    // CHART DRAGGING METHODS
    closeDragElement() {
      document.onmouseup = null, document.onmousemove = null;
    },
    dragMouseDown(s) {
      s = s || window.event, s.preventDefault(), document.onmouseup = this.closeDragElement, document.onmousemove = this.elementDrag;
    },
    elementDrag(s) {
      this.rafId || (this.rafId = window.requestAnimationFrame(() => this.onElementDrag(s)));
    },
    onElementDrag(s) {
      s = s || window.event, s.preventDefault();
      const l = this.$refs.chartModal.getBoundingClientRect();
      this.clientX = s.clientX - l.width / 2, this.clientY = s.clientY - l.height / 2, this.rafId = null;
    }
  }
}, F = (s) => (U("data-v-5a108fbd"), s = s(), V(), s), W = { class: "vue-ui-table-export-hub" }, Y = ["innerHTML"], K = ["data-is-open"], Z = /* @__PURE__ */ F(() => /* @__PURE__ */ a("b", { class: "vue-ui-table-export-hub-title" }, " Export ", -1)), q = { class: "vue-ui-table-export-hub-options" }, J = { class: "vue-ui-table-export-hub-option-wrapper" }, Q = { class: "label" }, $ = ["innerHTML"], ee = { class: "vue-ui-table-export-hub-option-wrapper" }, te = { class: "label" }, se = ["innerHTML"], re = { class: "vue-ui-table" }, ne = { id: "tableHead" }, le = /* @__PURE__ */ F(() => /* @__PURE__ */ a("th", { class: "invisible-cell" }, null, -1)), oe = { key: 0 }, ae = { key: 0 }, ie = { key: 1 }, ce = /* @__PURE__ */ F(() => /* @__PURE__ */ a("th", { class: "invisible-cell" }, null, -1)), ue = {
  key: 0,
  style: { display: "flex", "align-items": "center", "justify-content": "flex-end" }
}, he = ["innerHTML"], de = {
  key: 0,
  style: { "margin-left": "3px" }
}, ge = /* @__PURE__ */ F(() => /* @__PURE__ */ a("th", { class: "invisible-cell" }, null, -1)), ye = { key: 0 }, Ne = /* @__PURE__ */ F(() => /* @__PURE__ */ a("th", { class: "invisible-cell" }, null, -1)), be = { class: "th-filter" }, me = {
  key: 0,
  class: "th-date"
}, fe = { class: "date-wrapper--inputs" }, _e = { class: "date-fieldset" }, Ce = ["for"], Ie = ["id", "onUpdate:modelValue", "onInput"], Fe = { class: "date-fieldset" }, ve = ["for"], ke = ["id", "onUpdate:modelValue", "onInput"], pe = { class: "date-wrapper--button" }, we = ["onClick"], Se = ["innerHTML"], Oe = ["innerHTML"], Le = ["innerHTML"], Ae = ["onClick", "disabled"], De = ["placeholder", "onUpdate:modelValue", "name"], xe = ["onClick"], Ge = ["innerHTML"], Me = ["innerHTML"], Te = ["innerHTML"], Ee = ["onClick", "innerHTML"], ze = ["innerHTML"], Be = {
  key: 5,
  class: "th-range-filter"
}, He = ["for"], Pe = /* @__PURE__ */ F(() => /* @__PURE__ */ a("span", { style: { color: "grey" } }, "ᒥ", -1)), Re = /* @__PURE__ */ F(() => /* @__PURE__ */ a("span", { style: { color: "grey" } }, "ᒣ", -1)), Ue = ["id", "max", "min", "onUpdate:modelValue"], Ve = ["id", "max", "min", "onUpdate:modelValue"], je = ["for"], Xe = /* @__PURE__ */ F(() => /* @__PURE__ */ a("span", { style: { color: "grey" } }, "ᒪ", -1)), We = /* @__PURE__ */ F(() => /* @__PURE__ */ a("span", { style: { color: "grey" } }, "ᒧ", -1)), Ye = ["onClick", "disabled"], Ke = ["id"], Ze = ["onClick"], qe = ["onClick", "onKeyup"], Je = /* @__PURE__ */ F(() => /* @__PURE__ */ a("th", { class: "invisible-cell" }, null, -1)), Qe = ["innerHTML", "onClick", "onKeyup"], $e = ["data-row"], et = ["data-row"], tt = ["data-row", "onClick", "onKeyup", "id"], st = ["innerHTML"], rt = { key: 1 }, nt = { key: 2 }, lt = { key: 5 }, ot = ["innerHTML"], at = { key: 0 }, it = { style: { "margin-left": "12px" } }, ct = { class: "format-num" }, ut = { style: { "margin-left": "12px" } }, ht = {
  key: 0,
  class: "format-num"
}, dt = {
  key: 1,
  class: "format-num"
}, gt = { key: 2 }, yt = { style: { "margin-left": "12px" } }, Nt = {
  key: 0,
  class: "format-num"
}, bt = {
  key: 1,
  class: "format-num"
}, mt = { key: 2 }, ft = {
  key: 0,
  class: "vue-ui-table-paginator format-num"
}, _t = {
  key: 1,
  class: "vue-ui-table-size-warning"
}, Ct = ["innerHTML"], It = {
  key: 3,
  class: "vue-ui-table-pagination format-num"
}, Ft = ["innerHTML", "disabled"], vt = ["disabled"], kt = {
  key: 0,
  class: "vue-ui-table-page-scroller-wrapper"
}, pt = {
  for: "pageScroller",
  style: { "font-size": "14px" }
}, wt = ["max", "value"], St = { key: 1 }, Ot = ["disabled"], Lt = ["innerHTML", "disabled"], At = { class: "chart-modal-options" }, Dt = ["innerHTML"], xt = ["innerHTML"], Gt = ["innerHTML"], Mt = { style: { "margin-bottom": "12px" } }, Tt = { key: 0 }, Et = { key: 1 }, zt = {
  style: { width: "100%", height: "fit-content", cursor: "move" },
  ref: "chartModal"
}, Bt = { class: "vue-ui-table-fieldset" }, Ht = { class: "vue-ui-table-fieldset-wrapper" }, Pt = ["name", "id", "checked", "onInput"], Rt = ["for"], Ut = ["disabled"], Vt = ["innerHTML"], jt = ["viewBox"], Xt = ["markerWidth", "markerHeight", "refY"], Wt = ["points", "fill"], Yt = ["x2", "y1", "y2", "stroke", "stroke-width"], Kt = ["y2", "stroke", "stroke-width"], Zt = ["x", "width", "height", "fill"], qt = /* @__PURE__ */ R('<linearGradient id="barGradientSelected" x2="0%" y2="100%" data-v-5a108fbd><stop offset="0.2" stop-color="#6376DD" data-v-5a108fbd></stop><stop offset="1" stop-color="#6376DD80" data-v-5a108fbd></stop></linearGradient><linearGradient id="barGradientSelectedNeg" x2="0%" y2="100%" data-v-5a108fbd><stop offset="0.2" stop-color="#6376DD80" data-v-5a108fbd></stop><stop offset="1" stop-color="#6376DD" data-v-5a108fbd></stop></linearGradient><linearGradient id="barGradient" x2="0%" y2="100%" data-v-5a108fbd><stop offset="0.2" stop-color="#6376DDB3" data-v-5a108fbd></stop><stop offset="1" stop-color="#6376DD66" data-v-5a108fbd></stop></linearGradient><linearGradient id="barGradientNeg" x2="0%" y2="100%" data-v-5a108fbd><stop offset="0.2" stop-color="#6376DD66" data-v-5a108fbd></stop><stop offset="1" stop-color="#6376DDB3" data-v-5a108fbd></stop></linearGradient>', 4), Jt = ["x", "y", "height", "width", "fill", "stroke"], Qt = ["x", "y", "width"], $t = ["x1", "y1", "x2", "y2", "stroke-width", "stroke"], es = ["x1", "y1", "x2", "y2", "stroke", "stroke-width", "stroke-dasharray"], ts = ["cx", "cy", "r", "fill", "stroke", "stroke-width"], ss = ["x", "y", "width"], rs = ["x", "width", "height", "onMouseenter"], ns = ["x1", "y1", "x2", "y2", "stroke", "stroke-width", "stroke-dasharray"], ls = /* @__PURE__ */ F(() => /* @__PURE__ */ a("span", null, "---", -1)), os = ["d", "stroke"], as = ["x", "y"], is = { class: "vue-ui-table-donut-label-name" }, cs = ["fill"], us = ["fill"], hs = ["fill"], ds = ["fill"], gs = { class: "vue-ui-table-donut-legend" };
function ys(s, r, l, h, t, e) {
  return i(), c("div", {
    class: "vue-ui-table-main",
    style: g(`font-family: ${e.FINAL_CONFIG.fontFamily}`)
  }, [
    a("div", W, [
      a("button", {
        onClick: r[0] || (r[0] = (n) => t.isExportRequest = !t.isExportRequest),
        innerHTML: e.icons.export,
        style: g(`background:${e.FINAL_CONFIG.style.exportMenu.backgroundColor};color:${e.FINAL_CONFIG.style.exportMenu.color}`)
      }, null, 12, Y),
      a("div", {
        class: "vue-ui-table-export-hub-dropdown",
        "data-is-open": t.isExportRequest || "false",
        style: g(`background:${e.FINAL_CONFIG.style.exportMenu.backgroundColor};color:${e.FINAL_CONFIG.style.exportMenu.color}`)
      }, [
        Z,
        a("button", {
          class: "close-dropdown",
          onClick: r[1] || (r[1] = (n) => t.isExportRequest = !1),
          style: g(`background:${e.FINAL_CONFIG.style.closeButtons.backgroundColor};color:${e.FINAL_CONFIG.style.closeButtons.color};border-radius:${e.FINAL_CONFIG.style.closeButtons.borderRadius}`)
        }, " ✖ ", 4),
        a("div", q, [
          a("div", J, [
            a("div", Q, u(e.FINAL_CONFIG.translations.exportAllLabel) + " (" + u(t.bodyCopy.length) + ") ", 1),
            a("button", {
              id: "exportAll",
              onClick: r[2] || (r[2] = (n) => e.createXls("all")),
              style: g(`background:${e.FINAL_CONFIG.style.exportMenu.buttons.backgroundColor};color:${e.FINAL_CONFIG.style.exportMenu.buttons.color}`)
            }, [
              a("div", {
                innerHTML: e.icons.fileDownload
              }, null, 8, $),
              a("span", null, u(e.FINAL_CONFIG.translations.exportAllButton), 1)
            ], 4)
          ]),
          a("div", ee, [
            a("div", te, u(e.FINAL_CONFIG.translations.exportPageLabel), 1),
            a("button", {
              id: "exportPage",
              onClick: r[3] || (r[3] = (n) => e.createXls("page")),
              style: g(`background:${e.FINAL_CONFIG.style.exportMenu.buttons.backgroundColor};color:${e.FINAL_CONFIG.style.exportMenu.buttons.color}`)
            }, [
              a("div", {
                innerHTML: e.icons.fileDownload
              }, null, 8, se),
              a("span", null, u(e.FINAL_CONFIG.translations.exportPageButton), 1)
            ], 4)
          ])
        ])
      ], 12, K)
    ]),
    a("div", {
      class: "vue-ui-table__wrapper",
      style: g(`max-height:${e.FINAL_CONFIG.maxHeight}px`),
      ref: "tableWrapper"
    }, [
      a("table", re, [
        a("thead", ne, [
          a("tr", null, [
            le,
            (i(!0), c(b, null, _(t.tableHead, (n, o) => (i(), c("th", {
              key: `thead_${o}`,
              style: g(`overflow: visible;background:${e.FINAL_CONFIG.style.th.backgroundColor};color:${e.FINAL_CONFIG.style.th.color};outline:${e.FINAL_CONFIG.style.th.outline}`),
              class: f({ "th-has-nan": t.hasNaN[o] })
            }, [
              e.hasNumericTypes && ([t.constants.TEXT, t.constants.DATE].includes(n.type) || n.isPercentage) ? (i(), c("span", oe, [
                I(u(n.name) + " ", 1),
                n.isPercentage ? (i(), c("span", ae, " / " + u(n.percentageTo), 1)) : N("", !0)
              ])) : (i(), c("span", ie, u(n.name), 1))
            ], 6))), 128))
          ]),
          e.hasNumericTypes ? (i(), c(b, { key: 0 }, [
            a("tr", null, [
              ce,
              (i(!0), c(b, null, _(t.tableHead, (n, o) => (i(), c("th", {
                key: `thead_${o}`,
                class: f({ "th-numeric": !0, "th-has-nan": t.hasNaN[o] }),
                style: g(`background:${e.FINAL_CONFIG.style.th.backgroundColor};color:${e.FINAL_CONFIG.style.th.color};outline:${e.FINAL_CONFIG.style.th.outline}`)
              }, [
                n.sum && !t.hasNaN[o] ? (i(), c("span", ue, [
                  a("span", {
                    innerHTML: e.icons.sum,
                    style: { "margin-bottom": "-4px", "margin-right": "3px" }
                  }, null, 8, he),
                  I(" " + u(n.prefix) + " " + u(Number(e.getSum(o).toFixed(n.decimals)).toLocaleString()) + " " + u(n.suffix) + " ", 1),
                  t.percentages[o] && n.percentageTo && !n.isPercentage ? (i(), c("span", de, " (" + u(isNaN(e.getSum(o) / e.getSum(t.percentages[o].referenceIndex)) ? "-" : (e.getSum(o) / e.getSum(t.percentages[o].referenceIndex) * 100).toFixed(n.decimals)) + "%) ", 1)) : N("", !0)
                ])) : N("", !0)
              ], 6))), 128))
            ]),
            a("tr", null, [
              ge,
              (i(!0), c(b, null, _(t.tableHead, (n, o) => (i(), c("th", {
                key: `thead_${o}`,
                class: f({ "th-numeric": !0, "th-has-nan": t.hasNaN[o] }),
                style: g(`background:${e.FINAL_CONFIG.style.th.backgroundColor};color:${e.FINAL_CONFIG.style.th.color};outline:${e.FINAL_CONFIG.style.th.outline}`)
              }, [
                n.average && !t.hasNaN[o] ? (i(), c("span", ye, " ~ " + u(n.prefix) + " " + u(isNaN(e.getAverage(o)) ? "" : Number(e.getAverage(o).toFixed(n.decimals)).toLocaleString()) + " " + u(n.suffix), 1)) : N("", !0)
              ], 6))), 128))
            ]),
            a("tr", null, [
              Ne,
              (i(!0), c(b, null, _(t.tableHead, (n, o) => (i(), c("th", {
                key: `thead_${o}`,
                class: f({ "th-has-nan": t.hasNaN[o] }),
                style: g(`background:${e.FINAL_CONFIG.style.th.backgroundColor};color:${e.FINAL_CONFIG.style.th.color};outline:${e.FINAL_CONFIG.style.th.outline}`)
              }, [
                a("div", be, [
                  n.type === t.constants.DATE && t.dates[o] ? (i(), c("div", me, [
                    a("div", fe, [
                      a("div", _e, [
                        a("label", {
                          for: `from_${o}`
                        }, u(e.FINAL_CONFIG.translations.from), 9, Ce),
                        k(a("input", {
                          id: `from_${o}`,
                          type: "date",
                          "onUpdate:modelValue": (d) => t.dates[o].from = d,
                          onInput: (d) => {
                            e.filterBody(), e.setFilterDatesIndexes(o);
                          },
                          style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border}`)
                        }, null, 44, Ie), [
                          [w, t.dates[o].from]
                        ])
                      ]),
                      a("div", Fe, [
                        a("label", {
                          for: `to_${o}`
                        }, u(e.FINAL_CONFIG.translations.to), 9, ve),
                        k(a("input", {
                          id: `to_${o}`,
                          type: "date",
                          "onUpdate:modelValue": (d) => t.dates[o].to = d,
                          onInput: (d) => {
                            e.filterBody(), e.setFilterDatesIndexes(o);
                          },
                          style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border}`)
                        }, null, 44, ke), [
                          [w, t.dates[o].to]
                        ])
                      ])
                    ]),
                    a("div", pe, [
                      n.isSort ? (i(), c("button", {
                        key: 0,
                        onClick: (d) => e.sortTh(o, d),
                        class: f({ "th-button-active": [t.constants.DESC, t.constants.ASC].includes(t.sorts[o]) }),
                        style: g(`background:${[t.constants.DESC, t.constants.ASC].includes(t.sorts[o]) ? "" : e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${[t.constants.DESC, t.constants.ASC].includes(t.sorts[o]) ? "" : e.FINAL_CONFIG.style.pagination.buttons.color}`)
                      }, [
                        t.sorts[o] === t.constants.ASC ? (i(), c("span", {
                          key: 0,
                          innerHTML: [t.constants.DATE].includes(n.type) ? e.icons.sort09 : e.icons.sortAZ
                        }, null, 8, Se)) : t.sorts[o] === t.constants.DESC ? (i(), c("span", {
                          key: 1,
                          innerHTML: [t.constants.DATE].includes(n.type) ? e.icons.sort90 : e.icons.sortZA
                        }, null, 8, Oe)) : (i(), c("span", {
                          key: 2,
                          innerHTML: e.icons.arrowSort
                        }, null, 8, Le))
                      ], 14, we)) : N("", !0),
                      a("button", {
                        onClick: (d) => {
                          e.resetDates(o), e.resetFilter(o, n, d);
                        },
                        disabled: !t.filteredDatesIndexes[o] && e.isResetDisabled(o, n),
                        class: "th-reset"
                      }, " ✖ ", 8, Ae)
                    ])
                  ])) : N("", !0),
                  n.isSearch ? k((i(), c("input", {
                    key: 1,
                    placeholder: e.FINAL_CONFIG.translations.inputPlaceholder,
                    "onUpdate:modelValue": (d) => t.searches[o] = d,
                    onInput: r[4] || (r[4] = (d) => e.debounce(e.filterBody, 400)),
                    name: `search_${o}`,
                    style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border}`)
                  }, null, 44, De)), [
                    [w, t.searches[o]]
                  ]) : N("", !0),
                  !t.hasNaN[o] && n.isSort && n.type !== t.constants.DATE ? (i(), c("button", {
                    key: 2,
                    onClick: (d) => e.sortTh(o, d),
                    class: f({ "th-button-active": [t.constants.DESC, t.constants.ASC].includes(t.sorts[o]) }),
                    style: g(`background:${[t.constants.DESC, t.constants.ASC].includes(t.sorts[o]) ? "" : e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${[t.constants.DESC, t.constants.ASC].includes(t.sorts[o]) ? "" : e.FINAL_CONFIG.style.pagination.buttons.color}`)
                  }, [
                    t.sorts[o] === t.constants.ASC ? (i(), c("span", {
                      key: 0,
                      innerHTML: [t.constants.NUMERIC].includes(n.type) ? e.icons.sort09 : e.icons.sortZA
                    }, null, 8, Ge)) : t.sorts[o] === t.constants.DESC ? (i(), c("span", {
                      key: 1,
                      innerHTML: [t.constants.NUMERIC].includes(n.type) ? e.icons.sort90 : e.icons.sortAZ
                    }, null, 8, Me)) : (i(), c("span", {
                      key: 2,
                      innerHTML: e.icons.arrowSort
                    }, null, 8, Te))
                  ], 14, xe)) : N("", !0),
                  n.isMultiselect ? (i(), c("button", {
                    key: 3,
                    onClick: (d) => e.toggleMultiselect(o, n, d),
                    innerHTML: e.icons.filter,
                    class: f({ "th-button-active": t.multiselects[o] && t.multiselects[o].length !== e.getDropdownOptions(o).length }),
                    style: g(`background:${t.multiselects[o] && t.multiselects[o].length !== e.getDropdownOptions(o).length ? "" : e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${t.multiselects[o] && t.multiselects[o].length !== e.getDropdownOptions(o).length ? "" : e.FINAL_CONFIG.style.pagination.buttons.color}`)
                  }, null, 14, Ee)) : N("", !0),
                  t.currentSelectionSpan.col === o && e.canChart ? (i(), c("button", {
                    key: 4,
                    onClick: r[5] || (r[5] = (d) => t.showChart = !t.showChart),
                    innerHTML: e.icons.chart,
                    class: f({ "th-button-active": t.showChart }),
                    style: g(`background:${t.showChart ? "" : e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${t.showChart ? "" : e.FINAL_CONFIG.style.pagination.buttons.color}`)
                  }, null, 14, ze)) : N("", !0),
                  n.rangeFilter && t.rangeFilters[o] && !t.hasNaN[o] ? (i(), c("div", Be, [
                    a("label", {
                      for: `rangeMin${o}`
                    }, [
                      Pe,
                      I(" min "),
                      Re
                    ], 8, He),
                    k(a("input", {
                      type: "number",
                      id: `rangeMin${o}`,
                      max: t.immutableRangeFilters[o].max,
                      min: t.immutableRangeFilters[o].min,
                      "onUpdate:modelValue": (d) => t.rangeFilters[o].min = d,
                      onInput: r[6] || (r[6] = (d) => e.debounce(e.filterBody, 400)),
                      style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border}`)
                    }, null, 44, Ue), [
                      [
                        w,
                        t.rangeFilters[o].min,
                        void 0,
                        { number: !0 }
                      ]
                    ]),
                    k(a("input", {
                      type: "number",
                      id: `rangeMax${o}`,
                      max: t.immutableRangeFilters[o].max,
                      min: t.immutableRangeFilters[o].min,
                      "onUpdate:modelValue": (d) => t.rangeFilters[o].max = d,
                      onInput: r[7] || (r[7] = (d) => e.debounce(e.filterBody, 400)),
                      style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border}`)
                    }, null, 44, Ve), [
                      [
                        w,
                        t.rangeFilters[o].max,
                        void 0,
                        { number: !0 }
                      ]
                    ]),
                    a("label", {
                      for: `rangeMax${o}`
                    }, [
                      Xe,
                      I(" max "),
                      We
                    ], 8, je)
                  ])) : N("", !0),
                  e.canResetColumn(o, n) ? (i(), c("button", {
                    key: 6,
                    onClick: (d) => e.resetFilter(o, n, d),
                    disabled: e.isResetDisabled(o, n),
                    class: "th-reset"
                  }, " ✖ ", 8, Ye)) : N("", !0),
                  n.isMultiselect ? (i(), c("div", {
                    key: 7,
                    class: "th-dropdown",
                    "data-is-open": "false",
                    id: `th_dropdown_${o}`,
                    style: g(`background:${e.FINAL_CONFIG.style.dropdowns.backgroundColor};color:${e.FINAL_CONFIG.style.dropdowns.color}`)
                  }, [
                    a("button", {
                      class: "close-dropdown",
                      onClick: (d) => e.toggleMultiselect(o, n, d),
                      style: g(`background:${e.FINAL_CONFIG.style.closeButtons.backgroundColor};color:${e.FINAL_CONFIG.style.closeButtons.color}`)
                    }, " ✖ ", 12, Ze),
                    (i(!0), c(b, null, _(e.getDropdownOptions(o), (d, y) => (i(), c("span", {
                      class: "th-option",
                      key: `th_option_${o}_${y}`,
                      onClick: (m) => e.selectDropdownOption(d, o),
                      onKeyup: [
                        S((m) => e.selectDropdownOption(d, o), ["enter"]),
                        S((m) => e.selectDropdownOption(d, o), ["space"])
                      ],
                      style: g(`opacity:${e.isDropdownOptionSelected(d, o) ? 1 : 0.5}`),
                      tabindex: "0"
                    }, [
                      e.isDropdownOptionSelected(d, o) ? (i(), c("span", {
                        key: 0,
                        style: g(`color:${e.FINAL_CONFIG.style.dropdowns.icons.selected.color};margin-right:5px`),
                        class: "th-icon-green"
                      }, u(e.FINAL_CONFIG.style.dropdowns.icons.selected.unicode), 5)) : (i(), c("span", {
                        key: 1,
                        style: g(`color:${e.FINAL_CONFIG.style.dropdowns.icons.unselected.color};margin-right:5px`),
                        class: "th-icon-red"
                      }, u(e.FINAL_CONFIG.style.dropdowns.icons.unselected.unicode), 5)),
                      a("span", null, u(d), 1)
                    ], 44, qe))), 128))
                  ], 12, Ke)) : N("", !0)
                ])
              ], 6))), 128))
            ])
          ], 64)) : N("", !0),
          a("tr", null, [
            Je,
            (i(!0), c(b, null, _(t.tableHead, (n, o) => (i(), c("th", {
              key: `col_selector_${o}`,
              class: f({ "vue-ui-table-col-selector": !t.hasNaN[o], "th-has-nan": t.hasNaN[o] }),
              style: g(`background:${o === t.selectedColumn && !t.hasNaN[o] ? e.FINAL_CONFIG.style.th.selected.backgroundColor : e.FINAL_CONFIG.style.th.backgroundColor};color:${o === t.selectedColumn && !t.hasNaN[o] ? e.FINAL_CONFIG.style.th.selected.color : e.FINAL_CONFIG.style.th.color};outline:${e.FINAL_CONFIG.style.th.outline}`)
            }, [
              t.hasNaN[o] ? N("", !0) : (i(), c("div", {
                key: 0,
                innerHTML: t.tableHead[o].type === t.constants.NUMERIC ? e.icons.chevronDown : "",
                class: f({ "col-selector": t.tableHead[o].type === t.constants.NUMERIC }),
                tabindex: "0",
                onClick: O((d) => e.selectColumn(o), ["stop"]),
                onKeyup: S((d) => e.selectColumn(o), ["enter"])
              }, null, 42, Qe))
            ], 6))), 128))
          ])
        ]),
        a("tbody", {
          onClick: r[8] || (r[8] = (...n) => e.closeAllDropdowns && e.closeAllDropdowns(...n)),
          onKeydown: r[9] || (r[9] = (n) => e.navigateCell(n))
        }, [
          (i(!0), c(b, null, _(e.visibleRows, (n, o) => (i(), c("tr", {
            key: `tbody_${o}`,
            "data-row": o % 2 === 0 ? "odd" : "even",
            class: f(`tr_${t.uid}`),
            style: g(`${o % 2 === 0 ? `background:${e.FINAL_CONFIG.style.rows.odd.backgroundColor};color:${e.FINAL_CONFIG.style.rows.odd.color}` : `background:${e.FINAL_CONFIG.style.rows.even.backgroundColor};color:${e.FINAL_CONFIG.style.rows.even.color}`}`)
          }, [
            a("td", {
              class: "vue-ui-table-td-iteration",
              "data-row": o % 2 === 0 ? "odd" : "even"
            }, u(n.absoluteIndex + 1), 9, et),
            (i(!0), c(b, null, _(n.td, (d, y) => (i(), c("td", {
              "data-row": o % 2 === 0 ? "odd" : "even",
              key: `td_${o}_${y}`,
              style: g(e.isNumeric(d) || l.dataset.header[y].type === t.constants.DATE ? "text-align:right;font-variant-numeric: tabular-nums;" : ""),
              onClick: (m) => e.selectTd({
                td: d,
                rowIndex: o,
                colIndex: y,
                headerType: l.dataset.header[y].type,
                event: m
              }),
              onKeyup: [
                S((m) => e.selectTd({
                  td: d,
                  rowIndex: o,
                  colIndex: y,
                  headerType: l.dataset.header[y].type,
                  event: m
                }), ["enter"]),
                S((m) => e.selectTd({
                  td: d,
                  rowIndex: o,
                  colIndex: y,
                  headerType: l.dataset.header[y].type,
                  event: m
                }), ["space"])
              ],
              class: f({ "td-numeric": l.dataset.header[y].type === t.constants.NUMERIC, "td-focusable": !0, "td-has-nan": t.hasNaN[y] }),
              id: `cell_${o}_${y}_${t.uid}`,
              tabindex: "0"
            }, [
              n.meta && n.meta.markerIndices.includes(y) && n.meta.unicodeIcon ? (i(), c("span", {
                key: 0,
                style: g(`color:${n.meta.color};margin-right:3px`),
                innerHTML: n.meta.unicodeIcon
              }, null, 12, st)) : N("", !0),
              l.dataset.header[y].type === t.constants.DATE ? (i(), c("span", rt, u(l.dataset.header[y].prefix) + " " + u(new Date(d).toLocaleString().slice(0, 10)) + " " + u(l.dataset.header[y].suffix), 1)) : l.dataset.header[y].isPercentage ? (i(), c("span", nt, u(Number((d * 100).toFixed(l.dataset.header[y].decimals)).toLocaleString()) + "% ", 1)) : t.percentages[y] && l.dataset.header[y].percentageTo && !l.dataset.header[y].isPercentage ? (i(), c("span", {
                key: 3,
                class: f({ "td-nan": isNaN(Number(d)) })
              }, u(l.dataset.header[y].prefix) + " " + u(isNaN(Number(d)) ? `${d} is not ${t.constants.NUMERIC}` : Number(d.toFixed(l.dataset.header[y].decimals)).toLocaleString()) + " " + u(l.dataset.header[y].suffix) + " (" + u(isNaN(Number(d)) ? "" : Number((d / e.getSum(t.percentages[y].referenceIndex) * 100).toFixed(l.dataset.header[y].decimals)).toLocaleString()) + "%) ", 3)) : l.dataset.header[y].type === t.constants.NUMERIC ? (i(), c("span", {
                key: 4,
                class: f({ "td-nan": isNaN(Number(d)) })
              }, u(l.dataset.header[y].prefix) + " " + u(isNaN(Number(d)) ? `${d} is not ${t.constants.NUMERIC}` : Number(d.toFixed(l.dataset.header[y].decimals)).toLocaleString()) + " " + u(l.dataset.header[y].suffix), 3)) : (i(), c("span", lt, u(l.dataset.header[y].prefix) + " " + u(d) + " " + u(l.dataset.header[y].suffix), 1))
            ], 46, tt))), 128))
          ], 14, $e))), 128))
        ], 32)
      ])
    ], 4),
    a("div", {
      class: f({ "td-selector-info": !0, "td-selector-info--active": t.currentSelectionSpan.col !== void 0 && t.currentSelectionSpan.rows.length }),
      style: g(`background:${e.FINAL_CONFIG.style.infoBar.backgroundColor};color:${e.FINAL_CONFIG.style.infoBar.color}`)
    }, [
      t.currentSelectionSpan.col !== void 0 && t.currentSelectionSpan.rows.length ? (i(), c(b, { key: 0 }, [
        a("div", {
          innerHTML: e.icons.table,
          class: "td-selector-icon"
        }, null, 8, ot),
        a("span", null, [
          a("b", null, [
            I(u(l.dataset.header[t.currentSelectionSpan.col].name) + " ", 1),
            l.dataset.header[t.currentSelectionSpan.col].isPercentage ? (i(), c("span", at, " / " + u(l.dataset.header[t.percentages[t.currentSelectionSpan.col].referenceIndex].name), 1)) : N("", !0)
          ]),
          a("span", it, [
            I(u(e.FINAL_CONFIG.translations.nb) + " : ", 1),
            a("b", ct, u(t.currentSelectionSpan.rows.length), 1)
          ]),
          a("span", ut, [
            I(u(e.FINAL_CONFIG.translations.sum) + " : ", 1),
            l.dataset.header[t.currentSelectionSpan.col].isPercentage ? (i(), c("b", ht, u(e.selectedCellsCalculations.sumPercentage), 1)) : (i(), c("b", dt, u(l.dataset.header[t.currentSelectionSpan.col].prefix) + " " + u(e.selectedCellsCalculations.sumRegular) + " " + u(l.dataset.header[t.currentSelectionSpan.col].suffix), 1)),
            l.dataset.header[t.currentSelectionSpan.col].isPercentage ? (i(), c("b", gt, "%")) : N("", !0)
          ]),
          a("span", yt, [
            I(u(e.FINAL_CONFIG.translations.average) + " : ", 1),
            l.dataset.header[t.currentSelectionSpan.col].isPercentage ? (i(), c("b", Nt, u(e.selectedCellsCalculations.averagePercentage), 1)) : (i(), c("b", bt, u(l.dataset.header[t.currentSelectionSpan.col].prefix) + " " + u(e.selectedCellsCalculations.averageRegular) + " " + u(l.dataset.header[t.currentSelectionSpan.col].suffix), 1)),
            l.dataset.header[t.currentSelectionSpan.col].isPercentage ? (i(), c("b", mt, "%")) : N("", !0)
          ])
        ]),
        a("button", {
          onClick: r[10] || (r[10] = (...n) => e.resetSelection && e.resetSelection(...n)),
          class: "td-selector-info-reset",
          style: g(`background:${e.FINAL_CONFIG.style.closeButtons.backgroundColor};color:${e.FINAL_CONFIG.style.closeButtons.color};border-radius:${e.FINAL_CONFIG.style.closeButtons.borderRadius}`)
        }, " ✖ ", 4)
      ], 64)) : N("", !0)
    ], 6),
    t.bodyCopy.length > 10 ? (i(), c("div", ft, [
      I(u(e.FINAL_CONFIG.translations.totalRows) + " : " + u(l.dataset.body.length) + " | " + u(e.FINAL_CONFIG.translations.paginatorLabel) + " : ", 1),
      t.bodyCopy.length > 10 ? k((i(), c("select", {
        key: 0,
        id: "paginatorSelector",
        "onUpdate:modelValue": r[11] || (r[11] = (n) => t.itemsPerPage = n),
        onChange: r[12] || (r[12] = (...n) => e.resetSelection && e.resetSelection(...n)),
        style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border}`)
      }, [
        (i(!0), c(b, null, _(t.paginatorOptions, (n, o) => (i(), c(b, null, [
          t.bodyCopy.length > n || l.dataset.body.length === n ? (i(), c("option", {
            key: `paginator_option_${o}`
          }, u(n), 1)) : N("", !0)
        ], 64))), 256))
      ], 36)), [
        [
          P,
          t.itemsPerPage,
          void 0,
          { number: !0 }
        ]
      ]) : N("", !0)
    ])) : N("", !0),
    t.itemsPerPage >= 250 ? (i(), c("div", _t, [
      a("span", {
        innerHTML: e.icons.warning
      }, null, 8, Ct),
      I(u(e.FINAL_CONFIG.translations.sizeWarning), 1)
    ])) : N("", !0),
    e.pages.length > 1 && e.pages.length <= 10 ? (i(), c("div", {
      key: 2,
      class: "vue-ui-table-navigation-indicator",
      style: g(`background:${e.FINAL_CONFIG.style.pagination.navigationIndicator.backgroundColor};width:calc(${t.currentPage / (e.pages.length - 1) * 100}%)`)
    }, null, 4)) : N("", !0),
    e.pages.length > 1 ? (i(), c("div", It, [
      a("button", {
        class: "vue-ui-table-navigation",
        onClick: r[13] || (r[13] = O((n) => e.navigate("previous"), ["stop"])),
        innerHTML: e.icons.chevronLeft,
        disabled: t.currentPage === 0,
        style: g(`background:${e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${e.FINAL_CONFIG.style.pagination.buttons.color};opacity:${t.currentPage === 0 ? e.FINAL_CONFIG.style.pagination.buttons.opacityDisabled : 1}`)
      }, null, 12, Ft),
      e.pages.length > 3 ? (i(), c(b, { key: 0 }, [
        a("button", {
          class: "vue-ui-table-navigation",
          onClick: r[14] || (r[14] = O((n) => e.navigate(1), ["stop"])),
          disabled: t.currentPage === 0,
          style: g(`background:${e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${e.FINAL_CONFIG.style.pagination.buttons.color};opacity:${t.currentPage === 0 ? e.FINAL_CONFIG.style.pagination.buttons.opacityDisabled : 1}`)
        }, " 1 ", 12, vt),
        e.pages.length > 10 ? (i(), c("div", kt, [
          a("label", pt, u(e.FINAL_CONFIG.translations.page) + " " + u(t.currentPage + 1) + " / " + u(e.pages.length), 1),
          a("input", {
            class: "vue-ui-table-page-scroller",
            id: "pageScroller",
            type: "range",
            step: "1",
            min: 0,
            max: e.pages.length - 1,
            onInput: r[15] || (r[15] = (n) => e.updateCurrentPage(n)),
            value: t.currentPage,
            style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border};accent-color:${e.FINAL_CONFIG.style.inputs.accentColor}`)
          }, null, 44, wt)
        ])) : (i(), c("span", St, u(e.FINAL_CONFIG.translations.page) + " " + u(t.currentPage + 1) + " / " + u(e.pages.length), 1)),
        a("button", {
          class: "vue-ui-table-navigation",
          onClick: r[16] || (r[16] = O((n) => e.navigate(e.pages.length), ["stop"])),
          disabled: t.currentPage === e.pages.length - 1,
          style: g(`background:${e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${e.FINAL_CONFIG.style.pagination.buttons.color};opacity:${t.currentPage === e.pages.length - 1 ? e.FINAL_CONFIG.style.pagination.buttons.opacityDisabled : 1}`)
        }, u(e.pages.length), 13, Ot)
      ], 64)) : (i(), c(b, { key: 1 }, [
        I(u(e.FINAL_CONFIG.translations.page) + " " + u(t.currentPage + 1) + " / " + u(e.pages.length), 1)
      ], 64)),
      a("button", {
        class: "vue-ui-table-navigation",
        onClick: r[17] || (r[17] = O((n) => e.navigate("next"), ["stop"])),
        innerHTML: e.icons.chevronRight,
        disabled: t.currentPage === e.pages.length - 1,
        style: g(`background:${e.FINAL_CONFIG.style.pagination.buttons.backgroundColor};color:${e.FINAL_CONFIG.style.pagination.buttons.color};opacity:${t.currentPage === e.pages.length - 1 ? e.FINAL_CONFIG.style.pagination.buttons.opacityDisabled : 1}`)
      }, null, 12, Lt)
    ])) : N("", !0),
    t.showChart && e.canChart ? (i(), c("div", {
      key: 4,
      class: "vue-ui-table-chart-modal",
      style: g(`top:${t.clientY}px; left:${t.clientX}px;background:${e.FINAL_CONFIG.style.chart.modal.backgroundColor};color:${e.FINAL_CONFIG.style.chart.modal.color}`)
    }, [
      a("button", {
        class: "close-chart-modal",
        onClick: r[18] || (r[18] = (n) => t.showChart = !1),
        style: g(`background:${e.FINAL_CONFIG.style.closeButtons.backgroundColor};color:${e.FINAL_CONFIG.style.closeButtons.color};border-radius:${e.FINAL_CONFIG.style.closeButtons.borderRadius}`)
      }, " ✖ ", 4),
      a("div", At, [
        e.availableDonutCategories.length ? (i(), c("button", {
          key: 0,
          onClick: r[19] || (r[19] = (n) => t.showDonutOptions = !0),
          innerHTML: e.icons.donut,
          class: f({ "is-active-chart": t.chart.type === t.constants.DONUT || t.showDonutOptions }),
          style: g(`background:${t.chart.type === t.constants.DONUT || t.showDonutOptions ? e.FINAL_CONFIG.style.chart.modal.buttons.selected.backgroundColor : e.FINAL_CONFIG.style.chart.modal.buttons.unselected.backgroundColor};color:${t.chart.type === t.constants.DONUT || t.showDonutOptions ? e.FINAL_CONFIG.style.chart.modal.buttons.selected.color : e.FINAL_CONFIG.style.chart.modal.buttons.unselected.color}`)
        }, null, 14, Dt)) : N("", !0),
        a("button", {
          onClick: r[20] || (r[20] = (n) => {
            t.chart.type = t.constants.LINE, t.showDonutOptions = !1;
          }),
          innerHTML: e.icons.chart,
          class: f({ "is-active-chart": t.chart.type === t.constants.LINE && !t.showDonutOptions }),
          style: g(`background:${t.chart.type === t.constants.LINE && !t.showDonutOptions ? e.FINAL_CONFIG.style.chart.modal.buttons.selected.backgroundColor : e.FINAL_CONFIG.style.chart.modal.buttons.unselected.backgroundColor};color:${t.chart.type === t.constants.LINE && !t.showDonutOptions ? e.FINAL_CONFIG.style.chart.modal.buttons.selected.color : e.FINAL_CONFIG.style.chart.modal.buttons.unselected.color}`)
        }, null, 14, xt),
        a("button", {
          onClick: r[21] || (r[21] = (n) => {
            t.chart.type = t.constants.BAR, t.showDonutOptions = !1;
          }),
          innerHTML: e.icons.bar,
          class: f({ "is-active-chart": t.chart.type === t.constants.BAR && !t.showDonutOptions }),
          style: g(`background:${t.chart.type === t.constants.BAR && !t.showDonutOptions ? e.FINAL_CONFIG.style.chart.modal.buttons.selected.backgroundColor : e.FINAL_CONFIG.style.chart.modal.buttons.unselected.backgroundColor};color:${t.chart.type === t.constants.BAR && !t.showDonutOptions ? e.FINAL_CONFIG.style.chart.modal.buttons.selected.color : e.FINAL_CONFIG.style.chart.modal.buttons.unselected.color}`)
        }, null, 14, Gt)
      ]),
      a("div", Mt, [
        a("b", null, [
          I(u(l.dataset.header[t.currentSelectionSpan.col].name) + " ", 1),
          l.dataset.header[t.currentSelectionSpan.col].isPercentage && l.dataset.header[t.currentSelectionSpan.col].percentageTo ? (i(), c("span", Tt, " / " + u(l.dataset.header[t.percentages[t.currentSelectionSpan.col].referenceIndex].name), 1)) : N("", !0),
          t.chart.type === t.constants.DONUT && t.selectedDonutCategory && t.selectedDonutCategory.name ? (i(), c("span", Et, u(e.FINAL_CONFIG.translations.by) + " " + u(t.selectedDonutCategory.name), 1)) : N("", !0)
        ])
      ]),
      a("div", zt, [
        t.showDonutOptions && e.availableDonutCategories.length ? (i(), c("div", {
          key: 0,
          style: g(`background:${e.FINAL_CONFIG.style.chart.modal.backgroundColor};color:${e.FINAL_CONFIG.style.chart.modal.color}`)
        }, [
          a("fieldset", Bt, [
            a("legend", null, u(e.FINAL_CONFIG.translations.chooseCategoryColumn), 1),
            a("div", Ht, [
              (i(!0), c(b, null, _(e.availableDonutCategories, (n, o) => (i(), c("div", {
                key: `donut_radio_${o}`,
                class: "vue-ui-table-fieldset-option"
              }, [
                a("input", {
                  type: "radio",
                  name: n.name,
                  id: n.name,
                  checked: t.selectedDonutCategory && n.name === t.selectedDonutCategory.name,
                  onInput: (d) => t.selectedDonutCategory = e.availableDonutCategories[o],
                  style: g(`background:${e.FINAL_CONFIG.style.inputs.backgroundColor};color:${e.FINAL_CONFIG.style.inputs.color};border:${e.FINAL_CONFIG.style.inputs.border};accent-color:${e.FINAL_CONFIG.style.inputs.accentColor}`)
                }, null, 44, Pt),
                a("label", {
                  for: n.name
                }, u(n.name), 9, Rt)
              ]))), 128))
            ]),
            a("button", {
              class: "vue-ui-table-generate-donut",
              disabled: !t.selectedDonutCategory,
              onClick: r[22] || (r[22] = (...n) => e.applyDonutOption && e.applyDonutOption(...n)),
              style: g(`background:${e.FINAL_CONFIG.style.chart.modal.buttons.selected.backgroundColor};color:${e.FINAL_CONFIG.style.chart.modal.buttons.selected.color}`)
            }, [
              a("div", {
                style: { "margin-bottom": "-3px" },
                innerHTML: e.icons.donut
              }, null, 8, Vt),
              I(" " + u(e.FINAL_CONFIG.translations.makeDonut), 1)
            ], 12, Ut)
          ])
        ], 4)) : N("", !0),
        [t.constants.BAR, t.constants.LINE].includes(t.chart.type) && !t.showDonutOptions ? (i(), c(b, { key: 1 }, [
          (i(), c("svg", {
            viewBox: `0 0 ${t.chart.width} ${t.chart.height}`,
            class: "vue-ui-table-chart-svg",
            style: g(`background:${e.FINAL_CONFIG.style.chart.layout.backgroundColor}`)
          }, [
            a("defs", null, [
              a("marker", {
                id: "arrowhead",
                markerWidth: e.FINAL_CONFIG.style.chart.layout.progression.arrowSize,
                markerHeight: e.FINAL_CONFIG.style.chart.layout.progression.arrowSize,
                refX: "0",
                refY: e.FINAL_CONFIG.style.chart.layout.progression.arrowSize / 2,
                orient: "auto"
              }, [
                a("polygon", {
                  points: `0 0, ${e.FINAL_CONFIG.style.chart.layout.progression.arrowSize} ${e.FINAL_CONFIG.style.chart.layout.progression.arrowSize / 2}, 0 ${e.FINAL_CONFIG.style.chart.layout.progression.arrowSize}`,
                  fill: e.FINAL_CONFIG.style.chart.layout.progression.stroke
                }, null, 8, Wt)
              ], 8, Xt)
            ]),
            a("g", null, [
              a("line", {
                x1: 0,
                x2: t.chart.width,
                y1: e.chartData.zero,
                y2: e.chartData.zero,
                stroke: e.FINAL_CONFIG.style.chart.layout.axis.stroke,
                "stroke-width": e.FINAL_CONFIG.style.chart.layout.axis.strokeWidth,
                "stroke-linecap": "round"
              }, null, 8, Yt),
              a("line", {
                x1: 0,
                x2: 0,
                y1: 0,
                y2: t.chart.height,
                stroke: e.FINAL_CONFIG.style.chart.layout.axis.stroke,
                "stroke-width": e.FINAL_CONFIG.style.chart.layout.axis.strokeWidth,
                "stroke-linecap": "round"
              }, null, 8, Kt)
            ]),
            t.chart.type === t.constants.LINE ? (i(!0), c(b, { key: 0 }, _(e.chartData.plots, (n, o) => (i(), c("g", {
              key: `trap_fill_${o}`
            }, [
              a("rect", {
                x: o * e.chartData.slot,
                y: 0,
                width: e.chartData.slot,
                height: t.chart.height,
                fill: t.selectedPlot === o ? "rgba(0,0,0,0.03)" : "transparent"
              }, null, 8, Zt)
            ]))), 128)) : N("", !0),
            (i(!0), c(b, null, _(e.chartData.plots, (n, o) => (i(), c("g", {
              key: `plot_${o}`
            }, [
              t.chart.type === t.constants.BAR ? (i(), c(b, { key: 0 }, [
                qt,
                a("rect", {
                  x: n.x - e.chartData.slot / 2,
                  y: e.chartData.isAllNegative ? 0 : e.calcRectY(n.value, n.y),
                  height: n.value >= 0 ? e.chartData.zero - n.y : e.chartData.isAllNegative ? n.y : n.y - e.chartData.zero,
                  width: e.chartData.slot,
                  fill: e.FINAL_CONFIG.style.chart.layout.bar.fill ? e.FINAL_CONFIG.style.chart.layout.bar.fill : t.selectedPlot === o ? n.value >= 0 ? "url(#barGradientSelected)" : "url(#barGradientSelectedNeg)" : (n.value >= 0, "url(#barGradient)"),
                  stroke: e.FINAL_CONFIG.style.chart.layout.bar.stroke,
                  "stroke-width": "1"
                }, null, 8, Jt),
                t.selectedPlot === o ? (i(), c("foreignObject", {
                  key: 0,
                  x: n.x - (e.chartData.slot < 100 ? 50 : e.chartData.slot / 2),
                  y: n.value >= 0 ? n.y - 32 : n.y + 4,
                  height: "20",
                  width: e.chartData.slot < 100 ? 100 : e.chartData.slot,
                  style: { overflow: "visible" }
                }, [
                  a("div", {
                    style: g(`width:100%;text-align:center;font-size:20px;color:${e.FINAL_CONFIG.style.chart.layout.labels.color}`)
                  }, u(n.prefix) + " " + u(Number(n.value.toFixed(l.dataset.header[t.currentSelectionSpan.col].decimals)).toLocaleString()) + " " + u(n.suffix), 5)
                ], 8, Qt)) : N("", !0)
              ], 64)) : N("", !0),
              t.chart.type === t.constants.LINE ? (i(), c(b, { key: 1 }, [
                o + 1 < e.chartData.plots.length ? (i(), c("line", {
                  key: 0,
                  x1: n.x,
                  y1: n.y,
                  x2: e.chartData.plots[o + 1].x,
                  y2: e.chartData.plots[o + 1].y,
                  "stroke-width": e.FINAL_CONFIG.style.chart.layout.line.strokeWidth,
                  stroke: e.FINAL_CONFIG.style.chart.layout.line.stroke
                }, null, 8, $t)) : N("", !0),
                t.selectedPlot === o ? (i(), c("line", {
                  key: 1,
                  x1: n.x,
                  y1: n.y,
                  x2: n.x,
                  y2: t.chart.height,
                  stroke: e.FINAL_CONFIG.style.chart.layout.line.selector.stroke,
                  "stroke-width": e.FINAL_CONFIG.style.chart.layout.line.selector.strokeWidth,
                  "stroke-dasharray": e.FINAL_CONFIG.style.chart.layout.line.selector.strokeDasharray
                }, null, 8, es)) : N("", !0),
                a("circle", {
                  cx: n.x,
                  cy: n.y,
                  r: t.selectedPlot === o ? e.FINAL_CONFIG.style.chart.layout.line.plot.radius.selected : e.FINAL_CONFIG.style.chart.layout.line.plot.radius.unselected,
                  fill: e.FINAL_CONFIG.style.chart.layout.line.plot.fill,
                  stroke: e.FINAL_CONFIG.style.chart.layout.line.plot.stroke,
                  "stroke-width": e.FINAL_CONFIG.style.chart.layout.line.plot.strokeWidth
                }, null, 8, ts),
                t.selectedPlot === o ? (i(), c("foreignObject", {
                  key: 2,
                  x: n.x - (e.chartData.slot < 100 ? 50 : e.chartData.slot / 2),
                  y: e.placeLabelOnTopOrBottom({
                    previousPlot: e.chartData.plots[o - 1],
                    currentPlot: n,
                    nextPlot: e.chartData.plots[o + 1]
                  }),
                  height: "20",
                  width: e.chartData.slot < 100 ? 100 : e.chartData.slot,
                  style: { overflow: "visible" }
                }, [
                  a("div", {
                    style: g(`width:100%;text-align:center;font-size:20px;color:${e.FINAL_CONFIG.style.chart.layout.labels.color}`)
                  }, u(n.prefix) + " " + u(Number(n.value.toFixed(l.dataset.header[t.currentSelectionSpan.col].decimals)).toLocaleString()) + " " + u(n.suffix), 5)
                ], 8, ss)) : N("", !0)
              ], 64)) : N("", !0)
            ]))), 128)),
            (i(!0), c(b, null, _(e.chartData.plots, (n, o) => (i(), c("g", {
              key: `trap_${o}`
            }, [
              a("rect", {
                x: o * e.chartData.slot,
                y: 0,
                width: e.chartData.slot,
                height: t.chart.height,
                fill: "transparent",
                onMouseenter: (d) => t.selectedPlot = o,
                onMouseleave: r[23] || (r[23] = (d) => t.selectedPlot = void 0)
              }, null, 40, rs)
            ]))), 128)),
            e.chartData.progression && e.chartData.plots.length > 2 ? (i(), c("line", {
              key: 1,
              x1: e.chartData.progression.x1,
              y1: e.chartData.progression.y1,
              x2: e.chartData.progression.x2,
              y2: e.chartData.progression.y2,
              stroke: e.FINAL_CONFIG.style.chart.layout.progression.stroke,
              "stroke-width": e.FINAL_CONFIG.style.chart.layout.progression.strokeWidth,
              "stroke-dasharray": e.FINAL_CONFIG.style.chart.layout.progression.strokeDasharray,
              "marker-end": "url(#arrowhead)"
            }, null, 8, ns)) : N("", !0)
          ], 12, jt)),
          e.chartData.plots.length >= 2 ? (i(), c("div", {
            key: 0,
            class: "chart-trend",
            style: g(`color:${e.FINAL_CONFIG.style.chart.modal.color}`)
          }, [
            ls,
            I(" Trend: " + u((e.chartData.progression.trend * 100).toFixed(1)) + " % ", 1)
          ], 4)) : N("", !0)
        ], 64)) : N("", !0),
        [t.constants.DONUT].includes(t.chart.type) && !t.showDonutOptions ? (i(), c(b, { key: 2 }, [
          (i(), c("svg", {
            viewBox: "0 0 100 100",
            style: g(`max-width:100%; overflow: visible; padding: 0 24px;background:${e.FINAL_CONFIG.style.chart.layout.backgroundColor}`),
            class: "vue-ui-table-donut-chart"
          }, [
            (i(!0), c(b, null, _(t.currentDonut, (n, o) => (i(), c("path", {
              key: `arc_${o}`,
              d: n.path,
              stroke: `${n.color}CC`,
              "stroke-width": 20,
              fill: "none"
            }, null, 8, os))), 128)),
            (i(!0), c(b, null, _(t.currentDonut, (n, o) => (i(), c("foreignObject", {
              key: `text_marker_${o}`,
              x: e.calcDonutMarkerLabelPositionX(n) - 15,
              y: n.center.endY - 15,
              height: "30",
              width: "30",
              style: { overflow: "visible", display: "flex", "align-items": "center", "justify-content": "center" }
            }, [
              e.isArcBigEnough(n) ? (i(), c("div", {
                key: 0,
                class: "vue-ui-table-donut-label",
                style: g(`color:${e.FINAL_CONFIG.style.chart.layout.labels.color}`)
              }, [
                a("b", null, u(e.displayArcPercentage(n, t.currentDonut)), 1),
                a("span", is, u(n.name), 1)
              ], 4)) : N("", !0)
            ], 8, as))), 128)),
            a("text", {
              x: 50,
              y: 42,
              "text-anchor": "middle",
              "font-size": "6",
              fill: e.FINAL_CONFIG.style.chart.layout.labels.color
            }, u(e.FINAL_CONFIG.translations.total), 9, cs),
            a("text", {
              x: 50,
              y: 48,
              "text-anchor": "middle",
              "font-size": "4",
              fill: e.FINAL_CONFIG.style.chart.layout.labels.color
            }, u(l.dataset.header[t.currentSelectionSpan.col].prefix) + " " + u(e.donutHollowLabels.total) + " " + u(l.dataset.header[t.currentSelectionSpan.col].isPercentage ? "%" : "") + " " + u(l.dataset.header[t.currentSelectionSpan.col].suffix), 9, us),
            a("text", {
              x: 50,
              y: 56,
              "text-anchor": "middle",
              "font-size": "6",
              fill: e.FINAL_CONFIG.style.chart.layout.labels.color
            }, u(e.FINAL_CONFIG.translations.average), 9, hs),
            a("text", {
              x: 50,
              y: 62,
              "text-anchor": "middle",
              "font-size": "4",
              fill: e.FINAL_CONFIG.style.chart.layout.labels.color
            }, u(l.dataset.header[t.currentSelectionSpan.col].prefix) + " " + u(e.donutHollowLabels.average) + " " + u(l.dataset.header[t.currentSelectionSpan.col].isPercentage ? "%" : "") + " " + u(l.dataset.header[t.currentSelectionSpan.col].suffix), 9, ds)
          ], 4)),
          a("div", gs, [
            (i(!0), c(b, null, _(t.currentDonut.filter((n) => n.value > 0), (n, o) => (i(), c("div", {
              class: "vue-ui-table-donut-legend-item",
              key: `donut_legend_${o}`,
              style: g(`color:${e.FINAL_CONFIG.style.chart.layout.labels.color}`)
            }, [
              a("span", {
                style: g(`color:${n.color}`)
              }, "●", 4),
              a("span", null, u(n.name) + " : ", 1),
              a("b", null, u(l.dataset.header[t.currentSelectionSpan.col].prefix) + " " + u(e.getDonutLegendValue(n.absoluteValue)) + " " + u(l.dataset.header[t.currentSelectionSpan.col].isPercentage ? "%" : "") + " " + u(l.dataset.header[t.currentSelectionSpan.col].suffix), 1),
              a("span", null, "(" + u((n.proportion * 100).toFixed(1)) + "%)", 1)
            ], 4))), 128))
          ])
        ], 64)) : N("", !0)
      ], 512)
    ], 4)) : N("", !0)
  ], 4);
}
const fs = /* @__PURE__ */ j(X, [["render", ys], ["__scopeId", "data-v-5a108fbd"]]);
export {
  fs as default
};
