/*!
 * vue-datetime v1.0.0-beta.10
 * (c) 2019 Mario Juárez
 * Released under the MIT License.
 */

!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("luxon")):"function"==typeof define&&define.amd?define(["exports","luxon"],e):e(t.VueDatetime=t.VueDatetime||{},t.luxon)}(this,function(t,e){"use strict";function i(t){return t.charAt(0).toUpperCase()+t.slice(1)}function n(t){var i=e.DateTime.fromISO(t).toUTC();return i.isValid?i:null}function a(t,e,i){return t&&i<t||e&&i>e}function s(){return e.Info.months().map(function(t){return i(t)})}function r(t){return t<10?"0"+t:t}function o(t){return t.startOf("day")}function u(t){t.component("datetime",c)}var m=function(t,e){void 0===t&&(t=[]),void 0===e&&(e=null),this.flow=t,this.endStatus=e,this.diversionNext=null};m.prototype.step=function(t){return this.flow.length>t?this.flow[t]:this.endStatus},m.prototype.first=function(){return this.step(0)},m.prototype.next=function(t){if(this.diversionNext){var e=this.diversionNext;return this.diversionNext=null,e}return this.step(this.flow.indexOf(t)+1)},m.prototype.diversion=function(t){this.diversionNext=t};var c={render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime"},[t._t("before"),t._v(" "),i("input",t._g(t._b({staticClass:"vdatetime-input",class:t.inputClass,style:t.inputStyle,attrs:{id:t.inputId,type:"text"},domProps:{value:t.inputValue},on:{click:t.open,focus:t.open}},"input",t.$attrs,!1),t.$listeners)),t._v(" "),t.hiddenName?i("input",{attrs:{type:"hidden",name:t.hiddenName},domProps:{value:t.value},on:{input:t.setValue}}):t._e(),t._v(" "),t._t("after"),t._v(" "),i("transition-group",{attrs:{name:"vdatetime-fade",tag:"div"}},[t.isOpen?i("div",{key:"overlay",staticClass:"vdatetime-overlay",on:{click:function(e){if(e.target!==e.currentTarget)return null;t.cancel(e)}}}):t._e(),t._v(" "),t.isOpen?i("datetime-popup",{key:"popup",attrs:{type:t.type,datetime:t.popupDate,phrases:t.phrases,"use12-hour":t.use12Hour,"hour-step":t.hourStep,"minute-step":t.minuteStep,"min-datetime":t.popupMinDatetime,"max-datetime":t.popupMaxDatetime,auto:t.auto,"week-start":t.weekStart,flow:t.flow,title:t.title},on:{confirm:t.confirm,cancel:t.cancel},scopedSlots:t._u([{key:"button-cancel__internal",fn:function(e){return[t._t("button-cancel",[t._v(t._s(t.phrases.cancel))],{step:e.step})]}},{key:"button-confirm__internal",fn:function(e){return[t._t("button-confirm",[t._v(t._s(t.phrases.ok))],{step:e.step})]}}])}):t._e()],1)],2)},staticRenderFns:[],components:{DatetimePopup:{render:function(){var t=this.$createElement,e=this._self._c||t;return e("div",{staticClass:"vdatetime-popup"},[e("div",{staticClass:"vdatetime-popup__header"},[this.title?e("div",{staticClass:"vdatetime-popup__title"},[this._v(this._s(this.title))]):this._e(),this._v(" "),"time"!==this.type?e("div",{staticClass:"vdatetime-popup__year",on:{click:this.showYear}},[this._v(this._s(this.year))]):this._e(),this._v(" "),"time"!==this.type?e("div",{staticClass:"vdatetime-popup__date",on:{click:this.showMonth}},[this._v(this._s(this.dateFormatted))]):this._e()]),this._v(" "),e("div",{staticClass:"vdatetime-popup__body"},["year"===this.step?e("datetime-year-picker",{attrs:{"min-date":this.minDatetimeUTC,"max-date":this.maxDatetimeUTC,year:this.year},on:{change:this.onChangeYear}}):this._e(),this._v(" "),"month"===this.step?e("datetime-month-picker",{attrs:{"min-date":this.minDatetimeUTC,"max-date":this.maxDatetimeUTC,year:this.year,month:this.month},on:{change:this.onChangeMonth}}):this._e(),this._v(" "),"date"===this.step?e("datetime-calendar",{attrs:{year:this.year,month:this.month,day:this.day,"min-date":this.minDatetimeUTC,"max-date":this.maxDatetimeUTC,"week-start":this.weekStart},on:{change:this.onChangeDate}}):this._e(),this._v(" "),"time"===this.step?e("datetime-time-picker",{attrs:{hour:this.hour,minute:this.minute,"use12-hour":this.use12Hour,"hour-step":this.hourStep,"minute-step":this.minuteStep,"min-time":this.minTime,"max-time":this.maxTime},on:{change:this.onChangeTime}}):this._e()],1),this._v(" "),e("div",{staticClass:"vdatetime-popup__actions"},[e("div",{staticClass:"vdatetime-popup__actions__button vdatetime-popup__actions__button--cancel",on:{click:this.cancel}},[this._t("button-cancel__internal",[this._v(this._s(this.phrases.cancel))],{step:this.step})],2),this._v(" "),e("div",{staticClass:"vdatetime-popup__actions__button vdatetime-popup__actions__button--confirm",on:{click:this.confirm}},[this._t("button-confirm__internal",[this._v(this._s(this.phrases.ok))],{step:this.step})],2)])])},staticRenderFns:[],components:{DatetimeCalendar:{render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime-calendar"},[i("div",{staticClass:"vdatetime-calendar__navigation"},[i("div",{staticClass:"vdatetime-calendar__navigation--previous",on:{click:t.previousMonth}},[i("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 61.3 102.8"}},[i("path",{attrs:{fill:"none",stroke:"#444","stroke-width":"14","stroke-miterlimit":"10",d:"M56.3 97.8L9.9 51.4 56.3 5"}})])]),t._v(" "),i("div",{staticClass:"vdatetime-calendar__current--month"},[t._v(t._s(t.monthName)+" "+t._s(t.newYear))]),t._v(" "),i("div",{staticClass:"vdatetime-calendar__navigation--next",on:{click:t.nextMonth}},[i("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 61.3 102.8"}},[i("path",{attrs:{fill:"none",stroke:"#444","stroke-width":"14","stroke-miterlimit":"10",d:"M56.3 97.8L9.9 51.4 56.3 5"}})])])]),t._v(" "),i("div",{staticClass:"vdatetime-calendar__month"},[t._l(t.weekdays,function(e){return i("div",{staticClass:"vdatetime-calendar__month__weekday"},[t._v(t._s(e))])}),t._v(" "),t._l(t.days,function(e){return i("div",{staticClass:"vdatetime-calendar__month__day",class:{"vdatetime-calendar__month__day--selected":e.selected,"vdatetime-calendar__month__day--disabled":e.disabled},on:{click:function(i){t.selectDay(e)}}},[i("span",[i("span",[t._v(t._s(e.number))])])])})],2)])},staticRenderFns:[],props:{year:{type:Number,required:!0},month:{type:Number,required:!0},day:{type:Number,default:null},disabled:{type:Array},minDate:{type:e.DateTime,default:null},maxDate:{type:e.DateTime,default:null},weekStart:{type:Number,default:1}},data:function(){return{newDate:e.DateTime.fromObject({year:this.year,month:this.month,zone:"UTC"}),weekdays:function(t){--t<0&&(t=6);var n=e.Info.weekdays("short").map(function(t){return i(t)});return n=n.concat(n.splice(0,t))}(this.weekStart),months:s()}},computed:{newYear:function(){return this.newDate.year},newMonth:function(){return this.newDate.month},monthName:function(){return this.months[this.newMonth-1]},days:function(){var t=this;return function(t,i,n){var a=e.DateTime.local(t,i,1),s=a.weekday-n;s<0&&(s+=7);var r=(n-a.weekday-a.daysInMonth)%7;return r<0&&(r+=7),new Array(a.daysInMonth+s+r).fill(null).map(function(t,e){return e+1<=s||e>=s+a.daysInMonth?null:e+1-s})}(this.newYear,this.newMonth,this.weekStart).map(function(i){return{number:i,selected:i&&t.year===t.newYear&&t.month===t.newMonth&&t.day===i,disabled:!i||function(t,i,n,a,s){var r=e.DateTime.fromObject({year:n,month:a,day:s,zone:"UTC"});return t=t?o(t):null,i=i?o(i):null,t&&r<t||i&&r>i}(t.minDate,t.maxDate,t.newYear,t.newMonth,i)}})}},methods:{selectDay:function(t){t.disabled||this.$emit("change",this.newYear,this.newMonth,t.number)},previousMonth:function(){this.newDate=this.newDate.minus({months:1})},nextMonth:function(){this.newDate=this.newDate.plus({months:1})}}},DatetimeTimePicker:{render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{class:{"vdatetime-time-picker":!0,"vdatetime-time-picker__with-suffix":t.use12Hour}},[i("div",{ref:"hourList",staticClass:"vdatetime-time-picker__list vdatetime-time-picker__list--hours"},t._l(t.hours,function(e){return i("div",{staticClass:"vdatetime-time-picker__item",class:{"vdatetime-time-picker__item--selected":e.selected,"vdatetime-time-picker__item--disabled":e.disabled},on:{click:function(i){t.selectHour(e)}}},[t._v(t._s(t.formatHour(e.number)))])})),t._v(" "),i("div",{ref:"minuteList",staticClass:"vdatetime-time-picker__list vdatetime-time-picker__list--minutes"},t._l(t.minutes,function(e){return i("div",{staticClass:"vdatetime-time-picker__item",class:{"vdatetime-time-picker__item--selected":e.selected,"vdatetime-time-picker__item--disabled":e.disabled},on:{click:function(i){t.selectMinute(e)}}},[t._v(t._s(e.number))])})),t._v(" "),t.use12Hour?i("div",{ref:"suffixList",staticClass:"vdatetime-time-picker__list vdatetime-time-picker__list--suffix"},[i("div",{staticClass:"vdatetime-time-picker__item",class:{"vdatetime-time-picker__item--selected":t.hour<12},on:{click:function(e){t.selectSuffix("am")}}},[t._v("am")]),t._v(" "),i("div",{staticClass:"vdatetime-time-picker__item",class:{"vdatetime-time-picker__item--selected":t.hour>=12},on:{click:function(e){t.selectSuffix("pm")}}},[t._v("pm")])]):t._e()])},staticRenderFns:[],props:{hour:{type:Number,required:!0},minute:{type:Number,required:!0},use12Hour:{type:Boolean,default:!1},hourStep:{type:Number,default:1},minuteStep:{type:Number,default:1},minTime:{type:String,default:null},maxTime:{type:String,default:null}},computed:{hours:function(){var t=this;return function(t){return new Array(Math.ceil(24/t)).fill(null).map(function(e,i){return i*t})}(this.hourStep).filter(function(e){return!t.use12Hour||(t.hour<12?e<12:e>=12)}).map(function(e){return{number:r(e),selected:e===t.hour,disabled:a(t.minHour,t.maxHour,e)}})},minutes:function(){var t=this;return function(t){return new Array(Math.ceil(60/t)).fill(null).map(function(e,i){return i*t})}(this.minuteStep).map(function(e){return{number:r(e),selected:e===t.minute,disabled:a(t.minMinute,t.maxMinute,e)}})},minHour:function(){return this.minTime?parseInt(this.minTime.split(":")[0]):null},minMinute:function(){return this.minTime&&this.minHour===this.hour?parseInt(this.minTime.split(":")[1]):null},maxHour:function(){return this.maxTime?parseInt(this.maxTime.split(":")[0]):null},maxMinute:function(){return this.maxTime&&this.maxHour===this.hour?parseInt(this.maxTime.split(":")[1]):null}},methods:{selectHour:function(t){t.disabled||this.$emit("change",{hour:parseInt(t.number)})},selectMinute:function(t){t.disabled||this.$emit("change",{minute:parseInt(t.number)})},selectSuffix:function(t){"am"===t&&this.hour>=12&&this.$emit("change",{hour:parseInt(this.hour-12),suffixTouched:!0}),"pm"===t&&this.hour<12&&this.$emit("change",{hour:parseInt(this.hour+12),suffixTouched:!0})},formatHour:function(t){var e=Number(t);return this.use12Hour?0===e?12:e>12?e-12:e:t}},mounted:function(){var t=this.$refs.hourList.querySelector(".vdatetime-time-picker__item--selected"),e=this.$refs.minuteList.querySelector(".vdatetime-time-picker__item--selected");this.$refs.hourList.scrollTop=t?t.offsetTop-250:0,this.$refs.minuteList.scrollTop=e?e.offsetTop-250:0}},DatetimeYearPicker:{render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime-year-picker"},[i("div",{ref:"yearList",staticClass:"vdatetime-year-picker__list vdatetime-year-picker__list"},t._l(t.years,function(e){return i("div",{staticClass:"vdatetime-year-picker__item",class:{"vdatetime-year-picker__item--selected":e.selected,"vdatetime-year-picker__item--disabled":e.disabled},on:{click:function(i){t.select(e)}}},[t._v(t._s(e.number)+" ")])}))])},staticRenderFns:[],props:{year:{type:Number,required:!0},minDate:{type:e.DateTime,default:null},maxDate:{type:e.DateTime,default:null}},computed:{years:function(){var t=this;return function(t){return new Array(201).fill(null).map(function(e,i){return t-100+i})}(this.year).map(function(e){return{number:e,selected:e===t.year,disabled:!e||function(t,e,i){var n=t?t.year:null,a=e?e.year:null;return n&&i<n||a&&i>a}(t.minDate,t.maxDate,e)}})}},methods:{select:function(t){t.disabled||this.$emit("change",parseInt(t.number))},scrollToCurrent:function(){var t=this.$refs.yearList.querySelector(".vdatetime-year-picker__item--selected");this.$refs.yearList.scrollTop=t?t.offsetTop-250:0}},mounted:function(){this.scrollToCurrent()},updated:function(){this.scrollToCurrent()}},DatetimeMonthPicker:{render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime-month-picker"},[i("div",{ref:"monthList",staticClass:"vdatetime-month-picker__list vdatetime-month-picker__list"},t._l(t.months,function(e){return i("div",{staticClass:"vdatetime-month-picker__item",class:{"vdatetime-month-picker__item--selected":e.selected,"vdatetime-month-picker__item--disabled":e.disabled},on:{click:function(i){t.select(e)}}},[t._v(t._s(e.label)+" ")])}))])},staticRenderFns:[],props:{year:{type:Number,required:!0},month:{type:Number,required:!0},minDate:{type:e.DateTime,default:null},maxDate:{type:e.DateTime,default:null}},computed:{months:function(){var t=this;return s(this.month).map(function(i,n){return{number:++n,label:i,selected:n===t.month,disabled:!n||function(t,i,n,a){return t&&t>e.DateTime.utc(n,a,e.DateTime.utc(n,a).daysInMonth)||i&&i<e.DateTime.utc(n,a,1)}(t.minDate,t.maxDate,t.year,n)}})}},methods:{select:function(t){t.disabled||this.$emit("change",parseInt(t.number))},scrollToCurrent:function(){var t=this.$refs.monthList.querySelector(".vdatetime-month-picker__item--selected");this.$refs.monthList.scrollTop=t?t.offsetTop-250:0}},mounted:function(){this.scrollToCurrent()},updated:function(){this.scrollToCurrent()}}},props:{datetime:{type:e.DateTime,required:!0},phrases:{type:Object,default:function(){return{cancel:"Cancel",ok:"Ok"}}},type:{type:String,default:"date"},use12Hour:{type:Boolean,default:!1},hourStep:{type:Number,default:1},minuteStep:{type:Number,default:1},minDatetime:{type:e.DateTime,default:null},maxDatetime:{type:e.DateTime,default:null},auto:{type:Boolean,default:!1},weekStart:{type:Number,default:1},flow:{type:Array},title:{type:String}},data:function(){var t=this.flow?function(t){return new m(t,"end")}(this.flow):function(t){var e=[];switch(t){case"datetime":e=["date","time"];break;case"time":e=["time"];break;default:e=["date"]}return new m(e,"end")}(this.type);return{newDatetime:this.datetime,flowManager:t,step:t.first(),timePartsTouched:[]}},created:function(){document.addEventListener("keydown",this.onKeyDown)},beforeDestroy:function(){document.removeEventListener("keydown",this.onKeyDown)},computed:{year:function(){return this.newDatetime.year},month:function(){return this.newDatetime.month},day:function(){return this.newDatetime.day},hour:function(){return this.newDatetime.hour},minute:function(){return this.newDatetime.minute},dateFormatted:function(){return this.newDatetime.toLocaleString({month:"long",day:"numeric"})},minDatetimeUTC:function(){return this.minDatetime?this.minDatetime.toUTC():null},maxDatetimeUTC:function(){return this.maxDatetime?this.maxDatetime.toUTC():null},minTime:function(){return this.minDatetime&&this.minDatetime.year===this.year&&this.minDatetime.month===this.month&&this.minDatetime.day===this.day?this.minDatetime.toFormat("HH:mm"):null},maxTime:function(){return this.maxDatetime&&this.maxDatetime.year===this.year&&this.maxDatetime.month===this.month&&this.maxDatetime.day===this.day?this.maxDatetime.toFormat("HH:mm"):null}},methods:{nextStep:function(){this.step=this.flowManager.next(this.step),this.timePartsTouched=[],"end"===this.step&&this.$emit("confirm",this.newDatetime)},showYear:function(){this.step="year",this.flowManager.diversion("date")},showMonth:function(){this.step="month",this.flowManager.diversion("date")},confirm:function(){this.nextStep()},cancel:function(){this.$emit("cancel")},onChangeYear:function(t){this.newDatetime=this.newDatetime.set({year:t}),this.auto&&this.nextStep()},onChangeMonth:function(t){this.newDatetime=this.newDatetime.set({month:t}),this.auto&&this.nextStep()},onChangeDate:function(t,e,i){this.newDatetime=this.newDatetime.set({year:t,month:e,day:i}),this.auto&&this.nextStep()},onChangeTime:function(t){var e=t.hour,i=t.minute;t.suffixTouched&&(this.timePartsTouched.suffix=!0),Number.isInteger(e)&&(this.newDatetime=this.newDatetime.set({hour:e}),this.timePartsTouched.hour=!0),Number.isInteger(i)&&(this.newDatetime=this.newDatetime.set({minute:i}),this.timePartsTouched.minute=!0);this.auto&&this.timePartsTouched.hour&&this.timePartsTouched.minute&&(this.timePartsTouched.suffix||!this.use12Hour)&&this.nextStep()},onKeyDown:function(t){switch(t.keyCode){case 27:case 9:this.cancel();break;case 13:this.nextStep()}}}}},inheritAttrs:!1,props:{value:{type:String},valueZone:{type:String,default:"UTC"},inputId:{type:String,default:""},inputClass:{type:[Object,Array,String],default:""},inputStyle:{type:[Object,Array,String],default:""},hiddenName:{type:String},zone:{type:String,default:"local"},format:{type:[Object,String],default:null},type:{type:String,default:"date"},phrases:{type:Object,default:function(){return{cancel:"Cancel",ok:"Ok"}}},use12Hour:{type:Boolean,default:!1},hourStep:{type:Number,default:1},minuteStep:{type:Number,default:1},minDatetime:{type:String,default:null},maxDatetime:{type:String,default:null},auto:{type:Boolean,default:!1},weekStart:{type:Number,default:function(){return function(){var t;try{t=require("weekstart")}catch(e){t=window.weekstart}var i=t?t.getWeekStartByLocale(e.Settings.defaultLocale):1;return 0===i?7:i}()}},flow:{type:Array},title:{type:String}},data:function(){return{isOpen:!1,datetime:n(this.value)}},watch:{value:function(t){this.datetime=n(t)}},created:function(){this.emitInput()},computed:{inputValue:function(){var t=this.format;if(!t)switch(this.type){case"date":t=e.DateTime.DATE_MED;break;case"time":t=e.DateTime.TIME_24_SIMPLE;break;case"datetime":case"default":t=e.DateTime.DATETIME_MED}return"string"==typeof t?this.datetime?e.DateTime.fromISO(this.datetime).setZone(this.zone).toFormat(t):"":this.datetime?this.datetime.setZone(this.zone).toLocaleString(t):""},popupDate:function(){return this.datetime?this.datetime.setZone(this.zone):this.newPopupDatetime()},popupMinDatetime:function(){return this.minDatetime?e.DateTime.fromISO(this.minDatetime).setZone(this.zone):null},popupMaxDatetime:function(){return this.maxDatetime?e.DateTime.fromISO(this.maxDatetime).setZone(this.zone):null}},methods:{emitInput:function(){var t=this.datetime?this.datetime.setZone(this.valueZone):null;t&&"date"===this.type&&(t=o(t)),this.$emit("input",t?t.toISO():"")},open:function(t){t.target.blur(),this.isOpen=!0},close:function(){this.isOpen=!1,this.$emit("close")},confirm:function(t){this.datetime=t.toUTC(),this.emitInput(),this.close()},cancel:function(){this.close()},newPopupDatetime:function(){var t=e.DateTime.utc().setZone(this.zone).set({seconds:0,milliseconds:0});if(this.popupMinDatetime&&t<this.popupMinDatetime&&(t=this.popupMinDatetime.set({seconds:0,milliseconds:0})),this.popupMaxDatetime&&t>this.popupMaxDatetime&&(t=this.popupMaxDatetime.set({seconds:0,milliseconds:0})),1===this.minuteStep)return t;var i=Math.round(t.minute/this.minuteStep)*this.minuteStep;return 60===i?t.plus({hours:1}).set({minute:0}):t.set({minute:i})},setValue:function(t){this.datetime=n(t.target.value),this.emitInput()}}};"undefined"!=typeof window&&window.Vue&&window.Vue.use(u);t.default=u,t.Datetime=c,t.version="1.0.0-beta.10",Object.defineProperty(t,"__esModule",{value:!0})});