/*!
 * vue-datetime v1.0.0-beta.2
 * (c) 2018 Mario Juárez
 * Released under the MIT License.
 */

!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("luxon")):"function"==typeof define&&define.amd?define(["exports","luxon"],e):e(t.VueDatetime=t.VueDatetime||{},t.luxon)}(this,function(t,e){"use strict";function i(t){return t.charAt(0).toUpperCase()+t.slice(1)}function n(t){var i=e.DateTime.fromISO(t).toUTC();return i.isValid?i:null}function a(t,e,i){return t&&i<t||e&&i>e}function s(t){return t<10?"0"+t:t}function r(t){return t.startOf("day")}function u(t){t.component("datetime",m)}var o=function(t,e){void 0===t&&(t=[]),void 0===e&&(e=null),this.flow=t,this.endStatus=e,this.diversionNext=null};o.prototype.step=function(t){return this.flow.length>t?this.flow[t]:this.endStatus},o.prototype.first=function(){return this.step(0)},o.prototype.next=function(t){if(this.diversionNext){var e=this.diversionNext;return this.diversionNext=null,e}return this.step(this.flow.indexOf(t)+1)},o.prototype.diversion=function(t){this.diversionNext=t};var m={render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime"},[i("input",t._g(t._b({staticClass:"vdatetime-input",class:t.inputClass,attrs:{type:"text"},domProps:{value:t.inputValue},on:{click:t.open,focus:t.open}},"input",t.$attrs,!1),t.$listeners)),t._v(" "),i("transition-group",{attrs:{name:"vdatetime-fade",tag:"div"}},[t.isOpen?i("div",{key:"overlay",staticClass:"vdatetime-overlay",on:{click:function(e){if(e.target!==e.currentTarget)return null;t.cancel(e)}}}):t._e(),t._v(" "),t.isOpen?i("datetime-popup",{key:"popup",attrs:{type:t.type,datetime:t.popupDate,phrases:t.phrases,"hour-step":t.hourStep,"minute-step":t.minuteStep,"min-datetime":t.popupMinDatetime,"max-datetime":t.popupMaxDatetime,auto:t.auto,"week-start":t.weekStart},on:{confirm:t.confirm,cancel:t.cancel}}):t._e()],1)],1)},staticRenderFns:[],components:{DatetimePopup:{render:function(){var t=this.$createElement,e=this._self._c||t;return e("div",{staticClass:"vdatetime-popup"},[e("div",{staticClass:"vdatetime-popup__header"},[e("div",{staticClass:"vdatetime-popup__year",on:{click:this.showYear}},[this._v(this._s(this.year))]),this._v(" "),e("div",{staticClass:"vdatetime-popup__date"},[this._v(this._s(this.dateFormatted))])]),this._v(" "),e("div",{staticClass:"vdatetime-popup__body"},["year"===this.step?e("datetime-year-picker",{attrs:{year:this.year},on:{change:this.onChangeYear}}):this._e(),this._v(" "),"date"===this.step?e("datetime-calendar",{attrs:{year:this.year,month:this.month,day:this.day,"min-date":this.minDatetime,"max-date":this.maxDatetime,"week-start":this.weekStart},on:{change:this.onChangeDate}}):this._e(),this._v(" "),"time"===this.step?e("datetime-time-picker",{attrs:{hour:this.hour,minute:this.minute,"hour-step":this.hourStep,"minute-step":this.minuteStep,"min-time":this.minTime,"max-time":this.maxTime},on:{change:this.onChangeTime}}):this._e()],1),this._v(" "),e("div",{staticClass:"vdatetime-popup__actions"},[e("div",{staticClass:"vdatetime-popup__actions__button vdatetime-popup__actions__button--cancel",on:{click:this.cancel}},[this._v(this._s(this.phrases.cancel))]),this._v(" "),e("div",{staticClass:"vdatetime-popup__actions__button vdatetime-popup__actions__button--confirm",on:{click:this.confirm}},[this._v(this._s(this.phrases.ok))])])])},staticRenderFns:[],components:{DatetimeCalendar:{render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime-calendar"},[i("div",{staticClass:"vdatetime-calendar__navigation"},[i("div",{staticClass:"vdatetime-calendar__navigation--previous",on:{click:t.previousMonth}},[i("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 61.3 102.8"}},[i("path",{attrs:{fill:"none",stroke:"#444","stroke-width":"14","stroke-miterlimit":"10",d:"M56.3 97.8L9.9 51.4 56.3 5"}})])]),t._v(" "),i("div",{staticClass:"vdatetime-calendar__current--month"},[t._v(t._s(t.monthName)+" "+t._s(t.newYear))]),t._v(" "),i("div",{staticClass:"vdatetime-calendar__navigation--next",on:{click:t.nextMonth}},[i("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 61.3 102.8"}},[i("path",{attrs:{fill:"none",stroke:"#444","stroke-width":"14","stroke-miterlimit":"10",d:"M56.3 97.8L9.9 51.4 56.3 5"}})])])]),t._v(" "),i("div",{staticClass:"vdatetime-calendar__month"},[t._l(t.weekdays,function(e){return i("div",{staticClass:"vdatetime-calendar__month__weekday"},[t._v(t._s(e))])}),t._v(" "),t._l(t.days,function(e){return i("div",{staticClass:"vdatetime-calendar__month__day",class:{"vdatetime-calendar__month__day--selected":e.selected,"vdatetime-calendar__month__day--disabled":e.disabled},on:{click:function(i){t.selectDay(e)}}},[i("span",[i("span",[t._v(t._s(e.number))])])])})],2)])},staticRenderFns:[],props:{year:{type:Number,required:!0},month:{type:Number,required:!0},day:{type:Number,default:null},disabled:{type:Array},minDate:{type:e.DateTime,default:null},maxDate:{type:e.DateTime,default:null},weekStart:{type:Number,default:1}},data:function(){return{newDate:e.DateTime.fromObject({year:this.year,month:this.month,timeZone:"UTC"}),weekdays:function(t){--t<0&&(t=6);var n=e.Info.weekdays("short").map(function(t){return i(t)});return n=n.concat(n.splice(0,t))}(this.weekStart),months:e.Info.months().map(function(t){return i(t)})}},computed:{newYear:function(){return this.newDate.year},newMonth:function(){return this.newDate.month},monthName:function(){return this.months[this.newMonth-1]},days:function(){var t=this;return function(t,i,n){var a=e.DateTime.local(t,i,1),s=a.weekday-n;return s<0&&(s+=7),new Array(a.daysInMonth+s).fill(null).map(function(t,e){return e+1<=s?null:e+1-s})}(this.newYear,this.newMonth,this.weekStart).map(function(i){return{number:i,selected:i&&t.year===t.newYear&&t.month===t.newMonth&&t.day===i,disabled:!i||function(t,i,n,a,s){var u=e.DateTime.fromObject({year:n,month:a,day:s});return t=t?r(t):null,i=i?r(i):null,t&&u<t||i&&u>i}(t.minDate,t.maxDate,t.newYear,t.newMonth,i)}})}},methods:{selectDay:function(t){t.disabled||this.$emit("change",this.newYear,this.newMonth,t.number)},previousMonth:function(){this.newDate=this.newDate.minus({months:1})},nextMonth:function(){this.newDate=this.newDate.plus({months:1})}}},DatetimeTimePicker:{render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime-time-picker"},[i("div",{ref:"hourList",staticClass:"vdatetime-time-picker__list vdatetime-time-picker__list--hours"},t._l(t.hours,function(e){return i("div",{staticClass:"vdatetime-time-picker__item",class:{"vdatetime-time-picker__item--selected":e.selected,"vdatetime-time-picker__item--disabled":e.disabled},on:{click:function(i){t.selectHour(e)}}},[t._v(t._s(e.number))])})),t._v(" "),i("div",{ref:"minuteList",staticClass:"vdatetime-time-picker__list vdatetime-time-picker__list--minutes"},t._l(t.minutes,function(e){return i("div",{staticClass:"vdatetime-time-picker__item",class:{"vdatetime-time-picker__item--selected":e.selected,"vdatetime-time-picker__item--disabled":e.disabled},on:{click:function(i){t.selectMinute(e)}}},[t._v(t._s(e.number))])}))])},staticRenderFns:[],props:{hour:{type:Number,required:!0},minute:{type:Number,required:!0},hourStep:{type:Number,default:1},minuteStep:{type:Number,default:1},minTime:{type:String,default:null},maxTime:{type:String,default:null}},computed:{hours:function(){var t=this;return function(t){return new Array(Math.ceil(24/t)).fill(null).map(function(e,i){return i*t})}(this.hourStep).map(function(e){return{number:s(e),selected:e===t.hour,disabled:a(t.minHour,t.maxHour,e)}})},minutes:function(){var t=this;return function(t){return new Array(Math.ceil(60/t)).fill(null).map(function(e,i){return i*t})}(this.minuteStep).map(function(e){return{number:s(e),selected:e===t.minute,disabled:a(t.minMinute,t.maxMinute,e)}})},minHour:function(){return this.minTime?parseInt(this.minTime.split(":")[0]):null},minMinute:function(){return this.minTime&&this.minHour===this.hour?parseInt(this.minTime.split(":")[1]):null},maxHour:function(){return this.maxTime?parseInt(this.maxTime.split(":")[0]):null},maxMinute:function(){return this.maxTime&&this.maxHour===this.hour?parseInt(this.maxTime.split(":")[1]):null}},methods:{selectHour:function(t){t.disabled||this.$emit("change",{hour:parseInt(t.number)})},selectMinute:function(t){t.disabled||this.$emit("change",{minute:parseInt(t.number)})}},mounted:function(){var t=this.$refs.hourList.querySelector(".vdatetime-time-picker__item--selected"),e=this.$refs.minuteList.querySelector(".vdatetime-time-picker__item--selected");this.$refs.hourList.scrollTop=t?t.offsetTop-250:0,this.$refs.minuteList.scrollTop=e?e.offsetTop-250:0}},DatetimeYearPicker:{render:function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",{staticClass:"vdatetime-year-picker"},[i("div",{ref:"yearList",staticClass:"vdatetime-year-picker__list vdatetime-year-picker__list"},t._l(t.years,function(e){return i("div",{staticClass:"vdatetime-year-picker__item",class:{"vdatetime-year-picker__item--selected":e.selected},on:{click:function(i){t.select(e.number)}}},[t._v(t._s(e.number))])}))])},staticRenderFns:[],props:{year:{type:Number,required:!0}},computed:{years:function(){var t=this;return function(t){return new Array(201).fill(null).map(function(e,i){return t-100+i})}(this.year).map(function(e){return{number:e,selected:e===t.year}})}},methods:{select:function(t){this.$emit("change",parseInt(t))},scrollToCurrent:function(){var t=this.$refs.yearList.querySelector(".vdatetime-year-picker__item--selected");this.$refs.yearList.scrollTop=t?t.offsetTop-250:0}},mounted:function(){this.scrollToCurrent()},updated:function(){this.scrollToCurrent()}}},props:{datetime:{type:e.DateTime,required:!0},phrases:{type:Object,default:function(){return{cancel:"Cancel",ok:"Ok"}}},type:{type:String,default:"date"},hourStep:{type:Number,default:1},minuteStep:{type:Number,default:1},minDatetime:{type:e.DateTime,default:null},maxDatetime:{type:e.DateTime,default:null},auto:{type:Boolean,default:!1},weekStart:{type:Number,default:1}},data:function(){var t=function(t){var e=[];switch(t){case"datetime":e=["date","time"];break;default:e=["date"]}return new o(e,"end")}(this.type);return{newDatetime:this.datetime,flow:t,step:t.first(),timeTouched:!1}},created:function(){document.addEventListener("keydown",this.onKeyDown)},beforeDestroy:function(){document.removeEventListener("keydown",this.onKeyDown)},computed:{year:function(){return this.newDatetime.year},month:function(){return this.newDatetime.month},day:function(){return this.newDatetime.day},hour:function(){return this.newDatetime.hour},minute:function(){return this.newDatetime.minute},dateFormatted:function(){return this.newDatetime.toLocaleString({month:"long",day:"numeric"})},minTime:function(){return this.minDatetime&&this.minDatetime.year===this.year&&this.minDatetime.month===this.month&&this.minDatetime.day===this.day?this.minDatetime.toFormat("HH:mm"):null},maxTime:function(){return this.maxDatetime&&this.maxDatetime.year===this.year&&this.maxDatetime.month===this.month&&this.maxDatetime.day===this.day?this.maxDatetime.toFormat("HH:mm"):null}},methods:{nextStep:function(){this.step=this.flow.next(this.step),this.timeTouched=!1,"end"===this.step&&this.$emit("confirm",this.newDatetime)},showYear:function(){this.step="year",this.flow.diversion("date")},confirm:function(){this.nextStep()},cancel:function(){this.$emit("cancel")},onChangeYear:function(t){this.newDatetime=this.newDatetime.set({year:t}),this.auto&&this.nextStep()},onChangeDate:function(t,e,i){this.newDatetime=this.newDatetime.set({year:t,month:e,day:i}),this.auto&&this.nextStep()},onChangeTime:function(t){var e=t.hour,i=t.minute,n=!1;e&&(this.newDatetime=this.newDatetime.set({hour:e}),n="minute"===this.timeTouched,this.timeTouched="hour"),i&&(this.newDatetime=this.newDatetime.set({minute:i}),n="hour"===this.timeTouched,this.timeTouched="minute"),this.auto&&n&&this.nextStep()},onKeyDown:function(t){switch(t.keyCode){case 27:case 9:this.cancel();break;case 13:this.nextStep()}}}}},props:{value:{type:String},valueZone:{type:String,default:"UTC"},inputClass:{type:String,default:""},zone:{type:String,default:"local"},format:{type:Object,default:null},type:{type:String,default:"date"},phrases:{type:Object,default:function(){return{cancel:"Cancel",ok:"Ok"}}},hourStep:{type:Number,default:1},minuteStep:{type:Number,default:1},minDatetime:{type:String,default:null},maxDatetime:{type:String,default:null},auto:{type:Boolean,default:!1},weekStart:{type:Number,default:function(){return function(){var t;try{t=require("weekstart")}catch(e){t=window.weekstart}var i=t?t.getWeekStartByLocale(e.Settings.defaultLocale):1;return 0===i?7:i}()}}},data:function(){return{isOpen:!1,datetime:n(this.value)}},watch:{value:function(t){this.datetime=n(t)}},created:function(){this.emitInput()},computed:{inputValue:function(){var t=this.format||("date"===this.type?e.DateTime.DATE_MED:e.DateTime.DATETIME_MED);return this.datetime?this.datetime.setZone(this.zone).toLocaleString(t):""},popupDate:function(){return this.datetime?this.datetime.setZone(this.zone):e.DateTime.utc().setZone(this.zone)},popupMinDatetime:function(){return this.minDatetime?e.DateTime.fromISO(this.minDatetime):null},popupMaxDatetime:function(){return this.maxDatetime?e.DateTime.fromISO(this.maxDatetime):null}},methods:{emitInput:function(){var t=this.datetime?this.datetime.setZone(this.valueZone):null;t&&"date"===this.type&&(t=r(this.datetime)),this.$emit("input",t?t.toISO():"")},open:function(t){t.target.blur(),this.isOpen=!0},close:function(){this.isOpen=!1},confirm:function(t){this.datetime=t.toUTC(),this.emitInput(),this.close()},cancel:function(){this.close()}}};"undefined"!=typeof window&&window.Vue&&window.Vue.use(u);t.default=u,t.Datetime=m,t.version="1.0.0-beta.2",Object.defineProperty(t,"__esModule",{value:!0})});