import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'Share2Icon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-share-2"
    }, ctx.data]), [h("circle", {
      attrs: {
        cx: "18",
        cy: "5",
        r: "3"
      }
    }), h("circle", {
      attrs: {
        cx: "6",
        cy: "12",
        r: "3"
      }
    }), h("circle", {
      attrs: {
        cx: "18",
        cy: "19",
        r: "3"
      }
    }), h("line", {
      attrs: {
        x1: "8.59",
        y1: "13.51",
        x2: "15.42",
        y2: "17.49"
      }
    }), h("line", {
      attrs: {
        x1: "15.41",
        y1: "6.51",
        x2: "8.59",
        y2: "10.49"
      }
    })]);
  }
};