import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'UsersIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-users"
    }, ctx.data]), [h("path", {
      attrs: {
        d: "M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"
      }
    }), h("circle", {
      attrs: {
        cx: "9",
        cy: "7",
        r: "4"
      }
    }), h("path", {
      attrs: {
        d: "M23 21v-2a4 4 0 0 0-3-3.87"
      }
    }), h("path", {
      attrs: {
        d: "M16 3.13a4 4 0 0 1 0 7.75"
      }
    })]);
  }
};