import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'WifiOffIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-wifi-off"
    }, ctx.data]), [h("line", {
      attrs: {
        x1: "1",
        y1: "1",
        x2: "23",
        y2: "23"
      }
    }), h("path", {
      attrs: {
        d: "M16.72 11.06A10.94 10.94 0 0 1 19 12.55"
      }
    }), h("path", {
      attrs: {
        d: "M5 12.55a10.94 10.94 0 0 1 5.17-2.39"
      }
    }), h("path", {
      attrs: {
        d: "M10.71 5.05A16 16 0 0 1 22.58 9"
      }
    }), h("path", {
      attrs: {
        d: "M1.42 9a15.91 15.91 0 0 1 4.7-2.88"
      }
    }), h("path", {
      attrs: {
        d: "M8.53 16.11a6 6 0 0 1 6.95 0"
      }
    }), h("line", {
      attrs: {
        x1: "12",
        y1: "20",
        x2: "12.01",
        y2: "20"
      }
    })]);
  }
};