var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
import { defineComponent, computed, createVNode, h, resolveComponent, mergeProps, Fragment, createTextVNode, inject, provide, ref, watch, withModifiers, isVNode, onMounted, onUnmounted, reactive, withDirectives, resolveDirective, getCurrentInstance, Teleport, toRef, nextTick, watchEffect } from "vue";
function toVal(mix) {
  var k, y, str = "";
  if (typeof mix === "string" || typeof mix === "number") {
    str += mix;
  } else if (typeof mix === "object") {
    if (Array.isArray(mix)) {
      for (k = 0; k < mix.length; k++) {
        if (mix[k]) {
          if (y = toVal(mix[k])) {
            str && (str += " ");
            str += y;
          }
        }
      }
    } else {
      for (k in mix) {
        if (mix[k]) {
          str && (str += " ");
          str += k;
        }
      }
    }
  }
  return str;
}
function clsx() {
  var i = 0, tmp, x, str = "";
  while (i < arguments.length) {
    if (tmp = arguments[i++]) {
      if (x = toVal(tmp)) {
        str && (str += " ");
        str += x;
      }
    }
  }
  return str;
}
const computeKeyOnly = (value, className) => {
  return value ? className : "";
};
const computeKeyValue = (value, className) => {
  if (typeof value === "string")
    return `${value} ${className}`;
  return "";
};
const computeKeyOrKeyValue = (value, className) => {
  if (value === true)
    return className;
  if (value === "below")
    return `${className} ${value}`;
  if (typeof value === "string")
    return `${value} ${className}`;
  return "";
};
const computeTextAlignProp = (value) => {
  if (value === "justified")
    return "justified";
  return computeKeyValue(value, "aligned");
};
const computeWidthProp = (value, className) => {
  if (typeof value === "number" && className) {
    return `${numberToEnglish(value)} ${className}`;
  }
  if (typeof value === "number" && !className) {
    return numberToEnglish(value);
  }
  if (typeof value === "string" && value === "equal") {
    return `${value} width`;
  }
  return "";
};
const computeResponsiveProp = (value, className) => {
  if (!value)
    return "";
  return `${numberToEnglish(value)} wide ${className}`;
};
const numberToEnglish = (value) => {
  const englishWords = [
    "one",
    "two",
    "three",
    "four",
    "five",
    "six",
    "seven",
    "eight",
    "nine",
    "ten",
    "eleven",
    "twelve",
    "thirteen",
    "fourteen",
    "fifteen",
    "sixteen"
  ];
  return englishWords[value - 1];
};
var Button = defineComponent({
  name: "SuiButton",
  props: {
    active: Boolean,
    animated: [Boolean, String],
    as: {
      type: String,
      default: "button"
    },
    attached: String,
    basic: Boolean,
    circular: Boolean,
    color: String,
    compact: Boolean,
    disabled: Boolean,
    facebook: Boolean,
    floated: String,
    fluid: Boolean,
    google: Boolean,
    labeled: [Boolean, String],
    labelPosition: String,
    icon: Boolean,
    linkedin: Boolean,
    instagram: Boolean,
    inverted: Boolean,
    loading: Boolean,
    negative: Boolean,
    positive: Boolean,
    primary: Boolean,
    secondary: Boolean,
    size: String,
    telegram: Boolean,
    tertiary: Boolean,
    toggle: Boolean,
    twitter: Boolean,
    vk: Boolean,
    whatsapp: Boolean,
    youtube: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.active, "active"), computeKeyOnly(props.basic, "basic"), computeKeyOnly(props.circular, "circular"), computeKeyOnly(props.compact, "compact"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.facebook, "facebook"), computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.google, "google"), computeKeyOnly(props.icon, "icon"), computeKeyOnly(props.linkedin, "linkedin"), computeKeyOnly(props.instagram, "instagram"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.loading, "loading"), computeKeyOnly(props.negative, "negative"), computeKeyOnly(props.positive, "positive"), computeKeyOnly(props.primary, "primary"), computeKeyOnly(props.secondary, "secondary"), computeKeyOnly(props.telegram, "telegram"), computeKeyOnly(props.tertiary, "tertiary"), computeKeyOnly(props.toggle, "toggle"), computeKeyOnly(props.twitter, "twitter"), computeKeyOnly(props.vk, "vk"), computeKeyOnly(props.whatsapp, "whatsapp"), computeKeyOnly(props.youtube, "youtube"), computeKeyValue(props.attached, "attached"), computeKeyValue(props.floated, "floated"), computeKeyValue(props.labelPosition, "labeled"), computeKeyOrKeyValue(props.animated, "animated"), computeKeyOrKeyValue(props.labeled, "labeled"), "button");
    });
    return {
      computedClass
    };
  },
  render() {
    let elementType = this.as || "div";
    return createVNode(elementType, {
      "class": this.computedClass,
      "role": "button"
    }, {
      default: () => {
        var _a, _b;
        return [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)];
      }
    });
  }
});
var ButtonContent = defineComponent({
  name: "SuiButtonContent",
  props: {
    hidden: Boolean,
    visible: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.hidden, "hidden"), computeKeyOnly(props.visible, "visible"), "content");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var ButtonGroup = defineComponent({
  name: "SuiButtonGroup",
  props: {
    attached: String,
    basic: Boolean,
    color: String,
    icon: Boolean,
    labeled: Boolean,
    size: String,
    vertical: Boolean,
    widths: Number
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.basic, "basic"), computeKeyOnly(props.icon, "icon"), computeKeyOnly(props.labeled, "labeled"), computeKeyOnly(props.vertical, "vertical"), computeKeyValue(props.attached, "attached"), computeWidthProp(props.widths, ""), "buttons");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$G = {
  install(app) {
    app.component(Button.name, Button);
    app.component(ButtonContent.name, ButtonContent);
    app.component(ButtonGroup.name, ButtonGroup);
  }
};
var Container = defineComponent({
  name: "SuiContainer",
  props: {
    fluid: Boolean,
    text: Boolean,
    textAlign: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.text, "text"), computeTextAlignProp(props.textAlign), "container");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$F = {
  install(app) {
    app.component(Container.name, Container);
  }
};
var Divider = defineComponent({
  name: "SuiDivider",
  props: {
    clearing: Boolean,
    fitted: Boolean,
    hidden: Boolean,
    horizontal: Boolean,
    inverted: Boolean,
    section: Boolean,
    textAlign: String,
    vertical: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.clearing, "clearing"), computeKeyOnly(props.fitted, "fitted"), computeKeyOnly(props.hidden, "hidden"), computeKeyOnly(props.horizontal, "horizontal"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.section, "section"), computeKeyOnly(props.vertical, "vertical"), computeKeyValue(props.textAlign, "aligned"), "divider");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$E = {
  install(app) {
    app.component(Divider.name, Divider);
  }
};
var Emoji = defineComponent({
  name: "SuiEmoji",
  props: {
    disabled: Boolean,
    link: Boolean,
    loading: Boolean,
    name: String,
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.size, computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.link, "link"), computeKeyOnly(props.loading, "loading"));
    });
    return { computedClass };
  },
  render() {
    if (this.computedClass) {
      return h("em", {
        class: this.computedClass,
        "data-emoji": this.$props.name
      });
    }
    return h("em", { "data-emoji": this.$props.name });
  }
});
var index$D = {
  install(app) {
    app.component(Emoji.name, Emoji);
  }
};
var Flag = defineComponent({
  name: "SuiFlag",
  props: {
    name: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.name, "flag");
    });
    return { computedClass };
  },
  render() {
    return h("i", { class: this.computedClass });
  }
});
var index$C = {
  install(app) {
    app.component(Flag.name, Flag);
  }
};
var HeaderSubheader = defineComponent({
  name: "SuiHeaderSubheader",
  props: {
    as: String
  },
  setup(props) {
    const elementType = props.as || "div";
    return { elementType };
  },
  render() {
    var _a, _b;
    return h(this.elementType, { class: "sub header" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var Header = defineComponent({
  name: "SuiHeader",
  components: { HeaderSubheader },
  props: {
    as: String,
    attached: [Boolean, String],
    block: Boolean,
    color: String,
    content: String,
    disabled: Boolean,
    dividing: Boolean,
    floated: String,
    icon: Boolean,
    image: Boolean,
    inverted: Boolean,
    size: String,
    sub: Boolean,
    subheader: String,
    textAlign: String
  },
  setup(props) {
    const elementType = props.as || "div";
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.block, "block"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.dividing, "dividing"), computeKeyOnly(props.icon, "icon"), computeKeyOnly(props.image, "image"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.sub, "sub"), computeKeyValue(props.floated, "floated"), computeKeyOrKeyValue(props.attached, "attached"), computeTextAlignProp(props.textAlign), "header");
    });
    return { elementType, computedClass };
  },
  render() {
    var _a, _b;
    let children = [];
    if (this.content)
      children.push(this.content);
    if (this.subheader) {
      children.push(h(HeaderSubheader, {}, this.subheader));
    }
    if (children.length > 0) {
      return h(this.elementType, { class: this.computedClass }, children);
    }
    return h(this.elementType, { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var HeaderContent = defineComponent({
  name: "SuiHeaderContent",
  render() {
    var _a, _b;
    return h("div", { class: "content" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$B = {
  install(app) {
    app.component(Header.name, Header);
    app.component(HeaderContent.name, HeaderContent);
    app.component(HeaderSubheader.name, HeaderSubheader);
  }
};
var Icon = defineComponent({
  name: "SuiIcon",
  props: {
    as: String,
    bordered: Boolean,
    circular: Boolean,
    color: String,
    corner: [Boolean, String],
    disabled: Boolean,
    fitted: Boolean,
    flipped: String,
    inverted: Boolean,
    link: Boolean,
    loading: Boolean,
    name: String,
    rotated: String,
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.color, props.name, props.size, computeKeyOnly(props.bordered, "bordered"), computeKeyOnly(props.circular, "circular"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.fitted, "fitted"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.link, "link"), computeKeyOnly(props.loading, "loading"), computeKeyValue(props.flipped, "flipped"), computeKeyValue(props.rotated, "rotated"), computeKeyOrKeyValue(props.corner, "corner"), "icon");
    });
    return { computedClass };
  },
  render() {
    let elementType = this.$props.as || "i";
    return h(elementType, {
      "aria-hidden": true,
      class: this.computedClass
    });
  }
});
var IconGroup = defineComponent({
  name: "SuiIconGroup",
  props: {
    as: String,
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.size, "icons");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    let elementType = this.$props.as || "i";
    return h(elementType, { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$A = {
  install(app) {
    app.component(Icon.name, Icon);
    app.component(IconGroup.name, IconGroup);
  }
};
const alignments = ["top", "middle", "bottom"];
const useVerticalAlignProps = {
  verticalAlign: {
    type: String,
    validator: (value) => alignments.includes(value)
  }
};
function useVerticalAlignClass(props) {
  const verticalAlignClass = computed(() => {
    if (!props.verticalAlign)
      return null;
    if (alignments.includes(props.verticalAlign)) {
      return `${props.verticalAlign} aligned`;
    } else {
      return null;
    }
  });
  return { verticalAlignClass };
}
const floated = ["left", "right"];
const useFloatedProps = {
  floated: {
    type: String,
    validator: (value) => floated.includes(value)
  }
};
function useFloatedClass(props) {
  const floatedClass = computed(() => {
    if (!props.floated)
      return null;
    if (props.floated === "left" || props.floated === "right") {
      return `${props.floated} floated`;
    } else {
      return null;
    }
  });
  return { floatedClass };
}
var Label = defineComponent({
  name: "SuiLabel",
  props: {
    as: String,
    attached: String,
    basic: Boolean,
    circular: Boolean,
    color: String,
    corner: String,
    empty: Boolean,
    floating: Boolean,
    horizontal: Boolean,
    icon: String,
    image: Boolean,
    inverted: Boolean,
    pointing: [Boolean, String],
    prompt: Boolean,
    ribbon: [Boolean, String],
    size: String,
    tag: Boolean
  },
  setup(props, { slots }) {
    const labelClasses = computed(() => {
      return clsx("ui", props.size, props.color, computeKeyOnly(props.basic, "basic"), computeKeyOnly(props.circular, "circular"), computeKeyOnly(props.empty, "empty"), computeKeyOnly(props.floating, "floating"), computeKeyOnly(props.horizontal, "horizontal"), computeKeyOnly(props.image, "image"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.prompt, "prompt"), computeKeyOnly(props.tag, "tag"), computeKeyValue(props.attached, "attached"), computeKeyValue(props.corner, "corner"), computeKeyOrKeyValue(props.pointing, "pointing"), computeKeyOrKeyValue(props.ribbon, "ribbon"), "label");
    });
    let elementType = props.as || "div";
    if (props.icon) {
      return () => h(elementType, {
        class: labelClasses.value
      }, h(Icon, { name: props.icon }));
    }
    return () => {
      var _a;
      return h(elementType, {
        class: labelClasses.value
      }, (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var LabelDetail = defineComponent({
  name: "SuiLabelDetail",
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": "detail"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var LabelGroup = defineComponent({
  name: "SuiLabelGroup",
  props: {
    basic: Boolean,
    circular: Boolean,
    color: String,
    size: String,
    tag: Boolean
  },
  setup(props, { slots }) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.basic, "basic"), computeKeyOnly(props.circular, "circular"), computeKeyOnly(props.tag, "tag"), "labels");
    });
    return () => {
      var _a;
      return h("div", {
        class: computedClass.value
      }, (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var index$z = {
  install(app) {
    app.component(Label.name, Label);
    app.component(LabelDetail.name, LabelDetail);
    app.component(LabelGroup.name, LabelGroup);
  }
};
var Image = defineComponent({
  name: "SuiImage",
  props: __spreadValues(__spreadValues({
    as: String,
    avatar: Boolean,
    bordered: Boolean,
    centered: Boolean,
    circular: Boolean,
    disabled: Boolean,
    fluid: Boolean,
    hidden: Boolean,
    href: String,
    inline: Boolean,
    label: Object,
    target: String,
    wrapped: Boolean,
    rounded: Boolean,
    size: String,
    spaced: [Boolean, String],
    src: String
  }, useVerticalAlignProps), useFloatedProps),
  setup(props, {
    slots
  }) {
    const {
      verticalAlignClass
    } = useVerticalAlignClass(props);
    const {
      floatedClass
    } = useFloatedClass(props);
    const imageClasses = computed(() => {
      return clsx("ui", props.size, verticalAlignClass.value, floatedClass.value, computeKeyOnly(props.avatar, "avatar"), computeKeyOnly(props.bordered, "bordered"), computeKeyOnly(props.centered, "centered"), computeKeyOnly(props.circular, "circular"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.hidden, "hidden"), computeKeyOnly(props.inline, "inline"), computeKeyOnly(props.rounded, "rounded"), computeKeyOrKeyValue(props.spaced, "spaced"), "image");
    });
    if (props.as === "a" || props.as === "router-link") {
      let elementType = props.as;
      if (props.as === "router-link") {
        elementType = resolveComponent(props.as);
      }
      return () => {
        var _a;
        return h(elementType, {
          class: imageClasses.value,
          href: props.href,
          target: props.target && props.target
        }, h("img", {
          src: props.src
        }, (_a = slots.default) == null ? void 0 : _a.call(slots)));
      };
    }
    if (props.wrapped) {
      return () => {
        var _a;
        return h("div", {
          class: imageClasses.value
        }, h("img", {
          src: props.src
        }, (_a = slots.default) == null ? void 0 : _a.call(slots)));
      };
    }
    if (props.label) {
      return () => h("div", {
        class: imageClasses.value
      }, [h("img", {
        src: props.src
      }), h(Label, __spreadValues({}, props.label))]);
    }
    return () => createVNode("img", {
      "class": imageClasses.value,
      "src": props.src
    }, null);
  }
});
var ImageGroup = defineComponent({
  name: "SuiImageGroup",
  props: {
    size: String
  },
  setup(props, { slots }) {
    const computedClass = computed(() => {
      return clsx("ui", props.size, "images");
    });
    return () => {
      var _a;
      return h("div", {
        class: computedClass.value
      }, (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var index$y = {
  install(app) {
    app.component(Image.name, Image);
    app.component(ImageGroup.name, ImageGroup);
  }
};
var Input = defineComponent({
  name: "SuiInput",
  emits: ["update:modelValue"],
  props: {
    action: String,
    disabled: Boolean,
    error: Boolean,
    fluid: Boolean,
    focus: Boolean,
    icon: String,
    iconPosition: String,
    inverted: Boolean,
    label: String,
    labeled: Boolean,
    loading: Boolean,
    modelValue: String,
    placeholder: String,
    size: String,
    transparent: Boolean
  },
  setup(props, {
    emit
  }) {
    const hasIcon = computed(() => {
      return typeof props.icon === "string" || props.loading;
    });
    const hasLabel = computed(() => {
      return !!props.label || props.labeled;
    });
    const computedClass = computed(() => {
      return clsx("ui", props.size, props.action && "action", computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.error, "error"), computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.focus, "focus"), props.iconPosition, computeKeyOnly(hasIcon.value, "icon"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.loading, "loading"), computeKeyOnly(props.transparent, "transparent"), computeKeyOnly(hasLabel.value, "labeled"), "input");
    });
    const onInput = (event) => emit("update:modelValue", event.target.value);
    return () => createVNode("div", {
      "class": computedClass.value
    }, [props.label && createVNode(Label, null, {
      default: () => [props.label]
    }), createVNode("input", {
      "type": "text",
      "placeholder": props.placeholder,
      "value": props.modelValue,
      "onInput": (event) => onInput(event)
    }, null), hasIcon.value && createVNode(Icon, {
      "name": props.icon || "spinner"
    }, null), props.action && createVNode(Button, null, {
      default: () => [props.action]
    })]);
  }
});
var index$x = {
  install(app) {
    app.component(Input.name, Input);
  }
};
var List = defineComponent({
  name: "SuiList",
  props: {
    animated: Boolean,
    as: String,
    bulleted: Boolean,
    celled: Boolean,
    divided: Boolean,
    floated: String,
    horizontal: Boolean,
    inverted: Boolean,
    ordered: Boolean,
    relaxed: Boolean,
    link: Boolean,
    selection: Boolean,
    verticalAlign: String
  },
  setup(props, { slots }) {
    const listClasses = computed(() => {
      return clsx("ui", computeKeyOnly(props.animated, "animated"), computeKeyOnly(props.bulleted, "bulleted"), computeKeyOnly(props.celled, "celled"), computeKeyOnly(props.divided, "divided"), computeKeyOnly(props.horizontal, "horizontal"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.link, "link"), computeKeyOnly(props.ordered, "ordered"), computeKeyOnly(props.relaxed, "relaxed"), computeKeyOnly(props.selection, "selection"), computeKeyValue(props.verticalAlign, "aligned"), computeKeyValue(props.floated, "floated"), "list");
    });
    let elementType = props.as || "div";
    return () => {
      var _a;
      return h(elementType, {
        class: listClasses.value
      }, (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var ListItem = defineComponent({
  name: "SuiListItem",
  props: {
    active: Boolean,
    as: String,
    disabled: Boolean
  },
  setup(props, { slots }) {
    let elementType = props.as || "div";
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.active, "active"), computeKeyOnly(props.disabled, "disabled"), "item");
    });
    return () => {
      var _a;
      return h(elementType, {
        class: computedClass.value
      }, (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var ListIcon = defineComponent({
  name: "SuiListIcon",
  components: { Icon },
  setup(props, { slots }) {
    return () => {
      var _a;
      return h(resolveComponent(Icon.name), __spreadValues({}, props), (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var ListContent = defineComponent({
  name: "SuiListContent",
  props: {
    verticalAlign: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyValue(props.verticalAlign, "aligned"), "content");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var ListHeader = defineComponent({
  name: "SuiListHeader",
  props: {
    as: {
      type: String,
      default: "div",
      validator: (value) => ["div", "a"].includes(value)
    }
  },
  setup(props, { slots }) {
    return () => {
      var _a;
      return h(props.as, {
        class: "header"
      }, (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var ListDescription = defineComponent({
  name: "SuiListDescription",
  props: {
    as: {
      type: String,
      default: "div",
      validator: (value) => ["div", "a"].includes(value)
    }
  },
  setup(props, { slots }) {
    return () => {
      var _a;
      return h(props.as, {
        class: "description"
      }, (_a = slots.default) == null ? void 0 : _a.call(slots));
    };
  }
});
var ListList = defineComponent({
  name: "SuiListList",
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": "list"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$w = {
  install(app) {
    app.component(List.name, List);
    app.component(ListItem.name, ListItem);
    app.component(ListIcon.name, ListIcon);
    app.component(ListContent.name, ListContent);
    app.component(ListHeader.name, ListHeader);
    app.component(ListDescription.name, ListDescription);
    app.component(ListList.name, ListList);
  }
};
var Loader = defineComponent({
  name: "SuiLoader",
  props: {
    active: Boolean,
    color: String,
    disabled: Boolean,
    fast: Boolean,
    indeterminate: Boolean,
    inline: [Boolean, String],
    inverted: Boolean,
    size: String,
    slow: Boolean,
    text: Boolean
  },
  setup(props, {
    slots
  }) {
    const computedClass = computed(() => {
      var _a;
      return clsx("ui", props.color, props.size, computeKeyOnly(props.active, "active"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.fast, "fast"), computeKeyOnly(props.indeterminate, "indeterminate"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.slow, "slow"), computeKeyOnly(props.text || !!((_a = slots.default) == null ? void 0 : _a.call(slots)), "text"), computeKeyOrKeyValue(props.inline, "inline"), "loader");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$v = {
  install(app) {
    app.component(Loader.name, Loader);
  }
};
var Rail = defineComponent({
  name: "SuiRail",
  props: {
    attached: Boolean,
    close: [Boolean, String],
    dividing: Boolean,
    internal: Boolean,
    position: String,
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.position, props.size, computeKeyOnly(props.attached, "attached"), computeKeyOnly(props.dividing, "dividing"), computeKeyOnly(props.internal, "internal"), computeKeyOrKeyValue(props.close, "close"), "rail");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$u = {
  install(app) {
    app.component(Rail.name, Rail);
  }
};
var Reveal = defineComponent({
  name: "SuiReveal",
  props: {
    active: Boolean,
    animated: String,
    disabled: Boolean,
    instant: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.animated, computeKeyOnly(props.active, "active"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.instant, "instant"), "reveal");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var RevealContent = defineComponent({
  name: "SuiRevealContent",
  props: {
    visible: Boolean,
    hidden: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.visible, "visible"), computeKeyOnly(props.hidden, "hidden"), "content");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$t = {
  install(app) {
    app.component(Reveal.name, Reveal);
    app.component(RevealContent.name, RevealContent);
  }
};
var Segment = defineComponent({
  name: "SuiSegment",
  props: {
    attached: [Boolean, String],
    basic: Boolean,
    circular: Boolean,
    clearing: Boolean,
    color: String,
    compact: Boolean,
    disabled: Boolean,
    fitted: [Boolean, String],
    floated: String,
    inverted: Boolean,
    loading: Boolean,
    padded: [Boolean, String],
    piled: Boolean,
    placeholder: Boolean,
    raised: Boolean,
    secondary: Boolean,
    size: String,
    stacked: Boolean,
    tertiary: Boolean,
    textAlign: String,
    vertical: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.basic, "basic"), computeKeyOnly(props.circular, "circular"), computeKeyOnly(props.clearing, "clearing"), computeKeyOnly(props.compact, "compact"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.loading, "loading"), computeKeyOnly(props.piled, "piled"), computeKeyOnly(props.placeholder, "placeholder"), computeKeyOnly(props.raised, "raised"), computeKeyOnly(props.secondary, "secondary"), computeKeyOnly(props.stacked, "stacked"), computeKeyOnly(props.tertiary, "tertiary"), computeKeyOnly(props.vertical, "vertical"), computeKeyValue(props.floated, "floated"), computeKeyValue(props.textAlign, "aligned"), computeKeyOrKeyValue(props.attached, "attached"), computeKeyOrKeyValue(props.fitted, "fitted"), computeKeyOrKeyValue(props.padded, "padded"), "segment");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var SegmentGroup = defineComponent({
  name: "SuiSegmentGroup",
  props: {
    compact: Boolean,
    horizontal: Boolean,
    piled: Boolean,
    raised: Boolean,
    size: String,
    stacked: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.size, computeKeyOnly(props.compact, "compact"), computeKeyOnly(props.horizontal, "horizontal"), computeKeyOnly(props.piled, "piled"), computeKeyOnly(props.raised, "raised"), computeKeyOnly(props.stacked, "stacked"), "segments");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var SegmentInline = defineComponent({
  name: "SuiSegmentInline",
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": "inline"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$s = {
  install(app) {
    app.component(Segment.name, Segment);
    app.component(SegmentGroup.name, SegmentGroup);
    app.component(SegmentInline.name, SegmentInline);
  }
};
var Step = defineComponent({
  name: "SuiStep",
  props: {
    active: Boolean,
    completed: Boolean,
    disabled: Boolean,
    fluid: Boolean,
    href: String,
    link: Boolean,
    vertical: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.active, "active"), computeKeyOnly(props.completed, "completed"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.link, "link"), computeKeyOnly(props.vertical, "vertical"), "step");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.href) {
      return createVNode("a", {
        "class": this.computedClass,
        "href": this.href
      }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
    }
    return createVNode("div", {
      "class": this.computedClass
    }, [(_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c)]);
  }
});
const numbers = ["one", "two", "three", "four", "five", "six", "seven", "eight"];
var StepGroup = defineComponent({
  name: "SuiStepGroup",
  props: {
    attached: String,
    fluid: Boolean,
    inverted: Boolean,
    ordered: Boolean,
    size: String,
    stackable: String,
    unstackable: Boolean,
    vertical: Boolean,
    widths: Number
  },
  setup(props) {
    const {
      widths
    } = props;
    const computedClass = computed(() => {
      return clsx("ui", widths && numbers[widths - 1], props.size, computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.ordered, "ordered"), computeKeyOnly(props.unstackable, "unstackable"), computeKeyOnly(props.vertical, "vertical"), computeKeyValue(props.attached, "attached"), computeKeyValue(props.stackable, "stackable"), "steps");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var StepContent = defineComponent({
  name: "SuiStepContent",
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": "content"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var StepTitle = defineComponent({
  name: "SuiStepTitle",
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": "title"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var StepDescription = defineComponent({
  name: "SuiStepDescription",
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": "description"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$r = {
  install(app) {
    app.component(Step.name, Step);
    app.component(StepGroup.name, StepGroup);
    app.component(StepContent.name, StepContent);
    app.component(StepTitle.name, StepTitle);
    app.component(StepDescription.name, StepDescription);
  }
};
var elements = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  [Symbol.toStringTag]: "Module",
  Button: index$G,
  Container: index$F,
  Divider: index$E,
  Emoji: index$D,
  Flag: index$C,
  Header: index$B,
  Icon: index$A,
  Image: index$y,
  Input: index$x,
  Label: index$z,
  List: index$w,
  Loader: index$v,
  Rail: index$u,
  Reveal: index$t,
  Segment: index$s,
  Step: index$r
});
var BreadcrumbDivider = defineComponent({
  name: "SuiBreadcrumbDivider",
  props: {
    icon: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.icon, "icon", "divider");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    if (this.icon) {
      return createVNode("i", {
        "aria-hidden": "true",
        "class": this.computedClass
      }, null);
    }
    return createVNode("div", {
      "class": "divider"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var BreadcrumbSection = defineComponent({
  name: "SuiBreadcrumbSection",
  props: {
    active: Boolean,
    href: String,
    link: Boolean,
    to: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.active, "active"), "section");
    });
    const isLink = props.link || !!props.href;
    return {
      computedClass,
      isLink
    };
  },
  render() {
    let elementType = "div";
    if (this.isLink)
      elementType = "a";
    else if (this.to)
      elementType = resolveComponent("router-link");
    const props = {
      href: this.href,
      to: this.to
    };
    return createVNode(elementType, mergeProps({
      "class": this.computedClass
    }, props), {
      default: () => {
        var _a, _b;
        return [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)];
      }
    });
  }
});
var Breadcrumb = defineComponent({
  name: "SuiBreadcrumb",
  props: {
    icon: String,
    inverted: Boolean,
    sections: {
      type: Array,
      default: () => []
    },
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.size, computeKeyOnly(props.inverted, "inverted"), "breadcrumb");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    const renderSections = () => {
      var _a2;
      return (_a2 = this.sections) == null ? void 0 : _a2.map((sec, i) => {
        const sectionProps = {
          active: sec.active,
          href: sec.href,
          link: sec.link,
          to: sec.to
        };
        return createVNode(Fragment, null, [createVNode(BreadcrumbSection, sectionProps, {
          default: () => [sec.content]
        }), this.sections.length !== i + 1 && createVNode(BreadcrumbDivider, {
          "icon": this.icon
        }, {
          default: () => [createTextVNode(" / ")]
        })]);
      });
    };
    return createVNode("div", {
      "class": this.computedClass
    }, [((_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)) || renderSections()]);
  }
});
var index$q = {
  install(app) {
    app.component(Breadcrumb.name, Breadcrumb);
    app.component(BreadcrumbDivider.name, BreadcrumbDivider);
    app.component(BreadcrumbSection.name, BreadcrumbSection);
  }
};
var Form = defineComponent({
  name: "SuiForm",
  props: {
    error: Boolean,
    inverted: Boolean,
    loading: Boolean,
    reply: Boolean,
    success: Boolean,
    unstackable: Boolean,
    warning: Boolean,
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.size, computeKeyOnly(props.error, "error"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.loading, "loading"), computeKeyOnly(props.reply, "reply"), computeKeyOnly(props.success, "success"), computeKeyOnly(props.unstackable, "unstackable"), computeKeyOnly(props.warning, "warning"), "form");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("form", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var FormField = defineComponent({
  name: "SuiFormField",
  props: {
    error: Boolean,
    inline: Boolean,
    label: String,
    placeholder: String,
    required: Boolean,
    type: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.error, "error"), computeKeyOnly(props.inline, "inline"), computeKeyOnly(props.required, "required"), "field");
    });
    const inputType = props.type || "text";
    return {
      computedClass,
      inputType
    };
  },
  render() {
    var _a, _b;
    if (this.label) {
      return createVNode("div", {
        "class": this.computedClass
      }, [createVNode("label", null, [this.label]), createVNode("input", {
        "type": this.inputType,
        "placeholder": this.placeholder
      }, null)]);
    }
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var FormGroup = defineComponent({
  name: "SuiFormGroup",
  props: {
    widths: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyValue(props.widths, "width"), "fields");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var FormTextarea = defineComponent({
  name: "SuiFormTextarea",
  props: {
    label: String,
    placeholder: String
  },
  render() {
    if (this.label) {
      createVNode("div", {
        "class": "field"
      }, [createVNode("label", null, [this.label]), createVNode("textarea", {
        "placeholder": this.placeholder
      }, null)]);
    }
    return createVNode("div", {
      "class": "field"
    }, [createVNode("textarea", {
      "placeholder": this.placeholder
    }, null)]);
  }
});
var index$p = {
  install(app) {
    app.component(Form.name, Form);
    app.component(FormField.name, FormField);
    app.component(FormGroup.name, FormGroup);
    app.component(FormTextarea.name, FormTextarea);
  }
};
var Grid = defineComponent({
  name: "SuiGrid",
  props: {
    celled: [Boolean, String],
    centered: Boolean,
    columns: [Number, String],
    compact: Boolean,
    container: Boolean,
    divided: [Boolean, String],
    doubling: Boolean,
    inverted: Boolean,
    padded: [Boolean, String],
    relaxed: [Boolean, String],
    reversed: String,
    stackable: Boolean,
    textAlign: String,
    verticalAlign: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.container && "container", computeKeyOnly(props.centered, "centered"), computeKeyOnly(props.compact, "compact"), computeKeyOnly(props.doubling, "doubling"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.stackable, "stackable"), computeKeyValue(props.reversed, "reversed"), computeKeyValue(props.verticalAlign, "aligned"), computeKeyOrKeyValue(props.celled, "celled"), computeKeyOrKeyValue(props.divided, "divided"), computeKeyOrKeyValue(props.padded, "padded"), computeKeyOrKeyValue(props.relaxed, "relaxed"), computeTextAlignProp(props.textAlign), computeWidthProp(props.columns, "column"), "grid");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var GridColumn = defineComponent({
  name: "SuiGridColumn",
  props: {
    color: String,
    computer: Number,
    floated: String,
    largeScreen: Number,
    mobile: Number,
    only: String,
    tablet: Number,
    textAlign: String,
    width: Number,
    widescreen: Number
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.color, computeKeyValue(props.floated, "floated"), computeKeyValue(props.only, "only"), computeTextAlignProp(props.textAlign), computeWidthProp(props.width, "wide"), computeResponsiveProp(props.mobile, "mobile"), computeResponsiveProp(props.tablet, "tablet"), computeResponsiveProp(props.computer, "computer"), computeResponsiveProp(props.largeScreen, "large screen"), computeResponsiveProp(props.widescreen, "widescreen"), "column");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var GridRow = defineComponent({
  name: "SuiGridRow",
  props: {
    centered: Boolean,
    color: String,
    columns: Number,
    only: String,
    stretched: Boolean,
    textAlign: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.color, computeKeyOnly(props.centered, "centered"), computeKeyOnly(props.stretched, "stretched"), computeKeyValue(props.only, "only"), computeWidthProp(props.columns, "column"), computeTextAlignProp(props.textAlign), "row");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var index$o = {
  install(app) {
    app.component(Grid.name, Grid);
    app.component(GridColumn.name, GridColumn);
    app.component(GridRow.name, GridRow);
  }
};
var Menu = defineComponent({
  name: "SuiMenu",
  props: {
    attached: [Boolean, String],
    borderless: Boolean,
    color: Boolean,
    compact: Boolean,
    fixed: Boolean,
    floated: [Boolean, String],
    fluid: Boolean,
    icon: [Boolean, String],
    inverted: Boolean,
    pagination: Boolean,
    pointing: Boolean,
    secondary: Boolean,
    size: String,
    stackable: Boolean,
    tabular: [Boolean, String],
    text: Boolean,
    vertical: Boolean,
    widths: Number
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.borderless, "borderless"), computeKeyOnly(props.compact, "compact"), computeKeyOnly(props.fixed, "fixed"), computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.pagination, "pagination"), computeKeyOnly(props.pointing, "pointing"), computeKeyOnly(props.secondary, "secondary"), computeKeyOnly(props.stackable, "stackable"), computeKeyOnly(props.text, "text"), computeKeyOnly(props.vertical, "vertical"), computeKeyOrKeyValue(props.attached, "attached"), computeKeyOrKeyValue(props.floated, "floated"), computeKeyOrKeyValue(props.icon, "icon"), computeKeyOrKeyValue(props.tabular, "tabular"), computeWidthProp(props.widths, "item"), "menu");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var MenuHeader = defineComponent({
  name: "SuiMenuHeader",
  props: {
    as: String,
    content: String
  },
  setup(props, {
    slots
  }) {
    let elementType = props.as || "div";
    return () => createVNode(elementType, {
      "class": "header"
    }, {
      default: () => {
        var _a;
        return [props.content || ((_a = slots.default) == null ? void 0 : _a.call(slots))];
      }
    });
  }
});
var MenuItem = defineComponent({
  name: "SuiMenuItem",
  props: {
    action: Boolean,
    active: Boolean,
    as: String,
    browse: Boolean,
    color: String,
    disabled: Boolean,
    fitted: [Boolean, String],
    header: Boolean,
    icon: Boolean,
    index: Number,
    link: Boolean,
    name: String,
    position: String,
    stackable: Boolean
  },
  setup(props, {
    slots
  }) {
    let elementType = props.as || "a";
    if (props.header) {
      elementType = "div";
    }
    if (props.as === "router-link") {
      elementType = resolveComponent(props.as);
    }
    const computedClass = computed(() => {
      return clsx(props.color, props.position, computeKeyOnly(props.action, "action"), computeKeyOnly(props.active, "active"), computeKeyOnly(props.browse, "browse"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.header, "header"), computeKeyOnly(props.link, "link"), computeKeyOrKeyValue(props.fitted, "fitted"), "item");
    });
    return () => createVNode(elementType, {
      "class": computedClass.value
    }, {
      default: () => {
        var _a;
        return [props.name || ((_a = slots.default) == null ? void 0 : _a.call(slots))];
      }
    });
  }
});
var MenuMenu = defineComponent({
  name: "SuiMenuMenu",
  props: {
    position: String
  },
  setup(props) {
    const { position } = props;
    const computedClass = computed(() => {
      return clsx(position, "menu");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$n = {
  install(app) {
    app.component(Menu.name, Menu);
    app.component(MenuHeader.name, MenuHeader);
    app.component(MenuItem.name, MenuItem);
    app.component(MenuMenu.name, MenuMenu);
  }
};
var Message = defineComponent({
  name: "SuiMessage",
  props: {
    attached: [Boolean, String],
    color: String,
    compact: Boolean,
    content: String,
    header: String,
    error: Boolean,
    floating: Boolean,
    hidden: Boolean,
    icon: Boolean,
    info: Boolean,
    negative: Boolean,
    positive: Boolean,
    size: String,
    success: Boolean,
    visible: Boolean,
    warning: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.compact, "compact"), computeKeyOnly(props.error, "error"), computeKeyOnly(props.floating, "floating"), computeKeyOnly(props.hidden, "hidden"), computeKeyOnly(props.icon, "icon"), computeKeyOnly(props.info, "info"), computeKeyOnly(props.negative, "negative"), computeKeyOnly(props.positive, "positive"), computeKeyOnly(props.success, "success"), computeKeyOnly(props.visible, "visible"), computeKeyOnly(props.warning, "warning"), computeKeyOrKeyValue(props.attached, "attached"), "message");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(this.header || this.content) && createVNode(MessageContent, null, {
      default: () => [createVNode(MessageHeader, null, {
        default: () => [this.header]
      }), createVNode("p", null, [this.content])]
    }), (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var MessageContent = defineComponent({
  name: "SuiMessageContent",
  render() {
    var _a, _b;
    return h("div", { class: "content" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var MessageHeader = defineComponent({
  name: "SuiMessageHeader",
  render() {
    var _a, _b;
    return h("div", { class: "header" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var MessageItem = defineComponent({
  name: "SuiMessageItem",
  render() {
    var _a, _b;
    return h("li", { class: "content" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var MessageList = defineComponent({
  name: "SuiMessageList",
  render() {
    var _a, _b;
    return h("ul", { class: "list" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$m = {
  install(app) {
    app.component(Message.name, Message);
    app.component(MessageContent.name, MessageContent);
    app.component(MessageHeader.name, MessageHeader);
    app.component(MessageItem.name, MessageItem);
    app.component(MessageList.name, MessageList);
  }
};
var Table = defineComponent({
  name: "SuiTable",
  props: {
    attached: [Boolean, String],
    basic: [Boolean, String],
    celled: Boolean,
    collapsing: Boolean,
    color: String,
    columns: Number,
    compact: [Boolean, String],
    definition: Boolean,
    fixed: Boolean,
    inverted: Boolean,
    padded: [Boolean, String],
    selectable: Boolean,
    singleLine: Boolean,
    size: String,
    stackable: Boolean,
    striped: Boolean,
    structured: Boolean,
    unstackable: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.celled, "celled"), computeKeyOnly(props.collapsing, "collapsing"), computeKeyOnly(props.definition, "definition"), computeKeyOnly(props.fixed, "fixed"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.selectable, "selectable"), computeKeyOnly(props.singleLine, "single line"), computeKeyOnly(props.stackable, "stackable"), computeKeyOnly(props.striped, "striped"), computeKeyOnly(props.structured, "structured"), computeKeyOnly(props.unstackable, "unstackable"), computeKeyOrKeyValue(props.attached, "attached"), computeKeyOrKeyValue(props.basic, "basic"), computeKeyOrKeyValue(props.compact, "compact"), computeKeyOrKeyValue(props.padded, "padded"), computeWidthProp(props.columns, "column"), "table");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("table", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var TableBody = defineComponent({
  name: "SuiTableBody",
  render() {
    var _a, _b;
    return h("tbody", {}, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var TableCell = defineComponent({
  name: "SuiTableCell",
  props: {
    active: Boolean,
    collapsing: Boolean,
    color: String,
    disabled: Boolean,
    error: Boolean,
    marked: String,
    negative: Boolean,
    positive: Boolean,
    selectable: Boolean,
    singleLine: Boolean,
    textAlign: String,
    verticalAlign: String,
    warning: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.color, computeKeyOnly(props.active, "active"), computeKeyOnly(props.collapsing, "collapsing"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.error, "error"), computeKeyOnly(props.negative, "negative"), computeKeyOnly(props.positive, "positive"), computeKeyOnly(props.selectable, "selectable"), computeKeyOnly(props.singleLine, "single line"), computeKeyOnly(props.warning, "warning"), computeKeyValue(props.verticalAlign, "aligned"), computeKeyValue(props.marked, "marked"), computeTextAlignProp(props.textAlign));
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.computedClass) {
      return createVNode("td", {
        "class": this.computedClass
      }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
    }
    return createVNode("td", null, [(_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c)]);
  }
});
var TableFooter = defineComponent({
  name: "SuiTableFooter",
  props: {
    fullWidth: Boolean
  },
  setup(props) {
    const { fullWidth } = props;
    const computedClass = computed(() => clsx(computeKeyOnly(fullWidth, "full-width")));
    return { computedClass };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.computedClass) {
      return h("tfoot", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
    }
    return h("tfoot", {}, (_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c));
  }
});
var TableHeader = defineComponent({
  name: "SuiTableHeader",
  props: {
    fullWidth: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.fullWidth, "full-width"));
    });
    return { computedClass };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.computedClass) {
      return h("thead", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
    }
    return h("thead", {}, (_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c));
  }
});
var TableHeaderCell = defineComponent({
  name: "SuiTableHeaderCell",
  props: {
    singleLine: Boolean,
    textAlign: String,
    width: Number
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.singleLine, "single line"), computeKeyValue(props.textAlign, "aligned"), computeWidthProp(props.width, "wide"));
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.computedClass) {
      return createVNode("th", {
        "class": this.computedClass
      }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
    }
    return createVNode("th", null, [(_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c)]);
  }
});
var TableRow = defineComponent({
  name: "SuiTableRow",
  props: {
    active: Boolean,
    color: String,
    disabled: Boolean,
    error: Boolean,
    negative: Boolean,
    positive: Boolean,
    textAlign: String,
    verticalAlign: String,
    warning: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.color, computeKeyOnly(props.active, "active"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.error, "error"), computeKeyOnly(props.negative, "negative"), computeKeyOnly(props.positive, "positive"), computeKeyOnly(props.warning, "warning"), computeKeyValue(props.textAlign, "aligned"), computeKeyValue(props.verticalAlign, "aligned"));
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.computedClass) {
      return createVNode("tr", {
        "class": this.computedClass
      }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
    }
    return createVNode("tr", null, [(_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c)]);
  }
});
var index$l = {
  install(app) {
    app.component(Table.name, Table);
    app.component(TableBody.name, TableBody);
    app.component(TableCell.name, TableCell);
    app.component(TableFooter.name, TableFooter);
    app.component(TableHeader.name, TableHeader);
    app.component(TableHeaderCell.name, TableHeaderCell);
    app.component(TableRow.name, TableRow);
  }
};
var collections = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  [Symbol.toStringTag]: "Module",
  Breadcrumb: index$q,
  Form: index$p,
  Grid: index$o,
  Menu: index$n,
  Message: index$m,
  Table: index$l
});
var Advertisement = defineComponent({
  name: "SuiAdvertisement",
  props: {
    centered: Boolean,
    test: String,
    unit: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.unit, computeKeyOnly(props.centered, "centered"), computeKeyOnly(!!props.test, "test"), "ad");
    });
    return { computedClass };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.$props.test) {
      return h("div", {
        class: this.computedClass,
        "data-text": this.$props.test
      }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
    }
    return h("div", { class: this.computedClass }, (_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c));
  }
});
var index$k = {
  install(app) {
    app.component(Advertisement.name, Advertisement);
  }
};
var Card = defineComponent({
  name: "SuiCard",
  props: {
    centered: Boolean,
    color: String,
    fluid: Boolean,
    horizontal: Boolean,
    href: String,
    link: Boolean,
    raised: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, computeKeyOnly(props.centered, "centered"), computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.horizontal, "horizontal"), computeKeyOnly(props.link, "link"), computeKeyOnly(props.raised, "raised"), "card");
    });
    return { computedClass };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.$props.href || this.$props.link) {
      return h("a", {
        class: this.computedClass,
        href: this.$slots.href
      }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
    }
    return h("div", { class: this.computedClass }, (_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c));
  }
});
var CardContent = defineComponent({
  name: "SuiCardContent",
  props: {
    extra: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.extra, "extra"), "content");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var CardDescription = defineComponent({
  name: "SuiCardDescription",
  props: {
    textAlign: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyValue(props.textAlign, "aligned"), "description");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var CardGroup = defineComponent({
  name: "SuiCardGroup",
  props: {
    centered: Boolean,
    doubling: Boolean,
    inverted: Boolean,
    itemsPerRow: Number,
    stackable: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.centered, "centered"), computeKeyOnly(props.doubling, "doubling"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.stackable, "stackable"), computeWidthProp(props.itemsPerRow, ""), "cards");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var CardHeader = defineComponent({
  name: "SuiCardHeader",
  props: {
    textAlign: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyValue(props.textAlign, "aligned"), "header");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var CardMeta = defineComponent({
  name: "SuiCardMeta",
  render() {
    var _a, _b;
    return h("div", { class: "meta" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$j = {
  install(app) {
    app.component(Card.name, Card);
    app.component(CardContent.name, CardContent);
    app.component(CardDescription.name, CardDescription);
    app.component(CardGroup.name, CardGroup);
    app.component(CardHeader.name, CardHeader);
    app.component(CardMeta.name, CardMeta);
  }
};
var Comment = defineComponent({
  name: "SuiComment",
  render() {
    var _a, _b;
    return h("div", { class: "comment" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var CommentAction = defineComponent({
  name: "SuiCommentAction",
  props: {
    active: Boolean
  },
  setup(props) {
    const { active } = props;
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(active, "active"));
    });
    return { computedClass };
  },
  render() {
    var _a, _b, _c, _d;
    if (this.computedClass) {
      return h("a", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
    }
    return h("a", {}, (_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c));
  }
});
var CommentActions = defineComponent({
  name: "SuiCommentActions",
  render() {
    var _a, _b;
    return h("div", { class: "actions" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var CommentAuthor = defineComponent({
  name: "SuiCommentAuthor",
  props: {
    as: String
  },
  render() {
    var _a, _b;
    let elementType = this.$props.as || "div";
    return h(elementType, { class: "author" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var CommentAvatar = defineComponent({
  name: "SuiCommentAvatar",
  props: {
    as: String,
    src: String
  },
  render() {
    let elementType = this.$props.as || "div";
    return h(elementType, { class: "avatar" }, h("img", { src: this.$props.src }));
  }
});
var CommentContent = defineComponent({
  name: "SuiCommentContent",
  render() {
    var _a, _b;
    return h("div", { class: "content" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var CommentGroup = defineComponent({
  name: "SuiCommentGroup",
  props: {
    collapsed: Boolean,
    inverted: Boolean,
    minimal: Boolean,
    size: String,
    threaded: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.size, computeKeyOnly(props.collapsed, "collapsed"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.minimal, "minimal"), computeKeyOnly(props.threaded, "threaded"), "comments");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var CommentMetadata = defineComponent({
  name: "SuiCommentMetadata",
  render() {
    var _a, _b;
    return h("div", { class: "metadata" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var CommentText = defineComponent({
  name: "SuiCommentText",
  render() {
    var _a, _b;
    return h("div", { class: "text" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$i = {
  install(app) {
    app.component(Comment.name, Comment);
    app.component(CommentAction.name, CommentAction);
    app.component(CommentActions.name, CommentActions);
    app.component(CommentAuthor.name, CommentAuthor);
    app.component(CommentAvatar.name, CommentAvatar);
    app.component(CommentContent.name, CommentContent);
    app.component(CommentGroup.name, CommentGroup);
    app.component(CommentMetadata.name, CommentMetadata);
    app.component(CommentText.name, CommentText);
  }
};
var Feed = defineComponent({
  name: "SuiFeed",
  props: {
    inverted: Boolean,
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.size, computeKeyOnly(props.inverted, "inverted"), "feed");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedContent = defineComponent({
  name: "SuiFeedContent",
  render() {
    var _a, _b;
    return h("div", { class: "content" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedDate = defineComponent({
  name: "SuiFeedDate",
  render() {
    var _a, _b;
    return h("div", { class: "date" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedEvent = defineComponent({
  name: "SuiFeedEvent",
  render() {
    var _a, _b;
    return h("div", { class: "event" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedExtra = defineComponent({
  name: "SuiFeedExtra",
  props: {
    images: Boolean,
    text: Boolean
  },
  setup(props) {
    const { images, text } = props;
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(images, "images"), computeKeyOnly(text, "text"), "extra");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedLabel = defineComponent({
  name: "SuiFeedLabel",
  render() {
    var _a, _b;
    return h("div", { class: "label" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedLike = defineComponent({
  name: "SuiFeedLike",
  render() {
    var _a, _b;
    return h("a", { class: "like" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedMeta = defineComponent({
  name: "SuiFeedMeta",
  render() {
    var _a, _b;
    return h("div", { class: "meta" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedSummary = defineComponent({
  name: "SuiFeedSummary",
  render() {
    var _a, _b;
    return h("div", { class: "summary" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var FeedUser = defineComponent({
  name: "SuiFeedUser",
  render() {
    var _a, _b;
    return h("a", { class: "user" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$h = {
  install(app) {
    app.component(Feed.name, Feed);
    app.component(FeedContent.name, FeedContent);
    app.component(FeedDate.name, FeedDate);
    app.component(FeedEvent.name, FeedEvent);
    app.component(FeedExtra.name, FeedExtra);
    app.component(FeedLabel.name, FeedLabel);
    app.component(FeedLike.name, FeedLike);
    app.component(FeedMeta.name, FeedMeta);
    app.component(FeedSummary.name, FeedSummary);
    app.component(FeedUser.name, FeedUser);
  }
};
var Item = defineComponent({
  name: "SuiItem",
  render() {
    var _a, _b;
    return h("div", { class: "item" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ItemContent = defineComponent({
  name: "SuiItemContent",
  props: {
    verticalAlign: String
  },
  setup(props) {
    const { verticalAlign } = props;
    const computedClass = computed(() => {
      return clsx(computeKeyValue(verticalAlign, "aligned"), "content");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ItemDescription = defineComponent({
  name: "SuiItemDescription",
  render() {
    var _a, _b;
    return h("div", { class: "description" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ItemExtra = defineComponent({
  name: "SuiItemExtra",
  render() {
    var _a, _b;
    return h("div", { class: "extra" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ItemGroup = defineComponent({
  name: "SuiItemGroup",
  props: {
    divided: Boolean,
    inverted: Boolean,
    link: Boolean,
    relaxed: [Boolean, String],
    unstackable: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.divided, "divided"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.link, "link"), computeKeyOnly(props.unstackable, "unstackable"), computeKeyOrKeyValue(props.relaxed, "relaxed"), "items");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ItemHeader = defineComponent({
  name: "SuiItemHeader",
  props: {
    as: String
  },
  render() {
    var _a, _b;
    let elementType = this.$props.as || "div";
    return h(elementType, { class: "header" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ItemImage = defineComponent({
  name: "SuiItemImage",
  props: {
    size: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(props.size, "image");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ItemMeta = defineComponent({
  name: "SuiItemMeta",
  render() {
    var _a, _b;
    return h("div", { class: "meta" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$g = {
  install(app) {
    app.component(Item.name, Item);
    app.component(ItemContent.name, ItemContent);
    app.component(ItemDescription.name, ItemDescription);
    app.component(ItemExtra.name, ItemExtra);
    app.component(ItemGroup.name, ItemGroup);
    app.component(ItemHeader.name, ItemHeader);
    app.component(ItemImage.name, ItemImage);
    app.component(ItemMeta.name, ItemMeta);
  }
};
var StatisticLabel = defineComponent({
  name: "SuiStatisticLabel",
  props: {
    content: String
  },
  render() {
    var _a, _b;
    if (this.$props.content) {
      return h("div", { class: "label" }, this.$props.content);
    }
    return h("div", { class: "label" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var StatisticValue = defineComponent({
  name: "SuiStatisticValue",
  props: {
    content: String,
    text: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.text, "text"), "value");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    if (this.$props.content) {
      return h("div", { class: this.computedClass }, this.$props.content);
    }
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var Statistic = defineComponent({
  name: "SuiStatistic",
  components: { StatisticLabel, StatisticValue },
  props: {
    color: String,
    floated: [Boolean, String],
    horizontal: Boolean,
    inverted: Boolean,
    label: String,
    size: String,
    text: Boolean,
    value: String
  },
  setup(props) {
    const ui = inject("ui", true);
    const computedClass = computed(() => {
      return clsx(ui && "ui", props.color, props.size, computeKeyOnly(props.horizontal, "horizontal"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.text, "text"), computeKeyOrKeyValue(props.floated, "floated"), "statistic");
    });
    return { computedClass };
  },
  render() {
    var _a, _b, _c, _d, _e, _f;
    let children = [];
    if (this.$props.value) {
      children.push(h(StatisticValue, { content: this.$props.value }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)));
    }
    if (this.$props.label) {
      children.push(h(StatisticLabel, { content: this.$props.label }, (_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c)));
    }
    return h("div", { class: this.computedClass }, children.length > 0 ? children : (_f = (_e = this.$slots).default) == null ? void 0 : _f.call(_e));
  }
});
var StatisticGroup = defineComponent({
  name: "SuiStatisticGroup",
  props: {
    color: String,
    horizontal: Boolean,
    inverted: Boolean,
    size: String,
    widths: Number
  },
  setup(props) {
    provide("ui", false);
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.horizontal, "horizontal"), computeKeyOnly(props.inverted, "inverted"), computeWidthProp(props.widths, ""), "statistics");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$f = {
  install(app) {
    app.component(Statistic.name, Statistic);
    app.component(StatisticGroup.name, StatisticGroup);
    app.component(StatisticLabel.name, StatisticLabel);
    app.component(StatisticValue.name, StatisticValue);
  }
};
var views = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  [Symbol.toStringTag]: "Module",
  Advertisement: index$k,
  Card: index$j,
  Comment: index$i,
  Feed: index$h,
  Item: index$g,
  Statistic: index$f
});
var Accordion = defineComponent({
  name: "SuiAccordion",
  props: {
    fluid: Boolean,
    inverted: Boolean,
    multiple: Boolean,
    styled: Boolean
  },
  setup(props) {
    const activeIndex = props.multiple ? ref([]) : ref(-1);
    const isTabActive = (index2) => {
      if (props.multiple) {
        return activeIndex.value.includes(index2);
      }
      return activeIndex.value === index2;
    };
    const updateActiveIndex = (value) => {
      const active = isTabActive(value);
      if (props.multiple) {
        if (active) {
          activeIndex.value = activeIndex.value.filter((i) => i !== value);
        } else {
          activeIndex.value.push(value);
        }
      } else {
        activeIndex.value = active ? -1 : value;
      }
    };
    provide("isTabActive", isTabActive);
    provide("updateActiveIndex", updateActiveIndex);
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.styled, "styled"), "accordion");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    const renderTabs = (tabs) => {
      tabs.forEach((tab, i) => {
        tab.props.index = i;
      });
      return tabs;
    };
    return createVNode("div", {
      "class": this.computedClass
    }, [renderTabs((_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a))]);
  }
});
var AccordionAccordion = defineComponent({
  name: "SuiAccordionAccordion",
  render() {
    var _a, _b;
    return h("div", { class: "accordion" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var AccordionContent = defineComponent({
  name: "SuiAccordionContent",
  props: {
    active: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.active, "active"), "content");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var AccordionTab = defineComponent({
  name: "SuiAccordionTab",
  props: {
    index: Number,
    title: String
  },
  setup(props) {
    const isTabActive = inject("isTabActive");
    const updateActiveIndex = inject("updateActiveIndex");
    const titleClass = computed(() => {
      return clsx(computeKeyOnly(isTabActive(props.index), "active"), "title");
    });
    return {
      isTabActive,
      updateActiveIndex,
      titleClass
    };
  },
  render() {
    return createVNode(Fragment, null, [createVNode("div", {
      "class": this.titleClass,
      "onClick": () => this.updateActiveIndex(this.index)
    }, [createVNode(Icon, {
      "name": "dropdown"
    }, null), this.title]), createVNode(AccordionContent, {
      "active": this.isTabActive(this.index)
    }, {
      default: () => {
        var _a, _b;
        return [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)];
      }
    })]);
  }
});
var AccordionTitle = defineComponent({
  name: "SuiAccordionTitle",
  props: {
    active: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.active, "active"), "title");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$e = {
  install(app) {
    app.component(Accordion.name, Accordion);
    app.component(AccordionAccordion.name, AccordionAccordion);
    app.component(AccordionContent.name, AccordionContent);
    app.component(AccordionTab.name, AccordionTab);
    app.component(AccordionTitle.name, AccordionTitle);
  }
};
const mounted = (el, binding, vnode) => {
  el.clickOutside = (event) => {
    if (!(el === event.target || el.contains(event.target))) {
      binding.value(event, el);
    }
  };
  document.body.addEventListener("click", el.clickOutside);
};
const unmounted = (el, binding, vnode) => {
  document.body.removeEventListener("click", el.clickOutside);
};
var clickOutside = {
  mounted,
  unmounted
};
function useAnimation(show, options = {}) {
  const visualState = ref(show.value ? "open" : "closed");
  const updateVisualState = () => visualState.value = show.value ? "open" : "closed";
  watch(show, (newValue) => {
    visualState.value = newValue ? "opening" : "closing";
  });
  const setupAnimation = (el) => {
    el.addEventListener("animationend", updateVisualState, true);
  };
  const removeAnimation = (el) => {
    if (!el)
      return;
    el.removeEventListener("animationend", updateVisualState);
  };
  const computeAnimationClass = computed((animationType = "scale") => {
    switch (visualState.value) {
      case "opening":
        return `animating ${animationType} in`;
      case "open":
        return "visible active";
      case "closing":
        return `visible active animating ${animationType} out`;
      case "closed":
        return "hidden";
    }
  });
  return {
    setupAnimation,
    removeAnimation,
    computeAnimationClass
  };
}
var CalendarDay = defineComponent({
  name: "SuiCalendarDay",
  emits: ["select-day"],
  props: {
    active: Boolean,
    date: null,
    disabled: Boolean,
    onSelectDay: Function
  },
  setup(props, {
    emit
  }) {
    const focus = ref(false);
    const onMouseEnter = () => {
      if (!props.disabled)
        focus.value = true;
    };
    const onMouseLeave = () => focus.value = false;
    const onClick = () => {
      if (props.disabled)
        return;
      emit("select-day", props.date);
    };
    const isToday = () => {
      let today = new Date();
      return today.getFullYear() === props.date.year && today.getMonth() === props.date.month && today.getDate() === props.date.day;
    };
    const computedClass = computed(() => {
      return clsx("link", computeKeyOnly(focus.value, "focus"), computeKeyOnly(props.active && !props.disabled, "active"), computeKeyOnly(props.disabled, "adjacent disabled"), computeKeyOnly(isToday(), "today"));
    });
    return {
      onMouseEnter,
      onMouseLeave,
      onClick,
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("td", {
      "class": this.computedClass,
      "onMouseenter": this.onMouseEnter,
      "onMouseleave": this.onMouseLeave,
      "onClick": withModifiers(this.onClick, ["stop"])
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var CalendarDateTable = defineComponent({
  name: "SuiCalendarDateTable",
  setup() {
    const {
      calendarDays,
      updateSelectMode,
      set,
      add,
      subtract,
      selectedDate,
      setSelectedDate,
      selectType,
      updateVisible,
      formatDate
    } = inject(CalendarKey);
    const isEqualDay = (date) => {
      if (!selectedDate.value)
        return false;
      const target = selectedDate.value;
      return target.getFullYear() === date.year && target.getMonth() === date.month && target.getDate() === date.day;
    };
    const onSelectDay = (event) => {
      set(event.year, "years");
      set(event.month, "months");
      set(event.day, "days");
      if (selectType.value === "date") {
        let newDate = new Date(event.year, event.month, event.day);
        setSelectedDate(newDate);
        updateVisible(false);
        return;
      }
      updateSelectMode("hour");
    };
    return {
      calendarDays,
      isEqualDay,
      onSelectDay,
      updateSelectMode,
      formatDate,
      add,
      subtract
    };
  },
  render() {
    const renderCalendarDays = () => {
      return this.calendarDays.map((week, i) => {
        return createVNode("tr", null, [week.map((date) => {
          return createVNode(CalendarDay, {
            "active": this.isEqualDay(date),
            "date": date,
            "disabled": !date.currentMonth,
            "onSelectDay": this.onSelectDay
          }, {
            default: () => [date.day]
          });
        })]);
      });
    };
    return createVNode("table", {
      "class": "ui celled center aligned unstackable table day seven column"
    }, [createVNode("thead", null, [createVNode("tr", null, [createVNode("th", {
      "colspan": 7
    }, [createVNode("span", {
      "class": "link",
      "onClick": withModifiers(() => this.updateSelectMode("month"), ["stop"])
    }, [this.formatDate("date")]), createVNode("span", {
      "class": "prev link",
      "onClick": () => this.subtract(1, "months")
    }, [createVNode("i", {
      "class": "chevron left icon"
    }, null)]), createVNode("span", {
      "class": "next link",
      "onClick": () => this.add(1, "months")
    }, [createVNode("i", {
      "class": "chevron right icon"
    }, null)])])]), createVNode("tr", null, [createVNode("th", null, [createTextVNode("S")]), createVNode("th", null, [createTextVNode("M")]), createVNode("th", null, [createTextVNode("T")]), createVNode("th", null, [createTextVNode("W")]), createVNode("th", null, [createTextVNode("T")]), createVNode("th", null, [createTextVNode("F")]), createVNode("th", null, [createTextVNode("S")])])]), createVNode("tbody", null, [renderCalendarDays()])]);
  }
});
var CalendarTableCell = defineComponent({
  name: "SuiCalendarTableCell",
  emits: ["click-cell"],
  props: {
    active: Boolean,
    today: Boolean,
    value: null,
    onClickCell: Function
  },
  setup(props) {
    const focus = ref(false);
    const onMouseEnter = () => focus.value = true;
    const onMouseLeave = () => focus.value = false;
    const computedClass = computed(() => {
      return clsx("link", computeKeyOnly(props.active, "active"), computeKeyOnly(props.today, "today"), computeKeyOnly(focus.value, "focus"));
    });
    return {
      onMouseEnter,
      onMouseLeave,
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("td", {
      "class": this.computedClass,
      "onMouseenter": this.onMouseEnter,
      "onMouseleave": this.onMouseLeave,
      "onClick": withModifiers(() => this.$emit("click-cell", this.value), ["stop"])
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var CalendarMonthTable = defineComponent({
  name: "SuiCalendarMonthTable",
  setup() {
    const {
      state,
      set,
      add,
      subtract,
      selectedDate,
      updateSelectMode
    } = inject(CalendarKey);
    const isActive = (month) => {
      if (!selectedDate.value)
        return false;
      return state.year === selectedDate.value.getFullYear() && state.month === month;
    };
    const isThisMonth = (month) => {
      let today = new Date();
      return month === today.getMonth() && state.year === today.getFullYear();
    };
    const onClickCell = (value) => {
      set(value, "months");
      updateSelectMode("day");
    };
    return {
      state,
      add,
      subtract,
      updateSelectMode,
      isActive,
      isThisMonth,
      onClickCell
    };
  },
  render() {
    const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    const renderMonths = () => {
      return Array(4).fill(0).map((_, i) => {
        return createVNode("tr", null, [createVNode(CalendarTableCell, {
          "value": i * 3,
          "active": this.isActive(i * 3),
          "today": this.isThisMonth(i * 3),
          "onClickCell": this.onClickCell
        }, {
          default: () => [months[i * 3]]
        }), createVNode(CalendarTableCell, {
          "value": i * 3 + 1,
          "active": this.isActive(i * 3 + 1),
          "today": this.isThisMonth(i * 3 + 1),
          "onClickCell": this.onClickCell
        }, {
          default: () => [months[i * 3 + 1]]
        }), createVNode(CalendarTableCell, {
          "value": i * 3 + 2,
          "active": this.isActive(i * 3 + 2),
          "today": this.isThisMonth(i * 3 + 2),
          "onClickCell": this.onClickCell
        }, {
          default: () => [months[i * 3 + 2]]
        })]);
      });
    };
    return createVNode("table", {
      "class": "ui celled center aligned unstackable table month three column"
    }, [createVNode("thead", null, [createVNode("tr", null, [createVNode("th", {
      "colspan": 3
    }, [createVNode("span", {
      "class": "link",
      "onClick": withModifiers(() => this.updateSelectMode("year"), ["stop"])
    }, [this.state.year]), createVNode("span", {
      "class": "prev link",
      "onClick": () => this.subtract(1, "years")
    }, [createVNode("i", {
      "class": "chevron left icon"
    }, null)]), createVNode("span", {
      "class": "next link",
      "onClick": () => this.add(1, "years")
    }, [createVNode("i", {
      "class": "chevron right icon"
    }, null)])])])]), createVNode("tbody", null, [renderMonths()])]);
  }
});
var CalendarYearTable = defineComponent({
  name: "SuiCalendarYearTable",
  setup(p) {
    const {
      state,
      set,
      add,
      subtract,
      selectedDate,
      updateSelectMode
    } = inject(CalendarKey);
    const moveNextTwelveYears = () => add(10, "years");
    const movePrevTwelveYears = () => subtract(10, "years");
    const headerStartYear = computed(() => {
      return Math.round(state.year / 10) * 10 + 1;
    });
    const isActive = (year) => {
      if (!selectedDate.value)
        return false;
      return year === selectedDate.value.getFullYear();
    };
    const isThisYear = (year) => {
      let today = new Date();
      return year === today.getFullYear();
    };
    const onClickCell = (value) => {
      set(value, "years");
      updateSelectMode("day");
    };
    return {
      updateSelectMode,
      moveNextTwelveYears,
      movePrevTwelveYears,
      headerStartYear,
      isActive,
      isThisYear,
      onClickCell
    };
  },
  render() {
    return createVNode("table", {
      "class": "ui celled center aligned unstackable table year three column"
    }, [createVNode("thead", null, [createVNode("tr", null, [createVNode("th", {
      "colspan": 3
    }, [createVNode("span", {
      "class": "link",
      "onClick": withModifiers(() => this.updateSelectMode("day"), ["stop"])
    }, [this.headerStartYear, createTextVNode(" - "), this.headerStartYear + 11]), createVNode("span", {
      "class": "prev link",
      "onClick": this.movePrevTwelveYears
    }, [createVNode("i", {
      "class": "chevron left icon"
    }, null)]), createVNode("span", {
      "class": "next link",
      "onClick": this.moveNextTwelveYears
    }, [createVNode("i", {
      "class": "chevron right icon"
    }, null)])])])]), createVNode("tbody", null, [createVNode("tr", null, [createVNode(CalendarTableCell, {
      "value": this.headerStartYear,
      "active": this.isActive(this.headerStartYear),
      "today": this.isThisYear(this.headerStartYear),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 1,
      "active": this.isActive(this.headerStartYear + 1),
      "today": this.isThisYear(this.headerStartYear + 1),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 1]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 2,
      "active": this.isActive(this.headerStartYear + 2),
      "today": this.isThisYear(this.headerStartYear + 2),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 2]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 3,
      "active": this.isActive(this.headerStartYear + 3),
      "today": this.isThisYear(this.headerStartYear + 3),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 3]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 4,
      "active": this.isActive(this.headerStartYear + 4),
      "today": this.isThisYear(this.headerStartYear + 4),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 4]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 5,
      "active": this.isActive(this.headerStartYear + 5),
      "today": this.isThisYear(this.headerStartYear + 5),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 5]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 6,
      "active": this.isActive(this.headerStartYear + 6),
      "today": this.isThisYear(this.headerStartYear + 6),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 6]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 7,
      "active": this.isActive(this.headerStartYear + 7),
      "today": this.isThisYear(this.headerStartYear + 7),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 7]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 8,
      "active": this.isActive(this.headerStartYear + 8),
      "today": this.isThisYear(this.headerStartYear + 8),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 8]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 9,
      "active": this.isActive(this.headerStartYear + 9),
      "today": this.isThisYear(this.headerStartYear + 9),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 9]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 10,
      "active": this.isActive(this.headerStartYear + 10),
      "today": this.isThisYear(this.headerStartYear + 10),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 10]
    }), createVNode(CalendarTableCell, {
      "value": this.headerStartYear + 11,
      "active": this.isActive(this.headerStartYear + 11),
      "today": this.isThisYear(this.headerStartYear + 11),
      "onClickCell": this.onClickCell
    }, {
      default: () => [this.headerStartYear + 11]
    })])])]);
  }
});
var CalendarHourTable = defineComponent({
  name: "SuiCalendarHourTable",
  setup() {
    const {
      updateSelectMode,
      state,
      set,
      add,
      subtract,
      formatDate,
      selectedDate
    } = inject(CalendarKey);
    const onPrevClick = () => subtract(1, "days");
    const onNextClick = () => add(1, "days");
    const onClickCell = (value) => {
      set(value, "hours");
      updateSelectMode("minute");
    };
    const isActive = (hourValue) => {
      if (!selectedDate.value)
        return false;
      let year = selectedDate.value.getFullYear();
      let month = selectedDate.value.getMonth();
      let day = selectedDate.value.getDate();
      let hour = selectedDate.value.getHours();
      return state.year === year && state.month === month && state.day === day && hourValue === hour;
    };
    return {
      updateSelectMode,
      formatDate,
      onPrevClick,
      onNextClick,
      onClickCell,
      isActive
    };
  },
  render() {
    return createVNode("table", {
      "class": "ui celled center aligned unstackable table hour four column"
    }, [createVNode("thead", null, [createVNode("tr", null, [createVNode("th", {
      "colspan": 4
    }, [createVNode("span", {
      "class": "link",
      "onClick": withModifiers(() => this.updateSelectMode("day"), ["stop"])
    }, [this.formatDate()]), createVNode("span", {
      "class": "prev link",
      "onClick": this.onPrevClick
    }, [createVNode("i", {
      "class": "chevron left icon"
    }, null)]), createVNode("span", {
      "class": "next link",
      "onClick": this.onNextClick
    }, [createVNode("i", {
      "class": "chevron right icon"
    }, null)])])])]), createVNode("tbody", null, [createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(0),
      "value": 0,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("12:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(1),
      "value": 1,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("1:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(2),
      "value": 2,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("2:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(3),
      "value": 3,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("3:00 AM")]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(4),
      "value": 4,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("4:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(5),
      "value": 5,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("5:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(6),
      "value": 6,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("6:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(7),
      "value": 7,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("7:00 AM")]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(8),
      "value": 8,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("8:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(9),
      "value": 9,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("9:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(10),
      "value": 10,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("10:00 AM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(11),
      "value": 11,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("11:00 AM")]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(12),
      "value": 12,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("12:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(13),
      "value": 13,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("1:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(14),
      "value": 14,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("2:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(15),
      "value": 15,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("3:00 PM")]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(16),
      "value": 16,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("4:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(17),
      "value": 17,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("5:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(18),
      "value": 18,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("6:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(19),
      "value": 19,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("7:00 PM")]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(20),
      "value": 20,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("8:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(21),
      "value": 21,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("9:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(22),
      "value": 22,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("10:00 PM")]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(23),
      "value": 23,
      "onClickCell": this.onClickCell
    }, {
      default: () => [createTextVNode("11:00 PM")]
    })])])]);
  }
});
function _isSlot$1(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var CalendarMinuteTable = defineComponent({
  name: "SuiCalendarMinuteTable",
  setup() {
    const {
      state,
      set,
      add,
      subtract,
      formatDate,
      updateSelectMode,
      updateVisible,
      selectedDate
    } = inject(CalendarKey);
    const getTimeLabel = (minute) => {
      let hour = state.hour % 12;
      let hourStr = state.hour > 12 ? "PM" : "AM";
      let minuteStr = minute.toString().padStart(2, "0");
      if (state.hour === 0)
        return `12:${minuteStr} AM`;
      if (state.hour === 12)
        return `12:${minuteStr} PM`;
      return `${hour}:${minuteStr} ${hourStr}`;
    };
    const onClickCell = (value) => {
      set(value, "minutes");
      selectedDate.value = new Date(state.year, state.month, state.day, state.hour, state.minute);
      updateVisible(false);
    };
    const isActive = (minValue) => {
      if (!selectedDate.value)
        return false;
      let year = selectedDate.value.getFullYear();
      let month = selectedDate.value.getMonth();
      let day = selectedDate.value.getDate();
      let hour = selectedDate.value.getHours();
      let min = selectedDate.value.getMinutes();
      return state.year === year && state.month === month && state.day === day && state.hour === hour && minValue === min;
    };
    return {
      add,
      subtract,
      formatDate,
      updateSelectMode,
      getTimeLabel,
      onClickCell,
      isActive
    };
  },
  render() {
    let _slot, _slot2, _slot3, _slot4, _slot5, _slot6, _slot7, _slot8, _slot9, _slot10, _slot11, _slot12;
    return createVNode("table", {
      "class": "ui celled center aligned unstackable table minute three column"
    }, [createVNode("thead", null, [createVNode("tr", null, [createVNode("th", {
      "colspan": 3
    }, [createVNode("span", {
      "class": "link",
      "onClick": withModifiers(() => this.updateSelectMode("day"), ["stop"])
    }, [this.formatDate()]), createVNode("span", {
      "class": "prev link",
      "onClick": () => this.subtract(1, "days")
    }, [createVNode("i", {
      "class": "chevron left icon"
    }, null)]), createVNode("span", {
      "class": "next link",
      "onClick": () => this.add(1, "days")
    }, [createVNode("i", {
      "class": "chevron right icon"
    }, null)])])])]), createVNode("tbody", null, [createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(0),
      "value": 0,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot = this.getTimeLabel(0)) ? _slot : {
      default: () => [_slot]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(5),
      "value": 5,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot2 = this.getTimeLabel(5)) ? _slot2 : {
      default: () => [_slot2]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(10),
      "value": 10,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot3 = this.getTimeLabel(10)) ? _slot3 : {
      default: () => [_slot3]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(15),
      "value": 15,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot4 = this.getTimeLabel(15)) ? _slot4 : {
      default: () => [_slot4]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(20),
      "value": 20,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot5 = this.getTimeLabel(20)) ? _slot5 : {
      default: () => [_slot5]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(25),
      "value": 25,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot6 = this.getTimeLabel(25)) ? _slot6 : {
      default: () => [_slot6]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(30),
      "value": 30,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot7 = this.getTimeLabel(30)) ? _slot7 : {
      default: () => [_slot7]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(35),
      "value": 35,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot8 = this.getTimeLabel(35)) ? _slot8 : {
      default: () => [_slot8]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(40),
      "value": 40,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot9 = this.getTimeLabel(40)) ? _slot9 : {
      default: () => [_slot9]
    })]), createVNode("tr", null, [createVNode(CalendarTableCell, {
      "active": this.isActive(45),
      "value": 45,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot10 = this.getTimeLabel(45)) ? _slot10 : {
      default: () => [_slot10]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(50),
      "value": 50,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot11 = this.getTimeLabel(50)) ? _slot11 : {
      default: () => [_slot11]
    }), createVNode(CalendarTableCell, {
      "active": this.isActive(55),
      "value": 55,
      "onClickCell": this.onClickCell
    }, _isSlot$1(_slot12 = this.getTimeLabel(55)) ? _slot12 : {
      default: () => [_slot12]
    })])])]);
  }
});
var CalendarBody = defineComponent({
  name: "SuiCalendarBody",
  setup() {
    const rootRef = ref(null);
    const {
      visible,
      selectMode
    } = inject(CalendarKey);
    const {
      setupAnimation,
      removeAnimation,
      computeAnimationClass
    } = useAnimation(visible);
    onMounted(() => setupAnimation(rootRef.value));
    onUnmounted(() => removeAnimation(rootRef.value));
    const computedClass = computed(() => {
      return clsx("ui popup calendar", "bottom left", "transition", computeAnimationClass.value);
    });
    return {
      rootRef,
      computedClass,
      selectMode
    };
  },
  render() {
    const renderCalendarTable = () => {
      switch (this.selectMode) {
        case "day":
          return createVNode(CalendarDateTable, null, null);
        case "month":
          return createVNode(CalendarMonthTable, null, null);
        case "year":
          return createVNode(CalendarYearTable, null, null);
        case "hour":
          return createVNode(CalendarHourTable, null, null);
        case "minute":
          return createVNode(CalendarMinuteTable, null, null);
      }
    };
    return createVNode("div", {
      "ref": (ref2) => this.rootRef = ref2,
      "class": this.computedClass,
      "style": "inset: 38px auto auto 0px;"
    }, [renderCalendarTable()]);
  }
});
var CalendarInput = defineComponent({
  name: "SuiCalendarInput",
  props: {
    placeholder: String,
    value: null
  },
  setup(props) {
    const {
      visible,
      updateVisible,
      updateSelectMode,
      set,
      state,
      formatCalendarDate
    } = inject(CalendarKey);
    const onClick = () => {
      if (!visible.value) {
        updateSelectMode("day");
        if (props.value) {
          set(props.value.getFullYear(), "years");
          set(props.value.getMonth(), "months");
        }
      }
      updateVisible(!visible.value);
    };
    return {
      visible,
      formatCalendarDate,
      onClick
    };
  },
  render() {
    return createVNode("input", {
      "type": "text",
      "placeholder": this.placeholder,
      "value": this.formatCalendarDate(this.value),
      "onClick": () => this.onClick()
    }, null);
  }
});
const getFirstDayOfMonthIndex = (year, month) => {
  let day = new Date();
  day.setDate(1);
  day.setMonth(month);
  day.setFullYear(year);
  let dayIndex = day.getDay();
  return dayIndex >= 7 ? dayIndex - 7 : dayIndex;
};
const getDaysCountInPrevMonth = (year, month) => {
  let prevMonth;
  let prevYear;
  if (month === 0) {
    prevMonth = 11;
    prevYear = year - 1;
  } else {
    prevMonth = month - 1;
    prevYear = year;
  }
  return 32 - new Date(prevYear, prevMonth, 32).getDate();
};
const getMonthText = (i) => {
  return ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"][i];
};
function useCalendar() {
  const visible = ref(false);
  const updateVisible = (bool = false) => visible.value = bool;
  const date = new Date();
  function formatCalendarDate(date2) {
    if (!date2)
      return;
    let year = date2.getFullYear();
    let monthText = getMonthText(date2.getMonth());
    let day = date2.getDate();
    let hour = date2.getHours();
    let minute = date2.getMinutes();
    let hourStr = hour > 11 ? "PM" : "AM";
    hour = hour % 12;
    if (hour === 0) {
      hour = 12;
      hourStr = "AM";
    }
    let minuteStr = minute.toString().padStart(2, "0");
    return `${monthText} ${day}, ${year} ${hour}:${minuteStr} ${hourStr}`;
  }
  const selectType = ref("default");
  const selectMode = ref("day");
  function updateSelectMode(mode) {
    selectMode.value = mode;
  }
  const selectedDate = ref(null);
  const setSelectedDate = (newDate) => {
    selectedDate.value = newDate;
  };
  const state = reactive({
    year: date.getFullYear(),
    month: date.getMonth(),
    day: date.getDate(),
    hour: date.getHours(),
    minute: date.getMinutes()
  });
  const set = (value, key) => {
    switch (key) {
      case "years":
        state.year = value;
        break;
      case "months":
        state.month = value;
        break;
      case "days":
        state.day = value;
        break;
      case "hours":
        state.hour = value;
        break;
      case "minutes":
        state.minute = value;
    }
  };
  const add = (value, key) => {
    let newDate = new Date(state.year, state.month, state.day, state.hour);
    switch (key) {
      case "years":
        newDate.setFullYear(newDate.getFullYear() + value);
        break;
      case "months":
        newDate.setMonth(newDate.getMonth() + value);
        break;
      case "days":
        newDate.setDate(newDate.getDate() + value);
        break;
      case "hours":
        newDate.setHours(newDate.getHours() + value);
        break;
    }
    state.year = newDate.getFullYear();
    state.month = newDate.getMonth();
    state.day = newDate.getDate();
    state.hour = newDate.getHours();
  };
  const subtract = (value, key) => {
    let newDate = new Date(state.year, state.month, state.day, state.hour);
    switch (key) {
      case "years":
        newDate.setFullYear(newDate.getFullYear() - value);
        break;
      case "months":
        newDate.setMonth(newDate.getMonth() - value);
        break;
      case "days":
        newDate.setDate(newDate.getDate() - value);
        break;
      case "hours":
        newDate.setHours(newDate.getHours() - value);
        break;
    }
    state.year = newDate.getFullYear();
    state.month = newDate.getMonth();
    state.day = newDate.getDate();
    state.hour = newDate.getHours();
  };
  const formatDate = (format = "default") => {
    if (format === "date")
      return `${getMonthText(state.month)} ${state.year}`;
    return `${getMonthText(state.month)} ${state.day}, ${state.year}`;
  };
  const calendarDays = computed(() => {
    let month = state.month;
    let year = state.year;
    if (month > 11) {
      month = month % 11 - 1;
      year += 1;
    }
    let dates = [];
    let firstDay = getFirstDayOfMonthIndex(year, month);
    let daysLength = 32 - new Date(year, month, 32).getDate();
    let prevMonthDaysLength = getDaysCountInPrevMonth(year, month);
    let dayNumber = 1;
    for (let i = 0; i < 6; i++) {
      let week = [];
      if (i === 0) {
        for (let j = prevMonthDaysLength - firstDay + 1; j <= prevMonthDaysLength; j++) {
          let prevMonth = month === 0 ? 11 : month - 1;
          let prevMonthYear = month === 0 ? year - 1 : year;
          week.push({
            day: j,
            month: prevMonth,
            year: prevMonthYear,
            currentMonth: false
          });
        }
        let remainingDaysLength = 7 - week.length;
        for (let j = 0; j < remainingDaysLength; j++) {
          week.push({ day: dayNumber, month, year, currentMonth: true });
          dayNumber++;
        }
      } else {
        for (let j = 0; j < 7; j++) {
          if (dayNumber > daysLength) {
            let nextMonth = month === 11 ? 0 : month + 1;
            let nextMonthYear = month === 11 ? year + 1 : year;
            week.push({
              day: dayNumber - daysLength,
              month: nextMonth,
              year: nextMonthYear,
              currentMonth: false
            });
          } else {
            week.push({ day: dayNumber, month, year, currentMonth: true });
          }
          dayNumber++;
        }
      }
      dates.push(week);
    }
    return dates;
  });
  return {
    visible,
    updateVisible,
    calendarDays,
    formatCalendarDate,
    selectMode,
    updateSelectMode,
    selectType,
    selectedDate,
    setSelectedDate,
    state,
    set,
    add,
    subtract,
    formatDate
  };
}
const CalendarKey = Symbol("useCalendar");
var Calendar = defineComponent({
  name: "SuiCalendar",
  directives: {
    clickoutside: clickOutside
  },
  emits: ["update:modelValue"],
  props: {
    modelValue: null,
    placeholder: String
  },
  setup(_, {
    emit
  }) {
    const calendar = useCalendar();
    provide(CalendarKey, calendar);
    const {
      updateVisible,
      selectedDate
    } = calendar;
    watch(selectedDate, (newValue) => {
      emit("update:modelValue", newValue);
    });
    return {
      updateVisible
    };
  },
  render() {
    return withDirectives(createVNode("div", {
      "class": "ui calendar"
    }, [createVNode("div", {
      "class": "ui input left icon"
    }, [createVNode(CalendarBody, null, null), createVNode("i", {
      "class": "calendar icon"
    }, null), createVNode(CalendarInput, {
      "placeholder": this.placeholder,
      "value": this.modelValue
    }, null)])]), [[resolveDirective("clickoutside"), () => this.updateVisible(false)]]);
  }
});
var index$d = {
  install: (app) => {
    app.component(Calendar.name, Calendar);
  }
};
var Checkbox = defineComponent({
  name: "SuiCheckbox",
  emits: ["update:modelValue", "change", "click"],
  props: {
    disabled: Boolean,
    indeterminate: Boolean,
    label: String,
    modelValue: null,
    readOnly: Boolean,
    slider: Boolean,
    toggle: Boolean,
    value: null
  },
  setup(props, {
    emit
  }) {
    const computedClass = computed(() => {
      return clsx("ui", !props.label && "fitted", computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.indeterminate, "indeterminate"), computeKeyOnly(props.readOnly, "read-only"), computeKeyOnly(props.slider, "slider"), computeKeyOnly(props.toggle, "toggle"), "checkbox");
    });
    const checked = computed(() => {
      return Array.isArray(props.modelValue) ? props.modelValue.includes(props.value) : props.modelValue;
    });
    const onClick = (event) => {
      if (props.disabled || props.readOnly)
        return;
      let newValue;
      if (!props.value)
        newValue = !props.modelValue;
      else {
        if (checked.value)
          newValue = props.modelValue.filter((val) => props.value !== val);
        else
          newValue = props.modelValue ? [...props.modelValue, props.value] : [props.value];
      }
      emit("change", event);
      emit("click", event);
      emit("update:modelValue", newValue);
    };
    return {
      computedClass,
      checked,
      onClick
    };
  },
  render() {
    return createVNode("div", {
      "class": this.computedClass,
      "onClick": this.onClick
    }, [createVNode("input", {
      "type": "checkbox",
      "class": "hidden",
      "checked": this.checked,
      "readonly": true
    }, null), createVNode("label", null, [this.label])]);
  }
});
var index$c = {
  install(app) {
    app.component(Checkbox.name, Checkbox);
  }
};
var Dimmer = defineComponent({
  name: "SuiDimmer",
  props: {
    active: Boolean,
    inverted: Boolean,
    page: Boolean,
    simple: Boolean,
    verticalAlign: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.active, "active"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.page, "page"), computeKeyOnly(props.simple, "simple"), computeKeyValue(props.verticalAlign, "aligned"), "dimmer");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h("div", { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var DimmerDimmable = defineComponent({
  name: "SuiDimmerDimmable",
  components: { Segment },
  props: {
    blurring: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.blurring, "blurring"), "dimmable");
    });
    return { computedClass };
  },
  render() {
    var _a, _b;
    return h(Segment, { class: this.computedClass }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$b = {
  install(app) {
    app.component(Dimmer.name, Dimmer);
    app.component(DimmerDimmable.name, DimmerDimmable);
  }
};
const pluck = (array, key) => {
  return array.map((obj) => obj[key]);
};
var DropdownText = defineComponent({
  name: "SuiDropdownText",
  emits: ["remove"],
  props: {
    clearable: Boolean,
    filtered: Boolean,
    icon: {
      type: String,
      default: "dropdown"
    },
    item: [Object, String],
    placeholder: String,
    text: String,
    onRemove: Function
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.filtered, "filtered"), computeKeyOnly(!props.text && !props.item || Array.isArray(props.item) && props.item.length === 0, "default"), "text");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    let content;
    if (this.item && !Array.isArray(this.item)) {
      if (typeof this.item === "object") {
        const {
          flag,
          text
        } = this.item;
        content = createVNode(Fragment, null, [flag && createVNode("i", {
          "class": `${flag} flag`
        }, null), text]);
      } else {
        content = this.item;
      }
    } else {
      content = this.text || this.placeholder;
    }
    const image = typeof this.item === "object" ? (_a = this.item) == null ? void 0 : _a.image : null;
    const label = typeof this.item === "object" ? (_b = this.item) == null ? void 0 : _b.label : null;
    return createVNode(Fragment, null, [createVNode("div", {
      "class": this.computedClass
    }, [image && createVNode(Image, image, null), label && createVNode(Label, label, null), content]), createVNode("i", {
      "class": `${this.icon} icon`
    }, null), this.$props.clearable && createVNode("i", {
      "class": "remove icon",
      "onClick": withModifiers(() => this.$emit("remove"), ["stop"])
    }, null)]);
  }
});
const useDropdown = (props) => {
  getCurrentInstance();
  const state = reactive({
    visible: false,
    animating: false,
    direction: "down",
    multiple: props.multiple
  });
  watch(() => state.visible, () => {
    state.animating = true;
    setTimeout(() => state.animating = false, 200);
  });
  return {
    state,
    show: () => !state.animating && (state.visible = true),
    hide: () => {
      if (state.animating)
        return;
      state.visible = false;
    }
  };
};
function _isSlot(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var Dropdown = defineComponent({
  name: "SuiDropdown",
  directives: {
    clickoutside: clickOutside
  },
  emits: ["update:modelValue"],
  props: {
    button: Boolean,
    clearable: Boolean,
    compact: Boolean,
    floating: Boolean,
    fluid: Boolean,
    icon: String,
    inline: Boolean,
    item: Boolean,
    labeled: Boolean,
    modelValue: [Object, String],
    multiple: Boolean,
    options: Array,
    placeholder: String,
    pointing: [Boolean, String],
    scrolling: Boolean,
    selection: Boolean,
    search: Boolean,
    searchInMenu: Boolean,
    simple: Boolean,
    text: String
  },
  setup(props, {
    emit
  }) {
    const api = useDropdown(props);
    provide("useDropdown", api);
    const {
      state,
      show,
      hide
    } = api;
    const computedClass = computed(() => {
      return clsx("ui", computeKeyOnly(props.button, "button"), computeKeyOnly(props.clearable, "clearable"), computeKeyOnly(props.compact, "compact"), computeKeyOnly(props.floating, "floating"), computeKeyOnly(props.fluid, "fluid"), computeKeyOnly(!!props.icon, "icon"), computeKeyOnly(props.inline, "inline"), computeKeyOnly(props.item, "item"), computeKeyOnly(props.labeled, "labeled"), computeKeyOnly(props.multiple, "multiple"), computeKeyOnly(props.scrolling, "scrolling"), computeKeyOnly(props.selection, "selection"), computeKeyOnly(props.search, "search"), computeKeyOnly(props.simple, "simple"), computeKeyOrKeyValue(props.pointing, "pointing"), "dropdown", computeKeyOnly(state.visible, "active visible"), computeKeyOnly(state.direction === "up", "upward"));
    });
    const onClick = () => state.visible ? hide() : show();
    const openMenu = () => {
      if (props.search && inputRef.value)
        inputRef.value.focus();
      show();
    };
    const closeMenu = () => hide();
    const filteredText = ref("");
    const filteredOptions = computed(() => {
      return props.options.filter((option) => {
        if (typeof option === "string")
          return option.toLowerCase().includes(filteredText.value.toLowerCase());
        if (props.multiple && Array.isArray(props.modelValue)) {
          if (typeof option === "object")
            return !pluck(props.modelValue, "text").includes(option.text);
          return props.modelValue.includes(option);
        }
        return option.text.toLowerCase().includes(filteredText.value.toLowerCase());
      });
    });
    const inputRef = ref(null);
    const onInput = (event) => filteredText.value = event.target.value;
    const onSelect = (event) => {
      filteredText.value = "";
      if (props.multiple) {
        let result = Array.isArray(props.modelValue) ? [...props.modelValue, event] : [event];
        return emit("update:modelValue", result);
      }
      return emit("update:modelValue", event);
    };
    const removeItem = (value) => {
      if (Array.isArray(props.modelValue)) {
        const index2 = props.modelValue.findIndex((selected) => selected === value);
        if (index2 > -1) {
          let copy = Object.assign(props.modelValue);
          copy.splice(index2, 1);
          emit("update:modelValue", copy);
        }
      }
    };
    provide("selection", props.selection);
    return {
      computedClass,
      onClick,
      openMenu,
      closeMenu,
      filteredText,
      filteredOptions,
      inputRef,
      onInput,
      onSelect,
      removeItem
    };
  },
  render() {
    var _a, _b;
    const renderMultipleSelect = () => {
      if (Array.isArray(this.$props.modelValue)) {
        return this.$props.modelValue.map((selected) => {
          if (typeof selected === "object") {
            return createVNode("a", {
              "class": "ui label"
            }, [selected.flag && createVNode("i", {
              "class": `${selected.flag} flag`
            }, null), selected.text, createVNode("i", {
              "class": "delete icon",
              "onClick": withModifiers(() => this.removeItem(selected), ["stop"])
            }, null)]);
          }
          return createVNode("a", {
            "class": "ui label"
          }, [selected, createVNode("i", {
            "class": "delete icon",
            "onClick": withModifiers(() => this.removeItem(selected), ["stop"])
          }, null)]);
        });
      }
    };
    const renderOptions = () => {
      return this.filteredOptions.filter((option) => {
        if (this.$props.multiple && Array.isArray(this.$props.modelValue)) {
          return !this.$props.modelValue.includes(option);
        }
        return true;
      }).map((option) => {
        return createVNode(DropdownItem, {
          "item": option,
          "active": this.$props.modelValue && typeof option === "object" ? option.text === this.$props.modelValue.text : option === this.$props.modelValue,
          "text": typeof option === "object" ? option.text : option,
          "flag": typeof option === "object" ? Object.keys(option).includes("flag") ? option.flag : "" : "",
          "image": option.image,
          "label": option.label,
          "onSelect": this.onSelect
        }, null);
      });
    };
    const renderText = () => {
      let textProps = {
        clearable: this.clearable,
        filtered: this.filteredText.length > 0,
        icon: this.icon,
        item: this.modelValue,
        placeholder: this.placeholder,
        text: this.text
      };
      return createVNode(DropdownText, mergeProps(textProps, {
        "onRemove": () => this.$emit("update:modelValue", null)
      }), null);
    };
    const renderMenu = () => {
      let _slot;
      return createVNode(DropdownMenu, {
        "search": this.$props.searchInMenu,
        "onSearch": this.onInput
      }, _isSlot(_slot = renderOptions()) ? _slot : {
        default: () => [_slot]
      });
    };
    return withDirectives(createVNode("div", {
      "class": this.computedClass,
      "onClick": this.onClick
    }, [this.$props.multiple && renderMultipleSelect(), this.search && createVNode("input", {
      "ref": (ref2) => this.inputRef = ref2,
      "type": "text",
      "class": "search",
      "autocomplete": "off",
      "tabindex": 0,
      "value": this.filteredText,
      "onInput": (event) => this.onInput(event)
    }, null), this.search && this.multiple && createVNode("span", {
      "class": "sizer"
    }, null), renderText(), ((_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)) || renderMenu()]), [[resolveDirective("clickoutside"), this.closeMenu]]);
  }
});
var DropdownItem = defineComponent({
  name: "SuiDropdownItem",
  emits: ["select"],
  props: {
    active: Boolean,
    flag: String,
    description: String,
    icon: String,
    image: Object,
    item: [Object, String],
    label: Object,
    text: String,
    onSelect: Function
  },
  setup(props, {
    emit
  }) {
    const {
      state,
      hide
    } = inject("useDropdown");
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.active, "active"), "item");
    });
    const onClick = () => {
      if (!state.multiple)
        hide();
      emit("select", props.item ? props.item : props.text);
    };
    return {
      computedClass,
      onClick
    };
  },
  render() {
    return createVNode("div", {
      "class": this.computedClass,
      "onClick": withModifiers(this.onClick, ["stop"])
    }, [this.flag && createVNode("i", {
      "class": `${this.flag} flag`
    }, null), this.icon && createVNode("i", {
      "class": `${this.icon} icon`
    }, null), this.image && createVNode(Image, this.image, null), this.label && createVNode(Label, this.label, null), this.description && createVNode("span", {
      "class": "description"
    }, [this.description]), this.text]);
  }
});
var DropdownMenu = defineComponent({
  name: "SuiDropdownMenu",
  emits: ["search"],
  props: {
    search: Boolean,
    onSearch: Function
  },
  setup(_, {
    emit,
    slots
  }) {
    const {
      state
    } = inject("useDropdown");
    const container = ref(null);
    const computedClass = computed(() => {
      let animationClass = () => {
        if (state.visible)
          return `animating slide ${state.direction} in visible`;
        else
          return `animating slide ${state.direction} out visible`;
      };
      return clsx("menu", "transition", computeKeyOnly(state.visible, "visible"), computeKeyOnly(!state.visible && !state.animating, "hidden"), computeKeyOnly(state.animating, animationClass()));
    });
    watch(() => state.visible, (newValue) => {
      if (!newValue || !container.value)
        return;
      let parent = container.value.parentElement;
      const {
        top,
        height
      } = parent == null ? void 0 : parent.getBoundingClientRect();
      const spaceAtTop = top - items.value.length * 37;
      const spaceAtBottom = document.documentElement.clientHeight - top - height - items.value.length * 37;
      state.direction = spaceAtTop > spaceAtBottom ? "up" : "down";
    });
    const items = computed(() => {
      var _a;
      let items2 = [];
      let defaultSlot = (_a = slots.default) == null ? void 0 : _a.call(slots);
      if (defaultSlot) {
        defaultSlot.forEach((child) => {
          if (child.type.name === "SuiSelectItem")
            items2.push(child);
        });
      }
      return items2;
    });
    const onSearchInput = (event) => emit("search", event);
    return {
      container,
      computedClass,
      onSearchInput
    };
  },
  render() {
    var _a, _b, _c, _d;
    const renderSearchInMenu = () => {
      return createVNode(Fragment, null, [createVNode("div", {
        "class": "ui left icon input",
        "onClick": withModifiers(() => {
        }, ["stop"])
      }, [createVNode("input", {
        "type": "text",
        "onInput": (event) => this.onSearchInput(event)
      }, null), createVNode("i", {
        "class": "search icon"
      }, null)]), createVNode("div", {
        "class": "ui divider"
      }, null)]);
    };
    return createVNode("div", {
      "ref": (ref2) => this.container = ref2,
      "class": this.computedClass
    }, [this.$slots.header && createVNode("div", {
      "class": "header"
    }, [(_b = (_a = this.$slots).header) == null ? void 0 : _b.call(_a)]), this.$props.search && renderSearchInMenu(), (_d = (_c = this.$slots).default) == null ? void 0 : _d.call(_c)]);
  }
});
var index$a = {
  install(app) {
    app.component(Dropdown.name, Dropdown);
    app.component(DropdownItem.name, DropdownItem);
    app.component(DropdownMenu.name, DropdownMenu);
  }
};
var Embed = defineComponent({
  name: "SuiEmbed",
  props: {
    active: Boolean,
    aspectRatio: Boolean,
    autoplay: Boolean,
    id: String,
    placeholder: String,
    source: String,
    url: String
  },
  setup(props) {
    const active = ref(props.active);
    const clickHandler = () => {
      active.value = !active.value;
    };
    const getSrc = () => {
      if (props.source === "youtube") {
        return [
          `//www.youtube.com/embed/${props.id}`,
          "?autohide=true",
          `&amp;autoplay=${props.autoplay}`,
          "&amp;jsapi=false"
        ].join("");
      }
      return props.url;
    };
    const computedClass = computed(() => {
      return clsx("ui", props.aspectRatio, computeKeyOnly(active.value, "active"), "embed");
    });
    return {
      active,
      getSrc,
      clickHandler,
      computedClass
    };
  },
  render() {
    let children = [
      h("i", { class: "video play icon" }),
      h("img", {
        class: "placeholder",
        src: this.placeholder
      })
    ];
    if (this.active) {
      children.push(h("div", { class: "embed" }, h("iframe", { src: this.getSrc() })));
    }
    return h("div", {
      class: this.computedClass,
      onClick: this.clickHandler
    }, children);
  }
});
var index$9 = {
  install(app) {
    app.component(Embed.name, Embed);
  }
};
var Modal = defineComponent({
  name: "SuiModal",
  props: {
    basic: Boolean,
    closeIcon: Boolean,
    modelValue: Boolean,
    size: String
  },
  setup(props, {
    emit
  }) {
    const visualState = ref(props.modelValue ? "open" : "closed");
    const root = ref(null);
    const isVisible = computed(() => visualState.value !== "closed");
    watch(() => props.modelValue, (newValue) => {
      visualState.value = newValue ? "opening" : "closing";
    });
    const computeAnimationClass = (visualState2, animationType = "scale") => {
      switch (visualState2) {
        case "opening":
          return `animating ${animationType} in`;
        case "open":
          return "visible active";
        case "closing":
          return `visible active animating ${animationType} out`;
        case "closed":
          return "hidden";
      }
    };
    const updateVisualState = () => visualState.value = props.modelValue ? "open" : "closed";
    onMounted(() => {
      var _a;
      (_a = root.value) == null ? void 0 : _a.addEventListener("animationend", updateVisualState, true);
    });
    onUnmounted(() => {
      var _a;
      (_a = root.value) == null ? void 0 : _a.removeEventListener("animationend", updateVisualState);
    });
    const dimmerClass = computed(() => {
      return clsx("ui", "page modals dimmer transition", computeAnimationClass(visualState.value, "fade"));
    });
    const dimmerStyle = computed(() => {
      return {
        display: isVisible.value ? "flex !important" : "none !important",
        animationDuration: "500ms"
      };
    });
    const modalStyle = computed(() => {
      return {
        display: isVisible.value ? "block !important" : "none !important",
        animationDuration: "500ms"
      };
    });
    const computedClass = computed(() => {
      return clsx("ui", props.size, computeKeyOnly(props.basic, "basic"), "modal", "transition", computeAnimationClass(visualState.value));
    });
    const close = () => {
      emit("update:modelValue", false);
    };
    return {
      dimmerClass,
      dimmerStyle,
      modalStyle,
      computedClass,
      close,
      root
    };
  },
  render() {
    return createVNode(Teleport, {
      "to": "body"
    }, {
      default: () => {
        var _a, _b;
        return [createVNode("div", {
          "class": this.dimmerClass,
          "style": this.dimmerStyle,
          "onClick": this.close,
          "ref": (ref2) => this.root = ref2
        }, [createVNode("div", {
          "class": this.computedClass,
          "style": this.modalStyle,
          "onClick": (e) => e.stopPropagation()
        }, [this.closeIcon && createVNode("i", {
          "aria-hidden": "true",
          "class": "close icon",
          "onClick": this.close
        }, null), (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)])])];
      }
    });
  }
});
var ModalActions = defineComponent({
  name: "SuiModalActions",
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": "actions"
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var ModalContent = defineComponent({
  name: "SuiModalContent",
  props: {
    image: Boolean,
    scrolling: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx(computeKeyOnly(props.image, "image"), computeKeyOnly(props.scrolling, "scrolling"), "content");
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var ModalDescription = defineComponent({
  name: "SuiModalDescription",
  render() {
    var _a, _b;
    return h("div", { class: "description" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var ModalHeader = defineComponent({
  name: "SuiModalHeader",
  render() {
    var _a, _b;
    return h("div", { class: "header" }, (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a));
  }
});
var index$8 = {
  install(app) {
    app.component(Modal.name, Modal);
    app.component(ModalActions.name, ModalActions);
    app.component(ModalContent.name, ModalContent);
    app.component(ModalDescription.name, ModalDescription);
    app.component(ModalHeader.name, ModalHeader);
  }
};
var usePopup = (props) => {
  const show = ref(false);
  const placement = toRef(props, "position");
  const popupRef = ref(null);
  const triggerRef = toRef(props, "trigger");
  const showPopup = () => {
    show.value = true;
    nextTick(() => setPopupPosition());
  };
  const hidePopup = () => {
    show.value = false;
  };
  const setPopupPosition = () => {
    if (!popupRef.value || !triggerRef.value)
      return;
    let x = 0;
    let y = 0;
    const popupEl = popupRef.value;
    const triggerEl = triggerRef.value.$el;
    popupEl.style.transform = `translate(${x}px, ${y}px)`;
    const { top, left, width, height } = triggerEl.getBoundingClientRect();
    const popupRect = popupEl.getBoundingClientRect();
    const { pageXOffset, pageYOffset } = window;
    if (placement.value.includes("top")) {
      x = pageXOffset + left;
      y = pageYOffset + top - popupEl.offsetTop - popupEl.offsetHeight;
    } else {
      x = left;
      y = top + height - popupRect.top;
    }
    if (placement.value.includes("right")) {
      const xOffset = width - popupRect.width;
      x = left + xOffset;
    }
    if (placement.value.includes("center")) {
      const xOffset = width / 2 - popupRect.width / 2;
      x = left + xOffset;
    }
    if (placement.value === "right center") {
      x = left + width;
      y = top + height / 2 - popupRect.top - popupRect.height / 2;
    }
    if (placement.value === "left center") {
      x = left - popupRect.width;
      y = top + height / 2 - popupRect.top - popupRect.height / 2;
    }
    popupEl.style.display = "flex";
    popupEl.style.position = "absolute";
    popupEl.style.transform = `translate(${x}px, ${y}px)`;
  };
  return {
    show,
    showPopup,
    hidePopup,
    placement,
    popupRef,
    triggerRef
  };
};
var Popup = defineComponent({
  name: "SuiPopup",
  props: {
    basic: Boolean,
    content: String,
    flowing: Boolean,
    header: String,
    inverted: Boolean,
    position: {
      type: String,
      default: "top left"
    },
    size: String,
    trigger: Object,
    wide: [Boolean, String]
  },
  setup(props, {
    slots
  }) {
    const {
      show,
      showPopup,
      hidePopup,
      popupRef,
      triggerRef
    } = usePopup(props);
    watchEffect(() => {
      var _a, _b, _c;
      if (!((_a = triggerRef.value) == null ? void 0 : _a.$el))
        return;
      (_b = triggerRef.value) == null ? void 0 : _b.$el.addEventListener("mouseenter", showPopup);
      (_c = triggerRef.value) == null ? void 0 : _c.$el.addEventListener("mouseleave", hidePopup);
    });
    const visualState = ref(show.value ? "open" : "close");
    computed(() => visualState.value !== "closed");
    watch(() => show.value, (newValue) => {
      visualState.value = newValue ? "opening" : "closing";
    });
    const computeAnimationClass = (visualState2, animationType = "scale") => {
      switch (visualState2) {
        case "opening":
          return `animating ${animationType} in`;
        case "open":
          return "visible active";
        case "closing":
          return `visible active animating ${animationType} out`;
        case "closed":
          return "hidden";
      }
    };
    const updateVisualState = () => visualState.value = show.value ? "open" : "closed";
    onMounted(() => {
      var _a;
      (_a = popupRef.value) == null ? void 0 : _a.addEventListener("animationend", updateVisualState, true);
    });
    onUnmounted(() => {
      var _a;
      (_a = popupRef.value) == null ? void 0 : _a.removeEventListener("animationend", updateVisualState);
    });
    const popupStyle = {
      position: "initial",
      animationDuration: "200ms"
    };
    const classes = computed(() => {
      return clsx("ignored ui", props.position, props.size, computeKeyOnly(props.basic, "basic"), computeKeyOnly(props.flowing, "flowing"), computeKeyOnly(props.inverted, "inverted"), computeKeyOrKeyValue(props.wide, "wide"), "popup transition", computeAnimationClass(visualState.value, "scale"));
    });
    return () => createVNode(Teleport, {
      "to": "body"
    }, {
      default: () => {
        var _a;
        return [createVNode("div", {
          "ref": popupRef,
          "style": "display: flex; position: absolute; transform: translate(0px, 0px);"
        }, [createVNode("div", {
          "class": classes.value,
          "style": popupStyle
        }, [props.header && createVNode("div", {
          "class": "header"
        }, [props.header]), createVNode("div", {
          "class": "content"
        }, [props.content ? props.content : (_a = slots.default) == null ? void 0 : _a.call(slots)])])])];
      }
    });
  }
});
var index$7 = {
  install(app) {
    app.component(Popup.name, Popup);
  }
};
var Progress = defineComponent({
  name: "SuiProgress",
  props: {
    active: Boolean,
    attached: String,
    color: String,
    disabled: Boolean,
    error: Boolean,
    indicating: Boolean,
    inverted: Boolean,
    label: String,
    percent: Number,
    progress: [Boolean, String],
    size: String,
    success: Boolean,
    warning: Boolean
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.active, "active"), computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.error, "error"), computeKeyOnly(props.indicating, "indicating"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.success, "success"), computeKeyOnly(props.warning, "warning"), computeKeyValue(props.attached, "attached"), "progress");
    });
    const barClass = computed(() => {
      return clsx(computeKeyOrKeyValue(props.progress, "progress"));
    });
    return () => createVNode("div", {
      "class": computedClass.value,
      "data-percent": props.percent
    }, [createVNode("div", {
      "class": "bar",
      "style": `width: ${props.percent}%; transition-duration: 300ms;`
    }, [props.progress && createVNode("div", {
      "class": barClass.value
    }, [props.percent, createTextVNode("%")])]), props.label && createVNode("div", {
      "class": "label"
    }, [props.label])]);
  }
});
var index$6 = {
  install(app) {
    app.component(Progress.name, Progress);
  }
};
var RatingIcon = defineComponent({
  name: "SuiRatingIcon",
  props: {
    icon: String,
    index: {
      type: Number,
      default: 0
    }
  },
  setup(props) {
    const rating = inject("rating", ref(0));
    const updateRating = inject("updateRating");
    const selectedIndex = inject("selectedIndex", ref(0));
    const updateSelectedIndex = inject("updateSelectedIndex");
    const clearable = inject("clearable", false);
    const disabled = inject("disabled", false);
    const handleClick = () => {
      if (disabled)
        return;
      if (clearable && props.index === rating.value) {
        updateRating(0);
        updateSelectedIndex(0);
        return;
      }
      updateRating(props.index);
    };
    const handleMouseEnter = () => {
      if (disabled)
        return;
      updateSelectedIndex(props.index);
    };
    const isActive = computed(() => {
      return props.index <= rating.value;
    });
    const isSelected = computed(() => {
      return props.index <= selectedIndex.value;
    });
    const computedClass = computed(() => {
      return clsx(props.icon, computeKeyOnly(isActive.value, "active"), computeKeyOnly(isSelected.value, "selected"), "icon");
    });
    return () => createVNode("i", {
      "class": computedClass.value,
      "onClick": () => handleClick(),
      "onMouseenter": () => handleMouseEnter()
    }, null);
  }
});
var Rating = defineComponent({
  name: "SuiRating",
  props: {
    clearable: Boolean,
    color: String,
    defaultRating: {
      type: Number,
      default: 0
    },
    disabled: Boolean,
    icon: {
      type: String,
      default: "star"
    },
    maxRating: {
      type: Number,
      default: 1
    },
    size: String
  },
  setup(props) {
    const rating = ref(props.defaultRating);
    const selected = ref(false);
    const selectedIndex = ref(0);
    const updateRating = (value) => rating.value = value;
    const updateSelectedIndex = (value) => selectedIndex.value = value;
    const handleMouseEnter = () => {
      if (props.disabled)
        return;
      selected.value = true;
    };
    const handleMouseLeave = () => {
      if (props.disabled)
        return;
      selected.value = false;
      updateSelectedIndex(0);
    };
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.icon, props.size, computeKeyOnly(props.disabled, "disabled"), "rating", computeKeyOnly(selected.value, "selected"));
    });
    provide("rating", rating);
    provide("updateRating", updateRating);
    provide("selectedIndex", selectedIndex);
    provide("updateSelectedIndex", updateSelectedIndex);
    provide("clearable", props.clearable);
    provide("disabled", props.disabled);
    return () => createVNode("div", {
      "class": computedClass.value,
      "onMouseenter": () => handleMouseEnter(),
      "onMouseleave": () => handleMouseLeave()
    }, [[...Array(props.maxRating)].map((_, i) => {
      return createVNode(RatingIcon, {
        "icon": props.icon,
        "index": i + 1
      }, null);
    })]);
  }
});
var index$5 = {
  install(app) {
    app.component(Rating.name, Rating);
  }
};
var Search = defineComponent({
  name: "SuiSearch",
  props: {
    icon: String,
    placeholder: String
  },
  setup(props) {
    return () => createVNode("div", {
      "class": "ui search"
    }, [createVNode("div", {
      "class": "ui icon input"
    }, [createVNode("input", {
      "type": "text",
      "class": "prompt",
      "placeholder": props.placeholder
    }, null), createVNode("i", {
      "class": "search icon"
    }, null)]), createVNode("div", {
      "class": "results"
    }, null)]);
  }
});
var index$4 = {
  install(app) {
    app.component(Search.name, Search);
  }
};
var Sidebar = defineComponent({
  name: "SuiSidebar",
  directives: {
    clickoutside: clickOutside
  },
  emits: ["update:visible", "show", "hide"],
  props: {
    animation: {
      type: String,
      default: "overlay"
    },
    dimmed: Boolean,
    direction: {
      type: String,
      default: "left"
    },
    icon: [Boolean, String],
    inverted: Boolean,
    visible: Boolean
  },
  setup(props, {
    emit
  }) {
    const state = reactive({
      animating: false
    });
    const computedClass = computed(() => {
      const isVertical = props.direction === "right" || props.direction === "left";
      return clsx("ui", "sidebar", props.direction, props.animation, computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.visible, "visible"), computeKeyOnly(state.animating, "animating"), computeKeyOnly(isVertical, "vertical"), computeKeyOrKeyValue(props.icon, "icon"), "menu");
    });
    watch(() => props.visible, () => {
      state.animating = true;
      setTimeout(() => state.animating = false, 500);
      if (props.dimmed) {
        const pusher = document.querySelector(".pusher");
        pusher && pusher.classList.toggle("dimmed");
      }
    });
    const onClickPusher = (event) => {
      const path = event.path || event.composedPath && event.composedPath();
      if (!path)
        return;
      const pusher = path.find((el) => {
        return el.classList && el.classList.contains("pusher");
      });
      if (pusher) {
        props.visible && emit("update:visible", false);
      }
    };
    return {
      computedClass,
      onClickPusher
    };
  },
  render() {
    var _a, _b;
    return withDirectives(createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]), [[resolveDirective("clickoutside"), this.onClickPusher]]);
  }
});
var index$3 = {
  install: (app) => {
    app.component(Sidebar.name, Sidebar);
  }
};
class DomHandler {
  static getWindowScrollTop() {
    let { documentElement } = document;
    return (window.pageYOffset || documentElement.scrollTop) - (documentElement.clientTop || 0);
  }
  static getWindowScrollLeft() {
    let { documentElement } = document;
    return (window.pageXOffset || documentElement.scrollLeft) - (documentElement.clientLeft || 0);
  }
  static hasClass(element, selector) {
    return element.classList.contains(selector);
  }
}
var Slider = defineComponent({
  name: "SuiSlider",
  emits: ["change", "slideend", "update:modelValue"],
  props: {
    color: String,
    disabled: Boolean,
    inverted: Boolean,
    labeled: [Boolean, String],
    labels: Array,
    max: {
      type: Number,
      default: 10
    },
    min: {
      type: Number,
      default: 0
    },
    modelValue: {
      type: [Number, Array],
      default: 0
    },
    range: Boolean,
    reversed: Boolean,
    size: String,
    step: {
      type: Number,
      default: 1
    },
    vertical: Boolean,
    verticalHeight: {
      type: [Number, String],
      default: 200
    }
  },
  setup(props, {
    emit
  }) {
    const computedClass = computed(() => {
      return clsx("ui", props.color, props.size, computeKeyOnly(props.disabled, "disabled"), computeKeyOnly(props.inverted, "inverted"), computeKeyOnly(props.reversed, "reversed"), computeKeyOnly(props.vertical, "vertical"), computeKeyOrKeyValue(props.labeled, "labeled"), "slider");
    });
    const trackStartPosPercent = () => 100 * (props.modelValue[0] - props.min) / (props.max - props.min);
    const trackEndPosPercent = () => 100 * (props.modelValue[1] - props.min) / (props.max - props.min);
    const trackFillStyle = computed(() => {
      if (props.range) {
        if (props.reversed && !props.vertical) {
          return {
            right: trackStartPosPercent() + "%",
            width: trackEndPosPercent() - trackStartPosPercent() + "%"
          };
        }
        if (props.vertical) {
          if (props.reversed) {
            return {
              bottom: trackStartPosPercent() + "%",
              height: trackEndPosPercent() - trackStartPosPercent() + "%"
            };
          }
          return {
            top: trackStartPosPercent() + "%",
            height: trackEndPosPercent() - trackStartPosPercent() + "%"
          };
        }
        return {
          left: trackStartPosPercent() + "%",
          width: trackEndPosPercent() - trackStartPosPercent() + "%"
        };
      }
      let value = props.modelValue > props.max ? props.max : props.modelValue;
      if (props.reversed) {
        if (props.vertical) {
          return {
            bottom: "0%",
            top: `${100 - (value - props.min) / (props.max - props.min) * 100}%`
          };
        }
        return {
          right: "0%",
          left: `${100 - (value - props.min) / (props.max - props.min) * 100}%`
        };
      }
      if (props.vertical) {
        return {
          top: "0%",
          bottom: `${100 - (value - props.min) / (props.max - props.min) * 100}%`
        };
      }
      return {
        left: "0%",
        right: `${100 - (value - props.min) / (props.max - props.min) * 100}%`
      };
    });
    const thumbStyle = computed(() => {
      let value = props.range ? props.modelValue[0] : props.modelValue > props.max ? props.max : props.modelValue;
      if (!props.reversed && props.vertical) {
        return {
          top: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`,
          bottom: "auto"
        };
      }
      if (props.reversed && props.vertical) {
        return {
          top: "auto",
          bottom: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`
        };
      }
      if (props.reversed && !props.vertical) {
        return {
          left: "auto",
          right: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`
        };
      }
      return {
        left: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`,
        right: "auto"
      };
    });
    const thumbSecondStyle = computed(() => {
      let value = props.modelValue[1] > props.max ? props.max : props.modelValue[1];
      if (props.reversed && !props.vertical) {
        return {
          left: "auto",
          right: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`
        };
      } else if (props.vertical) {
        if (props.reversed) {
          return {
            top: "auto",
            bottom: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`
          };
        }
        return {
          top: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`,
          bottom: "auto"
        };
      }
      return {
        left: `calc(${(value - props.min) * 100 / (props.max - props.min)}% - 10.5px)`,
        right: "auto"
      };
    });
    const labels = computed(() => {
      if (!props.labels) {
        return [...Array(props.max - props.min + 1)].map((_, i) => i * props.step + props.min);
      }
      return props.labels;
    });
    const gapRatio = () => {
      var _a, _b;
      let gapRatio2 = 1;
      let numLabels = getNumLabels();
      let trackLength = (props.vertical ? (_a = trackRef.value) == null ? void 0 : _a.clientHeight : (_b = trackRef.value) == null ? void 0 : _b.clientWidth) || 0;
      let gapCounter = 1;
      if (trackLength > 0) {
        while (trackLength / numLabels * gapCounter < 100) {
          if (!(numLabels % gapCounter))
            gapRatio2 = gapCounter;
          gapCounter += 1;
        }
      }
      return gapRatio2;
    };
    const getNumLabels = () => Math.round((props.max - props.min) / props.step);
    const rootRef = ref(null);
    const trackRef = ref(null);
    const initX = ref(0);
    const initY = ref(0);
    const barWidth = ref(0);
    const barHeight = ref(0);
    const updateDomData = () => {
      if (!rootRef.value)
        return;
      let rect = rootRef.value.getBoundingClientRect();
      initX.value = rect.left + DomHandler.getWindowScrollLeft();
      initY.value = rect.top + DomHandler.getWindowScrollTop();
      barWidth.value = rootRef.value.offsetWidth;
      barHeight.value = rootRef.value.offsetHeight;
    };
    const rangeIndex = ref(0);
    const setValue = (event) => {
      let {
        pageX,
        pageY
      } = event.touches ? event.touches[0] : event;
      let handleValue;
      let newValue;
      if (props.vertical) {
        handleValue = (initY.value + barHeight.value - pageY) * 100 / barHeight.value;
      } else {
        handleValue = (pageX - initX.value) * 100 / barWidth.value;
      }
      newValue = (props.max - props.min) * (handleValue / 100) + props.min;
      const oldValue = props.range ? props.modelValue[rangeIndex.value] : props.modelValue || 0;
      newValue = oldValue + Math.round(newValue / props.step - oldValue / props.step) * props.step;
      if (props.reversed)
        newValue = props.max - newValue + props.min;
      if (props.vertical)
        newValue = props.max - newValue + props.min;
      updateModel(newValue);
    };
    const updateModel = (value) => {
      let newValue = value;
      let modelValue;
      if (props.range) {
        modelValue = props.modelValue ? [...props.modelValue] : [];
        if (rangeIndex.value === 0) {
          let maxValue = props.modelValue ? props.modelValue[1] : props.max;
          if (newValue < props.min)
            newValue = props.min;
          else if (newValue > maxValue)
            newValue = maxValue;
          modelValue[0] = newValue;
          modelValue[1] = modelValue[1] || props.max;
        } else {
          let minValue = props.modelValue ? props.modelValue[0] : props.min;
          if (newValue > props.max)
            newValue = props.max;
          else if (newValue < minValue)
            newValue = minValue;
          modelValue[0] = modelValue[0] || props.min;
          modelValue[1] = newValue;
        }
      } else {
        if (newValue < props.min)
          newValue = props.min;
        if (newValue > props.max)
          newValue = props.max;
        modelValue = newValue;
      }
      emit("update:modelValue", modelValue);
      emit("change", modelValue);
    };
    const dragging = ref(false);
    const updateDragging = (bool) => dragging.value = bool;
    const onDragStart = (event, index2 = 0) => {
      updateDragging(true);
      updateDomData();
      rangeIndex.value = index2;
      event.preventDefault();
    };
    const onDragEnd = (event) => {
      if (dragging.value) {
        updateDragging(false);
        document.removeEventListener("mousemove", onDrag);
        emit("slideend", {
          event,
          value: props.modelValue
        });
      }
    };
    const onDrag = (event) => {
      if (dragging.value) {
        setValue(event);
        event == null ? void 0 : event.preventDefault();
      }
    };
    const onMouseDown = (event, index2 = 0) => {
      if (props.disabled)
        return;
      onDragStart(event, index2);
      document.addEventListener("mousemove", onDrag);
      document.addEventListener("mouseup", onDragEnd);
      event.preventDefault();
    };
    const onKeyDown = (event, index2 = 0) => {
      rangeIndex.value = index2;
      switch (event.code) {
        case "ArrowUp":
          if (props.vertical)
            props.reversed ? increment() : decrement();
          event.preventDefault();
          break;
        case "ArrowDown":
          if (props.vertical)
            props.reversed ? decrement() : increment();
          event.preventDefault();
          break;
        case "ArrowRight":
          props.reversed ? decrement() : increment();
          event.preventDefault();
          break;
        case "ArrowLeft":
          props.reversed ? increment() : decrement();
          event.preventDefault();
          break;
      }
    };
    const increment = () => {
      let newValue = 0;
      if (props.range)
        newValue = props.modelValue[rangeIndex.value] + props.step;
      else
        newValue = props.modelValue + props.step;
      updateModel(newValue);
    };
    const decrement = () => {
      let newValue = 0;
      if (props.range)
        newValue = props.modelValue[rangeIndex.value] - props.step;
      else
        newValue = props.modelValue - props.step;
      updateModel(newValue);
    };
    const onClick = (event) => {
      if (props.disabled)
        return;
      if (!DomHandler.hasClass(event.target, "thumb")) {
        if (props.range) {
          let clickPosition = (props.vertical ? event.offsetY / event.target.clientHeight : event.offsetX / event.target.clientWidth) * 100;
          let centerPosition = (trackStartPosPercent() + trackEndPosPercent()) / 2;
          if (clickPosition < centerPosition)
            rangeIndex.value = props.reversed ? 1 : 0;
          else
            rangeIndex.value = props.reversed ? 0 : 1;
        }
        updateDomData();
        setValue(event);
      }
    };
    return () => createVNode("div", {
      "ref": (ref2) => rootRef.value = ref2,
      "class": computedClass.value,
      "style": props.vertical ? `height: ${props.verticalHeight}px;` : ""
    }, [createVNode("div", {
      "class": "inner",
      "onClick": onClick
    }, [createVNode("div", {
      "class": "track",
      "ref": (ref2) => trackRef.value = ref2
    }, null), createVNode("div", {
      "class": "track-fill",
      "style": trackFillStyle.value
    }, null), createVNode("div", {
      "class": "thumb",
      "style": thumbStyle.value,
      "onMousedown": (event) => onMouseDown(event),
      "onTouchstart": (event) => onDragStart(event),
      "onTouchmove": (event) => onDrag(event),
      "onTouchend": (event) => onDragEnd(event),
      "onKeydown": (event) => onKeyDown(event),
      "tabindex": 0
    }, null), props.range && createVNode("div", {
      "class": "thumb second",
      "style": thumbSecondStyle.value,
      "onMousedown": (event) => onMouseDown(event, 1),
      "onTouchstart": (event) => onDragStart(event, 1),
      "onTouchmove": (event) => onDrag(event),
      "onTouchend": (event) => onDragEnd(event),
      "onKeydown": (event) => onKeyDown(event, 1),
      "tabindex": 0
    }, null)]), props.labeled && createVNode("ul", {
      "class": "auto labels"
    }, [[...Array(getNumLabels() + 1)].map((_, i) => {
      let ratio = i / getNumLabels();
      if (!(i % gapRatio())) {
        return createVNode("li", {
          "class": "label",
          "style": `${props.vertical ? props.reversed ? "bottom" : "top" : "left"}: calc(((100% - 7px) - 7px) * ${ratio} + 7px);`
        }, [props.reversed && !props.vertical ? props.labels ? props.labels[getNumLabels() - i] : labels.value[getNumLabels() - i] : props.labels ? props.labels[i] : labels.value[i]]);
      } else {
        return createVNode("li", {
          "class": "halftick label",
          "style": `${props.vertical ? props.reversed ? "bottom" : "top" : "left"}: calc(((100% - 7px) - 7px) * ${ratio} + 7px);`
        }, null);
      }
    })])]);
  }
});
var index$2 = {
  install(app) {
    app.component(Slider.name, Slider);
  }
};
var TabPanel = defineComponent({
  name: "SuiTabPanel",
  props: {
    active: Boolean,
    attached: [Boolean, String],
    header: String
  },
  setup(props) {
    const computedClass = computed(() => {
      return clsx("ui tab segment", computeKeyOnly(props.active, "active"), computeKeyOrKeyValue(props.attached, "attached"));
    });
    return {
      computedClass
    };
  },
  render() {
    var _a, _b;
    return createVNode("div", {
      "class": this.computedClass
    }, [(_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)]);
  }
});
var Tab = defineComponent({
  name: "SuiTab",
  emits: ["update:activeIndex", "tab-change", "tab-click"],
  props: {
    activeIndex: {
      type: Number,
      default: 0
    },
    pointing: Boolean,
    secondary: Boolean,
    text: Boolean
  },
  setup(props, {
    emit,
    slots
  }) {
    const tabIndex = ref(props.activeIndex);
    watch(() => props.activeIndex, (newValue) => {
      tabIndex.value = newValue;
    });
    const onClick = (event, i) => {
      if (tabIndex.value !== i) {
        tabIndex.value = i;
        emit("update:activeIndex", i);
        emit("tab-change", {
          event,
          index: i
        });
      }
      emit("tab-click", {
        event,
        index: i
      });
    };
    const onKeyDown = (event, i) => {
      if (event.key === "Enter") {
        onClick(event, i);
      }
    };
    const tabs = computed(() => {
      var _a, _b;
      let tabs2 = [];
      if ((_a = slots.default) == null ? void 0 : _a.call(slots)) {
        (_b = slots.default) == null ? void 0 : _b.call(slots).forEach((child) => {
          if (child.type.name === "SuiTabPanel")
            tabs2.push(child);
        });
      }
      return tabs2;
    });
    const isDefaultMenu = computed(() => !props.secondary && !props.pointing && !props.text);
    const tabMenuClass = computed(() => {
      return clsx("ui menu", computeKeyOnly(isDefaultMenu.value, "tabular attached"), computeKeyOnly(props.pointing, "pointing"), computeKeyOnly(props.secondary, "secondary"), computeKeyOnly(props.text, "text"));
    });
    return {
      onClick,
      onKeyDown,
      tabIndex,
      tabs,
      tabMenuClass,
      isDefaultMenu
    };
  },
  render() {
    const renderMenuItems = () => {
      return this.tabs.map((tab, i) => {
        return createVNode("a", {
          "class": `item ${this.tabIndex === i && "active"}`,
          "onClick": (event) => this.onClick(event, i),
          "onKeydown": (event) => this.onKeyDown(event, i),
          "tabindex": 0
        }, [tab.props.header]);
      });
    };
    const renderTabPanels = () => {
      return this.tabs.map((tab, i) => {
        return createVNode(TabPanel, mergeProps(tab.props, {
          "active": this.tabIndex === i,
          "attached": this.isDefaultMenu ? "bottom" : false
        }), {
          default: () => {
            var _a, _b;
            return [(_b = (_a = tab.children).default) == null ? void 0 : _b.call(_a)];
          }
        });
      });
    };
    return createVNode(Fragment, null, [createVNode("div", {
      "class": this.tabMenuClass
    }, [renderMenuItems()]), renderTabPanels()]);
  }
});
var index$1 = {
  install(app) {
    app.component(Tab.name, Tab);
    app.component(TabPanel.name, TabPanel);
  }
};
var modules = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  [Symbol.toStringTag]: "Module",
  Accordion: index$e,
  Calendar: index$d,
  Checkbox: index$c,
  Dimmer: index$b,
  Dropdown: index$a,
  Embed: index$9,
  Modal: index$8,
  Popup: index$7,
  Progress: index$6,
  Rating: index$5,
  Search: index$4,
  Sidebar: index$3,
  Slider: index$2,
  Tab: index$1
});
function install(app) {
  Object.values(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, elements), collections), views), modules)).map((component) => app.use(component));
}
var index = { install };
export { Accordion as SuiAccordion, AccordionAccordion as SuiAccordionAccordion, AccordionContent as SuiAccordionContent, AccordionTab as SuiAccordionTab, AccordionTitle as SuiAccordionTitle, Advertisement as SuiAdvertisement, Breadcrumb as SuiBreadcrumb, BreadcrumbDivider as SuiBreadcrumbDivider, BreadcrumbSection as SuiBreadcrumbSection, Button as SuiButton, ButtonContent as SuiButtonContent, ButtonGroup as SuiButtonGroup, Calendar as SuiCalendar, Card as SuiCard, CardContent as SuiCardContent, CardDescription as SuiCardDescription, CardGroup as SuiCardGroup, CardHeader as SuiCardHeader, CardMeta as SuiCardMeta, Checkbox as SuiCheckbox, Comment as SuiComment, CommentAction as SuiCommentAction, CommentActions as SuiCommentActions, CommentAuthor as SuiCommentAuthor, CommentAvatar as SuiCommentAvatar, CommentContent as SuiCommentContent, CommentGroup as SuiCommentGroup, CommentMetadata as SuiCommentMetadata, CommentText as SuiCommentText, Container as SuiContainer, Dimmer as SuiDimmer, DimmerDimmable as SuiDimmerDimmable, Divider as SuiDivider, Dropdown as SuiDropdown, DropdownItem as SuiDropdownItem, DropdownMenu as SuiDropdownMenu, Embed as SuiEmbed, Emoji as SuiEmoji, Feed as SuiFeed, FeedContent as SuiFeedContent, FeedDate as SuiFeedDate, FeedEvent as SuiFeedEvent, FeedExtra as SuiFeedExtra, FeedLabel as SuiFeedLabel, FeedLike as SuiFeedLike, FeedMeta as SuiFeedMeta, FeedSummary as SuiFeedSummary, FeedUser as SuiFeedUser, Flag as SuiFlag, Form as SuiForm, FormField as SuiFormField, FormGroup as SuiFormGroup, FormTextarea as SuiFormTextarea, Grid as SuiGrid, GridColumn as SuiGridColumn, GridRow as SuiGridRow, Header as SuiHeader, HeaderContent as SuiHeaderContent, HeaderSubheader as SuiHeaderSubheader, Icon as SuiIcon, IconGroup as SuiIconGroup, Image as SuiImage, ImageGroup as SuiImageGroup, Input as SuiInput, Item as SuiItem, ItemContent as SuiItemContent, ItemDescription as SuiItemDescription, ItemExtra as SuiItemExtra, ItemGroup as SuiItemGroup, ItemHeader as SuiItemHeader, ItemImage as SuiItemImage, ItemMeta as SuiItemMeta, Label as SuiLabel, LabelDetail as SuiLabelDetail, LabelGroup as SuiLabelGroup, List as SuiList, ListContent as SuiListContent, ListDescription as SuiListDescription, ListHeader as SuiListHeader, ListIcon as SuiListIcon, ListItem as SuiListItem, ListList as SuiListList, Loader as SuiLoader, Menu as SuiMenu, MenuHeader as SuiMenuHeader, MenuItem as SuiMenuItem, MenuMenu as SuiMenuMenu, Message as SuiMessage, MessageContent as SuiMessageContent, MessageHeader as SuiMessageHeader, MessageItem as SuiMessageItem, MessageList as SuiMessageList, Modal as SuiModal, ModalActions as SuiModalActions, ModalContent as SuiModalContent, ModalDescription as SuiModalDescription, ModalHeader as SuiModalHeader, Popup as SuiPopup, Progress as SuiProgress, Rail as SuiRail, Rating as SuiRating, Reveal as SuiReveal, RevealContent as SuiRevealContent, Segment as SuiSegment, SegmentGroup as SuiSegmentGroup, SegmentInline as SuiSegmentInline, Sidebar as SuiSidebar, Slider as SuiSlider, Statistic as SuiStatistic, StatisticGroup as SuiStatisticGroup, StatisticLabel as SuiStatisticLabel, StatisticValue as SuiStatisticValue, Step as SuiStep, StepContent as SuiStepContent, StepDescription as SuiStepDescription, StepGroup as SuiStepGroup, StepTitle as SuiStepTitle, Tab as SuiTab, TabPanel as SuiTabPanel, Table as SuiTable, TableBody as SuiTableBody, TableCell as SuiTableCell, TableFooter as SuiTableFooter, TableHeader as SuiTableHeader, TableHeaderCell as SuiTableHeaderCell, TableRow as SuiTableRow, index as default };
