import { AnimationControls } from 'motion';
import { App } from 'vue';
import { ComponentOptionsMixin } from 'vue';
import { ComputedRef } from 'vue';
import { DefineComponent } from 'vue';
import { DefineSetupFnComponent } from 'vue';
import { ExtractPropTypes } from 'vue';
import { JSX } from 'vue/jsx-runtime';
import { MotionKeyframesDefinition } from 'motion';
import { Prop } from 'vue';
import { PropType } from 'vue';
import { PublicProps } from 'vue';
import { Ref } from 'vue';
import { RendererElement } from 'vue';
import { RendererNode } from 'vue';
import { VNode } from 'vue';

declare type Aligned = typeof AlignedValues[number];

declare const AlignedValues: readonly ["top", "middle", "bottom"];

declare type AnimationType = keyof typeof directionalAnimation | keyof typeof staticAnimation;

declare type Attached = typeof attachedValues[number];

declare const attachedValues: readonly ["top", "bottom", "left"];

declare type Color = typeof colorValues[number];

declare const colorValues: readonly ["red", "orange", "yellow", "olive", "green", "teal", "blue", "purple", "violet", "pink", "brown", "grey", "black"];

export declare const Column: DefineComponent<    {
active: FunctionConstructor;
cellClass: (BooleanConstructor | FunctionConstructor)[];
collapsing: BooleanConstructor;
field: StringConstructor;
header: StringConstructor;
error: FunctionConstructor;
color: FunctionConstructor;
negative: FunctionConstructor;
positive: FunctionConstructor;
marked: FunctionConstructor;
selectable: (BooleanConstructor | FunctionConstructor)[];
warning: FunctionConstructor;
}, unknown, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: FunctionConstructor;
cellClass: (BooleanConstructor | FunctionConstructor)[];
collapsing: BooleanConstructor;
field: StringConstructor;
header: StringConstructor;
error: FunctionConstructor;
color: FunctionConstructor;
negative: FunctionConstructor;
positive: FunctionConstructor;
marked: FunctionConstructor;
selectable: (BooleanConstructor | FunctionConstructor)[];
warning: FunctionConstructor;
}>>, {
collapsing: boolean;
}, {}>;

declare type CreateToastOptions = Omit<ToastOptions, 'id'>;

declare const _default: {
    install: typeof install;
};
export default _default;

declare const _default_10: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_10 as HeaderContent }
export { _default_10 as SuiHeaderContent }

declare const _default_100: DefineComponent<    {
content: StringConstructor;
}, unknown, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
content: StringConstructor;
}>>, {}, {}>;
export { _default_100 as StatisticLabel }
export { _default_100 as SuiStatisticLabel }

declare const _default_101: DefineComponent<    {
content: StringConstructor;
text: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
content: StringConstructor;
text: BooleanConstructor;
}>>, {
text: boolean;
}, {}>;
export { _default_101 as StatisticValue }
export { _default_101 as SuiStatisticValue }

declare const _default_102: DefineComponent<    {
basic: BooleanConstructor;
compact: PropType<boolean | "very">;
fluid: BooleanConstructor;
inverted: BooleanConstructor;
multiple: BooleanConstructor;
styled: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
basic: BooleanConstructor;
compact: PropType<boolean | "very">;
fluid: BooleanConstructor;
inverted: BooleanConstructor;
multiple: BooleanConstructor;
styled: BooleanConstructor;
}>>, {
styled: boolean;
inverted: boolean;
basic: boolean;
fluid: boolean;
multiple: boolean;
}, {}>;
export { _default_102 as Accordion }
export { _default_102 as SuiAccordion }

declare const _default_103: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_103 as AccordionAccordion }
export { _default_103 as SuiAccordionAccordion }

declare const _default_104: DefineComponent<    {
active: BooleanConstructor;
compact: BooleanConstructor;
styled: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
compact: BooleanConstructor;
styled: BooleanConstructor;
}>>, {
active: boolean;
compact: boolean;
styled: boolean;
}, {}>;
export { _default_104 as AccordionContent }
export { _default_104 as SuiAccordionContent }

declare const _default_105: DefineComponent<    {
compact: BooleanConstructor;
icon: StringConstructor;
index: NumberConstructor;
title: StringConstructor;
styled: BooleanConstructor;
}, {
isTabActive: any;
updateActiveIndex: any;
titleClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
compact: BooleanConstructor;
icon: StringConstructor;
index: NumberConstructor;
title: StringConstructor;
styled: BooleanConstructor;
}>>, {
compact: boolean;
styled: boolean;
}, {}>;
export { _default_105 as AccordionTab }
export { _default_105 as SuiAccordionTab }

declare const _default_106: DefineComponent<    {
active: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
}>>, {
active: boolean;
}, {}>;
export { _default_106 as AccordionTitle }
export { _default_106 as SuiAccordionTitle }

declare const _default_107: DefineComponent<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
activeStartDate: DateConstructor;
defaultView: {
type: PropType<View>;
default: string;
};
disabled: BooleanConstructor;
locale: StringConstructor;
localeFirstDayOfYear: {
type: NumberConstructor;
default: number;
};
modelValue: DateConstructor;
inline: BooleanConstructor;
inverted: BooleanConstructor;
placeholder: StringConstructor;
showIcon: {
type: BooleanConstructor;
default: boolean;
};
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, ("dateSelected" | "update:modelValue")[], "dateSelected" | "update:modelValue", PublicProps, Readonly<ExtractPropTypes<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
activeStartDate: DateConstructor;
defaultView: {
type: PropType<View>;
default: string;
};
disabled: BooleanConstructor;
locale: StringConstructor;
localeFirstDayOfYear: {
type: NumberConstructor;
default: number;
};
modelValue: DateConstructor;
inline: BooleanConstructor;
inverted: BooleanConstructor;
placeholder: StringConstructor;
showIcon: {
type: BooleanConstructor;
default: boolean;
};
}>> & {
onDateSelected?: ((...args: any[]) => any) | undefined;
"onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
}, {
disabled: boolean;
inverted: boolean;
localeFirstDayOfYear: number;
defaultView: "decade" | "year" | "month" | "day" | "hour";
inline: boolean;
showIcon: boolean;
}, {}>;
export { _default_107 as Calendar }
export { _default_107 as SuiCalendar }

declare const _default_108: DefineComponent<    {
disabled: BooleanConstructor;
indeterminate: BooleanConstructor;
label: StringConstructor;
modelValue: null;
radio: BooleanConstructor;
readOnly: BooleanConstructor;
slider: BooleanConstructor;
toggle: BooleanConstructor;
value: null;
}, {
computedClass: ComputedRef<string>;
checked: ComputedRef<any>;
onClick: (event: any) => void;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, ("change" | "click" | "update:modelValue")[], "change" | "click" | "update:modelValue", PublicProps, Readonly<ExtractPropTypes<    {
disabled: BooleanConstructor;
indeterminate: BooleanConstructor;
label: StringConstructor;
modelValue: null;
radio: BooleanConstructor;
readOnly: BooleanConstructor;
slider: BooleanConstructor;
toggle: BooleanConstructor;
value: null;
}>> & {
onChange?: ((...args: any[]) => any) | undefined;
onClick?: ((...args: any[]) => any) | undefined;
"onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
}, {
disabled: boolean;
toggle: boolean;
radio: boolean;
indeterminate: boolean;
readOnly: boolean;
slider: boolean;
}, {}>;
export { _default_108 as Checkbox }
export { _default_108 as SuiCheckbox }

declare const _default_109: DefineComponent<    {
active: BooleanConstructor;
inverted: BooleanConstructor;
page: BooleanConstructor;
simple: BooleanConstructor;
verticalAlign: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
inverted: BooleanConstructor;
page: BooleanConstructor;
simple: BooleanConstructor;
verticalAlign: StringConstructor;
}>>, {
active: boolean;
inverted: boolean;
page: boolean;
simple: boolean;
}, {}>;
export { _default_109 as Dimmer }
export { _default_109 as SuiDimmer }

declare const _default_11: DefineComponent<    {
as: StringConstructor;
}, {
elementType: string;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
}>>, {}, {}>;
export { _default_11 as HeaderSubheader }
export { _default_11 as SuiHeaderSubheader }

declare const _default_110: DefineSetupFnComponent<    {
blurring: boolean;
}, {}, {}, {
blurring: boolean;
} & {}, PublicProps>;
export { _default_110 as DimmerDimmable }
export { _default_110 as SuiDimmerDimmable }

declare const _default_111: DefineComponent<    {
button: BooleanConstructor;
clearable: BooleanConstructor;
floating: BooleanConstructor;
fluid: BooleanConstructor;
icon: StringConstructor;
inline: BooleanConstructor;
item: BooleanConstructor;
labeled: BooleanConstructor;
modelValue: (ObjectConstructor | StringConstructor | ArrayConstructor)[];
multiple: BooleanConstructor;
options: {
type: PropType<DropdownItem[] | OptionItem[]>;
default: () => never[];
};
placeholder: StringConstructor;
pointing: PropType<boolean | "bottom right" | "top left" | "left" | "right" | "top right" | "bottom right">;
search: BooleanConstructor;
searchInMenu: BooleanConstructor;
selection: BooleanConstructor;
selectable: BooleanConstructor;
text: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, "update:modelValue"[], "update:modelValue", PublicProps, Readonly<ExtractPropTypes<    {
button: BooleanConstructor;
clearable: BooleanConstructor;
floating: BooleanConstructor;
fluid: BooleanConstructor;
icon: StringConstructor;
inline: BooleanConstructor;
item: BooleanConstructor;
labeled: BooleanConstructor;
modelValue: (ObjectConstructor | StringConstructor | ArrayConstructor)[];
multiple: BooleanConstructor;
options: {
type: PropType<DropdownItem[] | OptionItem[]>;
default: () => never[];
};
placeholder: StringConstructor;
pointing: PropType<boolean | "bottom right" | "top left" | "left" | "right" | "top right" | "bottom right">;
search: BooleanConstructor;
searchInMenu: BooleanConstructor;
selection: BooleanConstructor;
selectable: BooleanConstructor;
text: StringConstructor;
}>> & {
"onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
}, {
search: boolean;
button: boolean;
fluid: boolean;
multiple: boolean;
labeled: boolean;
inline: boolean;
options: OptionItem[] | DropdownItem[];
floating: boolean;
item: boolean;
clearable: boolean;
selectable: boolean;
searchInMenu: boolean;
selection: boolean;
}, {}>;
export { _default_111 as Dropdown }
export { _default_111 as SuiDropdown }

declare const _default_112: DefineComponent<    {
active: BooleanConstructor;
aspectRatio: BooleanConstructor;
autoplay: BooleanConstructor;
id: StringConstructor;
placeholder: StringConstructor;
source: StringConstructor;
url: StringConstructor;
}, {
active: Ref<boolean>;
getSrc: () => string | undefined;
clickHandler: () => void;
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
aspectRatio: BooleanConstructor;
autoplay: BooleanConstructor;
id: StringConstructor;
placeholder: StringConstructor;
source: StringConstructor;
url: StringConstructor;
}>>, {
active: boolean;
aspectRatio: boolean;
autoplay: boolean;
}, {}>;
export { _default_112 as Embed }
export { _default_112 as SuiEmbed }

declare const _default_113: DefineComponent<    {
basic: BooleanConstructor;
closeIcon: BooleanConstructor;
dimmer: PropType<"inverted" | "blurring" | undefined>;
modelValue: BooleanConstructor;
size: StringConstructor;
closable: {
type: BooleanConstructor;
default: boolean;
};
overlay: BooleanConstructor;
fullscreen: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
basic: BooleanConstructor;
closeIcon: BooleanConstructor;
dimmer: PropType<"inverted" | "blurring" | undefined>;
modelValue: BooleanConstructor;
size: StringConstructor;
closable: {
type: BooleanConstructor;
default: boolean;
};
overlay: BooleanConstructor;
fullscreen: BooleanConstructor;
}>>, {
basic: boolean;
modelValue: boolean;
fullscreen: boolean;
closable: boolean;
closeIcon: boolean;
overlay: boolean;
}, {}>;
export { _default_113 as Modal }
export { _default_113 as SuiModal }

declare const _default_114: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_114 as ModalActions }
export { _default_114 as SuiModalActions }

declare const _default_115: DefineComponent<    {
image: BooleanConstructor;
scrolling: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
image: BooleanConstructor;
scrolling: BooleanConstructor;
}>>, {
image: boolean;
scrolling: boolean;
}, {}>;
export { _default_115 as ModalContent }
export { _default_115 as SuiModalContent }

declare const _default_116: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_116 as ModalDescription }
export { _default_116 as SuiModalDescription }

declare const _default_117: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_117 as ModalHeader }
export { _default_117 as SuiModalHeader }

declare const _default_118: DefineComponent<    {
basic: BooleanConstructor;
content: StringConstructor;
flowing: BooleanConstructor;
header: StringConstructor;
inverted: BooleanConstructor;
position: {
type: StringConstructor;
default: string;
};
size: StringConstructor;
trigger: ObjectConstructor;
wide: (BooleanConstructor | StringConstructor)[];
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
basic: BooleanConstructor;
content: StringConstructor;
flowing: BooleanConstructor;
header: StringConstructor;
inverted: BooleanConstructor;
position: {
type: StringConstructor;
default: string;
};
size: StringConstructor;
trigger: ObjectConstructor;
wide: (BooleanConstructor | StringConstructor)[];
}>>, {
inverted: boolean;
basic: boolean;
position: string;
flowing: boolean;
}, {}>;
export { _default_118 as Popup }
export { _default_118 as SuiPopup }

declare const _default_119: DefineComponent<    {
color: {
type: PropType<Color>;
validator: (v: any) => boolean;
};
attached: {
type: PropType<Attached>;
validator: (v: any) => boolean;
};
active: BooleanConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
indeterminate: PropType<boolean | "filling" | "sliding" | "swinging" | "slow" | "fast">;
indicating: BooleanConstructor;
inverted: BooleanConstructor;
label: StringConstructor;
percent: NumberConstructor;
progress: (BooleanConstructor | StringConstructor)[];
size: StringConstructor;
success: BooleanConstructor;
warning: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
color: {
type: PropType<Color>;
validator: (v: any) => boolean;
};
attached: {
type: PropType<Attached>;
validator: (v: any) => boolean;
};
active: BooleanConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
indeterminate: PropType<boolean | "filling" | "sliding" | "swinging" | "slow" | "fast">;
indicating: BooleanConstructor;
inverted: BooleanConstructor;
label: StringConstructor;
percent: NumberConstructor;
progress: (BooleanConstructor | StringConstructor)[];
size: StringConstructor;
success: BooleanConstructor;
warning: BooleanConstructor;
}>>, {
active: boolean;
disabled: boolean;
inverted: boolean;
error: boolean;
success: boolean;
warning: boolean;
indicating: boolean;
}, {}>;
export { _default_119 as Progress }
export { _default_119 as SuiProgress }

declare const _default_12: DefineComponent<    {
aligned: {
type: PropType<Aligned>;
validator: (v: any) => boolean;
};
as: StringConstructor;
bordered: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
colored: BooleanConstructor;
corner: (BooleanConstructor | StringConstructor)[];
disabled: BooleanConstructor;
fitted: BooleanConstructor;
flipped: StringConstructor;
inverted: BooleanConstructor;
link: BooleanConstructor;
loading: BooleanConstructor;
name: StringConstructor;
primary: BooleanConstructor;
rotated: StringConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
}, {
classes: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
aligned: {
type: PropType<Aligned>;
validator: (v: any) => boolean;
};
as: StringConstructor;
bordered: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
colored: BooleanConstructor;
corner: (BooleanConstructor | StringConstructor)[];
disabled: BooleanConstructor;
fitted: BooleanConstructor;
flipped: StringConstructor;
inverted: BooleanConstructor;
link: BooleanConstructor;
loading: BooleanConstructor;
name: StringConstructor;
primary: BooleanConstructor;
rotated: StringConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
}>>, {
link: boolean;
bordered: boolean;
circular: boolean;
colored: boolean;
disabled: boolean;
fitted: boolean;
inverted: boolean;
loading: boolean;
primary: boolean;
secondary: boolean;
}, {}>;
export { _default_12 as Icon }
export { _default_12 as SuiIcon }

declare const _default_120: DefineComponent<    {
clearable: BooleanConstructor;
color: StringConstructor;
defaultRating: {
type: NumberConstructor;
default: number;
};
disabled: BooleanConstructor;
icon: {
type: StringConstructor;
default: string;
};
maxRating: {
type: NumberConstructor;
default: number;
};
modelValue: NumberConstructor;
size: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
clearable: BooleanConstructor;
color: StringConstructor;
defaultRating: {
type: NumberConstructor;
default: number;
};
disabled: BooleanConstructor;
icon: {
type: StringConstructor;
default: string;
};
maxRating: {
type: NumberConstructor;
default: number;
};
modelValue: NumberConstructor;
size: StringConstructor;
}>>, {
disabled: boolean;
icon: string;
clearable: boolean;
defaultRating: number;
maxRating: number;
}, {}>;
export { _default_120 as Rating }
export { _default_120 as SuiRating }

declare const _default_121: DefineComponent<    {
animation: {
type: StringConstructor;
default: string;
};
dimmed: {
type: BooleanConstructor;
default: boolean;
};
icon: (BooleanConstructor | StringConstructor)[];
items: {
type: PropType<any[]>;
default: () => never[];
};
mountOnBody: {
type: BooleanConstructor;
default: boolean;
};
direction: {
type: PropType<"left" | "right">;
default: string;
};
visible: {
type: BooleanConstructor;
default: boolean;
};
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, ("update:visible" | "show" | "hide")[], "update:visible" | "show" | "hide", PublicProps, Readonly<ExtractPropTypes<    {
animation: {
type: StringConstructor;
default: string;
};
dimmed: {
type: BooleanConstructor;
default: boolean;
};
icon: (BooleanConstructor | StringConstructor)[];
items: {
type: PropType<any[]>;
default: () => never[];
};
mountOnBody: {
type: BooleanConstructor;
default: boolean;
};
direction: {
type: PropType<"left" | "right">;
default: string;
};
visible: {
type: BooleanConstructor;
default: boolean;
};
}>> & {
"onUpdate:visible"?: ((...args: any[]) => any) | undefined;
onShow?: ((...args: any[]) => any) | undefined;
onHide?: ((...args: any[]) => any) | undefined;
}, {
visible: boolean;
direction: "left" | "right";
items: any[];
dimmed: boolean;
animation: string;
mountOnBody: boolean;
}, {}>;
export { _default_121 as Sidebar }
export { _default_121 as SuiSidebar }

declare const _default_122: DefineComponent<    {
color: StringConstructor;
disabled: BooleanConstructor;
inverted: BooleanConstructor;
labeled: (BooleanConstructor | StringConstructor)[];
labels: ArrayConstructor;
max: {
type: NumberConstructor;
default: number;
};
min: {
type: NumberConstructor;
default: number;
};
modelValue: {
type: (NumberConstructor | ArrayConstructor)[];
default: number;
};
range: BooleanConstructor;
reversed: BooleanConstructor;
size: StringConstructor;
step: {
type: NumberConstructor;
default: number;
};
vertical: BooleanConstructor;
verticalHeight: {
type: (StringConstructor | NumberConstructor)[];
default: number;
};
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, ("change" | "update:modelValue" | "slideend")[], "change" | "update:modelValue" | "slideend", PublicProps, Readonly<ExtractPropTypes<    {
color: StringConstructor;
disabled: BooleanConstructor;
inverted: BooleanConstructor;
labeled: (BooleanConstructor | StringConstructor)[];
labels: ArrayConstructor;
max: {
type: NumberConstructor;
default: number;
};
min: {
type: NumberConstructor;
default: number;
};
modelValue: {
type: (NumberConstructor | ArrayConstructor)[];
default: number;
};
range: BooleanConstructor;
reversed: BooleanConstructor;
size: StringConstructor;
step: {
type: NumberConstructor;
default: number;
};
vertical: BooleanConstructor;
verticalHeight: {
type: (StringConstructor | NumberConstructor)[];
default: number;
};
}>> & {
onChange?: ((...args: any[]) => any) | undefined;
"onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
onSlideend?: ((...args: any[]) => any) | undefined;
}, {
disabled: boolean;
inverted: boolean;
vertical: boolean;
step: number;
modelValue: number | unknown[];
range: boolean;
reversed: boolean;
max: number;
min: number;
verticalHeight: string | number;
}, {}>;
export { _default_122 as Slider }
export { _default_122 as SuiSlider }

declare const _default_123: DefineComponent<    {
activeIndex: {
type: NumberConstructor;
default: number;
};
pointing: BooleanConstructor;
secondary: BooleanConstructor;
text: BooleanConstructor;
}, {
onClick: (event: any, i: number) => void;
onKeyDown: (event: KeyboardEvent, i: number) => void;
tabIndex: Ref<number>;
tabs: ComputedRef<any>;
tabMenuClass: ComputedRef<string>;
isDefaultMenu: ComputedRef<boolean>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, ("update:activeIndex" | "tab-change" | "tab-click")[], "update:activeIndex" | "tab-change" | "tab-click", PublicProps, Readonly<ExtractPropTypes<    {
activeIndex: {
type: NumberConstructor;
default: number;
};
pointing: BooleanConstructor;
secondary: BooleanConstructor;
text: BooleanConstructor;
}>> & {
"onUpdate:activeIndex"?: ((...args: any[]) => any) | undefined;
"onTab-change"?: ((...args: any[]) => any) | undefined;
"onTab-click"?: ((...args: any[]) => any) | undefined;
}, {
text: boolean;
secondary: boolean;
pointing: boolean;
activeIndex: number;
}, {}>;
export { _default_123 as SuiTab }
export { _default_123 as Tab }

declare const _default_124: DefineComponent<    {
active: BooleanConstructor;
attached: (BooleanConstructor | StringConstructor)[];
header: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
attached: (BooleanConstructor | StringConstructor)[];
header: StringConstructor;
}>>, {
active: boolean;
}, {}>;
export { _default_124 as SuiTabPanel }
export { _default_124 as TabPanel }

declare const _default_125: DefineComponent<    {
animation: {
type: PropType<AnimationType>;
default: string;
};
duration: {
type: NumberConstructor;
default: number;
};
}, {
onEnter: ComputedRef<(el: Element, done: () => void) => void>;
onLeave: ComputedRef<(el: Element, done: () => void) => void>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
animation: {
type: PropType<AnimationType>;
default: string;
};
duration: {
type: NumberConstructor;
default: number;
};
}>>, {
duration: number;
animation: AnimationType;
}, {}>;
export { _default_125 as SuiTransition }
export { _default_125 as Transition }

declare const _default_126: DefineComponent<    {
attached: {
type: PropType<Attached>;
validator: (v: any) => boolean;
};
aligned: PropType<"left" | "centered">;
basic: BooleanConstructor;
vertical: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
attached: {
type: PropType<Attached>;
validator: (v: any) => boolean;
};
aligned: PropType<"left" | "centered">;
basic: BooleanConstructor;
vertical: BooleanConstructor;
}>>, {
basic: boolean;
vertical: boolean;
}, {}>;

declare const _default_13: DefineComponent<    {
as: StringConstructor;
size: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
size: StringConstructor;
}>>, {}, {}>;
export { _default_13 as IconGroup }
export { _default_13 as SuiIconGroup }

declare const _default_14: DefineComponent<    {
floated: Prop<string>;
verticalAlign: Prop<string>;
as: StringConstructor;
avatar: BooleanConstructor;
bordered: BooleanConstructor;
centered: BooleanConstructor;
circular: BooleanConstructor;
disabled: BooleanConstructor;
fluid: BooleanConstructor;
hidden: BooleanConstructor;
href: StringConstructor;
inline: BooleanConstructor;
label: ObjectConstructor;
target: StringConstructor;
wrapped: BooleanConstructor;
rounded: BooleanConstructor;
size: StringConstructor;
spaced: (BooleanConstructor | StringConstructor)[];
src: StringConstructor;
}, () => VNode<RendererNode, RendererElement, {
[key: string]: any;
}>, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
floated: Prop<string>;
verticalAlign: Prop<string>;
as: StringConstructor;
avatar: BooleanConstructor;
bordered: BooleanConstructor;
centered: BooleanConstructor;
circular: BooleanConstructor;
disabled: BooleanConstructor;
fluid: BooleanConstructor;
hidden: BooleanConstructor;
href: StringConstructor;
inline: BooleanConstructor;
label: ObjectConstructor;
target: StringConstructor;
wrapped: BooleanConstructor;
rounded: BooleanConstructor;
size: StringConstructor;
spaced: (BooleanConstructor | StringConstructor)[];
src: StringConstructor;
}>>, {
hidden: boolean;
bordered: boolean;
circular: boolean;
disabled: boolean;
fluid: boolean;
centered: boolean;
inline: boolean;
avatar: boolean;
wrapped: boolean;
rounded: boolean;
}, {}>;
export { _default_14 as Image }
export { _default_14 as SuiImage }

declare const _default_15: DefineComponent<    {
size: StringConstructor;
}, () => VNode<RendererNode, RendererElement, {
[key: string]: any;
}>, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
size: StringConstructor;
}>>, {}, {}>;
export { _default_15 as ImageGroup }
export { _default_15 as SuiImageGroup }

declare const _default_16: DefineComponent<    {
action: StringConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
fluid: BooleanConstructor;
focus: BooleanConstructor;
icon: StringConstructor;
iconPosition: StringConstructor;
inverted: BooleanConstructor;
label: StringConstructor;
labeled: BooleanConstructor;
loading: BooleanConstructor;
modelValue: StringConstructor;
placeholder: StringConstructor;
size: StringConstructor;
transparent: BooleanConstructor;
type: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, "update:modelValue"[], "update:modelValue", PublicProps, Readonly<ExtractPropTypes<    {
action: StringConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
fluid: BooleanConstructor;
focus: BooleanConstructor;
icon: StringConstructor;
iconPosition: StringConstructor;
inverted: BooleanConstructor;
label: StringConstructor;
labeled: BooleanConstructor;
loading: BooleanConstructor;
modelValue: StringConstructor;
placeholder: StringConstructor;
size: StringConstructor;
transparent: BooleanConstructor;
type: StringConstructor;
}>> & {
"onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
}, {
disabled: boolean;
inverted: boolean;
loading: boolean;
error: boolean;
focus: boolean;
fluid: boolean;
labeled: boolean;
transparent: boolean;
}, {}>;
export { _default_16 as Input }
export { _default_16 as SuiInput }

declare const _default_17: DefineComponent<    {
as: StringConstructor;
attached: StringConstructor;
basic: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
content: StringConstructor;
corner: StringConstructor;
empty: BooleanConstructor;
floating: BooleanConstructor;
horizontal: BooleanConstructor;
icon: StringConstructor;
iconPos: PropType<"right">;
image: BooleanConstructor;
inverted: BooleanConstructor;
pointing: (BooleanConstructor | StringConstructor)[];
prompt: BooleanConstructor;
ribbon: (BooleanConstructor | StringConstructor)[];
size: StringConstructor;
tag: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
attached: StringConstructor;
basic: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
content: StringConstructor;
corner: StringConstructor;
empty: BooleanConstructor;
floating: BooleanConstructor;
horizontal: BooleanConstructor;
icon: StringConstructor;
iconPos: PropType<"right">;
image: BooleanConstructor;
inverted: BooleanConstructor;
pointing: (BooleanConstructor | StringConstructor)[];
prompt: BooleanConstructor;
ribbon: (BooleanConstructor | StringConstructor)[];
size: StringConstructor;
tag: BooleanConstructor;
}>>, {
image: boolean;
circular: boolean;
inverted: boolean;
basic: boolean;
floating: boolean;
horizontal: boolean;
empty: boolean;
prompt: boolean;
tag: boolean;
}, {}>;
export { _default_17 as Label }
export { _default_17 as SuiLabel }

declare const _default_18: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_18 as LabelDetail }
export { _default_18 as SuiLabelDetail }

declare const _default_19: DefineComponent<    {
basic: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
size: StringConstructor;
tag: BooleanConstructor;
}, () => VNode<RendererNode, RendererElement, {
[key: string]: any;
}>, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
basic: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
size: StringConstructor;
tag: BooleanConstructor;
}>>, {
circular: boolean;
basic: boolean;
tag: boolean;
}, {}>;
export { _default_19 as LabelGroup }
export { _default_19 as SuiLabelGroup }

declare const _default_2: DefineComponent<    {
loading: {
type: PropType<boolean | Loading>;
validator: (v: any) => boolean;
};
labeled: PropType<(string | boolean) | boolean>;
icon: PropType<string | boolean>;
iconPos: PropType<"left" | "right">;
active: BooleanConstructor;
animated: (BooleanConstructor | StringConstructor)[];
as: {
type: StringConstructor;
default: string;
};
attached: StringConstructor;
basic: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
compact: BooleanConstructor;
content: PropType<string | VNode[]>;
disabled: BooleanConstructor;
facebook: BooleanConstructor;
floated: StringConstructor;
fluid: BooleanConstructor;
google: BooleanConstructor;
linkedin: BooleanConstructor;
instagram: BooleanConstructor;
inverted: BooleanConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
primary: BooleanConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
telegram: BooleanConstructor;
tertiary: BooleanConstructor;
toggle: BooleanConstructor;
twitter: BooleanConstructor;
vk: BooleanConstructor;
whatsapp: BooleanConstructor;
youtube: BooleanConstructor;
}, {
classes: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
loading: {
type: PropType<boolean | Loading>;
validator: (v: any) => boolean;
};
labeled: PropType<(string | boolean) | boolean>;
icon: PropType<string | boolean>;
iconPos: PropType<"left" | "right">;
active: BooleanConstructor;
animated: (BooleanConstructor | StringConstructor)[];
as: {
type: StringConstructor;
default: string;
};
attached: StringConstructor;
basic: BooleanConstructor;
circular: BooleanConstructor;
color: StringConstructor;
compact: BooleanConstructor;
content: PropType<string | VNode[]>;
disabled: BooleanConstructor;
facebook: BooleanConstructor;
floated: StringConstructor;
fluid: BooleanConstructor;
google: BooleanConstructor;
linkedin: BooleanConstructor;
instagram: BooleanConstructor;
inverted: BooleanConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
primary: BooleanConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
telegram: BooleanConstructor;
tertiary: BooleanConstructor;
toggle: BooleanConstructor;
twitter: BooleanConstructor;
vk: BooleanConstructor;
whatsapp: BooleanConstructor;
youtube: BooleanConstructor;
}>>, {
active: boolean;
compact: boolean;
as: string;
circular: boolean;
disabled: boolean;
inverted: boolean;
primary: boolean;
secondary: boolean;
toggle: boolean;
basic: boolean;
fluid: boolean;
facebook: boolean;
google: boolean;
linkedin: boolean;
instagram: boolean;
negative: boolean;
positive: boolean;
telegram: boolean;
tertiary: boolean;
twitter: boolean;
vk: boolean;
whatsapp: boolean;
youtube: boolean;
}, {}>;
export { _default_2 as Button }
export { _default_2 as SuiButton }

declare const _default_20: DefineComponent<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
animated: BooleanConstructor;
as: StringConstructor;
bulleted: BooleanConstructor;
celled: BooleanConstructor;
divided: BooleanConstructor;
floated: StringConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
items: PropType<string[] | {
[key: string]: any;
}[]>;
ordered: BooleanConstructor;
relaxed: BooleanConstructor;
link: BooleanConstructor;
selection: BooleanConstructor;
verticalAlign: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
animated: BooleanConstructor;
as: StringConstructor;
bulleted: BooleanConstructor;
celled: BooleanConstructor;
divided: BooleanConstructor;
floated: StringConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
items: PropType<string[] | {
[key: string]: any;
}[]>;
ordered: BooleanConstructor;
relaxed: BooleanConstructor;
link: BooleanConstructor;
selection: BooleanConstructor;
verticalAlign: StringConstructor;
}>>, {
link: boolean;
inverted: boolean;
animated: boolean;
horizontal: boolean;
selection: boolean;
celled: boolean;
divided: boolean;
relaxed: boolean;
bulleted: boolean;
ordered: boolean;
}, {}>;
export { _default_20 as List }
export { _default_20 as SuiList }

declare const _default_21: DefineComponent<    {
verticalAlign: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
verticalAlign: StringConstructor;
}>>, {}, {}>;
export { _default_21 as ListContent }
export { _default_21 as SuiListContent }

declare const _default_22: DefineComponent<    {
as: {
type: StringConstructor;
default: string;
validator: (value: string) => boolean;
};
}, () => VNode<RendererNode, RendererElement, {
[key: string]: any;
}>, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: {
type: StringConstructor;
default: string;
validator: (value: string) => boolean;
};
}>>, {
as: string;
}, {}>;
export { _default_22 as ListDescription }
export { _default_22 as SuiListDescription }

declare const _default_23: DefineComponent<    {
as: {
type: StringConstructor;
default: string;
validator: (value: string) => boolean;
};
}, () => VNode<RendererNode, RendererElement, {
[key: string]: any;
}>, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: {
type: StringConstructor;
default: string;
validator: (value: string) => boolean;
};
}>>, {
as: string;
}, {}>;
export { _default_23 as ListHeader }
export { _default_23 as SuiListHeader }

declare const _default_24: DefineComponent<    {}, () => VNode<RendererNode, RendererElement, {
[key: string]: any;
}>, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_24 as ListIcon }
export { _default_24 as SuiListIcon }

declare const _default_25: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_25 as ListList }
export { _default_25 as SuiListList }

declare const _default_26: DefineComponent<    {
active: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
fast: BooleanConstructor;
indeterminate: BooleanConstructor;
inline: (BooleanConstructor | StringConstructor)[];
inverted: BooleanConstructor;
size: StringConstructor;
slow: BooleanConstructor;
text: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
fast: BooleanConstructor;
indeterminate: BooleanConstructor;
inline: (BooleanConstructor | StringConstructor)[];
inverted: BooleanConstructor;
size: StringConstructor;
slow: BooleanConstructor;
text: BooleanConstructor;
}>>, {
active: boolean;
text: boolean;
disabled: boolean;
inverted: boolean;
indeterminate: boolean;
slow: boolean;
fast: boolean;
}, {}>;
export { _default_26 as Loader }
export { _default_26 as SuiLoader }

declare const _default_27: DefineComponent<    {
attached: BooleanConstructor;
close: (BooleanConstructor | StringConstructor)[];
dividing: BooleanConstructor;
internal: BooleanConstructor;
position: StringConstructor;
size: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
attached: BooleanConstructor;
close: (BooleanConstructor | StringConstructor)[];
dividing: BooleanConstructor;
internal: BooleanConstructor;
position: StringConstructor;
size: StringConstructor;
}>>, {
attached: boolean;
dividing: boolean;
internal: boolean;
}, {}>;
export { _default_27 as Rail }
export { _default_27 as SuiRail }

declare const _default_28: DefineComponent<    {
active: BooleanConstructor;
animated: StringConstructor;
disabled: BooleanConstructor;
instant: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
animated: StringConstructor;
disabled: BooleanConstructor;
instant: BooleanConstructor;
}>>, {
active: boolean;
disabled: boolean;
instant: boolean;
}, {}>;
export { _default_28 as Reveal }
export { _default_28 as SuiReveal }

declare const _default_29: DefineComponent<    {
visible: BooleanConstructor;
hidden: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
visible: BooleanConstructor;
hidden: BooleanConstructor;
}>>, {
hidden: boolean;
visible: boolean;
}, {}>;
export { _default_29 as RevealContent }
export { _default_29 as SuiRevealContent }

declare const _default_3: DefineComponent<    {
hidden: BooleanConstructor;
visible: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
hidden: BooleanConstructor;
visible: BooleanConstructor;
}>>, {
hidden: boolean;
visible: boolean;
}, {}>;
export { _default_3 as ButtonContent }
export { _default_3 as SuiButtonContent }

declare const _default_30: DefineComponent<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
color: {
type: PropType<Color>;
validator: (v: any) => boolean;
};
attached: (BooleanConstructor | StringConstructor)[];
basic: BooleanConstructor;
circular: BooleanConstructor;
clearing: BooleanConstructor;
compact: BooleanConstructor;
disabled: BooleanConstructor;
fitted: (BooleanConstructor | StringConstructor)[];
floated: StringConstructor;
inverted: BooleanConstructor;
loading: BooleanConstructor;
padded: (BooleanConstructor | StringConstructor)[];
piled: BooleanConstructor;
placeholder: BooleanConstructor;
raised: BooleanConstructor;
scrolling: PropType<boolean | "very long" | "long" | "short" | "very short">;
secondary: BooleanConstructor;
stacked: BooleanConstructor;
tertiary: BooleanConstructor;
textAlign: StringConstructor;
vertical: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
color: {
type: PropType<Color>;
validator: (v: any) => boolean;
};
attached: (BooleanConstructor | StringConstructor)[];
basic: BooleanConstructor;
circular: BooleanConstructor;
clearing: BooleanConstructor;
compact: BooleanConstructor;
disabled: BooleanConstructor;
fitted: (BooleanConstructor | StringConstructor)[];
floated: StringConstructor;
inverted: BooleanConstructor;
loading: BooleanConstructor;
padded: (BooleanConstructor | StringConstructor)[];
piled: BooleanConstructor;
placeholder: BooleanConstructor;
raised: BooleanConstructor;
scrolling: PropType<boolean | "very long" | "long" | "short" | "very short">;
secondary: BooleanConstructor;
stacked: BooleanConstructor;
tertiary: BooleanConstructor;
textAlign: StringConstructor;
vertical: BooleanConstructor;
}>>, {
compact: boolean;
circular: boolean;
disabled: boolean;
inverted: boolean;
loading: boolean;
secondary: boolean;
basic: boolean;
tertiary: boolean;
vertical: boolean;
placeholder: boolean;
raised: boolean;
clearing: boolean;
piled: boolean;
stacked: boolean;
}, {}>;
export { _default_30 as Segment }
export { _default_30 as SuiSegment }

declare const _default_31: DefineSetupFnComponent<    {
size: "big" | "small" | "mini" | "tiny" | "medium" | "large" | "huge" | "massive";
basic: boolean;
compact: boolean;
horizontal: boolean;
piled: boolean;
raised: boolean;
stacked: boolean;
}, {}, {}, {
size: "big" | "small" | "mini" | "tiny" | "medium" | "large" | "huge" | "massive";
basic: boolean;
compact: boolean;
horizontal: boolean;
piled: boolean;
raised: boolean;
stacked: boolean;
} & {}, PublicProps>;
export { _default_31 as SegmentGroup }
export { _default_31 as SuiSegmentGroup }

declare const _default_32: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_32 as SegmentInline }
export { _default_32 as SuiSegmentInline }

declare const _default_33: DefineComponent<    {
active: BooleanConstructor;
completed: BooleanConstructor;
description: StringConstructor;
disabled: BooleanConstructor;
fluid: BooleanConstructor;
href: StringConstructor;
icon: StringConstructor;
link: BooleanConstructor;
title: StringConstructor;
vertical: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
completed: BooleanConstructor;
description: StringConstructor;
disabled: BooleanConstructor;
fluid: BooleanConstructor;
href: StringConstructor;
icon: StringConstructor;
link: BooleanConstructor;
title: StringConstructor;
vertical: BooleanConstructor;
}>>, {
active: boolean;
link: boolean;
disabled: boolean;
fluid: boolean;
vertical: boolean;
completed: boolean;
}, {}>;
export { _default_33 as Step }
export { _default_33 as SuiStep }

declare const _default_34: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_34 as StepContent }
export { _default_34 as SuiStepContent }

declare const _default_35: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_35 as StepDescription }
export { _default_35 as SuiStepDescription }

declare const _default_36: DefineComponent<    {
activeStep: {
type: NumberConstructor;
default: number;
};
attached: StringConstructor;
evenlyDivided: BooleanConstructor;
fluid: BooleanConstructor;
inverted: BooleanConstructor;
noCompleted: BooleanConstructor;
ordered: BooleanConstructor;
size: StringConstructor;
stackable: StringConstructor;
steps: () => Array<{
title: string;
description?: string;
icon?: string;
}>;
unstackable: BooleanConstructor;
vertical: BooleanConstructor;
widths: NumberConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
activeStep: {
type: NumberConstructor;
default: number;
};
attached: StringConstructor;
evenlyDivided: BooleanConstructor;
fluid: BooleanConstructor;
inverted: BooleanConstructor;
noCompleted: BooleanConstructor;
ordered: BooleanConstructor;
size: StringConstructor;
stackable: StringConstructor;
steps: () => Array<{
title: string;
description?: string;
icon?: string;
}>;
unstackable: BooleanConstructor;
vertical: BooleanConstructor;
widths: NumberConstructor;
}>>, {
inverted: boolean;
fluid: boolean;
vertical: boolean;
unstackable: boolean;
ordered: boolean;
activeStep: number;
evenlyDivided: boolean;
noCompleted: boolean;
}, {}>;
export { _default_36 as StepGroup }
export { _default_36 as SuiStepGroup }

declare const _default_37: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_37 as StepTitle }
export { _default_37 as SuiStepTitle }

declare const _default_38: DefineComponent<    {
icon: StringConstructor;
inverted: BooleanConstructor;
sections: {
type: ArrayConstructor;
default: () => never[];
};
size: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
icon: StringConstructor;
inverted: BooleanConstructor;
sections: {
type: ArrayConstructor;
default: () => never[];
};
size: StringConstructor;
}>>, {
inverted: boolean;
sections: unknown[];
}, {}>;
export { _default_38 as Breadcrumb }
export { _default_38 as SuiBreadcrumb }

declare const _default_39: DefineComponent<    {
icon: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
icon: StringConstructor;
}>>, {}, {}>;
export { _default_39 as BreadcrumbDivider }
export { _default_39 as SuiBreadcrumbDivider }

declare const _default_4: DefineComponent<    {
attached: StringConstructor;
basic: BooleanConstructor;
color: StringConstructor;
icon: BooleanConstructor;
labeled: BooleanConstructor;
size: StringConstructor;
vertical: BooleanConstructor;
widths: NumberConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
attached: StringConstructor;
basic: BooleanConstructor;
color: StringConstructor;
icon: BooleanConstructor;
labeled: BooleanConstructor;
size: StringConstructor;
vertical: BooleanConstructor;
widths: NumberConstructor;
}>>, {
icon: boolean;
basic: boolean;
labeled: boolean;
vertical: boolean;
}, {}>;
export { _default_4 as ButtonGroup }
export { _default_4 as SuiButtonGroup }

declare const _default_40: DefineComponent<    {
active: BooleanConstructor;
href: StringConstructor;
link: BooleanConstructor;
to: StringConstructor;
}, {
computedClass: ComputedRef<string>;
isLink: boolean;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
href: StringConstructor;
link: BooleanConstructor;
to: StringConstructor;
}>>, {
active: boolean;
link: boolean;
}, {}>;
export { _default_40 as BreadcrumbSection }
export { _default_40 as SuiBreadcrumbSection }

declare const _default_41: DefineComponent<    {
error: BooleanConstructor;
info: BooleanConstructor;
inverted: BooleanConstructor;
loading: BooleanConstructor;
reply: BooleanConstructor;
success: BooleanConstructor;
unstackable: BooleanConstructor;
warning: BooleanConstructor;
size: StringConstructor;
}, {
classes: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
error: BooleanConstructor;
info: BooleanConstructor;
inverted: BooleanConstructor;
loading: BooleanConstructor;
reply: BooleanConstructor;
success: BooleanConstructor;
unstackable: BooleanConstructor;
warning: BooleanConstructor;
size: StringConstructor;
}>>, {
inverted: boolean;
loading: boolean;
error: boolean;
info: boolean;
reply: boolean;
success: boolean;
unstackable: boolean;
warning: boolean;
}, {}>;
export { _default_41 as Form }
export { _default_41 as SuiForm }

declare const _default_42: DefineComponent<    {
disabled: BooleanConstructor;
error: BooleanConstructor;
inline: BooleanConstructor;
label: StringConstructor;
modelValue: StringConstructor;
placeholder: StringConstructor;
required: BooleanConstructor;
type: StringConstructor;
width: StringConstructor;
}, {
computedClass: ComputedRef<string>;
inputType: string;
onInput: (event: any) => void;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, "update:modelValue"[], "update:modelValue", PublicProps, Readonly<ExtractPropTypes<    {
disabled: BooleanConstructor;
error: BooleanConstructor;
inline: BooleanConstructor;
label: StringConstructor;
modelValue: StringConstructor;
placeholder: StringConstructor;
required: BooleanConstructor;
type: StringConstructor;
width: StringConstructor;
}>> & {
"onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
}, {
disabled: boolean;
error: boolean;
required: boolean;
inline: boolean;
}, {}>;
export { _default_42 as FormField }
export { _default_42 as SuiFormField }

declare const _default_43: DefineComponent<    {
widths: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
widths: StringConstructor;
}>>, {}, {}>;
export { _default_43 as FormGroup }
export { _default_43 as SuiFormGroup }

declare const _default_44: DefineComponent<    {
label: StringConstructor;
placeholder: StringConstructor;
rows: (StringConstructor | NumberConstructor)[];
}, unknown, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
label: StringConstructor;
placeholder: StringConstructor;
rows: (StringConstructor | NumberConstructor)[];
}>>, {}, {}>;
export { _default_44 as FormTextarea }
export { _default_44 as SuiFormTextarea }

declare const _default_45: DefineComponent<    {
celled: (BooleanConstructor | StringConstructor)[];
centered: BooleanConstructor;
columns: (StringConstructor | NumberConstructor)[];
compact: BooleanConstructor;
container: BooleanConstructor;
divided: (BooleanConstructor | StringConstructor)[];
doubling: BooleanConstructor;
inverted: BooleanConstructor;
padded: (BooleanConstructor | StringConstructor)[];
relaxed: (BooleanConstructor | StringConstructor)[];
reversed: StringConstructor;
stackable: BooleanConstructor;
textAlign: StringConstructor;
verticalAlign: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
celled: (BooleanConstructor | StringConstructor)[];
centered: BooleanConstructor;
columns: (StringConstructor | NumberConstructor)[];
compact: BooleanConstructor;
container: BooleanConstructor;
divided: (BooleanConstructor | StringConstructor)[];
doubling: BooleanConstructor;
inverted: BooleanConstructor;
padded: (BooleanConstructor | StringConstructor)[];
relaxed: (BooleanConstructor | StringConstructor)[];
reversed: StringConstructor;
stackable: BooleanConstructor;
textAlign: StringConstructor;
verticalAlign: StringConstructor;
}>>, {
compact: boolean;
inverted: boolean;
centered: boolean;
doubling: boolean;
stackable: boolean;
container: boolean;
}, {}>;
export { _default_45 as Grid }
export { _default_45 as SuiGrid }

declare const _default_46: DefineComponent<    {
color: StringConstructor;
computer: NumberConstructor;
floated: StringConstructor;
largeScreen: NumberConstructor;
mobile: NumberConstructor;
only: StringConstructor;
tablet: NumberConstructor;
textAlign: StringConstructor;
width: NumberConstructor;
widescreen: NumberConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
color: StringConstructor;
computer: NumberConstructor;
floated: StringConstructor;
largeScreen: NumberConstructor;
mobile: NumberConstructor;
only: StringConstructor;
tablet: NumberConstructor;
textAlign: StringConstructor;
width: NumberConstructor;
widescreen: NumberConstructor;
}>>, {}, {}>;
export { _default_46 as GridColumn }
export { _default_46 as SuiGridColumn }

declare const _default_47: DefineComponent<    {
centered: BooleanConstructor;
color: StringConstructor;
columns: NumberConstructor;
only: StringConstructor;
stretched: BooleanConstructor;
textAlign: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
centered: BooleanConstructor;
color: StringConstructor;
columns: NumberConstructor;
only: StringConstructor;
stretched: BooleanConstructor;
textAlign: StringConstructor;
}>>, {
centered: boolean;
stretched: boolean;
}, {}>;
export { _default_47 as GridRow }
export { _default_47 as SuiGridRow }

declare const _default_48: DefineComponent<    {
activeIndex: NumberConstructor;
attached: (BooleanConstructor | StringConstructor)[];
borderless: BooleanConstructor;
color: BooleanConstructor;
compact: BooleanConstructor;
fixed: BooleanConstructor;
floated: (BooleanConstructor | StringConstructor)[];
fluid: BooleanConstructor;
icon: (BooleanConstructor | StringConstructor)[];
inverted: BooleanConstructor;
items: PropType<MenuItemOption[]>;
pagination: BooleanConstructor;
pointing: BooleanConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
stackable: BooleanConstructor;
tabular: (BooleanConstructor | StringConstructor)[];
text: BooleanConstructor;
vertical: BooleanConstructor;
widths: NumberConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, ("transitionend" | "selected" | "update:activeIndex")[], "transitionend" | "selected" | "update:activeIndex", PublicProps, Readonly<ExtractPropTypes<    {
activeIndex: NumberConstructor;
attached: (BooleanConstructor | StringConstructor)[];
borderless: BooleanConstructor;
color: BooleanConstructor;
compact: BooleanConstructor;
fixed: BooleanConstructor;
floated: (BooleanConstructor | StringConstructor)[];
fluid: BooleanConstructor;
icon: (BooleanConstructor | StringConstructor)[];
inverted: BooleanConstructor;
items: PropType<MenuItemOption[]>;
pagination: BooleanConstructor;
pointing: BooleanConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
stackable: BooleanConstructor;
tabular: (BooleanConstructor | StringConstructor)[];
text: BooleanConstructor;
vertical: BooleanConstructor;
widths: NumberConstructor;
}>> & {
onTransitionend?: ((...args: any[]) => any) | undefined;
onSelected?: ((...args: any[]) => any) | undefined;
"onUpdate:activeIndex"?: ((...args: any[]) => any) | undefined;
}, {
compact: boolean;
fixed: boolean;
text: boolean;
color: boolean;
inverted: boolean;
secondary: boolean;
fluid: boolean;
vertical: boolean;
stackable: boolean;
pointing: boolean;
borderless: boolean;
pagination: boolean;
}, {}>;
export { _default_48 as Menu }
export { _default_48 as SuiMenu }

declare const _default_49: DefineComponent<    {
as: StringConstructor;
content: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
content: StringConstructor;
}>>, {}, {}>;
export { _default_49 as MenuHeader }
export { _default_49 as SuiMenuHeader }

declare const _default_5: DefineComponent<    {
fluid: BooleanConstructor;
text: BooleanConstructor;
textAlign: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
fluid: BooleanConstructor;
text: BooleanConstructor;
textAlign: StringConstructor;
}>>, {
text: boolean;
fluid: boolean;
}, {}>;
export { _default_5 as Container }
export { _default_5 as SuiContainer }

declare const _default_50: DefineComponent<    {
action: BooleanConstructor;
active: BooleanConstructor;
as: StringConstructor;
browse: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
fitted: (BooleanConstructor | StringConstructor)[];
header: BooleanConstructor;
icon: BooleanConstructor;
index: NumberConstructor;
link: BooleanConstructor;
name: StringConstructor;
position: StringConstructor;
stackable: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, "selected"[], "selected", PublicProps, Readonly<ExtractPropTypes<    {
action: BooleanConstructor;
active: BooleanConstructor;
as: StringConstructor;
browse: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
fitted: (BooleanConstructor | StringConstructor)[];
header: BooleanConstructor;
icon: BooleanConstructor;
index: NumberConstructor;
link: BooleanConstructor;
name: StringConstructor;
position: StringConstructor;
stackable: BooleanConstructor;
}>> & {
onSelected?: ((...args: any[]) => any) | undefined;
}, {
active: boolean;
link: boolean;
header: boolean;
disabled: boolean;
icon: boolean;
stackable: boolean;
action: boolean;
browse: boolean;
}, {}>;
export { _default_50 as MenuItem }
export { _default_50 as SuiMenuItem }

declare const _default_51: DefineComponent<    {
position: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
position: StringConstructor;
}>>, {}, {}>;
export { _default_51 as MenuMenu }
export { _default_51 as SuiMenuMenu }

declare const _default_52: DefineComponent<    {
attached: (BooleanConstructor | StringConstructor)[];
aligned: PropType<"center" | "right">;
color: StringConstructor;
closable: BooleanConstructor;
compact: BooleanConstructor;
content: StringConstructor;
header: StringConstructor;
error: BooleanConstructor;
floating: BooleanConstructor;
hidden: BooleanConstructor;
icon: (BooleanConstructor | StringConstructor)[];
info: BooleanConstructor;
list: ArrayConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
size: StringConstructor;
success: BooleanConstructor;
visible: BooleanConstructor;
warning: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, "close"[], "close", PublicProps, Readonly<ExtractPropTypes<    {
attached: (BooleanConstructor | StringConstructor)[];
aligned: PropType<"center" | "right">;
color: StringConstructor;
closable: BooleanConstructor;
compact: BooleanConstructor;
content: StringConstructor;
header: StringConstructor;
error: BooleanConstructor;
floating: BooleanConstructor;
hidden: BooleanConstructor;
icon: (BooleanConstructor | StringConstructor)[];
info: BooleanConstructor;
list: ArrayConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
size: StringConstructor;
success: BooleanConstructor;
visible: BooleanConstructor;
warning: BooleanConstructor;
}>> & {
onClose?: ((...args: any[]) => any) | undefined;
}, {
compact: boolean;
hidden: boolean;
visible: boolean;
error: boolean;
negative: boolean;
positive: boolean;
floating: boolean;
info: boolean;
success: boolean;
warning: boolean;
closable: boolean;
}, {}>;
export { _default_52 as Message }
export { _default_52 as SuiMessage }

declare const _default_53: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_53 as MessageContent }
export { _default_53 as SuiMessageContent }

declare const _default_54: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_54 as MessageHeader }
export { _default_54 as SuiMessageHeader }

declare const _default_55: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_55 as MessageItem }
export { _default_55 as SuiMessageItem }

declare const _default_56: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_56 as MessageList }
export { _default_56 as SuiMessageList }

declare const _default_57: DefineComponent<    {
scrolling: {
type: PropType<Scrolling>;
validator: (v: any) => boolean;
default: string | undefined;
};
attached: (BooleanConstructor | StringConstructor)[];
basic: (BooleanConstructor | StringConstructor)[];
celled: BooleanConstructor;
collapsing: BooleanConstructor;
color: StringConstructor;
columns: NumberConstructor;
compact: (BooleanConstructor | StringConstructor)[];
definition: BooleanConstructor;
definitionClass: StringConstructor;
fixed: BooleanConstructor;
hideHeader: BooleanConstructor;
inverted: BooleanConstructor;
items: ArrayConstructor;
rowActive: FunctionConstructor;
rowClass: (BooleanConstructor | FunctionConstructor)[];
rowColor: FunctionConstructor;
rowDisabled: FunctionConstructor;
rowError: FunctionConstructor;
rowNegative: FunctionConstructor;
rowPositive: FunctionConstructor;
rowWarning: FunctionConstructor;
rowsGroupBy: StringConstructor;
padded: (BooleanConstructor | StringConstructor)[];
selectable: BooleanConstructor;
singleLine: BooleanConstructor;
size: StringConstructor;
stackable: BooleanConstructor;
striped: BooleanConstructor;
structured: BooleanConstructor;
unstackable: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
scrolling: {
type: PropType<Scrolling>;
validator: (v: any) => boolean;
default: string | undefined;
};
attached: (BooleanConstructor | StringConstructor)[];
basic: (BooleanConstructor | StringConstructor)[];
celled: BooleanConstructor;
collapsing: BooleanConstructor;
color: StringConstructor;
columns: NumberConstructor;
compact: (BooleanConstructor | StringConstructor)[];
definition: BooleanConstructor;
definitionClass: StringConstructor;
fixed: BooleanConstructor;
hideHeader: BooleanConstructor;
inverted: BooleanConstructor;
items: ArrayConstructor;
rowActive: FunctionConstructor;
rowClass: (BooleanConstructor | FunctionConstructor)[];
rowColor: FunctionConstructor;
rowDisabled: FunctionConstructor;
rowError: FunctionConstructor;
rowNegative: FunctionConstructor;
rowPositive: FunctionConstructor;
rowWarning: FunctionConstructor;
rowsGroupBy: StringConstructor;
padded: (BooleanConstructor | StringConstructor)[];
selectable: BooleanConstructor;
singleLine: BooleanConstructor;
size: StringConstructor;
stackable: BooleanConstructor;
striped: BooleanConstructor;
structured: BooleanConstructor;
unstackable: BooleanConstructor;
}>>, {
fixed: boolean;
inverted: boolean;
stackable: boolean;
selectable: boolean;
unstackable: boolean;
celled: boolean;
scrolling: Scrolling;
definition: boolean;
collapsing: boolean;
singleLine: boolean;
hideHeader: boolean;
striped: boolean;
structured: boolean;
}, {}>;
export { _default_57 as SuiTable }
export { _default_57 as Table }

declare const _default_58: DefineComponent<    {
columns: ArrayConstructor;
definitionClass: StringConstructor;
rows: ArrayConstructor;
rowsGroupBy: StringConstructor;
rowActive: FunctionConstructor;
rowClass: (BooleanConstructor | FunctionConstructor)[];
rowColor: FunctionConstructor;
rowDisabled: FunctionConstructor;
rowError: FunctionConstructor;
rowNegative: FunctionConstructor;
rowPositive: FunctionConstructor;
rowWarning: FunctionConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, ("row-click" | "cell-click")[], "row-click" | "cell-click", PublicProps, Readonly<ExtractPropTypes<    {
columns: ArrayConstructor;
definitionClass: StringConstructor;
rows: ArrayConstructor;
rowsGroupBy: StringConstructor;
rowActive: FunctionConstructor;
rowClass: (BooleanConstructor | FunctionConstructor)[];
rowColor: FunctionConstructor;
rowDisabled: FunctionConstructor;
rowError: FunctionConstructor;
rowNegative: FunctionConstructor;
rowPositive: FunctionConstructor;
rowWarning: FunctionConstructor;
}>> & {
"onRow-click"?: ((...args: any[]) => any) | undefined;
"onCell-click"?: ((...args: any[]) => any) | undefined;
}, {}, {}>;
export { _default_58 as SuiTableBody }
export { _default_58 as TableBody }

declare const _default_59: DefineComponent<    {
active: BooleanConstructor;
className: StringConstructor;
collapsing: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
marked: StringConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
rowspan: NumberConstructor;
selectable: BooleanConstructor;
singleLine: BooleanConstructor;
textAlign: StringConstructor;
verticalAlign: StringConstructor;
warning: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
className: StringConstructor;
collapsing: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
marked: StringConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
rowspan: NumberConstructor;
selectable: BooleanConstructor;
singleLine: BooleanConstructor;
textAlign: StringConstructor;
verticalAlign: StringConstructor;
warning: BooleanConstructor;
}>>, {
active: boolean;
disabled: boolean;
error: boolean;
negative: boolean;
positive: boolean;
selectable: boolean;
warning: boolean;
collapsing: boolean;
singleLine: boolean;
}, {}>;
export { _default_59 as SuiTableCell }
export { _default_59 as TableCell }

declare const _default_6: DefineComponent<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
clearing: BooleanConstructor;
fitted: BooleanConstructor;
hidden: BooleanConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
section: BooleanConstructor;
textAlign: StringConstructor;
vertical: BooleanConstructor;
}, {
classes: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
clearing: BooleanConstructor;
fitted: BooleanConstructor;
hidden: BooleanConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
section: BooleanConstructor;
textAlign: StringConstructor;
vertical: BooleanConstructor;
}>>, {
hidden: boolean;
section: boolean;
fitted: boolean;
inverted: boolean;
vertical: boolean;
horizontal: boolean;
clearing: boolean;
}, {}>;
export { _default_6 as Divider }
export { _default_6 as SuiDivider }

declare const _default_60: DefineComponent<    {
fullWidth: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
fullWidth: BooleanConstructor;
}>>, {
fullWidth: boolean;
}, {}>;
export { _default_60 as SuiTableFooter }
export { _default_60 as TableFooter }

declare const _default_61: DefineComponent<    {
columns: ArrayConstructor;
definition: BooleanConstructor;
fullWidth: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
columns: ArrayConstructor;
definition: BooleanConstructor;
fullWidth: BooleanConstructor;
}>>, {
definition: boolean;
fullWidth: boolean;
}, {}>;
export { _default_61 as SuiTableHeader }
export { _default_61 as TableHeader }

declare const _default_62: DefineComponent<    {
singleLine: BooleanConstructor;
textAlign: StringConstructor;
width: NumberConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
singleLine: BooleanConstructor;
textAlign: StringConstructor;
width: NumberConstructor;
}>>, {
singleLine: boolean;
}, {}>;
export { _default_62 as SuiTableHeaderCell }
export { _default_62 as TableHeaderCell }

declare const _default_63: DefineComponent<    {
active: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
textAlign: StringConstructor;
verticalAlign: StringConstructor;
warning: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
error: BooleanConstructor;
negative: BooleanConstructor;
positive: BooleanConstructor;
textAlign: StringConstructor;
verticalAlign: StringConstructor;
warning: BooleanConstructor;
}>>, {
active: boolean;
disabled: boolean;
error: boolean;
negative: boolean;
positive: boolean;
warning: boolean;
}, {}>;
export { _default_63 as SuiTableRow }
export { _default_63 as TableRow }

declare const _default_64: DefineComponent<    {
centered: BooleanConstructor;
test: StringConstructor;
unit: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
centered: BooleanConstructor;
test: StringConstructor;
unit: StringConstructor;
}>>, {
centered: boolean;
}, {}>;
export { _default_64 as Advertisement }
export { _default_64 as SuiAdvertisement }

declare const _default_65: DefineComponent<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
loading: {
type: PropType<boolean | Loading>;
validator: (v: any) => boolean;
};
centered: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
fluid: BooleanConstructor;
horizontal: BooleanConstructor;
href: StringConstructor;
link: BooleanConstructor;
primary: BooleanConstructor;
raised: BooleanConstructor;
secondary: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
size: {
type: PropType<Size>;
validator: (value: string) => boolean;
};
loading: {
type: PropType<boolean | Loading>;
validator: (v: any) => boolean;
};
centered: BooleanConstructor;
color: StringConstructor;
disabled: BooleanConstructor;
fluid: BooleanConstructor;
horizontal: BooleanConstructor;
href: StringConstructor;
link: BooleanConstructor;
primary: BooleanConstructor;
raised: BooleanConstructor;
secondary: BooleanConstructor;
}>>, {
link: boolean;
disabled: boolean;
primary: boolean;
secondary: boolean;
fluid: boolean;
centered: boolean;
horizontal: boolean;
raised: boolean;
}, {}>;
export { _default_65 as Card }
export { _default_65 as SuiCard }

declare const _default_66: DefineComponent<    {
extra: BooleanConstructor;
header: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
extra: BooleanConstructor;
header: StringConstructor;
}>>, {
extra: boolean;
}, {}>;
export { _default_66 as CardContent }
export { _default_66 as SuiCardContent }

declare const _default_67: DefineComponent<    {
textAlign: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
textAlign: StringConstructor;
}>>, {}, {}>;
export { _default_67 as CardDescription }
export { _default_67 as SuiCardDescription }

declare const _default_68: DefineComponent<    {
basic: BooleanConstructor;
centered: BooleanConstructor;
doubling: BooleanConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
itemsPerRow: NumberConstructor;
stackable: BooleanConstructor;
}, {
classes: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
basic: BooleanConstructor;
centered: BooleanConstructor;
doubling: BooleanConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
itemsPerRow: NumberConstructor;
stackable: BooleanConstructor;
}>>, {
inverted: boolean;
basic: boolean;
centered: boolean;
horizontal: boolean;
doubling: boolean;
stackable: boolean;
}, {}>;
export { _default_68 as CardGroup }
export { _default_68 as SuiCardGroup }

declare const _default_69: DefineComponent<    {
textAlign: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
textAlign: StringConstructor;
}>>, {}, {}>;
export { _default_69 as CardHeader }
export { _default_69 as SuiCardHeader }

declare const _default_7: DefineComponent<    {
disabled: BooleanConstructor;
link: BooleanConstructor;
loading: BooleanConstructor;
name: StringConstructor;
size: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
disabled: BooleanConstructor;
link: BooleanConstructor;
loading: BooleanConstructor;
name: StringConstructor;
size: StringConstructor;
}>>, {
link: boolean;
disabled: boolean;
loading: boolean;
}, {}>;
export { _default_7 as Emoji }
export { _default_7 as SuiEmoji }

declare const _default_70: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_70 as CardMeta }
export { _default_70 as SuiCardMeta }

declare const _default_71: DefineComponent<    {
disabled: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
disabled: BooleanConstructor;
}>>, {
disabled: boolean;
}, {}>;
export { _default_71 as Comment }
export { _default_71 as SuiComment }

declare const _default_72: DefineComponent<    {
active: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
}>>, {
active: boolean;
}, {}>;
export { _default_72 as CommentAction }
export { _default_72 as SuiCommentAction }

declare const _default_73: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_73 as CommentActions }
export { _default_73 as SuiCommentActions }

declare const _default_74: DefineComponent<    {
as: StringConstructor;
}, unknown, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
}>>, {}, {}>;
export { _default_74 as CommentAuthor }
export { _default_74 as SuiCommentAuthor }

declare const _default_75: DefineComponent<    {
as: StringConstructor;
src: StringConstructor;
}, unknown, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
src: StringConstructor;
}>>, {}, {}>;
export { _default_75 as CommentAvatar }
export { _default_75 as SuiCommentAvatar }

declare const _default_76: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_76 as CommentContent }
export { _default_76 as SuiCommentContent }

declare const _default_77: DefineComponent<    {
collapsed: BooleanConstructor;
inverted: BooleanConstructor;
minimal: BooleanConstructor;
size: StringConstructor;
threaded: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
collapsed: BooleanConstructor;
inverted: BooleanConstructor;
minimal: BooleanConstructor;
size: StringConstructor;
threaded: BooleanConstructor;
}>>, {
inverted: boolean;
collapsed: boolean;
minimal: boolean;
threaded: boolean;
}, {}>;
export { _default_77 as CommentGroup }
export { _default_77 as SuiCommentGroup }

declare const _default_78: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_78 as CommentMetadata }
export { _default_78 as SuiCommentMetadata }

declare const _default_79: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_79 as CommentText }
export { _default_79 as SuiCommentText }

declare const _default_8: DefineSetupFnComponent<    {
size: "big" | "small" | "mini" | "tiny" | "medium" | "large" | "huge" | "massive";
name: string;
}, {}, {}, {
size: "big" | "small" | "mini" | "tiny" | "medium" | "large" | "huge" | "massive";
name: string;
} & {}, PublicProps>;
export { _default_8 as Flag }
export { _default_8 as SuiFlag }

declare const _default_80: DefineComponent<    {
connected: BooleanConstructor;
disabled: BooleanConstructor;
inverted: BooleanConstructor;
size: StringConstructor;
}, () => VNode<RendererNode, RendererElement, {
[key: string]: any;
}>, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
connected: BooleanConstructor;
disabled: BooleanConstructor;
inverted: BooleanConstructor;
size: StringConstructor;
}>>, {
disabled: boolean;
inverted: boolean;
connected: boolean;
}, {}>;
export { _default_80 as Feed }
export { _default_80 as SuiFeed }

declare const _default_81: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_81 as FeedContent }
export { _default_81 as SuiFeedContent }

declare const _default_82: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_82 as FeedDate }
export { _default_82 as SuiFeedDate }

declare const _default_83: DefineComponent<    {
disabled: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
disabled: BooleanConstructor;
}>>, {
disabled: boolean;
}, {}>;
export { _default_83 as FeedEvent }
export { _default_83 as SuiFeedEvent }

declare const _default_84: DefineComponent<    {
images: BooleanConstructor;
text: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
images: BooleanConstructor;
text: BooleanConstructor;
}>>, {
text: boolean;
images: boolean;
}, {}>;
export { _default_84 as FeedExtra }
export { _default_84 as SuiFeedExtra }

declare const _default_85: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_85 as FeedLabel }
export { _default_85 as SuiFeedLabel }

declare const _default_86: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_86 as FeedLike }
export { _default_86 as SuiFeedLike }

declare const _default_87: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_87 as FeedMeta }
export { _default_87 as SuiFeedMeta }

declare const _default_88: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_88 as FeedSummary }
export { _default_88 as SuiFeedSummary }

declare const _default_89: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_89 as FeedUser }
export { _default_89 as SuiFeedUser }

declare const _default_9: DefineComponent<    {
as: StringConstructor;
attached: (BooleanConstructor | StringConstructor)[];
block: BooleanConstructor;
color: StringConstructor;
content: StringConstructor;
disabled: BooleanConstructor;
dividing: BooleanConstructor;
floated: StringConstructor;
icon: BooleanConstructor;
image: BooleanConstructor;
inverted: BooleanConstructor;
primary: BooleanConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
sub: BooleanConstructor;
subheader: StringConstructor;
textAlign: StringConstructor;
}, {
elementType: string;
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
attached: (BooleanConstructor | StringConstructor)[];
block: BooleanConstructor;
color: StringConstructor;
content: StringConstructor;
disabled: BooleanConstructor;
dividing: BooleanConstructor;
floated: StringConstructor;
icon: BooleanConstructor;
image: BooleanConstructor;
inverted: BooleanConstructor;
primary: BooleanConstructor;
secondary: BooleanConstructor;
size: StringConstructor;
sub: BooleanConstructor;
subheader: StringConstructor;
textAlign: StringConstructor;
}>>, {
sub: boolean;
image: boolean;
disabled: boolean;
inverted: boolean;
primary: boolean;
secondary: boolean;
icon: boolean;
block: boolean;
dividing: boolean;
}, {}>;
export { _default_9 as Header }
export { _default_9 as SuiHeader }

declare const _default_90: DefineComponent<    {
disabled: BooleanConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
disabled: BooleanConstructor;
}>>, {
disabled: boolean;
}, {}>;
export { _default_90 as Item }
export { _default_90 as SuiItem }

declare const _default_91: DefineComponent<    {
verticalAlign: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
verticalAlign: StringConstructor;
}>>, {}, {}>;
export { _default_91 as ItemContent }
export { _default_91 as SuiItemContent }

declare const _default_92: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_92 as ItemDescription }
export { _default_92 as SuiItemDescription }

declare const _default_93: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_93 as ItemExtra }
export { _default_93 as SuiItemExtra }

declare const _default_94: DefineComponent<    {
divided: BooleanConstructor;
inverted: BooleanConstructor;
link: BooleanConstructor;
relaxed: (BooleanConstructor | StringConstructor)[];
unstackable: BooleanConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
divided: BooleanConstructor;
inverted: BooleanConstructor;
link: BooleanConstructor;
relaxed: (BooleanConstructor | StringConstructor)[];
unstackable: BooleanConstructor;
}>>, {
link: boolean;
inverted: boolean;
unstackable: boolean;
divided: boolean;
}, {}>;
export { _default_94 as ItemGroup }
export { _default_94 as SuiItemGroup }

declare const _default_95: DefineComponent<    {
as: StringConstructor;
}, unknown, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
as: StringConstructor;
}>>, {}, {}>;
export { _default_95 as ItemHeader }
export { _default_95 as SuiItemHeader }

declare const _default_96: DefineComponent<    {
size: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
size: StringConstructor;
}>>, {}, {}>;
export { _default_96 as ItemImage }
export { _default_96 as SuiItemImage }

declare const _default_97: DefineComponent<    {}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {}>>, {}, {}>;
export { _default_97 as ItemMeta }
export { _default_97 as SuiItemMeta }

declare const _default_98: DefineComponent<    {
color: StringConstructor;
floated: (BooleanConstructor | StringConstructor)[];
fluid: BooleanConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
label: StringConstructor;
size: StringConstructor;
text: BooleanConstructor;
value: StringConstructor;
}, {
computedClass: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
color: StringConstructor;
floated: (BooleanConstructor | StringConstructor)[];
fluid: BooleanConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
label: StringConstructor;
size: StringConstructor;
text: BooleanConstructor;
value: StringConstructor;
}>>, {
text: boolean;
inverted: boolean;
fluid: boolean;
horizontal: boolean;
}, {}>;
export { _default_98 as Statistic }
export { _default_98 as SuiStatistic }

declare const _default_99: DefineComponent<    {
color: StringConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
size: StringConstructor;
stackable: BooleanConstructor;
widths: NumberConstructor;
}, {
classes: ComputedRef<string>;
}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
color: StringConstructor;
horizontal: BooleanConstructor;
inverted: BooleanConstructor;
size: StringConstructor;
stackable: BooleanConstructor;
widths: NumberConstructor;
}>>, {
inverted: boolean;
horizontal: boolean;
stackable: boolean;
}, {}>;
export { _default_99 as StatisticGroup }
export { _default_99 as SuiStatisticGroup }

declare const directionalAnimation: {
    browse: ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'browse right': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    drop: ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    fade: ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fade up': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fade down': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fade left': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fade right': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    fly: ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fly up': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fly down': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fly left': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'fly right': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'horizontal flip': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'vertical flip': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    scale: ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'slide up': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'slide down': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'slide left': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'slide right': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'swing up': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'swing down': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'swing left': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    'swing right': ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
    zoom: ((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls)[];
};

declare type DropdownItem = string | {
    text?: string;
    header?: string;
    icon?: string;
    description?: string;
    action?: () => void;
    label?: InstanceType<typeof _default_17>['$props'];
    image?: InstanceType<typeof _default_14>['$props'];
    children?: DropdownItem[];
    divider?: boolean;
};

export declare const Flyout: DefineComponent<    {
fullscreen: {
type: BooleanConstructor;
default: boolean;
};
position: {
type: PropType<"left" | "right" | "top" | "bottom">;
default: string;
};
showCloseIcon: {
type: BooleanConstructor;
default: boolean;
};
visible: {
type: BooleanConstructor;
default: boolean;
};
width: PropType<"very thin" | "thin" | "wide" | "very wide">;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, "update:visible"[], "update:visible", PublicProps, Readonly<ExtractPropTypes<    {
fullscreen: {
type: BooleanConstructor;
default: boolean;
};
position: {
type: PropType<"left" | "right" | "top" | "bottom">;
default: string;
};
showCloseIcon: {
type: BooleanConstructor;
default: boolean;
};
visible: {
type: BooleanConstructor;
default: boolean;
};
width: PropType<"very thin" | "thin" | "wide" | "very wide">;
}>> & {
"onUpdate:visible"?: ((...args: any[]) => any) | undefined;
}, {
visible: boolean;
position: "top" | "bottom" | "left" | "right";
fullscreen: boolean;
showCloseIcon: boolean;
}, {}>;

declare function install(app: App): void;

declare const ListItem: DefineComponent<    {
active: BooleanConstructor;
as: StringConstructor;
children: PropType<any[]>;
content: StringConstructor;
description: StringConstructor;
disabled: BooleanConstructor;
header: StringConstructor;
icon: StringConstructor;
text: StringConstructor;
}, () => JSX.Element, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<    {
active: BooleanConstructor;
as: StringConstructor;
children: PropType<any[]>;
content: StringConstructor;
description: StringConstructor;
disabled: BooleanConstructor;
header: StringConstructor;
icon: StringConstructor;
text: StringConstructor;
}>>, {
active: boolean;
disabled: boolean;
}, {}>;
export { ListItem }
export { ListItem as SuiListItem }

declare type Loading = typeof loadingValues[number];

declare const loadingValues: readonly ["double", "usual double", "elastic"];

declare type MenuItemOption = string | {
    as?: string;
    header?: boolean;
    icon?: string;
    text?: string | VNode[];
    [key: string]: any;
};

declare type OptionItem = string | {
    text: string;
    value: string | number;
    flag?: string;
    image?: {
        avatar?: boolean;
        src?: string;
    };
    icon?: string;
    disabled?: boolean;
};

declare type Position = typeof positionValues[number];

declare const positionValues: readonly ["top right", "top center", "top left", "bottom right", "bottom center", "bottom left", "centered"];

declare type Scrolling = typeof scrollingValues[number] | boolean;

declare const scrollingValues: readonly ["long", "very long", "short", "very short"];

declare type Size = typeof sizeValues[number];

declare const sizeValues: readonly ["mini", "tiny", "small", "medium", "large", "big", "huge", "massive"];

declare const staticAnimation: {
    bounce: (((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls) | undefined)[];
    flash: (((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls) | undefined)[];
    glow: (((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls) | undefined)[];
    jiggle: (((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls) | undefined)[];
    pulse: (((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls) | undefined)[];
    shake: (((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls) | undefined)[];
    tada: (((el: Element, { duration, keyframesOverride, }: {
        duration?: number | undefined;
        keyframesOverride?: MotionKeyframesDefinition | undefined;
    }) => AnimationControls) | undefined)[];
};

declare type ToastActionOptions = {
    close: () => void;
};

declare type ToastOptions = {
    id: number;
    type?: ToastType;
    title?: string;
    message: string;
    displayTime?: number;
    centered?: boolean;
    position?: Position;
    messageStyle?: boolean;
    color?: Color;
    inverted?: boolean;
    attached?: "top" | "bottom" | "left";
    horizontal?: boolean;
    showProgress?: "top" | "bottom";
    showProgressColor?: Color;
    showProgressUp?: boolean;
    actions?: (options: ToastActionOptions) => VNode[];
    actionsProps?: InstanceType<typeof _default_126>['$props'];
};

declare type ToastType = typeof toastTypeValues[number];

declare const toastTypeValues: readonly ["success", "error", "warning", "info"];

export declare const useToast: () => {
    toast: (options: CreateToastOptions) => void;
};

declare type View = typeof viewValues[number];

declare const viewValues: readonly ["decade", "year", "month", "day", "hour"];

export { }
