export declare const isType: (value: any, type: string) => boolean;
declare const _default: import("vue").DefineComponent<{
    /**
     * Json to download
     */
    data: {
        type: ArrayConstructor;
        required: true;
    };
    /**
     * fields inside the Json Object that you want to export
     * if no given, all the properties in the Json are exported
     * Can either be an array or a function
     */
    fields: {
        type: (ArrayConstructor | FunctionConstructor)[];
        required: false;
    };
    /**
     * filename to export, default: data.csv
     */
    name: {
        type: StringConstructor;
        default: string;
    };
    /**
     * Delimiter for the CSV file
     */
    delimiter: {
        type: StringConstructor;
        default: string;
        required: false;
    };
    /**
     * Should the module add SEP={delimiter}
     *
     * Useful for opening file with Excel
     */
    separatorExcel: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * What will be the encoding of the file
     */
    encoding: {
        type: StringConstructor;
        default: string;
    };
    /**
     * Advanced options for Papaparse that is used to export to CSV
     */
    advancedOptions: {
        type: ObjectConstructor;
        default: () => void;
    };
    /**
     * Labels for columns
     *
     * Object or function
     */
    labels: {
        type: (FunctionConstructor | ObjectConstructor)[];
        required: false;
    };
    /**
     * Used only for testing purposes
     */
    testing: {
        required: false;
        default: boolean;
    };
}, unknown, unknown, {
    idName(): string;
    exportableData(): any[] | null;
}, {
    labelsFunctionGenerator(): (item: any) => any;
    fieldsFunctionGenerator(): (item: any) => any;
    cleaningData(): any[];
    generate(): void;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * Json to download
     */
    data: {
        type: ArrayConstructor;
        required: true;
    };
    /**
     * fields inside the Json Object that you want to export
     * if no given, all the properties in the Json are exported
     * Can either be an array or a function
     */
    fields: {
        type: (ArrayConstructor | FunctionConstructor)[];
        required: false;
    };
    /**
     * filename to export, default: data.csv
     */
    name: {
        type: StringConstructor;
        default: string;
    };
    /**
     * Delimiter for the CSV file
     */
    delimiter: {
        type: StringConstructor;
        default: string;
        required: false;
    };
    /**
     * Should the module add SEP={delimiter}
     *
     * Useful for opening file with Excel
     */
    separatorExcel: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * What will be the encoding of the file
     */
    encoding: {
        type: StringConstructor;
        default: string;
    };
    /**
     * Advanced options for Papaparse that is used to export to CSV
     */
    advancedOptions: {
        type: ObjectConstructor;
        default: () => void;
    };
    /**
     * Labels for columns
     *
     * Object or function
     */
    labels: {
        type: (FunctionConstructor | ObjectConstructor)[];
        required: false;
    };
    /**
     * Used only for testing purposes
     */
    testing: {
        required: false;
        default: boolean;
    };
}>>, {
    name: string;
    delimiter: string;
    separatorExcel: boolean;
    encoding: string;
    advancedOptions: Record<string, any>;
    testing: boolean;
}>;
export default _default;
