webpackJsonp([2,32],{114:function(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default={data:function(){return{vertical:"bottom",horizontal:"center",duration:4e3}},methods:{open:function(){this.$refs.snackbar.open()}}},e.exports=t.default},246:function(e,t,a){t=e.exports=a(1)(),t.push([e.id,"",""])},360:function(e,t,a){var o,n;a(567),o=a(114);var d=a(502);n=o=o||{},"object"!=typeof o.default&&"function"!=typeof o.default||(n=o=o.default),"function"==typeof n&&(n=n.options),n.render=d.render,n.staticRenderFns=d.staticRenderFns,n._scopeId="data-v-6eaf2ec0",e.exports=o},502:function(e,t){e.exports={render:function(){var e=this,t=e.$createElement,a=e._self._c||t;return a("page-content",{attrs:{"page-title":"Components - Snackbar"}},[a("docs-component",[a("div",{slot:"description"},[a("p",[e._v("Snackbars contain a single line of text directly related to the operation performed. They may contain a text action, but no icons.")])]),e._v(" "),a("div",{slot:"api"},[a("api-table",{attrs:{name:"md-snackbar"}},[a("md-table",{slot:"properties"},[a("md-table-header",[a("md-table-row",[a("md-table-head",[e._v("Name")]),e._v(" "),a("md-table-head",[e._v("Type")]),e._v(" "),a("md-table-head",[e._v("Description")])],1)],1),e._v(" "),a("md-table-body",[a("md-table-row",[a("md-table-cell",[e._v("md-position")]),e._v(" "),a("md-table-cell",[a("code",[e._v("String")])]),e._v(" "),a("md-table-cell",[e._v("Specify which vertical and horizontal position the snackbar will take. Accepts "),a("code",[e._v("top left")]),e._v("|"),a("code",[e._v("top center")]),e._v("|"),a("code",[e._v("right center")]),e._v("|"),a("code",[e._v("bottom left")]),e._v("|"),a("code",[e._v("bottom center")]),e._v("|"),a("code",[e._v("bottom right")]),e._v(". Default: "),a("code",[e._v("bottom center")])])],1),e._v(" "),a("md-table-row",[a("md-table-cell",[e._v("md-duration")]),e._v(" "),a("md-table-cell",[a("code",[e._v("Number")])]),e._v(" "),a("md-table-cell",[e._v("The duration visibility in miliseconds. Default: "),a("code",[e._v("4000")])])],1)],1)],1),e._v(" "),a("md-table",{slot:"events"},[a("md-table-header",[a("md-table-row",[a("md-table-head",[e._v("Name")]),e._v(" "),a("md-table-head",[e._v("Value")]),e._v(" "),a("md-table-head",[e._v("Description")])],1)],1),e._v(" "),a("md-table-body",[a("md-table-row",[a("md-table-cell",[e._v("open")]),e._v(" "),a("md-table-cell",[e._v("None")]),e._v(" "),a("md-table-cell",[e._v("Triggered when the snackbar open.")])],1),e._v(" "),a("md-table-row",[a("md-table-cell",[e._v("close")]),e._v(" "),a("md-table-cell",[e._v("None")]),e._v(" "),a("md-table-cell",[e._v("Triggered when the snackbar closes.")])],1)],1)],1),e._v(" "),a("md-table",{slot:"methods"},[a("md-table-header",[a("md-table-row",[a("md-table-head",[e._v("Name")]),e._v(" "),a("md-table-head",[e._v("Description")])],1)],1),e._v(" "),a("md-table-body",[a("md-table-row",[a("md-table-cell",[e._v("open")]),e._v(" "),a("md-table-cell",[e._v("Opens the Snackbar.")])],1),e._v(" "),a("md-table-row",[a("md-table-cell",[e._v("close")]),e._v(" "),a("md-table-cell",[e._v("Closes the Snackbar.")])],1)],1)],1)],1)],1),e._v(" "),a("div",{slot:"example"},[a("example-box",{attrs:{"card-title":"Default"}},[a("div",{slot:"demo"},[a("form",{attrs:{novalidate:""},on:{submit:function(t){t.stopPropagation(),t.preventDefault(),e.open(t)}}},[a("div",[a("div",{staticClass:"md-body-2"},[e._v("Vertical")]),e._v(" "),a("md-radio",{directives:[{name:"model",rawName:"v-model",value:e.vertical,expression:"vertical"}],attrs:{id:"top",name:"snackbar-vertical","md-value":"top"},domProps:{value:e.vertical},on:{input:function(t){e.vertical=t}}},[e._v("top")]),e._v(" "),a("md-radio",{directives:[{name:"model",rawName:"v-model",value:e.vertical,expression:"vertical"}],attrs:{id:"bottom",name:"snackbar-vertical","md-value":"bottom"},domProps:{value:e.vertical},on:{input:function(t){e.vertical=t}}},[e._v("bottom")])],1),e._v(" "),a("div",[a("div",{staticClass:"md-body-2"},[e._v("Horizontal")]),e._v(" "),a("md-radio",{directives:[{name:"model",rawName:"v-model",value:e.horizontal,expression:"horizontal"}],attrs:{id:"left",name:"snackbar-horizontal","md-value":"left"},domProps:{value:e.horizontal},on:{input:function(t){e.horizontal=t}}},[e._v("left")]),e._v(" "),a("md-radio",{directives:[{name:"model",rawName:"v-model",value:e.horizontal,expression:"horizontal"}],attrs:{id:"center",name:"snackbar-horizontal","md-value":"center"},domProps:{value:e.horizontal},on:{input:function(t){e.horizontal=t}}},[e._v("center")]),e._v(" "),a("md-radio",{directives:[{name:"model",rawName:"v-model",value:e.horizontal,expression:"horizontal"}],attrs:{id:"right",name:"snackbar-horizontal","md-value":"right"},domProps:{value:e.horizontal},on:{input:function(t){e.horizontal=t}}},[e._v("right")])],1),e._v(" "),a("div",[a("div",{staticClass:"md-body-2"},[e._v("Delay")]),e._v(" "),a("md-input-container",[a("md-input",{directives:[{name:"model",rawName:"v-model",value:e.duration,expression:"duration"}],attrs:{type:"number"},domProps:{value:e.duration},on:{input:function(t){e.duration=e._n(t)},blur:function(t){e.$forceUpdate()}}})],1)],1),e._v(" "),a("md-button",{staticClass:"md-primary md-raised",attrs:{type:"submit"}},[e._v("Open Snackbar")]),e._v(" "),a("md-snackbar",{ref:"snackbar",attrs:{"md-position":e.vertical+" "+e.horizontal,"md-duration":e.duration}},[a("span",[e._v("Connection timeout. Showing limited messages.")]),e._v(" "),a("md-button",{staticClass:"md-accent",attrs:{"md-theme":"light-blue"},on:{click:function(t){e.$refs.snackbar.close()}}},[e._v("Retry")])],1)],1)]),e._v(" "),a("div",{slot:"code"},[a("code-block",{attrs:{lang:"xml"}},[e._v('\n            <form novalidate @submit.stop.prevent="open">\n              <div>\n                <div class="md-body-2">Vertical</div>\n                <md-radio v-model="vertical" id="top" name="snackbar-vertical" md-value="top">top</md-radio>\n                <md-radio v-model="vertical" id="bottom" name="snackbar-vertical" md-value="bottom">bottom</md-radio>\n              </div>\n\n              <div>\n                <div class="md-body-2">Horizontal</div>\n                <md-radio v-model="horizontal" id="left" name="snackbar-horizontal" md-value="left">left</md-radio>\n                <md-radio v-model="horizontal" id="center" name="snackbar-horizontal" md-value="center">center</md-radio>\n                <md-radio v-model="horizontal" id="right" name="snackbar-horizontal" md-value="right">right</md-radio>\n              </div>\n\n              <div>\n                <div class="md-body-2">Delay</div>\n\n                <md-input-container>\n                  <md-input type="number" v-model="duration"></md-input>\n                </md-input-container>\n              </div>\n\n              <md-button type="submit" class="md-primary md-raised">Open Snackbar</md-button>\n\n              <md-snackbar :md-position="vertical + \' \' + horizontal" ref="snackbar" :md-duration="duration">\n                <span>Connection timeout. Showing limited messages.</span>\n                <md-button class="md-accent" md-theme="light-blue" @click="$refs.snackbar.close()">Retry</md-button>\n              </md-snackbar>\n            </form>\n          ')]),e._v(" "),a("code-block",{attrs:{lang:"javacript"}},[e._v("\n            export default {\n              data: () => ({\n                vertical: 'bottom',\n                horizontal: 'center',\n                duration: 4000\n              }),\n              methods: {\n                open() {\n                  this.$refs.snackbar.open();\n                }\n              }\n            };\n          ")])],1)])],1)]),e._v(" "),a("md-button",{staticClass:"md-fab md-fab-bottom-right"},[a("md-icon",[e._v("add")])],1)],1)},staticRenderFns:[]}},567:function(e,t,a){var o=a(246);"string"==typeof o&&(o=[[e.id,o,""]]);a(2)(o,{});o.locals&&(e.exports=o.locals)}});